package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Grupo;
import com.ejie.y41a.model.Organismo;

/**
 * * OrganismoDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface OrganismoDao {

	/**
	 * Inserts a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo add(Organismo organismo);

	/**
	 * Updates a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo update(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return Organismo
	 */
	Organismo find(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	public Organismo findOrganismoByCodOrg(Organismo organismo);

	/**
	 * Finds a single row in the Organismo KNet table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	Organismo findOrganismoKnet(Organismo organismo);

	/**
	 * Finds a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Pagination
	 * @return Organismo
	 */
	Organismo findOrganismo(Organismo organismo);

	/**
	 * Deletes a single row in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return
	 */
	void remove(Organismo organismo);

	/**
	 * Finds a List of rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Organismo> findAll(Organismo organismo, Pagination pagination);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	Long findAllCount(Organismo organismo);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLike(Organismo organismo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismoKnet(Organismo organismo,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table de KontsumoNet.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoKnetCount(Organismo organismo, Boolean startsWith);

	/**
	 * Finds rows in the Organismo table using like.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Organismo> findAllLikeOrganismo(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Organismo table.
	 * 
	 * @param organismo
	 *            Organismo
	 * @param codOrgConectado
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeOrganismoCount(Organismo organismo, String codOrgConectado,
			Boolean startsWith);

	/**
	 * Obtener los grupos a los que pertenece un organismo
	 * 
	 * @param organismo
	 *            Organismo
	 * @return List
	 */
	List<Grupo> obtenerGruposOrganismo(Organismo organismo);

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Crear Solicitudes
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	List<Organismo> findAllOrganismoSolicitudes(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith);

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Crear Solicitudes
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	Long findAllOrganismoSolicitudesCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith);

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Solicitudes
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	List<Organismo> findAllOrganismoTraslado(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith);

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Traslado Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	Long findAllOrganismoTrasladoCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith);

	/**
	 * Busca los organismos que estén tanto en la tabla de Organismos como en la
	 * vista de Organismos Inhibicion Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param pagination
	 *            Pagination paginación
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return List<Organismo> lista de organismos que cumplen el filtro
	 */
	List<Organismo> findAllOrganismoInhibicion(Organismo organismo,
			String codOrgConectado, Pagination pagination, Boolean startsWith);

	/**
	 * Cuenta los organismos que estén tanto en la tabla de Organismos como en
	 * la vista de Organismos Inhibicion Consumo
	 * 
	 * @param organismo
	 *            Organismo filtro de organismo
	 * @param codOrgConectado
	 *            String código del usuario conectado
	 * @param startsWith
	 *            Boolean indica si hay que buscar textos que empiecen por el
	 *            filtro seleccionado
	 * @return Long número de resultados
	 */
	Long findAllOrganismoInhibicionCount(Organismo organismo,
			String codOrgConectado, Boolean startsWith);
}
