package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Ooee;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * OoeeDaoImpl generated by UDA, 23-nov-2016 12:18:26.
 * 
 *  
 */

@Repository
@Transactional
public class OoeeDaoImpl implements OoeeDao {
	private JdbcTemplate jdbcTemplate;
	private RowMapper<Ooee> rwMap = new RowMapper<Ooee>() {
		public Ooee mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Ooee(resultSet.getString("OECODIGO"),
					resultSet.getString("OETESI"),
					resultSet.getString("OENOREP"),
					resultSet.getString("OENIREP"),
					resultSet.getString("OENOCARE"),
					resultSet.getString("OENOAPP"),
					resultSet.getString("OENOAPS"),
					resultSet.getDate("OEFEAD"), resultSet.getString("OECOJA"),
					resultSet.getDate("OEFEADFIN"),
					resultSet.getDate("OEFECALTA"),
					resultSet.getString("OEUSUALTA"),
					resultSet.getDate("OEFECMOD"),
					resultSet.getString("OEUSUMOD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Ooee table.
	 * 
	 * @param ooee
	 *            Pagination
	 * @return Ooee
	 */
	@Transactional(readOnly = true)
	public Ooee find(Ooee ooee) {
		String query = "SELECT t1.OECODIGO OECODIGO, t1.OETESI OETESI, t1.OENOREP OENOREP, t1.OENIREP OENIREP, t1.OENOCARE OENOCARE, t1.OENOAPP OENOAPP, t1.OENOAPS OENOAPS, t1.OEFEAD OEFEAD, t1.OECOJA OECOJA, t1.OEFEADFIN OEFEADFIN, t1.OEFECALTA OEFECALTA, t1.OEUSUALTA OEUSUALTA, t1.OEFECMOD OEFECMOD, t2.USUARIOXLNET OEUSUMOD FROM OOEE t1,CENSO_MONITOR t2 WHERE t1.OEUSUMOD=t2.MOCODIGO(+) AND t1.OECODIGO = ?  ";

		List<Ooee> ooeeList = this.jdbcTemplate.query(query, this.rwMap,
				ooee.getOecodigo());
		return (Ooee) DataAccessUtils.uniqueResult(ooeeList);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	private RowMapper<Ooee> rwMapBusqueda = new RowMapper<Ooee>() {
		public Ooee mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			Ooee ooee = new Ooee(resultSet.getString("OECODIGO"),
					resultSet.getString("OETESI"),
					resultSet.getString("OENOREP"),
					resultSet.getString("OENIREP"),
					resultSet.getString("OENOCARE"),
					resultSet.getString("OENOAPP"),
					resultSet.getString("OENOAPS"),
					resultSet.getDate("OEFEAD"), resultSet.getString("OECOJA"),
					resultSet.getDate("OEFEADFIN"),
					resultSet.getDate("OEFECALTA"),
					resultSet.getString("OEUSUALTA"),
					resultSet.getDate("OEFECMOD"),
					resultSet.getString("OEUSUMOD"));
			Organismo organismo = new Organismo();
			organismo.setNombreEs(resultSet.getString("OrganismoNOMBREES"));
			organismo.setNombreEu(resultSet.getString("OrganismoNOMBREEU"));
			organismo.setNombreMunicipio(resultSet
					.getString("OrganismoNOMBREMUNICIPIO"));
			ooee.setOrganismo(organismo);
			ooee.setOeadherido(resultSet.getString("OEADHERIDO"));
			return ooee;
		}
	};

	/**
	 * Finds a List of rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Ooee> findAllBusqueda(Ooee ooee, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT distinct t1.OECODIGO OECODIGO,t1.OETESI OETESI,t1.OENOREP OENOREP,t1.OENIREP OENIREP,t1.OENOCARE OENOCARE,t1.OENOAPP OENOAPP,t1.OENOAPS OENOAPS,t1.OEFEAD OEFEAD,t1.OECOJA OECOJA,t1.OEFEADFIN OEFEADFIN,t1.OEFECALTA OEFECALTA,t1.OEUSUALTA OEUSUALTA,t1.OEFECMOD OEFECMOD,t1.OEUSUMOD OEUSUMOD ");
		query.append(" , t2.NOMBRE_ES OrganismoNOMBREES, t2.NOMBRE_EU OrganismoNOMBREEU, t2.NOMBRE_MUNICIPIO OrganismoNOMBREMUNICIPIO, CASE WHEN t1.OEFEAD IS NULL OR t1.OEFEAD>SYSDATE THEN 'N' ");
		query.append(" WHEN t1.OEFEAD IS NOT NULL AND t1.OEFEAD<SYSDATE AND t1.OEFEADFIN IS NOT NULL AND t1.OEFEADFIN<SYSDATE THEN 'B' ");
		query.append(" ELSE 'A' END oeadherido ");
		query.append(" FROM OOEE t1, ORGANISMO t2, OESE t3, OETA1 t4 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.OECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.OECODIGO=t3.M6COOE(+)  ");
		where.append(" AND t1.OECODIGO=t4.M5COOE(+) ");

		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuilder(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<Ooee>) this.jdbcTemplate.query(query.toString(),
				this.rwMapBusqueda, params.toArray());
	}

	/**
	 * Counts rows in the Ooee table.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllBusquedaCount(Ooee ooee) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(distinct oecodigo)  FROM OOEE t1, ORGANISMO t2, OESE t3, OETA1 t4  ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ooee);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.OECODIGO=t2.COD_ORG(+) ");
		where.append(" AND t1.OECODIGO=t3.M6COOE(+)  ");
		where.append(" AND t1.OECODIGO=t4.M5COOE(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ooee entity
	 * 
	 * @param ooee
	 *            Ooee Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
	private Map<String, ?> getWhereMap(Ooee ooee) {

		StringBuilder where = new StringBuilder(OoeeDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ooee != null && !Y41aUtils.esNullOCadenaVacia(ooee.getOecodigo())) {
			where.append(" AND TRANSLATE(UPPER(t1.OECODIGO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ ooee.getOecodigo().toUpperCase().replaceAll("Á", "A")
							.replaceAll("É", "E").replaceAll("Í", "I")
							.replaceAll("Ó", "O").replaceAll("Ú", "U") + "%");
			where.append(" AND t1.OECODIGO IS NOT NULL");
		}
		if (ooee != null && !Y41aUtils.esNullOCadenaVacia(ooee.getOetesi())) {
			where.append(" AND TRANSLATE(UPPER(t1.OETESI),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			params.add("%"
					+ ooee.getOetesi().toUpperCase().replaceAll("Á", "A")
							.replaceAll("É", "E").replaceAll("Í", "I")
							.replaceAll("Ó", "O").replaceAll("Ú", "U") + "%");
			where.append(" AND t1.OETESI IS NOT NULL");
		}
		// Organismo
		if (ooee != null && ooee.getOrganismo() != null) {
			if (!Y41aUtils
					.esNullOCadenaVacia(ooee.getOrganismo().getNombreEs())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_ES),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ ooee.getOrganismo().getNombreEs().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
				where.append(" AND t2.NOMBRE_ES IS NOT NULL");
			}
			if (!Y41aUtils
					.esNullOCadenaVacia(ooee.getOrganismo().getNombreEu())) {
				where.append(" AND TRANSLATE(UPPER(t2.NOMBRE_EU),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
				params.add("%"
						+ ooee.getOrganismo().getNombreEu().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
				where.append(" AND t2.NOMBRE_EU IS NOT NULL");
			}
			if (!Y41aUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraProvinciaId())) {
				where.append(" AND t2.NORA_PROVINCIA_ID = ?");
				params.add(ooee.getOrganismo().getNoraProvinciaId());
			}
			if (!Y41aUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraMunicipioId())) {
				where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
				params.add(ooee.getOrganismo().getNoraMunicipioId());
			}
			if (!Y41aUtils.esNullOCadenaVacia(ooee.getOrganismo()
					.getNoraLocalidadId())) {
				where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
				params.add(ooee.getOrganismo().getNoraLocalidadId());
			}
		}
		// Sector
		if (ooee != null && !Y41aUtils.esNullOCadenaVacia(ooee.getOesecodigo())) {
			where.append(" AND t3.M6COSE = ? ");
			params.add(ooee.getOesecodigo());
		}
		// Territorio de actuacion
		if (ooee != null
				&& (!Y41aUtils.esNullOCadenaVacia(ooee.getOeThActAraba())
						|| !Y41aUtils.esNullOCadenaVacia(ooee
								.getOeThActBizkaia()) || !Y41aUtils
						.esNullOCadenaVacia(ooee.getOeThActGipuzkoa()))) {
			where.append(" AND ( ");
			if (ooee != null
					&& !Y41aUtils.esNullOCadenaVacia(ooee.getOeThActAraba())) {
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActAraba());
			}
			if (ooee != null
					&& !Y41aUtils.esNullOCadenaVacia(ooee.getOeThActBizkaia())) {
				if (ooee != null
						&& !Y41aUtils
								.esNullOCadenaVacia(ooee.getOeThActAraba())) {
					where.append(" OR ");
				}
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActBizkaia());
			}
			if (ooee != null
					&& !Y41aUtils.esNullOCadenaVacia(ooee.getOeThActGipuzkoa())) {
				if (ooee != null
						&& (!Y41aUtils.esNullOCadenaVacia(ooee
								.getOeThActAraba()) || !Y41aUtils
								.esNullOCadenaVacia(ooee.getOeThActBizkaia()))) {
					where.append(" OR ");
				}
				where.append(" t4.M5COTA1 = ? ");
				params.add(ooee.getOeThActGipuzkoa());
			}
			where.append(" ) ");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - GeneraciÃ³n de cÃ³digo de UDA
}
