package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.ConsultaDetalle;

/**
 * * NumConsultaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */
@SuppressWarnings(value = { "deprecation" })
@Repository
@Transactional
public class NumConsultaDaoImpl implements NumConsultaDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Num_Consulta table.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * @return ConsultaDetalle
	 */
	public ConsultaDetalle add(ConsultaDetalle consultaDetalle) {

		String query = "INSERT INTO NUM_CONSULTA(COCOOR,CONRANRG,CONRREG) "
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, consultaDetalle.getCodOrg(),
				consultaDetalle.getConranrg(), consultaDetalle.getConrreg());
		return consultaDetalle;
	}

	/**
	 * Finds a single row in the Num_Consulta table.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * @return ConsultaDetalle
	 */
	@Transactional(readOnly = true)
	public ConsultaDetalle findNumConsulta(ConsultaDetalle consultaDetalle) {
		String query = "SELECT NVL(MAX(ABS(CONRREG)),0)+1 CONRREG FROM NUM_CONSULTA WHERE COCOOR = ? AND CONRANRG = ? ";

		return (ConsultaDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<ConsultaDetalle>() {
					public ConsultaDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new ConsultaDetalle(null, null, resultSet
								.getInt("CONRREG"));
					}
				}, consultaDetalle.getCodOrg(), consultaDetalle.getConranrg());
	}

}
