package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Envio;
import com.ejie.y41a.model.Item;

/**
 * * ItemDaoImpl generated by UDA, 13-ene-2012 12:26:47.
 * 
 *  
 */

@Repository()
@Transactional()
public class ItemDaoImpl implements ItemDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Item> rwMap = new RowMapper<Item>() {
		public Item mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Item(resultSet.getString("ITEMREF"), new Envio(
					resultSet.getString("ENVIOID"), null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null),
					resultSet.getString("NOMBRE"),
					resultSet.getString("NOMBRELOCALIZACION"),
					resultSet.getString("TELEFONO"),
					resultSet.getString("EMAIL"),
					resultSet.getString("SELECCIONADO"),
					resultSet.getDate("FECHAMAILINGENVIO"),
					resultSet.getString("MAILINGRESPONSECODE"),
					resultSet.getDate("FECHAMAILINGRECEPCION"),
					resultSet.getString("XMLCAMPO1"),
					resultSet.getString("XMLCAMPO2"),
					resultSet.getString("XMLCAMPO3"),
					resultSet.getString("XMLCAMPO4"),
					resultSet.getString("XMLCAMPO5"),
					resultSet.getString("XMLCAMPO6"),
					resultSet.getString("XMLCAMPO7"),
					resultSet.getString("XMLCAMPO8"),
					resultSet.getString("XMLCAMPO9"),
					resultSet.getString("XMLCAMPO10"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Item table.
	 * 
	 * @param item
	 *            Pagination
	 * @return Item
	 */
	public Item add(Item item) {

		String query = "INSERT INTO ITEM( ITEM_REF,ENVIO_ID,NOMBRE,NOMBRE_LOCALIZACION,TELEFONO,EMAIL,SELECCIONADO,FECHA_MAILING_ENVIO,MAILING_RESPONSE_CODE,FECHA_MAILING_RECEPCION,XMLCAMPO1,XMLCAMPO2,XMLCAMPO3,XMLCAMPO4,XMLCAMPO5,XMLCAMPO6,XMLCAMPO7,XMLCAMPO8,XMLCAMPO9,XMLCAMPO10)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object EnvioEnvioIdAux = null;
		if (item.getEnvio() != null && item.getEnvio().getEnvioId() != null) {
			EnvioEnvioIdAux = item.getEnvio().getEnvioId();
		}
		this.jdbcTemplate.update(query, item.getItemRef(), EnvioEnvioIdAux,
				item.getNombre(), item.getNombreLocalizacion(),
				item.getTelefono(), item.getEmail(), item.getSeleccionado(),
				item.getFechaMailingEnvio(), item.getMailingResponseCode(),
				item.getFechaMailingRecepcion(), item.getXmlcampo1(),
				item.getXmlcampo2(), item.getXmlcampo3(), item.getXmlcampo4(),
				item.getXmlcampo5(), item.getXmlcampo6(), item.getXmlcampo7(),
				item.getXmlcampo8(), item.getXmlcampo9(), item.getXmlcampo10());
		return item;
	}

	/**
	 * Updates a single row in the Item table.
	 * 
	 * @param item
	 *            Pagination
	 * @return Item
	 */
	public Item update(Item item) {
		String query = "UPDATE ITEM SET NOMBRE=?,NOMBRE_LOCALIZACION=?,TELEFONO=?,EMAIL=?,SELECCIONADO=?,FECHA_MAILING_ENVIO=?,MAILING_RESPONSE_CODE=?,FECHA_MAILING_RECEPCION=?,XMLCAMPO1=?,XMLCAMPO2=?,XMLCAMPO3=?,XMLCAMPO4=?,XMLCAMPO5=?,XMLCAMPO6=?,XMLCAMPO7=?,XMLCAMPO8=?,XMLCAMPO9=?,XMLCAMPO10=? WHERE ITEM_REF=? AND ENVIO_ID=?";
		Object EnvioEnvioIdAux = null;
		if (item.getEnvio() != null && item.getEnvio().getEnvioId() != null) {
			EnvioEnvioIdAux = item.getEnvio().getEnvioId();
		}
		this.jdbcTemplate.update(query, item.getNombre(),
				item.getNombreLocalizacion(), item.getTelefono(),
				item.getEmail(), item.getSeleccionado(),
				item.getFechaMailingEnvio(), item.getMailingResponseCode(),
				item.getFechaMailingRecepcion(), item.getXmlcampo1(),
				item.getXmlcampo2(), item.getXmlcampo3(), item.getXmlcampo4(),
				item.getXmlcampo5(), item.getXmlcampo6(), item.getXmlcampo7(),
				item.getXmlcampo8(), item.getXmlcampo9(), item.getXmlcampo10(),
				item.getItemRef(), EnvioEnvioIdAux);
		return item;
	}

	/**
	 * Finds a single row in the Item table.
	 * 
	 * @param item
	 *            Pagination
	 * @return Item
	 */
	@Transactional(readOnly = true)
	public Item find(Item item) {
		try {
			String query = "SELECT t1.ITEM_REF ITEMREF, t1.ENVIO_ID ENVIOID, t1.NOMBRE NOMBRE, t1.NOMBRE_LOCALIZACION NOMBRELOCALIZACION, t1.TELEFONO TELEFONO, t1.EMAIL EMAIL, t1.SELECCIONADO SELECCIONADO, t1.FECHA_MAILING_ENVIO FECHAMAILINGENVIO, t1.MAILING_RESPONSE_CODE MAILINGRESPONSECODE, t1.FECHA_MAILING_RECEPCION FECHAMAILINGRECEPCION, t1.XMLCAMPO1 XMLCAMPO1, t1.XMLCAMPO2 XMLCAMPO2, t1.XMLCAMPO3 XMLCAMPO3, t1.XMLCAMPO4 XMLCAMPO4, t1.XMLCAMPO5 XMLCAMPO5, t1.XMLCAMPO6 XMLCAMPO6, t1.XMLCAMPO7 XMLCAMPO7, t1.XMLCAMPO8 XMLCAMPO8, t1.XMLCAMPO9 XMLCAMPO9, t1.XMLCAMPO10 XMLCAMPO10 "
					+ "FROM ITEM t1  "
					+ "WHERE t1.ITEM_REF = ?   AND t1.ENVIO_ID = ?    ";
			return (Item) this.jdbcTemplate.queryForObject(query, this.rwMap,
					item.getItemRef(), item.getEnvio().getEnvioId());
		} catch (EmptyResultDataAccessException e) {
			return new Item();
		}
	}

	/**
	 * JavaMail filtered Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Item> findLimpiarItems(Item item) {
		StringBuffer where = new StringBuffer(Y41aConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(Y41aConstantes.NUM_3000);
		query.append("SELECT t1.ITEM_REF ITEMREF, t1.ENVIO_ID ENVIOID, t1.NOMBRE NOMBRE, t1.NOMBRE_LOCALIZACION NOMBRELOCALIZACION, t1.TELEFONO TELEFONO, t1.EMAIL EMAIL, t1.SELECCIONADO SELECCIONADO, t1.FECHA_MAILING_ENVIO FECHAMAILINGENVIO, t1.MAILING_RESPONSE_CODE MAILINGRESPONSECODE, t1.FECHA_MAILING_RECEPCION FECHAMAILINGRECEPCION, t1.XMLCAMPO1 XMLCAMPO1, t1.XMLCAMPO2 XMLCAMPO2, t1.XMLCAMPO3 XMLCAMPO3, t1.XMLCAMPO4 XMLCAMPO4, t1.XMLCAMPO5 XMLCAMPO5, t1.XMLCAMPO6 XMLCAMPO6, t1.XMLCAMPO7 XMLCAMPO7, t1.XMLCAMPO8 XMLCAMPO8, t1.XMLCAMPO9 XMLCAMPO9, t1.XMLCAMPO10 XMLCAMPO10 ");
		query.append(" FROM ITEM t1 ");

		/*
		 * SELECT t1.* FROM ITEM T1 WHERE T1.FECHA_MAILING_ENVIO IS NULL AND
		 * T1.ENVIO_ID=''
		 */
		where.append(" WHERE 1 = 1 ");
		where.append(" AND T1.FECHA_MAILING_ENVIO IS NULL ");

		if (item != null && item.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(item.getEnvio().getEnvioId());
		}

		query.append(where);

		RowMapper<Item> rwMap = new RowMapper<Item>() {
			public Item mapRow(ResultSet resultSet, int rowNum)
					throws SQLException {

				return new Item(resultSet.getString("ITEMREF"), new Envio(
						resultSet.getString("ENVIOID"), null, null, null, null,
						null, null, null, null, null, null, null, null, null,
						null, null, null, null, null, null, null, null),
						resultSet.getString("NOMBRE"),
						resultSet.getString("NOMBRELOCALIZACION"),
						resultSet.getString("TELEFONO"),
						resultSet.getString("EMAIL"),
						resultSet.getString("SELECCIONADO"),
						resultSet.getDate("FECHAMAILINGENVIO"),
						resultSet.getString("MAILINGRESPONSECODE"),
						resultSet.getDate("FECHAMAILINGRECEPCION"),
						resultSet.getString("XMLCAMPO1"),
						resultSet.getString("XMLCAMPO2"),
						resultSet.getString("XMLCAMPO3"),
						resultSet.getString("XMLCAMPO4"),
						resultSet.getString("XMLCAMPO5"),
						resultSet.getString("XMLCAMPO6"),
						resultSet.getString("XMLCAMPO7"),
						resultSet.getString("XMLCAMPO8"),
						resultSet.getString("XMLCAMPO9"),
						resultSet.getString("XMLCAMPO10"));

			}
		};

		return (List<Item>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());

	}

	/**
	 * Removes a single row in the Item table.
	 * 
	 * @param item
	 *            Pagination
	 * @return
	 */
	public void remove(Item item) {
		String query = "DELETE  FROM ITEM WHERE ITEM_REF=? AND ENVIO_ID=?";
		this.jdbcTemplate.update(query, item.getItemRef(), item.getEnvio()
				.getEnvioId());
	}

	/**
	 * Removes a single row in the Item table.
	 * 
	 * @param item
	 *            Pagination
	 * @return
	 */
	public void removeItemsEnvio(Item item) {
		String query = "DELETE  FROM ITEM WHERE ENVIO_ID=?";
		this.jdbcTemplate.update(query, item.getEnvio().getEnvioId());
	}

	/**
	 * Finds a List of rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Item> findAll(Item item, Pagination pagination) {
		StringBuffer where = new StringBuffer(Y41aConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ITEM_REF ITEMREF,t1.ENVIO_ID ENVIOID,t1.NOMBRE NOMBRE,t1.NOMBRE_LOCALIZACION NOMBRELOCALIZACION,t1.TELEFONO TELEFONO,t1.EMAIL EMAIL,t1.SELECCIONADO SELECCIONADO,t1.FECHA_MAILING_ENVIO FECHAMAILINGENVIO,t1.MAILING_RESPONSE_CODE MAILINGRESPONSECODE,t1.FECHA_MAILING_RECEPCION FECHAMAILINGRECEPCION,t1.XMLCAMPO1 XMLCAMPO1,t1.XMLCAMPO2 XMLCAMPO2,t1.XMLCAMPO3 XMLCAMPO3,t1.XMLCAMPO4 XMLCAMPO4,t1.XMLCAMPO5 XMLCAMPO5,t1.XMLCAMPO6 XMLCAMPO6,t1.XMLCAMPO7 XMLCAMPO7,t1.XMLCAMPO8 XMLCAMPO8,t1.XMLCAMPO9 XMLCAMPO9,t1.XMLCAMPO10 XMLCAMPO10 "
						+ "FROM ITEM t1 ");

		if (item != null && item.getItemRef() != null) {
			where.append(" AND t1.ITEM_REF = ?");
			params.add(item.getItemRef());
		}
		if (item != null && item.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(item.getEnvio().getEnvioId());
		}
		if (item != null && item.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(item.getNombre());
		}
		if (item != null && item.getNombreLocalizacion() != null) {
			where.append(" AND t1.NOMBRE_LOCALIZACION = ?");
			params.add(item.getNombreLocalizacion());
		}
		if (item != null && item.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(item.getTelefono());
		}
		if (item != null && item.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(item.getEmail());
		}
		if (item != null && item.getSeleccionado() != null) {
			where.append(" AND t1.SELECCIONADO = ?");
			params.add(item.getSeleccionado());
		}
		if (item != null && item.getFechaMailingEnvio() != null) {
			where.append(" AND t1.FECHA_MAILING_ENVIO = ?");
			params.add(item.getFechaMailingEnvio());
		}
		if (item != null && item.getMailingResponseCode() != null) {
			where.append(" AND t1.MAILING_RESPONSE_CODE = ?");
			params.add(item.getMailingResponseCode());
		}
		if (item != null && item.getFechaMailingRecepcion() != null) {
			where.append(" AND t1.FECHA_MAILING_RECEPCION = ?");
			params.add(item.getFechaMailingRecepcion());
		}
		if (item != null && item.getXmlcampo1() != null) {
			where.append(" AND t1.XMLCAMPO1 = ?");
			params.add(item.getXmlcampo1());
		}
		if (item != null && item.getXmlcampo2() != null) {
			where.append(" AND t1.XMLCAMPO2 = ?");
			params.add(item.getXmlcampo2());
		}
		if (item != null && item.getXmlcampo3() != null) {
			where.append(" AND t1.XMLCAMPO3 = ?");
			params.add(item.getXmlcampo3());
		}
		if (item != null && item.getXmlcampo4() != null) {
			where.append(" AND t1.XMLCAMPO4 = ?");
			params.add(item.getXmlcampo4());
		}
		if (item != null && item.getXmlcampo5() != null) {
			where.append(" AND t1.XMLCAMPO5 = ?");
			params.add(item.getXmlcampo5());
		}
		if (item != null && item.getXmlcampo6() != null) {
			where.append(" AND t1.XMLCAMPO6 = ?");
			params.add(item.getXmlcampo6());
		}
		if (item != null && item.getXmlcampo7() != null) {
			where.append(" AND t1.XMLCAMPO7 = ?");
			params.add(item.getXmlcampo7());
		}
		if (item != null && item.getXmlcampo8() != null) {
			where.append(" AND t1.XMLCAMPO8 = ?");
			params.add(item.getXmlcampo8());
		}
		if (item != null && item.getXmlcampo9() != null) {
			where.append(" AND t1.XMLCAMPO9 = ?");
			params.add(item.getXmlcampo9());
		}
		if (item != null && item.getXmlcampo10() != null) {
			where.append(" AND t1.XMLCAMPO10 = ?");
			params.add(item.getXmlcampo10());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Y41aConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Item>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Item item) {

		StringBuffer where = new StringBuffer(Y41aConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ITEM t1  ");
		if (item != null && item.getItemRef() != null) {
			where.append(" AND t1.ITEM_REF = ?");
			params.add(item.getItemRef());
		}
		if (item != null && item.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(item.getEnvio().getEnvioId());
		}
		if (item != null && item.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(item.getNombre());
		}
		if (item != null && item.getNombreLocalizacion() != null) {
			where.append(" AND t1.NOMBRE_LOCALIZACION = ?");
			params.add(item.getNombreLocalizacion());
		}
		if (item != null && item.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(item.getTelefono());
		}
		if (item != null && item.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(item.getEmail());
		}
		if (item != null && item.getSeleccionado() != null) {
			where.append(" AND t1.SELECCIONADO = ?");
			params.add(item.getSeleccionado());
		}
		if (item != null && item.getFechaMailingEnvio() != null) {
			where.append(" AND t1.FECHA_MAILING_ENVIO = ?");
			params.add(item.getFechaMailingEnvio());
		}
		if (item != null && item.getMailingResponseCode() != null) {
			where.append(" AND t1.MAILING_RESPONSE_CODE = ?");
			params.add(item.getMailingResponseCode());
		}
		if (item != null && item.getFechaMailingRecepcion() != null) {
			where.append(" AND t1.FECHA_MAILING_RECEPCION = ?");
			params.add(item.getFechaMailingRecepcion());
		}
		if (item != null && item.getXmlcampo1() != null) {
			where.append(" AND t1.XMLCAMPO1 = ?");
			params.add(item.getXmlcampo1());
		}
		if (item != null && item.getXmlcampo2() != null) {
			where.append(" AND t1.XMLCAMPO2 = ?");
			params.add(item.getXmlcampo2());
		}
		if (item != null && item.getXmlcampo3() != null) {
			where.append(" AND t1.XMLCAMPO3 = ?");
			params.add(item.getXmlcampo3());
		}
		if (item != null && item.getXmlcampo4() != null) {
			where.append(" AND t1.XMLCAMPO4 = ?");
			params.add(item.getXmlcampo4());
		}
		if (item != null && item.getXmlcampo5() != null) {
			where.append(" AND t1.XMLCAMPO5 = ?");
			params.add(item.getXmlcampo5());
		}
		if (item != null && item.getXmlcampo6() != null) {
			where.append(" AND t1.XMLCAMPO6 = ?");
			params.add(item.getXmlcampo6());
		}
		if (item != null && item.getXmlcampo7() != null) {
			where.append(" AND t1.XMLCAMPO7 = ?");
			params.add(item.getXmlcampo7());
		}
		if (item != null && item.getXmlcampo8() != null) {
			where.append(" AND t1.XMLCAMPO8 = ?");
			params.add(item.getXmlcampo8());
		}
		if (item != null && item.getXmlcampo9() != null) {
			where.append(" AND t1.XMLCAMPO9 = ?");
			params.add(item.getXmlcampo9());
		}
		if (item != null && item.getXmlcampo10() != null) {
			where.append(" AND t1.XMLCAMPO10 = ?");
			params.add(item.getXmlcampo10());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Item table.
	 * 
	 * @param item
	 *            Item
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCountSeguimiento(Item item) {

		StringBuffer where = new StringBuffer(Y41aConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ITEM t1  ");
		if (item != null && item.getItemRef() != null) {
			where.append(" AND t1.ITEM_REF = ?");
			params.add(item.getItemRef());
		}
		if (item != null && item.getEnvio().getEnvioId() != null) {
			where.append(" AND t1.ENVIO_ID = ?");
			params.add(item.getEnvio().getEnvioId());
		}
		if (item != null && item.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(item.getNombre());
		}
		if (item != null && item.getNombreLocalizacion() != null) {
			where.append(" AND t1.NOMBRE_LOCALIZACION = ?");
			params.add(item.getNombreLocalizacion());
		}
		if (item != null && item.getTelefono() != null) {
			where.append(" AND t1.TELEFONO = ?");
			params.add(item.getTelefono());
		}
		if (item != null && item.getEmail() != null) {
			where.append(" AND t1.EMAIL = ?");
			params.add(item.getEmail());
		}
		if (item != null && item.getSeleccionado() != null) {
			where.append(" AND t1.SELECCIONADO = ?");
			params.add(item.getSeleccionado());
		}
		if (item != null && item.getFechaMailingEnvio() != null) {
			where.append(" AND t1.FECHA_MAILING_ENVIO = ?");
			params.add(item.getFechaMailingEnvio());
		}
		if (item != null && item.getMailingResponseCode() != null) {
			where.append(" AND t1.MAILING_RESPONSE_CODE = ?");
			params.add(item.getMailingResponseCode());
		}
		if (item != null) {
			if (item.getFechaMailingRecepcion() != null) {
				where.append(" AND t1.FECHA_MAILING_RECEPCION = ?");
				params.add(item.getFechaMailingRecepcion());
			} else {
				where.append(" AND t1.FECHA_MAILING_RECEPCION IS NULL");
			}
		}
		if (item != null && item.getXmlcampo1() != null) {
			where.append(" AND t1.XMLCAMPO1 = ?");
			params.add(item.getXmlcampo1());
		}
		if (item != null && item.getXmlcampo2() != null) {
			where.append(" AND t1.XMLCAMPO2 = ?");
			params.add(item.getXmlcampo2());
		}
		if (item != null && item.getXmlcampo3() != null) {
			where.append(" AND t1.XMLCAMPO3 = ?");
			params.add(item.getXmlcampo3());
		}
		if (item != null && item.getXmlcampo4() != null) {
			where.append(" AND t1.XMLCAMPO4 = ?");
			params.add(item.getXmlcampo4());
		}
		if (item != null && item.getXmlcampo5() != null) {
			where.append(" AND t1.XMLCAMPO5 = ?");
			params.add(item.getXmlcampo5());
		}
		if (item != null && item.getXmlcampo6() != null) {
			where.append(" AND t1.XMLCAMPO6 = ?");
			params.add(item.getXmlcampo6());
		}
		if (item != null && item.getXmlcampo7() != null) {
			where.append(" AND t1.XMLCAMPO7 = ?");
			params.add(item.getXmlcampo7());
		}
		if (item != null && item.getXmlcampo8() != null) {
			where.append(" AND t1.XMLCAMPO8 = ?");
			params.add(item.getXmlcampo8());
		}
		if (item != null && item.getXmlcampo9() != null) {
			where.append(" AND t1.XMLCAMPO9 = ?");
			params.add(item.getXmlcampo9());
		}
		if (item != null && item.getXmlcampo10() != null) {
			where.append(" AND t1.XMLCAMPO10 = ?");
			params.add(item.getXmlcampo10());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Item table using like.
	 * 
	 * @param item
	 *            Item
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Item> findAllLike(Item item, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(Y41aConstantes.NUM_3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ITEM_REF ITEMREF,t1.ENVIO_ID ENVIOID,t1.NOMBRE NOMBRE,t1.NOMBRE_LOCALIZACION NOMBRELOCALIZACION,t1.TELEFONO TELEFONO,t1.EMAIL EMAIL,t1.SELECCIONADO SELECCIONADO,t1.FECHA_MAILING_ENVIO FECHAMAILINGENVIO,t1.MAILING_RESPONSE_CODE MAILINGRESPONSECODE,t1.FECHA_MAILING_RECEPCION FECHAMAILINGRECEPCION,t1.XMLCAMPO1 XMLCAMPO1,t1.XMLCAMPO2 XMLCAMPO2,t1.XMLCAMPO3 XMLCAMPO3,t1.XMLCAMPO4 XMLCAMPO4,t1.XMLCAMPO5 XMLCAMPO5,t1.XMLCAMPO6 XMLCAMPO6,t1.XMLCAMPO7 XMLCAMPO7,t1.XMLCAMPO8 XMLCAMPO8,t1.XMLCAMPO9 XMLCAMPO9,t1.XMLCAMPO10 XMLCAMPO10 "
						+ "FROM ITEM t1 ");

		if (item != null && item.getItemRef() != null) {
			where.append(" AND UPPER(t1.ITEM_REF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getItemRef().toUpperCase() + "%");
			} else {
				params.add("%" + item.getItemRef().toUpperCase() + "%");
			}
			where.append(" AND t1.ITEM_REF IS NOT NULL");
		}
		if (item != null && item.getEnvio().getEnvioId() != null) {
			where.append(" AND UPPER(t1.ENVIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getEnvio().getEnvioId().toUpperCase() + "%");
			} else {
				params.add("%" + item.getEnvio().getEnvioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ENVIO_ID IS NOT NULL");
		}
		if (item != null && item.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + item.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (item != null && item.getNombreLocalizacion() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIZACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getNombreLocalizacion().toUpperCase() + "%");
			} else {
				params.add("%" + item.getNombreLocalizacion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIZACION IS NOT NULL");
		}
		if (item != null && item.getTelefono() != null) {
			where.append(" AND UPPER(t1.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getTelefono().toUpperCase() + "%");
			} else {
				params.add("%" + item.getTelefono().toUpperCase() + "%");
			}
			where.append(" AND t1.TELEFONO IS NOT NULL");
		}
		if (item != null && item.getEmail() != null) {
			where.append(" AND UPPER(t1.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getEmail().toUpperCase() + "%");
			} else {
				params.add("%" + item.getEmail().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAIL IS NOT NULL");
		}
		if (item != null && item.getSeleccionado() != null) {
			where.append(" AND UPPER(t1.SELECCIONADO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getSeleccionado().toUpperCase() + "%");
			} else {
				params.add("%" + item.getSeleccionado().toUpperCase() + "%");
			}
			where.append(" AND t1.SELECCIONADO IS NOT NULL");
		}
		if (item != null && item.getFechaMailingEnvio() != null) {
			where.append(" AND t1.FECHA_MAILING_ENVIO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getFechaMailingEnvio() + "%");
			} else {
				params.add("%" + item.getFechaMailingEnvio() + "%");
			}
			where.append(" AND t1.FECHA_MAILING_ENVIO IS NOT NULL");
		}
		if (item != null && item.getMailingResponseCode() != null) {
			where.append(" AND UPPER(t1.MAILING_RESPONSE_CODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getMailingResponseCode().toUpperCase() + "%");
			} else {
				params.add("%" + item.getMailingResponseCode().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MAILING_RESPONSE_CODE IS NOT NULL");
		}
		if (item != null && item.getFechaMailingRecepcion() != null) {
			where.append(" AND t1.FECHA_MAILING_RECEPCION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getFechaMailingRecepcion() + "%");
			} else {
				params.add("%" + item.getFechaMailingRecepcion() + "%");
			}
			where.append(" AND t1.FECHA_MAILING_RECEPCION IS NOT NULL");
		}
		if (item != null && item.getXmlcampo1() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo1().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo1().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO1 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo2() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo2().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo2().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO2 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo3() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo3().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo3().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO3 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo4() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo4().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo4().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO4 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo5() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO5) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo5().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo5().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO5 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo6() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO6) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo6().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo6().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO6 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo7() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo7().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo7().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO7 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo8() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo8().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo8().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO8 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo9() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO9) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo9().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo9().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO9 IS NOT NULL");
		}
		if (item != null && item.getXmlcampo10() != null) {
			where.append(" AND UPPER(t1.XMLCAMPO10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(item.getXmlcampo10().toUpperCase() + "%");
			} else {
				params.add("%" + item.getXmlcampo10().toUpperCase() + "%");
			}
			where.append(" AND t1.XMLCAMPO10 IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(Y41aConstantes.NUM_3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Item>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}
}
