package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Intervinientes;

/**
 * IntervinientesDaoImpl generated by UDA, 22-oct-2013 11:50:10.
 * 
 *  
 */

@Repository
@Transactional
public class IntervinientesDaoImpl implements IntervinientesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Intervinientes> rwMap = new RowMapper<Intervinientes>() {
		public Intervinientes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Intervinientes(resultSet.getString("IDINTERVINIENTE"),
					resultSet.getString("DTCODIGO"),
					resultSet.getString("ESCODIGO"),
					resultSet.getString("ENTIDAD_ID"),
					resultSet.getString("NOMBRE"),
					resultSet.getString("APELLIDO1"),
					resultSet.getString("APELLIDO2"),
					resultSet.getString("ESNOCO"),
					resultSet.getString("DTINTIPID"),
					resultSet.getString("NIF"),
					resultSet.getString("DTRANGO_EDAD"),
					resultSet.getString("DTCOSX"),
					resultSet.getString("COIDCO"),
					resultSet.getString("ESTEURL"),
					resultSet.getString("ESNOPECO"),
					resultSet.getDate("ESFEBA"), resultSet.getString("NRTEL"),
					resultSet.getString("NRTEL2"), resultSet.getString("COEM"),
					resultSet.getString("EXTRANJERO"),
					resultSet.getString("NORAPROVINCIAID"),
					resultSet.getString("NOMBREPROVINCIA"),
					resultSet.getString("NORAMUNICIPIOID"),
					resultSet.getString("NOMBREMUNICIPIO"),
					resultSet.getString("NORALOCALIDADID"),
					resultSet.getString("NOMBRELOCALIDAD"),
					resultSet.getString("NORACALLEID"),
					resultSet.getString("NOMBRECALLE"),
					resultSet.getString("NORACPID"),
					resultSet.getString("NOMBRECP"),
					resultSet.getString("NORAPORTALID"),
					resultSet.getString("NOMBREPORTAL"),
					resultSet.getString("NOMBREPISO"),
					resultSet.getString("NORAPAISID"),
					resultSet.getString("NOMBREPAIS"),
					resultSet.getString("DIRECCIONNOCAPV"),
					resultSet.getString("DIRECCIONANTIGUA"),
					resultSet.getString("INADAR"),
					resultSet.getString("SECODIGO"),
					resultSet.getString("SENOMBRE"),
					resultSet.getString("SENOMBREE"),
					resultSet.getString("TIPOINTERVINIENTE"),
					resultSet.getString("HDCODIGO"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	public Intervinientes add(Intervinientes intervinientes) {
		String query = "INSERT INTO INTERVINIENTES (IDINTERVINIENTE, DTCODIGO, ESCODIGO, ENTIDAD_ID, NOMBRE, APELLIDO1, APELLIDO2, ESNOCO, DTINTIPID, NIF, DTRANGO_EDAD, DTCOSX, COIDCO, ESTEURL, ESNOPECO, ESFEBA, NRTEL, NRTEL2, COEM, EXTRANJERO, NORA_PROVINCIA_ID, NOMBRE_PROVINCIA, NORA_MUNICIPIO_ID, NOMBRE_MUNICIPIO, NORA_LOCALIDAD_ID, NOMBRE_LOCALIDAD, NORA_CALLE_ID, NOMBRE_CALLE, NORA_CP_ID, NOMBRE_CP, NORA_PORTAL_ID, NOMBRE_PORTAL, NOMBRE_PISO, NORA_PAIS_ID, NOMBRE_PAIS, DIRECCION_NOCAPV, DIRECCION_ANTIGUA, INADAR, SECODIGO, SENOMBRE, SENOMBREE,TIPO_INTERVINIENTE, HDCODIGO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, intervinientes.getIdinterviniente(),
				intervinientes.getDtcodigo(), intervinientes.getEscodigo(),
				intervinientes.getEntidadId(), intervinientes.getNombre(),
				intervinientes.getApellido1(), intervinientes.getApellido2(),
				intervinientes.getEsnoco(), intervinientes.getDtintipid(),
				intervinientes.getNif(), intervinientes.getDtrango_edad(),
				intervinientes.getDtcosx(), intervinientes.getCoidco(),
				intervinientes.getEsteurl(), intervinientes.getEsnopeco(),
				intervinientes.getEsfeba(), intervinientes.getNrtel(),
				intervinientes.getNrtel2(), intervinientes.getCoem(),
				intervinientes.getExtranjero(),
				intervinientes.getNoraProvinciaId(),
				intervinientes.getNombreProvincia(),
				intervinientes.getNoraMunicipioId(),
				intervinientes.getNombreMunicipio(),
				intervinientes.getNoraLocalidadId(),
				intervinientes.getNombreLocalidad(),
				intervinientes.getNoraCalleId(),
				intervinientes.getNombreCalle(), intervinientes.getNoraCpId(),
				intervinientes.getNombreCp(), intervinientes.getNoraPortalId(),
				intervinientes.getNombrePortal(),
				intervinientes.getNombrePiso(), intervinientes.getNoraPaisId(),
				intervinientes.getNombrePais(),
				intervinientes.getDireccionNocapv(),
				intervinientes.getDireccionAntigua(),
				intervinientes.getInadar(), intervinientes.getSecodigo(),
				intervinientes.getSenombre(), intervinientes.getSenombree(),
				intervinientes.getTipoInterviniente(),
				intervinientes.getIdExpediente());

		return intervinientes;
	}

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	public Intervinientes update(Intervinientes intervinientes) {
		String query = "UPDATE INTERVINIENTES SET DTCODIGO=?, ESCODIGO=?, ENTIDAD_ID=?, NOMBRE=?, APELLIDO1=?, APELLIDO2=?, ESNOCO=?, DTINTIPID=?, NIF=?, DTRANGO_EDAD=?, DTCOSX=?, COIDCO=?, ESTEURL=?, ESNOPECO=?, ESFEBA=?, NRTEL=?, NRTEL2=?, COEM=?, EXTRANJERO=?, NORA_PROVINCIA_ID=?, NOMBRE_PROVINCIA=?, NORA_MUNICIPIO_ID=?, NOMBRE_MUNICIPIO=?, NORA_LOCALIDAD_ID=?, NOMBRE_LOCALIDAD=?, NORA_CALLE_ID=?, NOMBRE_CALLE=?, NORA_CP_ID=?, NOMBRE_CP=?, NORA_PORTAL_ID=?, NOMBRE_PORTAL=?, NOMBRE_PISO=?, NORA_PAIS_ID=?, NOMBRE_PAIS=?,DIRECCION_NOCAPV=?, DIRECCION_ANTIGUA=?, INADAR=?, SECODIGO=?, SENOMBRE=?, SENOMBREE=?,TIPO_INTERVINIENTE=?, HDCODIGO=? WHERE IDINTERVINIENTE=?";

		this.jdbcTemplate.update(query, intervinientes.getDtcodigo(),
				intervinientes.getEscodigo(), intervinientes.getEntidadId(),
				intervinientes.getNombre(), intervinientes.getApellido1(),
				intervinientes.getApellido2(), intervinientes.getEsnoco(),
				intervinientes.getDtintipid(), intervinientes.getNif(),
				intervinientes.getDtrango_edad(), intervinientes.getDtcosx(),
				intervinientes.getCoidco(), intervinientes.getEsteurl(),
				intervinientes.getEsnopeco(), intervinientes.getEsfeba(),
				intervinientes.getNrtel(), intervinientes.getNrtel2(),
				intervinientes.getCoem(), intervinientes.getExtranjero(),
				intervinientes.getNoraProvinciaId(),
				intervinientes.getNombreProvincia(),
				intervinientes.getNoraMunicipioId(),
				intervinientes.getNombreMunicipio(),
				intervinientes.getNoraLocalidadId(),
				intervinientes.getNombreLocalidad(),
				intervinientes.getNoraCalleId(),
				intervinientes.getNombreCalle(), intervinientes.getNoraCpId(),
				intervinientes.getNombreCp(), intervinientes.getNoraPortalId(),
				intervinientes.getNombrePortal(),
				intervinientes.getNombrePiso(), intervinientes.getNoraPaisId(),
				intervinientes.getNombrePais(),
				intervinientes.getDireccionNocapv(),
				intervinientes.getDireccionAntigua(),
				intervinientes.getInadar(), intervinientes.getSecodigo(),
				intervinientes.getSenombre(), intervinientes.getSenombree(),
				intervinientes.getTipoInterviniente(),
				intervinientes.getIdExpediente(),
				intervinientes.getIdinterviniente());
		return intervinientes;
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	@Transactional(readOnly = true)
	public Intervinientes find(Intervinientes intervinientes) {
		String query = "SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO FROM INTERVINIENTES t1  WHERE t1.IDINTERVINIENTE = ?  ";

		List<Intervinientes> intervinientesList = this.jdbcTemplate.query(
				query, this.rwMap, intervinientes.getIdinterviniente());
		return (Intervinientes) DataAccessUtils
				.uniqueResult(intervinientesList);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	@Transactional(readOnly = true)
	public Intervinientes findIntervinienteConsumidor(
			Intervinientes intervinientes) {
		String query = "SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO FROM INTERVINIENTES t1  WHERE t1.DTCODIGO = ? AND t1.HDCODIGO=? ";

		List<Intervinientes> intervinientesList = this.jdbcTemplate.query(
				query, this.rwMap, intervinientes.getDtcodigo(),
				intervinientes.getIdExpediente());
		return (Intervinientes) DataAccessUtils
				.uniqueResult(intervinientesList);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	@Transactional(readOnly = true)
	public Intervinientes findIntervinienteEstablecimiento(
			Intervinientes intervinientes) {
		String query = "SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO FROM INTERVINIENTES t1  WHERE t1.ESCODIGO = ? AND t1.HDCODIGO=? ";

		List<Intervinientes> intervinientesList = this.jdbcTemplate.query(
				query, this.rwMap, intervinientes.getEscodigo(),
				intervinientes.getIdExpediente());
		return (Intervinientes) DataAccessUtils
				.uniqueResult(intervinientesList);
	}

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	@Transactional(readOnly = true)
	public Intervinientes findIntervinienteEntidad(Intervinientes intervinientes) {
		String query = "SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO FROM INTERVINIENTES t1  WHERE t1.ENTIDAD_ID = ?  AND t1.HDCODIGO=? ";

		List<Intervinientes> intervinientesList = this.jdbcTemplate.query(
				query, this.rwMap, intervinientes.getEntidadId(),
				intervinientes.getIdExpediente());
		return (Intervinientes) DataAccessUtils
				.uniqueResult(intervinientesList);
	}

	/**
	 * Removes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return
	 */
	public void remove(Intervinientes intervinientes) {
		String query = "DELETE FROM INTERVINIENTES WHERE IDINTERVINIENTE=?";
		this.jdbcTemplate.update(query, intervinientes.getIdinterviniente());
	}

	/**
	 * Removes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return
	 */
	public void removeIntervinientesExpediente(Intervinientes intervinientes) {
		String query = "DELETE FROM INTERVINIENTES WHERE HDCODIGO=?";
		this.jdbcTemplate.update(query, intervinientes.getIdExpediente());
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Intervinientes> findAll(Intervinientes intervinientes,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO ");
		query.append("FROM INTERVINIENTES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(intervinientes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Intervinientes> findAllIntervinientesTelematicos(
			Intervinientes intervinientes, Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO ");
		query.append("FROM INTERVINIENTES_TELE t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(intervinientes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Intervinientes intervinientes) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INTERVINIENTES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(intervinientes);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Intervinientes> findAllLike(Intervinientes intervinientes,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDINTERVINIENTE IDINTERVINIENTE, t1.DTCODIGO DTCODIGO, t1.ESCODIGO ESCODIGO, t1.ENTIDAD_ID ENTIDAD_ID, t1.NOMBRE NOMBRE, t1.APELLIDO1 APELLIDO1,t1.APELLIDO2 APELLIDO2,t1.ESNOCO ESNOCO,t1.DTINTIPID DTINTIPID,t1.NIF NIF, t1.DTRANGO_EDAD DTRANGO_EDAD, t1.DTCOSX DTCOSX, t1.COIDCO COIDCO, t1.ESTEURL ESTEURL, t1.ESNOPECO ESNOPECO, t1.ESFEBA ESFEBA,t1.NRTEL NRTEL, t1.NRTEL2 NRTEL2, t1.COEM COEM, t1.EXTRANJERO EXTRANJERO, t1.NORA_PROVINCIA_ID NORAPROVINCIAID, t1.NOMBRE_PROVINCIA NOMBREPROVINCIA, t1.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t1.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t1.NORA_LOCALIDAD_ID NORALOCALIDADID, t1.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t1.NORA_CALLE_ID NORACALLEID, t1.NOMBRE_CALLE NOMBRECALLE, t1.NORA_CP_ID NORACPID, t1.NOMBRE_CP NOMBRECP, t1.NORA_PORTAL_ID NORAPORTALID, t1.NOMBRE_PORTAL NOMBREPORTAL, t1.NOMBRE_PISO NOMBREPISO, t1.NORA_PAIS_ID NORAPAISID, t1.NOMBRE_PAIS NOMBREPAIS, t1.DIRECCION_NOCAPV DIRECCIONNOCAPV, t1.DIRECCION_ANTIGUA DIRECCIONANTIGUA, t1.INADAR INADAR, t1.SECODIGO SECODIGO, t1.SENOMBRE SENOMBRE, t1.SENOMBREE SENOMBREE, t1.TIPO_INTERVINIENTE TIPOINTERVINIENTE, t1.HDCODIGO HDCODIGO  ");
		query.append("FROM INTERVINIENTES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(intervinientes,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<Intervinientes>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Intervinientes intervinientes,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM INTERVINIENTES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(intervinientes,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Intervinientes entity
	 * 
	 * @param intervinientes
	 *            Intervinientes Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Intervinientes intervinientes) {

		StringBuilder where = new StringBuilder(
				IntervinientesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (intervinientes != null
				&& intervinientes.getIdinterviniente() != null) {
			where.append(" AND t1.IDINTERVINIENTE = ?");
			params.add(intervinientes.getIdinterviniente());
		}
		if (intervinientes != null && intervinientes.getNombre() != null) {
			where.append(" AND t1.NOMBRE = ?");
			params.add(intervinientes.getNombre());
		}
		if (intervinientes != null && intervinientes.getNif() != null) {
			where.append(" AND t1.NIF = ?");
			params.add(intervinientes.getNif());
		}
		if (intervinientes != null && intervinientes.getNrtel() != null) {
			where.append(" AND t1.NRTEL = ?");
			params.add(intervinientes.getNrtel());
		}
		if (intervinientes != null && intervinientes.getNrtel2() != null) {
			where.append(" AND t1.NRTEL2 = ?");
			params.add(intervinientes.getNrtel2());
		}
		if (intervinientes != null && intervinientes.getCoem() != null) {
			where.append(" AND t1.COEM = ?");
			params.add(intervinientes.getCoem());
		}
		if (intervinientes != null
				&& intervinientes.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(intervinientes.getNoraProvinciaId());
		}
		if (intervinientes != null
				&& intervinientes.getNombreProvincia() != null) {
			where.append(" AND t1.NOMBRE_PROVINCIA = ?");
			params.add(intervinientes.getNombreProvincia());
		}
		if (intervinientes != null
				&& intervinientes.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(intervinientes.getNoraMunicipioId());
		}
		if (intervinientes != null
				&& intervinientes.getNombreMunicipio() != null) {
			where.append(" AND t1.NOMBRE_MUNICIPIO = ?");
			params.add(intervinientes.getNombreMunicipio());
		}
		if (intervinientes != null
				&& intervinientes.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(intervinientes.getNoraLocalidadId());
		}
		if (intervinientes != null
				&& intervinientes.getNombreLocalidad() != null) {
			where.append(" AND t1.NOMBRE_LOCALIDAD = ?");
			params.add(intervinientes.getNombreLocalidad());
		}
		if (intervinientes != null && intervinientes.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(intervinientes.getNoraCalleId());
		}
		if (intervinientes != null && intervinientes.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(intervinientes.getNombreCalle());
		}
		if (intervinientes != null && intervinientes.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(intervinientes.getNoraCpId());
		}
		if (intervinientes != null && intervinientes.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(intervinientes.getNombreCp());
		}
		if (intervinientes != null && intervinientes.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(intervinientes.getNoraPortalId());
		}
		if (intervinientes != null && intervinientes.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(intervinientes.getNombrePortal());
		}
		if (intervinientes != null && intervinientes.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(intervinientes.getNombrePiso());
		}
		if (intervinientes != null
				&& intervinientes.getDireccionNocapv() != null) {
			where.append(" AND t1.DIRECCION_NOCAPV = ?");
			params.add(intervinientes.getDireccionNocapv());
		}
		if (intervinientes != null
				&& intervinientes.getDireccionAntigua() != null) {
			where.append(" AND t1.DIRECCION_ANTIGUA = ?");
			params.add(intervinientes.getDireccionAntigua());
		}
		if (intervinientes != null
				&& intervinientes.getTipoInterviniente() != null) {
			where.append(" AND t1.TIPO_INTERVINIENTE = ?");
			params.add(intervinientes.getTipoInterviniente());
		}
		if (intervinientes != null && intervinientes.getIdExpediente() != null) {
			where.append(" AND t1.HDCODIGO = ?");
			params.add(intervinientes.getIdExpediente());
		}
		if (intervinientes != null && intervinientes.getEntidadId() != null) {
			where.append(" AND t1.ENTIDAD_ID = ?");
			params.add(intervinientes.getEntidadId());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Intervinientes entity
	 * 
	 * @param intervinientes
	 *            Intervinientes Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(Intervinientes intervinientes,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				IntervinientesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (intervinientes != null
				&& intervinientes.getIdinterviniente() != null) {
			where.append(" AND UPPER(t1.IDINTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getIdinterviniente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getIdinterviniente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.IDINTERVINIENTE IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNombre() != null) {
			where.append(" AND UPPER(t1.NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombre().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNombre().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBRE IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNif() != null) {
			where.append(" AND UPPER(t1.NIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNif().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNif().toUpperCase() + "%");
			}
			where.append(" AND t1.NIF IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNrtel() != null) {
			where.append(" AND UPPER(t1.NRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNrtel().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNrtel().toUpperCase() + "%");
			}
			where.append(" AND t1.NRTEL IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNrtel2() != null) {
			where.append(" AND UPPER(t1.NRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNrtel2().toUpperCase() + "%");
			}
			where.append(" AND t1.NRTEL2 IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getCoem() != null) {
			where.append(" AND UPPER(t1.COEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getCoem().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getCoem().toUpperCase() + "%");
			}
			where.append(" AND t1.COEM IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraProvinciaId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNombreProvincia() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombreProvincia().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraMunicipioId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNombreMunicipio() != null) {
			where.append(" AND UPPER(t1.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombreMunicipio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraLocalidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getNombreLocalidad() != null) {
			where.append(" AND UPPER(t1.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombreLocalidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getNombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNoraCalleId() != null) {
			where.append(" AND UPPER(t1.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraCalleId().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_CALLE_ID IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNombreCalle() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombreCalle().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CALLE IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNoraCpId() != null) {
			where.append(" AND UPPER(t1.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_CP_ID IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNombreCp() != null) {
			where.append(" AND UPPER(t1.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_CP IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNoraPortalId() != null) {
			where.append(" AND UPPER(t1.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNoraPortalId().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NORA_PORTAL_ID IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNombrePortal() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombrePortal().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PORTAL IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getNombrePiso() != null) {
			where.append(" AND UPPER(t1.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getNombrePiso().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getNombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NOMBRE_PISO IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getDireccionNocapv() != null) {
			where.append(" AND UPPER(t1.DIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getDireccionNocapv().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getDireccionNocapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION_NOCAPV IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getDireccionAntigua() != null) {
			where.append(" AND UPPER(t1.DIRECCION_ANTIGUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getDireccionAntigua().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getDireccionAntigua().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCION_ANTIGUA IS NOT NULL");
		}
		if (intervinientes != null
				&& intervinientes.getTipoInterviniente() != null) {
			where.append(" AND UPPER(t1.TIPO_INTERVINIENTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getTipoInterviniente().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ intervinientes.getTipoInterviniente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPO_INTERVINIENTE IS NOT NULL");
		}
		if (intervinientes != null && intervinientes.getIdExpediente() != null) {
			where.append(" AND UPPER(t1.HDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(intervinientes.getIdExpediente().toUpperCase() + "%");
			} else {
				params.add("%" + intervinientes.getIdExpediente().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HDCODIGO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		try {
			String query = "UPDATE INTERVINIENTES SET ESCODIGO=? WHERE ESCODIGO=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {

		}
	}

}
