package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Intervinientes;

/**
 * IntervinientesDao generated by UDA, 22-oct-2013 11:50:10.
 * 
 *  
 */

public interface IntervinientesDao {

	/**
	 * Inserts a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes add(Intervinientes intervinientes);

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes update(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Intervinientes
	 */
	Intervinientes find(Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	public Intervinientes findIntervinienteConsumidor(
			Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	public Intervinientes findIntervinienteEstablecimiento(
			Intervinientes intervinientes);

	/**
	 * Finds a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return Intervinientes
	 */
	public Intervinientes findIntervinienteEntidad(Intervinientes intervinientes);

	/**
	 * Deletes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return
	 */
	void remove(Intervinientes intervinientes);

	/**
	 * Removes a single row in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Pagination
	 * @return
	 */
	public void removeIntervinientesExpediente(Intervinientes intervinientes);

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Intervinientes> findAll(Intervinientes intervinientes,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Intervinientes> findAllIntervinientesTelematicos(
			Intervinientes intervinientes, Pagination pagination);

	/**
	 * Counts rows in the Intervinientes table.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @return Long
	 */
	Long findAllCount(Intervinientes intervinientes);

	/**
	 * Finds rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Intervinientes> findAllLike(Intervinientes intervinientes,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Intervinientes table using like.
	 * 
	 * @param intervinientes
	 *            Intervinientes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Intervinientes intervinientes, Boolean startsWith);

	/**
	 * Updates a single row in the Intervinientes table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar);

}
