package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Inspector;

/**
 *  * InspectorDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class InspectorDaoImpl implements InspectorDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Inspector> rwMap = new RowMapper<Inspector>() {
		public Inspector mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Inspector(
               resultSet.getString("INCODIGO"), resultSet.getString("INNOMBRE"), resultSet.getString("INCOOR")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Inspector table.
     *
     * @param inspector Pagination
     * @return Inspector
     */
	public Inspector add(Inspector inspector) {

    	String query = "INSERT INTO INSPECTOR( INCODIGO,INNOMBRE,INCOOR)"
        + "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, inspector.getIncodigo(), inspector.getInnombre(), inspector.getIncoor());
		return inspector;
	}

    /**
     * Updates a single row in the Inspector table.
     *
     * @param inspector Pagination
     * @return Inspector
     */
    public Inspector update(Inspector inspector) {
		String query = "UPDATE INSPECTOR SET INNOMBRE=?,INCOOR=? WHERE INCODIGO=?";
		this.jdbcTemplate.update(query, inspector.getInnombre(), inspector.getIncoor(), inspector.getIncodigo());
		return inspector;
	}

    /**
     * Finds a single row in the Inspector table.
     *
     * @param inspector Pagination
     * @return Inspector
     */
    @Transactional (readOnly = true)
    public Inspector find(Inspector inspector) {
		String query = "SELECT t1.INCODIGO INCODIGO, t1.INNOMBRE INNOMBRE, t1.INCOOR INCOOR " 
         + "FROM INSPECTOR t1  " 
         + "WHERE t1.INCODIGO = ?    ";
		return (Inspector) this.jdbcTemplate.queryForObject(query, 
			rwMap , inspector.getIncodigo());	 
    }

    /**
     * Removes a single row in the Inspector table.
     *
     * @param inspector Pagination
     * @return
     */
    public void remove(Inspector inspector) {
		String query = "DELETE  FROM INSPECTOR WHERE INCODIGO=?";
		this.jdbcTemplate.update(query, inspector.getIncodigo());
    	}
    
   /**
    * Finds a List of rows in the Inspector table.
    * 
    * @param inspector Inspector
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Inspector> findAll(Inspector inspector, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.INCODIGO INCODIGO,t1.INNOMBRE INNOMBRE,t1.INCOOR INCOOR " 
			+ "FROM INSPECTOR t1 ");
		
		if (inspector  != null  && inspector.getIncodigo() != null ) {
			where.append(" AND t1.INCODIGO = ?");
			params.add(inspector.getIncodigo());
		}
		if (inspector  != null  && inspector.getInnombre() != null ) {
			where.append(" AND t1.INNOMBRE = ?");
			params.add(inspector.getInnombre());
		}
		if (inspector  != null  && inspector.getIncoor() != null ) {
			where.append(" AND t1.INCOOR = ?");
			params.add(inspector.getIncoor());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Inspector>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Inspector table.
     * 
     * @param inspector Inspector
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Inspector inspector) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  INSPECTOR t1  ");
		if (inspector  != null  && inspector.getIncodigo() != null ) {
			where.append(" AND t1.INCODIGO = ?");
			params.add(inspector.getIncodigo());
		}
		if (inspector  != null  && inspector.getInnombre() != null ) {
			where.append(" AND t1.INNOMBRE = ?");
			params.add(inspector.getInnombre());
		}
		if (inspector  != null  && inspector.getIncoor() != null ) {
			where.append(" AND t1.INCOOR = ?");
			params.add(inspector.getIncoor());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Inspector table using like.
     * 
     * @param inspector Inspector
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Inspector> findAllLike(Inspector inspector, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.INCODIGO INCODIGO,t1.INNOMBRE INNOMBRE,t1.INCOOR INCOOR " 
        	+ "FROM INSPECTOR t1 ");
      	
		if (inspector  != null  && inspector.getIncodigo() != null ) {
			where.append(" AND UPPER(t1.INCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(inspector.getIncodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+inspector.getIncodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.INCODIGO IS NOT NULL");
        }
		if (inspector  != null  && inspector.getInnombre() != null ) {
			where.append(" AND UPPER(t1.INNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(inspector.getInnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+inspector.getInnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.INNOMBRE IS NOT NULL");
        }
		if (inspector  != null  && inspector.getIncoor() != null ) {
			where.append(" AND UPPER(t1.INCOOR) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(inspector.getIncoor().toUpperCase()  +"%");
			}else{
				params.add("%"+inspector.getIncoor().toUpperCase() +"%");
			}	
			where.append(" AND t1.INCOOR IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Inspector>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

