package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Inspecciones;

/**
 * * InspeccionesDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class InspeccionesDaoImpl implements InspeccionesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Inspecciones> rwMap = new RowMapper<Inspecciones>() {
		public Inspecciones mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Inspecciones(resultSet.getString("INSCODCARTA"),
					resultSet.getString("INSNOMBRE"),
					resultSet.getString("INSNOMBREE"),
					resultSet.getDate("INSBAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Pagination
	 * @return Inspecciones
	 */
	public Inspecciones add(Inspecciones inspecciones) {

		String query = "INSERT INTO INSPECCIONES( INSCODCARTA,INSNOMBRE,INSNOMBREE,INSBAJA)"
				+ "VALUES (?,?,?,?)";

		this.jdbcTemplate.update(query, inspecciones.getInscodcarta(),
				inspecciones.getInsnombre(), inspecciones.getInsnombree(),
				inspecciones.getInsbaja());
		return inspecciones;
	}

	/**
	 * Updates a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Pagination
	 * @return Inspecciones
	 */
	public Inspecciones update(Inspecciones inspecciones) {
		String query = "UPDATE INSPECCIONES SET INSNOMBRE=?,INSNOMBREE=?,INSBAJA=? WHERE INSCODCARTA=?";
		this.jdbcTemplate.update(query, inspecciones.getInsnombre(),
				inspecciones.getInsnombree(), inspecciones.getInsbaja(),
				inspecciones.getInscodcarta());
		return inspecciones;
	}

	/**
	 * Updates a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Pagination
	 * @return Inspecciones
	 */
	public Inspecciones updateFecha(Inspecciones inspecciones) {
		String query = "UPDATE INSPECCIONES SET INSBAJA=? WHERE INSCODCARTA=?";
		this.jdbcTemplate.update(query, inspecciones.getInsbaja(),
				inspecciones.getInscodcarta());
		return inspecciones;
	}

	/**
	 * Finds a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Pagination
	 * @return Inspecciones
	 */
	@Transactional(readOnly = true)
	public Inspecciones find(Inspecciones inspecciones) {
		String query = "SELECT t1.INSCODCARTA INSCODCARTA, t1.INSNOMBRE INSNOMBRE, t1.INSNOMBREE INSNOMBREE, t1.INSBAJA INSBAJA "
				+ "FROM INSPECCIONES t1  " + "WHERE t1.INSCODCARTA = ?    ";
		return (Inspecciones) this.jdbcTemplate.queryForObject(query, rwMap,
				inspecciones.getInscodcarta());
	}

	/**
	 * Removes a single row in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Pagination
	 * @return
	 */
	public void remove(Inspecciones inspecciones) {
		String query = "DELETE  FROM INSPECCIONES WHERE INSCODCARTA=?";
		this.jdbcTemplate.update(query, inspecciones.getInscodcarta());
	}

	/**
	 * Finds a List of rows in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Inspecciones> findAll(Inspecciones inspecciones,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.INSCODCARTA INSCODCARTA,t1.INSNOMBRE INSNOMBRE,t1.INSNOMBREE INSNOMBREE,t1.INSBAJA INSBAJA "
						+ "FROM INSPECCIONES t1 ");

		if (inspecciones != null && inspecciones.getInscodcarta() != null) {
			where.append(" AND t1.INSCODCARTA = ?");
			params.add(inspecciones.getInscodcarta());
		}
		if (inspecciones != null && inspecciones.getInsnombre() != null) {
			where.append(" AND t1.INSNOMBRE = ?");
			params.add(inspecciones.getInsnombre());
		}
		if (inspecciones != null && inspecciones.getInsnombree() != null) {
			where.append(" AND t1.INSNOMBREE = ?");
			params.add(inspecciones.getInsnombree());
		}
		if (inspecciones != null && inspecciones.getInsbaja() != null) {
			where.append(" AND t1.INSBAJA = ?");
			params.add(inspecciones.getInsbaja());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Inspecciones>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Inspecciones table.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Inspecciones inspecciones) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  INSPECCIONES t1  ");
		if (inspecciones != null && inspecciones.getInscodcarta() != null) {
			where.append(" AND t1.INSCODCARTA = ?");
			params.add(inspecciones.getInscodcarta());
		}
		if (inspecciones != null && inspecciones.getInsnombre() != null) {
			where.append(" AND t1.INSNOMBRE = ?");
			params.add(inspecciones.getInsnombre());
		}
		if (inspecciones != null && inspecciones.getInsnombree() != null) {
			where.append(" AND t1.INSNOMBREE = ?");
			params.add(inspecciones.getInsnombree());
		}
		if (inspecciones != null && inspecciones.getInsbaja() != null) {
			where.append(" AND t1.INSBAJA = ?");
			params.add(inspecciones.getInsbaja());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Inspecciones table using like.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Inspecciones> findAllLike(Inspecciones inspecciones,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.INSCODCARTA INSCODCARTA,t1.INSNOMBRE INSNOMBRE,t1.INSNOMBREE INSNOMBREE,t1.INSBAJA INSBAJA "
						+ "FROM INSPECCIONES t1 ");

		if (inspecciones != null && inspecciones.getInscodcarta() != null) {
			where.append(" AND UPPER(t1.INSCODCARTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspecciones.getInscodcarta().toUpperCase() + "%");
			} else {
				params.add("%" + inspecciones.getInscodcarta().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.INSCODCARTA IS NOT NULL");
		}
		if (inspecciones != null && inspecciones.getInsnombre() != null) {
			where.append(" AND UPPER(t1.INSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspecciones.getInsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + inspecciones.getInsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.INSNOMBRE IS NOT NULL");
		}
		if (inspecciones != null && inspecciones.getInsnombree() != null) {
			where.append(" AND UPPER(t1.INSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspecciones.getInsnombree().toUpperCase() + "%");
			} else {
				params.add("%" + inspecciones.getInsnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.INSNOMBREE IS NOT NULL");
		}
		if (inspecciones != null && inspecciones.getInsbaja() != null) {
			where.append(" AND t1.INSBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(inspecciones.getInsbaja() + "%");
			} else {
				params.add("%" + inspecciones.getInsbaja() + "%");
			}
			where.append(" AND t1.INSBAJA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Inspecciones>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21S7T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
