package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.Comaut;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipOrigenProd;
import com.ejie.y41a.model.TipReqNormativo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.InfracAlerta;

/**
 * * InfracAlertaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class InfracAlertaDaoImpl implements InfracAlertaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<InfracAlerta> rwMap = new RowMapper<InfracAlerta>() {
		public InfracAlerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new InfracAlerta(resultSet.getString("IACODIGO"),
					new TipReqNormativo(resultSet
							.getString("TipReqNormativoTTICODIGO"), resultSet
							.getString("TipReqNormativoTTINOMBRE"), resultSet
							.getString("TipReqNormativoTTINOCO"), resultSet
							.getString("TipReqNormativoTTITEDE"), resultSet
							.getString("TipReqNormativoTTICOSE"), resultSet
							.getString("TipReqNormativoTTINOCO2"), resultSet
							.getString("TipReqNormativoTTIINSEL1"), resultSet
							.getString("TipReqNormativoTTICOL4"), resultSet
							.getString("TipReqNormativoTTINOMBREE"), resultSet
							.getString("TipReqNormativoTTINOMBREI"), resultSet
							.getString("TipReqNormativoTTINOMBREF"), resultSet
							.getString("TipReqNormativoTTINOCOE"), resultSet
							.getString("TipReqNormativoTTINOCOI"), resultSet
							.getString("TipReqNormativoTTINOCOF"), resultSet
							.getString("TipReqNormativoTTITEDEE"), resultSet
							.getString("TipReqNormativoTTITEDEI"), resultSet
							.getString("TipReqNormativoTTITEDEF"), resultSet
							.getString("TipReqNormativoTTICODGRUPO"), resultSet
							.getString("TipReqNormativoTTINOMBREA"), resultSet
							.getString("TipReqNormativoTTINOCOA"), resultSet
							.getString("TipReqNormativoTTITEDEA"), resultSet
							.getString("TipReqNormativoTTICOE7"), resultSet
							.getString("TipReqNormativoTTICOINC")),
					new Alerta(resultSet.getString("AlertaALCODIGO"), resultSet
							.getString("AlertaALCOOR"), resultSet
							.getLong("AlertaALNRAN"), resultSet
							.getString("AlertaALNROR"), resultSet
							.getDate("AlertaALFEEN"), resultSet
							.getDate("AlertaALFEPLRR"), resultSet
							.getString("AlertaALNOPRSE"), resultSet
							.getString("AlertaALNRLOPS"), resultSet
							.getString("AlertaALNOMAPS"), resultSet
							.getString("AlertaALNOMOPS"), resultSet
							.getDate("AlertaALFEDUMI"), null, resultSet
							.getDate("AlertaALFERRIN"), resultSet
							.getString("AlertaALINRE"), resultSet
							.getDate("AlertaALFECOOR"), resultSet
							.getString("AlertaALCOTMO"), new Comaut(resultSet
							.getString("AlertaALCOCA"), null, null, null),
							new Producto(resultSet.getString("AlertaALCOPS"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new TipOrigenProd(resultSet
									.getString("AlertaALCOTOP"), null, null),
							new Pais(resultSet.getString("AlertaALCOPA"), null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("AlertaALCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            Pagination
	 * @return InfracAlerta
	 */
	public InfracAlerta add(InfracAlerta infracalerta) {

		String query = "INSERT INTO INFRAC_ALERTA( IACODIGO,IACOTTI,IACOAL)"
				+ "VALUES (?,?,?)";

		Object getTipReqNormativoTticodigoAux = null;
		if (infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = infracalerta.getTipReqNormativo()
					.getTticodigo();
		}
		Object getAlertaAlcodigoAux = null;
		if (infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = infracalerta.getAlerta().getAlcodigo();
		}
		this.jdbcTemplate.update(query, infracalerta.getIacodigo(),
				getTipReqNormativoTticodigoAux, getAlertaAlcodigoAux);
		return infracalerta;
	}

	/**
	 * Updates a single row in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            Pagination
	 * @return InfracAlerta
	 */
	public InfracAlerta update(InfracAlerta infracalerta) {
		String query = "UPDATE INFRAC_ALERTA SET IACOTTI=?,IACOAL=? WHERE IACODIGO=?";
		Object getTipReqNormativoTticodigoAux = null;
		if (infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = infracalerta.getTipReqNormativo()
					.getTticodigo();
		}
		Object getAlertaAlcodigoAux = null;
		if (infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = infracalerta.getAlerta().getAlcodigo();
		}
		this.jdbcTemplate.update(query, getTipReqNormativoTticodigoAux,
				getAlertaAlcodigoAux, infracalerta.getIacodigo());
		return infracalerta;
	}

	/**
	 * Finds a single row in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            Pagination
	 * @return InfracAlerta
	 */
	@Transactional(readOnly = true)
	public InfracAlerta find(InfracAlerta infracalerta) {
		String query = "SELECT t1.IACODIGO IACODIGO, t2.TTICODIGO TIPREQNORMATIVOTTICODIGO, t2.TTINOMBRE TIPREQNORMATIVOTTINOMBRE, t2.TTINOCO TIPREQNORMATIVOTTINOCO, t2.TTITEDE TIPREQNORMATIVOTTITEDE, t2.TTICOSE TIPREQNORMATIVOTTICOSE, t2.TTINOCO2 TIPREQNORMATIVOTTINOCO2, t2.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1, t2.TTICOL4 TIPREQNORMATIVOTTICOL4, t2.TTINOMBREE TIPREQNORMATIVOTTINOMBREE, t2.TTINOMBREI TIPREQNORMATIVOTTINOMBREI, t2.TTINOMBREF TIPREQNORMATIVOTTINOMBREF, t2.TTINOCOE TIPREQNORMATIVOTTINOCOE, t2.TTINOCOI TIPREQNORMATIVOTTINOCOI, t2.TTINOCOF TIPREQNORMATIVOTTINOCOF, t2.TTITEDEE TIPREQNORMATIVOTTITEDEE, t2.TTITEDEI TIPREQNORMATIVOTTITEDEI, t2.TTITEDEF TIPREQNORMATIVOTTITEDEF, t2.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO, t2.TTINOMBREA TIPREQNORMATIVOTTINOMBREA, t2.TTINOCOA TIPREQNORMATIVOTTINOCOA, t2.TTITEDEA TIPREQNORMATIVOTTITEDEA, t2.TTICOE7 TIPREQNORMATIVOTTICOE7, t2.TTICOINC TIPREQNORMATIVOTTICOINC, t3.ALCODIGO ALERTAALCODIGO, t3.ALCOOR ALERTAALCOOR, t3.ALNRAN ALERTAALNRAN, t3.ALNROR ALERTAALNROR, t3.ALFEEN ALERTAALFEEN, t3.ALFEPLRR ALERTAALFEPLRR, t3.ALNOPRSE ALERTAALNOPRSE, t3.ALNRLOPS ALERTAALNRLOPS, t3.ALNOMAPS ALERTAALNOMAPS, t3.ALNOMOPS ALERTAALNOMOPS, t3.ALFEDUMI ALERTAALFEDUMI, t3.ALFERRIN ALERTAALFERRIN, t3.ALINRE ALERTAALINRE, t3.ALFECOOR ALERTAALFECOOR, t3.ALCOTMO ALERTAALCOTMO, t3.ALCOCA ALERTAALCOCA, t3.ALCOPS ALERTAALCOPS, t3.ALCOTOP ALERTAALCOTOP, t3.ALCOPA ALERTAALCOPA, t3.ALCOES ALERTAALCOES "
				+ "FROM INFRAC_ALERTA t1 , TIP_REQ_NORMATIVO t2 , ALERTA t3  "
				+ "WHERE t1.IACODIGO = ?   AND t1.IACOTTI= t2.TTICODIGO(+) AND t1.IACOAL= t3.ALCODIGO(+)  ";
		return (InfracAlerta) this.jdbcTemplate.queryForObject(query, rwMap,
				infracalerta.getIacodigo());
	}

	/**
	 * Removes a single row in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            Pagination
	 * @return
	 */
	public void remove(InfracAlerta infracalerta) {
		String query = "DELETE  FROM INFRAC_ALERTA WHERE IACODIGO=?";
		this.jdbcTemplate.update(query, infracalerta.getIacodigo());
	}

	/**
	 * Finds a List of rows in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            InfracAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfracAlerta> findAll(InfracAlerta infracalerta,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.IACOTTI= t2.TTICODIGO(+) AND t1.IACOAL= t3.ALCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IACODIGO IACODIGO,t2.TTICODIGO TIPREQNORMATIVOTTICODIGO,t2.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t2.TTINOCO TIPREQNORMATIVOTTINOCO,t2.TTITEDE TIPREQNORMATIVOTTITEDE,t2.TTICOSE TIPREQNORMATIVOTTICOSE,t2.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t2.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t2.TTICOL4 TIPREQNORMATIVOTTICOL4,t2.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t2.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t2.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t2.TTINOCOE TIPREQNORMATIVOTTINOCOE,t2.TTINOCOI TIPREQNORMATIVOTTINOCOI,t2.TTINOCOF TIPREQNORMATIVOTTINOCOF,t2.TTITEDEE TIPREQNORMATIVOTTITEDEE,t2.TTITEDEI TIPREQNORMATIVOTTITEDEI,t2.TTITEDEF TIPREQNORMATIVOTTITEDEF,t2.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t2.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t2.TTINOCOA TIPREQNORMATIVOTTINOCOA,t2.TTITEDEA TIPREQNORMATIVOTTITEDEA,t2.TTICOE7 TIPREQNORMATIVOTTICOE7,t2.TTICOINC TIPREQNORMATIVOTTICOINC,t3.ALCODIGO ALERTAALCODIGO,t3.ALCOOR ALERTAALCOOR,t3.ALNRAN ALERTAALNRAN,t3.ALNROR ALERTAALNROR,t3.ALFEEN ALERTAALFEEN,t3.ALFEPLRR ALERTAALFEPLRR,t3.ALNOPRSE ALERTAALNOPRSE,t3.ALNRLOPS ALERTAALNRLOPS,t3.ALNOMAPS ALERTAALNOMAPS,t3.ALNOMOPS ALERTAALNOMOPS,t3.ALFEDUMI ALERTAALFEDUMI,t3.ALFERRIN ALERTAALFERRIN,t3.ALINRE ALERTAALINRE,t3.ALFECOOR ALERTAALFECOOR,t3.ALCOTMO ALERTAALCOTMO,t3.ALCOCA ALERTAALCOCA,t3.ALCOPS ALERTAALCOPS,t3.ALCOTOP ALERTAALCOTOP,t3.ALCOPA ALERTAALCOPA,t3.ALCOES ALERTAALCOES "
						+ "FROM INFRAC_ALERTA t1 ,TIP_REQ_NORMATIVO t2 ,ALERTA t3 ");

		if (infracalerta != null && infracalerta.getIacodigo() != null) {
			where.append(" AND t1.IACODIGO = ?");
			params.add(infracalerta.getIacodigo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t2.TTICODIGO = ?");
			params.add(infracalerta.getTipReqNormativo().getTticodigo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t2.TTINOMBRE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombre());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t2.TTINOCO = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinoco());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t2.TTITEDE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitede());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t2.TTICOSE = ?");
			params.add(infracalerta.getTipReqNormativo().getTticose());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t2.TTINOCO2 = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinoco2());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t2.TTIINSEL1 = ?");
			params.add(infracalerta.getTipReqNormativo().getTtiinsel1());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t2.TTICOL4 = ?");
			params.add(infracalerta.getTipReqNormativo().getTticol4());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t2.TTINOMBREE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombree());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t2.TTINOMBREI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombrei());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t2.TTINOMBREF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombref());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t2.TTINOCOE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoe());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t2.TTINOCOI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoi());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t2.TTINOCOF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocof());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t2.TTITEDEE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedee());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t2.TTITEDEI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedei());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t2.TTITEDEF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedef());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t2.TTICODGRUPO = ?");
			params.add(infracalerta.getTipReqNormativo().getTticodgrupo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t2.TTINOMBREA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombrea());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t2.TTINOCOA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoa());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t2.TTITEDEA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedea());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t2.TTICOE7 = ?");
			params.add(infracalerta.getTipReqNormativo().getTticoe7());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t2.TTICOINC = ?");
			params.add(infracalerta.getTipReqNormativo().getTticoinc());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t3.ALCODIGO = ?");
			params.add(infracalerta.getAlerta().getAlcodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getComaut() != null
				&& infracalerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t3.ALCOCA = ?");
			params.add(infracalerta.getAlerta().getComaut().getCacodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getProducto() != null
				&& infracalerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t3.ALCOPS = ?");
			params.add(infracalerta.getAlerta().getProducto().getPscodigo());
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getTipOrigenProd() != null
				&& infracalerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t3.ALCOTOP = ?");
			params.add(infracalerta.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getPais() != null
				&& infracalerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t3.ALCOPA = ?");
			params.add(infracalerta.getAlerta().getPais().getPacodigo());
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getEstablecimiento() != null
				&& infracalerta.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ALCOES = ?");
			params.add(infracalerta.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcoor() != null) {
			where.append(" AND t3.ALCOOR = ?");
			params.add(infracalerta.getAlerta().getAlcoor());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnran() != null) {
			where.append(" AND t3.ALNRAN = ?");
			params.add(infracalerta.getAlerta().getAlnran());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnror() != null) {
			where.append(" AND t3.ALNROR = ?");
			params.add(infracalerta.getAlerta().getAlnror());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t3.ALFEEN = ?");
			params.add(infracalerta.getAlerta().getAlfeen());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t3.ALFEPLRR = ?");
			params.add(infracalerta.getAlerta().getAlfeplrr());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND t3.ALNOPRSE = ?");
			params.add(infracalerta.getAlerta().getAlnoprse());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND t3.ALNRLOPS = ?");
			params.add(infracalerta.getAlerta().getAlnrlops());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND t3.ALNOMAPS = ?");
			params.add(infracalerta.getAlerta().getAlnomaps());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomops() != null) {
			where.append(" AND t3.ALNOMOPS = ?");
			params.add(infracalerta.getAlerta().getAlnomops());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t3.ALFEDUMI = ?");
			params.add(infracalerta.getAlerta().getAlfedumi());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAltein() != null) {
			where.append(" AND t3.ALTEIN = ?");
			params.add(infracalerta.getAlerta().getAltein());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t3.ALFERRIN = ?");
			params.add(infracalerta.getAlerta().getAlferrin());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlinre() != null) {
			where.append(" AND t3.ALINRE = ?");
			params.add(infracalerta.getAlerta().getAlinre());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t3.ALFECOOR = ?");
			params.add(infracalerta.getAlerta().getAlfecoor());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND t3.ALCOTMO = ?");
			params.add(infracalerta.getAlerta().getAlcotmo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<InfracAlerta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the InfracAlerta table.
	 * 
	 * @param infracalerta
	 *            InfracAlerta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(InfracAlerta infracalerta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.IACOTTI= t2.TTICODIGO(+) and t1.IACOAL= t3.ALCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  INFRAC_ALERTA t1   ,  TIP_REQ_NORMATIVO t2   ,  ALERTA t3  ");
		if (infracalerta != null && infracalerta.getIacodigo() != null) {
			where.append(" AND t1.IACODIGO = ?");
			params.add(infracalerta.getIacodigo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t2.TTICODIGO = ?");
			params.add(infracalerta.getTipReqNormativo().getTticodigo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t2.TTINOMBRE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombre());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t2.TTINOCO = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinoco());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t2.TTITEDE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitede());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t2.TTICOSE = ?");
			params.add(infracalerta.getTipReqNormativo().getTticose());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t2.TTINOCO2 = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinoco2());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t2.TTIINSEL1 = ?");
			params.add(infracalerta.getTipReqNormativo().getTtiinsel1());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t2.TTICOL4 = ?");
			params.add(infracalerta.getTipReqNormativo().getTticol4());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t2.TTINOMBREE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombree());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t2.TTINOMBREI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombrei());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t2.TTINOMBREF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombref());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t2.TTINOCOE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoe());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t2.TTINOCOI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoi());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t2.TTINOCOF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocof());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t2.TTITEDEE = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedee());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t2.TTITEDEI = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedei());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t2.TTITEDEF = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedef());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t2.TTICODGRUPO = ?");
			params.add(infracalerta.getTipReqNormativo().getTticodgrupo());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t2.TTINOMBREA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinombrea());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t2.TTINOCOA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtinocoa());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t2.TTITEDEA = ?");
			params.add(infracalerta.getTipReqNormativo().getTtitedea());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t2.TTICOE7 = ?");
			params.add(infracalerta.getTipReqNormativo().getTticoe7());
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t2.TTICOINC = ?");
			params.add(infracalerta.getTipReqNormativo().getTticoinc());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t3.ALCODIGO = ?");
			params.add(infracalerta.getAlerta().getAlcodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getComaut() != null
				&& infracalerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t3.ALCOCA = ?");
			params.add(infracalerta.getAlerta().getComaut().getCacodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getProducto() != null
				&& infracalerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t3.ALCOPS = ?");
			params.add(infracalerta.getAlerta().getProducto().getPscodigo());
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getTipOrigenProd() != null
				&& infracalerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t3.ALCOTOP = ?");
			params.add(infracalerta.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getPais() != null
				&& infracalerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t3.ALCOPA = ?");
			params.add(infracalerta.getAlerta().getPais().getPacodigo());
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getEstablecimiento() != null
				&& infracalerta.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ALCOES = ?");
			params.add(infracalerta.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcoor() != null) {
			where.append(" AND t3.ALCOOR = ?");
			params.add(infracalerta.getAlerta().getAlcoor());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnran() != null) {
			where.append(" AND t3.ALNRAN = ?");
			params.add(infracalerta.getAlerta().getAlnran());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnror() != null) {
			where.append(" AND t3.ALNROR = ?");
			params.add(infracalerta.getAlerta().getAlnror());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t3.ALFEEN = ?");
			params.add(infracalerta.getAlerta().getAlfeen());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t3.ALFEPLRR = ?");
			params.add(infracalerta.getAlerta().getAlfeplrr());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND t3.ALNOPRSE = ?");
			params.add(infracalerta.getAlerta().getAlnoprse());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND t3.ALNRLOPS = ?");
			params.add(infracalerta.getAlerta().getAlnrlops());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND t3.ALNOMAPS = ?");
			params.add(infracalerta.getAlerta().getAlnomaps());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomops() != null) {
			where.append(" AND t3.ALNOMOPS = ?");
			params.add(infracalerta.getAlerta().getAlnomops());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t3.ALFEDUMI = ?");
			params.add(infracalerta.getAlerta().getAlfedumi());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAltein() != null) {
			where.append(" AND t3.ALTEIN = ?");
			params.add(infracalerta.getAlerta().getAltein());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t3.ALFERRIN = ?");
			params.add(infracalerta.getAlerta().getAlferrin());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlinre() != null) {
			where.append(" AND t3.ALINRE = ?");
			params.add(infracalerta.getAlerta().getAlinre());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t3.ALFECOOR = ?");
			params.add(infracalerta.getAlerta().getAlfecoor());
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND t3.ALCOTMO = ?");
			params.add(infracalerta.getAlerta().getAlcotmo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the InfracAlerta table using like.
	 * 
	 * @param infracalerta
	 *            InfracAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<InfracAlerta> findAllLike(InfracAlerta infracalerta,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.IACOTTI= t2.TTICODIGO(+) AND t1.IACOAL= t3.ALCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.IACODIGO IACODIGO,t2.TTICODIGO TIPREQNORMATIVOTTICODIGO,t2.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t2.TTINOCO TIPREQNORMATIVOTTINOCO,t2.TTITEDE TIPREQNORMATIVOTTITEDE,t2.TTICOSE TIPREQNORMATIVOTTICOSE,t2.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t2.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t2.TTICOL4 TIPREQNORMATIVOTTICOL4,t2.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t2.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t2.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t2.TTINOCOE TIPREQNORMATIVOTTINOCOE,t2.TTINOCOI TIPREQNORMATIVOTTINOCOI,t2.TTINOCOF TIPREQNORMATIVOTTINOCOF,t2.TTITEDEE TIPREQNORMATIVOTTITEDEE,t2.TTITEDEI TIPREQNORMATIVOTTITEDEI,t2.TTITEDEF TIPREQNORMATIVOTTITEDEF,t2.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t2.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t2.TTINOCOA TIPREQNORMATIVOTTINOCOA,t2.TTITEDEA TIPREQNORMATIVOTTITEDEA,t2.TTICOE7 TIPREQNORMATIVOTTICOE7,t2.TTICOINC TIPREQNORMATIVOTTICOINC,t3.ALCODIGO ALERTAALCODIGO,t3.ALCOOR ALERTAALCOOR,t3.ALNRAN ALERTAALNRAN,t3.ALNROR ALERTAALNROR,t3.ALFEEN ALERTAALFEEN,t3.ALFEPLRR ALERTAALFEPLRR,t3.ALNOPRSE ALERTAALNOPRSE,t3.ALNRLOPS ALERTAALNRLOPS,t3.ALNOMAPS ALERTAALNOMAPS,t3.ALNOMOPS ALERTAALNOMOPS,t3.ALFEDUMI ALERTAALFEDUMI,t3.ALFERRIN ALERTAALFERRIN,t3.ALINRE ALERTAALINRE,t3.ALFECOOR ALERTAALFECOOR,t3.ALCOTMO ALERTAALCOTMO,t3.ALCOCA ALERTAALCOCA,t3.ALCOPS ALERTAALCOPS,t3.ALCOTOP ALERTAALCOTOP,t3.ALCOPA ALERTAALCOPA,t3.ALCOES ALERTAALCOES "
						+ "FROM INFRAC_ALERTA t1 ,TIP_REQ_NORMATIVO t2 ,ALERTA t3 ");

		if (infracalerta != null && infracalerta.getIacodigo() != null) {
			where.append(" AND UPPER(t1.IACODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getIacodigo().toUpperCase() + "%");
			} else {
				params.add("%" + infracalerta.getIacodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.IACODIGO IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t2.TTICODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticodigo()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticodigo()
						+ "%");
			}
			where.append(" AND t2.TTICODIGO IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND UPPER(t2.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOMBRE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND UPPER(t2.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCO IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND UPPER(t2.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtitede()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtitede()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTITEDE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticose() != null) {
			where.append(" AND UPPER(t2.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticose()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTICOSE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND UPPER(t2.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinoco2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinoco2()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCO2 IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND UPPER(t2.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtiinsel1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtiinsel1()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTIINSEL1 IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND UPPER(t2.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticol4()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticol4()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTICOL4 IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND UPPER(t2.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOMBREE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND UPPER(t2.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinombrei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinombrei()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOMBREI IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND UPPER(t2.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinombref()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinombref()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOMBREF IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND UPPER(t2.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinocoe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinocoe()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCOE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND UPPER(t2.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinocoi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinocoi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCOI IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND UPPER(t2.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinocof()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinocof()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCOF IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND UPPER(t2.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtitedee()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtitedee()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTITEDEE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND UPPER(t2.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtitedei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtitedei()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTITEDEI IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND UPPER(t2.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtitedef()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtitedef()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTITEDEF IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND UPPER(t2.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticodgrupo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticodgrupo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTICODGRUPO IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND UPPER(t2.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinombrea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinombrea()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOMBREA IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND UPPER(t2.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtinocoa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtinocoa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTINOCOA IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND UPPER(t2.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTtitedea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTtitedea()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTITEDEA IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND UPPER(t2.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticoe7()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticoe7()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTICOE7 IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getTipReqNormativo() != null
				&& infracalerta.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND UPPER(t2.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getTipReqNormativo().getTticoinc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getTipReqNormativo().getTticoinc()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TTICOINC IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t3.ALCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlcodigo() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlcodigo() + "%");
			}
			where.append(" AND t3.ALCODIGO IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getComaut() != null
				&& infracalerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND UPPER(t3.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getComaut().getCacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getComaut().getCacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ALCOCA IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getProducto() != null
				&& infracalerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t3.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getProducto().getPscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getProducto().getPscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ALCOPS IS NOT NULL");
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getTipOrigenProd() != null
				&& infracalerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND UPPER(t3.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getTipOrigenProd()
						.getTopcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getTipOrigenProd()
								.getTopcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ALCOTOP IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getPais() != null
				&& infracalerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND UPPER(t3.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getPais().getPacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getPais().getPacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ALCOPA IS NOT NULL");
		}
		if (infracalerta != null
				&& infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getEstablecimiento() != null
				&& infracalerta.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t3.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ALCOES IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t3.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALCOOR IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnran() != null) {
			where.append(" AND t3.ALNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnran() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlnran() + "%");
			}
			where.append(" AND t3.ALNRAN IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t3.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnror().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALNROR IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t3.ALFEEN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlfeen() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlfeen() + "%");
			}
			where.append(" AND t3.ALFEEN IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t3.ALFEPLRR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlfeplrr() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlfeplrr() + "%");
			}
			where.append(" AND t3.ALFEPLRR IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t3.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALNOPRSE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t3.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALNRLOPS IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t3.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALNOMAPS IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t3.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALNOMOPS IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t3.ALFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlfedumi() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlfedumi() + "%");
			}
			where.append(" AND t3.ALFEDUMI IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t3.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAltein().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAltein().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALTEIN IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t3.ALFERRIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlferrin() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlferrin() + "%");
			}
			where.append(" AND t3.ALFERRIN IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t3.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALINRE IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t3.ALFECOOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlfecoor() + "%");
			} else {
				params.add("%" + infracalerta.getAlerta().getAlfecoor() + "%");
			}
			where.append(" AND t3.ALFECOOR IS NOT NULL");
		}
		if (infracalerta != null && infracalerta.getAlerta() != null
				&& infracalerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t3.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(infracalerta.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ infracalerta.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ALCOTMO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<InfracAlerta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
