package com.ejie.y41a.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

/**
 * HistoricoDaoImpl generated by UDA, 16-dic-2013 9:50:02.
 * 
 *  
 */

@Repository
@Transactional
public class HistoricoDaoImpl implements HistoricoDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Updates a single row in the Historico table.
	 * 
	 * @param escodigoBueno
	 *            Pagination
	 * @param escodigoAfusionar
	 *            Pagination
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		String query = "UPDATE HISTORICO SET SHIDESTABLECIMIENTO=? WHERE SHIDESTABLECIMIENTO=?";
		this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
	}

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
