package com.ejie.y41a.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.ConsumidorReclamaciones;
import com.ejie.y41a.model.EstablecimientoDecisionAnyo;
import com.ejie.y41a.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.PlantillaSolicitudDetalle;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.model.SolicitudDetalle;
import com.ejie.y41a.model.TramiteHechoDetalle;

/**
 * * HechoDenunciadoDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface HechoDenunciadoDao {

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado add(HechoDenunciado hechodenunciado);

	/**
	 * Inserts a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado addHechoDenunciado(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado update(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado updateEstablecimiento(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	HechoDenunciado updateIndicadorArbitraje(HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateExpedienteTrasladoKonbide(
			HechoDenunciado hechodenunciado);

	/**
	 * Updates a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            Pagination
	 * @return HechoDenunciado
	 */
	public HechoDenunciado updateInstructor(HechoDenunciado hechodenunciado);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	HechoDenunciado find(HechoDenunciado hechodenunciado);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findSolicitud(SolicitudDetalle solicitudDetalle);

	/**
	 * Deletes a single row in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return
	 */
	void remove(HechoDenunciado hechodenunciado);

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HechoDenunciado> findAllHechosEstablecimiento(
			HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Finds a List of rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<HechoDenunciado> findAll(HechoDenunciado hechodenunciado,
			Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return List
	 */
	Long findAllCount(HechoDenunciado hechodenunciado);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return List
	 */
	Long findAllExpedientesAbiertosCount(HechoDenunciado hechodenunciado);

	/**
	 * Finds rows in the HechoDenunciado table using like.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<HechoDenunciado> findAllLike(HechoDenunciado hechodenunciado,
			Pagination pagination, Boolean startsWith);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoReclamacionesAnyo> findAllEstablecimientoReclamacionesAnyo(
			HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllEstablecimientoReclamacionesAnyoCount(
			HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con el numero de reclamaciones de un establecimiento
	 * por decision y por año.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<EstablecimientoDecisionAnyo> findAllEstablecimientoDecisionAnyo(
			HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllEstablecimientoDecisionAnyoCount(HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con las reclamaciones de un consumidor.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<ConsumidorReclamaciones> findAllConsumidorReclamaciones(
			HechoDenunciado hechodenunciado, Pagination pagination);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param hechodenunciado
	 *            HechoDenunciado
	 * @return Long
	 */
	Long findAllConsumidorReclamacionesCount(HechoDenunciado hechodenunciado);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<SolicitudBusqueda> findAllLikeSolicitudes(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Counts rows in the HechoDenunciado table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return Long
	 */
	Long findAllLikeSolicitudesCount(SolicitudBusqueda solicitudesBusqueda,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Finds a single row in the Tramite Hecho table.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return TramiteHechoDetalle
	 */
	TramiteHechoDetalle findUltimoTramite(SolicitudBusqueda solicitudesBusqueda);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return PlantillaSolicitudDetalle
	 */
	PlantillaSolicitudDetalle findPlantillaSolicitudDetalle(
			SolicitudDetalle solicitudDetalle);

	/**
	 * Finds a single row in the HechoDenunciado table.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * @return SolicitudDetalle
	 */
	SolicitudDetalle findLobTablaTemporal(SolicitudDetalle solicitudDetalle);

}