package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Y41aGrupoOrganismoTree;
import com.ejie.y41a.model.Y41aOrganismoTree;

/**
 * * GruposDaoImpl generated by UDA 1.0, 08-jun-2011 12:15:12.
 * 
 *  
 */
@Repository
@Transactional
public class GrupoOrganismoDaoImpl implements GrupoOrganismoDao {
	private static final Logger logger = LoggerFactory
			.getLogger(GrupoOrganismoDaoImpl.class);

	private SimpleJdbcTemplate jdbcTemplate;

	private RowMapper<Y41aGrupoOrganismoTree> rwMap = new RowMapper<Y41aGrupoOrganismoTree>() {
		public Y41aGrupoOrganismoTree mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Y41aGrupoOrganismoTree(resultSet.getString("GRUPOID"),
					null, resultSet.getString("NOMBREES"),
					resultSet.getString("NOMBREEU"),
					resultSet.getString("GRUPOPADREID"),
					resultSet.getString("ACTIVA"));
		}
	};

	private RowMapper<Y41aOrganismoTree> rwMapOrg = new RowMapper<Y41aOrganismoTree>() {
		public Y41aOrganismoTree mapRow(ResultSet resultSet, int rowNum) {
			Y41aOrganismoTree org = new Y41aOrganismoTree();
			try {
				org.setGrupoId(resultSet.getString(1));
				org.setCodOrg(resultSet.getString(2));
				org.setNombreEs(resultSet.getString(3));
				org.setNombreEu(resultSet.getString(4));
				org.setActiva(resultSet.getString(5));
			} catch (Exception e) {
				e.printStackTrace();
			}
			return org;

		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * 
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
		// this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the Grupos table.
	 * 
	 * @param grupo
	 *            Y42bGrupo
	 * @return Grupo
	 */
	@Transactional(readOnly = true)
	public Y41aGrupoOrganismoTree find(Y41aGrupoOrganismoTree grupo) {

		String query = "SELECT t1.GRUPO_ID GRUPOID, t1.NIVEL NIVEL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.GRUPO_PADRE_ID GRUPOPADREID, t1.ACTIVA "
				+ "FROM GRUPOORGANISMO t1  "
				+ "WHERE 1 = 1  AND t1.GRUPO_ID = ? ";

		try {
			return (Y41aGrupoOrganismoTree) this.jdbcTemplate.queryForObject(
					query, rwMap, grupo.getGrupoId());
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Grupos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<Y41aGrupoOrganismoTree> findAll(Y41aGrupoOrganismoTree grupo,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT t1.GRUPO_ID GRUPOID, t1.NIVEL NIVEL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.GRUPO_PADRE_ID GRUPOPADREID, t1.ACTIVA "
						+ "FROM GRUPOORGANISMO t1 ");

		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_ID = ?");
			params.add(grupo.getGrupoId());
		}

		if (grupo != null && grupo.getPadreId() == null) {
			where.append(" AND (");
			where.append("t1.GRUPO_PADRE_ID IS NULL");
			where.append(" OR ");
			where.append("t1.GRUPO_PADRE_ID = '0')");
		}

		where.append(" AND t1.ACTIVA = ? ");
		params.add(Y41aConstantes.VALOR_SI);

		where.append(" AND t1.GRUPO_ID <> ? ");
		params.add(Y41aConstantes.GRUPO_RAIZ_ID);

		query.append(where);

		return (List<Y41aGrupoOrganismoTree>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());

	}

	/**
	 * Finds a List of rows in the Grupos table.
	 * 
	 * @param grupo
	 *            Y41aGrupoOrganismoTree
	 * @return List
	 */

	@Transactional(readOnly = true)
	public List<Y41aGrupoOrganismoTree> findAllChildren(
			Y41aGrupoOrganismoTree grupo) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT t1.GRUPO_ID GRUPOID, t1.NIVEL NIVEL, t1.NOMBRE_ES NOMBREES, t1.NOMBRE_EU NOMBREEU, t1.GRUPO_PADRE_ID GRUPOPADREID, t1.ACTIVA "
						+ "FROM GRUPOORGANISMO t1 ");

		/**
		 * Busca hijos
		 */
		if (grupo != null && grupo.getGrupoId() != null) {
			where.append(" AND t1.GRUPO_PADRE_ID = ?");
			params.add(grupo.getGrupoId());
		}

		query.append(where);

		return (List<Y41aGrupoOrganismoTree>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());

	}

	/**
	 * Find a single row in the findGrupoEntidad Many To Many relationship.
	 * 
	 * @param grupo
	 *            Y41aGrupoOrganismoTree
	 * @param entidad
	 *            Y41aOrganismoTree
	 * @param pagination
	 *            Pagination
	 * @return Y41aGrupoOrganismoTree
	 */
	@Transactional(readOnly = true)
	public Y41aGrupoOrganismoTree findGrupoEntidad(
			Y41aGrupoOrganismoTree grupo, Y41aOrganismoTree organismo,
			Pagination pagination) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ENTIDAD_ID = t2.ENTIDAD_ID AND t2.COD_ORG IS NOT NULL AND t2.ISKONTSUMONET = '");
		where.append(Y41aConstantes.VALOR_SI);
		where.append("' AND t1.GRUPO_ID = '");
		where.append(grupo.getGrupoId());
		where.append("'");
		/*
		 * where.append(" AND t2.ORINBDCO  = '");
		 * where.append(Y41aConstantes.VALOR_SI); where.append("'");
		 */

		if (organismo.getActiva() != null) {
			where.append(" AND t2.ACTIVA = '");
			where.append(organismo.getActiva());
			where.append("'");
		}
		if (organismo.getCodOrg() != null) {
			where.append(" AND t2.COD_ORG != '");
			where.append(organismo.getCodOrg());
			where.append("'");
		}

		StringBuffer query = new StringBuffer(
				"SELECT t1.GRUPO_ID, t2.COD_ORG, t2.nombre_Es, t2.nombre_Eu, t2.ACTIVA "
						+ "FROM GRUPOS_ENTIDADES t1, ORGANISMO t2 ");

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {

				order.append(" ORDER BY NLSSORT(UPPER(" + pagination.getSort()
						+ "), 'NLS_SORT=SPANISH') " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		List<Y41aOrganismoTree> listaHijo = this.jdbcTemplate.query(
				query.toString(), rwMapOrg, params.toArray());
		grupo.setEntidads(listaHijo);

		logger.debug("SQL: " + query.toString());
		logger.debug("Hijos: " + listaHijo.size());

		return grupo;
	}

	/**
	 * Counts rows in the Grupo table.
	 * 
	 * @param y41aGrupoOrganismoTree
	 *            Y41aGrupoOrganismoTree
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long countEntidadesKontsumonet(
			Y41aGrupoOrganismoTree y41aGrupoOrganismoTree) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND tt1.ENTIDAD_ID= tt2.ENTIDAD_ID AND tt2.GRUPO_ID = tt3.GRUPO_ID AND tt2.grupo_id=? AND tt3.ACTIVA = ? AND tt1.ACTIVA = ? AND tt1.COD_ORG IS NOT NULL AND tt1.ISKONTSUMONET=? ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM ORGANISMO tt1, GRUPOS_ENTIDADES tt2, GRUPOORGANISMO tt3   ");

		params.add(y41aGrupoOrganismoTree.getGrupoId());
		params.add(Y41aConstantes.SI);
		params.add(Y41aConstantes.SI);
		params.add(Y41aConstantes.SI);

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
