package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FormasVenta;

/**
 *  * FormasVentaDaoImpl generated by UDA, 19-ene-2016 11:45:24.
 *  
 */
 
@Repository
@Transactional
public class FormasVentaDaoImpl implements FormasVentaDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<FormasVenta> rwMap = new RowMapper<FormasVenta>() {
		public FormasVenta mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new FormasVenta(
               resultSet.getString("FVCODIGO"), resultSet.getString("FVNOMBRE"), resultSet.getString("FVNOMBREE")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
	public FormasVenta add(FormasVenta formasventa) {

    	String query = "INSERT INTO FORMAS_VENTA( FVCODIGO,FVNOMBRE,FVNOMBREE)"
        + "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, formasventa.getFvcodigo(), formasventa.getFvnombre(), formasventa.getFvnombree());
		return formasventa;
	}

    /**
     * Updates a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
    public FormasVenta update(FormasVenta formasventa) {
		String query = "UPDATE FORMAS_VENTA SET FVNOMBRE=?,FVNOMBREE=? WHERE FVCODIGO=?";
		this.jdbcTemplate.update(query, formasventa.getFvnombre(), formasventa.getFvnombree(), formasventa.getFvcodigo());
		return formasventa;
	}

    /**
     * Finds a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return FormasVenta
     */
    @Transactional (readOnly = true)
    public FormasVenta find(FormasVenta formasventa) {
		String query = "SELECT t1.FVCODIGO FVCODIGO, t1.FVNOMBRE FVNOMBRE, t1.FVNOMBREE FVNOMBREE " 
         + "FROM FORMAS_VENTA t1  " 
         + "WHERE t1.FVCODIGO = ?    ";
		return (FormasVenta) this.jdbcTemplate.queryForObject(query, 
			rwMap , formasventa.getFvcodigo());	 
    }

    /**
     * Removes a single row in the FormasVenta table.
     *
     * @param formasventa Pagination
     * @return
     */
    public void remove(FormasVenta formasventa) {
		String query = "DELETE  FROM FORMAS_VENTA WHERE FVCODIGO=?";
		this.jdbcTemplate.update(query, formasventa.getFvcodigo());
    	}
    
   /**
    * Finds a List of rows in the FormasVenta table.
    * 
    * @param formasventa FormasVenta
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<FormasVenta> findAll(FormasVenta formasventa, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.FVCODIGO FVCODIGO,t1.FVNOMBRE FVNOMBRE,t1.FVNOMBREE FVNOMBREE " 
			+ "FROM FORMAS_VENTA t1 ");
		
		if (formasventa  != null  && formasventa.getFvcodigo() != null ) {
			where.append(" AND t1.FVCODIGO = ?");
			params.add(formasventa.getFvcodigo());
		}
		if (formasventa  != null  && formasventa.getFvnombre() != null ) {
			where.append(" AND t1.FVNOMBRE = ?");
			params.add(formasventa.getFvnombre());
		}
		if (formasventa  != null  && formasventa.getFvnombree() != null ) {
			where.append(" AND t1.FVNOMBREE = ?");
			params.add(formasventa.getFvnombree());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<FormasVenta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the FormasVenta table.
     * 
     * @param formasventa FormasVenta
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(FormasVenta formasventa) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  FORMAS_VENTA t1  ");
		if (formasventa  != null  && formasventa.getFvcodigo() != null ) {
			where.append(" AND t1.FVCODIGO = ?");
			params.add(formasventa.getFvcodigo());
		}
		if (formasventa  != null  && formasventa.getFvnombre() != null ) {
			where.append(" AND t1.FVNOMBRE = ?");
			params.add(formasventa.getFvnombre());
		}
		if (formasventa  != null  && formasventa.getFvnombree() != null ) {
			where.append(" AND t1.FVNOMBREE = ?");
			params.add(formasventa.getFvnombree());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the FormasVenta table using like.
     * 
     * @param formasventa FormasVenta
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<FormasVenta> findAllLike(FormasVenta formasventa, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.FVCODIGO FVCODIGO,t1.FVNOMBRE FVNOMBRE,t1.FVNOMBREE FVNOMBREE " 
        	+ "FROM FORMAS_VENTA t1 ");
      	
		if (formasventa  != null  && formasventa.getFvcodigo() != null ) {
			where.append(" AND UPPER(t1.FVCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+formasventa.getFvcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.FVCODIGO IS NOT NULL");
        }
		if (formasventa  != null  && formasventa.getFvnombre() != null ) {
			where.append(" AND UPPER(t1.FVNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+formasventa.getFvnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.FVNOMBRE IS NOT NULL");
        }
		if (formasventa  != null  && formasventa.getFvnombree() != null ) {
			where.append(" AND UPPER(t1.FVNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formasventa.getFvnombree().toUpperCase()  +"%");
			}else{
				params.add("%"+formasventa.getFvnombree().toUpperCase() +"%");
			}	
			where.append(" AND t1.FVNOMBREE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<FormasVenta>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

