package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FormaPresentacion;

/**
 *  * FormaPresentacionDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class FormaPresentacionDaoImpl implements FormaPresentacionDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<FormaPresentacion> rwMap = new RowMapper<FormaPresentacion>() {
		public FormaPresentacion mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new FormaPresentacion(
               resultSet.getString("TFPCODIGO"), resultSet.getString("TFPNOMBRE"), resultSet.getString("TFPNOMBREE"), resultSet.getString("TFPNOMBREI"), resultSet.getString("TFPNOMBREF"), resultSet.getString("TFPNOMBREA")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the FormaPresentacion table.
     *
     * @param formapresentacion Pagination
     * @return FormaPresentacion
     */
	public FormaPresentacion add(FormaPresentacion formapresentacion) {

    	String query = "INSERT INTO FORMA_PRESENTACION( TFPCODIGO,TFPNOMBRE,TFPNOMBREE,TFPNOMBREI,TFPNOMBREF,TFPNOMBREA)"
        + "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, formapresentacion.getTfpcodigo(), formapresentacion.getTfpnombre(), formapresentacion.getTfpnombree(), formapresentacion.getTfpnombrei(), formapresentacion.getTfpnombref(), formapresentacion.getTfpnombrea());
		return formapresentacion;
	}

    /**
     * Updates a single row in the FormaPresentacion table.
     *
     * @param formapresentacion Pagination
     * @return FormaPresentacion
     */
    public FormaPresentacion update(FormaPresentacion formapresentacion) {
		String query = "UPDATE FORMA_PRESENTACION SET TFPNOMBRE=?,TFPNOMBREE=?,TFPNOMBREI=?,TFPNOMBREF=?,TFPNOMBREA=? WHERE TFPCODIGO=?";
		this.jdbcTemplate.update(query, formapresentacion.getTfpnombre(), formapresentacion.getTfpnombree(), formapresentacion.getTfpnombrei(), formapresentacion.getTfpnombref(), formapresentacion.getTfpnombrea(), formapresentacion.getTfpcodigo());
		return formapresentacion;
	}

    /**
     * Finds a single row in the FormaPresentacion table.
     *
     * @param formapresentacion Pagination
     * @return FormaPresentacion
     */
    @Transactional (readOnly = true)
    public FormaPresentacion find(FormaPresentacion formapresentacion) {
		String query = "SELECT t1.TFPCODIGO TFPCODIGO, t1.TFPNOMBRE TFPNOMBRE, t1.TFPNOMBREE TFPNOMBREE, t1.TFPNOMBREI TFPNOMBREI, t1.TFPNOMBREF TFPNOMBREF, t1.TFPNOMBREA TFPNOMBREA " 
         + "FROM FORMA_PRESENTACION t1  " 
         + "WHERE t1.TFPCODIGO = ?    ";
		return (FormaPresentacion) this.jdbcTemplate.queryForObject(query, 
			rwMap , formapresentacion.getTfpcodigo());	 
    }

    /**
     * Removes a single row in the FormaPresentacion table.
     *
     * @param formapresentacion Pagination
     * @return
     */
    public void remove(FormaPresentacion formapresentacion) {
		String query = "DELETE  FROM FORMA_PRESENTACION WHERE TFPCODIGO=?";
		this.jdbcTemplate.update(query, formapresentacion.getTfpcodigo());
    	}
    
   /**
    * Finds a List of rows in the FormaPresentacion table.
    * 
    * @param formapresentacion FormaPresentacion
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<FormaPresentacion> findAll(FormaPresentacion formapresentacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,t1.TFPNOMBREE TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA " 
			+ "FROM FORMA_PRESENTACION t1 ");
		
		if (formapresentacion  != null  && formapresentacion.getTfpcodigo() != null ) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombre() != null ) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombree() != null ) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombrei() != null ) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombref() != null ) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombrea() != null ) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the FormaPresentacion table.
     * 
     * @param formapresentacion FormaPresentacion
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(FormaPresentacion formapresentacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  FORMA_PRESENTACION t1  ");
		if (formapresentacion  != null  && formapresentacion.getTfpcodigo() != null ) {
			where.append(" AND t1.TFPCODIGO = ?");
			params.add(formapresentacion.getTfpcodigo());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombre() != null ) {
			where.append(" AND t1.TFPNOMBRE = ?");
			params.add(formapresentacion.getTfpnombre());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombree() != null ) {
			where.append(" AND t1.TFPNOMBREE = ?");
			params.add(formapresentacion.getTfpnombree());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombrei() != null ) {
			where.append(" AND t1.TFPNOMBREI = ?");
			params.add(formapresentacion.getTfpnombrei());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombref() != null ) {
			where.append(" AND t1.TFPNOMBREF = ?");
			params.add(formapresentacion.getTfpnombref());
		}
		if (formapresentacion  != null  && formapresentacion.getTfpnombrea() != null ) {
			where.append(" AND t1.TFPNOMBREA = ?");
			params.add(formapresentacion.getTfpnombrea());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the FormaPresentacion table using like.
     * 
     * @param formapresentacion FormaPresentacion
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<FormaPresentacion> findAllLike(FormaPresentacion formapresentacion, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.TFPCODIGO TFPCODIGO,t1.TFPNOMBRE TFPNOMBRE,t1.TFPNOMBREE TFPNOMBREE,t1.TFPNOMBREI TFPNOMBREI,t1.TFPNOMBREF TFPNOMBREF,t1.TFPNOMBREA TFPNOMBREA " 
        	+ "FROM FORMA_PRESENTACION t1 ");
      	
		if (formapresentacion  != null  && formapresentacion.getTfpcodigo() != null ) {
			where.append(" AND UPPER(t1.TFPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPCODIGO IS NOT NULL");
        }
		if (formapresentacion  != null  && formapresentacion.getTfpnombre() != null ) {
			where.append(" AND UPPER(t1.TFPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPNOMBRE IS NOT NULL");
        }
		if (formapresentacion  != null  && formapresentacion.getTfpnombree() != null ) {
			where.append(" AND UPPER(t1.TFPNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpnombree().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpnombree().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPNOMBREE IS NOT NULL");
        }
		if (formapresentacion  != null  && formapresentacion.getTfpnombrei() != null ) {
			where.append(" AND UPPER(t1.TFPNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpnombrei().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpnombrei().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPNOMBREI IS NOT NULL");
        }
		if (formapresentacion  != null  && formapresentacion.getTfpnombref() != null ) {
			where.append(" AND UPPER(t1.TFPNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpnombref().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpnombref().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPNOMBREF IS NOT NULL");
        }
		if (formapresentacion  != null  && formapresentacion.getTfpnombrea() != null ) {
			where.append(" AND UPPER(t1.TFPNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(formapresentacion.getTfpnombrea().toUpperCase()  +"%");
			}else{
				params.add("%"+formapresentacion.getTfpnombrea().toUpperCase() +"%");
			}	
			where.append(" AND t1.TFPNOMBREA IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<FormaPresentacion>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

