package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.FichasSolicitudes;

/**
 * * FichasSolicitudesDaoImpl generated by UDA, 26-ene-2016 17:53:34.
 * 
 *  
 */

@Repository
@Transactional
public class FichasSolicitudesDaoImpl implements FichasSolicitudesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<FichasSolicitudes> rwMap = new RowMapper<FichasSolicitudes>() {
		public FichasSolicitudes mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new FichasSolicitudes(resultSet.getString("FICODIGO"),
					resultSet.getString("FINOMBRE"),
					resultSet.getString("FINOMBREE"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the FichasSolicitudes table.
	 * 
	 * @param fichassolicitudes
	 *            Pagination
	 * @return FichasSolicitudes
	 */
	public FichasSolicitudes add(FichasSolicitudes fichassolicitudes) {

		String query = "INSERT INTO FICHAS_SOLICITUDES( FICODIGO,FINOMBRE,FINOMBREE)"
				+ "VALUES (?,?,?)";

		this.jdbcTemplate.update(query, fichassolicitudes.getFicodigo(),
				fichassolicitudes.getFinombre(),
				fichassolicitudes.getFinombree());
		return fichassolicitudes;
	}

	/**
	 * Finds a List of rows in the FichasSolicitudes table.
	 * 
	 * @param fichassolicitudes
	 *            FichasSolicitudes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<FichasSolicitudes> findAll(FichasSolicitudes fichassolicitudes,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.FICODIGO FICODIGO,t1.FINOMBRE FINOMBRE,t1.FINOMBREE FINOMBREE "
						+ "FROM FICHAS_SOLICITUDES t1 ");

		if (fichassolicitudes != null
				&& fichassolicitudes.getFicodigo() != null) {
			where.append(" AND t1.FICODIGO = ?");
			params.add(fichassolicitudes.getFicodigo());
		}
		if (fichassolicitudes != null
				&& fichassolicitudes.getFinombre() != null) {
			where.append(" AND t1.FINOMBRE = ?");
			params.add(fichassolicitudes.getFinombre());
		}
		if (fichassolicitudes != null
				&& fichassolicitudes.getFinombree() != null) {
			where.append(" AND t1.FINOMBREE = ?");
			params.add(fichassolicitudes.getFinombree());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<FichasSolicitudes>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the FichasSolicitudes table.
	 * 
	 * @param fichassolicitudes
	 *            FichasSolicitudes
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(FichasSolicitudes fichassolicitudes) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  FICHAS_SOLICITUDES t1  ");
		if (fichassolicitudes != null
				&& fichassolicitudes.getFicodigo() != null) {
			where.append(" AND t1.FICODIGO = ?");
			params.add(fichassolicitudes.getFicodigo());
		}
		if (fichassolicitudes != null
				&& fichassolicitudes.getFinombre() != null) {
			where.append(" AND t1.FINOMBRE = ?");
			params.add(fichassolicitudes.getFinombre());
		}
		if (fichassolicitudes != null
				&& fichassolicitudes.getFinombree() != null) {
			where.append(" AND t1.FINOMBREE = ?");
			params.add(fichassolicitudes.getFinombree());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
