package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.EstadisticasSolicitudesResultado;
import com.ejie.y41a.model.ListadoSolicitudResultado;
import com.ejie.y41a.model.SolicitudBusqueda;

/**
 * * EstadisticasListadosSolicitudesDaoImpl generated by UDA, 22-feb-2012
 * 17:30:27.
 * 
 *  
 */

@Repository
public class EstadisticasListadosSolicitudesDaoImpl implements
		EstadisticasListadosSolicitudesDao {

	private static final Logger logger = LoggerFactory
			.getLogger(EstadisticasListadosSolicitudesDaoImpl.class);

	// @Autowired
	// private DataSource dataSource;
	private SimpleJdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND HCFEDE IS NOT NULL AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(t9.DENOMBRE,'INDEF') AS FILAS, NVL(t9.DENOMBREE,'INDEF') AS FILASE, NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append(" GROUP BY  NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF'))");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF'))");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaDecisionMunicipioConsumidor Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND HCFEDE IS NOT NULL AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(t9.DENOMBRE,'INDEF') AS FILAS, NVL(t9.DENOMBREE,'INDEF') AS FILASE,	NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(distinct t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append(" GROUP BY  NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'),NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF'))");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'),NVL(t3.DTNOMBRE_MUNICIPIO, DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaDecisionMunicipioConsumidor Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(t11.SENOMBRE,'INDEF') AS FILAS, NVL(t11.SENOMBREE,'INDEF') AS FILASE, NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append(" GROUP BY NVL(t11.SENOMBRE,'INDEF'), NVL(t11.SENOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t11.SENOMBRE,'INDEF'), NVL(t11.SENOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaMotivos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaMotivos Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(t12.PSNOMBRE,'INDEF') AS FILAS, NVL(t12.PSNOMBREE,'INDEF') AS FILASE, NVL(t13.TIRNOMBRE,'INDEF') AS FILAS2, COUNT(distinct t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY  NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'),NVL(t13.TIRNOMBRE,'INDEF') ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'),NVL(t13.TIRNOMBRE,'INDEF') ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											resultSet.getString("FILAS2"),
											null, null, null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaMotivos Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisiones(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaDecisiones Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND HCFEDE IS NOT NULL AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT NVL(t9.DENOMBRE,'INDEF') AS FILAS, NVL(t9.DENOMBREE,'INDEF') AS FILASE, COUNT(distinct t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY  NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF') ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF') ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, null, null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaDecisiones Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t1.DECOTFP= t2.TFPCODIGO AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(

					" SELECT  NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS FILAS, NVL(t2.TFPNOMBRE,'INDEF') AS COLUMNAS, NVL(t2.TFPNOMBREE,'INDEF') AS COLUMNASE, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,FORMA_PRESENTACION t2,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')), NVL(t2.TFPNOMBRE,'INDEF'), NVL(t2.TFPNOMBREE,'INDEF')");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t2.TFPNOMBRE,'INDEF'), NVL(t2.TFPNOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"), null,
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getString("COLUMNASE"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor Fin");
		}
	}

	/**
	 * 0132627 Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t4.HDFORMAVENTA = t12.FVCODIGO(+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(

					" SELECT  NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS FILAS, NVL(t12.FVNOMBRE,'INDEF') AS COLUMNAS, NVL(t12.FVNOMBREE,'INDEF') AS COLUMNASE, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr,FORMAS_VENTA t12 ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')), NVL(t12.FVNOMBRE,'INDEF'), NVL(t12.FVNOMBREE,'INDEF')");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t12.FVNOMBRE,'INDEF'), NVL(t12.FVNOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"), null,
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getString("COLUMNASE"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaSectoresMunicipioConsumidor Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT NVL(t11.SENOMBRE,'INDEF') AS FILAS, NVL(t11.SENOMBREE,'INDEF') AS FILASE, NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY NVL(t11.SENOMBRE,'INDEF'), NVL(t11.SENOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t11.SENOMBRE,'INDEF'), NVL(t11.SENOMBREE,'INDEF'),NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaSectoresMunicipioConsumidor Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSexoEdad(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaSexoEdad Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t3.DTRANGO_EDAD = t12.RANCOD(+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT NVL(t12.RANDESC,'Indefinido') AS FILAS, DECODE(t3.DTCOSX,'H','H',decode(t3.DTCOSX,'M','M','Indefinido'))  AS COLUMNAS, COUNT(distinct t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11, RANGO_EDAD t12,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY  t12.RANDESC,t3.DTCOSX ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t12.RANDESC,'Indefinido') ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"), null,
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaSexoEdad Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND HCFEDE IS NOT NULL AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(

					" SELECT NVL(t9.DENOMBRE,'INDEF') AS FILAS, NVL(t9.DENOMBREE,'INDEF') AS FILASE, NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, ROUND(AVG(HCFEDE- DEFEDE), 0) AS TOTAL, COUNT(DISTINCT t4.HDCODIGO) AS NUMREG "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append(" GROUP BY NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t9.DENOMBRE,'INDEF'), NVL(t9.DENOMBREE,'INDEF'),NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"),
											resultSet.getBigDecimal("NUMREG"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t4.HDCOPS = t12.PSCODIGO(+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(

					" SELECT NVL(t12.PSNOMBRE,'INDEF') AS FILAS, NVL(t12.PSNOMBREE,'INDEF') AS FILASE, NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,PRODUCTO t12,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append("  ORDER BY NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'), NVL(t7.ESNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF'))");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t4.HDCOPS = t12.PSCODIGO(+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(

					" SELECT NVL(t12.PSNOMBRE,'INDEF') AS FILAS, NVL(t12.PSNOMBREE,'INDEF') AS FILASE, NVL(t3.DTNOMBRE_MUNICIPIO, DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(DISTINCT t4.HDCODIGO) AS TOTAL "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,PRODUCTO t12,ESTABLECIM_SECTOR t10, SECTOR t11,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			where.append("  GROUP BY NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t12.PSNOMBRE,'INDEF'), NVL(t12.PSNOMBREE,'INDEF'), NVL(t3.DTNOMBRE_MUNICIPIO,DECODE(DTEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasSolicitudesResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasSolicitudesResultado>() {
								public EstadisticasSolicitudesResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasSolicitudesResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											null, resultSet
													.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicioMotivo(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoSolicitudesProductoServicioMotivo Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP= t2.TFPCODIGO AND t6.HCCODIGO=tr.IHCOHC(+) AND t4.HDFORMAVENTA=t14.FVCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT distinct t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, (t3.DTNOMBRE || ' ' || t3.DTAPELLIDO1 || ' ' || t3.DTAPELLIDO2) as DTNOMBRE, t7.ESNOMBRE, t7.ESNOCO, t7.ESNOMBRE_PROVINCIA, t7.ESNOMBRE_CALLE, t7.ESNOMBRE_PORTAL, t7.ESDIRECCION_NOCAPV, t7.ESNOMBRE_MUNICIPIO, t7.ESNODIR, t7.ESNORA_PAIS_NOMBRE,t7.ESNOMBRE_CP, t11.SENOMBRE, t11.SENOMBREE, t12.PSNOMBRE, t12.PSNOMBREE, t13.TIRNOMBRE, t14.FVNOMBRE, t14.FVNOMBREE "
							+ "FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,FORMA_PRESENTACION t2,TRASLADO tr, FORMAS_VENTA t14 ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN, t1.DENROR, t4.HDNROR ");
				query.append(order);
			}

			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), resultSet
											.getString("TFPNOMBRE"), resultSet
											.getString("TFPNOMBREE"), null,
									resultSet.getString("DTNOMBRE"), resultSet
											.getLong("HDNROR"), resultSet
											.getString("ESNOMBRE"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNODIR"), resultSet
											.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESNOMBRE_CP"), null,
									resultSet.getString("PSNOMBRE"), resultSet
											.getString("PSNOMBREE"), resultSet
											.getString("TIRNOMBRE"), resultSet
											.getString("SENOMBRE"), resultSet
											.getString("SENOMBREE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, resultSet
											.getString("FVNOMBRE"), resultSet
											.getString("FVNOMBREE"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesProductoServicioMotivo Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesEstablecimientos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoSolicitudesEstablecimientos Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT distinct t7.ESNOMBRE, t7.ESNOCO, t7.ESNOMBRE_PROVINCIA, t7.ESNOMBRE_CALLE, t7.ESNOMBRE_PORTAL, t7.ESDIRECCION_NOCAPV, t7.ESNOMBRE_MUNICIPIO, t7.ESNODIR, t7.ESNORA_PAIS_NOMBRE, t7.ESNOMBRE_CP,t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, HCFEDE, t9.DENOMBRE, t9.DENOMBREE, t11.SENOMBRE, t11.SENOMBREE, t13.TIRNOMBRE "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY ESNOCO ");
				query.append(order);
			}

			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), null, null,
									null, null, resultSet.getLong("HDNROR"),
									resultSet.getString("ESNOMBRE"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNODIR"), resultSet
											.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESNOMBRE_CP"), null,
									null, null, resultSet
											.getString("TIRNOMBRE"), resultSet
											.getString("SENOMBRE"), resultSet
											.getString("SENOMBREE"), null,
									null, resultSet.getString("DENOMBRE"),
									resultSet.getString("DENOMBREE"), resultSet
											.getDate("HCFEDE"), null, null,
									null, null, null, null, null, null, null,
									null);
						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesEstablecimientos Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicios(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoSolicitudesProductoServicios Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT distinct NVL(t12.PSNOMBRE,'INDEF') AS PSNOMBRE, NVL(t12.PSNOMBREE,'INDEF') AS PSNOMBREE, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, t7.ESNOMBRE, t7.ESNOCO, t7.ESNOMBRE_PROVINCIA, t7.ESNOMBRE_CALLE, t7.ESNOMBRE_PORTAL, t7.ESDIRECCION_NOCAPV, t7.ESNOMBRE_MUNICIPIO, t7.ESNODIR, t7.ESNORA_PAIS_NOMBRE,t7.ESNOMBRE_CP ,HCFEDE, t9.DENOMBRE,t9.DENOMBREE, t13.TIRNOMBRE "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY PSNOMBRE,PSNOMBREE ");
				query.append(order);
			}

			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), null, null,
									null, null, resultSet.getLong("HDNROR"),
									resultSet.getString("ESNOMBRE"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNODIR"), resultSet
											.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESNOMBRE_CP"), null,
									resultSet.getString("PSNOMBRE"), resultSet
											.getString("PSNOMBREE"), resultSet
											.getString("TIRNOMBRE"), null,
									null, null, null, resultSet
											.getString("DENOMBRE"), resultSet
											.getString("DENOMBREE"), resultSet
											.getDate("HCFEDE"), null, null,
									null, null, null, null, null, null, null,
									null);
						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesProductoServicios Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesSinDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoSolicitudesSinDecision Ini");
		try {
			List<Object> params2 = new ArrayList<Object>();
			StringBuffer where2 = new StringBuffer(3000);
			where2 = this.getParteWhereListadoSolicitudesSinDecision();
			where2.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params2, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));
			StringBuffer sql = new StringBuffer(3000);
			// sql.append("SELECT distinct(t1.DECOOR) NUM_SOLICITUD, t22.MONOMBRE MONITOR, TO_CHAR(t1.DEFEDE, 'DD/MM/YY') FEC_PRESENTACION, ");
			sql.append("SELECT distinct(t1.DECOOR) NUM_SOLICITUD, t22.MONOMBRE MONITOR, t1.DEFEDE FEC_PRESENTACION, ");
			sql.append("t4.HDNROR NUM_HECHO, t3.DTNIF NIF_CONSUMIDOR, t3.DTNOMBRE||' '||t3.DTAPELLIDO1||' '||t3.DTAPELLIDO2 NOMBRE_APE, ");
			sql.append("t3.DTNOMBRE_MUNICIPIO NOM_MUNICIPIO, t7.ESNOCO ESTABLECIMIENTO, ROUND((SYSDATE - t1.DEFEDE),0) AS DIAS, ");
			sql.append("t21.TRNOMBRE ULT_TRAMITE_CAS, t21.TRNOMBREE ULT_TRAMITE_EUS, ");
			// sql.append("TO_CHAR(t20.EHFECHA,'DD/MM/YYYY') ULT_TRAMITE_DIA, t20.EHHORA ULT_TRAMITE_HORA, ");
			sql.append("t20.EHFECHA ULT_TRAMITE_DIA, t20.EHHORA ULT_TRAMITE_HORA, ");
			sql.append("t1.DENRAN DENRAN, t1.DENROR DENROR");
			sql.append(" FROM DENUNCIA t1, CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, ");
			sql.append("DECISION t9, ESTABLECIM_SECTOR t10, SECTOR t11, PRODUCTO t12, MOTIVO t13, FORMA_PRESENTACION t2, ");
			sql.append("TRASLADO tr, TRAMITE_HECHO t20, TRAMITE t21, CENSO_MONITOR t22");
			sql.append(where2);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					sql.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
				}
				sql = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, sql.toString()));
			} else {
				sql.append(" ORDER BY MONITOR ASC, NUM_SOLICITUD ASC, DENRAN ASC, DENROR ASC");
			}
			logger.info("sql-nueva: " + sql.toString());

			List<ListadoSolicitudResultado> lstSolicitudResultado = this.jdbcTemplate
					.query(sql.toString(), rwMap, params2.toArray());

			return lstSolicitudResultado;
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesSinDecision Fin");
		}
	}

	private RowMapper<ListadoSolicitudResultado> rwMap = new RowMapper<ListadoSolicitudResultado>() {
		public ListadoSolicitudResultado mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			ListadoSolicitudResultado resultado = new ListadoSolicitudResultado();
			resultado.setDecoor(resultSet.getString("NUM_SOLICITUD"));
			resultado.setDenran(resultSet.getInt("DENRAN"));
			resultado.setDenror(resultSet.getLong("DENROR"));
			resultado.setDefede(resultSet.getDate("FEC_PRESENTACION"));
			resultado.setDtnombre(resultSet.getString("NOMBRE_APE"));
			resultado.setEsnoco(resultSet.getString("ESTABLECIMIENTO"));
			resultado
					.setEsnombreMunicipio(resultSet.getString("NOM_MUNICIPIO"));
			resultado.setEhfecha(resultSet.getDate("ULT_TRAMITE_DIA"));
			resultado.setEhhora(resultSet.getString("ULT_TRAMITE_HORA"));
			resultado.setTrnombre(resultSet.getString("ULT_TRAMITE_CAS"));
			resultado.setTrnombree(resultSet.getString("ULT_TRAMITE_EUS"));
			resultado.setDias(resultSet.getBigDecimal("DIAS"));
			resultado.setMonombreDenuncia(resultSet.getString("MONITOR"));
			resultado.setHdnror(resultSet.getLong("NUM_HECHO"));
			resultado.setDtnif(resultSet.getString("NIF_CONSUMIDOR"));

			return resultado;

		}
	};

	/**
	 * Forma parte de la sentencia where de la query para sacar el listado de
	 * solicitudes sin decision por monitor y ultimo tramite.
	 * 
	 * @return StringBuffer con la informacion
	 */
	private StringBuffer getParteWhereListadoSolicitudesSinDecision() {
		StringBuffer sqlWhere = new StringBuffer(3000);
		sqlWhere.append(" WHERE 1=1");
		sqlWhere.append(" AND t1.DECODT=t3.DTCODIGO");
		sqlWhere.append(" AND t1.DECODIGO=t4.HDCODE");
		sqlWhere.append(" AND t4.HDCODIGO=t6.HCCOHD");
		sqlWhere.append(" AND t4.HDCOES=t7.ESCODIGO");
		sqlWhere.append(" AND t6.HCCOTTD=t9.DECODIGO(+)");
		sqlWhere.append(" AND t7.ESCODIGO=t10.EACOES(+)");
		sqlWhere.append(" AND t10.EACOSE=t11.SECODIGO(+)");
		sqlWhere.append(" AND t10.EAINPRSE(+) = 'P'");
		sqlWhere.append(" AND t4.HDCOPS=t12.PSCODIGO(+)");
		sqlWhere.append(" AND t4.HDCOTIR=t13.TIRCODIGO(+)");
		sqlWhere.append(" AND t1.DECOTFP=t2.TFPCODIGO");
		sqlWhere.append(" AND t6.HCFEDE IS NULL");
		sqlWhere.append(" AND t6.HCCODIGO=tr.IHCOHC(+)");
		sqlWhere.append(" AND t4.HDCOMO=t22.MOCODIGO");
		sqlWhere.append(" AND t4.HDCODIGO=t20.EHCOHD");
		sqlWhere.append(" AND t20.EHFECHA=(SELECT MAX(tr2.EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD = t4.HDCODIGO)");
		sqlWhere.append(" AND NVL(t20.EHHORA, 0)=(SELECT NVL(MAX(tr3.EHHORA), 0) FROM TRAMITE_HECHO tr3");
		sqlWhere.append(" WHERE t20.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD = t4.HDCODIGO)");
		sqlWhere.append(" AND t6.HCCOTTD=t9.DECODIGO (+)");
		sqlWhere.append(" AND t20.EHCOTEE = t21.TRCODIGO");

		return sqlWhere;
	}// end getParteWhereListadoSolicitudesSinDecision

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesConDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		logger.info("findAllSolicitudListadoSolicitudesConDecision Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP= t2.TFPCODIGO AND HCFEDE IS NOT NULL AND t6.HCCODIGO=tr.IHCOHC(+) AND t4.HDFORMAVENTA=t14.FVCODIGO(+) ");// ñ

			StringBuffer query = new StringBuffer(
					" SELECT distinct t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, t7.ESNOMBRE, t7.ESNOCO, t7.ESNOMBRE_PROVINCIA, t7.ESNOMBRE_CALLE, t7.ESNOMBRE_PORTAL, t7.ESDIRECCION_NOCAPV, t7.ESNOMBRE_MUNICIPIO, t7.ESNODIR, t7.ESNORA_PAIS_NOMBRE, t7.ESNOMBRE_CP,t11.SENOMBRE,t11.SENOMBREE, t9.DENOMBRE,t9.DENOMBREE, HCFEDE, ROUND((HCFEDE - DEFEDE),0) AS DIAS,t14.FVNOMBRE,t14.FVNOMBREE "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,FORMA_PRESENTACION t2,TRASLADO tr ,FORMAS_VENTA t14 ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN, t1.DENROR, t4.HDNROR ");
				query.append(order);
			}

			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), null, null,
									null, null, resultSet.getLong("HDNROR"),
									resultSet.getString("ESNOMBRE"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNODIR"), resultSet
											.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESNOMBRE_CP"), null,
									null, null, null, resultSet
											.getString("SENOMBRE"), resultSet
											.getString("SENOMBREE"), null,
									null, resultSet.getString("DENOMBRE"),
									resultSet.getString("DENOMBREE"), resultSet
											.getDate("HCFEDE"), null, null,
									null, null, null, resultSet
											.getBigDecimal("DIAS"), null, null,
									resultSet.getString("FVNOMBRE"), resultSet
											.getString("FVNOMBREE"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesConDecision Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoEstadoExpedientesCurso(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoEstadoExpedientesCurso Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP= t2.TFPCODIGO AND t4.HDCOTSR = t14.TSRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDCODIGO = tr1.EHCOHD(+) AND tr1.EHCOTEE= tr4.TRCODIGO(+) AND tr1.EHCOMO = tr8.MOCODIGO(+) AND HCFEDE IS NULL AND t6.HCCODIGO=tr.IHCOHC(+)AND t4.HDFORMAVENTA=t14.FVCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT distinct t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, t14.TSRNOMBRE, t14.TSRNOMBREE, t8.MONOMBRE MONOMBREDENUNCIA, (t3.DTNOMBRE || ' ' || t3.DTAPELLIDO1 || ' ' || t3.DTAPELLIDO2) as DTNOMBRE, t7.ESNOMBRE, t7.ESNOCO, t7.ESNOMBRE_PROVINCIA, t7.ESNOMBRE_CALLE, t7.ESNOMBRE_PORTAL, t7.ESDIRECCION_NOCAPV, t7.ESNOMBRE_MUNICIPIO, t7.ESNODIR, t7.ESNORA_PAIS_NOMBRE, t7.ESNOMBRE_CP,tr4.TRNOMBRE, tr4.TRNOMBREE, tr1.EHFECHA, tr1.EHHORA, tr8.MONOMBRE MONOMBRETRAMITE, t14.FVNOMBRE, t14.FVNOMBREE "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,FORMA_PRESENTACION t2,TIPO_RECLAMACION t14, CENSO_MONITOR t8, TRAMITE_HECHO tr1, TRAMITE tr4, CENSO_MONITOR tr8,TRASLADO tr, FORMAS_VENTA t14 ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN, t1.DENROR, t4.HDNROR, tr1.EHFECHA, tr1.EHHORA ");
				query.append(order);
			}

			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), null, null,
									resultSet.getString("MONOMBREDENUNCIA"),
									resultSet.getString("DTNOMBRE"), resultSet
											.getLong("HDNROR"), resultSet
											.getString("ESNOMBRE"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNODIR"), resultSet
											.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESNOMBRE_CP"), null,
									null, null, null, null, null, null, null,
									null, null, null, resultSet
											.getDate("EHFECHA"), resultSet
											.getString("EHHORA"), resultSet
											.getString("TRNOMBRE"), resultSet
											.getString("TRNOMBREE"), resultSet
											.getString("MONOMBRETRAMITE"),
									null, resultSet.getString("TSRNOMBRE"),
									resultSet.getString("TSRNOMBREE"),
									resultSet.getString("FVNOMBRE"), resultSet
											.getString("FVNOMBREE"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoEstadoExpedientesCurso Fin");
		}
	}

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoTramitacion(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoTiempoTramitacion Ini");
		// JdbcTemplate jdbcTemplateNoDataSource = null;
		// SingleConnectionDataSource singleConnectionDataSource = null;
		try {
			// try {
			// singleConnectionDataSource = new SingleConnectionDataSource(
			// this.dataSource.getConnection(), false);
			// jdbcTemplateNoDataSource = new JdbcTemplate(
			// singleConnectionDataSource);
			// } catch (SQLException sqlExc) {
			// logger.error("findAllSolicitudListadoTiempoTramitacion Error:"
			// + StackTraceManager.getStackTrace(sqlExc));
			// }
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP= t2.TFPCODIGO AND t4.HDCODIGO = tr1.EHCOHD(+) AND tr1.EHCOTEE= tr4.TRCODIGO(+) AND t6.HCCODIGO=tr.IHCOHC(+) ");

			StringBuffer query = new StringBuffer(
					" SELECT distinct t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t4.HDNROR, (t3.DTNOMBRE || ' ' || t3.DTAPELLIDO1 || ' ' || t3.DTAPELLIDO2) as DTNOMBRE, tr4.TRNOMBRE, tr4.TRNOMBREE, tr1.EHFECHA,  tr1.EHHORA, (tr1.EHFECHA - t1.DEFEDE) AS DIAS "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,FORMA_PRESENTACION t2, TRAMITE_HECHO tr1, TRAMITE tr4,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN, t1.DENROR, t4.HDNROR, tr1.EHFECHA, tr1.EHHORA ");
				query.append(order);
			}
			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), resultSet
											.getDate("DEFEDE"), null, null,
									null, resultSet.getString("DTNOMBRE"),
									resultSet.getLong("HDNROR"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, resultSet
											.getDate("EHFECHA"), resultSet
											.getString("EHHORA"), resultSet
											.getString("TRNOMBRE"), resultSet
											.getString("TRNOMBREE"), null,
									resultSet.getBigDecimal("DIAS"), null,
									null, null, null);
						}
					}, params.toArray());
		} finally {
			// if (singleConnectionDataSource != null) {
			// singleConnectionDataSource.destroy();
			// }
			logger.info("findAllSolicitudListadoTiempoTramitacion Fin");
		}
	}

	// /

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesGeneral(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoSolicitudesGeneral Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT = t3.DTCODIGO AND t1.DECODIGO = t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES = t7.ESCODIGO AND t6.HCCOTTD = t9.DECODIGO (+)  ");
			where.append(" AND t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP = t2.TFPCODIGO(+) AND t4.HDCODIGO = tr1.EHCOHD(+) ");
			where.append(" AND tr1.EHCOTEE     = tr4.TRCODIGO(+) AND t4.HDCOMO = t8.MOCODIGO(+) AND t4.HDFORMAVENTA = t99.FVCODIGO(+) AND t4.HDCOTSR = t73.TSRCODIGO(+) ");
			where.append(" AND t11.SECODIGO = (SELECT t994.SECODIGO SECTORSECODIGO FROM ESTABLECIM_SECTOR t991, ESTABLECIMIENTO t992, SECTOR t994 WHERE t991.EACOES = t992.ESCODIGO(+) AND t991.EACOSE = t994.SECODIGO(+) AND t991.EAINPRSE = 'P' AND t7.ESCODIGO = t992.ESCODIGO AND ROWNUM = 1 ) ");
			where.append(" AND tr1.EHFECHA=(SELECT MAX(tr2.EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD = t4.HDCODIGO) AND NVL(tr1.EHHORA, 0)=(SELECT NVL(MAX(tr3.EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD = t4.HDCODIGO) ");
			where.append(" AND t6.HCCOTTD=t9.DECODIGO (+) AND tr1.EHCOTEE = tr4.TRCODIGO (+) ");

			StringBuffer query = new StringBuffer(

					" SELECT t1.DECOOR DECOOR,t1.DENRAN DENRAN, t1.DENROR DENROR,  t4.HDNROR HDNROR, t8.MONOMBRE MONOMBREDENUNCIA, t4.HDCOSC HDCOSC, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t4.HDIDIOMA HDIDIOMA, "
							+ " t1.DEHOJARECLAMACION DEHOJARECLAMACION, t2.TFPCODIGO TFPCODIGO, t2.TFPNOMBRE TFPNOMBRE, t2.TFPNOMBREE TFPNOMBREE, t4.HDCODEXPEDIENTEORIGEN HDCODEXPEDIENTEORIGEN, t3.DTINTIPID DTINTIPID, t3.DTNIF DTNIF, "
							+ " t3.DTNOMBRE DTNOMBRE, t3.DTAPELLIDO1 DTAPELLIDO1, t3.DTAPELLIDO2 DTAPELLIDO2, t3.DTNRTEL DTNRTEL, t3.DTNRTEL2 DTNRTEL2, t3.DTTECOEM DTTECOEM, t3.DTNRAN DTNRAN, t3.DTCOSX DTCOSX, t3.DTCOIDCO DTCOIDCO, "
							+ " t3.DTEXTRANJERO DTEXTRANJERO, t3.DTNOMBRE_CP DTNOMBRE_CP, t3.DTNORA_PAIS_NOMBRE DTNORA_PAIS_NOMBRE, t3.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, t3.DTNOMBRE_PROVINCIA DTNOMBRE_PROVINCIA, "
							+ " t3.DTNOMBRE_MUNICIPIO DTNOMBRE_MUNICIPIO, t3.DTNOMBRE_LOCALIDAD DTNOMBRE_LOCALIDAD, t3.DTNOMBRE_CALLE DTNOMBRE_CALLE, t3.DTNOMBRE_PORTAL DTNOMBRE_PORTAL, t3.DTNOMBRE_PISO DTNOMBRE_PISO, "
							+ " t7.ESNIF ESNIF, t7.ESNOCO ESNOCO, t7.ESNOMBRE ESNOMBRE, t7.ESCOIDCO ESCOIDCO, t7.ESTEURL ESTEURL, t11.SECODIGO SECODIGO, t11.SENOMBRE SENOMBRE, t11.SENOMBREE SENOMBREE, t7.ESTECO ESTECO, "
							+ " t7.ESNOPECO ESNOPECO, t7.ESFEBA ESFEBA, t7.ESCOEM ESCOEM, t7.ESNRTEL ESNRTEL, t7.ESNRTEL2 ESNRTEL2, t7.ESEXTRANJERO ESEXTRANJERO, t7.ESNOMBRE_CP ESNOMBRE_CP, t7.ESNORA_PAIS_NOMBRE ESNORA_PAIS_NOMBRE, "
							+ " t7.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t7.ESNOMBRE_PROVINCIA ESNOMBRE_PROVINCIA, t7.ESNOMBRE_MUNICIPIO ESNOMBRE_MUNICIPIO, t7.ESNOMBRE_LOCALIDAD ESNOMBRE_LOCALIDAD, t7.ESNOMBRE_CALLE ESNOMBRE_CALLE, "
							+ " t7.ESNOMBRE_PORTAL ESNOMBRE_PORTAL, t7.ESNOMBRE_PISO ESNOMBRE_PISO, t4.HDFEHD HDFEHD, t4.HDTE HDTE, t12.PSCODIGO PSCODIGO, t12.PSNOMBRE PSNOMBRE, t12.PSNOMBREE PSNOMBREE, t13.TIRCODIGO TIRCODIGO, "
							+ " t13.TIRNOMBRE TIRNOMBRE, t13.TIRNOMBREE TIRNOMBREE, t99.FVCODIGO FVCODIGO, t99.FVNOMBRE FVNOMBRE, t99.FVNOMBREE FVNOMBREE, t73.TSRCODIGO TSRCODIGO, t73.TSRNOMBRE TSRNOMBRE, t73.TSRNOMBREE TSRNOMBREE, "
							+ " t4.HDCAPTSO HDCAPTSO, t4.HDTESO HDTESO, tr4.TRNOMBRE TRNOMBRE, tr4.TRNOMBREE TRNOMBREE, tr1.EHFECHA EHFECHA, tr1.EHHORA EHHORA, t9.DENOMBRE DENOMBRE, t9.DENOMBREE DENOMBREE, t6.HCFEDE HCFEDE "
							+ " FROM DENUNCIA t1, FORMA_PRESENTACION t2, CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, CENSO_MONITOR t8, DECISION t9, SECTOR t11, PRODUCTO t12, "
							+ " MOTIVO t13, TRAMITE_HECHO tr1, TRAMITE tr4, FORMAS_VENTA t99, TIPO_RECLAMACION t73 ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN, t1.DENROR, t4.HDNROR, tr1.EHFECHA, tr1.EHHORA ");
				query.append(order);
			}
			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(
									null,
									resultSet.getString("DECOOR"),
									resultSet.getInt("DENRAN"),
									resultSet.getLong("DENROR"),
									resultSet.getLong("HDNROR"),
									resultSet.getString("MONOMBREDENUNCIA"),
									resultSet.getString("HDCOSC"),
									resultSet.getDate("DEFEDE"),
									resultSet.getDate("DEFERE"),
									resultSet.getString("HDIDIOMA"),
									resultSet.getString("DEHOJARECLAMACION"),
									resultSet.getString("TFPNOMBRE"),
									resultSet.getString("TFPNOMBREE"),
									resultSet
											.getString("HDCODEXPEDIENTEORIGEN"),
									resultSet.getString("DTINTIPID"), resultSet
											.getString("DTNIF"), resultSet
											.getString("DTNOMBRE"), resultSet
											.getString("DTAPELLIDO1"),
									resultSet.getString("DTAPELLIDO2"),
									resultSet.getString("DTNRTEL"), resultSet
											.getString("DTNRTEL2"), resultSet
											.getString("DTTECOEM"), resultSet
											.getString("DTNRAN"), resultSet
											.getString("DTCOSX"), resultSet
											.getString("DTCOIDCO"), resultSet
											.getString("DTEXTRANJERO"),
									resultSet.getString("DTNOMBRE_CP"),
									resultSet.getString("DTNORA_PAIS_NOMBRE"),
									resultSet.getString("DTDIRECCION_NOCAPV"),
									resultSet.getString("DTNOMBRE_PROVINCIA"),
									resultSet.getString("DTNOMBRE_MUNICIPIO"),
									resultSet.getString("DTNOMBRE_LOCALIDAD"),
									resultSet.getString("DTNOMBRE_CALLE"),
									resultSet.getString("DTNOMBRE_PORTAL"),
									resultSet.getString("DTNOMBRE_PISO"),
									resultSet.getString("ESNIF"), resultSet
											.getString("ESNOCO"), resultSet
											.getString("ESNOMBRE"), resultSet
											.getString("ESCOIDCO"), resultSet
											.getString("ESTEURL"), resultSet
											.getString("SECODIGO"), resultSet
											.getString("SENOMBRE"), resultSet
											.getString("SENOMBREE"), resultSet
											.getString("ESTECO"), resultSet
											.getString("ESNOPECO"), resultSet
											.getDate("ESFEBA"), resultSet
											.getString("ESCOEM"), resultSet
											.getString("ESNRTEL"), resultSet
											.getString("ESNRTEL2"), resultSet
											.getString("ESEXTRANJERO"),
									resultSet.getString("ESNOMBRE_CP"),
									resultSet.getString("ESNORA_PAIS_NOMBRE"),
									resultSet.getString("ESDIRECCION_NOCAPV"),
									resultSet.getString("ESNOMBRE_PROVINCIA"),
									resultSet.getString("ESNOMBRE_MUNICIPIO"),
									resultSet.getString("ESNOMBRE_LOCALIDAD"),
									resultSet.getString("ESNOMBRE_CALLE"),
									resultSet.getString("ESNOMBRE_PORTAL"),
									resultSet.getString("ESNOMBRE_PISO"),
									resultSet.getDate("HDFEHD"), resultSet
											.getString("HDTE"), resultSet
											.getString("PSCODIGO"), resultSet
											.getString("PSNOMBRE"), resultSet
											.getString("PSNOMBREE"), resultSet
											.getString("TIRNOMBRE"), resultSet
											.getString("FVNOMBRE"), resultSet
											.getString("FVNOMBREE"), resultSet
											.getString("TSRNOMBRE"), resultSet
											.getString("TSRNOMBREE"), resultSet
											.getString("HDCAPTSO"), resultSet
											.getString("HDTESO"), resultSet
											.getString("TRNOMBRE"), resultSet
											.getString("TRNOMBREE"), resultSet
											.getDate("EHFECHA"), resultSet
											.getString("EHHORA"), resultSet
											.getString("DENOMBRE"), resultSet
											.getString("DENOMBREE"), resultSet
											.getDate("HCFEDE"));

						}
					}, params.toArray());
		} finally {
			logger.info("findAllSolicitudListadoSolicitudesGeneral Fin");
		}
	}

	// /

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoRealizacionPrimerTramite(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {
		logger.info("findAllSolicitudListadoTiempoRealizacionPrimerTramite Ini");

		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.DECODT= t3.DTCODIGO AND t1.DECODIGO= t4.HDCODE AND t4.HDCODIGO = t6.HCCOHD AND t4.HDCOES= t7.ESCODIGO AND "
					+ "t6.HCCOTTD= t9.DECODIGO (+) AND t7.ESCODIGO=t10.EACOES(+) AND t10.EACOSE= t11.SECODIGO(+) AND t10.EAINPRSE(+) = 'P' AND "
					+ "t4.HDCOPS = t12.PSCODIGO(+) AND t4.HDCOTIR = t13.TIRCODIGO(+) AND t1.DECOTFP= t2.TFPCODIGO AND t4.HDCODIGO = tr1.EHCOHD(+) AND "
					+ "tr1.EHCOTEE= tr4.TRCODIGO(+) AND t6.HCCODIGO=tr.IHCOHC(+) ");
			where.append(" AND tr1.EHCOTEE <> '1' ");

			StringBuffer query = new StringBuffer(
					" select t1.DECOOR, t1.DENROR, t1.DENRAN, t4.HDNROR, MIN(t1.DEFEDE) AS FECHA_PRESENTACION, MIN(tr1.EHFECHA) AS FECHA_TRAMITE, "
							+ "MIN(tr1.EHFECHA) -  MIN(t1.DEFEDE) as NUM_DIAS "
							+ " FROM DENUNCIA t1,CONSUMIDOR t3, HECHO_DENUNCIADO t4, DECISION_HECHO t6, ESTABLECIMIENTO t7, DECISION t9,"
							+ "ESTABLECIM_SECTOR t10, SECTOR t11,PRODUCTO t12, MOTIVO t13,FORMA_PRESENTACION t2, TRAMITE_HECHO tr1, TRAMITE tr4,TRASLADO tr ");

			where.append(getWhereEstadisticasSolicitudes(solicitudesBusqueda,
					params, startsWith, defedeDesde, defedeHasta, defereDesde,
					defereHasta, hcfedeDesde, hcfedeHasta));

			query.append(where);

			StringBuffer group = new StringBuffer(3000);
			group.append(" GROUP BY t1.DECOOR, t1.DENRAN,t1.DENROR,t4.HDNROR");
			query.append(group);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY t1.DECOOR, t1.DENRAN,t1.DENROR,t4.HDNROR ");
				query.append(order);
			}
			return (List<ListadoSolicitudResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoSolicitudResultado>() {
						public ListadoSolicitudResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoSolicitudResultado(null,
									resultSet.getString("DECOOR"), resultSet
											.getInt("DENRAN"), resultSet
											.getLong("DENROR"), null, null,
									null, null, null, resultSet
											.getLong("HDNROR"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, resultSet
											.getDate("FECHA_PRESENTACION"),
									resultSet.getDate("FECHA_TRAMITE"), null,
									null, null, null, resultSet
											.getBigDecimal("NUM_DIAS"), null,
									null, null, null);
						}
					}, params.toArray());

		} finally {
			logger.info("findAllSolicitudListadoTiempoTramitacion Fin");
		}
	}

	/**
	 * Obtain the where in estadisticas estadisticas.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param params
	 *            List
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * 
	 * @return String
	 */
	private static String getWhereEstadisticasSolicitudes(
			SolicitudBusqueda solicitudesBusqueda, List<Object> params,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta) {

		StringBuffer where = new StringBuffer(3000);

		// organismo
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDecoor() != null) {
			where.append(" AND t1.DECOOR = ? ");
			params.add(solicitudesBusqueda.getDecoor());
		}

		// anyo
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDenran() != null) {
			where.append(" AND t1.DENRAN = ? ");
			params.add(solicitudesBusqueda.getDenran());
		}

		// correlativo
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDenror() != null) {
			where.append(" AND t1.DENROR = ? ");
			params.add(solicitudesBusqueda.getDenror());
		}

		// Mi gestion
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getIndGestion() != null
				&& solicitudesBusqueda.getIndGestion().equals(
						Y41aConstantes.SOLICITUDES_MIGESTION)) {
			where.append(" AND t4.HDINSOMA = ? ");
			params.add(Y41aConstantes.SOLICITUD_MEDIACION);
			where.append(" AND t6.HCCOOR = ? ");
			params.add(solicitudesBusqueda.getCodOrgConectado());
		}

		// Recibidas
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getIndGestion() != null
				&& solicitudesBusqueda.getIndGestion().equals(
						Y41aConstantes.SOLICITUDES_RECIBIDAS)) {
			where.append(" AND IHCOORDT = ? ");
			params.add(solicitudesBusqueda.getCodOrgConectado());
		}

		// Trasladadas
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getIndGestion() != null
				&& solicitudesBusqueda.getIndGestion().equals(
						Y41aConstantes.SOLICITUDES_TRASLADADAS)) {
			where.append(" AND tr.IHCOORTR = ? ");
			params.add(solicitudesBusqueda.getCodOrgConectado());
		}

		// Arbitraje
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getIndGestion() != null
				&& solicitudesBusqueda.getIndGestion().equals(
						Y41aConstantes.SOLICITUDES_ARBITRAJE)) {
			where.append(" AND t4.HDINSOMA = ? ");
			params.add(Y41aConstantes.SOLICITUD_ARBITRAJE);
			where.append(" AND t6.HCCOOR = ? ");
			params.add(solicitudesBusqueda.getCodOrgConectado());
		}

		// Todas
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getIndGestion() != null
				&& solicitudesBusqueda.getIndGestion().equals(
						Y41aConstantes.SOLICITUDES_TODAS)) {
			where.append(" AND (t6.HCCOOR = ? OR tr.IHCOORTR = ? OR tr.IHCOORDT= ?) ");
			params.add(solicitudesBusqueda.getCodOrgConectado());
			params.add(solicitudesBusqueda.getCodOrgConectado());
			params.add(solicitudesBusqueda.getCodOrgConectado());
		}

		// fecha presentacion desde
		if (defedeDesde != null && defedeDesde instanceof Date) {
			where.append(" AND t1.DEFEDE >= ?");
			params.add(defedeDesde);
		}
		// fecha presentacion hasta
		if (defedeHasta != null && defedeHasta instanceof Date) {
			where.append(" AND t1.DEFEDE <= ?");
			params.add(defedeHasta);
		}
		// fecha registro desde
		if (defereDesde != null && defereDesde instanceof Date) {
			where.append(" AND t1.DEFERE >= ?");
			params.add(defereDesde);
		}
		// fecha registro hasta
		if (defereHasta != null && defereHasta instanceof Date) {
			where.append(" AND t1.DEFERE <= ?");
			params.add(defereHasta);
		}

		// tipo forma presentacion
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getTfpcodigo() != null) {
			where.append(" AND t1.DECOTFP = ? ");
			params.add(solicitudesBusqueda.getTfpcodigo());
		}

		// Tipo solicitud
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ? ");
			params.add(solicitudesBusqueda.getHdcosc());
		}

		// Tramite
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getTrcodigo() != null) {
			where.append(" AND EXISTS (SELECT EHCOHD FROM TRAMITE_HECHO tr1 WHERE tr1.EHCOHD=t4.HDCODIGO AND EHCOTEE = ?  ");
			params.add(solicitudesBusqueda.getTrcodigo());

			if (solicitudesBusqueda != null
					&& solicitudesBusqueda.getIndUltimoTramite() != null
					&& solicitudesBusqueda.getIndUltimoTramite().equals(
							Y41aConstantes.VALOR_SI)) {
				where.append(" AND EHFECHA = (SELECT MAX(EHFECHA) FROM TRAMITE_HECHO tr2 WHERE tr2.EHCOHD=t4.HDCODIGO ) AND NVL(EHHORA, 0) = (SELECT NVL(MAX(EHHORA), 0) FROM TRAMITE_HECHO tr3 WHERE tr1.EHFECHA = tr3.EHFECHA AND tr3.EHCOHD=t4.HDCODIGO)) ");
			} else {
				where.append(" ) ");
			}
		}

		// Decision
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDecodigo() != null) {

			if (solicitudesBusqueda.getDecodigo().equalsIgnoreCase("SIND")) {
				where.append(" AND (t6.HCCOTTD = ? OR t6.HCCOTTD IS NULL)");
				params.add(solicitudesBusqueda.getDecodigo());
			} else {
				where.append(" AND t6.HCCOTTD = ?");
				params.add(solicitudesBusqueda.getDecodigo());
			}
		}

		// fecha decision desde
		if (hcfedeDesde != null && hcfedeDesde instanceof Date) {
			where.append(" AND t6.HCFEDE >= ?");
			params.add(hcfedeDesde);
		}
		// fecha decision hasta
		if (hcfedeHasta != null && hcfedeHasta instanceof Date) {
			where.append(" AND t6.HCFEDE <= ?");
			params.add(hcfedeHasta);
		}

		// Nombre persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtnombre() != null) {
			where.append(" AND TRANSLATE(UPPER(t3.DTNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3.DTNOMBRE IS NOT NULL");
		}

		// Apellido1 persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtapellido1() != null) {
			where.append(" AND TRANSLATE(UPPER(t3.DTAPELLIDO1),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido1().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtapellido1().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3.DTAPELLIDO1 IS NOT NULL");
		}

		// Apellido2 persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtapellido2() != null) {
			where.append(" AND TRANSLATE(UPPER(t3.DTAPELLIDO2),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtapellido2().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getDtapellido2().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3.DTAPELLIDO2 IS NOT NULL");
		}
		// Dni persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtnif() != null) {
			where.append(" AND UPPER(t3.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getDtnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getDtnif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNIF IS NOT NULL");
		}

		// Provincia persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtnoraProvinciaId() != null) {
			where.append(" AND t3.DTNORA_PROVINCIA_ID = ? ");
			params.add(solicitudesBusqueda.getDtnoraProvinciaId());
		}

		// Municipio persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtnoraMunicipioId() != null) {
			where.append(" AND t3.DTNORA_MUNICIPIO_ID = ? ");
			params.add(solicitudesBusqueda.getDtnoraMunicipioId());
		}

		// Localidad persona consumidora
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getDtnoraLocalidadId() != null) {
			where.append(" AND t3.DTNORA_LOCALIDAD_ID = ? ");
			params.add(solicitudesBusqueda.getDtnoraLocalidadId());
		}

		// Establecimiento por nombre o normbre comercial
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t7.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t7.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t7.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ solicitudesBusqueda.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t7.ESNOCO IS NOT NULL)) ");
		}

		// NIF establecimiento
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getEsnif() != null) {
			where.append(" AND (UPPER(t7.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(solicitudesBusqueda.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + solicitudesBusqueda.getEsnif().toUpperCase()
						+ "%");
			}
			where.append(" AND t7.ESNIF IS NOT NULL) ");
		}

		// Provincia establecimiento
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getEsnoraProvinciaId() != null) {
			where.append(" AND t7.ESNORA_PROVINCIA_ID = ? ");
			params.add(solicitudesBusqueda.getEsnoraProvinciaId());
		}

		// Municipio establecimiento
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getEsnoraMunicipioId() != null) {
			where.append(" AND t7.ESNORA_MUNICIPIO_ID = ? ");
			params.add(solicitudesBusqueda.getEsnoraMunicipioId());
		}

		// Localidad establecimiento
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getEsnoraLocalidadId() != null) {
			where.append(" AND t7.ESNORA_LOCALIDAD_ID = ? ");
			params.add(solicitudesBusqueda.getEsnoraLocalidadId());
		}

		// Sector
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getSecodigo() != null) {
			where.append(" AND t11.SECODIGO = ? ");
			params.add(solicitudesBusqueda.getSecodigo());
		}

		// Producto
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getPscodigo() != null) {
			where.append(" AND t4.HDCOPS = ? ");
			params.add(solicitudesBusqueda.getPscodigo());
		}

		// Motivo
		if (solicitudesBusqueda != null
				&& solicitudesBusqueda.getTircodigo() != null) {
			where.append(" AND t4.HDCOTIR = ? ");
			params.add(solicitudesBusqueda.getTircodigo());
		}

		return where.toString();
	}
}
