package com.ejie.y41a.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.EstadisticasSolicitudesResultado;
import com.ejie.y41a.model.ListadoSolicitudResultado;
import com.ejie.y41a.model.SolicitudBusqueda;

/**
 * * EstadisticasListadosSolicitudesDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface EstadisticasListadosSolicitudesDao {

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaMotivos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaDecisiones(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaPresentacionMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * 0132627 Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaFormaVentaMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSectoresMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaSexoEdad(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaPromedioTiempoResolverSolicitud(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioEstablecimiento(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasSolicitudesResultado> findAllSolicitudEstadisticaProductoServicioMunicipioConsumidor(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicioMotivo(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesEstablecimientos(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesProductoServicios(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesSinDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesConDecision(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoEstadoExpedientesCurso(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoTramitacion(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes de un organismo.
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	List<ListadoSolicitudResultado> findAllSolicitudListadoSolicitudesGeneral(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);

	/**
	 * Devuelve una lista con las solicitudes con tiempo de realizaci�n primer
	 * tramite..
	 * 
	 * @param solicitudesBusqueda
	 *            SolicitudBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param defedeDesde
	 *            Date
	 * @param defedeHasta
	 *            Date
	 * @param defereDesde
	 *            Date
	 * @param defereHasta
	 *            Date
	 * @param hcfedeDesde
	 *            Date
	 * @param hcfedeHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoSolicitudResultado> findAllSolicitudListadoTiempoRealizacionPrimerTramite(
			SolicitudBusqueda solicitudesBusqueda, Pagination pagination,
			Boolean startsWith, Date defedeDesde, Date defedeHasta,
			Date defereDesde, Date defereHasta, Date hcfedeDesde,
			Date hcfedeHasta);
}
