package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.model.EstadisticasKontsumonetResultado;

/**
 * * EstadisticasListadosKontsumonetDaoImpl generated by UDA, 22-feb-2012
 * 17:30:27.
 * 
 *  
 */

@Repository
public class EstadisticasListadosKontsumonetDaoImpl implements
		EstadisticasListadosKontsumonetDao {

	private static final Logger logger = LoggerFactory
			.getLogger(EstadisticasListadosKontsumonetDaoImpl.class);

	// @Autowired
	// private DataSource dataSource;
	private SimpleJdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstadisticasKontsumonetResultado> findAllConsultaEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination) {
		logger.info("findAllConsultaEstadisticasKontsumonet Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE t1.COCOOR = t2.COD_ORG ");

			StringBuffer query = new StringBuffer(
					"SELECT COD_ORG, NOMBRE_ES, NOMBRE_EU, COUNT(*) NUMRECLAMACIONES "
							+ "FROM CONSULTA t1, ORGANISMO t2 ");

			where.append(" AND t1.CONRANRG = ? ");
			params.add(estadisticasKontsumonetBusqueda.getAnyo());

			where.append(" GROUP BY COD_ORG, NOMBRE_ES, NOMBRE_EU ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NOMBRE_ES, NOMBRE_EU ");
				query.append(order);
			}

			return (List<EstadisticasKontsumonetResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasKontsumonetResultado>() {
								public EstadisticasKontsumonetResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasKontsumonetResultado(
											null,
											resultSet.getString("COD_ORG"),
											resultSet.getString("NOMBRE_ES"),
											resultSet.getString("NOMBRE_EU"),
											resultSet
													.getBigDecimal("NUMRECLAMACIONES"),
											null, null);
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticasKontsumonet Fin");
		}
	}

	/**
	 * Finds rows in the Hecho Denunciado table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstadisticasKontsumonetResultado> findAllSolicitudEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination) {
		logger.info("findAllSolicitudEstadisticasKontsumonet Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE t1.DECODIGO= t2.HDCODE AND t2.HDCODIGO = t3.HCCOHD AND t2.HDINSOMA = ?  AND t3.HCCOOR = t4.COD_ORG ");

			StringBuffer query = new StringBuffer(
					"SELECT COD_ORG, NOMBRE_ES, NOMBRE_EU, COUNT(*) NUMRECLAMACIONES "
							+ "FROM DENUNCIA t1, HECHO_DENUNCIADO t2, DECISION_HECHO t3, ORGANISMO t4 ");

			params.add(Y41aConstantes.SOLICITUD_MEDIACION);

			where.append(" AND t1.DENRAN = ? ");
			params.add(estadisticasKontsumonetBusqueda.getAnyo());

			where.append(" GROUP BY COD_ORG, NOMBRE_ES, NOMBRE_EU ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NOMBRE_ES, NOMBRE_EU ");
				query.append(order);
			}

			return (List<EstadisticasKontsumonetResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasKontsumonetResultado>() {
								public EstadisticasKontsumonetResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasKontsumonetResultado(
											null,
											resultSet.getString("COD_ORG"),
											resultSet.getString("NOMBRE_ES"),
											resultSet.getString("NOMBRE_EU"),
											resultSet
													.getBigDecimal("NUMRECLAMACIONES"),
											null, null);
								}
							}, params.toArray());
		} finally {
			logger.info("findAllSolicitudEstadisticasKontsumonet Fin");
		}
	}

	/**
	 * Finds rows in the Comunicacion table.
	 * 
	 * @param estadisticasKontsumonetBusqueda
	 *            EstadisticasKontsumonetBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EstadisticasKontsumonetResultado> findAllComunicacionEstadisticasKontsumonet(
			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda,
			Pagination pagination) {
		logger.info("findAllComunicacionEstadisticasKontsumonet Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE t1.M4COCOMU = t2.M5COCOMU AND t2.M5COOR= t3.COD_ORG ");

			StringBuffer query = new StringBuffer(
					"SELECT COD_ORG, NOMBRE_ES, NOMBRE_EU, COUNT(case when M5FELEIDO is null then 1 end) NUMNOLEIDOS, COUNT(case when M5FELEIDO is not null then 1 end) NUMLEIDOS "
							+ "FROM COMUNICACION t1, DEST_COMUNICACION t2, ORGANISMO t3 ");

			where.append(" AND TO_CHAR(M4FEENV,'YYYY') = ? ");
			params.add(estadisticasKontsumonetBusqueda.getAnyo());

			where.append(" GROUP BY COD_ORG, NOMBRE_ES, NOMBRE_EU ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc());
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NOMBRE_ES, NOMBRE_EU ");
				query.append(order);
			}

			return (List<EstadisticasKontsumonetResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasKontsumonetResultado>() {
								public EstadisticasKontsumonetResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasKontsumonetResultado(
											null,
											resultSet.getString("COD_ORG"),
											resultSet.getString("NOMBRE_ES"),
											resultSet.getString("NOMBRE_EU"),
											null,
											resultSet
													.getBigDecimal("NUMLEIDOS"),
											resultSet
													.getBigDecimal("NUMNOLEIDOS"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllComunicacionEstadisticasKontsumonet Fin");
		}
	}
}
