package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.EstadisticasConsultasResultado;
import com.ejie.y41a.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41a.model.ListadoConsultaResultado;

/**
 * * EstadisticasListadosConsultasDaoImpl generated by UDA, 22-feb-2012
 * 17:30:27.
 * 
 *  
 */

@Repository
public class EstadisticasListadosConsultasDaoImpl implements
		EstadisticasListadosConsultasDao {

	private static final Logger logger = LoggerFactory
			.getLogger(EstadisticasListadosConsultasDaoImpl.class);

	// @Autowired
	// private DataSource dataSource;
	private SimpleJdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaFormaPresentacion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaFormaPresentacion Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(

					"SELECT NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(*) AS TOTAL, NVL(t5.TFPNOMBRE,'INDEF') AS FILAS, NVL(t5.TFPNOMBREE,'INDEF') AS FILASE "
							+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')), NVL(t5.TFPNOMBRE,'INDEF'), NVL(t5.TFPNOMBREE,'INDEF')");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t5.TFPNOMBRE,'INDEF'), NVL(t5.TFPNOMBREE,'INDEF'), NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasConsultasResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasResultado>() {
								public EstadisticasConsultasResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaFormaPresentacion Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaMotivosProductos(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaMotivosProductos Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(*) AS TOTAL, NVL(t2.TIRNOMBRE,'INDEF') AS FILAS2, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE "
							+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')), NVL(t2.TIRNOMBRE,'INDEF'), NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF') ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF'), NVL(t2.TIRNOMBRE,'INDEF'), NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasConsultasResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasResultado>() {
								public EstadisticasConsultasResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											resultSet.getString("FILAS2"),
											null, resultSet
													.getString("COLUMNAS"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaMotivosProductos Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaProductoServicio(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaProductoServicio Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(

					"SELECT NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS, COUNT(*) AS TOTAL, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE "
							+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')), NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF') ");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF'),NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) ");
				query.append(order);
			}

			return (List<EstadisticasConsultasResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasResultado>() {
								public EstadisticasConsultasResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaProductoServicio Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaSexoEdad(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaSexoEdad Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT NVL(RANDESC,'Indefinido') AS FILAS,  decode(cocosx,'H','H',decode(cocosx,'M','M','Indefinido')) AS COLUMNAS,  count(*) AS TOTAL "
							+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" GROUP BY RANDESC,cocosx ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(RANDESC,'Indefinido') ");
				query.append(order);
			}

			return (List<EstadisticasConsultasResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasResultado>() {
								public EstadisticasConsultasResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasResultado(
											resultSet.getString("FILAS"), null,
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getBigDecimal("TOTAL"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaSexoEdad Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasResultado> findAllConsultaEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaPromedioMedioResponderConsulta Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(

					"SELECT NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')) AS COLUMNAS,NVL(ROUND(AVG(COFERES - COFECHA), 0),0) AS TOTAL, NVL(t3.PSNOMBRE,'INDEF') AS FILAS, NVL(t3.PSNOMBREE,'INDEF') AS FILASE, COUNT(*) AS NUMREG "
							+ "FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" GROUP BY NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF')), NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF') ");
			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY NVL(t3.PSNOMBRE,'INDEF'), NVL(t3.PSNOMBREE,'INDEF'), NVL(t1.NOMBRE_MUNICIPIO,DECODE(COEXTRANJERO,'S','Extranjero','INDEF'))");
				query.append(order);
			}

			return (List<EstadisticasConsultasResultado>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasResultado>() {
								public EstadisticasConsultasResultado mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasResultado(
											resultSet.getString("FILAS"),
											resultSet.getString("FILASE"),
											null, null, resultSet
													.getString("COLUMNAS"),
											resultSet.getBigDecimal("TOTAL"),
											resultSet.getBigDecimal("NUMREG"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaPromedioMedioResponderConsulta Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, FECHACONSULTA, HORA_CONSULTA, HORACONSUMIDOR, SEXO, PRODUCTO, PRODUCTOE, NVL(ROUND(DEMORA,0),0) AS DEMORA, NVL(TRUNC(DEMORA/60),0) AS HORAS, NVL(ROUND(DEMORA-((TRUNC(DEMORA/60))*60),0),0) AS MINUTOS ");
			query.append(" FROM (SELECT COCOOR, CONRREG, CONRANRG, COFECHA AS FECHACONSULTA, COHORA AS HORA_CONSULTA, TO_CHAR(COFECHACONSUMIDOR, 'hh24:mi') AS HORACONSUMIDOR, COCOSX AS SEXO, t3.PSNOMBRE AS PRODUCTO, t3.PSNOMBREE AS PRODUCTOE, (TO_DATE(TO_CHAR(COFECHA, 'DD/MM/YYYY') || ' ' || COHORA,'DD/MM/YYYY hh24:mi')-COFECHACONSUMIDOR)*24*60 AS DEMORA");
			query.append(" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(" AND COCOTFP != ? ");
			where.append(" AND COCOTFP != ? ");
			params.add(Y41aConstantes.FORMA_PRESENTACION_WEB);
			params.add(Y41aConstantes.FORMA_PRESENTACION_FAX);

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			where.append(" ) ");

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
				query.append(order);
			}

			return (List<EstadisticasConsultasTiempoAtencion>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasTiempoAtencion>() {
								public EstadisticasConsultasTiempoAtencion mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasTiempoAtencion(
											resultSet
													.getString("NUMERO_CONSULTA"),
											resultSet.getDate("FECHACONSULTA"),
											resultSet
													.getString("HORA_CONSULTA"),
											resultSet
													.getString("HORACONSUMIDOR"),
											null, resultSet.getString("SEXO"),
											resultSet.getString("PRODUCTO"),
											resultSet.getString("PRODUCTOE"),
											resultSet.getBigDecimal("DEMORA"),
											resultSet.getBigDecimal("HORAS"),
											resultSet.getBigDecimal("MINUTOS"),
											null);
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, COFECHA AS FECHA_CONSULTA, COFERES AS FECHA_RESPUESTA, COCOSX AS SEXO, PSNOMBRE AS PRODUCTO, PSNOMBREE AS PRODUCTOE, TO_DATE(DECODE(TO_CHAR(COFERES,'DD/MM/YYYY'),'',NULL,COFERES))-COFECHA AS DIAS ");
			query.append(" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(" AND (COCOTFP = ? OR COCOTFP = ?) ");
			params.add(Y41aConstantes.FORMA_PRESENTACION_WEB);
			params.add(Y41aConstantes.FORMA_PRESENTACION_FAX);

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
				query.append(order);
			}

			return (List<EstadisticasConsultasTiempoAtencion>) this.jdbcTemplate
					.query(query.toString(),
							new RowMapper<EstadisticasConsultasTiempoAtencion>() {
								public EstadisticasConsultasTiempoAtencion mapRow(
										ResultSet resultSet, int rowNum)
										throws SQLException {
									return new EstadisticasConsultasTiempoAtencion(
											resultSet
													.getString("NUMERO_CONSULTA"),
											resultSet.getDate("FECHA_CONSULTA"),
											null,
											null,
											resultSet
													.getDate("FECHA_RESPUESTA"),
											resultSet.getString("SEXO"),
											resultSet.getString("PRODUCTO"),
											resultSet.getString("PRODUCTOE"),
											null, null, null, resultSet
													.getBigDecimal("DIAS"));
								}
							}, params.toArray());
		} finally {
			logger.info("findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta Fin");
		}
	}

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultas(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaListadoRelacionConsultas Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT COCOOR, CONRREG, CONRANRG, MONOMBRE, COFECHA, COCOSX, RANDESC, TIRNOMBRE, PSNOMBRE, PSNOMBREE, COTEXTO ");
			query.append(" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
				query.append(order);
			}

			return (List<ListadoConsultaResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoConsultaResultado>() {
						public ListadoConsultaResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoConsultaResultado(null, resultSet
									.getString("COCOOR"), resultSet
									.getInt("CONRREG"), resultSet
									.getLong("CONRANRG"), resultSet
									.getString("MONOMBRE"), resultSet
									.getDate("COFECHA"), resultSet
									.getString("COCOSX"), resultSet
									.getString("RANDESC"), resultSet
									.getString("PSNOMBRE"), resultSet
									.getString("PSNOMBREE"), resultSet
									.getString("TIRNOMBRE"), resultSet
									.getString("COTEXTO"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllConsultaListadoRelacionConsultas Fin");
		}
	}

	// /
	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasGeneral(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaListadoRelacionConsultas Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();

			where.append(" WHERE 1=1 AND t1.COCOTIR = t2.TIRCODIGO(+) AND t1.COCOPS = t3.PSCODIGO(+) AND t1.CORANCOD = t4.RANCOD(+) AND t1.COCOTFP = t5.TFPCODIGO(+) AND t1.COCOMO  = t7.MOCODIGO(+)"
					+ " AND t1.COCODIGO= t9.P9COCO(+) AND t9.P9COP8=  t8.P8CODIGO(+)");

			StringBuffer query = new StringBuffer(
					"SELECT t1.COCOOR || '-' || t1.CONRREG || '-' || t1.CONRANRG AS NUMERO_CONSULTA, t1.COCOOR, t1.CONRREG, t1.CONRANRG,  TO_CHAR(COFECHACONSUMIDOR, 'hh24:mi') AS HORACONSUMIDOR, t1.COFECHA, t1.COHORA,t7.MONOMBRE, t5.TFPNOMBRE,"
							+ " t5.TFPNOMBREE, t1.COTEXTO, t3.PSCODIGO, t3.PSNOMBRE, t3.PSNOMBREE, t2.TIRNOMBRE, t9.P9FERESP, t8.P8NOMBRE, t8.P8NOMBREE, t9.P9TERES, t1.CONOCO, t4.RANDESC, t1.COCOSX, t1.COCOEMCO, "
							+ " t1.CONRTELCO, t1.CONRFAXCO, t1.COEXTRANJERO, t1.NOMBRE_CP, t1.NOMBRE_PAIS, t1.DIRECCION_NOCAPV, t1.NOMBRE_PROVINCIA, t1.NOMBRE_MUNICIPIO, t1.NOMBRE_LOCALIDAD, t1.NOMBRE_CALLE,"
							+ " t1.NOMBRE_PORTAL, t1.NOMBRE_PISO ");

			query.append(" FROM CONSULTA t1 , MOTIVO t2 , PRODUCTO t3 , RANGO_EDAD t4 , FORMA_PRESENTACION t5, CENSO_MONITOR t7, TIPO_RESPUESTA t8, RESPUESTA t9 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
				query.append(order);
			}

			return (List<ListadoConsultaResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoConsultaResultado>() {
						public ListadoConsultaResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoConsultaResultado(resultSet
									.getString("NUMERO_CONSULTA"), resultSet
									.getString("COCOOR"), resultSet
									.getInt("CONRREG"), resultSet
									.getLong("CONRANRG"), resultSet
									.getString("HORACONSUMIDOR"), resultSet
									.getDate("COFECHA"), resultSet
									.getString("COHORA"), resultSet
									.getString("MONOMBRE"), resultSet
									.getString("TFPNOMBRE"), resultSet
									.getString("TFPNOMBREE"), resultSet
									.getString("COTEXTO"), resultSet
									.getString("PSCODIGO"), resultSet
									.getString("PSNOMBRE"), resultSet
									.getString("PSNOMBREE"), resultSet
									.getString("TIRNOMBRE"), resultSet
									.getDate("P9FERESP"), resultSet
									.getString("P8NOMBRE"), resultSet
									.getString("P8NOMBREE"), resultSet
									.getString("P9TERES"), resultSet
									.getString("CONOCO"), resultSet
									.getString("RANDESC"), resultSet
									.getString("COCOSX"), resultSet
									.getString("COCOEMCO"), resultSet
									.getString("CONRTELCO"), resultSet
									.getString("CONRFAXCO"), resultSet
									.getString("COEXTRANJERO"), resultSet
									.getString("NOMBRE_CP"), resultSet
									.getString("NOMBRE_PAIS"), resultSet
									.getString("DIRECCION_NOCAPV"), resultSet
									.getString("NOMBRE_PROVINCIA"), resultSet
									.getString("NOMBRE_MUNICIPIO"), resultSet
									.getString("NOMBRE_LOCALIDAD"), resultSet
									.getString("NOMBRE_CALLE"), resultSet
									.getString("NOMBRE_PORTAL"), resultSet
									.getString("NOMBRE_PISO"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllConsultaListadoRelacionConsultas Fin");
		}
	}

	// //
	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	public List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasAbreviada(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta) {
		logger.info("findAllConsultaListadoRelacionConsultasAbreviada Ini");
		try {
			StringBuffer where = new StringBuffer(3000);
			List<Object> params = new ArrayList<Object>();
			where.append(" WHERE 1=1 AND t1.COCOTIR= t2.TIRCODIGO(+) AND t1.COCOPS= t3.PSCODIGO(+) AND t1.CORANCOD= t4.RANCOD(+) AND t1.COCOTFP= t5.TFPCODIGO(+) AND t1.COCOMO= t7.MOCODIGO(+) ");

			StringBuffer query = new StringBuffer(
					"SELECT COCOOR || '-' || CONRREG || '-' || CONRANRG AS NUMERO_CONSULTA, MONOMBRE, COFECHA, PSNOMBRE, PSNOMBREE, TIRNOMBRE, COTEXTO ");
			query.append(" FROM CONSULTA t1 ,MOTIVO t2 ,PRODUCTO t3 ,RANGO_EDAD t4 ,FORMA_PRESENTACION t5,CENSO_MONITOR t7 ");

			where.append(getWhereEstadisticasConsultas(consulta, params,
					startsWith, fechaDesde, fechaHasta));

			query.append(where);

			StringBuffer order = new StringBuffer(3000);
			if (pagination != null) {
				if (pagination.getSort() != null) {
					order.append(" ORDER BY " + pagination.getSort() + " "
							+ pagination.getAscDsc() + " NULLS LAST ");
					query.append(order);
				}
				query = new StringBuffer(PaginationManager.getQueryLimits(
						pagination, query.toString()));
			} else {
				order.append(" ORDER BY COCOOR, CONRANRG, CONRREG ");
				query.append(order);
			}

			return (List<ListadoConsultaResultado>) this.jdbcTemplate.query(
					query.toString(),
					new RowMapper<ListadoConsultaResultado>() {
						public ListadoConsultaResultado mapRow(
								ResultSet resultSet, int rowNum)
								throws SQLException {
							return new ListadoConsultaResultado(resultSet
									.getString("NUMERO_CONSULTA"), null, null,
									null, resultSet.getString("MONOMBRE"),
									resultSet.getDate("COFECHA"), null, null,
									resultSet.getString("PSNOMBRE"), resultSet
											.getString("PSNOMBREE"), resultSet
											.getString("TIRNOMBRE"), resultSet
											.getString("COTEXTO"));
						}
					}, params.toArray());
		} finally {
			logger.info("findAllConsultaListadoRelacionConsultasAbreviada Fin");
		}
	}

	/**
	 * Obtain the where in estadisticas consultas.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param params
	 *            List
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return String
	 */

	private static String getWhereEstadisticasConsultas(Consulta consulta,
			List<Object> params, Boolean startsWith, Date fechaDesde,
			Date fechaHasta) {

		StringBuffer where = new StringBuffer(3000);

		if (consulta != null && consulta.getCocodigo() != null) {
			where.append(" AND t1.COCODIGO = ?");
			params.add(consulta.getCocodigo());
		}
		if (consulta != null && consulta.getMotivo() != null
				&& consulta.getMotivo().getTircodigo() != null) {
			where.append(" AND t2.TIRCODIGO = ?");
			params.add(consulta.getMotivo().getTircodigo());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(consulta.getProducto().getPscodigo());
		}
		if (consulta != null
				&& consulta.getProducto() != null
				&& consulta.getProducto().getProdAgrupado() != null
				&& consulta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(consulta.getProducto().getProdAgrupado().getE8codigo());
		}

		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(consulta.getProducto().getPsnoco());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(consulta.getProducto().getPsdescri());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(consulta.getProducto().getPscose());
		}

		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(consulta.getProducto().getPsnombrei());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(consulta.getProducto().getPsnombref());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(consulta.getProducto().getPsnombrea());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(consulta.getProducto().getPsnocoe());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(consulta.getProducto().getPsnocoi());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(consulta.getProducto().getPsnocof());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(consulta.getProducto().getPsnocoa());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(consulta.getProducto().getPsdescrie());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(consulta.getProducto().getPsdescrii());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(consulta.getProducto().getPsdescrif());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(consulta.getProducto().getPsdescria());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(consulta.getProducto().getPssel1());
		}
		if (consulta != null && consulta.getProducto() != null
				&& consulta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(consulta.getProducto().getPscoinc());
		}
		if (consulta != null && consulta.getRangoEdad() != null
				&& consulta.getRangoEdad().getRancod() != null) {
			where.append(" AND t4.RANCOD = ?");
			params.add(consulta.getRangoEdad().getRancod());
		}
		// if (consulta != null && consulta.getRangoEdad() != null
		// && consulta.getRangoEdad().getRandesc() != null) {
		// where.append(" AND t4.RANDESC = ?");
		// params.add(consulta.getRangoEdad().getRandesc());
		// }
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t5.TFPCODIGO = ?");
			params.add(consulta.getFormaPresentacion().getTfpcodigo());
		}

		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t5.TFPNOMBREI = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrei());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t5.TFPNOMBREF = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombref());
		}
		if (consulta != null && consulta.getFormaPresentacion() != null
				&& consulta.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t5.TFPNOMBREA = ?");
			params.add(consulta.getFormaPresentacion().getTfpnombrea());
		}
		if (consulta != null && consulta.getOrganismo() != null
				&& consulta.getOrganismo().getCodOrg() != null) {
			where.append(" AND t1.COCOOR = ?");
			params.add(consulta.getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t7.MOCODIGO = ?");
			params.add(consulta.getCensoMonitor().getMocodigo());
		}
		if (consulta != null
				&& consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getOrganismo() != null
				&& consulta.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t7.MOCOOR = ?");
			params.add(consulta.getCensoMonitor().getOrganismo().getCodOrg());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t7.MOCOEM = ?");
			params.add(consulta.getCensoMonitor().getMocoem());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMousu() != null) {
			where.append(" AND t7.MOUSU = ?");
			params.add(consulta.getCensoMonitor().getMousu());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t7.MOCLAVE = ?");
			params.add(consulta.getCensoMonitor().getMoclave());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t7.MOFECBAJA = ?");
			params.add(consulta.getCensoMonitor().getMofecbaja());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t7.MOADMIN = ?");
			params.add(consulta.getCensoMonitor().getMoadmin());
		}
		if (consulta != null && consulta.getCensoMonitor() != null
				&& consulta.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t7.MOPRIMERA = ?");
			params.add(consulta.getCensoMonitor().getMoprimera());
		}
		if (consulta != null && consulta.getCofecha() != null) {
			where.append(" AND t1.COFECHA = ?");
			params.add(consulta.getCofecha());
		}
		if (consulta != null && consulta.getCocosx() != null) {
			where.append(" AND t1.COCOSX = ?");
			params.add(consulta.getCocosx());
		}
		if (consulta != null && consulta.getConran() != null) {
			where.append(" AND t1.CONRAN = ?");
			params.add(consulta.getConran());
		}
		if (consulta != null && consulta.getCocose() != null) {
			where.append(" AND t1.COCOSE = ?");
			params.add(consulta.getCocose());
		}
		if (consulta != null && consulta.getCotexto() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.COTEXTO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getCotexto().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ consulta.getCotexto().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.COTEXTO IS NOT NULL");
		}
		if (consulta != null && consulta.getConrreg() != null) {
			where.append(" AND t1.CONRREG = ?");
			params.add(consulta.getConrreg());
		}
		if (consulta != null && consulta.getConoco() != null) {
			where.append(" AND TRANSLATE(UPPER(t1.CONOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consulta.getConoco().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ consulta.getConoco().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.CONOCO IS NOT NULL");
		}
		if (consulta != null && consulta.getConodirco() != null) {
			where.append(" AND t1.CONODIRCO = ?");
			params.add(consulta.getConodirco());
		}
		if (consulta != null && consulta.getConrcpco() != null) {
			where.append(" AND t1.CONRCPCO = ?");
			params.add(consulta.getConrcpco());
		}
		if (consulta != null && consulta.getCocoloco() != null) {
			where.append(" AND t1.COCOLOCO = ?");
			params.add(consulta.getCocoloco());
		}
		if (consulta != null && consulta.getConoloco() != null) {
			where.append(" AND t1.CONOLOCO = ?");
			params.add(consulta.getConoloco());
		}
		if (consulta != null && consulta.getConomuco() != null) {
			where.append(" AND t1.CONOMUCO = ?");
			params.add(consulta.getConomuco());
		}
		if (consulta != null && consulta.getCocopvco() != null) {
			where.append(" AND t1.COCOPVCO = ?");
			params.add(consulta.getCocopvco());
		}
		if (consulta != null && consulta.getCocopaco() != null) {
			where.append(" AND t1.COCOPACO = ?");
			params.add(consulta.getCocopaco());
		}
		if (consulta != null && consulta.getConrtelco() != null) {
			where.append(" AND t1.CONRTELCO = ?");
			params.add(consulta.getConrtelco());
		}
		if (consulta != null && consulta.getConrfaxco() != null) {
			where.append(" AND t1.CONRFAXCO = ?");
			params.add(consulta.getConrfaxco());
		}
		if (consulta != null && consulta.getCocoemco() != null) {
			where.append(" AND t1.COCOEMCO = ?");
			params.add(consulta.getCocoemco());
		}
		if (consulta != null && consulta.getCoferes() != null) {
			where.append(" AND t1.COFERES = ?");
			params.add(consulta.getCoferes());
		}
		if (consulta != null && consulta.getCoinreenv() != null) {
			where.append(" AND t1.COINREENV = ?");
			params.add(consulta.getCoinreenv());
		}
		if (consulta != null && consulta.getCoteresp() != null) {
			where.append(" AND t1.COTERESP = ?");
			params.add(consulta.getCoteresp());
		}
		if (consulta != null && consulta.getCocotfpr() != null) {
			where.append(" AND t1.COCOTFPR = ?");
			params.add(consulta.getCocotfpr());
		}
		if (consulta != null && consulta.getCoinl37() != null) {
			where.append(" AND (t1.COINL37 = ?");
			params.add(consulta.getCoinl37());

			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" OR t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
			where.append(" ) ");
		}
		if (consulta != null && consulta.getCoinl37() == null) {
			if (consulta != null && consulta.getCoinl21() != null) {
				where.append(" AND t1.COINL21 = ?");
				params.add(consulta.getCoinl21());
			}
		}
		if (consulta != null && consulta.getConranrg() != null) {
			where.append(" AND t1.CONRANRG = ?");
			params.add(consulta.getConranrg());
		}
		if (consulta != null && consulta.getCocopro() != null) {
			where.append(" AND t1.COCOPRO = ?");
			params.add(consulta.getCocopro());
		}
		if (consulta != null && consulta.getCohdcodigo() != null) {
			where.append(" AND t1.COHDCODIGO = ?");
			params.add(consulta.getCohdcodigo());
		}
		if (consulta != null && consulta.getCohora() != null) {
			where.append(" AND t1.COHORA = ?");
			params.add(consulta.getCohora());
		}
		if (consulta != null && consulta.getCofechaconsumidor() != null) {
			where.append(" AND t1.COFECHACONSUMIDOR = ?");
			params.add(consulta.getCofechaconsumidor());
		}
		if (consulta != null && consulta.getNoraPaisId() != null) {
			where.append(" AND t1.NORA_PAIS_ID = ?");
			params.add(consulta.getNoraPaisId());
		}
		if (consulta != null && consulta.getNombrePais() != null) {
			where.append(" AND t1.NOMBRE_PAIS = ?");
			params.add(consulta.getNombrePais());
		}
		if (consulta != null && consulta.getNoraProvinciaId() != null) {
			where.append(" AND t1.NORA_PROVINCIA_ID = ?");
			params.add(consulta.getNoraProvinciaId());
		}
		if (consulta != null && consulta.getNoraMunicipioId() != null) {
			where.append(" AND t1.NORA_MUNICIPIO_ID = ?");
			params.add(consulta.getNoraMunicipioId());
		}
		if (consulta != null && consulta.getNoraLocalidadId() != null) {
			where.append(" AND t1.NORA_LOCALIDAD_ID = ?");
			params.add(consulta.getNoraLocalidadId());
		}
		if (consulta != null && consulta.getNoraCalleId() != null) {
			where.append(" AND t1.NORA_CALLE_ID = ?");
			params.add(consulta.getNoraCalleId());
		}
		if (consulta != null && consulta.getNombreCalle() != null) {
			where.append(" AND t1.NOMBRE_CALLE = ?");
			params.add(consulta.getNombreCalle());
		}
		if (consulta != null && consulta.getNoraCpId() != null) {
			where.append(" AND t1.NORA_CP_ID = ?");
			params.add(consulta.getNoraCpId());
		}
		if (consulta != null && consulta.getNombreCp() != null) {
			where.append(" AND t1.NOMBRE_CP = ?");
			params.add(consulta.getNombreCp());
		}
		if (consulta != null && consulta.getNoraPortalId() != null) {
			where.append(" AND t1.NORA_PORTAL_ID = ?");
			params.add(consulta.getNoraPortalId());
		}
		if (consulta != null && consulta.getNombrePortal() != null) {
			where.append(" AND t1.NOMBRE_PORTAL = ?");
			params.add(consulta.getNombrePortal());
		}

		if (consulta != null && consulta.getCosituacion() != null) {
			if (consulta.getCosituacion().equals(
					Y41aConstantes.SITUACION_PENDIENTES)) {
				where.append(" AND COFERES IS NULL ");
			}
			if (consulta.getCosituacion().equals(
					Y41aConstantes.SITUACION_RESUELTAS)) {
				where.append(" AND COFERES IS NOT NULL ");
			}
		}

		if (consulta != null && consulta.getNombrePiso() != null) {
			where.append(" AND t1.NOMBRE_PISO = ?");
			params.add(consulta.getNombrePiso());
		}

		/*
		 * Fechas desde hasta del envio de la operacion.
		 */
		if (fechaDesde != null && fechaDesde instanceof Date) {
			where.append(" AND t1.COFECHA >= ?");
			params.add(fechaDesde);
		}
		if (fechaHasta != null && fechaHasta instanceof Date) {
			where.append(" AND t1.COFECHA <= ?");
			params.add(fechaHasta);
		}

		return where.toString();
	}
}