package com.ejie.y41a.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.EstadisticasConsultasResultado;
import com.ejie.y41a.model.EstadisticasConsultasTiempoAtencion;
import com.ejie.y41a.model.ListadoConsultaResultado;

/**
 * * EstadisticasListadosConsultasDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface EstadisticasListadosConsultasDao {

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaFormaPresentacion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaMotivosProductos(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaProductoServicio(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaSexoEdad(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasResultado> findAllConsultaEstadisticaPromedioMedioResponderConsulta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasPresencialesTiempoAtencion(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<EstadisticasConsultasTiempoAtencion> findAllConsultaEstadisticaConsultasWebFaxTiempoRespuesta(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultas(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasGeneral(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<ListadoConsultaResultado> findAllConsultaListadoRelacionConsultasAbreviada(
			Consulta consulta, Pagination pagination, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);
}
