package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Organismo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Establecimiento;

/**
 * * EstablecimientoDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class EstablecimientoDaoImpl implements EstablecimientoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Establecimiento> rwMap = new RowMapper<Establecimiento>() {
		public Establecimiento mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Establecimiento(resultSet.getString("ESCODIGO"),
					resultSet.getString("ESNOMBRE"),
					resultSet.getString("ESNIF"),
					resultSet.getString("ESNOAN"),
					resultSet.getString("ESNOCO"),
					resultSet.getString("ESNODIR"),
					resultSet.getString("ESCOLO"),
					resultSet.getString("ESNRCOPO"),
					resultSet.getString("ESNRTEL"),
					resultSet.getString("ESNRFAX"),
					resultSet.getString("ESCOPA"),
					resultSet.getString("ESINCAPR"),
					resultSet.getString("ESINDEMP"),
					resultSet.getString("ESTECO"),
					resultSet.getString("ESINADAR"),
					resultSet.getDate("ESFEADAR"),
					resultSet.getString("ESCOEM"),
					resultSet.getString("ESINEMPR"),
					resultSet.getString("ESNRTEL2"),
					resultSet.getDate("ESFEBA"),
					resultSet.getString("ESNOAP1"),
					resultSet.getString("ESNOAP2"),
					resultSet.getString("ESNOLO"),
					resultSet.getString("ESCOMAPV"),
					resultSet.getString("ESCOCA"),
					resultSet.getString("ESNOPECO"),
					resultSet.getString("ESCOIDCO"),
					resultSet.getString("ESINRECO"),
					resultSet.getString("ESFEMOD"),
					resultSet.getString("ESINESCO"),
					resultSet.getString("ESNOMU"),
					resultSet.getString("ESNOREP"),
					resultSet.getString("ESNIFREP"),
					resultSet.getString("DTTEEMR"),
					resultSet.getString("ESCAREP"),
					resultSet.getString("ESTEURL"),
					resultSet.getString("ESCOOE"),
					resultSet.getString("ESNODECO"),
					resultSet.getString("ESINTIAR"),
					resultSet.getDate("ESFEPLAD"),
					resultSet.getString("ESINDEME"),
					resultSet.getString("ESNORAPAISID"),
					resultSet.getString("ESNORAPAISNOMBRE"),
					resultSet.getString("ESNORAPROVINCIAID"),
					resultSet.getString("ESNOMBREPROVINCIA"),
					resultSet.getString("ESNORAMUNICIPIOID"),
					resultSet.getString("ESNOMBREMUNICIPIO"),
					resultSet.getString("ESNORALOCALIDADID"),
					resultSet.getString("ESNOMBRELOCALIDAD"),
					resultSet.getString("ESNORACALLEID"),
					resultSet.getString("ESNOMBRECALLE"),
					resultSet.getString("ESNORACPID"),
					resultSet.getString("ESNOMBRECP"),
					resultSet.getString("ESNORAPORTALID"),
					resultSet.getString("ESNOMBREPORTAL"),
					resultSet.getString("ESNOMBREPISO"),
					resultSet.getString("ESDIRECCION_NOCAPV"),
					resultSet.getString("ESEXTRANJERO"), null,
					new CensoMonitor(resultSet
							.getString("CensoMonitorMOCODIGO"), resultSet
							.getString("CensoMonitorMONOMBRE"), resultSet
							.getString("CensoMonitorMOCOEM"), resultSet
							.getString("CensoMonitorMOUSU"), resultSet
							.getString("CensoMonitorMOCLAVE"), resultSet
							.getDate("CensoMonitorMOFECBAJA"), resultSet
							.getString("CensoMonitorMOADMIN"), resultSet
							.getString("CensoMonitorMOPRIMERA"), new Organismo(
							resultSet.getString("CensoMonitorMOCOOR"), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento add(Establecimiento establecimiento) {

		String query = "INSERT INTO ESTABLECIMIENTO( ESCODIGO,ESCOZS,ESNOMBRE,ESNIF,ESNOAN,ESNOCO,ESNODIR,ESCOLO,ESNRCOPO,ESNRTEL,ESNRFAX,ESCOPA,ESINCAPR,ESINDEMP,ESTECO,ESINADAR,ESFEADAR,ESCOEM,ESINEMPR,ESNRTEL2,ESFEBA,ESNOAP1,ESNOAP2,ESNOLO,ESCOMAPV,ESCOCA,ESNOPECO,ESCOIDCO,ESINRECO,ESFEMOD,ESINESCO,ESNOMU,ESNOREP,ESNIFREP,DTTEEMR,ESCAREP,ESTEURL,ESCOOE,ESNODECO,ESINTIAR,ESFEPLAD,ESINDEME,ESNORA_PAIS_ID,ESNORA_PAIS_NOMBRE,ESNORA_PROVINCIA_ID,ESNOMBRE_PROVINCIA,ESNORA_MUNICIPIO_ID,ESNOMBRE_MUNICIPIO,ESNORA_LOCALIDAD_ID,ESNOMBRE_LOCALIDAD,ESNORA_CALLE_ID,ESNOMBRE_CALLE,ESNORA_CP_ID,ESNOMBRE_CP,ESNORA_PORTAL_ID,ESNOMBRE_PORTAL,ESNOMBRE_PISO,ESDIRECCION_NOCAPV,ESEXTRANJERO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getCensoMonitorMocodigoAux = null;
		if (establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = establecimiento.getCensoMonitor()
					.getMocodigo();
		}
		this.jdbcTemplate.update(query, establecimiento.getEscodigo(),
				getCensoMonitorMocodigoAux, establecimiento.getEsnombre(),
				establecimiento.getEsnif(), establecimiento.getEsnoan(),
				establecimiento.getEsnoco(), establecimiento.getEsnodir(),
				establecimiento.getEscolo(), establecimiento.getEsnrcopo(),
				establecimiento.getEsnrtel(), establecimiento.getEsnrfax(),
				establecimiento.getEscopa(), establecimiento.getEsincapr(),
				establecimiento.getEsindemp(), establecimiento.getEsteco(),
				establecimiento.getEsinadar(), establecimiento.getEsfeadar(),
				establecimiento.getEscoem(), establecimiento.getEsinempr(),
				establecimiento.getEsnrtel2(), establecimiento.getEsfeba(),
				establecimiento.getEsnoap1(), establecimiento.getEsnoap2(),
				establecimiento.getEsnolo(), establecimiento.getEscomapv(),
				establecimiento.getEscoca(), establecimiento.getEsnopeco(),
				establecimiento.getEscoidco(), establecimiento.getEsinreco(),
				establecimiento.getEsfemod(), establecimiento.getEsinesco(),
				establecimiento.getEsnomu(), establecimiento.getEsnorep(),
				establecimiento.getEsnifrep(), establecimiento.getDtteemr(),
				establecimiento.getEscarep(), establecimiento.getEsteurl(),
				establecimiento.getEscooe(), establecimiento.getEsnodeco(),
				establecimiento.getEsintiar(), establecimiento.getEsfeplad(),
				establecimiento.getEsindeme(),
				establecimiento.getEsnoraPaisId(),
				establecimiento.getEsnoraPaisNombre(),
				establecimiento.getEsnoraProvinciaId(),
				establecimiento.getEsnombreProvincia(),
				establecimiento.getEsnoraMunicipioId(),
				establecimiento.getEsnombreMunicipio(),
				establecimiento.getEsnoraLocalidadId(),
				establecimiento.getEsnombreLocalidad(),
				establecimiento.getEsnoraCalleId(),
				establecimiento.getEsnombreCalle(),
				establecimiento.getEsnoraCpId(),
				establecimiento.getEsnombreCp(),
				establecimiento.getEsnoraPortalId(),
				establecimiento.getEsnombrePortal(),
				establecimiento.getEsnombrePiso(),
				establecimiento.getEsdireccion_nocapv(),
				establecimiento.getEsextranjero());
		return establecimiento;
	}

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	public Establecimiento update(Establecimiento establecimiento) {
		String query = "UPDATE ESTABLECIMIENTO SET ESCOZS=?,ESNOMBRE=?,ESNIF=?,ESNOCO=?,ESNRTEL=?,ESTECO=?,ESINADAR=?,ESFEADAR=?,ESCOEM=?,ESNRTEL2=?,ESFEBA=?,ESNOPECO=?,ESCOIDCO=?,ESFEMOD=?,ESTEURL=?,ESNORA_PAIS_ID=?,ESNORA_PAIS_NOMBRE=?,ESNORA_PROVINCIA_ID=?,ESNOMBRE_PROVINCIA=?,ESNORA_MUNICIPIO_ID=?,ESNOMBRE_MUNICIPIO=?,ESNORA_LOCALIDAD_ID=?,ESNOMBRE_LOCALIDAD=?,ESNORA_CALLE_ID=?,ESNOMBRE_CALLE=?,ESNORA_CP_ID=?,ESNOMBRE_CP=?,ESNORA_PORTAL_ID=?,ESNOMBRE_PORTAL=?,ESNOMBRE_PISO=?,ESDIRECCION_NOCAPV=?,ESEXTRANJERO=?, ESNOREP=?, ESNIFREP=?, ESCOOE=? WHERE ESCODIGO=?";
		Object getCensoMonitorMocodigoAux = null;
		if (establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			getCensoMonitorMocodigoAux = establecimiento.getCensoMonitor()
					.getMocodigo();
		}
		this.jdbcTemplate.update(query, getCensoMonitorMocodigoAux,
				establecimiento.getEsnombre(), establecimiento.getEsnif(),
				establecimiento.getEsnoco(), establecimiento.getEsnrtel(),
				establecimiento.getEsteco(), establecimiento.getEsinadar(),
				establecimiento.getEsfeadar(), establecimiento.getEscoem(),
				establecimiento.getEsnrtel2(), establecimiento.getEsfeba(),
				establecimiento.getEsnopeco(), establecimiento.getEscoidco(),
				establecimiento.getEsfemod(), establecimiento.getEsteurl(),
				establecimiento.getEsnoraPaisId(),
				establecimiento.getEsnoraPaisNombre(),
				establecimiento.getEsnoraProvinciaId(),
				establecimiento.getEsnombreProvincia(),
				establecimiento.getEsnoraMunicipioId(),
				establecimiento.getEsnombreMunicipio(),
				establecimiento.getEsnoraLocalidadId(),
				establecimiento.getEsnombreLocalidad(),
				establecimiento.getEsnoraCalleId(),
				establecimiento.getEsnombreCalle(),
				establecimiento.getEsnoraCpId(),
				establecimiento.getEsnombreCp(),
				establecimiento.getEsnoraPortalId(),
				establecimiento.getEsnombrePortal(),
				establecimiento.getEsnombrePiso(),
				establecimiento.getEsdireccion_nocapv(),
				establecimiento.getEsextranjero(),
				establecimiento.getEsnorep(), establecimiento.getEsnifrep(),
				establecimiento.getEscooe(), establecimiento.getEscodigo());
		return establecimiento;
	}

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return Establecimiento
	 */
	@Transactional(readOnly = true)
	public Establecimiento find(Establecimiento establecimiento) {
		String query = "SELECT t1.ESCODIGO ESCODIGO, t1.ESNOMBRE ESNOMBRE, t1.ESNIF ESNIF, t1.ESNOAN ESNOAN, t1.ESNOCO ESNOCO, t1.ESNODIR ESNODIR, t1.ESCOLO ESCOLO, t1.ESNRCOPO ESNRCOPO, t1.ESNRTEL ESNRTEL, t1.ESNRFAX ESNRFAX, t1.ESCOPA ESCOPA, t1.ESINCAPR ESINCAPR, t1.ESINDEMP ESINDEMP, t1.ESTECO ESTECO, t1.ESFEADAR ESFEADAR, t1.ESCOEM ESCOEM, t1.ESINEMPR ESINEMPR, t1.ESNRTEL2 ESNRTEL2, t1.ESFEBA ESFEBA, t1.ESNOAP1 ESNOAP1, t1.ESNOAP2 ESNOAP2, t1.ESNOLO ESNOLO, t1.ESCOMAPV ESCOMAPV, t1.ESCOCA ESCOCA, t1.ESNOPECO ESNOPECO, t1.ESCOIDCO ESCOIDCO, t1.ESINRECO ESINRECO, t1.ESFEMOD ESFEMOD, t1.ESINESCO ESINESCO, t1.ESNOMU ESNOMU, t1.ESNOREP ESNOREP, t1.ESNIFREP ESNIFREP, t1.DTTEEMR DTTEEMR, t1.ESCAREP ESCAREP, t1.ESTEURL ESTEURL, t1.ESCOOE ESCOOE, t1.ESNODECO ESNODECO, t1.ESINTIAR ESINTIAR, t1.ESFEPLAD ESFEPLAD, t1.ESINDEME ESINDEME, t1.ESNORA_PAIS_ID ESNORAPAISID, t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE, t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID, t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA, t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID, t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t1.ESNORA_CALLE_ID ESNORACALLEID, t1.ESNOMBRE_CALLE ESNOMBRECALLE, t1.ESNORA_CP_ID ESNORACPID, t1.ESNOMBRE_CP ESNOMBRECP, t1.ESNORA_PORTAL_ID ESNORAPORTALID, t1.ESNOMBRE_PORTAL ESNOMBREPORTAL, t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t2.MOCODIGO CENSOMONITORMOCODIGO, t2.MONOMBRE CENSOMONITORMONOMBRE, t2.MOCOEM CENSOMONITORMOCOEM, t2.MOUSU CENSOMONITORMOUSU, t2.MOCLAVE CENSOMONITORMOCLAVE, t2.MOFECBAJA CENSOMONITORMOFECBAJA, t2.MOADMIN CENSOMONITORMOADMIN, t2.MOPRIMERA CENSOMONITORMOPRIMERA, t2.MOCOOR CENSOMONITORMOCOOR, CASE WHEN t1.ESFEADAR IS NULL OR t3.AHCODIGO IS NULL THEN 'N' WHEN t3.AHCODIGO IS NOT NULL AND t3.AHFEBA IS NOT NULL AND t3.AHFEBA<SYSDATE THEN 'B' ELSE 'A' END ESINADAR "
				+ "FROM ESTABLECIMIENTO t1, CENSO_MONITOR t2, ESTABLECIM_ARBITRA t3 "
				+ "WHERE t1.ESCODIGO = ?   AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.AHCOES(+) ";
		return (Establecimiento) this.jdbcTemplate.queryForObject(query, rwMap,
				establecimiento.getEscodigo());
	}

	/**
	 * Removes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Pagination
	 * @return
	 */
	public void remove(Establecimiento establecimiento) {
		String query = "DELETE  FROM ESTABLECIMIENTO WHERE ESCODIGO=?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAll(Establecimiento establecimiento,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM,t2.MOUSU CENSOMONITORMOUSU,t2.MOCLAVE CENSOMONITORMOCLAVE,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOADMIN CENSOMONITORMOADMIN,t2.MOPRIMERA CENSOMONITORMOPRIMERA,t2.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMousu() != null) {
			where.append(" AND t2.MOUSU = ?");
			params.add(establecimiento.getCensoMonitor().getMousu());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t2.MOCLAVE = ?");
			params.add(establecimiento.getCensoMonitor().getMoclave());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t2.MOADMIN = ?");
			params.add(establecimiento.getCensoMonitor().getMoadmin());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t2.MOPRIMERA = ?");
			params.add(establecimiento.getCensoMonitor().getMoprimera());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND t1.ESNOMBRE = ?");
			params.add(establecimiento.getEsnombre());
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND t1.ESNIF = ?");
			params.add(establecimiento.getEsnif());
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			where.append(" AND t1.ESINADAR = ?");
			params.add(establecimiento.getEsinadar());
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePiso() != null) {
			where.append(" AND t1.ESNOMBRE_PISO = ?");
			params.add(establecimiento.getEsnombrePiso());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Establecimiento establecimiento) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ESCOZS= t2.MOCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ESTABLECIMIENTO t1   ,  CENSO_MONITOR t2  ");
		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMousu() != null) {
			where.append(" AND t2.MOUSU = ?");
			params.add(establecimiento.getCensoMonitor().getMousu());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t2.MOCLAVE = ?");
			params.add(establecimiento.getCensoMonitor().getMoclave());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t2.MOADMIN = ?");
			params.add(establecimiento.getCensoMonitor().getMoadmin());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t2.MOPRIMERA = ?");
			params.add(establecimiento.getCensoMonitor().getMoprimera());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND t1.ESNOMBRE = ?");
			params.add(establecimiento.getEsnombre());
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND t1.ESNIF = ?");
			params.add(establecimiento.getEsnif());
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			where.append(" AND t1.ESINADAR = ?");
			params.add(establecimiento.getEsinadar());
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePiso() != null) {
			where.append(" AND t1.ESNOMBRE_PISO = ?");
			params.add(establecimiento.getEsnombrePiso());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAllLike(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESINADAR ESINADAR,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t1.ESEXTRANJERO ESEXTRANJERO, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM,t2.MOUSU CENSOMONITORMOUSU,t2.MOCLAVE CENSOMONITORMOCLAVE,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOADMIN CENSOMONITORMOADMIN,t2.MOPRIMERA CENSOMONITORMOPRIMERA,t2.MOCOOR CENSOMONITORMOCOOR "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscodigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMocodigo()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMocodigo() + "%");
			}
			where.append(" AND t2.MOCODIGO IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t2.MOCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getOrganismo()
						.getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getOrganismo()
								.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOOR IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND UPPER(t2.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMonombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMonombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MONOMBRE IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND UPPER(t2.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMocoem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMocoem()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOCOEM IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMousu() != null) {
			where.append(" AND UPPER(t2.MOUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMousu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMousu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOUSU IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoclave() != null) {
			where.append(" AND UPPER(t2.MOCLAVE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMoclave()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMoclave()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOCLAVE IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMofecbaja()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMofecbaja()
						+ "%");
			}
			where.append(" AND t2.MOFECBAJA IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND UPPER(t2.MOADMIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMoadmin()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMoadmin()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOADMIN IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND UPPER(t2.MOPRIMERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getCensoMonitor().getMoprimera()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getCensoMonitor().getMoprimera()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.MOPRIMERA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND UPPER(t1.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoan().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoan().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOAN IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND UPPER(t1.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND UPPER(t1.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnodir().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnodir().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNODIR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND UPPER(t1.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOLO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND UPPER(t1.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrcopo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrcopo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNRCOPO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND UPPER(t1.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrtel().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNRTEL IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND UPPER(t1.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrfax().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrfax().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNRFAX IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND UPPER(t1.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscopa().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOPA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND UPPER(t1.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsincapr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsincapr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINCAPR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND UPPER(t1.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsindemp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsindemp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINDEMP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND UPPER(t1.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsteco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsteco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESTECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			where.append(" AND UPPER(t1.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinadar().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinadar().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINADAR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeadar() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeadar() + "%");
			}
			where.append(" AND t1.ESFEADAR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND UPPER(t1.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoem().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOEM IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND UPPER(t1.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinempr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinempr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINEMPR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND UPPER(t1.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnrtel2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNRTEL2 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeba() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeba() + "%");
			}
			where.append(" AND t1.ESFEBA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND UPPER(t1.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoap1().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoap1().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOAP1 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND UPPER(t1.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoap2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoap2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOAP2 IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND UPPER(t1.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnolo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOLO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND UPPER(t1.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscomapv().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscomapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOMAPV IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND UPPER(t1.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoca().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoca().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOCA IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND UPPER(t1.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnopeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnopeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOPECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND UPPER(t1.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscoidco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscoidco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOIDCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND UPPER(t1.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinreco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinreco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINRECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND UPPER(t1.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfemod().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsfemod().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESFEMOD IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND UPPER(t1.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsinesco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsinesco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINESCO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND UPPER(t1.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnomu().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnomu().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMU IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND UPPER(t1.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnorep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnorep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND UPPER(t1.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnifrep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnifrep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNIFREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND UPPER(t1.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getDtteemr().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getDtteemr().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DTTEEMR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND UPPER(t1.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscarep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscarep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCAREP IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND UPPER(t1.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsteurl().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsteurl().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESTEURL IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND UPPER(t1.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEscooe().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEscooe().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESCOOE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND UPPER(t1.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnodeco().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnodeco().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNODECO IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND UPPER(t1.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsintiar().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsintiar().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINTIAR IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsfeplad() + "%");
			} else {
				params.add("%" + establecimiento.getEsfeplad() + "%");
			}
			where.append(" AND t1.ESFEPLAD IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND UPPER(t1.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsindeme().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsindeme().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESINDEME IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPaisId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraPaisId().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t1.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPaisNombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraPaisNombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraProvinciaId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraProvinciaId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreProvincia().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombreProvincia().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t1.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraMunicipioId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraMunicipioId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreMunicipio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombreMunicipio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t1.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraLocalidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraLocalidadId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreLocalidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombreLocalidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t1.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraCalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreCalle() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreCalle().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND UPPER(t1.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraCpId().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_CP_ID IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombreCp().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_CP IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t1.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnoraPortalId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePortal() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePortal().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePiso() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Establecimiento> findAllLikeEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ESCOZS= t2.MOCODIGO(+) AND t1.ESCODIGO = t3.EACOES(+) AND t1.ESCODIGO = t4.AHCOES(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  distinct t1.ESCODIGO ESCODIGO,t1.ESNOMBRE ESNOMBRE,t1.ESNIF ESNIF,t1.ESNOAN ESNOAN,t1.ESNOCO ESNOCO,t1.ESNODIR ESNODIR,t1.ESCOLO ESCOLO,t1.ESNRCOPO ESNRCOPO,t1.ESNRTEL ESNRTEL,t1.ESNRFAX ESNRFAX,t1.ESCOPA ESCOPA,t1.ESINCAPR ESINCAPR,t1.ESINDEMP ESINDEMP,t1.ESTECO ESTECO,t1.ESFEADAR ESFEADAR,t1.ESCOEM ESCOEM,t1.ESINEMPR ESINEMPR,t1.ESNRTEL2 ESNRTEL2,t1.ESFEBA ESFEBA,t1.ESNOAP1 ESNOAP1,t1.ESNOAP2 ESNOAP2,t1.ESNOLO ESNOLO,t1.ESCOMAPV ESCOMAPV,t1.ESCOCA ESCOCA,t1.ESNOPECO ESNOPECO,t1.ESCOIDCO ESCOIDCO,t1.ESINRECO ESINRECO,t1.ESFEMOD ESFEMOD,t1.ESINESCO ESINESCO,t1.ESNOMU ESNOMU,t1.ESNOREP ESNOREP,t1.ESNIFREP ESNIFREP,t1.DTTEEMR DTTEEMR,t1.ESCAREP ESCAREP,t1.ESTEURL ESTEURL,t1.ESCOOE ESCOOE,t1.ESNODECO ESNODECO,t1.ESINTIAR ESINTIAR,t1.ESFEPLAD ESFEPLAD,t1.ESINDEME ESINDEME,t1.ESNORA_PAIS_ID ESNORAPAISID,t1.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,t1.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID,t1.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA,t1.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID,t1.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO,t1.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID,t1.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD,t1.ESNORA_CALLE_ID ESNORACALLEID,t1.ESNOMBRE_CALLE ESNOMBRECALLE,t1.ESNORA_CP_ID ESNORACPID,t1.ESNOMBRE_CP ESNOMBRECP,t1.ESNORA_PORTAL_ID ESNORAPORTALID,t1.ESNOMBRE_PORTAL ESNOMBREPORTAL,t1.ESNOMBRE_PISO ESNOMBREPISO, t1.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV,t1.ESEXTRANJERO ESEXTRANJERO, t2.MOCODIGO CENSOMONITORMOCODIGO,t2.MONOMBRE CENSOMONITORMONOMBRE,t2.MOCOEM CENSOMONITORMOCOEM,t2.MOUSU CENSOMONITORMOUSU,t2.MOCLAVE CENSOMONITORMOCLAVE,t2.MOFECBAJA CENSOMONITORMOFECBAJA,t2.MOADMIN CENSOMONITORMOADMIN,t2.MOPRIMERA CENSOMONITORMOPRIMERA,t2.MOCOOR CENSOMONITORMOCOOR, CASE WHEN t1.ESFEADAR IS NULL OR t4.AHCODIGO IS NULL THEN 'N' WHEN t4.AHCODIGO IS NOT NULL AND t4.AHFEBA IS NOT NULL AND t4.AHFEBA<SYSDATE THEN 'B' ELSE 'A' END ESINADAR "
						+ "FROM ESTABLECIMIENTO t1 ,CENSO_MONITOR t2, ESTABLECIM_SECTOR t3, ESTABLECIM_ARBITRA t4 ");

		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMousu() != null) {
			where.append(" AND t2.MOUSU = ?");
			params.add(establecimiento.getCensoMonitor().getMousu());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t2.MOCLAVE = ?");
			params.add(establecimiento.getCensoMonitor().getMoclave());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t2.MOADMIN = ?");
			params.add(establecimiento.getCensoMonitor().getMoadmin());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t2.MOPRIMERA = ?");
			params.add(establecimiento.getCensoMonitor().getMoprimera());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL)) ");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			// Sacar solamente los ADHERIDOS (que no esten de baja)
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41aConstantes.SI.equals(establecimiento.getEsinadar())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND (t4.AHFEBA IS NULL OR ( t4.AHFEBA IS NOT NULL AND t4.AHFEBA >= TRUNC(SYSDATE)))");
			}
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsinfeba() == null) {
			where.append(" AND t1.ESFEBA IS NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePiso() != null) {
			where.append(" AND UPPER(t1.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombrePiso().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombrePiso().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNOMBRE_PISO IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsdireccion_nocapv() != null) {
			where.append(" AND UPPER(t1.ESDIRECCION_NOCAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsdireccion_nocapv()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ establecimiento.getEsdireccion_nocapv().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESDIRECCION_NOCAPV IS NOT NULL");
		}
		if (establecimiento != null
				&& establecimiento.getEsextranjero() != null
				&& establecimiento.getEsestado() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41aConstantes.SI);
		}
		if (establecimiento != null && establecimiento.getEsestado() != null
				&& establecimiento.getEsextranjero() == null) {
			where.append(" AND t1.ESEXTRANJERO = ?");
			params.add(Y41aConstantes.NO);
		}
		if (establecimSector != null && establecimSector.getSector() != null
				&& establecimSector.getSector().getSecodigo() != null) {
			where.append(" AND t3.EACOSE = ?");
			params.add(establecimSector.getSector().getSecodigo());
			where.append(" AND t3.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Establecimiento>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeEstablecimientoCount(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ESCOZS= t2.MOCODIGO(+)  AND t1.ESCODIGO = t3.EACOES(+) AND t1.ESCODIGO = t4.AHCOES(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(distinct t1.ESCODIGO) FROM  ESTABLECIMIENTO t1, CENSO_MONITOR t2, ESTABLECIM_SECTOR t3, ESTABLECIM_ARBITRA t4 ");
		if (establecimiento != null && establecimiento.getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimiento.getEscodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.MOCODIGO = ?");
			params.add(establecimiento.getCensoMonitor().getMocodigo());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getOrganismo() != null
				&& establecimiento.getCensoMonitor().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.MOCOOR = ?");
			params.add(establecimiento.getCensoMonitor().getOrganismo()
					.getCodOrg());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMonombre() != null) {
			where.append(" AND t2.MONOMBRE = ?");
			params.add(establecimiento.getCensoMonitor().getMonombre());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMocoem() != null) {
			where.append(" AND t2.MOCOEM = ?");
			params.add(establecimiento.getCensoMonitor().getMocoem());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMousu() != null) {
			where.append(" AND t2.MOUSU = ?");
			params.add(establecimiento.getCensoMonitor().getMousu());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoclave() != null) {
			where.append(" AND t2.MOCLAVE = ?");
			params.add(establecimiento.getCensoMonitor().getMoclave());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMofecbaja() != null) {
			where.append(" AND t2.MOFECBAJA = ?");
			params.add(establecimiento.getCensoMonitor().getMofecbaja());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoadmin() != null) {
			where.append(" AND t2.MOADMIN = ?");
			params.add(establecimiento.getCensoMonitor().getMoadmin());
		}
		if (establecimiento != null
				&& establecimiento.getCensoMonitor() != null
				&& establecimiento.getCensoMonitor().getMoprimera() != null) {
			where.append(" AND t2.MOPRIMERA = ?");
			params.add(establecimiento.getCensoMonitor().getMoprimera());
		}
		if (establecimiento != null && establecimiento.getEsnombre() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t1.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.ESNOMBRE IS NOT NULL) ");

			where.append(" OR (TRANSLATE(UPPER(t1.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnombre().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ establecimiento.getEsnombre().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t1.ESNOCO IS NOT NULL)) ");
		}
		if (establecimiento != null && establecimiento.getEsnif() != null) {
			where.append(" AND UPPER(t1.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimiento.getEsnif().toUpperCase() + "%");
			} else {
				params.add("%" + establecimiento.getEsnif().toUpperCase() + "%");
			}
			where.append(" AND t1.ESNIF IS NOT NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoan() != null) {
			where.append(" AND t1.ESNOAN = ?");
			params.add(establecimiento.getEsnoan());
		}
		if (establecimiento != null && establecimiento.getEsnoco() != null) {
			where.append(" AND t1.ESNOCO = ?");
			params.add(establecimiento.getEsnoco());
		}
		if (establecimiento != null && establecimiento.getEsnodir() != null) {
			where.append(" AND t1.ESNODIR = ?");
			params.add(establecimiento.getEsnodir());
		}
		if (establecimiento != null && establecimiento.getEscolo() != null) {
			where.append(" AND t1.ESCOLO = ?");
			params.add(establecimiento.getEscolo());
		}
		if (establecimiento != null && establecimiento.getEsnrcopo() != null) {
			where.append(" AND t1.ESNRCOPO = ?");
			params.add(establecimiento.getEsnrcopo());
		}
		if (establecimiento != null && establecimiento.getEsnrtel() != null) {
			where.append(" AND t1.ESNRTEL = ?");
			params.add(establecimiento.getEsnrtel());
		}
		if (establecimiento != null && establecimiento.getEsnrfax() != null) {
			where.append(" AND t1.ESNRFAX = ?");
			params.add(establecimiento.getEsnrfax());
		}
		if (establecimiento != null && establecimiento.getEscopa() != null) {
			where.append(" AND t1.ESCOPA = ?");
			params.add(establecimiento.getEscopa());
		}
		if (establecimiento != null && establecimiento.getEsincapr() != null) {
			where.append(" AND t1.ESINCAPR = ?");
			params.add(establecimiento.getEsincapr());
		}
		if (establecimiento != null && establecimiento.getEsindemp() != null) {
			where.append(" AND t1.ESINDEMP = ?");
			params.add(establecimiento.getEsindemp());
		}
		if (establecimiento != null && establecimiento.getEsteco() != null) {
			where.append(" AND t1.ESTECO = ?");
			params.add(establecimiento.getEsteco());
		}
		if (establecimiento != null && establecimiento.getEsinadar() != null) {
			// Sacar solamente los ADHERIDOS (que no esten de baja)
			// Para saber si el establecimiento esta adherido, debemos usar la
			// tabla de ADHERIDO_ESTABLECIMIENTO
			if (Y41aConstantes.SI.equals(establecimiento.getEsinadar())) {
				where.append(" AND t4.AHCODIGO IS NOT NULL");
				where.append(" AND (t4.AHFEBA IS NULL OR ( t4.AHFEBA IS NOT NULL AND t4.AHFEBA >= TRUNC(SYSDATE)))");
			}
		}
		if (establecimiento != null && establecimiento.getEsfeadar() != null) {
			where.append(" AND t1.ESFEADAR = ?");
			params.add(establecimiento.getEsfeadar());
		}
		if (establecimiento != null && establecimiento.getEscoem() != null) {
			where.append(" AND t1.ESCOEM = ?");
			params.add(establecimiento.getEscoem());
		}
		if (establecimiento != null && establecimiento.getEsinempr() != null) {
			where.append(" AND t1.ESINEMPR = ?");
			params.add(establecimiento.getEsinempr());
		}
		if (establecimiento != null && establecimiento.getEsnrtel2() != null) {
			where.append(" AND t1.ESNRTEL2 = ?");
			params.add(establecimiento.getEsnrtel2());
		}
		if (establecimiento != null && establecimiento.getEsfeba() != null) {
			where.append(" AND t1.ESFEBA = ?");
			params.add(establecimiento.getEsfeba());
		}
		if (establecimiento != null && establecimiento.getEsinfeba() == null) {
			where.append(" AND t1.ESFEBA IS NULL");
		}
		if (establecimiento != null && establecimiento.getEsnoap1() != null) {
			where.append(" AND t1.ESNOAP1 = ?");
			params.add(establecimiento.getEsnoap1());
		}
		if (establecimiento != null && establecimiento.getEsnoap2() != null) {
			where.append(" AND t1.ESNOAP2 = ?");
			params.add(establecimiento.getEsnoap2());
		}
		if (establecimiento != null && establecimiento.getEsnolo() != null) {
			where.append(" AND t1.ESNOLO = ?");
			params.add(establecimiento.getEsnolo());
		}
		if (establecimiento != null && establecimiento.getEscomapv() != null) {
			where.append(" AND t1.ESCOMAPV = ?");
			params.add(establecimiento.getEscomapv());
		}
		if (establecimiento != null && establecimiento.getEscoca() != null) {
			where.append(" AND t1.ESCOCA = ?");
			params.add(establecimiento.getEscoca());
		}
		if (establecimiento != null && establecimiento.getEsnopeco() != null) {
			where.append(" AND t1.ESNOPECO = ?");
			params.add(establecimiento.getEsnopeco());
		}
		if (establecimiento != null && establecimiento.getEscoidco() != null) {
			where.append(" AND t1.ESCOIDCO = ?");
			params.add(establecimiento.getEscoidco());
		}
		if (establecimiento != null && establecimiento.getEsinreco() != null) {
			where.append(" AND t1.ESINRECO = ?");
			params.add(establecimiento.getEsinreco());
		}
		if (establecimiento != null && establecimiento.getEsfemod() != null) {
			where.append(" AND t1.ESFEMOD = ?");
			params.add(establecimiento.getEsfemod());
		}
		if (establecimiento != null && establecimiento.getEsinesco() != null) {
			where.append(" AND t1.ESINESCO = ?");
			params.add(establecimiento.getEsinesco());
		}
		if (establecimiento != null && establecimiento.getEsnomu() != null) {
			where.append(" AND t1.ESNOMU = ?");
			params.add(establecimiento.getEsnomu());
		}
		if (establecimiento != null && establecimiento.getEsnorep() != null) {
			where.append(" AND t1.ESNOREP = ?");
			params.add(establecimiento.getEsnorep());
		}
		if (establecimiento != null && establecimiento.getEsnifrep() != null) {
			where.append(" AND t1.ESNIFREP = ?");
			params.add(establecimiento.getEsnifrep());
		}
		if (establecimiento != null && establecimiento.getDtteemr() != null) {
			where.append(" AND t1.DTTEEMR = ?");
			params.add(establecimiento.getDtteemr());
		}
		if (establecimiento != null && establecimiento.getEscarep() != null) {
			where.append(" AND t1.ESCAREP = ?");
			params.add(establecimiento.getEscarep());
		}
		if (establecimiento != null && establecimiento.getEsteurl() != null) {
			where.append(" AND t1.ESTEURL = ?");
			params.add(establecimiento.getEsteurl());
		}
		if (establecimiento != null && establecimiento.getEscooe() != null) {
			where.append(" AND t1.ESCOOE = ?");
			params.add(establecimiento.getEscooe());
		}
		if (establecimiento != null && establecimiento.getEsnodeco() != null) {
			where.append(" AND t1.ESNODECO = ?");
			params.add(establecimiento.getEsnodeco());
		}
		if (establecimiento != null && establecimiento.getEsintiar() != null) {
			where.append(" AND t1.ESINTIAR = ?");
			params.add(establecimiento.getEsintiar());
		}
		if (establecimiento != null && establecimiento.getEsfeplad() != null) {
			where.append(" AND t1.ESFEPLAD = ?");
			params.add(establecimiento.getEsfeplad());
		}
		if (establecimiento != null && establecimiento.getEsindeme() != null) {
			where.append(" AND t1.ESINDEME = ?");
			params.add(establecimiento.getEsindeme());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisId() != null) {
			where.append(" AND t1.ESNORA_PAIS_ID = ?");
			params.add(establecimiento.getEsnoraPaisId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPaisNombre() != null) {
			where.append(" AND t1.ESNORA_PAIS_NOMBRE = ?");
			params.add(establecimiento.getEsnoraPaisNombre());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraProvinciaId() != null) {
			where.append(" AND t1.ESNORA_PROVINCIA_ID = ?");
			params.add(establecimiento.getEsnoraProvinciaId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreProvincia() != null) {
			where.append(" AND t1.ESNOMBRE_PROVINCIA = ?");
			params.add(establecimiento.getEsnombreProvincia());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraMunicipioId() != null) {
			where.append(" AND t1.ESNORA_MUNICIPIO_ID = ?");
			params.add(establecimiento.getEsnoraMunicipioId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreMunicipio() != null) {
			where.append(" AND t1.ESNOMBRE_MUNICIPIO = ?");
			params.add(establecimiento.getEsnombreMunicipio());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraLocalidadId() != null) {
			where.append(" AND t1.ESNORA_LOCALIDAD_ID = ?");
			params.add(establecimiento.getEsnoraLocalidadId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreLocalidad() != null) {
			where.append(" AND t1.ESNOMBRE_LOCALIDAD = ?");
			params.add(establecimiento.getEsnombreLocalidad());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraCalleId() != null) {
			where.append(" AND t1.ESNORA_CALLE_ID = ?");
			params.add(establecimiento.getEsnoraCalleId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombreCalle() != null) {
			where.append(" AND t1.ESNOMBRE_CALLE = ?");
			params.add(establecimiento.getEsnombreCalle());
		}
		if (establecimiento != null && establecimiento.getEsnoraCpId() != null) {
			where.append(" AND t1.ESNORA_CP_ID = ?");
			params.add(establecimiento.getEsnoraCpId());
		}
		if (establecimiento != null && establecimiento.getEsnombreCp() != null) {
			where.append(" AND t1.ESNOMBRE_CP = ?");
			params.add(establecimiento.getEsnombreCp());
		}
		if (establecimiento != null
				&& establecimiento.getEsnoraPortalId() != null) {
			where.append(" AND t1.ESNORA_PORTAL_ID = ?");
			params.add(establecimiento.getEsnoraPortalId());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePortal() != null) {
			where.append(" AND t1.ESNOMBRE_PORTAL = ?");
			params.add(establecimiento.getEsnombrePortal());
		}
		if (establecimiento != null
				&& establecimiento.getEsnombrePiso() != null) {
			where.append(" AND t1.ESNOMBRE_PISO = ?");
			params.add(establecimiento.getEsnombrePiso());
		}
		if (establecimSector != null && establecimSector.getSector() != null
				&& establecimSector.getSector().getSecodigo() != null) {
			where.append(" AND t3.EACOSE = ?");
			params.add(establecimSector.getSector().getSecodigo());
			where.append(" AND t3.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllEstablecimientoDescriptor(
			Establecimiento establecimiento) {
		String query = "DELETE  FROM ESTABLECIMIENTO_DESCRIPTOR "
				+ " WHERE ESCODIGO=? ";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}
}
