package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Establecimiento;

/**
 * * EstablecimientoDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface EstablecimientoDao {

	/**
	 * Inserts a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento add(Establecimiento establecimiento);

	/**
	 * Updates a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento update(Establecimiento establecimiento);

	/**
	 * Finds a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	Establecimiento find(Establecimiento establecimiento);

	/**
	 * Deletes a single row in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	void remove(Establecimiento establecimiento);

	/**
	 * Finds a List of rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Establecimiento> findAll(Establecimiento establecimiento,
			Pagination pagination);

	/**
	 * Counts rows in the Establecimiento table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return List
	 */
	Long findAllCount(Establecimiento establecimiento);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLike(Establecimiento establecimiento,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Establecimiento> findAllLikeEstablecimiento(
			Establecimiento establecimiento, EstablecimSector establecimSector,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Establecimiento table using like.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	Long findAllLikeEstablecimientoCount(Establecimiento establecimiento,
			EstablecimSector establecimSector, Boolean startsWith);

	/**
	 * Deletes a single row in the EstablecimientoDescriptor table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllEstablecimientoDescriptor(
			Establecimiento establecimiento);
}
