package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.EstablecimArbitra;
import com.ejie.y41a.model.Establecimiento;

/**
 * * EstablecimArbitraDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class EstablecimArbitraDaoImpl implements EstablecimArbitraDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<EstablecimArbitra> rwMap = new RowMapper<EstablecimArbitra>() {
		public EstablecimArbitra mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new EstablecimArbitra(resultSet.getString("AHCODIGO"),
					new Establecimiento(resultSet.getString("AHCOES"), null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null), resultSet.getInt("AHCOEX"),
					resultSet.getInt("AHNRDI"), resultSet.getDate("AHFECODI"),
					resultSet.getDate("AHFEBA"),
					resultSet.getString("AHCOTAG"),
					resultSet.getString("AHCOT2"),
					resultSet.getString("AHCOAV"),
					resultSet.getString("AHCOSE"),
					resultSet.getString("AHCOSEDE"),
					resultSet.getDate("AHFEPUCD"),
					resultSet.getDate("AHFEPUBA"),
					resultSet.getString("AHCOCC"),
					resultSet.getString("AHNIREP"),
					resultSet.getString("AHNOREP"),
					resultSet.getString("AHNOAP1R"),
					resultSet.getString("AHNOAP2R"),
					resultSet.getString("AHNOCARE"),
					resultSet.getDate("AHFERE"),
					resultSet.getString("AHTELIMI"),
					resultSet.getString("AHINAMNA"),
					resultSet.getString("AHCOJA"),
					resultSet.getString("AHCOZS"),
					resultSet.getString("AHCOJAAD"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	public EstablecimArbitra add(EstablecimArbitra establecimarbitra) {

		String query = "INSERT INTO ESTABLECIM_ARBITRA( AHCODIGO,AHCOES,AHCOEX,AHNRDI,AHFECODI,AHFEBA,AHCOTAG,AHCOT2,AHCOAV,AHCOSE,AHCOSEDE,AHFEPUCD,AHFEPUBA,AHCOCC,AHNIREP,AHNOREP,AHNOAP1R,AHNOAP2R,AHNOCARE,AHFERE,AHTELIMI,AHINAMNA,AHCOJA,AHCOZS,AHCOJAAD)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object EstablecimientoEscodigoAux = null;
		if (establecimarbitra.getEstablecimiento() != null
				&& establecimarbitra.getEstablecimiento().getEscodigo() != null) {
			EstablecimientoEscodigoAux = establecimarbitra.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, establecimarbitra.getAhcodigo(),
				EstablecimientoEscodigoAux, establecimarbitra.getAhcoex(),
				establecimarbitra.getAhnrdi(), establecimarbitra.getAhfecodi(),
				establecimarbitra.getAhfeba(), establecimarbitra.getAhcotag(),
				establecimarbitra.getAhcot2(), establecimarbitra.getAhcoav(),
				establecimarbitra.getAhcose(), establecimarbitra.getAhcosede(),
				establecimarbitra.getAhfepucd(),
				establecimarbitra.getAhfepuba(), establecimarbitra.getAhcocc(),
				establecimarbitra.getAhnirep(), establecimarbitra.getAhnorep(),
				establecimarbitra.getAhnoap1r(),
				establecimarbitra.getAhnoap2r(),
				establecimarbitra.getAhnocare(), establecimarbitra.getAhfere(),
				establecimarbitra.getAhtelimi(),
				establecimarbitra.getAhinamna(), establecimarbitra.getAhcoja(),
				establecimarbitra.getAhcozs(), establecimarbitra.getAhcojaad());
		return establecimarbitra;
	}

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	public EstablecimArbitra update(EstablecimArbitra establecimarbitra) {
		String query = "UPDATE ESTABLECIM_ARBITRA SET AHCOEX=?,AHNRDI=?,AHFECODI=?,AHFEBA=?,AHCOTAG=?,AHCOT2=?,AHCOAV=?,AHCOSE=?,AHCOSEDE=?,AHFEPUCD=?,AHFEPUBA=?,AHCOCC=?,AHNIREP=?,AHNOREP=?,AHNOAP1R=?,AHNOAP2R=?,AHNOCARE=?,AHFERE=?,AHTELIMI=?,AHINAMNA=?,AHCOJA=?,AHCOZS=?,AHCOJAAD=? WHERE AHCODIGO=? AND AHCOES=?";
		Object EstablecimientoEscodigoAux = null;
		if (establecimarbitra.getEstablecimiento() != null
				&& establecimarbitra.getEstablecimiento().getEscodigo() != null) {
			EstablecimientoEscodigoAux = establecimarbitra.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, establecimarbitra.getAhcoex(),
				establecimarbitra.getAhnrdi(), establecimarbitra.getAhfecodi(),
				establecimarbitra.getAhfeba(), establecimarbitra.getAhcotag(),
				establecimarbitra.getAhcot2(), establecimarbitra.getAhcoav(),
				establecimarbitra.getAhcose(), establecimarbitra.getAhcosede(),
				establecimarbitra.getAhfepucd(),
				establecimarbitra.getAhfepuba(), establecimarbitra.getAhcocc(),
				establecimarbitra.getAhnirep(), establecimarbitra.getAhnorep(),
				establecimarbitra.getAhnoap1r(),
				establecimarbitra.getAhnoap2r(),
				establecimarbitra.getAhnocare(), establecimarbitra.getAhfere(),
				establecimarbitra.getAhtelimi(),
				establecimarbitra.getAhinamna(), establecimarbitra.getAhcoja(),
				establecimarbitra.getAhcozs(), establecimarbitra.getAhcojaad(),
				establecimarbitra.getAhcodigo(), EstablecimientoEscodigoAux);
		return establecimarbitra;
	}

	/**
	 * Updates a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	public void updateEstablecimiento(String escodigoBueno,
			String escodigoAfusionar) {
		try {
			String query = "UPDATE SOLICITUD_ARBITRA SET MACOES=? WHERE MACOES=? ";
			this.jdbcTemplate.update(query, escodigoBueno, escodigoAfusionar);
		} catch (Exception e) {
		}
	}

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	@Transactional(readOnly = true)
	public EstablecimArbitra find(EstablecimArbitra establecimarbitra) {
		String query = "SELECT t1.AHCODIGO AHCODIGO, t1.AHCOES AHCOES, t1.AHCOEX AHCOEX, t1.AHNRDI AHNRDI, t1.AHFECODI AHFECODI, t1.AHFEBA AHFEBA, t1.AHCOTAG AHCOTAG, t1.AHCOT2 AHCOT2, t1.AHCOAV AHCOAV, t1.AHCOSE AHCOSE, t1.AHCOSEDE AHCOSEDE, t1.AHFEPUCD AHFEPUCD, t1.AHFEPUBA AHFEPUBA, t1.AHCOCC AHCOCC, t1.AHNIREP AHNIREP, t1.AHNOREP AHNOREP, t1.AHNOAP1R AHNOAP1R, t1.AHNOAP2R AHNOAP2R, t1.AHNOCARE AHNOCARE, t1.AHFERE AHFERE, t1.AHTELIMI AHTELIMI, t1.AHINAMNA AHINAMNA, t1.AHCOJA AHCOJA, t1.AHCOZS AHCOZS, t1.AHCOJAAD AHCOJAAD "
				+ "FROM ESTABLECIM_ARBITRA t1  "
				+ "WHERE t1.AHCODIGO = ?   AND t1.AHCOES = ?    ";
		return (EstablecimArbitra) this.jdbcTemplate.queryForObject(query,
				rwMap, establecimarbitra.getAhcodigo(), establecimarbitra
						.getEstablecimiento().getEscodigo());
	}

	/**
	 * Finds a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return EstablecimArbitra
	 */
	@Transactional(readOnly = true)
	public EstablecimArbitra findArbitraje(EstablecimArbitra establecimarbitra) {
		String query = "SELECT t1.AHCODIGO AHCODIGO, t1.AHCOES AHCOES, t1.AHCOEX AHCOEX, t1.AHNRDI AHNRDI, t1.AHFECODI AHFECODI, t1.AHFEBA AHFEBA, t1.AHCOTAG AHCOTAG, t1.AHCOT2 AHCOT2, t1.AHCOAV AHCOAV, t1.AHCOSE AHCOSE, t1.AHCOSEDE AHCOSEDE, t1.AHFEPUCD AHFEPUCD, t1.AHFEPUBA AHFEPUBA, t1.AHCOCC AHCOCC, t1.AHNIREP AHNIREP, t1.AHNOREP AHNOREP, t1.AHNOAP1R AHNOAP1R, t1.AHNOAP2R AHNOAP2R, t1.AHNOCARE AHNOCARE, t1.AHFERE AHFERE, t1.AHTELIMI AHTELIMI, t1.AHINAMNA AHINAMNA, t1.AHCOJA AHCOJA, t1.AHCOZS AHCOZS, t1.AHCOJAAD AHCOJAAD "
				+ "FROM ESTABLECIM_ARBITRA t1  " + "WHERE t1.AHCOES = ?    ";
		return (EstablecimArbitra) this.jdbcTemplate.queryForObject(query,
				rwMap, establecimarbitra.getEstablecimiento().getEscodigo());
	}

	/**
	 * Removes a single row in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            Pagination
	 * @return
	 */
	public void remove(EstablecimArbitra establecimarbitra) {
		String query = "DELETE  FROM ESTABLECIM_ARBITRA WHERE AHCODIGO=? AND AHCOES=?";
		this.jdbcTemplate.update(query, establecimarbitra.getAhcodigo(),
				establecimarbitra.getEstablecimiento().getEscodigo());
	}

	/**
	 * Finds a List of rows in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstablecimArbitra> findAll(EstablecimArbitra establecimarbitra,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.AHCODIGO AHCODIGO,t1.AHCOES AHCOES,t1.AHCOEX AHCOEX,t1.AHNRDI AHNRDI,t1.AHFECODI AHFECODI,t1.AHFEBA AHFEBA,t1.AHCOTAG AHCOTAG,t1.AHCOT2 AHCOT2,t1.AHCOAV AHCOAV,t1.AHCOSE AHCOSE,t1.AHCOSEDE AHCOSEDE,t1.AHFEPUCD AHFEPUCD,t1.AHFEPUBA AHFEPUBA,t1.AHCOCC AHCOCC,t1.AHNIREP AHNIREP,t1.AHNOREP AHNOREP,t1.AHNOAP1R AHNOAP1R,t1.AHNOAP2R AHNOAP2R,t1.AHNOCARE AHNOCARE,t1.AHFERE AHFERE,t1.AHTELIMI AHTELIMI,t1.AHINAMNA AHINAMNA,t1.AHCOJA AHCOJA,t1.AHCOZS AHCOZS,t1.AHCOJAAD AHCOJAAD "
						+ "FROM ESTABLECIM_ARBITRA t1 ");

		if (establecimarbitra != null
				&& establecimarbitra.getAhcodigo() != null) {
			where.append(" AND t1.AHCODIGO = ?");
			params.add(establecimarbitra.getAhcodigo());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimarbitra.getEstablecimiento().getEscodigo());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoex() != null) {
			where.append(" AND t1.AHCOEX = ?");
			params.add(establecimarbitra.getAhcoex());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnrdi() != null) {
			where.append(" AND t1.AHNRDI = ?");
			params.add(establecimarbitra.getAhnrdi());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfecodi() != null) {
			where.append(" AND t1.AHFECODI = ?");
			params.add(establecimarbitra.getAhfecodi());
		}
		if (establecimarbitra != null && establecimarbitra.getAhfeba() != null) {
			where.append(" AND t1.AHFEBA = ?");
			params.add(establecimarbitra.getAhfeba());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcotag() != null) {
			where.append(" AND t1.AHCOTAG = ?");
			params.add(establecimarbitra.getAhcotag());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcot2() != null) {
			where.append(" AND t1.AHCOT2 = ?");
			params.add(establecimarbitra.getAhcot2());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoav() != null) {
			where.append(" AND t1.AHCOAV = ?");
			params.add(establecimarbitra.getAhcoav());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcose() != null) {
			where.append(" AND t1.AHCOSE = ?");
			params.add(establecimarbitra.getAhcose());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcosede() != null) {
			where.append(" AND t1.AHCOSEDE = ?");
			params.add(establecimarbitra.getAhcosede());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepucd() != null) {
			where.append(" AND t1.AHFEPUCD = ?");
			params.add(establecimarbitra.getAhfepucd());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepuba() != null) {
			where.append(" AND t1.AHFEPUBA = ?");
			params.add(establecimarbitra.getAhfepuba());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcocc() != null) {
			where.append(" AND t1.AHCOCC = ?");
			params.add(establecimarbitra.getAhcocc());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnirep() != null) {
			where.append(" AND t1.AHNIREP = ?");
			params.add(establecimarbitra.getAhnirep());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnorep() != null) {
			where.append(" AND t1.AHNOREP = ?");
			params.add(establecimarbitra.getAhnorep());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap1r() != null) {
			where.append(" AND t1.AHNOAP1R = ?");
			params.add(establecimarbitra.getAhnoap1r());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap2r() != null) {
			where.append(" AND t1.AHNOAP2R = ?");
			params.add(establecimarbitra.getAhnoap2r());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnocare() != null) {
			where.append(" AND t1.AHNOCARE = ?");
			params.add(establecimarbitra.getAhnocare());
		}
		if (establecimarbitra != null && establecimarbitra.getAhfere() != null) {
			where.append(" AND t1.AHFERE = ?");
			params.add(establecimarbitra.getAhfere());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhtelimi() != null) {
			where.append(" AND t1.AHTELIMI = ?");
			params.add(establecimarbitra.getAhtelimi());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhinamna() != null) {
			where.append(" AND t1.AHINAMNA = ?");
			params.add(establecimarbitra.getAhinamna());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoja() != null) {
			where.append(" AND t1.AHCOJA = ?");
			params.add(establecimarbitra.getAhcoja());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcozs() != null) {
			where.append(" AND t1.AHCOZS = ?");
			params.add(establecimarbitra.getAhcozs());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcojaad() != null) {
			where.append(" AND t1.AHCOJAAD = ?");
			params.add(establecimarbitra.getAhcojaad());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EstablecimArbitra>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the EstablecimArbitra table.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(EstablecimArbitra establecimarbitra) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ESTABLECIM_ARBITRA t1  ");
		if (establecimarbitra != null
				&& establecimarbitra.getAhcodigo() != null) {
			where.append(" AND t1.AHCODIGO = ?");
			params.add(establecimarbitra.getAhcodigo());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.ESCODIGO = ?");
			params.add(establecimarbitra.getEstablecimiento().getEscodigo());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoex() != null) {
			where.append(" AND t1.AHCOEX = ?");
			params.add(establecimarbitra.getAhcoex());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnrdi() != null) {
			where.append(" AND t1.AHNRDI = ?");
			params.add(establecimarbitra.getAhnrdi());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfecodi() != null) {
			where.append(" AND t1.AHFECODI = ?");
			params.add(establecimarbitra.getAhfecodi());
		}
		if (establecimarbitra != null && establecimarbitra.getAhfeba() != null) {
			where.append(" AND t1.AHFEBA = ?");
			params.add(establecimarbitra.getAhfeba());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcotag() != null) {
			where.append(" AND t1.AHCOTAG = ?");
			params.add(establecimarbitra.getAhcotag());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcot2() != null) {
			where.append(" AND t1.AHCOT2 = ?");
			params.add(establecimarbitra.getAhcot2());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoav() != null) {
			where.append(" AND t1.AHCOAV = ?");
			params.add(establecimarbitra.getAhcoav());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcose() != null) {
			where.append(" AND t1.AHCOSE = ?");
			params.add(establecimarbitra.getAhcose());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcosede() != null) {
			where.append(" AND t1.AHCOSEDE = ?");
			params.add(establecimarbitra.getAhcosede());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepucd() != null) {
			where.append(" AND t1.AHFEPUCD = ?");
			params.add(establecimarbitra.getAhfepucd());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepuba() != null) {
			where.append(" AND t1.AHFEPUBA = ?");
			params.add(establecimarbitra.getAhfepuba());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcocc() != null) {
			where.append(" AND t1.AHCOCC = ?");
			params.add(establecimarbitra.getAhcocc());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnirep() != null) {
			where.append(" AND t1.AHNIREP = ?");
			params.add(establecimarbitra.getAhnirep());
		}
		if (establecimarbitra != null && establecimarbitra.getAhnorep() != null) {
			where.append(" AND t1.AHNOREP = ?");
			params.add(establecimarbitra.getAhnorep());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap1r() != null) {
			where.append(" AND t1.AHNOAP1R = ?");
			params.add(establecimarbitra.getAhnoap1r());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap2r() != null) {
			where.append(" AND t1.AHNOAP2R = ?");
			params.add(establecimarbitra.getAhnoap2r());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnocare() != null) {
			where.append(" AND t1.AHNOCARE = ?");
			params.add(establecimarbitra.getAhnocare());
		}
		if (establecimarbitra != null && establecimarbitra.getAhfere() != null) {
			where.append(" AND t1.AHFERE = ?");
			params.add(establecimarbitra.getAhfere());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhtelimi() != null) {
			where.append(" AND t1.AHTELIMI = ?");
			params.add(establecimarbitra.getAhtelimi());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhinamna() != null) {
			where.append(" AND t1.AHINAMNA = ?");
			params.add(establecimarbitra.getAhinamna());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoja() != null) {
			where.append(" AND t1.AHCOJA = ?");
			params.add(establecimarbitra.getAhcoja());
		}
		if (establecimarbitra != null && establecimarbitra.getAhcozs() != null) {
			where.append(" AND t1.AHCOZS = ?");
			params.add(establecimarbitra.getAhcozs());
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcojaad() != null) {
			where.append(" AND t1.AHCOJAAD = ?");
			params.add(establecimarbitra.getAhcojaad());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the EstablecimArbitra table using like.
	 * 
	 * @param establecimarbitra
	 *            EstablecimArbitra
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<EstablecimArbitra> findAllLike(
			EstablecimArbitra establecimarbitra, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.AHCODIGO AHCODIGO,t1.AHCOES AHCOES,t1.AHCOEX AHCOEX,t1.AHNRDI AHNRDI,t1.AHFECODI AHFECODI,t1.AHFEBA AHFEBA,t1.AHCOTAG AHCOTAG,t1.AHCOT2 AHCOT2,t1.AHCOAV AHCOAV,t1.AHCOSE AHCOSE,t1.AHCOSEDE AHCOSEDE,t1.AHFEPUCD AHFEPUCD,t1.AHFEPUBA AHFEPUBA,t1.AHCOCC AHCOCC,t1.AHNIREP AHNIREP,t1.AHNOREP AHNOREP,t1.AHNOAP1R AHNOAP1R,t1.AHNOAP2R AHNOAP2R,t1.AHNOCARE AHNOCARE,t1.AHFERE AHFERE,t1.AHTELIMI AHTELIMI,t1.AHINAMNA AHINAMNA,t1.AHCOJA AHCOJA,t1.AHCOZS AHCOZS,t1.AHCOJAAD AHCOJAAD "
						+ "FROM ESTABLECIM_ARBITRA t1 ");

		if (establecimarbitra != null
				&& establecimarbitra.getAhcodigo() != null) {
			where.append(" AND UPPER(t1.AHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCODIGO IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t1.ESCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getEstablecimiento().getEscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ establecimarbitra.getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.ESCODIGO IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoex() != null) {
			where.append(" AND t1.AHCOEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcoex() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcoex() + "%");
			}
			where.append(" AND t1.AHCOEX IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhnrdi() != null) {
			where.append(" AND t1.AHNRDI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnrdi() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnrdi() + "%");
			}
			where.append(" AND t1.AHNRDI IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfecodi() != null) {
			where.append(" AND t1.AHFECODI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhfecodi() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhfecodi() + "%");
			}
			where.append(" AND t1.AHFECODI IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhfeba() != null) {
			where.append(" AND t1.AHFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhfeba() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhfeba() + "%");
			}
			where.append(" AND t1.AHFEBA IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcotag() != null) {
			where.append(" AND UPPER(t1.AHCOTAG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcotag().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcotag().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOTAG IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcot2() != null) {
			where.append(" AND UPPER(t1.AHCOT2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcot2().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcot2().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOT2 IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoav() != null) {
			where.append(" AND UPPER(t1.AHCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcoav().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcoav().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOAV IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcose() != null) {
			where.append(" AND UPPER(t1.AHCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcose().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcose().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOSE IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcosede() != null) {
			where.append(" AND UPPER(t1.AHCOSEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcosede().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcosede().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOSEDE IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepucd() != null) {
			where.append(" AND t1.AHFEPUCD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhfepucd() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhfepucd() + "%");
			}
			where.append(" AND t1.AHFEPUCD IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhfepuba() != null) {
			where.append(" AND t1.AHFEPUBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhfepuba() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhfepuba() + "%");
			}
			where.append(" AND t1.AHFEPUBA IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcocc() != null) {
			where.append(" AND UPPER(t1.AHCOCC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcocc().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcocc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOCC IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhnirep() != null) {
			where.append(" AND UPPER(t1.AHNIREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnirep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnirep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHNIREP IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhnorep() != null) {
			where.append(" AND UPPER(t1.AHNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnorep().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnorep().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHNOREP IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap1r() != null) {
			where.append(" AND UPPER(t1.AHNOAP1R) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnoap1r().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnoap1r().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHNOAP1R IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnoap2r() != null) {
			where.append(" AND UPPER(t1.AHNOAP2R) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnoap2r().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnoap2r().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHNOAP2R IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhnocare() != null) {
			where.append(" AND UPPER(t1.AHNOCARE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhnocare().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhnocare().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHNOCARE IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhfere() != null) {
			where.append(" AND t1.AHFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhfere() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhfere() + "%");
			}
			where.append(" AND t1.AHFERE IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhtelimi() != null) {
			where.append(" AND UPPER(t1.AHTELIMI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhtelimi().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhtelimi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHTELIMI IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhinamna() != null) {
			where.append(" AND UPPER(t1.AHINAMNA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhinamna().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhinamna().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHINAMNA IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcoja() != null) {
			where.append(" AND UPPER(t1.AHCOJA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcoja().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcoja().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOJA IS NOT NULL");
		}
		if (establecimarbitra != null && establecimarbitra.getAhcozs() != null) {
			where.append(" AND UPPER(t1.AHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcozs().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcozs().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOZS IS NOT NULL");
		}
		if (establecimarbitra != null
				&& establecimarbitra.getAhcojaad() != null) {
			where.append(" AND UPPER(t1.AHCOJAAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(establecimarbitra.getAhcojaad().toUpperCase() + "%");
			} else {
				params.add("%" + establecimarbitra.getAhcojaad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AHCOJAAD IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<EstablecimArbitra>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}
}
