package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.DocumentoHechoDetalle;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.TipoReclamacion;
import com.ejie.y41a.model.Tramite;
import com.ejie.y41a.model.TramiteComun;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * DocumentoHechoDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class DocumentoHechoDaoImpl implements DocumentoHechoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<DocumentoHecho> rwMap = new RowMapper<DocumentoHecho>() {
		public DocumentoHecho mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DocumentoHecho(
					resultSet.getString("Q5CODOCUMENTO"),
					resultSet.getString("Q5NOFILE"),
					resultSet.getBlob("Q5DATAFILE"),
					resultSet.getInt("Q5SIZEFILE"),
					resultSet.getString("Q5TEDESFILE"),
					resultSet.getString("Q5ORIGEN"),
					resultSet.getDate("Q5FECHA"),
					resultSet.getString("Q5INDMAIL"),
					resultSet.getString("Q5CONTENTTYPEFILE"),
					new TramiteHecho(resultSet
							.getString("TramiteHechoEHCODIGO"), resultSet
							.getDate("TramiteHechoEHFECHA"), resultSet
							.getString("TramiteHechoEHHORA"), resultSet
							.getString("TramiteHechoEHCODPOR"), resultSet
							.getString("TramiteHechoEHCODPDE"), resultSet
							.getString("TramiteHechoEHTEXTO"), resultSet
							.getString("TramiteHechoEHCOZS"), resultSet
							.getBigDecimal("TramiteHechoEHCIVIHE"), resultSet
							.getDate("TramiteHechoEHACUSE"), resultSet
							.getString("TramiteHechoEHENVIOMAIL"), resultSet
							.getString("TramiteHechoEHDIREMAIL"), null, null,
							new Tramite(resultSet
									.getString("TramiteHechoEHCOTEE"), null,
									null, null, null), new CensoMonitor(
									resultSet.getString("TramiteHechoEHCOMO"),
									null, null, null, null, null, null, null,
									null, null, null, null),
							new HechoDenunciado(resultSet
									.getString("TramiteHechoEHCOHD"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null)),
					new TramiteHecho(resultSet
							.getString("TramiteHechoEHCODIGO"), resultSet
							.getDate("TramiteHechoEHFECHA"), resultSet
							.getString("TramiteHechoEHHORA"), resultSet
							.getString("TramiteHechoEHCODPOR"), resultSet
							.getString("TramiteHechoEHCODPDE"), resultSet
							.getString("TramiteHechoEHTEXTO"), resultSet
							.getString("TramiteHechoEHCOZS"), resultSet
							.getBigDecimal("TramiteHechoEHCIVIHE"), resultSet
							.getDate("TramiteHechoEHACUSE"), resultSet
							.getString("TramiteHechoEHENVIOMAIL"), resultSet
							.getString("TramiteHechoEHDIREMAIL"), null, null,
							new Tramite(resultSet
									.getString("TramiteHechoEHCOTEE"), null,
									null, null, null), new CensoMonitor(
									resultSet.getString("TramiteHechoEHCOMO"),
									null, null, null, null, null, null, null,
									null, null, null, null),
							new HechoDenunciado(resultSet
									.getString("TramiteHechoEHCOHD"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null)),
					new HechoDenunciado(
							resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"),
							resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"),
							resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"),
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"),
							resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"),
							resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"),
							resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"),
							resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"),
							resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"),
							resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"),
							resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"),
							resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"),
							resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"),
							resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"),
							resultSet
									.getString("HechoDenunciadoHDCODEXPEDIENTEORIGEN"),
							new Denuncia(resultSet
									.getString("HechoDenunciadoHDCODE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new Establecimiento(resultSet
									.getString("HechoDenunciadoHDCOES"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null), new Sector(resultSet
									.getString("HechoDenunciadoHDCOSE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("HechoDenunciadoHDCOMO"), null,
									null, null, null, null, null, null, null,
									null, null, null), new Producto(resultSet
									.getString("HechoDenunciadoHDCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipoReclamacion(resultSet
									.getString("HechoDenunciadoHDCOTSR"), null,
									null, null, null, null, null),
							new Motivo(resultSet
									.getString("HechoDenunciadoHDCOTIR"), null,
									null, null), null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho add(DocumentoHecho documentohecho) {

		String query = "INSERT INTO DOCUMENTO_HECHO( Q5CODOCUMENTO,Q5TRMAIL,Q5TRAMITE,Q5HDCODIGO,Q5NOFILE,Q5DATAFILE,Q5SIZEFILE,Q5TEDESFILE,Q5ORIGEN,Q5FECHA,Q5INDMAIL, Q5CONTENTTYPEFILE, Q5ID_TIPODOC)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTramiteHechoByQ5trmailEhcodigoAux = null;
		if (documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			getTramiteHechoByQ5trmailEhcodigoAux = documentohecho
					.getTramiteHechoByQ5trmail().getEhcodigo();
		}
		Object getTramiteHechoByQ5tramiteEhcodigoAux = null;
		if (documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodigo() != null) {
			getTramiteHechoByQ5tramiteEhcodigoAux = documentohecho
					.getTramiteHechoByQ5tramite().getEhcodigo();
		}
		Object getHechoDenunciadoHdcodigoAux = null;
		if (documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = documentohecho.getHechoDenunciado()
					.getHdcodigo();
		}
		this.jdbcTemplate
				.update(query, documentohecho.getQ5codocumento(),
						getTramiteHechoByQ5trmailEhcodigoAux,
						getTramiteHechoByQ5tramiteEhcodigoAux,
						getHechoDenunciadoHdcodigoAux, documentohecho
								.getQ5nofile(), Y41aJdbcUtils
								.ConvertBlobToByte(documentohecho
										.getQ5datafile()), documentohecho
								.getQ5sizefile(), documentohecho
								.getQ5tedesfile(),
						documentohecho.getQ5origen(), documentohecho
								.getQ5fecha(), documentohecho.getQ5indmail(),
						documentohecho.getQ5contenttypefile(), documentohecho
								.getQ5idtipodoc());
		return documentohecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho update(DocumentoHecho documentohecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5TRMAIL=?,Q5TRAMITE=?,Q5HDCODIGO=?,Q5NOFILE=?,Q5DATAFILE=?,Q5SIZEFILE=?,Q5TEDESFILE=?,Q5ORIGEN=?,Q5FECHA=?,Q5INDMAIL=?,Q5CONTENTTYPEFILE=? WHERE Q5CODOCUMENTO=?";
		Object getTramiteHechoByQ5trmailEhcodigoAux = null;
		if (documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			getTramiteHechoByQ5trmailEhcodigoAux = documentohecho
					.getTramiteHechoByQ5trmail().getEhcodigo();
		}
		Object getTramiteHechoByQ5tramiteEhcodigoAux = null;
		if (documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodigo() != null) {
			getTramiteHechoByQ5tramiteEhcodigoAux = documentohecho
					.getTramiteHechoByQ5tramite().getEhcodigo();
		}
		Object getHechoDenunciadoHdcodigoAux = null;
		if (documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = documentohecho.getHechoDenunciado()
					.getHdcodigo();
		}
		this.jdbcTemplate
				.update(query, getTramiteHechoByQ5trmailEhcodigoAux,
						getTramiteHechoByQ5tramiteEhcodigoAux,
						getHechoDenunciadoHdcodigoAux, documentohecho
								.getQ5nofile(), Y41aJdbcUtils
								.ConvertBlobToByte(documentohecho
										.getQ5datafile()), documentohecho
								.getQ5sizefile(), documentohecho
								.getQ5tedesfile(),
						documentohecho.getQ5origen(), documentohecho
								.getQ5fecha(), documentohecho.getQ5indmail(),
						documentohecho.getQ5contenttypefile(), documentohecho
								.getQ5codocumento());
		return documentohecho;
	}

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	public DocumentoHecho updateDocumentoHechoMail(DocumentoHecho documentohecho) {
		String query = "UPDATE DOCUMENTO_HECHO SET Q5TRMAIL=?,Q5INDMAIL=? WHERE Q5CODOCUMENTO=?";
		Object getTramiteHechoByQ5trmailEhcodigoAux = null;
		if (documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			getTramiteHechoByQ5trmailEhcodigoAux = documentohecho
					.getTramiteHechoByQ5trmail().getEhcodigo();
		}

		this.jdbcTemplate.update(query, getTramiteHechoByQ5trmailEhcodigoAux,
				documentohecho.getQ5indmail(),
				documentohecho.getQ5codocumento());
		return documentohecho;
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho find(DocumentoHecho documentohecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t2.EHCODIGO TRAMITEHECHOEHCODIGO, t2.EHFECHA TRAMITEHECHOEHFECHA, t2.EHHORA TRAMITEHECHOEHHORA, t2.EHCODPOR TRAMITEHECHOEHCODPOR, t2.EHCODPDE TRAMITEHECHOEHCODPDE, t2.EHTEXTO TRAMITEHECHOEHTEXTO, t2.EHCOZS TRAMITEHECHOEHCOZS, t2.EHCIVIHE TRAMITEHECHOEHCIVIHE, t2.EHACUSE TRAMITEHECHOEHACUSE, t2.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL, t2.EHDIREMAIL TRAMITEHECHOEHDIREMAIL, t3.EHCODIGO TRAMITEHECHOEHCODIGO, t3.EHFECHA TRAMITEHECHOEHFECHA, t3.EHHORA TRAMITEHECHOEHHORA, t3.EHCODPOR TRAMITEHECHOEHCODPOR, t3.EHCODPDE TRAMITEHECHOEHCODPDE, t3.EHTEXTO TRAMITEHECHOEHTEXTO, t3.EHCOZS TRAMITEHECHOEHCOZS, t3.EHCIVIHE TRAMITEHECHOEHCIVIHE, t3.EHACUSE TRAMITEHECHOEHACUSE, t3.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL, t3.EHDIREMAIL TRAMITEHECHOEHDIREMAIL, t4.HDCODIGO HECHODENUNCIADOHDCODIGO, t4.HDNROR HECHODENUNCIADOHDNROR, t4.HDTE HECHODENUNCIADOHDTE, t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t4.HDCOAV HECHODENUNCIADOHDCOAV, t4.HDNOPS HECHODENUNCIADOHDNOPS, t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t4.HDINSOTR HECHODENUNCIADOHDINSOTR, t4.HDINSOMA HECHODENUNCIADOHDINSOMA, t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t4.HDTESO HECHODENUNCIADOHDTESO, t4.HDFEARDT HECHODENUNCIADOHDFEARDT, t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t4.HDINININ HECHODENUNCIADOHDINININ, t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t4.HDFEROPC HECHODENUNCIADOHDFEROPC, t4.HDCOREPC HECHODENUNCIADOHDCOREPC, t4.HDFEIORP HECHODENUNCIADOHDFEIORP, t4.HDFERORP HECHODENUNCIADOHDFERORP, t4.HDCOREAP HECHODENUNCIADOHDCOREAP, t4.HDFEIORA HECHODENUNCIADOHDFEIORA, t4.HDTEACPA HECHODENUNCIADOHDTEACPA, t4.HDFECEAC HECHODENUNCIADOHDFECEAC, t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t4.HDTEACDE HECHODENUNCIADOHDTEACDE, t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t4.HDCOTRA HECHODENUNCIADOHDCOTRA, t4.HDTE02 HECHODENUNCIADOHDTE02, t4.HDTE03 HECHODENUNCIADOHDTE03, t4.HDTE04 HECHODENUNCIADOHDTE04, t4.HDTE05 HECHODENUNCIADOHDTE05, t4.HDTE06 HECHODENUNCIADOHDTE06, t4.HDTE07 HECHODENUNCIADOHDTE07, t4.HDTE08 HECHODENUNCIADOHDTE08, t4.HDTE09 HECHODENUNCIADOHDTE09, t4.HDTE10 HECHODENUNCIADOHDTE10, t4.HDCOSC HECHODENUNCIADOHDCOSC, t4.HDIDAL HECHODENUNCIADOHDIDAL, t4.HDFEROAD HECHODENUNCIADOHDFEROAD, t4.HDFEROAT HECHODENUNCIADOHDFEROAT, t4.HDTEALDT HECHODENUNCIADOHDTEALDT, t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t4.HDFEHD HECHODENUNCIADOHDFEHD, t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t4.HDNOPSE HECHODENUNCIADOHDNOPSE, t4.HDNOPSI HECHODENUNCIADOHDNOPSI, t4.HDNOPSF HECHODENUNCIADOHDNOPSF, t4.HDNOPSA HECHODENUNCIADOHDNOPSA, t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t2.EHCOTEE TRAMITEHECHOEHCOTEE, t2.EHCOMO TRAMITEHECHOEHCOMO, t2.EHCOHD TRAMITEHECHOEHCOHD, t3.EHCOTEE TRAMITEHECHOEHCOTEE, t3.EHCOMO TRAMITEHECHOEHCOMO, t3.EHCOHD TRAMITEHECHOEHCOHD, t4.HDCODE HECHODENUNCIADOHDCODE, t4.HDCOES HECHODENUNCIADOHDCOES, t4.HDCOSE HECHODENUNCIADOHDCOSE, t4.HDCOMO HECHODENUNCIADOHDCOMO, t4.HDCOPS HECHODENUNCIADOHDCOPS, t4.HDCOTSR HECHODENUNCIADOHDCOTSR, t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
				+ "FROM DOCUMENTO_HECHO t1 , TRAMITE_HECHO t2 , TRAMITE_HECHO t3 , HECHO_DENUNCIADO t4  "
				+ "WHERE t1.Q5CODOCUMENTO = ?   AND t1.Q5TRMAIL= t2.EHCODIGO(+) AND t1.Q5TRAMITE= t3.EHCODIGO(+) AND t1.Q5HDCODIGO= t4.HDCODIGO(+)  ";
		return (DocumentoHecho) this.jdbcTemplate.queryForObject(query, rwMap,
				documentohecho.getQ5codocumento());
	}

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	@Transactional(readOnly = true)
	public DocumentoHecho findDocumentoHecho(DocumentoHecho documentohecho) {
		String query = "SELECT t1.Q5CODOCUMENTO Q5CODOCUMENTO, t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE, t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE, t1.Q5ORIGEN Q5ORIGEN, t1.Q5FECHA Q5FECHA, t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE "
				+ "FROM DOCUMENTO_HECHO t1  " + "WHERE t1.Q5CODOCUMENTO = ? ";
		return (DocumentoHecho) this.jdbcTemplate.queryForObject(query,
				new RowMapper<DocumentoHecho>() {
					public DocumentoHecho mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new DocumentoHecho(resultSet
								.getString("Q5CODOCUMENTO"), resultSet
								.getString("Q5NOFILE"), resultSet
								.getBlob("Q5DATAFILE"), resultSet
								.getInt("Q5SIZEFILE"), resultSet
								.getString("Q5TEDESFILE"), resultSet
								.getString("Q5ORIGEN"), resultSet
								.getDate("Q5FECHA"), resultSet
								.getString("Q5INDMAIL"), resultSet
								.getString("Q5CONTENTTYPEFILE"), null, null,
								null);
					}
				}, documentohecho.getQ5codocumento());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return
	 */
	public void remove(DocumentoHecho documentohecho) {
		String query = "DELETE  FROM DOCUMENTO_HECHO WHERE Q5CODOCUMENTO=?";
		this.jdbcTemplate.update(query, documentohecho.getQ5codocumento());
	}

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return
	 */
	public void removeDocumentoTramiteHecho(DocumentoHecho documentohecho) {
		StringBuffer query = new StringBuffer(3000);
		query.append("DELETE  FROM DOCUMENTO_HECHO WHERE Q5TRAMITE='")
				.append(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcodigo()).append("'");
		this.jdbcTemplate.update(query.toString());
	}

	/**
	 * Removes all documents of the Solicitud.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return
	 */
	public void removeDocumentosSolicitud(DocumentoHecho documentohecho) {
		String query = "DELETE  FROM DOCUMENTO_HECHO WHERE Q5HDCODIGO=?";
		this.jdbcTemplate.update(query, documentohecho.getHechoDenunciado()
				.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAll(DocumentoHecho documentohecho,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q5TRMAIL= t2.EHCODIGO(+) AND t1.Q5TRAMITE= t3.EHCODIGO(+) AND t1.Q5HDCODIGO= t4.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5NOFILE Q5NOFILE,t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t2.EHCODIGO TRAMITEHECHOEHCODIGO,t2.EHFECHA TRAMITEHECHOEHFECHA,t2.EHHORA TRAMITEHECHOEHHORA,t2.EHCODPOR TRAMITEHECHOEHCODPOR,t2.EHCODPDE TRAMITEHECHOEHCODPDE,t2.EHTEXTO TRAMITEHECHOEHTEXTO,t2.EHCOZS TRAMITEHECHOEHCOZS,t2.EHCIVIHE TRAMITEHECHOEHCIVIHE,t2.EHACUSE TRAMITEHECHOEHACUSE,t2.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL,t2.EHDIREMAIL TRAMITEHECHOEHDIREMAIL,t3.EHCODIGO TRAMITEHECHOEHCODIGO,t3.EHFECHA TRAMITEHECHOEHFECHA,t3.EHHORA TRAMITEHECHOEHHORA,t3.EHCODPOR TRAMITEHECHOEHCODPOR,t3.EHCODPDE TRAMITEHECHOEHCODPDE,t3.EHTEXTO TRAMITEHECHOEHTEXTO,t3.EHCOZS TRAMITEHECHOEHCOZS,t3.EHCIVIHE TRAMITEHECHOEHCIVIHE,t3.EHACUSE TRAMITEHECHOEHACUSE,t3.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL,t3.EHDIREMAIL TRAMITEHECHOEHDIREMAIL,t4.HDCODIGO HECHODENUNCIADOHDCODIGO,t4.HDNROR HECHODENUNCIADOHDNROR,t4.HDTE HECHODENUNCIADOHDTE,t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t4.HDCOAV HECHODENUNCIADOHDCOAV,t4.HDNOPS HECHODENUNCIADOHDNOPS,t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t4.HDINSOTR HECHODENUNCIADOHDINSOTR,t4.HDINSOMA HECHODENUNCIADOHDINSOMA,t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t4.HDTESO HECHODENUNCIADOHDTESO,t4.HDFEARDT HECHODENUNCIADOHDFEARDT,t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t4.HDINININ HECHODENUNCIADOHDINININ,t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t4.HDFEROPC HECHODENUNCIADOHDFEROPC,t4.HDCOREPC HECHODENUNCIADOHDCOREPC,t4.HDFEIORP HECHODENUNCIADOHDFEIORP,t4.HDFERORP HECHODENUNCIADOHDFERORP,t4.HDCOREAP HECHODENUNCIADOHDCOREAP,t4.HDFEIORA HECHODENUNCIADOHDFEIORA,t4.HDTEACPA HECHODENUNCIADOHDTEACPA,t4.HDFECEAC HECHODENUNCIADOHDFECEAC,t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t4.HDTEACDE HECHODENUNCIADOHDTEACDE,t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t4.HDCOTRA HECHODENUNCIADOHDCOTRA,t4.HDTE02 HECHODENUNCIADOHDTE02,t4.HDTE03 HECHODENUNCIADOHDTE03,t4.HDTE04 HECHODENUNCIADOHDTE04,t4.HDTE05 HECHODENUNCIADOHDTE05,t4.HDTE06 HECHODENUNCIADOHDTE06,t4.HDTE07 HECHODENUNCIADOHDTE07,t4.HDTE08 HECHODENUNCIADOHDTE08,t4.HDTE09 HECHODENUNCIADOHDTE09,t4.HDTE10 HECHODENUNCIADOHDTE10,t4.HDCOSC HECHODENUNCIADOHDCOSC,t4.HDIDAL HECHODENUNCIADOHDIDAL,t4.HDFEROAD HECHODENUNCIADOHDFEROAD,t4.HDFEROAT HECHODENUNCIADOHDFEROAT,t4.HDTEALDT HECHODENUNCIADOHDTEALDT,t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t4.HDFEHD HECHODENUNCIADOHDFEHD,t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t4.HDNOPSE HECHODENUNCIADOHDNOPSE,t4.HDNOPSI HECHODENUNCIADOHDNOPSI,t4.HDNOPSF HECHODENUNCIADOHDNOPSF,t4.HDNOPSA HECHODENUNCIADOHDNOPSA,t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t2.EHCOTEE TRAMITEHECHOEHCOTEE,t2.EHCOMO TRAMITEHECHOEHCOMO,t2.EHCOHD TRAMITEHECHOEHCOHD,t3.EHCOTEE TRAMITEHECHOEHCOTEE,t3.EHCOMO TRAMITEHECHOEHCOMO,t3.EHCOHD TRAMITEHECHOEHCOHD,t4.HDCODE HECHODENUNCIADOHDCODE,t4.HDCOES HECHODENUNCIADOHDCOES,t4.HDCOSE HECHODENUNCIADOHDCOSE,t4.HDCOMO HECHODENUNCIADOHDCOMO,t4.HDCOPS HECHODENUNCIADOHDCOPS,t4.HDCOTSR HECHODENUNCIADOHDCOTSR,t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DOCUMENTO_HECHO t1 ,TRAMITE_HECHO t2 ,TRAMITE_HECHO t3 ,HECHO_DENUNCIADO t4 ");

		if (documentohecho != null && documentohecho.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO = ?");
			params.add(documentohecho.getQ5codocumento());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND t2.EHCOTEE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getTramite()
					.getTrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.EHCOMO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getCensoMonitor().getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.EHCOHD = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhfecha() != null) {
			where.append(" AND t2.EHFECHA = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhfecha());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhhora() != null) {
			where.append(" AND t2.EHHORA = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhhora());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpor() != null) {
			where.append(" AND t2.EHCODPOR = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodpor());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpde() != null) {
			where.append(" AND t2.EHCODPDE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodpde());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhtexto() != null) {
			where.append(" AND t2.EHTEXTO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhtexto());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcozs() != null) {
			where.append(" AND t2.EHCOZS = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcozs());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcivihe() != null) {
			where.append(" AND t2.EHCIVIHE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcivihe());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhacuse() != null) {
			where.append(" AND t2.EHACUSE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhacuse());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhenviomail() != null) {
			where.append(" AND t2.EHENVIOMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getEhenviomail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhdiremail() != null) {
			where.append(" AND t2.EHDIREMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getEhdiremail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodigo() != null) {
			where.append(" AND t3.EHCODIGO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND t3.EHCOTEE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getTramite()
					.getTrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.EHCOMO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getCensoMonitor().getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t3.EHCOHD = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhfecha() != null) {
			where.append(" AND t3.EHFECHA = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhfecha());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhhora() != null) {
			where.append(" AND t3.EHHORA = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhhora());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpor() != null) {
			where.append(" AND t3.EHCODPOR = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodpor());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpde() != null) {
			where.append(" AND t3.EHCODPDE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodpde());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhtexto() != null) {
			where.append(" AND t3.EHTEXTO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhtexto());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcozs() != null) {
			where.append(" AND t3.EHCOZS = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhcozs());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcivihe() != null) {
			where.append(" AND t3.EHCIVIHE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcivihe());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhacuse() != null) {
			where.append(" AND t3.EHACUSE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhacuse());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhenviomail() != null) {
			where.append(" AND t3.EHENVIOMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhenviomail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhdiremail() != null) {
			where.append(" AND t3.EHDIREMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhdiremail());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getDenuncia() != null
				&& documentohecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t4.HDCODE = ?");
			params.add(documentohecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ?");
			params.add(documentohecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getSector() != null
				&& documentohecho.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND t4.HDCOSE = ?");
			params.add(documentohecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.HDCOMO = ?");
			params.add(documentohecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getProducto() != null
				&& documentohecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t4.HDCOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t4.HDCOTSR = ?");
			params.add(documentohecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getMotivo() != null
				&& documentohecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t4.HDCOTIR = ?");
			params.add(documentohecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnror());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t4.HDTE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t4.HDTEDOAD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoad());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t4.HDCOAV = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcoav());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t4.HDNOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t4.HDNOMAPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnomaps());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t4.HDNOMOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnomops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t4.HDNRLOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnrlops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfedmps());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t4.HDINSOTR = ?");
			params.add(documentohecho.getHechoDenunciado().getHdinsotr());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t4.HDINSOMA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdinsoma());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcaptso());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t4.HDTESO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteso());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeardt());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiohd());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t4.HDINININ = ?");
			params.add(documentohecho.getHechoDenunciado().getHdininin());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiopc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferopc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t4.HDCOREPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcorepc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiorp());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferorp());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t4.HDCOREAP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcoreap());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiora());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t4.HDTEACPA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteacpa());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeceac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t4.HDHOCEAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdhoceac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeioca());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t4.HDTEACDE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteacde());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeioac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiofc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t4.HDCOTRA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcotra());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t4.HDTE02 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte02());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t4.HDTE03 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte03());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t4.HDTE04 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte04());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t4.HDTE05 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte05());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t4.HDTE06 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte06());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t4.HDTE07 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte07());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t4.HDTE08 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte08());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t4.HDTE09 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte09());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t4.HDTE10 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte10());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcosc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t4.HDIDAL = ?");
			params.add(documentohecho.getHechoDenunciado().getHdidal());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferoad());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferoat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t4.HDTEALDT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtealdt());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t4.HDTEDEAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedeat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfedeat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfehd());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t4.HDTEDOADE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoade());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t4.HDTEDOADI = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoadi());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t4.HDTEDOADF = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoadf());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t4.HDTEDOADA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoada());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t4.HDNOPSE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopse());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t4.HDNOPSI = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsi());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t4.HDNOPSF = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsf());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t4.HDNOPSA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsa());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t4.HDCOCODIGO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcocodigo());
		}
		if (documentohecho != null && documentohecho.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(documentohecho.getQ5nofile());
		}
		if (documentohecho != null && documentohecho.getQ5sizefile() != null) {
			where.append(" AND t1.Q5SIZEFILE = ?");
			params.add(documentohecho.getQ5sizefile());
		}
		if (documentohecho != null && documentohecho.getQ5tedesfile() != null) {
			where.append(" AND t1.Q5TEDESFILE = ?");
			params.add(documentohecho.getQ5tedesfile());
		}
		if (documentohecho != null && documentohecho.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(documentohecho.getQ5origen());
		}
		if (documentohecho != null && documentohecho.getQ5fecha() != null) {
			where.append(" AND t1.Q5FECHA = ?");
			params.add(documentohecho.getQ5fecha());
		}
		if (documentohecho != null && documentohecho.getQ5indmail() != null) {
			where.append(" AND t1.Q5INDMAIL = ?");
			params.add(documentohecho.getQ5indmail());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DocumentoHecho documentohecho) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.Q5TRMAIL= t2.EHCODIGO(+) and t1.Q5TRAMITE= t3.EHCODIGO(+) and t1.Q5HDCODIGO= t4.HDCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DOCUMENTO_HECHO t1   ,  TRAMITE_HECHO t2   ,  TRAMITE_HECHO t3   ,  HECHO_DENUNCIADO t4  ");
		if (documentohecho != null && documentohecho.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO = ?");
			params.add(documentohecho.getQ5codocumento());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND t2.EHCOTEE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getTramite()
					.getTrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.EHCOMO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getCensoMonitor().getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.EHCOHD = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhfecha() != null) {
			where.append(" AND t2.EHFECHA = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhfecha());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhhora() != null) {
			where.append(" AND t2.EHHORA = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhhora());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpor() != null) {
			where.append(" AND t2.EHCODPOR = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodpor());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpde() != null) {
			where.append(" AND t2.EHCODPDE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcodpde());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhtexto() != null) {
			where.append(" AND t2.EHTEXTO = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhtexto());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcozs() != null) {
			where.append(" AND t2.EHCOZS = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcozs());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcivihe() != null) {
			where.append(" AND t2.EHCIVIHE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhcivihe());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhacuse() != null) {
			where.append(" AND t2.EHACUSE = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail().getEhacuse());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhenviomail() != null) {
			where.append(" AND t2.EHENVIOMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getEhenviomail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhdiremail() != null) {
			where.append(" AND t2.EHDIREMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5trmail()
					.getEhdiremail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodigo() != null) {
			where.append(" AND t3.EHCODIGO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND t3.EHCOTEE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getTramite()
					.getTrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.EHCOMO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getCensoMonitor().getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t3.EHCOHD = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhfecha() != null) {
			where.append(" AND t3.EHFECHA = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhfecha());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhhora() != null) {
			where.append(" AND t3.EHHORA = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhhora());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpor() != null) {
			where.append(" AND t3.EHCODPOR = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodpor());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpde() != null) {
			where.append(" AND t3.EHCODPDE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcodpde());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhtexto() != null) {
			where.append(" AND t3.EHTEXTO = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhtexto());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcozs() != null) {
			where.append(" AND t3.EHCOZS = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhcozs());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcivihe() != null) {
			where.append(" AND t3.EHCIVIHE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhcivihe());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhacuse() != null) {
			where.append(" AND t3.EHACUSE = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite().getEhacuse());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhenviomail() != null) {
			where.append(" AND t3.EHENVIOMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhenviomail());
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhdiremail() != null) {
			where.append(" AND t3.EHDIREMAIL = ?");
			params.add(documentohecho.getTramiteHechoByQ5tramite()
					.getEhdiremail());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getDenuncia() != null
				&& documentohecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t4.HDCODE = ?");
			params.add(documentohecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t4.HDCOES = ?");
			params.add(documentohecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getSector() != null
				&& documentohecho.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND t4.HDCOSE = ?");
			params.add(documentohecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t4.HDCOMO = ?");
			params.add(documentohecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getProducto() != null
				&& documentohecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t4.HDCOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t4.HDCOTSR = ?");
			params.add(documentohecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getMotivo() != null
				&& documentohecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t4.HDCOTIR = ?");
			params.add(documentohecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnror());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t4.HDTE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t4.HDTEDOAD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoad());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t4.HDCOAV = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcoav());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t4.HDNOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t4.HDNOMAPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnomaps());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t4.HDNOMOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnomops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t4.HDNRLOPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnrlops());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfedmps());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t4.HDINSOTR = ?");
			params.add(documentohecho.getHechoDenunciado().getHdinsotr());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t4.HDINSOMA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdinsoma());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcaptso());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t4.HDTESO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteso());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeardt());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiohd());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t4.HDINININ = ?");
			params.add(documentohecho.getHechoDenunciado().getHdininin());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiopc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferopc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t4.HDCOREPC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcorepc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiorp());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferorp());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t4.HDCOREAP = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcoreap());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiora());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t4.HDTEACPA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteacpa());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeceac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t4.HDHOCEAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdhoceac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeioca());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t4.HDTEACDE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdteacde());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeioac());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfeiofc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t4.HDCOTRA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcotra());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t4.HDTE02 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte02());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t4.HDTE03 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte03());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t4.HDTE04 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte04());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t4.HDTE05 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte05());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t4.HDTE06 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte06());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t4.HDTE07 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte07());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t4.HDTE08 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte08());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t4.HDTE09 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte09());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t4.HDTE10 = ?");
			params.add(documentohecho.getHechoDenunciado().getHdte10());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t4.HDCOSC = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcosc());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t4.HDIDAL = ?");
			params.add(documentohecho.getHechoDenunciado().getHdidal());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferoad());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdferoat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t4.HDTEALDT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtealdt());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t4.HDTEDEAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedeat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfedeat());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD = ?");
			params.add(documentohecho.getHechoDenunciado().getHdfehd());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t4.HDTEDOADE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoade());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t4.HDTEDOADI = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoadi());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t4.HDTEDOADF = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoadf());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t4.HDTEDOADA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdtedoada());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t4.HDNOPSE = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopse());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t4.HDNOPSI = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsi());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t4.HDNOPSF = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsf());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t4.HDNOPSA = ?");
			params.add(documentohecho.getHechoDenunciado().getHdnopsa());
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t4.HDCOCODIGO = ?");
			params.add(documentohecho.getHechoDenunciado().getHdcocodigo());
		}
		if (documentohecho != null && documentohecho.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(documentohecho.getQ5nofile());
		}
		if (documentohecho != null && documentohecho.getQ5sizefile() != null) {
			where.append(" AND t1.Q5SIZEFILE = ?");
			params.add(documentohecho.getQ5sizefile());
		}
		if (documentohecho != null && documentohecho.getQ5tedesfile() != null) {
			where.append(" AND t1.Q5TEDESFILE = ?");
			params.add(documentohecho.getQ5tedesfile());
		}
		if (documentohecho != null && documentohecho.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(documentohecho.getQ5origen());
		}
		if (documentohecho != null && documentohecho.getQ5fecha() != null) {
			where.append(" AND t1.Q5FECHA = ?");
			params.add(documentohecho.getQ5fecha());
		}
		if (documentohecho != null && documentohecho.getQ5indmail() != null) {
			where.append(" AND t1.Q5INDMAIL = ?");
			params.add(documentohecho.getQ5indmail());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHechoDetalle> findAllDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q5TRMAIL= t2.EHCODIGO(+) AND t1.Q5TRAMITE= t3.EHCODIGO(+) AND t1.Q5HDCODIGO= t4.HDCODIGO(+) AND t2.EHCOTEE= t5.TRCODIGO(+) AND t3.EHCOTEE= t6.TRCODIGO(+) AND t1.Q5ID_TIPODOC=t7.ID_TIPODOC(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE, t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE, t2.EHCODIGO EHCODIGOMAIL, t5.TRCODIGO TRCODIGOMAIL, t5.TRNOMBRE TRNOMBREMAIL, t5.TRNOMBREE TRNOMBREEMAIL, t5.TRBAJA TRBAJAMAIL, t3.EHCODIGO EHCODIGOTRAMITE, t6.TRCODIGO TRCODIGOTRAMITE, t6.TRNOMBRE TRNOMBRETRAMITE, t6.TRNOMBREE TRNOMBREETRAMITE, t6.TRBAJA TRBAJATRAMITE, t4.HDCODIGO HDCODIGO, t1.Q5ID_TIPODOC Q5ID_TIPODOC, t7.TDNOMBRE TDNOMBRE, t7.TDNOMBREE TDNOMBREE "
						+ "FROM DOCUMENTO_HECHO t1,TRAMITE_HECHO t2 ,TRAMITE_HECHO t3 ,HECHO_DENUNCIADO t4, TRAMITE t5, TRAMITE t6, TIPO_DOCUMENTO t7 ");

		if (documentoHechoDetalle != null
				&& documentoHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(documentoHechoDetalle.getHdcodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DocumentoHechoDetalle>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<DocumentoHechoDetalle>() {
					public DocumentoHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new DocumentoHechoDetalle(resultSet
								.getString("Q5CODOCUMENTO"), resultSet
								.getString("Q5NOFILE"), resultSet
								.getBlob("Q5DATAFILE"), resultSet
								.getInt("Q5SIZEFILE"), resultSet
								.getString("Q5TEDESFILE"), resultSet
								.getString("Q5ORIGEN"), resultSet
								.getDate("Q5FECHA"), resultSet
								.getString("Q5INDMAIL"), resultSet
								.getString("Q5CONTENTTYPEFILE"), resultSet
								.getString("EHCODIGOMAIL"), resultSet
								.getString("TRCODIGOMAIL"), resultSet
								.getString("TRNOMBREMAIL"), resultSet
								.getString("TRNOMBREEMAIL"), resultSet
								.getDate("TRBAJAMAIL"), resultSet
								.getString("EHCODIGOTRAMITE"), resultSet
								.getString("TRCODIGOTRAMITE"), resultSet
								.getString("TRNOMBRETRAMITE"), resultSet
								.getString("TRNOMBREETRAMITE"), resultSet
								.getDate("TRBAJATRAMITE"), resultSet
								.getString("HDCODIGO"), resultSet
								.getString("Q5ID_TIPODOC"), resultSet
								.getString("TDNOMBRE"), resultSet
								.getString("TDNOMBREE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentoHechoCount(
			DocumentoHechoDetalle documentoHechoDetalle) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q5TRMAIL= t2.EHCODIGO(+) AND t1.Q5TRAMITE= t3.EHCODIGO(+) AND t1.Q5HDCODIGO= t4.HDCODIGO(+) AND t2.EHCOTEE= t5.TRCODIGO(+) AND t3.EHCOTEE= t6.TRCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1,TRAMITE_HECHO t2 ,TRAMITE_HECHO t3 ,HECHO_DENUNCIADO t4, TRAMITE t5, TRAMITE t6 ");

		if (documentoHechoDetalle != null
				&& documentoHechoDetalle.getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO = ?");
			params.add(documentoHechoDetalle.getHdcodigo());
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAllLike(DocumentoHecho documentohecho,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q5TRMAIL= t2.EHCODIGO(+) AND t1.Q5TRAMITE= t3.EHCODIGO(+) AND t1.Q5HDCODIGO= t4.HDCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5NOFILE Q5NOFILE,t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL, t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t2.EHCODIGO TRAMITEHECHOEHCODIGO,t2.EHFECHA TRAMITEHECHOEHFECHA,t2.EHHORA TRAMITEHECHOEHHORA,t2.EHCODPOR TRAMITEHECHOEHCODPOR,t2.EHCODPDE TRAMITEHECHOEHCODPDE,t2.EHTEXTO TRAMITEHECHOEHTEXTO,t2.EHCOZS TRAMITEHECHOEHCOZS,t2.EHCIVIHE TRAMITEHECHOEHCIVIHE,t2.EHACUSE TRAMITEHECHOEHACUSE,t2.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL,t2.EHDIREMAIL TRAMITEHECHOEHDIREMAIL,t3.EHCODIGO TRAMITEHECHOEHCODIGO,t3.EHFECHA TRAMITEHECHOEHFECHA,t3.EHHORA TRAMITEHECHOEHHORA,t3.EHCODPOR TRAMITEHECHOEHCODPOR,t3.EHCODPDE TRAMITEHECHOEHCODPDE,t3.EHTEXTO TRAMITEHECHOEHTEXTO,t3.EHCOZS TRAMITEHECHOEHCOZS,t3.EHCIVIHE TRAMITEHECHOEHCIVIHE,t3.EHACUSE TRAMITEHECHOEHACUSE,t3.EHENVIOMAIL TRAMITEHECHOEHENVIOMAIL,t3.EHDIREMAIL TRAMITEHECHOEHDIREMAIL,t4.HDCODIGO HECHODENUNCIADOHDCODIGO,t4.HDNROR HECHODENUNCIADOHDNROR,t4.HDTE HECHODENUNCIADOHDTE,t4.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t4.HDCOAV HECHODENUNCIADOHDCOAV,t4.HDNOPS HECHODENUNCIADOHDNOPS,t4.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t4.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t4.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t4.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t4.HDINSOTR HECHODENUNCIADOHDINSOTR,t4.HDINSOMA HECHODENUNCIADOHDINSOMA,t4.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t4.HDTESO HECHODENUNCIADOHDTESO,t4.HDFEARDT HECHODENUNCIADOHDFEARDT,t4.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t4.HDINININ HECHODENUNCIADOHDINININ,t4.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t4.HDFEROPC HECHODENUNCIADOHDFEROPC,t4.HDCOREPC HECHODENUNCIADOHDCOREPC,t4.HDFEIORP HECHODENUNCIADOHDFEIORP,t4.HDFERORP HECHODENUNCIADOHDFERORP,t4.HDCOREAP HECHODENUNCIADOHDCOREAP,t4.HDFEIORA HECHODENUNCIADOHDFEIORA,t4.HDTEACPA HECHODENUNCIADOHDTEACPA,t4.HDFECEAC HECHODENUNCIADOHDFECEAC,t4.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t4.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t4.HDTEACDE HECHODENUNCIADOHDTEACDE,t4.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t4.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t4.HDCOTRA HECHODENUNCIADOHDCOTRA,t4.HDTE02 HECHODENUNCIADOHDTE02,t4.HDTE03 HECHODENUNCIADOHDTE03,t4.HDTE04 HECHODENUNCIADOHDTE04,t4.HDTE05 HECHODENUNCIADOHDTE05,t4.HDTE06 HECHODENUNCIADOHDTE06,t4.HDTE07 HECHODENUNCIADOHDTE07,t4.HDTE08 HECHODENUNCIADOHDTE08,t4.HDTE09 HECHODENUNCIADOHDTE09,t4.HDTE10 HECHODENUNCIADOHDTE10,t4.HDCOSC HECHODENUNCIADOHDCOSC,t4.HDIDAL HECHODENUNCIADOHDIDAL,t4.HDFEROAD HECHODENUNCIADOHDFEROAD,t4.HDFEROAT HECHODENUNCIADOHDFEROAT,t4.HDTEALDT HECHODENUNCIADOHDTEALDT,t4.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t4.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t4.HDFEHD HECHODENUNCIADOHDFEHD,t4.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t4.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t4.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t4.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t4.HDNOPSE HECHODENUNCIADOHDNOPSE,t4.HDNOPSI HECHODENUNCIADOHDNOPSI,t4.HDNOPSF HECHODENUNCIADOHDNOPSF,t4.HDNOPSA HECHODENUNCIADOHDNOPSA,t4.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t2.EHCOTEE TRAMITEHECHOEHCOTEE,t2.EHCOMO TRAMITEHECHOEHCOMO,t2.EHCOHD TRAMITEHECHOEHCOHD,t3.EHCOTEE TRAMITEHECHOEHCOTEE,t3.EHCOMO TRAMITEHECHOEHCOMO,t3.EHCOHD TRAMITEHECHOEHCOHD,t4.HDCODE HECHODENUNCIADOHDCODE,t4.HDCOES HECHODENUNCIADOHDCOES,t4.HDCOSE HECHODENUNCIADOHDCOSE,t4.HDCOMO HECHODENUNCIADOHDCOMO,t4.HDCOPS HECHODENUNCIADOHDCOPS,t4.HDCOTSR HECHODENUNCIADOHDCOTSR,t4.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DOCUMENTO_HECHO t1 ,TRAMITE_HECHO t2 ,TRAMITE_HECHO t3 ,HECHO_DENUNCIADO t4 ");

		if (documentohecho != null && documentohecho.getQ5codocumento() != null) {
			where.append(" AND t1.Q5CODOCUMENTO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5codocumento() + "%");
			} else {
				params.add("%" + documentohecho.getQ5codocumento() + "%");
			}
			where.append(" AND t1.Q5CODOCUMENTO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodigo() != null) {
			where.append(" AND t2.EHCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhcodigo() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhcodigo() + "%");
			}
			where.append(" AND t2.EHCODIGO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND UPPER(t2.EHCOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getTramite().getTrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getTramite().getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOTEE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t2.EHCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EHCOMO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND UPPER(t2.EHCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getHechoDenunciado().getHdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getHechoDenunciado().getHdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOHD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhfecha() != null) {
			where.append(" AND t2.EHFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhfecha() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhfecha() + "%");
			}
			where.append(" AND t2.EHFECHA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhhora() != null) {
			where.append(" AND UPPER(t2.EHHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhhora().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhhora().toUpperCase() + "%");
			}
			where.append(" AND t2.EHHORA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpor() != null) {
			where.append(" AND UPPER(t2.EHCODPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhcodpor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhcodpor().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODPOR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcodpde() != null) {
			where.append(" AND UPPER(t2.EHCODPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhcodpde().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhcodpde().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCODPDE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhtexto() != null) {
			where.append(" AND UPPER(t2.EHTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhtexto().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhtexto().toUpperCase() + "%");
			}
			where.append(" AND t2.EHTEXTO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcozs() != null) {
			where.append(" AND UPPER(t2.EHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhcozs().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhcozs().toUpperCase() + "%");
			}
			where.append(" AND t2.EHCOZS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhcivihe() != null) {
			where.append(" AND t2.EHCIVIHE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhcivihe() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhcivihe() + "%");
			}
			where.append(" AND t2.EHCIVIHE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhacuse() != null) {
			where.append(" AND t2.EHACUSE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhacuse() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhacuse() + "%");
			}
			where.append(" AND t2.EHACUSE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhenviomail() != null) {
			where.append(" AND UPPER(t2.EHENVIOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhenviomail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhenviomail().toUpperCase() + "%");
			}
			where.append(" AND t2.EHENVIOMAIL IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5trmail() != null
				&& documentohecho.getTramiteHechoByQ5trmail().getEhdiremail() != null) {
			where.append(" AND UPPER(t2.EHDIREMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5trmail()
						.getEhdiremail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5trmail()
								.getEhdiremail().toUpperCase() + "%");
			}
			where.append(" AND t2.EHDIREMAIL IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodigo() != null) {
			where.append(" AND t3.EHCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcodigo() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhcodigo() + "%");
			}
			where.append(" AND t3.EHCODIGO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getTramite()
						.getTrcodigo() != null) {
			where.append(" AND UPPER(t3.EHCOTEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getTramite().getTrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getTramite().getTrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.EHCOTEE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t3.EHCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.EHCOMO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado() != null
				&& documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND UPPER(t3.EHCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getHechoDenunciado().getHdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getHechoDenunciado().getHdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.EHCOHD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhfecha() != null) {
			where.append(" AND t3.EHFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhfecha() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhfecha() + "%");
			}
			where.append(" AND t3.EHFECHA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhhora() != null) {
			where.append(" AND UPPER(t3.EHHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhhora().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhhora().toUpperCase() + "%");
			}
			where.append(" AND t3.EHHORA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpor() != null) {
			where.append(" AND UPPER(t3.EHCODPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcodpor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhcodpor().toUpperCase() + "%");
			}
			where.append(" AND t3.EHCODPOR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcodpde() != null) {
			where.append(" AND UPPER(t3.EHCODPDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcodpde().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhcodpde().toUpperCase() + "%");
			}
			where.append(" AND t3.EHCODPDE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhtexto() != null) {
			where.append(" AND UPPER(t3.EHTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhtexto().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhtexto().toUpperCase() + "%");
			}
			where.append(" AND t3.EHTEXTO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcozs() != null) {
			where.append(" AND UPPER(t3.EHCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcozs().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhcozs().toUpperCase() + "%");
			}
			where.append(" AND t3.EHCOZS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhcivihe() != null) {
			where.append(" AND t3.EHCIVIHE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhcivihe() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhcivihe() + "%");
			}
			where.append(" AND t3.EHCIVIHE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhacuse() != null) {
			where.append(" AND t3.EHACUSE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhacuse() + "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhacuse() + "%");
			}
			where.append(" AND t3.EHACUSE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhenviomail() != null) {
			where.append(" AND UPPER(t3.EHENVIOMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhenviomail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhenviomail().toUpperCase() + "%");
			}
			where.append(" AND t3.EHENVIOMAIL IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getTramiteHechoByQ5tramite() != null
				&& documentohecho.getTramiteHechoByQ5tramite().getEhdiremail() != null) {
			where.append(" AND UPPER(t3.EHDIREMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getTramiteHechoByQ5tramite()
						.getEhdiremail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getTramiteHechoByQ5tramite()
								.getEhdiremail().toUpperCase() + "%");
			}
			where.append(" AND t3.EHDIREMAIL IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t4.HDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcodigo()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcodigo()
						+ "%");
			}
			where.append(" AND t4.HDCODIGO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getDenuncia() != null
				&& documentohecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND UPPER(t4.HDCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getDenuncia()
						.getDecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getDenuncia()
								.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCODE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento() != null
				&& documentohecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t4.HDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado()
						.getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado()
								.getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOES IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getSector() != null
				&& documentohecho.getHechoDenunciado().getSector()
						.getSecodigo() != null) {
			where.append(" AND UPPER(t4.HDCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getSector()
						.getSecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getSector()
								.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOSE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor() != null
				&& documentohecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t4.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado()
						.getCensoMonitor().getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOMO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getProducto() != null
				&& documentohecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND UPPER(t4.HDCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion() != null
				&& documentohecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND UPPER(t4.HDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado()
						.getTipoReclamacion().getTsrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado()
								.getTipoReclamacion().getTsrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTSR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getMotivo() != null
				&& documentohecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND UPPER(t4.HDCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getMotivo()
						.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getMotivo()
								.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTIR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t4.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnror()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnror() + "%");
			}
			where.append(" AND t4.HDNROR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND UPPER(t4.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND UPPER(t4.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedoad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedoad()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOAD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND UPPER(t4.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcoav()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcoav()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOAV IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND UPPER(t4.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND UPPER(t4.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOMAPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND UPPER(t4.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOMOPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND UPPER(t4.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNRLOPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t4.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfedmps()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfedmps()
						+ "%");
			}
			where.append(" AND t4.HDFEDMPS IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND UPPER(t4.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdinsotr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdinsotr()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINSOTR IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND UPPER(t4.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdinsoma()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdinsoma()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINSOMA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t4.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcaptso()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcaptso()
						+ "%");
			}
			where.append(" AND t4.HDCAPTSO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND UPPER(t4.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdteso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdteso()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTESO IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t4.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeardt()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeardt()
						+ "%");
			}
			where.append(" AND t4.HDFEARDT IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t4.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeiohd()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeiohd()
						+ "%");
			}
			where.append(" AND t4.HDFEIOHD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND UPPER(t4.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdininin()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdininin()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDINININ IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t4.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeiopc()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeiopc()
						+ "%");
			}
			where.append(" AND t4.HDFEIOPC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t4.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdferopc()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdferopc()
						+ "%");
			}
			where.append(" AND t4.HDFEROPC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND UPPER(t4.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcorepc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcorepc()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOREPC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t4.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeiorp()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeiorp()
						+ "%");
			}
			where.append(" AND t4.HDFEIORP IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t4.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdferorp()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdferorp()
						+ "%");
			}
			where.append(" AND t4.HDFERORP IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND UPPER(t4.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcoreap()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcoreap()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOREAP IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t4.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeiora()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeiora()
						+ "%");
			}
			where.append(" AND t4.HDFEIORA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND UPPER(t4.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdteacpa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdteacpa()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEACPA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t4.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeceac()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeceac()
						+ "%");
			}
			where.append(" AND t4.HDFECEAC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND UPPER(t4.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdhoceac()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdhoceac()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDHOCEAC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t4.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeioca()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeioca()
						+ "%");
			}
			where.append(" AND t4.HDFEIOCA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND UPPER(t4.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdteacde()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdteacde()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEACDE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t4.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeioac()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeioac()
						+ "%");
			}
			where.append(" AND t4.HDFEIOAC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t4.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfeiofc()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfeiofc()
						+ "%");
			}
			where.append(" AND t4.HDFEIOFC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND UPPER(t4.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcotra()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcotra()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOTRA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND UPPER(t4.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte02()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte02()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE02 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND UPPER(t4.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte03()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE03 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND UPPER(t4.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte04()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE04 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND UPPER(t4.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte05()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte05()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE05 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND UPPER(t4.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte06()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE06 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND UPPER(t4.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte07()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE07 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND UPPER(t4.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte08()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte08()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE08 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND UPPER(t4.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte09()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte09()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE09 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND UPPER(t4.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdte10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdte10()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTE10 IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND UPPER(t4.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcosc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcosc()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOSC IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND UPPER(t4.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdidal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdidal()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDIDAL IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t4.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdferoad()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdferoad()
						+ "%");
			}
			where.append(" AND t4.HDFEROAD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t4.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdferoat()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdferoat()
						+ "%");
			}
			where.append(" AND t4.HDFEROAT IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND UPPER(t4.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtealdt()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtealdt()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEALDT IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND UPPER(t4.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedeat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedeat()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDEAT IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t4.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfedeat()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfedeat()
						+ "%");
			}
			where.append(" AND t4.HDFEDEAT IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t4.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdfehd()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdfehd() + "%");
			}
			where.append(" AND t4.HDFEHD IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND UPPER(t4.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedoade()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedoade()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND UPPER(t4.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedoadi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedoadi()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADI IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND UPPER(t4.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedoadf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedoadf()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADF IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND UPPER(t4.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdtedoada()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdtedoada()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDTEDOADA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND UPPER(t4.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnopse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnopse()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSE IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND UPPER(t4.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnopsi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnopsi()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSI IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND UPPER(t4.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnopsf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnopsf()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSF IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND UPPER(t4.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdnopsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdnopsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDNOPSA IS NOT NULL");
		}
		if (documentohecho != null
				&& documentohecho.getHechoDenunciado() != null
				&& documentohecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND UPPER(t4.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getHechoDenunciado().getHdcocodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ documentohecho.getHechoDenunciado().getHdcocodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.HDCOCODIGO IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5nofile() != null) {
			where.append(" AND UPPER(t1.Q5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5nofile().toUpperCase() + "%");
			} else {
				params.add("%" + documentohecho.getQ5nofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5NOFILE IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5sizefile() != null) {
			where.append(" AND t1.Q5SIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5sizefile() + "%");
			} else {
				params.add("%" + documentohecho.getQ5sizefile() + "%");
			}
			where.append(" AND t1.Q5SIZEFILE IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5tedesfile() != null) {
			where.append(" AND UPPER(t1.Q5TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + documentohecho.getQ5tedesfile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5TEDESFILE IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5origen() != null) {
			where.append(" AND UPPER(t1.Q5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5origen().toUpperCase() + "%");
			} else {
				params.add("%" + documentohecho.getQ5origen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5ORIGEN IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5fecha() != null) {
			where.append(" AND t1.Q5FECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5fecha() + "%");
			} else {
				params.add("%" + documentohecho.getQ5fecha() + "%");
			}
			where.append(" AND t1.Q5FECHA IS NOT NULL");
		}
		if (documentohecho != null && documentohecho.getQ5indmail() != null) {
			where.append(" AND UPPER(t1.Q5INDMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(documentohecho.getQ5indmail().toUpperCase() + "%");
			} else {
				params.add("%" + documentohecho.getQ5indmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5INDMAIL IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21Q5T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Obtiene todos los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List<DocumentoHecho> lista de documentos
	 */
	@Transactional(readOnly = true)
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteComun tramiteComun, Pagination pagination) {
		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q5CODOCUMENTO Q5CODOCUMENTO,t1.Q5HDCODIGO Q5HDCODIGO,t1.Q5NOFILE Q5NOFILE, t1.Q5DATAFILE Q5DATAFILE,t1.Q5SIZEFILE Q5SIZEFILE,t1.Q5TEDESFILE Q5TEDESFILE,t1.Q5ORIGEN Q5ORIGEN,t1.Q5TRAMITE Q5TRAMITE,t1.Q5FECHA Q5FECHA,t1.Q5INDMAIL Q5INDMAIL,t1.Q5TRMAIL Q5TRMAIL,t1.Q5CONTENTTYPEFILE Q5CONTENTTYPEFILE,t1.Q5IDDOCUMENTUM Q5IDDOCUMENTUM,t1.Q5FECHAAPORTACION Q5FECHAAPORTACION,t1.Q5FECHAENTRADA Q5FECHAENTRADA,t1.Q5NUMREGISTROENTRADA Q5NUMREGISTROENTRADA,t1.Q5ID_PERFILFIRMA Q5IDPERFILFIRMA,t1.Q5ESTADODOCUMENTO Q5ESTADODOCUMENTO,t1.Q5FECHASOLFIRMA Q5FECHASOLFIRMA,t1.Q5FECHALIMFIRMA Q5FECHALIMFIRMA,t1.Q5FECHAFIRMA Q5FECHAFIRMA,t1.Q5COMOFIRMA Q5COMOFIRMA,t1.Q5ID_TIPODOC Q5IDTIPODOC,t1.Q5DESTINO Q5DESTINO, t1.Q5FECHASOLLOCALIZADOR Q5FECHASOLLOCALIZADOR, t1.Q5PTCODIGO Q5PTCODIGO ");
		query.append("FROM DOCUMENTO_HECHO t1 ");

		StringBuilder where = new StringBuilder("WHERE 1=1");

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<DocumentoHecho>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<DocumentoHecho>() {
					public DocumentoHecho mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new DocumentoHecho(resultSet
								.getString("Q5CODOCUMENTO"), resultSet
								.getString("Q5NOFILE"), resultSet
								.getBlob("Q5DATAFILE"), resultSet
								.getInt("Q5SIZEFILE"), resultSet
								.getString("Q5TEDESFILE"), resultSet
								.getString("Q5ORIGEN"), resultSet
								.getDate("Q5FECHA"), resultSet
								.getString("Q5INDMAIL"), resultSet
								.getString("Q5CONTENTTYPEFILE"), null, null,
								null);
					}
				}, params.toArray());
	}

	/**
	 * Cuenta los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @return Long número de resultados
	 */
	@Transactional(readOnly = true)
	public Long findAllDocumentosByTramiteCount(TramiteComun tramiteComun) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM DOCUMENTO_HECHO t1  WHERE 1=1 ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t1.Q5TRAMITE = ? ");
		params.add(tramiteComun.getIdTramite());

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
