package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.DocumentoHechoDetalle;
import com.ejie.y41a.model.TramiteComun;

/**
 * * DocumentoHechoDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface DocumentoHechoDao {

	/**
	 * Inserts a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho add(DocumentoHecho documentohecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho update(DocumentoHecho documentohecho);

	/**
	 * Updates a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	DocumentoHecho updateDocumentoHechoMail(DocumentoHecho documentohecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	DocumentoHecho find(DocumentoHecho documentohecho);

	/**
	 * Finds a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return DocumentoHecho
	 */
	DocumentoHecho findDocumentoHecho(DocumentoHecho documentohecho);

	/**
	 * Deletes a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return
	 */
	void remove(DocumentoHecho documentohecho);

	/**
	 * Removes a single row in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return
	 */
	void removeDocumentoTramiteHecho(DocumentoHecho documentohecho);

	/**
	 * Removes all documents of the Solicitud.
	 * 
	 * @param documentohecho
	 *            Pagination
	 * @return
	 */
	void removeDocumentosSolicitud(DocumentoHecho documentohecho);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoHecho> findAll(DocumentoHecho documentohecho,
			Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @return List
	 */
	Long findAllCount(DocumentoHecho documentohecho);

	/**
	 * Finds rows in the DocumentoHecho table using like.
	 * 
	 * @param documentohecho
	 *            DocumentoHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DocumentoHecho> findAllLike(DocumentoHecho documentohecho,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds a List of rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoHechoDetalle> findAllDocumentoHecho(
			DocumentoHechoDetalle documentoHechoDetalle, Pagination pagination);

	/**
	 * Counts rows in the DocumentoHecho table.
	 * 
	 * @param documentoHechoDetalle
	 *            DocumentoHechoDetalle
	 * @return Long
	 */
	Long findAllDocumentoHechoCount(DocumentoHechoDetalle documentoHechoDetalle);

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	Long getNewPK();

	/**
	 * Obtiene todos los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @param pagination
	 *            Pagination paginación
	 * @return List<DocumentoHecho> lista de documentos
	 */
	public List<DocumentoHecho> findAllDocumentosByTramite(
			TramiteComun tramiteComun, Pagination pagination);

	/**
	 * Cuenta los documentos asociados a un trámite
	 * 
	 * @param tramiteComun
	 *            TramiteComun filtro de trámite
	 * @return Long número de resultados
	 */
	public Long findAllDocumentosByTramiteCount(TramiteComun tramiteComun);
}
