package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consumidor;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.RangoEdad;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Denuncia;

/**
 * * DenunciaDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class DenunciaDaoImpl implements DenunciaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Denuncia> rwMap = new RowMapper<Denuncia>() {
		public Denuncia mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Denuncia(
					resultSet.getString("DECODIGO"),
					resultSet.getString("DECOCP"),
					resultSet.getString("DECOOR"),
					resultSet.getInt("DENRAN"),
					resultSet.getLong("DENROR"),
					resultSet.getDate("DEFEDE"),
					resultSet.getDate("DEFERE"),
					resultSet.getDate("DEFEEX"),
					resultSet.getDate("DEFEIM"),
					resultSet.getString("DEINRE"),
					resultSet.getString("DENRRGEN"),
					new FormaPresentacion(resultSet
							.getString("FormaPresentacionTFPCODIGO"), resultSet
							.getString("FormaPresentacionTFPNOMBRE"), resultSet
							.getString("FormaPresentacionTFPNOMBREE"),
							resultSet.getString("FormaPresentacionTFPNOMBREI"),
							resultSet.getString("FormaPresentacionTFPNOMBREF"),
							resultSet.getString("FormaPresentacionTFPNOMBREA")),
					new Consumidor(
							resultSet.getString("ConsumidorDTCODIGO"),
							new CensoMonitor(resultSet
									.getString("ConsumidorDTCOZS"), null, null,
									null, null, null, null, null, null, null,
									null, null),
							new RangoEdad(resultSet
									.getString("ConsumidorDTRANGOEDAD"), null,
									null, null),
							resultSet.getString("ConsumidorDTNOMBRE"),
							resultSet.getString("ConsumidorDTAPELLIDO1"),
							resultSet.getString("ConsumidorDTAPELLIDO2"),
							resultSet.getString("ConsumidorDTNIF"),
							resultSet.getString("ConsumidorDTNODIR"),
							resultSet.getString("ConsumidorDTCOLO"),
							resultSet.getString("ConsumidorDTNRCOPO"),
							resultSet.getString("ConsumidorDTNRTEL"),
							resultSet.getString("ConsumidorDTNRFAX"),
							resultSet.getString("ConsumidorDTCOPA"),
							resultSet.getString("ConsumidorDTNRDIMU"),
							resultSet.getString("ConsumidorDTTECOEM"),
							resultSet.getString("ConsumidorDTNRTEL2"),
							resultSet.getString("ConsumidorDTNRTEL3"),
							resultSet.getString("ConsumidorDTCOIDCO"),
							resultSet.getString("ConsumidorDTINRECO"),
							resultSet.getString("ConsumidorDTCOORAC"),
							resultSet.getString("ConsumidorDTNOAP1"),
							resultSet.getString("ConsumidorDTNOAP2"),
							resultSet.getString("ConsumidorDTNRSOCI"),
							resultSet.getString("ConsumidorDTNRAN"),
							resultSet.getString("ConsumidorDTCOSX"),
							resultSet.getString("ConsumidorDTNOREP"),
							resultSet.getString("ConsumidorDTNIFREP"),
							resultSet.getString("ConsumidorDTFEMOD"),
							resultSet.getString("ConsumidorDTNOLO"),
							resultSet.getString("ConsumidorDTCOPV"),
							resultSet.getString("ConsumidorDTINRL"),
							resultSet.getString("ConsumidorDTNODIRR"),
							resultSet.getString("ConsumidorDTCOLOR"),
							resultSet.getString("ConsumidorDTNRCOPOR"),
							resultSet.getString("ConsumidorDTCOPVR"),
							resultSet.getString("ConsumidorDTNRTELR"),
							resultSet.getString("ConsumidorDTNRTEL2R"),
							resultSet.getString("ConsumidorDTNRFAXR"),
							resultSet.getString("ConsumidorDTTEEMR"),
							resultSet.getString("ConsumidorDTINTIPID"),
							resultSet.getString("ConsumidorDTNORAPAISID"),
							resultSet.getString("ConsumidorDTNORAPAISNOMBRE"),
							resultSet.getString("ConsumidorDTNORAPROVINCIAID"),
							resultSet.getString("ConsumidorDTNOMBREPROVINCIA"),
							resultSet.getString("ConsumidorDTNORAMUNICIPIOID"),
							resultSet.getString("ConsumidorDTNOMBREMUNICIPIO"),
							resultSet.getString("ConsumidorDTNORALOCALIDADID"),
							resultSet.getString("ConsumidorDTNOMBRELOCALIDAD"),
							resultSet.getString("ConsumidorDTNORACALLEID"),
							resultSet.getString("ConsumidorDTNOMBRECALLE"),
							resultSet.getString("ConsumidorDTNORACPID"),
							resultSet.getString("ConsumidorDTNOMBRECP"),
							resultSet.getString("ConsumidorDTNORAPORTALID"),
							resultSet.getString("ConsumidorDTNOMBREPORTAL"),
							resultSet.getString("ConsumidorDTNOMBREPISO"),
							resultSet.getString("ConsumidorDTDIRECCION_NOCAPV"),
							null, null, null, null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	public Denuncia add(Denuncia denuncia) {

		String query = "INSERT INTO DENUNCIA( DECODIGO,DECOTFP,DECODT,DECOCP,DECOOR,DENRAN,DENROR,DEFEDE,DEFERE,DEFEEX,DEFEIM,DEINRE,DENRRGEN)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getFormaPresentacionTfpcodigoAux = null;
		if (denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = denuncia.getFormaPresentacion()
					.getTfpcodigo();
		}
		Object getConsumidorDtcodigoAux = null;
		if (denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			getConsumidorDtcodigoAux = denuncia.getConsumidor().getDtcodigo();
		}
		this.jdbcTemplate.update(query, denuncia.getDecodigo(),
				getFormaPresentacionTfpcodigoAux, getConsumidorDtcodigoAux,
				denuncia.getDecocp(), denuncia.getDecoor(),
				denuncia.getDenran(), denuncia.getDenror(),
				denuncia.getDefede(), denuncia.getDefere(),
				denuncia.getDefeex(), denuncia.getDefeim(),
				denuncia.getDeinre(), denuncia.getDenrrgen());
		return denuncia;
	}

	/**
	 * Inserts a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	public Denuncia addDenuncia(Denuncia denuncia) {

		String query = "INSERT INTO DENUNCIA( DECODIGO,DECOTFP,DECODT,DECOCP,DECOOR,DENRAN,DENROR,DEFEDE,DEFERE,DEFEEX,DEFEIM,DEINRE,DENRRGEN,DEHOJARECLAMACION )"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getFormaPresentacionTfpcodigoAux = null;
		if (denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = denuncia.getFormaPresentacion()
					.getTfpcodigo();
		}
		Object getConsumidorDtcodigoAux = null;
		if (denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			getConsumidorDtcodigoAux = denuncia.getConsumidor().getDtcodigo();
		}
		this.jdbcTemplate.update(query, denuncia.getDecodigo(),
				getFormaPresentacionTfpcodigoAux, getConsumidorDtcodigoAux,
				denuncia.getDecocp(), denuncia.getDecoor(),
				denuncia.getDenran(), denuncia.getDenror(),
				denuncia.getDefede(), denuncia.getDefere(),
				denuncia.getDefeex(), denuncia.getDefeim(),
				denuncia.getDeinre(), denuncia.getDenrrgen(),
				denuncia.getDehojareclamacion());
		return denuncia;
	}

	/**
	 * Updates a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	public Denuncia update(Denuncia denuncia) {
		String query = "UPDATE DENUNCIA SET DECOTFP=?,DECODT=?,DECOCP=?,DECOOR=?,DENRAN=?,DENROR=?,DEFEDE=?,DEFERE=?,DEFEEX=?,DEFEIM=?,DEINRE=?,DENRRGEN=?,DEHOJARECLAMACION=? WHERE DECODIGO=?";
		Object getFormaPresentacionTfpcodigoAux = null;
		if (denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			getFormaPresentacionTfpcodigoAux = denuncia.getFormaPresentacion()
					.getTfpcodigo();
		}
		Object getConsumidorDtcodigoAux = null;
		if (denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			getConsumidorDtcodigoAux = denuncia.getConsumidor().getDtcodigo();
		}
		this.jdbcTemplate.update(query, getFormaPresentacionTfpcodigoAux,
				getConsumidorDtcodigoAux, denuncia.getDecocp(),
				denuncia.getDecoor(), denuncia.getDenran(),
				denuncia.getDenror(), denuncia.getDefede(),
				denuncia.getDefere(), denuncia.getDefeex(),
				denuncia.getDefeim(), denuncia.getDeinre(),
				denuncia.getDenrrgen(), denuncia.getDehojareclamacion(),
				denuncia.getDecodigo());
		return denuncia;
	}

	/**
	 * Finds a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return Denuncia
	 */
	@Transactional(readOnly = true)
	public Denuncia find(Denuncia denuncia) {
		String query = "SELECT t1.DECODIGO DECODIGO, t1.DECOCP DECOCP, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.DEFEDE DEFEDE, t1.DEFERE DEFERE, t1.DEFEEX DEFEEX, t1.DEFEIM DEFEIM, t1.DEINRE DEINRE, t1.DENRRGEN DENRRGEN, t1.DEHOJARECLAMACION, t2.TFPCODIGO FORMAPRESENTACIONTFPCODIGO, t2.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE, t2.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE, t2.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI, t2.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF, t2.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA, t3.DTCODIGO CONSUMIDORDTCODIGO, t3.DTNOMBRE CONSUMIDORDTNOMBRE, t3.DTNIF CONSUMIDORDTNIF, t3.DTNODIR CONSUMIDORDTNODIR, t3.DTCOLO CONSUMIDORDTCOLO, t3.DTNRCOPO CONSUMIDORDTNRCOPO, t3.DTNRTEL CONSUMIDORDTNRTEL, t3.DTNRFAX CONSUMIDORDTNRFAX, t3.DTCOPA CONSUMIDORDTCOPA, t3.DTNRDIMU CONSUMIDORDTNRDIMU, t3.DTTECOEM CONSUMIDORDTTECOEM, t3.DTNRTEL2 CONSUMIDORDTNRTEL2, t3.DTNRTEL3 CONSUMIDORDTNRTEL3, t3.DTCOIDCO CONSUMIDORDTCOIDCO, t3.DTINRECO CONSUMIDORDTINRECO, t3.DTCOORAC CONSUMIDORDTCOORAC, t3.DTNOAP1 CONSUMIDORDTNOAP1, t3.DTNOAP2 CONSUMIDORDTNOAP2, t3.DTNRSOCI CONSUMIDORDTNRSOCI, t3.DTNRAN CONSUMIDORDTNRAN, t3.DTCOSX CONSUMIDORDTCOSX, t3.DTNOREP CONSUMIDORDTNOREP, t3.DTNIFREP CONSUMIDORDTNIFREP, t3.DTFEMOD CONSUMIDORDTFEMOD, t3.DTNOLO CONSUMIDORDTNOLO, t3.DTCOPV CONSUMIDORDTCOPV, t3.DTINRL CONSUMIDORDTINRL, t3.DTNODIRR CONSUMIDORDTNODIRR, t3.DTCOLOR CONSUMIDORDTCOLOR, t3.DTNRCOPOR CONSUMIDORDTNRCOPOR, t3.DTCOPVR CONSUMIDORDTCOPVR, t3.DTNRTELR CONSUMIDORDTNRTELR, t3.DTNRTEL2R CONSUMIDORDTNRTEL2R, t3.DTNRFAXR CONSUMIDORDTNRFAXR, t3.DTTEEMR CONSUMIDORDTTEEMR, t3.DTINTIPID CONSUMIDORDTINTIPID, t3.DTNORA_PAIS_ID CONSUMIDORDTNORAPAISID, t3.DTNORA_PAIS_NOMBRE CONSUMIDORDTNORAPAISNOMBRE, t3.DTNORA_PROVINCIA_ID CONSUMIDORDTNORAPROVINCIAID, t3.DTNOMBRE_PROVINCIA CONSUMIDORDTNOMBREPROVINCIA, t3.DTNORA_MUNICIPIO_ID CONSUMIDORDTNORAMUNICIPIOID, t3.DTNOMBRE_MUNICIPIO CONSUMIDORDTNOMBREMUNICIPIO, t3.DTNORA_LOCALIDAD_ID CONSUMIDORDTNORALOCALIDADID, t3.DTNOMBRE_LOCALIDAD CONSUMIDORDTNOMBRELOCALIDAD, t3.DTNORA_CALLE_ID CONSUMIDORDTNORACALLEID, t3.DTNOMBRE_CALLE CONSUMIDORDTNOMBRECALLE, t3.DTNORA_CP_ID CONSUMIDORDTNORACPID, t3.DTNOMBRE_CP CONSUMIDORDTNOMBRECP, t3.DTNORA_PORTAL_ID CONSUMIDORDTNORAPORTALID, t3.DTNOMBRE_PORTAL CONSUMIDORDTNOMBREPORTAL, t3.DTNOMBRE_PISO CONSUMIDORDTNOMBREPISO, t3.DTDIRECCION_NOCAPV ConsumidorDTDIRECCION_NOCAPV, t3.DTCOZS CONSUMIDORDTCOZS, t3.DTRANGO_EDAD CONSUMIDORDTRANGOEDAD "
				+ "FROM DENUNCIA t1 , FORMA_PRESENTACION t2 , CONSUMIDOR t3  "
				+ "WHERE t1.DECODIGO = ?   AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODT= t3.DTCODIGO(+)  ";
		return (Denuncia) this.jdbcTemplate.queryForObject(query, rwMap,
				denuncia.getDecodigo());
	}

	/**
	 * Removes a single row in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Pagination
	 * @return
	 */
	public void remove(Denuncia denuncia) {
		String query = "DELETE  FROM DENUNCIA WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, denuncia.getDecodigo());
	}

	/**
	 * Finds a List of rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Denuncia> findAll(Denuncia denuncia, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODT= t3.DTCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DECOCP DECOCP,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.DEFEDE DEFEDE,t1.DEFERE DEFERE,t1.DEFEEX DEFEEX,t1.DEFEIM DEFEIM,t1.DEINRE DEINRE,t1.DENRRGEN DENRRGEN,t1.DEHOJARECLAMACION,t2.TFPCODIGO FORMAPRESENTACIONTFPCODIGO,t2.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE,t2.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE,t2.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI,t2.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF,t2.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA,t3.DTCODIGO CONSUMIDORDTCODIGO,t3.DTNOMBRE CONSUMIDORDTNOMBRE,t3.DTNIF CONSUMIDORDTNIF,t3.DTNODIR CONSUMIDORDTNODIR,t3.DTCOLO CONSUMIDORDTCOLO,t3.DTNRCOPO CONSUMIDORDTNRCOPO,t3.DTNRTEL CONSUMIDORDTNRTEL,t3.DTNRFAX CONSUMIDORDTNRFAX,t3.DTCOPA CONSUMIDORDTCOPA,t3.DTNRDIMU CONSUMIDORDTNRDIMU,t3.DTTECOEM CONSUMIDORDTTECOEM,t3.DTNRTEL2 CONSUMIDORDTNRTEL2,t3.DTNRTEL3 CONSUMIDORDTNRTEL3,t3.DTCOIDCO CONSUMIDORDTCOIDCO,t3.DTINRECO CONSUMIDORDTINRECO,t3.DTCOORAC CONSUMIDORDTCOORAC,t3.DTNOAP1 CONSUMIDORDTNOAP1,t3.DTNOAP2 CONSUMIDORDTNOAP2,t3.DTNRSOCI CONSUMIDORDTNRSOCI,t3.DTNRAN CONSUMIDORDTNRAN,t3.DTCOSX CONSUMIDORDTCOSX,t3.DTNOREP CONSUMIDORDTNOREP,t3.DTNIFREP CONSUMIDORDTNIFREP,t3.DTFEMOD CONSUMIDORDTFEMOD,t3.DTNOLO CONSUMIDORDTNOLO,t3.DTCOPV CONSUMIDORDTCOPV,t3.DTINRL CONSUMIDORDTINRL,t3.DTNODIRR CONSUMIDORDTNODIRR,t3.DTCOLOR CONSUMIDORDTCOLOR,t3.DTNRCOPOR CONSUMIDORDTNRCOPOR,t3.DTCOPVR CONSUMIDORDTCOPVR,t3.DTNRTELR CONSUMIDORDTNRTELR,t3.DTNRTEL2R CONSUMIDORDTNRTEL2R,t3.DTNRFAXR CONSUMIDORDTNRFAXR,t3.DTTEEMR CONSUMIDORDTTEEMR,t3.DTINTIPID CONSUMIDORDTINTIPID,t3.DTNORA_PAIS_ID CONSUMIDORDTNORAPAISID,t3.DTNORA_PAIS_NOMBRE CONSUMIDORDTNORAPAISNOMBRE,t3.DTNORA_PROVINCIA_ID CONSUMIDORDTNORAPROVINCIAID,t3.DTNOMBRE_PROVINCIA CONSUMIDORDTNOMBREPROVINCIA,t3.DTNORA_MUNICIPIO_ID CONSUMIDORDTNORAMUNICIPIOID,t3.DTNOMBRE_MUNICIPIO CONSUMIDORDTNOMBREMUNICIPIO,t3.DTNORA_LOCALIDAD_ID CONSUMIDORDTNORALOCALIDADID,t3.DTNOMBRE_LOCALIDAD CONSUMIDORDTNOMBRELOCALIDAD,t3.DTNORA_CALLE_ID CONSUMIDORDTNORACALLEID,t3.DTNOMBRE_CALLE CONSUMIDORDTNOMBRECALLE,t3.DTNORA_CP_ID CONSUMIDORDTNORACPID,t3.DTNOMBRE_CP CONSUMIDORDTNOMBRECP,t3.DTNORA_PORTAL_ID CONSUMIDORDTNORAPORTALID,t3.DTNOMBRE_PORTAL CONSUMIDORDTNOMBREPORTAL,t3.DTNOMBRE_PISO CONSUMIDORDTNOMBREPISO, t3.DTDIRECCION_NOCAPV ConsumidorDTDIRECCION_NOCAPV,t3.DTCOZS CONSUMIDORDTCOZS,t3.DTRANGO_EDAD CONSUMIDORDTRANGOEDAD "
						+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2 ,CONSUMIDOR t3 ");

		if (denuncia != null && denuncia.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(denuncia.getDecodigo());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t2.TFPCODIGO = ?");
			params.add(denuncia.getFormaPresentacion().getTfpcodigo());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND t2.TFPNOMBRE = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombre());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND t2.TFPNOMBREE = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombree());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t2.TFPNOMBREI = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombrei());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t2.TFPNOMBREF = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombref());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t2.TFPNOMBREA = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombrea());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			where.append(" AND t3.DTCODIGO = ?");
			params.add(denuncia.getConsumidor().getDtcodigo());
		}
		if (denuncia != null
				&& denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getCensoMonitor() != null
				&& denuncia.getConsumidor().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.DTCOZS = ?");
			params.add(denuncia.getConsumidor().getCensoMonitor().getMocodigo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getRangoEdad() != null
				&& denuncia.getConsumidor().getRangoEdad().getRancod() != null) {
			where.append(" AND t3.DTRANGO_EDAD = ?");
			params.add(denuncia.getConsumidor().getRangoEdad().getRancod());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombre() != null) {
			where.append(" AND t3.DTNOMBRE = ?");
			params.add(denuncia.getConsumidor().getDtnombre());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnif() != null) {
			where.append(" AND t3.DTNIF = ?");
			params.add(denuncia.getConsumidor().getDtnif());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodir() != null) {
			where.append(" AND t3.DTNODIR = ?");
			params.add(denuncia.getConsumidor().getDtnodir());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolo() != null) {
			where.append(" AND t3.DTCOLO = ?");
			params.add(denuncia.getConsumidor().getDtcolo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopo() != null) {
			where.append(" AND t3.DTNRCOPO = ?");
			params.add(denuncia.getConsumidor().getDtnrcopo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel() != null) {
			where.append(" AND t3.DTNRTEL = ?");
			params.add(denuncia.getConsumidor().getDtnrtel());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfax() != null) {
			where.append(" AND t3.DTNRFAX = ?");
			params.add(denuncia.getConsumidor().getDtnrfax());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopa() != null) {
			where.append(" AND t3.DTCOPA = ?");
			params.add(denuncia.getConsumidor().getDtcopa());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrdimu() != null) {
			where.append(" AND t3.DTNRDIMU = ?");
			params.add(denuncia.getConsumidor().getDtnrdimu());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDttecoem() != null) {
			where.append(" AND t3.DTTECOEM = ?");
			params.add(denuncia.getConsumidor().getDttecoem());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2() != null) {
			where.append(" AND t3.DTNRTEL2 = ?");
			params.add(denuncia.getConsumidor().getDtnrtel2());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel3() != null) {
			where.append(" AND t3.DTNRTEL3 = ?");
			params.add(denuncia.getConsumidor().getDtnrtel3());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoidco() != null) {
			where.append(" AND t3.DTCOIDCO = ?");
			params.add(denuncia.getConsumidor().getDtcoidco());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinreco() != null) {
			where.append(" AND t3.DTINRECO = ?");
			params.add(denuncia.getConsumidor().getDtinreco());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoorac() != null) {
			where.append(" AND t3.DTCOORAC = ?");
			params.add(denuncia.getConsumidor().getDtcoorac());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap1() != null) {
			where.append(" AND t3.DTNOAP1 = ?");
			params.add(denuncia.getConsumidor().getDtnoap1());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap2() != null) {
			where.append(" AND t3.DTNOAP2 = ?");
			params.add(denuncia.getConsumidor().getDtnoap2());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrsoci() != null) {
			where.append(" AND t3.DTNRSOCI = ?");
			params.add(denuncia.getConsumidor().getDtnrsoci());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnran() != null) {
			where.append(" AND t3.DTNRAN = ?");
			params.add(denuncia.getConsumidor().getDtnran());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcosx() != null) {
			where.append(" AND t3.DTCOSX = ?");
			params.add(denuncia.getConsumidor().getDtcosx());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnorep() != null) {
			where.append(" AND t3.DTNOREP = ?");
			params.add(denuncia.getConsumidor().getDtnorep());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnifrep() != null) {
			where.append(" AND t3.DTNIFREP = ?");
			params.add(denuncia.getConsumidor().getDtnifrep());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtfemod() != null) {
			where.append(" AND t3.DTFEMOD = ?");
			params.add(denuncia.getConsumidor().getDtfemod());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnolo() != null) {
			where.append(" AND t3.DTNOLO = ?");
			params.add(denuncia.getConsumidor().getDtnolo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopv() != null) {
			where.append(" AND t3.DTCOPV = ?");
			params.add(denuncia.getConsumidor().getDtcopv());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinrl() != null) {
			where.append(" AND t3.DTINRL = ?");
			params.add(denuncia.getConsumidor().getDtinrl());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodirr() != null) {
			where.append(" AND t3.DTNODIRR = ?");
			params.add(denuncia.getConsumidor().getDtnodirr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolor() != null) {
			where.append(" AND t3.DTCOLOR = ?");
			params.add(denuncia.getConsumidor().getDtcolor());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopor() != null) {
			where.append(" AND t3.DTNRCOPOR = ?");
			params.add(denuncia.getConsumidor().getDtnrcopor());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopvr() != null) {
			where.append(" AND t3.DTCOPVR = ?");
			params.add(denuncia.getConsumidor().getDtcopvr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtelr() != null) {
			where.append(" AND t3.DTNRTELR = ?");
			params.add(denuncia.getConsumidor().getDtnrtelr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2r() != null) {
			where.append(" AND t3.DTNRTEL2R = ?");
			params.add(denuncia.getConsumidor().getDtnrtel2r());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfaxr() != null) {
			where.append(" AND t3.DTNRFAXR = ?");
			params.add(denuncia.getConsumidor().getDtnrfaxr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtteemr() != null) {
			where.append(" AND t3.DTTEEMR = ?");
			params.add(denuncia.getConsumidor().getDtteemr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtintipid() != null) {
			where.append(" AND t3.DTINTIPID = ?");
			params.add(denuncia.getConsumidor().getDtintipid());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisId() != null) {
			where.append(" AND t3.DTNORA_PAIS_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraPaisId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisNombre() != null) {
			where.append(" AND t3.DTNORA_PAIS_NOMBRE = ?");
			params.add(denuncia.getConsumidor().getDtnoraPaisNombre());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraProvinciaId() != null) {
			where.append(" AND t3.DTNORA_PROVINCIA_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraProvinciaId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreProvincia() != null) {
			where.append(" AND t3.DTNOMBRE_PROVINCIA = ?");
			params.add(denuncia.getConsumidor().getDtnombreProvincia());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraMunicipioId() != null) {
			where.append(" AND t3.DTNORA_MUNICIPIO_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraMunicipioId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreMunicipio() != null) {
			where.append(" AND t3.DTNOMBRE_MUNICIPIO = ?");
			params.add(denuncia.getConsumidor().getDtnombreMunicipio());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraLocalidadId() != null) {
			where.append(" AND t3.DTNORA_LOCALIDAD_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraLocalidadId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreLocalidad() != null) {
			where.append(" AND t3.DTNOMBRE_LOCALIDAD = ?");
			params.add(denuncia.getConsumidor().getDtnombreLocalidad());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCalleId() != null) {
			where.append(" AND t3.DTNORA_CALLE_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraCalleId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCalle() != null) {
			where.append(" AND t3.DTNOMBRE_CALLE = ?");
			params.add(denuncia.getConsumidor().getDtnombreCalle());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCpId() != null) {
			where.append(" AND t3.DTNORA_CP_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraCpId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCp() != null) {
			where.append(" AND t3.DTNOMBRE_CP = ?");
			params.add(denuncia.getConsumidor().getDtnombreCp());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPortalId() != null) {
			where.append(" AND t3.DTNORA_PORTAL_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraPortalId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePortal() != null) {
			where.append(" AND t3.DTNOMBRE_PORTAL = ?");
			params.add(denuncia.getConsumidor().getDtnombrePortal());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePiso() != null) {
			where.append(" AND t3.DTNOMBRE_PISO = ?");
			params.add(denuncia.getConsumidor().getDtnombrePiso());
		}
		if (denuncia != null && denuncia.getDecocp() != null) {
			where.append(" AND t1.DECOCP = ?");
			params.add(denuncia.getDecocp());
		}
		if (denuncia != null && denuncia.getDecoor() != null) {
			where.append(" AND t1.DECOOR = ?");
			params.add(denuncia.getDecoor());
		}
		if (denuncia != null && denuncia.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(denuncia.getDenran());
		}
		if (denuncia != null && denuncia.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(denuncia.getDenror());
		}
		if (denuncia != null && denuncia.getDefede() != null) {
			where.append(" AND t1.DEFEDE = ?");
			params.add(denuncia.getDefede());
		}
		if (denuncia != null && denuncia.getDefere() != null) {
			where.append(" AND t1.DEFERE = ?");
			params.add(denuncia.getDefere());
		}
		if (denuncia != null && denuncia.getDefeex() != null) {
			where.append(" AND t1.DEFEEX = ?");
			params.add(denuncia.getDefeex());
		}
		if (denuncia != null && denuncia.getDefeim() != null) {
			where.append(" AND t1.DEFEIM = ?");
			params.add(denuncia.getDefeim());
		}
		if (denuncia != null && denuncia.getDeinre() != null) {
			where.append(" AND t1.DEINRE = ?");
			params.add(denuncia.getDeinre());
		}
		if (denuncia != null && denuncia.getDenrrgen() != null) {
			where.append(" AND t1.DENRRGEN = ?");
			params.add(denuncia.getDenrrgen());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Denuncia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Denuncia table.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Denuncia denuncia) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.DECOTFP= t2.TFPCODIGO(+) and t1.DECODT= t3.DTCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DENUNCIA t1   ,  FORMA_PRESENTACION t2   ,  CONSUMIDOR t3  ");
		if (denuncia != null && denuncia.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(denuncia.getDecodigo());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t2.TFPCODIGO = ?");
			params.add(denuncia.getFormaPresentacion().getTfpcodigo());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND t2.TFPNOMBRE = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombre());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND t2.TFPNOMBREE = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombree());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND t2.TFPNOMBREI = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombrei());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND t2.TFPNOMBREF = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombref());
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND t2.TFPNOMBREA = ?");
			params.add(denuncia.getFormaPresentacion().getTfpnombrea());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			where.append(" AND t3.DTCODIGO = ?");
			params.add(denuncia.getConsumidor().getDtcodigo());
		}
		if (denuncia != null
				&& denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getCensoMonitor() != null
				&& denuncia.getConsumidor().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t3.DTCOZS = ?");
			params.add(denuncia.getConsumidor().getCensoMonitor().getMocodigo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getRangoEdad() != null
				&& denuncia.getConsumidor().getRangoEdad().getRancod() != null) {
			where.append(" AND t3.DTRANGO_EDAD = ?");
			params.add(denuncia.getConsumidor().getRangoEdad().getRancod());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombre() != null) {
			where.append(" AND t3.DTNOMBRE = ?");
			params.add(denuncia.getConsumidor().getDtnombre());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnif() != null) {
			where.append(" AND t3.DTNIF = ?");
			params.add(denuncia.getConsumidor().getDtnif());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodir() != null) {
			where.append(" AND t3.DTNODIR = ?");
			params.add(denuncia.getConsumidor().getDtnodir());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolo() != null) {
			where.append(" AND t3.DTCOLO = ?");
			params.add(denuncia.getConsumidor().getDtcolo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopo() != null) {
			where.append(" AND t3.DTNRCOPO = ?");
			params.add(denuncia.getConsumidor().getDtnrcopo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel() != null) {
			where.append(" AND t3.DTNRTEL = ?");
			params.add(denuncia.getConsumidor().getDtnrtel());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfax() != null) {
			where.append(" AND t3.DTNRFAX = ?");
			params.add(denuncia.getConsumidor().getDtnrfax());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopa() != null) {
			where.append(" AND t3.DTCOPA = ?");
			params.add(denuncia.getConsumidor().getDtcopa());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrdimu() != null) {
			where.append(" AND t3.DTNRDIMU = ?");
			params.add(denuncia.getConsumidor().getDtnrdimu());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDttecoem() != null) {
			where.append(" AND t3.DTTECOEM = ?");
			params.add(denuncia.getConsumidor().getDttecoem());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2() != null) {
			where.append(" AND t3.DTNRTEL2 = ?");
			params.add(denuncia.getConsumidor().getDtnrtel2());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel3() != null) {
			where.append(" AND t3.DTNRTEL3 = ?");
			params.add(denuncia.getConsumidor().getDtnrtel3());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoidco() != null) {
			where.append(" AND t3.DTCOIDCO = ?");
			params.add(denuncia.getConsumidor().getDtcoidco());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinreco() != null) {
			where.append(" AND t3.DTINRECO = ?");
			params.add(denuncia.getConsumidor().getDtinreco());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoorac() != null) {
			where.append(" AND t3.DTCOORAC = ?");
			params.add(denuncia.getConsumidor().getDtcoorac());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap1() != null) {
			where.append(" AND t3.DTNOAP1 = ?");
			params.add(denuncia.getConsumidor().getDtnoap1());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap2() != null) {
			where.append(" AND t3.DTNOAP2 = ?");
			params.add(denuncia.getConsumidor().getDtnoap2());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrsoci() != null) {
			where.append(" AND t3.DTNRSOCI = ?");
			params.add(denuncia.getConsumidor().getDtnrsoci());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnran() != null) {
			where.append(" AND t3.DTNRAN = ?");
			params.add(denuncia.getConsumidor().getDtnran());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcosx() != null) {
			where.append(" AND t3.DTCOSX = ?");
			params.add(denuncia.getConsumidor().getDtcosx());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnorep() != null) {
			where.append(" AND t3.DTNOREP = ?");
			params.add(denuncia.getConsumidor().getDtnorep());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnifrep() != null) {
			where.append(" AND t3.DTNIFREP = ?");
			params.add(denuncia.getConsumidor().getDtnifrep());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtfemod() != null) {
			where.append(" AND t3.DTFEMOD = ?");
			params.add(denuncia.getConsumidor().getDtfemod());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnolo() != null) {
			where.append(" AND t3.DTNOLO = ?");
			params.add(denuncia.getConsumidor().getDtnolo());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopv() != null) {
			where.append(" AND t3.DTCOPV = ?");
			params.add(denuncia.getConsumidor().getDtcopv());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinrl() != null) {
			where.append(" AND t3.DTINRL = ?");
			params.add(denuncia.getConsumidor().getDtinrl());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodirr() != null) {
			where.append(" AND t3.DTNODIRR = ?");
			params.add(denuncia.getConsumidor().getDtnodirr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolor() != null) {
			where.append(" AND t3.DTCOLOR = ?");
			params.add(denuncia.getConsumidor().getDtcolor());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopor() != null) {
			where.append(" AND t3.DTNRCOPOR = ?");
			params.add(denuncia.getConsumidor().getDtnrcopor());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopvr() != null) {
			where.append(" AND t3.DTCOPVR = ?");
			params.add(denuncia.getConsumidor().getDtcopvr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtelr() != null) {
			where.append(" AND t3.DTNRTELR = ?");
			params.add(denuncia.getConsumidor().getDtnrtelr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2r() != null) {
			where.append(" AND t3.DTNRTEL2R = ?");
			params.add(denuncia.getConsumidor().getDtnrtel2r());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfaxr() != null) {
			where.append(" AND t3.DTNRFAXR = ?");
			params.add(denuncia.getConsumidor().getDtnrfaxr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtteemr() != null) {
			where.append(" AND t3.DTTEEMR = ?");
			params.add(denuncia.getConsumidor().getDtteemr());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtintipid() != null) {
			where.append(" AND t3.DTINTIPID = ?");
			params.add(denuncia.getConsumidor().getDtintipid());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisId() != null) {
			where.append(" AND t3.DTNORA_PAIS_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraPaisId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisNombre() != null) {
			where.append(" AND t3.DTNORA_PAIS_NOMBRE = ?");
			params.add(denuncia.getConsumidor().getDtnoraPaisNombre());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraProvinciaId() != null) {
			where.append(" AND t3.DTNORA_PROVINCIA_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraProvinciaId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreProvincia() != null) {
			where.append(" AND t3.DTNOMBRE_PROVINCIA = ?");
			params.add(denuncia.getConsumidor().getDtnombreProvincia());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraMunicipioId() != null) {
			where.append(" AND t3.DTNORA_MUNICIPIO_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraMunicipioId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreMunicipio() != null) {
			where.append(" AND t3.DTNOMBRE_MUNICIPIO = ?");
			params.add(denuncia.getConsumidor().getDtnombreMunicipio());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraLocalidadId() != null) {
			where.append(" AND t3.DTNORA_LOCALIDAD_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraLocalidadId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreLocalidad() != null) {
			where.append(" AND t3.DTNOMBRE_LOCALIDAD = ?");
			params.add(denuncia.getConsumidor().getDtnombreLocalidad());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCalleId() != null) {
			where.append(" AND t3.DTNORA_CALLE_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraCalleId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCalle() != null) {
			where.append(" AND t3.DTNOMBRE_CALLE = ?");
			params.add(denuncia.getConsumidor().getDtnombreCalle());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCpId() != null) {
			where.append(" AND t3.DTNORA_CP_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraCpId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCp() != null) {
			where.append(" AND t3.DTNOMBRE_CP = ?");
			params.add(denuncia.getConsumidor().getDtnombreCp());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPortalId() != null) {
			where.append(" AND t3.DTNORA_PORTAL_ID = ?");
			params.add(denuncia.getConsumidor().getDtnoraPortalId());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePortal() != null) {
			where.append(" AND t3.DTNOMBRE_PORTAL = ?");
			params.add(denuncia.getConsumidor().getDtnombrePortal());
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePiso() != null) {
			where.append(" AND t3.DTNOMBRE_PISO = ?");
			params.add(denuncia.getConsumidor().getDtnombrePiso());
		}
		if (denuncia != null && denuncia.getDecocp() != null) {
			where.append(" AND t1.DECOCP = ?");
			params.add(denuncia.getDecocp());
		}
		if (denuncia != null && denuncia.getDecoor() != null) {
			where.append(" AND t1.DECOOR = ?");
			params.add(denuncia.getDecoor());
		}
		if (denuncia != null && denuncia.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(denuncia.getDenran());
		}
		if (denuncia != null && denuncia.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(denuncia.getDenror());
		}
		if (denuncia != null && denuncia.getDefede() != null) {
			where.append(" AND t1.DEFEDE = ?");
			params.add(denuncia.getDefede());
		}
		if (denuncia != null && denuncia.getDefere() != null) {
			where.append(" AND t1.DEFERE = ?");
			params.add(denuncia.getDefere());
		}
		if (denuncia != null && denuncia.getDefeex() != null) {
			where.append(" AND t1.DEFEEX = ?");
			params.add(denuncia.getDefeex());
		}
		if (denuncia != null && denuncia.getDefeim() != null) {
			where.append(" AND t1.DEFEIM = ?");
			params.add(denuncia.getDefeim());
		}
		if (denuncia != null && denuncia.getDeinre() != null) {
			where.append(" AND t1.DEINRE = ?");
			params.add(denuncia.getDeinre());
		}
		if (denuncia != null && denuncia.getDenrrgen() != null) {
			where.append(" AND t1.DENRRGEN = ?");
			params.add(denuncia.getDenrrgen());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Denuncia table using like.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Denuncia> findAllLike(Denuncia denuncia, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.DECOTFP= t2.TFPCODIGO(+) AND t1.DECODT= t3.DTCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DECOCP DECOCP,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.DEFEDE DEFEDE,t1.DEFERE DEFERE,t1.DEFEEX DEFEEX,t1.DEFEIM DEFEIM,t1.DEINRE DEINRE,t1.DENRRGEN DENRRGEN,t1.DEHOJARECLAMACION,t2.TFPCODIGO FORMAPRESENTACIONTFPCODIGO,t2.TFPNOMBRE FORMAPRESENTACIONTFPNOMBRE,t2.TFPNOMBREE FORMAPRESENTACIONTFPNOMBREE,t2.TFPNOMBREI FORMAPRESENTACIONTFPNOMBREI,t2.TFPNOMBREF FORMAPRESENTACIONTFPNOMBREF,t2.TFPNOMBREA FORMAPRESENTACIONTFPNOMBREA,t3.DTCODIGO CONSUMIDORDTCODIGO,t3.DTNOMBRE CONSUMIDORDTNOMBRE,t3.DTNIF CONSUMIDORDTNIF,t3.DTNODIR CONSUMIDORDTNODIR,t3.DTCOLO CONSUMIDORDTCOLO,t3.DTNRCOPO CONSUMIDORDTNRCOPO,t3.DTNRTEL CONSUMIDORDTNRTEL,t3.DTNRFAX CONSUMIDORDTNRFAX,t3.DTCOPA CONSUMIDORDTCOPA,t3.DTNRDIMU CONSUMIDORDTNRDIMU,t3.DTTECOEM CONSUMIDORDTTECOEM,t3.DTNRTEL2 CONSUMIDORDTNRTEL2,t3.DTNRTEL3 CONSUMIDORDTNRTEL3,t3.DTCOIDCO CONSUMIDORDTCOIDCO,t3.DTINRECO CONSUMIDORDTINRECO,t3.DTCOORAC CONSUMIDORDTCOORAC,t3.DTNOAP1 CONSUMIDORDTNOAP1,t3.DTNOAP2 CONSUMIDORDTNOAP2,t3.DTNRSOCI CONSUMIDORDTNRSOCI,t3.DTNRAN CONSUMIDORDTNRAN,t3.DTCOSX CONSUMIDORDTCOSX,t3.DTNOREP CONSUMIDORDTNOREP,t3.DTNIFREP CONSUMIDORDTNIFREP,t3.DTFEMOD CONSUMIDORDTFEMOD,t3.DTNOLO CONSUMIDORDTNOLO,t3.DTCOPV CONSUMIDORDTCOPV,t3.DTINRL CONSUMIDORDTINRL,t3.DTNODIRR CONSUMIDORDTNODIRR,t3.DTCOLOR CONSUMIDORDTCOLOR,t3.DTNRCOPOR CONSUMIDORDTNRCOPOR,t3.DTCOPVR CONSUMIDORDTCOPVR,t3.DTNRTELR CONSUMIDORDTNRTELR,t3.DTNRTEL2R CONSUMIDORDTNRTEL2R,t3.DTNRFAXR CONSUMIDORDTNRFAXR,t3.DTTEEMR CONSUMIDORDTTEEMR,t3.DTINTIPID CONSUMIDORDTINTIPID,t3.DTNORA_PAIS_ID CONSUMIDORDTNORAPAISID,t3.DTNORA_PAIS_NOMBRE CONSUMIDORDTNORAPAISNOMBRE,t3.DTNORA_PROVINCIA_ID CONSUMIDORDTNORAPROVINCIAID,t3.DTNOMBRE_PROVINCIA CONSUMIDORDTNOMBREPROVINCIA,t3.DTNORA_MUNICIPIO_ID CONSUMIDORDTNORAMUNICIPIOID,t3.DTNOMBRE_MUNICIPIO CONSUMIDORDTNOMBREMUNICIPIO,t3.DTNORA_LOCALIDAD_ID CONSUMIDORDTNORALOCALIDADID,t3.DTNOMBRE_LOCALIDAD CONSUMIDORDTNOMBRELOCALIDAD,t3.DTNORA_CALLE_ID CONSUMIDORDTNORACALLEID,t3.DTNOMBRE_CALLE CONSUMIDORDTNOMBRECALLE,t3.DTNORA_CP_ID CONSUMIDORDTNORACPID,t3.DTNOMBRE_CP CONSUMIDORDTNOMBRECP,t3.DTNORA_PORTAL_ID CONSUMIDORDTNORAPORTALID,t3.DTNOMBRE_PORTAL CONSUMIDORDTNOMBREPORTAL,t3.DTNOMBRE_PISO CONSUMIDORDTNOMBREPISO, t3.DTDIRECCION_NOCAPV ConsumidorDTDIRECCION_NOCAPV,t3.DTCOZS CONSUMIDORDTCOZS,t3.DTRANGO_EDAD CONSUMIDORDTRANGOEDAD "
						+ "FROM DENUNCIA t1 ,FORMA_PRESENTACION t2 ,CONSUMIDOR t3 ");

		if (denuncia != null && denuncia.getDecodigo() != null) {
			where.append(" AND UPPER(t1.DECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DECODIGO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpcodigo() != null) {
			where.append(" AND t2.TFPCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpcodigo() + "%");
			} else {
				params.add("%" + denuncia.getFormaPresentacion().getTfpcodigo()
						+ "%");
			}
			where.append(" AND t2.TFPCODIGO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombre() != null) {
			where.append(" AND UPPER(t2.TFPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getFormaPresentacion().getTfpnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TFPNOMBRE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombree() != null) {
			where.append(" AND UPPER(t2.TFPNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpnombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getFormaPresentacion().getTfpnombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TFPNOMBREE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrei() != null) {
			where.append(" AND UPPER(t2.TFPNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpnombrei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getFormaPresentacion().getTfpnombrei()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TFPNOMBREI IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombref() != null) {
			where.append(" AND UPPER(t2.TFPNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpnombref()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getFormaPresentacion().getTfpnombref()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TFPNOMBREF IS NOT NULL");
		}
		if (denuncia != null && denuncia.getFormaPresentacion() != null
				&& denuncia.getFormaPresentacion().getTfpnombrea() != null) {
			where.append(" AND UPPER(t2.TFPNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getFormaPresentacion().getTfpnombrea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getFormaPresentacion().getTfpnombrea()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TFPNOMBREA IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcodigo() != null) {
			where.append(" AND t3.DTCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcodigo() + "%");
			} else {
				params.add("%" + denuncia.getConsumidor().getDtcodigo() + "%");
			}
			where.append(" AND t3.DTCODIGO IS NOT NULL");
		}
		if (denuncia != null
				&& denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getCensoMonitor() != null
				&& denuncia.getConsumidor().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t3.DTCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.DTCOZS IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getRangoEdad() != null
				&& denuncia.getConsumidor().getRangoEdad().getRancod() != null) {
			where.append(" AND UPPER(t3.DTRANGO_EDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getRangoEdad().getRancod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getRangoEdad().getRancod()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTRANGO_EDAD IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombre() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNOMBRE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnif() != null) {
			where.append(" AND UPPER(t3.DTNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNIF IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodir() != null) {
			where.append(" AND UPPER(t3.DTNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnodir().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnodir().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNODIR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolo() != null) {
			where.append(" AND UPPER(t3.DTCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcolo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOLO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopo() != null) {
			where.append(" AND UPPER(t3.DTNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrcopo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrcopo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRCOPO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel() != null) {
			where.append(" AND UPPER(t3.DTNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrtel().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrtel().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRTEL IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfax() != null) {
			where.append(" AND UPPER(t3.DTNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrfax().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrfax().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRFAX IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopa() != null) {
			where.append(" AND UPPER(t3.DTCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcopa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOPA IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrdimu() != null) {
			where.append(" AND UPPER(t3.DTNRDIMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrdimu().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrdimu().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRDIMU IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDttecoem() != null) {
			where.append(" AND UPPER(t3.DTTECOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDttecoem().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDttecoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTTECOEM IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2() != null) {
			where.append(" AND UPPER(t3.DTNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrtel2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrtel2().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRTEL2 IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel3() != null) {
			where.append(" AND UPPER(t3.DTNRTEL3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrtel3().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrtel3().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRTEL3 IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoidco() != null) {
			where.append(" AND UPPER(t3.DTCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcoidco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcoidco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOIDCO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinreco() != null) {
			where.append(" AND UPPER(t3.DTINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtinreco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtinreco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTINRECO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcoorac() != null) {
			where.append(" AND UPPER(t3.DTCOORAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcoorac().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcoorac().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOORAC IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap1() != null) {
			where.append(" AND UPPER(t3.DTNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoap1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoap1().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNOAP1 IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoap2() != null) {
			where.append(" AND UPPER(t3.DTNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoap2().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoap2().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNOAP2 IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrsoci() != null) {
			where.append(" AND UPPER(t3.DTNRSOCI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrsoci().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrsoci().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRSOCI IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnran() != null) {
			where.append(" AND UPPER(t3.DTNRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnran().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnran().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRAN IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcosx() != null) {
			where.append(" AND UPPER(t3.DTCOSX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcosx().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcosx().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOSX IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnorep() != null) {
			where.append(" AND UPPER(t3.DTNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnorep().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnorep().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNOREP IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnifrep() != null) {
			where.append(" AND UPPER(t3.DTNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnifrep().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnifrep().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNIFREP IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtfemod() != null) {
			where.append(" AND UPPER(t3.DTFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtfemod().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtfemod().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTFEMOD IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnolo() != null) {
			where.append(" AND UPPER(t3.DTNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnolo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNOLO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopv() != null) {
			where.append(" AND UPPER(t3.DTCOPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcopv().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcopv().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOPV IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtinrl() != null) {
			where.append(" AND UPPER(t3.DTINRL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtinrl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtinrl().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTINRL IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnodirr() != null) {
			where.append(" AND UPPER(t3.DTNODIRR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnodirr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnodirr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNODIRR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcolor() != null) {
			where.append(" AND UPPER(t3.DTCOLOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcolor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcolor().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOLOR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrcopor() != null) {
			where.append(" AND UPPER(t3.DTNRCOPOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrcopor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrcopor().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRCOPOR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtcopvr() != null) {
			where.append(" AND UPPER(t3.DTCOPVR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtcopvr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtcopvr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTCOPVR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtelr() != null) {
			where.append(" AND UPPER(t3.DTNRTELR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrtelr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrtelr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRTELR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrtel2r() != null) {
			where.append(" AND UPPER(t3.DTNRTEL2R) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrtel2r()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrtel2r().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRTEL2R IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnrfaxr() != null) {
			where.append(" AND UPPER(t3.DTNRFAXR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnrfaxr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnrfaxr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTNRFAXR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtteemr() != null) {
			where.append(" AND UPPER(t3.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtteemr().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtteemr().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTTEEMR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtintipid() != null) {
			where.append(" AND UPPER(t3.DTINTIPID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtintipid()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtintipid().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.DTINTIPID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisId() != null) {
			where.append(" AND UPPER(t3.DTNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_PAIS_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPaisNombre() != null) {
			where.append(" AND UPPER(t3.DTNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraProvinciaId() != null) {
			where.append(" AND UPPER(t3.DTNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreProvincia() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraMunicipioId() != null) {
			where.append(" AND UPPER(t3.DTNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreMunicipio() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraLocalidadId() != null) {
			where.append(" AND UPPER(t3.DTNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreLocalidad() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCalleId() != null) {
			where.append(" AND UPPER(t3.DTNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_CALLE_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCalle() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_CALLE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraCpId() != null) {
			where.append(" AND UPPER(t3.DTNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_CP_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombreCp() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_CP IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnoraPortalId() != null) {
			where.append(" AND UPPER(t3.DTNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNORA_PORTAL_ID IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePortal() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_PORTAL IS NOT NULL");
		}
		if (denuncia != null && denuncia.getConsumidor() != null
				&& denuncia.getConsumidor().getDtnombrePiso() != null) {
			where.append(" AND UPPER(t3.DTNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getConsumidor().getDtnombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ denuncia.getConsumidor().getDtnombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DTNOMBRE_PISO IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDecocp() != null) {
			where.append(" AND UPPER(t1.DECOCP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDecocp().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDecocp().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOCP IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDecoor().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDecoor().toUpperCase() + "%");
			}
			where.append(" AND t1.DECOOR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDenran() != null) {
			where.append(" AND t1.DENRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDenran() + "%");
			} else {
				params.add("%" + denuncia.getDenran() + "%");
			}
			where.append(" AND t1.DENRAN IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDenror() != null) {
			where.append(" AND t1.DENROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDenror() + "%");
			} else {
				params.add("%" + denuncia.getDenror() + "%");
			}
			where.append(" AND t1.DENROR IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDefede() != null) {
			where.append(" AND t1.DEFEDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDefede() + "%");
			} else {
				params.add("%" + denuncia.getDefede() + "%");
			}
			where.append(" AND t1.DEFEDE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDefere() != null) {
			where.append(" AND t1.DEFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDefere() + "%");
			} else {
				params.add("%" + denuncia.getDefere() + "%");
			}
			where.append(" AND t1.DEFERE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDefeex() != null) {
			where.append(" AND t1.DEFEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDefeex() + "%");
			} else {
				params.add("%" + denuncia.getDefeex() + "%");
			}
			where.append(" AND t1.DEFEEX IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDefeim() != null) {
			where.append(" AND t1.DEFEIM like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDefeim() + "%");
			} else {
				params.add("%" + denuncia.getDefeim() + "%");
			}
			where.append(" AND t1.DEFEIM IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDeinre() != null) {
			where.append(" AND UPPER(t1.DEINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDeinre().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDeinre().toUpperCase() + "%");
			}
			where.append(" AND t1.DEINRE IS NOT NULL");
		}
		if (denuncia != null && denuncia.getDenrrgen() != null) {
			where.append(" AND UPPER(t1.DENRRGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(denuncia.getDenrrgen().toUpperCase() + "%");
			} else {
				params.add("%" + denuncia.getDenrrgen().toUpperCase() + "%");
			}
			where.append(" AND t1.DENRRGEN IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Denuncia>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
