package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.DecisionHechoDetalle;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.PlantillaTramiteDecisionDetalle;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.TipoReclamacion;

/**
 * * DecisionHechoDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class DecisionHechoDaoImpl implements DecisionHechoDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<DecisionHecho> rwMap = new RowMapper<DecisionHecho>() {
		public DecisionHecho mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DecisionHecho(
					resultSet.getString("HCCODIGO"),
					resultSet.getString("HCCOOR"),
					resultSet.getDate("HCFEDE"),
					resultSet.getDate("HCFECODE"),
					resultSet.getString("HCCOORPROP"),
					resultSet.getString("HCCOORTRASINHIBI"),
					new HechoDenunciado(
							resultSet.getString("HechoDenunciadoHDCODIGO"),
							resultSet.getLong("HechoDenunciadoHDNROR"),
							resultSet.getString("HechoDenunciadoHDTE"),
							resultSet.getString("HechoDenunciadoHDTEDOAD"),
							resultSet.getString("HechoDenunciadoHDCOAV"),
							resultSet.getString("HechoDenunciadoHDNOPS"),
							resultSet.getString("HechoDenunciadoHDNOMAPS"),
							resultSet.getString("HechoDenunciadoHDNOMOPS"),
							resultSet.getString("HechoDenunciadoHDNRLOPS"),
							resultSet.getDate("HechoDenunciadoHDFEDMPS"),
							resultSet.getString("HechoDenunciadoHDINSOTR"),
							resultSet.getString("HechoDenunciadoHDINSOMA"),
							resultSet.getBigDecimal("HechoDenunciadoHDCAPTSO"),
							resultSet.getString("HechoDenunciadoHDTESO"),
							resultSet.getDate("HechoDenunciadoHDFEARDT"),
							resultSet.getDate("HechoDenunciadoHDFEIOHD"),
							resultSet.getString("HechoDenunciadoHDINININ"),
							resultSet.getDate("HechoDenunciadoHDFEIOPC"),
							resultSet.getDate("HechoDenunciadoHDFEROPC"),
							resultSet.getString("HechoDenunciadoHDCOREPC"),
							resultSet.getDate("HechoDenunciadoHDFEIORP"),
							resultSet.getDate("HechoDenunciadoHDFERORP"),
							resultSet.getString("HechoDenunciadoHDCOREAP"),
							resultSet.getDate("HechoDenunciadoHDFEIORA"),
							resultSet.getString("HechoDenunciadoHDTEACPA"),
							resultSet.getDate("HechoDenunciadoHDFECEAC"),
							resultSet.getString("HechoDenunciadoHDHOCEAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOCA"),
							resultSet.getString("HechoDenunciadoHDTEACDE"),
							resultSet.getDate("HechoDenunciadoHDFEIOAC"),
							resultSet.getDate("HechoDenunciadoHDFEIOFC"),
							resultSet.getString("HechoDenunciadoHDCOTRA"),
							resultSet.getString("HechoDenunciadoHDTE02"),
							resultSet.getString("HechoDenunciadoHDTE03"),
							resultSet.getString("HechoDenunciadoHDTE04"),
							resultSet.getString("HechoDenunciadoHDTE05"),
							resultSet.getString("HechoDenunciadoHDTE06"),
							resultSet.getString("HechoDenunciadoHDTE07"),
							resultSet.getString("HechoDenunciadoHDTE08"),
							resultSet.getString("HechoDenunciadoHDTE09"),
							resultSet.getString("HechoDenunciadoHDTE10"),
							resultSet.getString("HechoDenunciadoHDCOSC"),
							resultSet.getString("HechoDenunciadoHDIDAL"),
							resultSet.getDate("HechoDenunciadoHDFEROAD"),
							resultSet.getDate("HechoDenunciadoHDFEROAT"),
							resultSet.getString("HechoDenunciadoHDTEALDT"),
							resultSet.getString("HechoDenunciadoHDTEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEDEAT"),
							resultSet.getDate("HechoDenunciadoHDFEHD"),
							resultSet.getString("HechoDenunciadoHDTEDOADE"),
							resultSet.getString("HechoDenunciadoHDTEDOADI"),
							resultSet.getString("HechoDenunciadoHDTEDOADF"),
							resultSet.getString("HechoDenunciadoHDTEDOADA"),
							resultSet.getString("HechoDenunciadoHDNOPSE"),
							resultSet.getString("HechoDenunciadoHDNOPSI"),
							resultSet.getString("HechoDenunciadoHDNOPSF"),
							resultSet.getString("HechoDenunciadoHDNOPSA"),
							resultSet.getString("HechoDenunciadoHDCOCODIGO"),
							resultSet
									.getString("HechoDenunciadoHDCODEXPEDIENTEORIGEN"),
							new Denuncia(resultSet
									.getString("HechoDenunciadoHDCODE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new Establecimiento(resultSet
									.getString("HechoDenunciadoHDCOES"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null), new Sector(resultSet
									.getString("HechoDenunciadoHDCOSE"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("HechoDenunciadoHDCOMO"), null,
									null, null, null, null, null, null, null,
									null, null, null), new Producto(resultSet
									.getString("HechoDenunciadoHDCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipoReclamacion(resultSet
									.getString("HechoDenunciadoHDCOTSR"), null,
									null, null, null, null, null),
							new Motivo(resultSet
									.getString("HechoDenunciadoHDCOTIR"), null,
									null, null), null), new Decision(
							resultSet.getString("DecisionDECODIGO"),
							resultSet.getString("DecisionDENOMBRE"),
							resultSet.getString("DecisionDENOMBREE"),
							resultSet.getDate("DecisionDEBAJA")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho add(DecisionHecho decisionhecho) {

		String query = "INSERT INTO DECISION_HECHO( HCCODIGO,HCCOHD,HCCOTTD,HCCOOR,HCFEDE,HCFECODE,HCCOORPROP)"
				+ "VALUES (?,?,?,?,?,?,?)";

		Object getHechoDenunciadoHdcodigoAux = null;
		if (decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = decisionhecho.getHechoDenunciado()
					.getHdcodigo();
		}
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, decisionhecho.getHccodigo(),
				getHechoDenunciadoHdcodigoAux, getDecisionDecodigoAux,
				decisionhecho.getHccoor(), decisionhecho.getHcfede(),
				decisionhecho.getHcfecode(), decisionhecho.getHccoorprop());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho update(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOHD=?,HCCOTTD=?,HCCOOR=?,HCFEDE=?,HCFECODE=?,HCCOORPROP=? WHERE HCCODIGO=?";
		Object getHechoDenunciadoHdcodigoAux = null;
		if (decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			getHechoDenunciadoHdcodigoAux = decisionhecho.getHechoDenunciado()
					.getHdcodigo();
		}
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, getHechoDenunciadoHdcodigoAux,
				getDecisionDecodigoAux, decisionhecho.getHccoor(),
				decisionhecho.getHcfede(), decisionhecho.getHcfecode(),
				decisionhecho.getHccoorprop(), decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho updateDecision(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOTTD=?, HCFEDE=? WHERE HCCODIGO=?";
		Object getDecisionDecodigoAux = null;
		if (decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			getDecisionDecodigoAux = decisionhecho.getDecision().getDecodigo();
		}
		this.jdbcTemplate.update(query, getDecisionDecodigoAux,
				decisionhecho.getHcfede(), decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Actualiza los datos referentes al organismo destino al decidir un
	 * traslado/inhibición
	 * 
	 * @param decisionhecho
	 *            DecisionHecho objeto con las propiedades hccodigo y
	 *            hccoortransinhibi informados
	 * @return DecisionHecho datos actualizados
	 */
	public DecisionHecho updateOrganismoTrasladoInhibicion(
			DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOORTRASINHIBI=? WHERE HCCODIGO=?";
		this.jdbcTemplate.update(query, decisionhecho.getHccoortrasinhibi(),
				decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	public DecisionHecho updateOrganismoTraslado(DecisionHecho decisionhecho) {
		String query = "UPDATE DECISION_HECHO SET HCCOOR=? WHERE HCCODIGO=?";
		this.jdbcTemplate.update(query, decisionhecho.getHccoor(),
				decisionhecho.getHccodigo());
		return decisionhecho;
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	@Transactional(readOnly = true)
	public DecisionHecho find(DecisionHecho decisionhecho) {
		String query = "SELECT t1.HCCODIGO HCCODIGO, t1.HCCOOR HCCOOR, t1.HCFEDE HCFEDE, t1.HCFECODE HCFECODE, t1.HCCOORPROP HCCOORPROP, t1.HCCOORTRASINHIBI HCCOORTRASINHIBI, t2.HDCODIGO HECHODENUNCIADOHDCODIGO, t2.HDNROR HECHODENUNCIADOHDNROR, t2.HDTE HECHODENUNCIADOHDTE, t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD, t2.HDCOAV HECHODENUNCIADOHDCOAV, t2.HDNOPS HECHODENUNCIADOHDNOPS, t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS, t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS, t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS, t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS, t2.HDINSOTR HECHODENUNCIADOHDINSOTR, t2.HDINSOMA HECHODENUNCIADOHDINSOMA, t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO, t2.HDTESO HECHODENUNCIADOHDTESO, t2.HDFEARDT HECHODENUNCIADOHDFEARDT, t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD, t2.HDINININ HECHODENUNCIADOHDINININ, t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC, t2.HDFEROPC HECHODENUNCIADOHDFEROPC, t2.HDCOREPC HECHODENUNCIADOHDCOREPC, t2.HDFEIORP HECHODENUNCIADOHDFEIORP, t2.HDFERORP HECHODENUNCIADOHDFERORP, t2.HDCOREAP HECHODENUNCIADOHDCOREAP, t2.HDFEIORA HECHODENUNCIADOHDFEIORA, t2.HDTEACPA HECHODENUNCIADOHDTEACPA, t2.HDFECEAC HECHODENUNCIADOHDFECEAC, t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC, t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA, t2.HDTEACDE HECHODENUNCIADOHDTEACDE, t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC, t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC, t2.HDCOTRA HECHODENUNCIADOHDCOTRA, t2.HDTE02 HECHODENUNCIADOHDTE02, t2.HDTE03 HECHODENUNCIADOHDTE03, t2.HDTE04 HECHODENUNCIADOHDTE04, t2.HDTE05 HECHODENUNCIADOHDTE05, t2.HDTE06 HECHODENUNCIADOHDTE06, t2.HDTE07 HECHODENUNCIADOHDTE07, t2.HDTE08 HECHODENUNCIADOHDTE08, t2.HDTE09 HECHODENUNCIADOHDTE09, t2.HDTE10 HECHODENUNCIADOHDTE10, t2.HDCOSC HECHODENUNCIADOHDCOSC, t2.HDIDAL HECHODENUNCIADOHDIDAL, t2.HDFEROAD HECHODENUNCIADOHDFEROAD, t2.HDFEROAT HECHODENUNCIADOHDFEROAT, t2.HDTEALDT HECHODENUNCIADOHDTEALDT, t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT, t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT, t2.HDFEHD HECHODENUNCIADOHDFEHD, t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE, t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI, t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF, t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA, t2.HDNOPSE HECHODENUNCIADOHDNOPSE, t2.HDNOPSI HECHODENUNCIADOHDNOPSI, t2.HDNOPSF HECHODENUNCIADOHDNOPSF, t2.HDNOPSA HECHODENUNCIADOHDNOPSA, t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO, t3.DECODIGO DECISIONDECODIGO, t3.DENOMBRE DECISIONDENOMBRE, t3.DENOMBREE DECISIONDENOMBREE, t3.DEBAJA DECISIONDEBAJA, t2.HDCODE HECHODENUNCIADOHDCODE, t2.HDCOES HECHODENUNCIADOHDCOES, t2.HDCOSE HECHODENUNCIADOHDCOSE, t2.HDCOMO HECHODENUNCIADOHDCOMO, t2.HDCOPS HECHODENUNCIADOHDCOPS, t2.HDCOTSR HECHODENUNCIADOHDCOTSR, t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
				+ "FROM DECISION_HECHO t1 , HECHO_DENUNCIADO t2 , DECISION t3  "
				+ "WHERE t1.HCCODIGO = ?   AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+)  ";
		return (DecisionHecho) this.jdbcTemplate.queryForObject(query, rwMap,
				decisionhecho.getHccodigo());
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	@Transactional(readOnly = true)
	public DecisionHechoDetalle findDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle) {
		StringBuilder query = new StringBuilder(
				"SELECT t1.HCCODIGO HCCODIGO, t1.HCCOOR HCCOOR, t1.HCFEDE HCFEDE, t1.HCFECODE HCFECODE, ");
		query.append("t1.HCCOORPROP HCCOORPROP, t1.HCCOORTRASINHIBI HCCOORTRASINHIBI, t2.HDCODIGO HDCODIGO, t3.DECODIGO DECODIGO, ");
		query.append("t3.DENOMBRE DENOMBRE, t3.DENOMBREE DENOMBREE, t3.DEBAJA DEBAJA, t4.NOMBRE_ES ORG_NOMBRE_ES, t4.NOMBRE_EU ORG_NOMBRE_EU ");
		query.append("FROM DECISION_HECHO t1, HECHO_DENUNCIADO t2, DECISION t3, ORGANISMO t4 ");
		query.append("WHERE t1.HCCOHD = ? AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+) ");
		query.append("AND t1.HCCOORTRASINHIBI= t4.COD_ORG(+) ");
		return (DecisionHechoDetalle) this.jdbcTemplate.queryForObject(
				query.toString(), new RowMapper<DecisionHechoDetalle>() {
					public DecisionHechoDetalle mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new DecisionHechoDetalle(resultSet
								.getString("HCCODIGO"), resultSet
								.getString("HCCOOR"), resultSet
								.getDate("HCFEDE"), resultSet
								.getDate("HCFECODE"), resultSet
								.getString("HCCOORPROP"), resultSet
								.getString("HCCOORTRASINHIBI"), resultSet
								.getString("ORG_NOMBRE_ES"), resultSet
								.getString("ORG_NOMBRE_EU"), resultSet
								.getString("HDCODIGO"), resultSet
								.getString("DECODIGO"), resultSet
								.getString("DENOMBRE"), resultSet
								.getString("DENOMBREE"), resultSet
								.getDate("DEBAJA"), null, null, null, null,
								null, null, null, null, null, null, null);
					}
				}, decisionHechoDetalle.getHdcodigo());
	}

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaTramiteDecisionDetalle findPlantillaTramiteDecision(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle) {

		String query = "SELECT * FROM(SELECT t1.DECODIGO DECODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t2.HDCODIGO HDCODIGO, t2.HDNROR HDNROR,t2.HDCAPTSO HDCAPTSO, t3.ESCODIGO ESCODIGO, t3.ESNOMBRE ESNOMBRE, t3.ESNIF ESNIF, t3.ESNOCO ESNOCO, t3.ESINADAR ESINADAR, t3.ESNORA_PROVINCIA_ID ESNORAPROVINCIAID, t3.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIA, t3.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOID, t3.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIO, t3.ESNORA_LOCALIDAD_ID ESNORALOCALIDADID, t3.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDAD, t3.ESNORA_CALLE_ID ESNORACALLEID, t3.ESNOMBRE_CALLE ESNOMBRECALLE, t3.ESNORA_CP_ID ESNORACPID, t3.ESNOMBRE_CP ESNOMBRECP, t3.ESNORA_PORTAL_ID ESNORAPORTALID, t3.ESNOMBRE_PORTAL ESNOMBREPORTAL, t3.ESNOMBRE_PISO ESNOMBREPISO, t3.ESNOLO ESNOLO, t3.ESNODIR ESNODIR, t3.ESNRCOPO ESNRCOPO, t3.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPV, t3.ESEXTRANJERO ESEXTRANJERO, T3.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBRE,T3.ESCOEM ESCOEM,T3.ESNRTEL ESNRTEL, t4.DTCODIGO DTCODIGO, (RTRIM(t4.DTNOMBRE) || ' ' || RTRIM(t4.DTAPELLIDO1) || ' ' || RTRIM(t4.DTAPELLIDO2)) as DTNOMBRE, t4.DTNIF DTNIF, t4.DTNORA_PROVINCIA_ID DTNORAPROVINCIAID, t4.DTNOMBRE_PROVINCIA DTNOMBREPROVINCIA, t4.DTNORA_MUNICIPIO_ID DTNORAMUNICIPIOID, t4.DTNOMBRE_MUNICIPIO DTNOMBREMUNICIPIO, t4.DTNORA_LOCALIDAD_ID DTNORALOCALIDADID, t4.DTNOMBRE_LOCALIDAD DTNOMBRELOCALIDAD, t4.DTNORA_CALLE_ID DTNORACALLEID, t4.DTNOMBRE_CALLE DTNOMBRECALLE, t4.DTNORA_CP_ID DTNORACPID, t4.DTNOMBRE_CP DTNOMBRECP, t4.DTNORA_PORTAL_ID DTNORAPORTALID, t4.DTNOMBRE_PORTAL DTNOMBREPORTAL, t4.DTNOMBRE_PISO DTNOMBREPISO, t4.DTNOLO DTNOLO, t4.DTNODIR DTNODIR, t4.DTNRCOPO DTNRCOPO, t4.DTDIRECCION_NOCAPV DTDIRECCION_NOCAPV, T4.DTEXTRANJERO DTEXTRANJERO, T4.DTNORA_PAIS_NOMBRE DTNORAPAISNOMBRE,T4.DTTECOEM DTTECOEM,T4.DTNRTEL DTNRTEL,t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU,  t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL,t6.EMAIL EMAIL, t6.TELEFONO TELEFONO, t5.HCCODIGO HCCODIGO, t5.HCFEDE HCFEDE, t8.COD_ORG CODORGTRASPASO, t8.NOMBRE_ES NOMBREESTRASPASO, t8.NOMBRE_EU NOMBREEUTRASPASO,  t8.NORA_PROVINCIA_ID NORAPROVINCIAIDTRASPASO, t8.NOMBRE_PROVINCIA NOMBREPROVINCIATRASPASO, t8.NORA_MUNICIPIO_ID NORAMUNICIPIOIDTRASPASO, t8.NOMBRE_MUNICIPIO NOMBREMUNICIPIOTRASPASO, t8.NORA_LOCALIDAD_ID NORALOCALIDADIDTRASPASO, t8.NOMBRE_LOCALIDAD NOMBRELOCALIDADTRASPASO, t8.NORA_CALLE_ID NORACALLEIDTRASPASO, t8.NOMBRE_CALLE NOMBRECALLETRASPASO, t8.NORA_CP_ID NORACPIDTRASPASO, t8.NOMBRE_CP NOMBRECPTRASPASO, t8.NORA_PORTAL_ID NORAPORTALIDTRASPASO, t8.NOMBRE_PORTAL NOMBREPORTALTRASPASO,t8.EMAIL EMAILTRASPASO, t8.TELEFONO TELEFONOTRASPASO "
				+ "FROM DENUNCIA t1 ,HECHO_DENUNCIADO t2,ESTABLECIMIENTO t3, CONSUMIDOR t4, DECISION_HECHO t5, ORGANISMO t6,TRAMITE_HECHO t7, ORGANISMO t8 "
				+ "WHERE 1=1 AND t1.DECODIGO= t2.HDCODE(+)  AND t2.HDCOES= t3.ESCODIGO(+) AND t1.DECODT= t4.DTCODIGO(+) AND t2.HDCODIGO = t5.HCCOHD(+) AND t5.HCCOOR= t6.COD_ORG(+) AND t2.HDCODIGO = t7.EHCOHD(+) AND t5.HCCOORTRASINHIBI = t8.COD_ORG(+) AND t5.HCCODIGO = ? "
				+ "ORDER BY EHFECHA DESC, EHHORA DESC) WHERE ROWNUM=1 ";

		return (PlantillaTramiteDecisionDetalle) this.jdbcTemplate
				.queryForObject(query,
						new RowMapper<PlantillaTramiteDecisionDetalle>() {
							public PlantillaTramiteDecisionDetalle mapRow(
									ResultSet resultSet, int rowNum)
									throws SQLException {

								return new PlantillaTramiteDecisionDetalle(
										resultSet.getString("DECODIGO"),
										resultSet.getString("DECOOR"),
										resultSet.getBigDecimal("DENRAN"),
										resultSet.getBigDecimal("DENROR"),
										resultSet.getString("HDCODIGO"),
										resultSet.getBigDecimal("HDNROR"),
										resultSet.getBigDecimal("HDCAPTSO"),
										resultSet.getString("DTCODIGO"),
										resultSet.getString("DTNOMBRE"),
										resultSet.getString("DTNIF"),
										resultSet
												.getString("DTNORAPROVINCIAID"),
										resultSet
												.getString("DTNOMBREPROVINCIA"),
										resultSet
												.getString("DTNORAMUNICIPIOID"),
										resultSet
												.getString("DTNOMBREMUNICIPIO"),
										resultSet
												.getString("DTNORALOCALIDADID"),
										resultSet
												.getString("DTNOMBRELOCALIDAD"),
										resultSet.getString("DTNORACALLEID"),
										resultSet.getString("DTNOMBRECALLE"),
										resultSet.getString("DTNORACPID"),
										resultSet.getString("DTNOMBRECP"),
										resultSet.getString("DTNORAPORTALID"),
										resultSet.getString("DTNOMBREPORTAL"),
										resultSet.getString("DTNOMBREPISO"),
										resultSet.getString("DTNOLO"),
										resultSet.getString("DTNODIR"),
										resultSet.getString("DTNRCOPO"),
										resultSet
												.getString("DTDIRECCION_NOCAPV"),
										resultSet.getString("DTEXTRANJERO"),
										resultSet.getString("DTNORAPAISNOMBRE"),
										resultSet.getString("DTTECOEM"),
										resultSet.getString("DTNRTEL"),
										resultSet.getString("ESCODIGO"),
										resultSet.getString("ESNOMBRE"),
										resultSet.getString("ESNIF"),
										resultSet.getString("ESNOCO"),
										resultSet.getString("ESINADAR"),
										resultSet
												.getString("ESNORAPROVINCIAID"),
										resultSet
												.getString("ESNOMBREPROVINCIA"),
										resultSet
												.getString("ESNORAMUNICIPIOID"),
										resultSet
												.getString("ESNOMBREMUNICIPIO"),
										resultSet
												.getString("ESNORALOCALIDADID"),
										resultSet
												.getString("ESNOMBRELOCALIDAD"),
										resultSet.getString("ESNORACALLEID"),
										resultSet.getString("ESNOMBRECALLE"),
										resultSet.getString("ESNORACPID"),
										resultSet.getString("ESNOMBRECP"),
										resultSet.getString("ESNORAPORTALID"),
										resultSet.getString("ESNOMBREPORTAL"),
										resultSet.getString("ESNOMBREPISO"),
										resultSet.getString("ESNOLO"),
										resultSet.getString("ESNODIR"),
										resultSet.getString("ESNRCOPO"),
										resultSet
												.getString("ESDIRECCION_NOCAPV"),
										resultSet.getString("ESEXTRANJERO"),
										resultSet.getString("ESNORAPAISNOMBRE"),
										resultSet.getString("ESCOEM"),
										resultSet.getString("ESNRTEL"),
										resultSet.getString("CODORG"),
										resultSet.getString("NOMBREES"),
										resultSet.getString("NOMBREEU"),
										resultSet.getString("NORAPROVINCIAID"),
										resultSet.getString("NOMBREPROVINCIA"),
										resultSet.getString("NORAMUNICIPIOID"),
										resultSet.getString("NOMBREMUNICIPIO"),
										resultSet.getString("NORALOCALIDADID"),
										resultSet.getString("NOMBRELOCALIDAD"),
										resultSet.getString("NORACALLEID"),
										resultSet.getString("NOMBRECALLE"),
										resultSet.getString("NORACPID"),
										resultSet.getString("NOMBRECP"),
										resultSet.getString("NORAPORTALID"),
										resultSet.getString("NOMBREPORTAL"),
										resultSet.getString("EMAIL"),
										resultSet.getString("TELEFONO"),
										resultSet.getString("HCCODIGO"),
										resultSet.getDate("HCFEDE"),
										resultSet.getString("CODORGTRASPASO"),
										resultSet.getString("NOMBREESTRASPASO"),
										resultSet.getString("NOMBREEUTRASPASO"),
										resultSet
												.getString("NORAPROVINCIAIDTRASPASO"),
										resultSet
												.getString("NOMBREPROVINCIATRASPASO"),
										resultSet
												.getString("NORAMUNICIPIOIDTRASPASO"),
										resultSet
												.getString("NOMBREMUNICIPIOTRASPASO"),
										resultSet
												.getString("NORALOCALIDADIDTRASPASO"),
										resultSet
												.getString("NOMBRELOCALIDADTRASPASO"),
										resultSet
												.getString("NORACALLEIDTRASPASO"),
										resultSet
												.getString("NOMBRECALLETRASPASO"),
										resultSet.getString("NORACPIDTRASPASO"),
										resultSet.getString("NOMBRECPTRASPASO"),
										resultSet
												.getString("NORAPORTALIDTRASPASO"),
										resultSet
												.getString("NOMBREPORTALTRASPASO"),
										resultSet.getString("EMAILTRASPASO"),
										resultSet.getString("TELEFONOTRASPASO"));
							}
						}, plantillaTramiteDecisionDetalle.getHccodigo());
	}

	/**
	 * Removes a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	public void remove(DecisionHecho decisionhecho) {
		String query = "DELETE  FROM DECISION_HECHO WHERE HCCODIGO=?";
		this.jdbcTemplate.update(query, decisionhecho.getHccodigo());
	}

	/**
	 * Removes all decision of the Solicitud.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	public void removeDecisionSolicitud(DecisionHecho decisionhecho) {
		String query = "DELETE  FROM DECISION_HECHO WHERE HCCOHD=?";
		this.jdbcTemplate.update(query, decisionhecho.getHechoDenunciado()
				.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DecisionHecho> findAll(DecisionHecho decisionhecho,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.HCCODIGO HCCODIGO,t1.HCCOOR HCCOOR,t1.HCFEDE HCFEDE,t1.HCFECODE HCFECODE,t1.HCCOORPROP HCCOORPROP,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.DECODIGO DECISIONDECODIGO,t3.DENOMBRE DECISIONDENOMBRE,t3.DENOMBREE DECISIONDENOMBREE,t3.DEBAJA DECISIONDEBAJA,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DECISION_HECHO t1 ,HECHO_DENUNCIADO t2 ,DECISION t3 ");

		if (decisionhecho != null && decisionhecho.getHccodigo() != null) {
			where.append(" AND t1.HCCODIGO = ?");
			params.add(decisionhecho.getHccodigo());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(decisionhecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(decisionhecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getSector() != null
				&& decisionhecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(decisionhecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(decisionhecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getProducto() != null
				&& decisionhecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(decisionhecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getMotivo() != null
				&& decisionhecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(decisionhecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnror());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoad());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcoav());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnomaps());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnomops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnrlops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfedmps());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdinsotr());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdinsoma());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcaptso());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteso());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeardt());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiohd());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdininin());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiopc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferopc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcorepc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiorp());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferorp());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcoreap());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiora());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteacpa());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeceac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdhoceac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeioca());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteacde());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeioac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiofc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcotra());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte02());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte03());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte04());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte05());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte06());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte07());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte08());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte09());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte10());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcosc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdidal());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferoad());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferoat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtealdt());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedeat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfedeat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfehd());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoade());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoadi());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoadf());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoada());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopse());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsi());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsf());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsa());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcocodigo());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			where.append(" AND t3.DECODIGO = ?");
			params.add(decisionhecho.getDecision().getDecodigo());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombre() != null) {
			where.append(" AND t3.DENOMBRE = ?");
			params.add(decisionhecho.getDecision().getDenombre());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombree() != null) {
			where.append(" AND t3.DENOMBREE = ?");
			params.add(decisionhecho.getDecision().getDenombree());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDebaja() != null) {
			where.append(" AND t3.DEBAJA = ?");
			params.add(decisionhecho.getDecision().getDebaja());
		}
		if (decisionhecho != null && decisionhecho.getHccoor() != null) {
			where.append(" AND t1.HCCOOR = ?");
			params.add(decisionhecho.getHccoor());
		}
		if (decisionhecho != null && decisionhecho.getHcfede() != null) {
			where.append(" AND t1.HCFEDE = ?");
			params.add(decisionhecho.getHcfede());
		}
		if (decisionhecho != null && decisionhecho.getHcfecode() != null) {
			where.append(" AND t1.HCFECODE = ?");
			params.add(decisionhecho.getHcfecode());
		}
		if (decisionhecho != null && decisionhecho.getHccoorprop() != null) {
			where.append(" AND t1.HCCOORPROP = ?");
			params.add(decisionhecho.getHccoorprop());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DecisionHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DecisionHecho decisionhecho) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.HCCOHD= t2.HDCODIGO(+) and t1.HCCOTTD= t3.DECODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DECISION_HECHO t1   ,  HECHO_DENUNCIADO t2   ,  DECISION t3  ");
		if (decisionhecho != null && decisionhecho.getHccodigo() != null) {
			where.append(" AND t1.HCCODIGO = ?");
			params.add(decisionhecho.getHccodigo());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND t2.HDCODE = ?");
			params.add(decisionhecho.getHechoDenunciado().getDenuncia()
					.getDecodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.HDCOES = ?");
			params.add(decisionhecho.getHechoDenunciado().getEstablecimiento()
					.getEscodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getSector() != null
				&& decisionhecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND t2.HDCOSE = ?");
			params.add(decisionhecho.getHechoDenunciado().getSector()
					.getSecodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t2.HDCOMO = ?");
			params.add(decisionhecho.getHechoDenunciado().getCensoMonitor()
					.getMocodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getProducto() != null
				&& decisionhecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND t2.HDCOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getProducto()
					.getPscodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND t2.HDCOTSR = ?");
			params.add(decisionhecho.getHechoDenunciado().getTipoReclamacion()
					.getTsrcodigo());
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getMotivo() != null
				&& decisionhecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND t2.HDCOTIR = ?");
			params.add(decisionhecho.getHechoDenunciado().getMotivo()
					.getTircodigo());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnror());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND t2.HDTE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND t2.HDTEDOAD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoad());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND t2.HDCOAV = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcoav());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND t2.HDNOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND t2.HDNOMAPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnomaps());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND t2.HDNOMOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnomops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND t2.HDNRLOPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnrlops());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfedmps());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND t2.HDINSOTR = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdinsotr());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND t2.HDINSOMA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdinsoma());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcaptso());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND t2.HDTESO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteso());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeardt());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiohd());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND t2.HDINININ = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdininin());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiopc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferopc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND t2.HDCOREPC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcorepc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiorp());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferorp());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND t2.HDCOREAP = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcoreap());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiora());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND t2.HDTEACPA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteacpa());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeceac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND t2.HDHOCEAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdhoceac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeioca());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND t2.HDTEACDE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdteacde());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeioac());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfeiofc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND t2.HDCOTRA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcotra());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND t2.HDTE02 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte02());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND t2.HDTE03 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte03());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND t2.HDTE04 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte04());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND t2.HDTE05 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte05());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND t2.HDTE06 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte06());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND t2.HDTE07 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte07());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND t2.HDTE08 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte08());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND t2.HDTE09 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte09());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND t2.HDTE10 = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdte10());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND t2.HDCOSC = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcosc());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND t2.HDIDAL = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdidal());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferoad());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdferoat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND t2.HDTEALDT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtealdt());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND t2.HDTEDEAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedeat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfedeat());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdfehd());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND t2.HDTEDOADE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoade());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND t2.HDTEDOADI = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoadi());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND t2.HDTEDOADF = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoadf());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND t2.HDTEDOADA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdtedoada());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND t2.HDNOPSE = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopse());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND t2.HDNOPSI = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsi());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND t2.HDNOPSF = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsf());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND t2.HDNOPSA = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdnopsa());
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND t2.HDCOCODIGO = ?");
			params.add(decisionhecho.getHechoDenunciado().getHdcocodigo());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			where.append(" AND t3.DECODIGO = ?");
			params.add(decisionhecho.getDecision().getDecodigo());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombre() != null) {
			where.append(" AND t3.DENOMBRE = ?");
			params.add(decisionhecho.getDecision().getDenombre());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombree() != null) {
			where.append(" AND t3.DENOMBREE = ?");
			params.add(decisionhecho.getDecision().getDenombree());
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDebaja() != null) {
			where.append(" AND t3.DEBAJA = ?");
			params.add(decisionhecho.getDecision().getDebaja());
		}
		if (decisionhecho != null && decisionhecho.getHccoor() != null) {
			where.append(" AND t1.HCCOOR = ?");
			params.add(decisionhecho.getHccoor());
		}
		if (decisionhecho != null && decisionhecho.getHcfede() != null) {
			where.append(" AND t1.HCFEDE = ?");
			params.add(decisionhecho.getHcfede());
		}
		if (decisionhecho != null && decisionhecho.getHcfecode() != null) {
			where.append(" AND t1.HCFECODE = ?");
			params.add(decisionhecho.getHcfecode());
		}
		if (decisionhecho != null && decisionhecho.getHccoorprop() != null) {
			where.append(" AND t1.HCCOORPROP = ?");
			params.add(decisionhecho.getHccoorprop());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the DecisionHecho table using like.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<DecisionHecho> findAllLike(DecisionHecho decisionhecho,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.HCCOHD= t2.HDCODIGO(+) AND t1.HCCOTTD= t3.DECODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.HCCODIGO HCCODIGO,t1.HCCOOR HCCOOR,t1.HCFEDE HCFEDE,t1.HCFECODE HCFECODE,t1.HCCOORPROP HCCOORPROP,t2.HDCODIGO HECHODENUNCIADOHDCODIGO,t2.HDNROR HECHODENUNCIADOHDNROR,t2.HDTE HECHODENUNCIADOHDTE,t2.HDTEDOAD HECHODENUNCIADOHDTEDOAD,t2.HDCOAV HECHODENUNCIADOHDCOAV,t2.HDNOPS HECHODENUNCIADOHDNOPS,t2.HDNOMAPS HECHODENUNCIADOHDNOMAPS,t2.HDNOMOPS HECHODENUNCIADOHDNOMOPS,t2.HDNRLOPS HECHODENUNCIADOHDNRLOPS,t2.HDFEDMPS HECHODENUNCIADOHDFEDMPS,t2.HDINSOTR HECHODENUNCIADOHDINSOTR,t2.HDINSOMA HECHODENUNCIADOHDINSOMA,t2.HDCAPTSO HECHODENUNCIADOHDCAPTSO,t2.HDTESO HECHODENUNCIADOHDTESO,t2.HDFEARDT HECHODENUNCIADOHDFEARDT,t2.HDFEIOHD HECHODENUNCIADOHDFEIOHD,t2.HDINININ HECHODENUNCIADOHDINININ,t2.HDFEIOPC HECHODENUNCIADOHDFEIOPC,t2.HDFEROPC HECHODENUNCIADOHDFEROPC,t2.HDCOREPC HECHODENUNCIADOHDCOREPC,t2.HDFEIORP HECHODENUNCIADOHDFEIORP,t2.HDFERORP HECHODENUNCIADOHDFERORP,t2.HDCOREAP HECHODENUNCIADOHDCOREAP,t2.HDFEIORA HECHODENUNCIADOHDFEIORA,t2.HDTEACPA HECHODENUNCIADOHDTEACPA,t2.HDFECEAC HECHODENUNCIADOHDFECEAC,t2.HDHOCEAC HECHODENUNCIADOHDHOCEAC,t2.HDFEIOCA HECHODENUNCIADOHDFEIOCA,t2.HDTEACDE HECHODENUNCIADOHDTEACDE,t2.HDFEIOAC HECHODENUNCIADOHDFEIOAC,t2.HDFEIOFC HECHODENUNCIADOHDFEIOFC,t2.HDCOTRA HECHODENUNCIADOHDCOTRA,t2.HDTE02 HECHODENUNCIADOHDTE02,t2.HDTE03 HECHODENUNCIADOHDTE03,t2.HDTE04 HECHODENUNCIADOHDTE04,t2.HDTE05 HECHODENUNCIADOHDTE05,t2.HDTE06 HECHODENUNCIADOHDTE06,t2.HDTE07 HECHODENUNCIADOHDTE07,t2.HDTE08 HECHODENUNCIADOHDTE08,t2.HDTE09 HECHODENUNCIADOHDTE09,t2.HDTE10 HECHODENUNCIADOHDTE10,t2.HDCOSC HECHODENUNCIADOHDCOSC,t2.HDIDAL HECHODENUNCIADOHDIDAL,t2.HDFEROAD HECHODENUNCIADOHDFEROAD,t2.HDFEROAT HECHODENUNCIADOHDFEROAT,t2.HDTEALDT HECHODENUNCIADOHDTEALDT,t2.HDTEDEAT HECHODENUNCIADOHDTEDEAT,t2.HDFEDEAT HECHODENUNCIADOHDFEDEAT,t2.HDFEHD HECHODENUNCIADOHDFEHD,t2.HDTEDOADE HECHODENUNCIADOHDTEDOADE,t2.HDTEDOADI HECHODENUNCIADOHDTEDOADI,t2.HDTEDOADF HECHODENUNCIADOHDTEDOADF,t2.HDTEDOADA HECHODENUNCIADOHDTEDOADA,t2.HDNOPSE HECHODENUNCIADOHDNOPSE,t2.HDNOPSI HECHODENUNCIADOHDNOPSI,t2.HDNOPSF HECHODENUNCIADOHDNOPSF,t2.HDNOPSA HECHODENUNCIADOHDNOPSA,t2.HDCOCODIGO HECHODENUNCIADOHDCOCODIGO,t3.DECODIGO DECISIONDECODIGO,t3.DENOMBRE DECISIONDENOMBRE,t3.DENOMBREE DECISIONDENOMBREE,t3.DEBAJA DECISIONDEBAJA,t2.HDCODE HECHODENUNCIADOHDCODE,t2.HDCOES HECHODENUNCIADOHDCOES,t2.HDCOSE HECHODENUNCIADOHDCOSE,t2.HDCOMO HECHODENUNCIADOHDCOMO,t2.HDCOPS HECHODENUNCIADOHDCOPS,t2.HDCOTSR HECHODENUNCIADOHDCOTSR,t2.HDCOTIR HECHODENUNCIADOHDCOTIR "
						+ "FROM DECISION_HECHO t1 ,HECHO_DENUNCIADO t2 ,DECISION t3 ");

		if (decisionhecho != null && decisionhecho.getHccodigo() != null) {
			where.append(" AND UPPER(t1.HCCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHccodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decisionhecho.getHccodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HCCODIGO IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcodigo() != null) {
			where.append(" AND t2.HDCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcodigo()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcodigo()
						+ "%");
			}
			where.append(" AND t2.HDCODIGO IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia() != null
				&& decisionhecho.getHechoDenunciado().getDenuncia()
						.getDecodigo() != null) {
			where.append(" AND UPPER(t2.HDCODE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getDenuncia()
						.getDecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getDenuncia()
								.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCODE IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento() != null
				&& decisionhecho.getHechoDenunciado().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado()
						.getEstablecimiento().getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado()
								.getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOES IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getSector() != null
				&& decisionhecho.getHechoDenunciado().getSector().getSecodigo() != null) {
			where.append(" AND UPPER(t2.HDCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getSector()
						.getSecodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getSector()
								.getSecodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSE IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor() != null
				&& decisionhecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOMO IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getProducto() != null
				&& decisionhecho.getHechoDenunciado().getProducto()
						.getPscodigo() != null) {
			where.append(" AND UPPER(t2.HDCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOPS IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion() != null
				&& decisionhecho.getHechoDenunciado().getTipoReclamacion()
						.getTsrcodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTSR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado()
						.getTipoReclamacion().getTsrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado()
								.getTipoReclamacion().getTsrcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTSR IS NOT NULL");
		}
		if (decisionhecho != null
				&& decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getMotivo() != null
				&& decisionhecho.getHechoDenunciado().getMotivo()
						.getTircodigo() != null) {
			where.append(" AND UPPER(t2.HDCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getMotivo()
						.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getMotivo()
								.getTircodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTIR IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnror() != null) {
			where.append(" AND t2.HDNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnror() + "%");
			} else {
				params.add("%" + decisionhecho.getHechoDenunciado().getHdnror()
						+ "%");
			}
			where.append(" AND t2.HDNROR IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte() != null) {
			where.append(" AND UPPER(t2.HDTE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoad() != null) {
			where.append(" AND UPPER(t2.HDTEDOAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedoad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedoad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOAD IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoav() != null) {
			where.append(" AND UPPER(t2.HDCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcoav()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcoav()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOAV IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnops() != null) {
			where.append(" AND UPPER(t2.HDNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPS IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomaps() != null) {
			where.append(" AND UPPER(t2.HDNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMAPS IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnomops() != null) {
			where.append(" AND UPPER(t2.HDNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOMOPS IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnrlops() != null) {
			where.append(" AND UPPER(t2.HDNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNRLOPS IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedmps() != null) {
			where.append(" AND t2.HDFEDMPS like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfedmps()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfedmps()
						+ "%");
			}
			where.append(" AND t2.HDFEDMPS IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsotr() != null) {
			where.append(" AND UPPER(t2.HDINSOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdinsotr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdinsotr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOTR IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdinsoma() != null) {
			where.append(" AND UPPER(t2.HDINSOMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdinsoma()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdinsoma()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINSOMA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcaptso() != null) {
			where.append(" AND t2.HDCAPTSO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcaptso()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcaptso()
						+ "%");
			}
			where.append(" AND t2.HDCAPTSO IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteso() != null) {
			where.append(" AND UPPER(t2.HDTESO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdteso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdteso()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTESO IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeardt() != null) {
			where.append(" AND t2.HDFEARDT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeardt()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeardt()
						+ "%");
			}
			where.append(" AND t2.HDFEARDT IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiohd() != null) {
			where.append(" AND t2.HDFEIOHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeiohd()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeiohd()
						+ "%");
			}
			where.append(" AND t2.HDFEIOHD IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdininin() != null) {
			where.append(" AND UPPER(t2.HDINININ) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdininin()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdininin()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDINININ IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiopc() != null) {
			where.append(" AND t2.HDFEIOPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeiopc()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeiopc()
						+ "%");
			}
			where.append(" AND t2.HDFEIOPC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferopc() != null) {
			where.append(" AND t2.HDFEROPC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdferopc()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdferopc()
						+ "%");
			}
			where.append(" AND t2.HDFEROPC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcorepc() != null) {
			where.append(" AND UPPER(t2.HDCOREPC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcorepc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcorepc()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREPC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiorp() != null) {
			where.append(" AND t2.HDFEIORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeiorp()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeiorp()
						+ "%");
			}
			where.append(" AND t2.HDFEIORP IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferorp() != null) {
			where.append(" AND t2.HDFERORP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdferorp()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdferorp()
						+ "%");
			}
			where.append(" AND t2.HDFERORP IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcoreap() != null) {
			where.append(" AND UPPER(t2.HDCOREAP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcoreap()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcoreap()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOREAP IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiora() != null) {
			where.append(" AND t2.HDFEIORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeiora()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeiora()
						+ "%");
			}
			where.append(" AND t2.HDFEIORA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacpa() != null) {
			where.append(" AND UPPER(t2.HDTEACPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdteacpa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdteacpa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACPA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeceac() != null) {
			where.append(" AND t2.HDFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeceac()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeceac()
						+ "%");
			}
			where.append(" AND t2.HDFECEAC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdhoceac() != null) {
			where.append(" AND UPPER(t2.HDHOCEAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdhoceac()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdhoceac()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDHOCEAC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioca() != null) {
			where.append(" AND t2.HDFEIOCA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeioca()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeioca()
						+ "%");
			}
			where.append(" AND t2.HDFEIOCA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdteacde() != null) {
			where.append(" AND UPPER(t2.HDTEACDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdteacde()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdteacde()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEACDE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeioac() != null) {
			where.append(" AND t2.HDFEIOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeioac()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeioac()
						+ "%");
			}
			where.append(" AND t2.HDFEIOAC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfeiofc() != null) {
			where.append(" AND t2.HDFEIOFC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfeiofc()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfeiofc()
						+ "%");
			}
			where.append(" AND t2.HDFEIOFC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcotra() != null) {
			where.append(" AND UPPER(t2.HDCOTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcotra()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcotra()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOTRA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte02() != null) {
			where.append(" AND UPPER(t2.HDTE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte02()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte02()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE02 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte03() != null) {
			where.append(" AND UPPER(t2.HDTE03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte03()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte03()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE03 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte04() != null) {
			where.append(" AND UPPER(t2.HDTE04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte04()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte04()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE04 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte05() != null) {
			where.append(" AND UPPER(t2.HDTE05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte05()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte05()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE05 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte06() != null) {
			where.append(" AND UPPER(t2.HDTE06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte06()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte06()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE06 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte07() != null) {
			where.append(" AND UPPER(t2.HDTE07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte07()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte07()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE07 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte08() != null) {
			where.append(" AND UPPER(t2.HDTE08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte08()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte08()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE08 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte09() != null) {
			where.append(" AND UPPER(t2.HDTE09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte09()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte09()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE09 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdte10() != null) {
			where.append(" AND UPPER(t2.HDTE10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdte10()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdte10()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTE10 IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcosc() != null) {
			where.append(" AND UPPER(t2.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcosc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcosc()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOSC IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdidal() != null) {
			where.append(" AND UPPER(t2.HDIDAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdidal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdidal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDIDAL IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoad() != null) {
			where.append(" AND t2.HDFEROAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdferoad()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdferoad()
						+ "%");
			}
			where.append(" AND t2.HDFEROAD IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdferoat() != null) {
			where.append(" AND t2.HDFEROAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdferoat()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdferoat()
						+ "%");
			}
			where.append(" AND t2.HDFEROAT IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtealdt() != null) {
			where.append(" AND UPPER(t2.HDTEALDT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtealdt()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtealdt()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEALDT IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedeat() != null) {
			where.append(" AND UPPER(t2.HDTEDEAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedeat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedeat()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDEAT IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfedeat() != null) {
			where.append(" AND t2.HDFEDEAT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfedeat()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdfedeat()
						+ "%");
			}
			where.append(" AND t2.HDFEDEAT IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdfehd() != null) {
			where.append(" AND t2.HDFEHD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdfehd() + "%");
			} else {
				params.add("%" + decisionhecho.getHechoDenunciado().getHdfehd()
						+ "%");
			}
			where.append(" AND t2.HDFEHD IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoade() != null) {
			where.append(" AND UPPER(t2.HDTEDOADE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedoade()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedoade()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadi() != null) {
			where.append(" AND UPPER(t2.HDTEDOADI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedoadi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedoadi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADI IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoadf() != null) {
			where.append(" AND UPPER(t2.HDTEDOADF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedoadf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedoadf()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADF IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdtedoada() != null) {
			where.append(" AND UPPER(t2.HDTEDOADA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdtedoada()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdtedoada()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDTEDOADA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopse() != null) {
			where.append(" AND UPPER(t2.HDNOPSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnopse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnopse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsi() != null) {
			where.append(" AND UPPER(t2.HDNOPSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnopsi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnopsi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSI IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsf() != null) {
			where.append(" AND UPPER(t2.HDNOPSF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnopsf()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnopsf()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSF IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdnopsa() != null) {
			where.append(" AND UPPER(t2.HDNOPSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdnopsa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdnopsa()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDNOPSA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHechoDenunciado() != null
				&& decisionhecho.getHechoDenunciado().getHdcocodigo() != null) {
			where.append(" AND UPPER(t2.HDCOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHechoDenunciado().getHdcocodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getHechoDenunciado().getHdcocodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.HDCOCODIGO IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDecodigo() != null) {
			where.append(" AND t3.DECODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getDecision().getDecodigo() + "%");
			} else {
				params.add("%" + decisionhecho.getDecision().getDecodigo()
						+ "%");
			}
			where.append(" AND t3.DECODIGO IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombre() != null) {
			where.append(" AND UPPER(t3.DENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getDecision().getDenombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getDecision().getDenombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DENOMBRE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDenombree() != null) {
			where.append(" AND UPPER(t3.DENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getDecision().getDenombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ decisionhecho.getDecision().getDenombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.DENOMBREE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getDecision() != null
				&& decisionhecho.getDecision().getDebaja() != null) {
			where.append(" AND t3.DEBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getDecision().getDebaja() + "%");
			} else {
				params.add("%" + decisionhecho.getDecision().getDebaja() + "%");
			}
			where.append(" AND t3.DEBAJA IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHccoor() != null) {
			where.append(" AND UPPER(t1.HCCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHccoor().toUpperCase() + "%");
			} else {
				params.add("%" + decisionhecho.getHccoor().toUpperCase() + "%");
			}
			where.append(" AND t1.HCCOOR IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHcfede() != null) {
			where.append(" AND t1.HCFEDE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHcfede() + "%");
			} else {
				params.add("%" + decisionhecho.getHcfede() + "%");
			}
			where.append(" AND t1.HCFEDE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHcfecode() != null) {
			where.append(" AND t1.HCFECODE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHcfecode() + "%");
			} else {
				params.add("%" + decisionhecho.getHcfecode() + "%");
			}
			where.append(" AND t1.HCFECODE IS NOT NULL");
		}
		if (decisionhecho != null && decisionhecho.getHccoorprop() != null) {
			where.append(" AND UPPER(t1.HCCOORPROP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decisionhecho.getHccoorprop().toUpperCase() + "%");
			} else {
				params.add("%" + decisionhecho.getHccoorprop().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HCCOORPROP IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<DecisionHecho>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
