package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.DecisionHechoDetalle;
import com.ejie.y41a.model.PlantillaTramiteDecisionDetalle;

/**
 * * DecisionHechoDao generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

public interface DecisionHechoDao {

	/**
	 * Inserts a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho add(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho update(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHecho updateDecision(DecisionHecho decisionhecho);

	/**
	 * Updates a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHecho updateOrganismoTraslado(DecisionHecho decisionhecho);

	/**
	 * Actualiza los datos referentes al organismo destino al decidir un
	 * traslado/inhibición
	 * 
	 * @param decisionhecho
	 *            DecisionHecho objeto con las propiedades hccodigo y
	 *            hccoortransinhibi informados
	 * @return DecisionHecho datos actualizados
	 */
	DecisionHecho updateOrganismoTrasladoInhibicion(DecisionHecho decisionhecho);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	DecisionHecho find(DecisionHecho decisionhecho);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return DecisionHecho
	 */
	DecisionHechoDetalle findDecisionHecho(
			DecisionHechoDetalle decisionHechoDetalle);

	/**
	 * Finds a single row in the DecisionHecho table.
	 * 
	 * @param plantillaTramiteDecisionDetalle
	 *            PlantillaTramiteDecisionDetalle
	 * @return PlantillaTramiteDecisionDetalle
	 */
	PlantillaTramiteDecisionDetalle findPlantillaTramiteDecision(
			PlantillaTramiteDecisionDetalle plantillaTramiteDecisionDetalle);

	/**
	 * Deletes a single row in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return
	 */
	void remove(DecisionHecho decisionhecho);

	/**
	 * Removes all decision of the Solicitud.
	 * 
	 * @param decisionhecho
	 *            Pagination
	 * @return
	 */
	void removeDecisionSolicitud(DecisionHecho decisionhecho);

	/**
	 * Finds a List of rows in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DecisionHecho> findAll(DecisionHecho decisionhecho,
			Pagination pagination);

	/**
	 * Counts rows in the DecisionHecho table.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @return List
	 */
	Long findAllCount(DecisionHecho decisionhecho);

	/**
	 * Finds rows in the DecisionHecho table using like.
	 * 
	 * @param decisionhecho
	 *            DecisionHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<DecisionHecho> findAllLike(DecisionHecho decisionhecho,
			Pagination pagination, Boolean startsWith);
}
