package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Decision;

/**
 * * DecisionDaoImpl generated by UDA, 05-mar-2012 9:11:42.
 * 
 *  
 */

@Repository
@Transactional
public class DecisionDaoImpl implements DecisionDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Decision> rwMap = new RowMapper<Decision>() {
		public Decision mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Decision(resultSet.getString("DECODIGO"),
					resultSet.getString("DENOMBRE"),
					resultSet.getString("DENOMBREE"),
					resultSet.getDate("DEBAJA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision add(Decision decision) {

		String query = "INSERT INTO DECISION( DECODIGO,DENOMBRE,DENOMBREE,DEBAJA,ISKONTSUMONET)"
				+ "VALUES (?,?,?,?,?)";

		this.jdbcTemplate.update(query, decision.getDecodigo(),
				decision.getDenombre(), decision.getDenombree(),
				decision.getDebaja(), Y41aConstantes.SI);
		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision update(Decision decision) {
		String query = "UPDATE DECISION SET DENOMBRE=?,DENOMBREE=?,DEBAJA=? WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDenombre(),
				decision.getDenombree(), decision.getDebaja(),
				decision.getDecodigo());
		return decision;
	}

	/**
	 * Updates a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	public Decision updateFecha(Decision decision) {
		String query = "UPDATE DECISION SET DEBAJA=? WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDebaja(),
				decision.getDecodigo());
		return decision;
	}

	/**
	 * Finds a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return Decision
	 */
	@Transactional(readOnly = true)
	public Decision find(Decision decision) {
		String query = "SELECT t1.DECODIGO DECODIGO, t1.DENOMBRE DENOMBRE, t1.DENOMBREE DENOMBREE, t1.DEBAJA DEBAJA "
				+ "FROM DECISION t1  " + "WHERE t1.DECODIGO = ?    ";
		return (Decision) this.jdbcTemplate.queryForObject(query, rwMap,
				decision.getDecodigo());
	}

	/**
	 * Removes a single row in the Decision table.
	 * 
	 * @param decision
	 *            Pagination
	 * @return
	 */
	public void remove(Decision decision) {
		String query = "DELETE  FROM DECISION WHERE DECODIGO=?";
		this.jdbcTemplate.update(query, decision.getDecodigo());
	}

	/**
	 * Finds a List of rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAll(Decision decision, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,t1.DENOMBREE DENOMBREE,t1.DEBAJA DEBAJA "
						+ "FROM DECISION t1 ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Decision table.
	 * 
	 * @param decision
	 *            Decision
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Decision decision) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  DECISION t1  ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND t1.DECODIGO = ?");
			params.add(decision.getDecodigo());
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND t1.DENOMBRE = ?");
			params.add(decision.getDenombre());
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND t1.DENOMBREE = ?");
			params.add(decision.getDenombree());
		}
		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA = ?");
			params.add(decision.getDebaja());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Decision table using like.
	 * 
	 * @param decision
	 *            Decision
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Decision> findAllLike(Decision decision, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.DECODIGO DECODIGO,t1.DENOMBRE DENOMBRE,t1.DENOMBREE DENOMBREE,t1.DEBAJA DEBAJA "
						+ "FROM DECISION t1 ");

		where.append(" AND t1.ISKONTSUMONET = ? ");
		params.add(Y41aConstantes.SI);

		if (decision != null && decision.getDecodigo() != null) {
			where.append(" AND UPPER(t1.DECODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDecodigo().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDecodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.DECODIGO IS NOT NULL");
		}
		if (decision != null && decision.getDenombre() != null) {
			where.append(" AND UPPER(t1.DENOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombre().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDenombre().toUpperCase() + "%");
			}
			where.append(" AND t1.DENOMBRE IS NOT NULL");
		}
		if (decision != null && decision.getDenombree() != null) {
			where.append(" AND UPPER(t1.DENOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDenombree().toUpperCase() + "%");
			} else {
				params.add("%" + decision.getDenombree().toUpperCase() + "%");
			}
			where.append(" AND t1.DENOMBREE IS NOT NULL");
		}
		if (decision != null && decision.getDebaja() != null) {
			where.append(" AND t1.DEBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(decision.getDebaja() + "%");
			} else {
				params.add("%" + decision.getDebaja() + "%");
			}
			where.append(" AND t1.DEBAJA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Decision>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21R8T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
