package com.ejie.y41a.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Establecimiento;

/**
 * DatosMailEstablecimientoDaoImpl generated by UDA, 01-oct-2015 8:37:17.
 * 
 *  
 */

@Repository
@Transactional
public class DatosMailEstablecimientoDaoImpl implements
		DatosMailEstablecimientoDao {
	private JdbcTemplate jdbcTemplate;

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Removes a single row in the DATOS_MAIL_ESTABLECIMIENTO table.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return
	 */
	public void removeAllDatosMailEstablec(Establecimiento establecimiento) {
		String query = "DELETE FROM DATOS_MAIL_ESTABLECIMIENTO WHERE ESCODIGO=?";
		this.jdbcTemplate.update(query, establecimiento.getEscodigo());
	}

}
