package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.ConsultaFile;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.RangoEdad;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * ConsultaFileDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class ConsultaFileDaoImpl implements ConsultaFileDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<ConsultaFile> rwMap = new RowMapper<ConsultaFile>() {
		public ConsultaFile mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ConsultaFile(resultSet.getLong("Q4CODOCUMENTO"),
					resultSet.getString("Q4NOFILE"),
					resultSet.getBlob("Q4DATAFILE"),
					resultSet.getInt("Q4SIZEFILE"),
					resultSet.getString("Q4TEDESFILE"),
					resultSet.getDate("Q4FECHA"),
					resultSet.getString("Q4ORIGEN"),
					resultSet.getString("Q4CONTENTTYPEFILE"), new Consulta(
							resultSet.getString("ConsultaCOCODIGO"),
							new Motivo(resultSet.getString("ConsultaCOCOTIR"),
									null, null, null), new Producto(
									resultSet.getString("ConsultaCOCOPS"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new RangoEdad(resultSet
									.getString("ConsultaCORANCOD"), null, null,
									null), new FormaPresentacion(
									resultSet.getString("ConsultaCOCOTFP"),
									null, null, null, null, null, null),
							new Organismo(
									resultSet.getString("ConsultaCOCOOR"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new CensoMonitor(resultSet
									.getString("ConsultaCOCOMO"), null, null,
									null, null, null, null, null, null, null,
									null, null),
							resultSet.getDate("ConsultaCOFECHA"),
							resultSet.getString("ConsultaCOCOSX"),
							resultSet.getString("ConsultaCONRAN"),
							resultSet.getString("ConsultaCOCOSE"),
							resultSet.getString("ConsultaCOTEXTO"),
							resultSet.getInt("ConsultaCONRREG"),
							resultSet.getString("ConsultaCONOCO"),
							resultSet.getString("ConsultaCONODIRCO"),
							resultSet.getString("ConsultaCONRCPCO"),
							resultSet.getString("ConsultaCOCOLOCO"),
							resultSet.getString("ConsultaCONOLOCO"),
							resultSet.getString("ConsultaCONOMUCO"),
							resultSet.getString("ConsultaCOCOPVCO"),
							resultSet.getString("ConsultaCOCOPACO"),
							resultSet.getString("ConsultaCONRTELCO"),
							resultSet.getString("ConsultaCONRFAXCO"),
							resultSet.getString("ConsultaCOCOEMCO"),
							resultSet.getDate("ConsultaCOFERES"),
							resultSet.getString("ConsultaCOINREENV"),
							resultSet.getString("ConsultaCOTERESP"),
							resultSet.getString("ConsultaCOCOTFPR"),
							resultSet.getString("ConsultaCOINL37"),
							resultSet.getLong("ConsultaCONRANRG"),
							resultSet.getString("ConsultaCOCOPRO"),
							resultSet.getString("ConsultaCOHDCODIGO"),
							resultSet.getString("ConsultaCOHORA"),
							resultSet.getDate("ConsultaCOFECHACONSUMIDOR"),
							resultSet.getString("ConsultaNORAPAISID"),
							resultSet.getString("ConsultaNOMBREPAIS"),
							resultSet.getString("ConsultaNORAPROVINCIAID"),
							resultSet.getString("ConsultaNOMBREPROVINCIA"),
							resultSet.getString("ConsultaNORAMUNICIPIOID"),
							resultSet.getString("ConsultaNOMBREMUNICIPIO"),
							resultSet.getString("ConsultaNORALOCALIDADID"),
							resultSet.getString("ConsultaNOMBRELOCALIDAD"),
							resultSet.getString("ConsultaNORACALLEID"),
							resultSet.getString("ConsultaNOMBRECALLE"),
							resultSet.getString("ConsultaNORACPID"),
							resultSet.getString("ConsultaNOMBRECP"),
							resultSet.getString("ConsultaNORAPORTALID"),
							resultSet.getString("ConsultaNOMBREPORTAL"),
							resultSet.getString("ConsultaCOINL21"),
							resultSet.getString("ConsultaCOSITUACION"),
							resultSet.getString("ConsultaNOMBREPISO"),
							resultSet.getString("ConsultaDIRECCION_NOCAPV"),
							null, null, null, null));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            Pagination
	 * @return ConsultaFile
	 */
	public ConsultaFile add(ConsultaFile consultafile) {

		String query = "INSERT INTO CONSULTA_FILE( Q4CODOCUMENTO,Q4CODCONSULTA,Q4NOFILE,Q4DATAFILE,Q4SIZEFILE,Q4TEDESFILE,Q4FECHA,Q4ORIGEN,Q4CONTENTTYPEFILE)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getConsultaCocodigoAux = null;
		if (consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocodigo() != null) {
			getConsultaCocodigoAux = consultafile.getConsulta().getCocodigo();
		}
		this.jdbcTemplate.update(query, consultafile.getQ4codocumento(),
				getConsultaCocodigoAux, consultafile.getQ4nofile(),
				Y41aJdbcUtils.ConvertBlobToByte(consultafile.getQ4datafile()),
				consultafile.getQ4sizefile(), consultafile.getQ4tedesfile(),
				consultafile.getQ4fecha(), consultafile.getQ4origen(),
				consultafile.getQ4contenttypefile());
		return consultafile;
	}

	/**
	 * Updates a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            Pagination
	 * @return ConsultaFile
	 */
	public ConsultaFile update(ConsultaFile consultafile) {
		String query = "UPDATE CONSULTA_FILE SET Q4CODCONSULTA=?,Q4NOFILE=?,Q4DATAFILE=?,Q4SIZEFILE=?,Q4TEDESFILE=?,Q4FECHA=?,Q4ORIGEN=?,Q4CONTENTTYPEFILE=? WHERE Q4CODOCUMENTO=?";
		Object getConsultaCocodigoAux = null;
		if (consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocodigo() != null) {
			getConsultaCocodigoAux = consultafile.getConsulta().getCocodigo();
		}
		this.jdbcTemplate.update(query, getConsultaCocodigoAux,
				consultafile.getQ4nofile(),
				Y41aJdbcUtils.ConvertBlobToByte(consultafile.getQ4datafile()),
				consultafile.getQ4sizefile(), consultafile.getQ4tedesfile(),
				consultafile.getQ4fecha(), consultafile.getQ4origen(),
				consultafile.getQ4contenttypefile(),
				consultafile.getQ4codocumento());
		return consultafile;
	}

	/**
	 * Finds a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            Pagination
	 * @return ConsultaFile
	 */
	@Transactional(readOnly = true)
	public ConsultaFile find(ConsultaFile consultafile) {
		String query = "SELECT t1.Q4CODOCUMENTO Q4CODOCUMENTO, t1.Q4NOFILE Q4NOFILE, t1.Q4DATAFILE Q4DATAFILE, t1.Q4SIZEFILE Q4SIZEFILE, t1.Q4TEDESFILE Q4TEDESFILE, t1.Q4FECHA Q4FECHA, t1.Q4ORIGEN Q4ORIGEN, t1.Q4CONTENTTYPEFILE Q4CONTENTTYPEFILE, t2.COCODIGO CONSULTACOCODIGO, t2.COFECHA CONSULTACOFECHA, t2.COCOSX CONSULTACOCOSX, t2.CONRAN CONSULTACONRAN, t2.COCOSE CONSULTACOCOSE, t2.COTEXTO CONSULTACOTEXTO, t2.CONRREG CONSULTACONRREG, t2.CONOCO CONSULTACONOCO, t2.CONODIRCO CONSULTACONODIRCO, t2.CONRCPCO CONSULTACONRCPCO, t2.COCOLOCO CONSULTACOCOLOCO, t2.CONOLOCO CONSULTACONOLOCO, t2.CONOMUCO CONSULTACONOMUCO, t2.COCOPVCO CONSULTACOCOPVCO, t2.COCOPACO CONSULTACOCOPACO, t2.CONRTELCO CONSULTACONRTELCO, t2.CONRFAXCO CONSULTACONRFAXCO, t2.COCOEMCO CONSULTACOCOEMCO, t2.COFERES CONSULTACOFERES, t2.COINREENV CONSULTACOINREENV, t2.COTERESP CONSULTACOTERESP, t2.COCOTFPR CONSULTACOCOTFPR, t2.COINL37 CONSULTACOINL37, t2.CONRANRG CONSULTACONRANRG, t2.COCOPRO CONSULTACOCOPRO, t2.COHDCODIGO CONSULTACOHDCODIGO, t2.COHORA CONSULTACOHORA, t2.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR, t2.NORA_PAIS_ID CONSULTANORAPAISID, t2.NOMBRE_PAIS CONSULTANOMBREPAIS, t2.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID, t2.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA, t2.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID, t2.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD, t2.NORA_CALLE_ID CONSULTANORACALLEID, t2.NOMBRE_CALLE CONSULTANOMBRECALLE, t2.NORA_CP_ID CONSULTANORACPID, t2.NOMBRE_CP CONSULTANOMBRECP, t2.NORA_PORTAL_ID CONSULTANORAPORTALID, t2.NOMBRE_PORTAL CONSULTANOMBREPORTAL, t2.COINL21 CONSULTACOINL21, t2.COSITUACION CONSULTACOSITUACION, t2.NOMBRE_PISO ConsultaNOMBREPISO, t2.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV, t2.COCOTIR CONSULTACOCOTIR, t2.COCOPS CONSULTACOCOPS, t2.CORANCOD CONSULTACORANCOD, t2.COCOTFP CONSULTACOCOTFP, t2.COCOOR CONSULTACOCOOR, t2.COCOMO CONSULTACOCOMO "
				+ "FROM CONSULTA_FILE t1 , CONSULTA t2  "
				+ "WHERE t1.Q4CODOCUMENTO = ?   AND t1.Q4CODCONSULTA= t2.COCODIGO(+)  ";
		return (ConsultaFile) this.jdbcTemplate.queryForObject(query, rwMap,
				consultafile.getQ4codocumento());
	}

	/**
	 * Removes a single row in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            Pagination
	 * @return
	 */
	public void remove(ConsultaFile consultafile) {
		String query = "DELETE  FROM CONSULTA_FILE WHERE Q4CODOCUMENTO=?";
		this.jdbcTemplate.update(query, consultafile.getQ4codocumento());
	}

	/**
	 * Removes a single row in the ConsultaFile table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	public void removeConsultaFileConsulta(Consulta consulta) {
		String query = "DELETE  FROM CONSULTA_FILE WHERE Q4CODCONSULTA=?";
		this.jdbcTemplate.update(query, consulta.getCocodigo());
	}

	/**
	 * Finds a List of rows in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsultaFile> findAll(ConsultaFile consultafile,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q4CODCONSULTA= t2.COCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q4CODOCUMENTO Q4CODOCUMENTO,t1.Q4NOFILE Q4NOFILE,t1.Q4DATAFILE Q4DATAFILE,t1.Q4SIZEFILE Q4SIZEFILE,t1.Q4TEDESFILE Q4TEDESFILE,t1.Q4FECHA Q4FECHA,t1.Q4ORIGEN Q4ORIGEN, t1.Q4CONTENTTYPEFILE Q4CONTENTTYPEFILE,t2.COCODIGO CONSULTACOCODIGO,t2.COFECHA CONSULTACOFECHA,t2.COCOSX CONSULTACOCOSX,t2.CONRAN CONSULTACONRAN,t2.COCOSE CONSULTACOCOSE,t2.COTEXTO CONSULTACOTEXTO,t2.CONRREG CONSULTACONRREG,t2.CONOCO CONSULTACONOCO,t2.CONODIRCO CONSULTACONODIRCO,t2.CONRCPCO CONSULTACONRCPCO,t2.COCOLOCO CONSULTACOCOLOCO,t2.CONOLOCO CONSULTACONOLOCO,t2.CONOMUCO CONSULTACONOMUCO,t2.COCOPVCO CONSULTACOCOPVCO,t2.COCOPACO CONSULTACOCOPACO,t2.CONRTELCO CONSULTACONRTELCO,t2.CONRFAXCO CONSULTACONRFAXCO,t2.COCOEMCO CONSULTACOCOEMCO,t2.COFERES CONSULTACOFERES,t2.COINREENV CONSULTACOINREENV,t2.COTERESP CONSULTACOTERESP,t2.COCOTFPR CONSULTACOCOTFPR,t2.COINL37 CONSULTACOINL37,t2.CONRANRG CONSULTACONRANRG,t2.COCOPRO CONSULTACOCOPRO,t2.COHDCODIGO CONSULTACOHDCODIGO,t2.COHORA CONSULTACOHORA,t2.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR,t2.NORA_PAIS_ID CONSULTANORAPAISID,t2.NOMBRE_PAIS CONSULTANOMBREPAIS,t2.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID,t2.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID,t2.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD,t2.NORA_CALLE_ID CONSULTANORACALLEID,t2.NOMBRE_CALLE CONSULTANOMBRECALLE,t2.NORA_CP_ID CONSULTANORACPID,t2.NOMBRE_CP CONSULTANOMBRECP,t2.NORA_PORTAL_ID CONSULTANORAPORTALID,t2.NOMBRE_PORTAL CONSULTANOMBREPORTAL,t2.COINL21 CONSULTACOINL21,t2.COSITUACION CONSULTACOSITUACION, t2.NOMBRE_PISO ConsultaNOMBREPISO, t2.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV,t2.COCOTIR CONSULTACOCOTIR,t2.COCOPS CONSULTACOCOPS,t2.CORANCOD CONSULTACORANCOD,t2.COCOTFP CONSULTACOCOTFP,t2.COCOOR CONSULTACOCOOR,t2.COCOMO CONSULTACOCOMO "
						+ "FROM CONSULTA_FILE t1 ,CONSULTA t2 ");

		if (consultafile != null && consultafile.getQ4codocumento() != null) {
			where.append(" AND t1.Q4CODOCUMENTO = ?");
			params.add(consultafile.getQ4codocumento());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocodigo() != null) {
			where.append(" AND t2.COCODIGO = ?");
			params.add(consultafile.getConsulta().getCocodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getMotivo() != null
				&& consultafile.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND t2.COCOTIR = ?");
			params.add(consultafile.getConsulta().getMotivo().getTircodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getProducto() != null
				&& consultafile.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.COCOPS = ?");
			params.add(consultafile.getConsulta().getProducto().getPscodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getRangoEdad() != null
				&& consultafile.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND t2.CORANCOD = ?");
			params.add(consultafile.getConsulta().getRangoEdad().getRancod());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getFormaPresentacion() != null
				&& consultafile.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND t2.COCOTFP = ?");
			params.add(consultafile.getConsulta().getFormaPresentacion()
					.getTfpcodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getOrganismo() != null
				&& consultafile.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COCOOR = ?");
			params.add(consultafile.getConsulta().getOrganismo().getCodOrg());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCensoMonitor() != null
				&& consultafile.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.COCOMO = ?");
			params.add(consultafile.getConsulta().getCensoMonitor()
					.getMocodigo());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofecha() != null) {
			where.append(" AND t2.COFECHA = ?");
			params.add(consultafile.getConsulta().getCofecha());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocosx() != null) {
			where.append(" AND t2.COCOSX = ?");
			params.add(consultafile.getConsulta().getCocosx());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConran() != null) {
			where.append(" AND t2.CONRAN = ?");
			params.add(consultafile.getConsulta().getConran());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocose() != null) {
			where.append(" AND t2.COCOSE = ?");
			params.add(consultafile.getConsulta().getCocose());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCotexto() != null) {
			where.append(" AND t2.COTEXTO = ?");
			params.add(consultafile.getConsulta().getCotexto());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrreg() != null) {
			where.append(" AND t2.CONRREG = ?");
			params.add(consultafile.getConsulta().getConrreg());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoco() != null) {
			where.append(" AND t2.CONOCO = ?");
			params.add(consultafile.getConsulta().getConoco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConodirco() != null) {
			where.append(" AND t2.CONODIRCO = ?");
			params.add(consultafile.getConsulta().getConodirco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrcpco() != null) {
			where.append(" AND t2.CONRCPCO = ?");
			params.add(consultafile.getConsulta().getConrcpco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoloco() != null) {
			where.append(" AND t2.COCOLOCO = ?");
			params.add(consultafile.getConsulta().getCocoloco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoloco() != null) {
			where.append(" AND t2.CONOLOCO = ?");
			params.add(consultafile.getConsulta().getConoloco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConomuco() != null) {
			where.append(" AND t2.CONOMUCO = ?");
			params.add(consultafile.getConsulta().getConomuco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopvco() != null) {
			where.append(" AND t2.COCOPVCO = ?");
			params.add(consultafile.getConsulta().getCocopvco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopaco() != null) {
			where.append(" AND t2.COCOPACO = ?");
			params.add(consultafile.getConsulta().getCocopaco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrtelco() != null) {
			where.append(" AND t2.CONRTELCO = ?");
			params.add(consultafile.getConsulta().getConrtelco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrfaxco() != null) {
			where.append(" AND t2.CONRFAXCO = ?");
			params.add(consultafile.getConsulta().getConrfaxco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoemco() != null) {
			where.append(" AND t2.COCOEMCO = ?");
			params.add(consultafile.getConsulta().getCocoemco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoferes() != null) {
			where.append(" AND t2.COFERES = ?");
			params.add(consultafile.getConsulta().getCoferes());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinreenv() != null) {
			where.append(" AND t2.COINREENV = ?");
			params.add(consultafile.getConsulta().getCoinreenv());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoteresp() != null) {
			where.append(" AND t2.COTERESP = ?");
			params.add(consultafile.getConsulta().getCoteresp());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocotfpr() != null) {
			where.append(" AND t2.COCOTFPR = ?");
			params.add(consultafile.getConsulta().getCocotfpr());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl37() != null) {
			where.append(" AND t2.COINL37 = ?");
			params.add(consultafile.getConsulta().getCoinl37());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConranrg() != null) {
			where.append(" AND t2.CONRANRG = ?");
			params.add(consultafile.getConsulta().getConranrg());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopro() != null) {
			where.append(" AND t2.COCOPRO = ?");
			params.add(consultafile.getConsulta().getCocopro());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohdcodigo() != null) {
			where.append(" AND t2.COHDCODIGO = ?");
			params.add(consultafile.getConsulta().getCohdcodigo());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohora() != null) {
			where.append(" AND t2.COHORA = ?");
			params.add(consultafile.getConsulta().getCohora());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t2.COFECHACONSUMIDOR = ?");
			params.add(consultafile.getConsulta().getCofechaconsumidor());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(consultafile.getConsulta().getNoraPaisId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(consultafile.getConsulta().getNombrePais());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(consultafile.getConsulta().getNoraProvinciaId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(consultafile.getConsulta().getNombreProvincia());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(consultafile.getConsulta().getNoraMunicipioId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(consultafile.getConsulta().getNombreMunicipio());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(consultafile.getConsulta().getNoraLocalidadId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(consultafile.getConsulta().getNombreLocalidad());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(consultafile.getConsulta().getNoraCalleId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(consultafile.getConsulta().getNombreCalle());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(consultafile.getConsulta().getNoraCpId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(consultafile.getConsulta().getNombreCp());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(consultafile.getConsulta().getNoraPortalId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(consultafile.getConsulta().getNombrePortal());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl21() != null) {
			where.append(" AND t2.COINL21 = ?");
			params.add(consultafile.getConsulta().getCoinl21());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCosituacion() != null) {
			where.append(" AND t2.COSITUACION = ?");
			params.add(consultafile.getConsulta().getCosituacion());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePiso() != null) {
			where.append(" AND t2.NOMBRE_PISO = ?");
			params.add(consultafile.getConsulta().getNombrePiso());
		}
		if (consultafile != null && consultafile.getQ4nofile() != null) {
			where.append(" AND t1.Q4NOFILE = ?");
			params.add(consultafile.getQ4nofile());
		}
		if (consultafile != null && consultafile.getQ4sizefile() != null) {
			where.append(" AND t1.Q4SIZEFILE = ?");
			params.add(consultafile.getQ4sizefile());
		}
		if (consultafile != null && consultafile.getQ4tedesfile() != null) {
			where.append(" AND t1.Q4TEDESFILE = ?");
			params.add(consultafile.getQ4tedesfile());
		}
		if (consultafile != null && consultafile.getQ4fecha() != null) {
			where.append(" AND t1.Q4FECHA = ?");
			params.add(consultafile.getQ4fecha());
		}
		if (consultafile != null && consultafile.getQ4origen() != null) {
			where.append(" AND t1.Q4ORIGEN = ?");
			params.add(consultafile.getQ4origen());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ConsultaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ConsultaFile table.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ConsultaFile consultafile) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.Q4CODCONSULTA= t2.COCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CONSULTA_FILE t1   ,  CONSULTA t2  ");
		if (consultafile != null && consultafile.getQ4codocumento() != null) {
			where.append(" AND t1.Q4CODOCUMENTO = ?");
			params.add(consultafile.getQ4codocumento());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocodigo() != null) {
			where.append(" AND t2.COCODIGO = ?");
			params.add(consultafile.getConsulta().getCocodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getMotivo() != null
				&& consultafile.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND t2.COCOTIR = ?");
			params.add(consultafile.getConsulta().getMotivo().getTircodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getProducto() != null
				&& consultafile.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.COCOPS = ?");
			params.add(consultafile.getConsulta().getProducto().getPscodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getRangoEdad() != null
				&& consultafile.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND t2.CORANCOD = ?");
			params.add(consultafile.getConsulta().getRangoEdad().getRancod());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getFormaPresentacion() != null
				&& consultafile.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND t2.COCOTFP = ?");
			params.add(consultafile.getConsulta().getFormaPresentacion()
					.getTfpcodigo());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getOrganismo() != null
				&& consultafile.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COCOOR = ?");
			params.add(consultafile.getConsulta().getOrganismo().getCodOrg());
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCensoMonitor() != null
				&& consultafile.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t2.COCOMO = ?");
			params.add(consultafile.getConsulta().getCensoMonitor()
					.getMocodigo());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofecha() != null) {
			where.append(" AND t2.COFECHA = ?");
			params.add(consultafile.getConsulta().getCofecha());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocosx() != null) {
			where.append(" AND t2.COCOSX = ?");
			params.add(consultafile.getConsulta().getCocosx());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConran() != null) {
			where.append(" AND t2.CONRAN = ?");
			params.add(consultafile.getConsulta().getConran());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocose() != null) {
			where.append(" AND t2.COCOSE = ?");
			params.add(consultafile.getConsulta().getCocose());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCotexto() != null) {
			where.append(" AND t2.COTEXTO = ?");
			params.add(consultafile.getConsulta().getCotexto());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrreg() != null) {
			where.append(" AND t2.CONRREG = ?");
			params.add(consultafile.getConsulta().getConrreg());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoco() != null) {
			where.append(" AND t2.CONOCO = ?");
			params.add(consultafile.getConsulta().getConoco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConodirco() != null) {
			where.append(" AND t2.CONODIRCO = ?");
			params.add(consultafile.getConsulta().getConodirco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrcpco() != null) {
			where.append(" AND t2.CONRCPCO = ?");
			params.add(consultafile.getConsulta().getConrcpco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoloco() != null) {
			where.append(" AND t2.COCOLOCO = ?");
			params.add(consultafile.getConsulta().getCocoloco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoloco() != null) {
			where.append(" AND t2.CONOLOCO = ?");
			params.add(consultafile.getConsulta().getConoloco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConomuco() != null) {
			where.append(" AND t2.CONOMUCO = ?");
			params.add(consultafile.getConsulta().getConomuco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopvco() != null) {
			where.append(" AND t2.COCOPVCO = ?");
			params.add(consultafile.getConsulta().getCocopvco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopaco() != null) {
			where.append(" AND t2.COCOPACO = ?");
			params.add(consultafile.getConsulta().getCocopaco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrtelco() != null) {
			where.append(" AND t2.CONRTELCO = ?");
			params.add(consultafile.getConsulta().getConrtelco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrfaxco() != null) {
			where.append(" AND t2.CONRFAXCO = ?");
			params.add(consultafile.getConsulta().getConrfaxco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoemco() != null) {
			where.append(" AND t2.COCOEMCO = ?");
			params.add(consultafile.getConsulta().getCocoemco());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoferes() != null) {
			where.append(" AND t2.COFERES = ?");
			params.add(consultafile.getConsulta().getCoferes());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinreenv() != null) {
			where.append(" AND t2.COINREENV = ?");
			params.add(consultafile.getConsulta().getCoinreenv());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoteresp() != null) {
			where.append(" AND t2.COTERESP = ?");
			params.add(consultafile.getConsulta().getCoteresp());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocotfpr() != null) {
			where.append(" AND t2.COCOTFPR = ?");
			params.add(consultafile.getConsulta().getCocotfpr());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl37() != null) {
			where.append(" AND t2.COINL37 = ?");
			params.add(consultafile.getConsulta().getCoinl37());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConranrg() != null) {
			where.append(" AND t2.CONRANRG = ?");
			params.add(consultafile.getConsulta().getConranrg());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopro() != null) {
			where.append(" AND t2.COCOPRO = ?");
			params.add(consultafile.getConsulta().getCocopro());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohdcodigo() != null) {
			where.append(" AND t2.COHDCODIGO = ?");
			params.add(consultafile.getConsulta().getCohdcodigo());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohora() != null) {
			where.append(" AND t2.COHORA = ?");
			params.add(consultafile.getConsulta().getCohora());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t2.COFECHACONSUMIDOR = ?");
			params.add(consultafile.getConsulta().getCofechaconsumidor());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(consultafile.getConsulta().getNoraPaisId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(consultafile.getConsulta().getNombrePais());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(consultafile.getConsulta().getNoraProvinciaId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(consultafile.getConsulta().getNombreProvincia());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(consultafile.getConsulta().getNoraMunicipioId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(consultafile.getConsulta().getNombreMunicipio());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(consultafile.getConsulta().getNoraLocalidadId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(consultafile.getConsulta().getNombreLocalidad());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(consultafile.getConsulta().getNoraCalleId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(consultafile.getConsulta().getNombreCalle());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(consultafile.getConsulta().getNoraCpId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(consultafile.getConsulta().getNombreCp());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(consultafile.getConsulta().getNoraPortalId());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(consultafile.getConsulta().getNombrePortal());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl21() != null) {
			where.append(" AND t2.COINL21 = ?");
			params.add(consultafile.getConsulta().getCoinl21());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCosituacion() != null) {
			where.append(" AND t2.COSITUACION = ?");
			params.add(consultafile.getConsulta().getCosituacion());
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePiso() != null) {
			where.append(" AND t2.NOMBRE_PISO = ?");
			params.add(consultafile.getConsulta().getNombrePiso());
		}
		if (consultafile != null && consultafile.getQ4nofile() != null) {
			where.append(" AND t1.Q4NOFILE = ?");
			params.add(consultafile.getQ4nofile());
		}
		if (consultafile != null && consultafile.getQ4sizefile() != null) {
			where.append(" AND t1.Q4SIZEFILE = ?");
			params.add(consultafile.getQ4sizefile());
		}
		if (consultafile != null && consultafile.getQ4tedesfile() != null) {
			where.append(" AND t1.Q4TEDESFILE = ?");
			params.add(consultafile.getQ4tedesfile());
		}
		if (consultafile != null && consultafile.getQ4fecha() != null) {
			where.append(" AND t1.Q4FECHA = ?");
			params.add(consultafile.getQ4fecha());
		}
		if (consultafile != null && consultafile.getQ4origen() != null) {
			where.append(" AND t1.Q4ORIGEN = ?");
			params.add(consultafile.getQ4origen());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ConsultaFile table using like.
	 * 
	 * @param consultafile
	 *            ConsultaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ConsultaFile> findAllLike(ConsultaFile consultafile,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.Q4CODCONSULTA= t2.COCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.Q4CODOCUMENTO Q4CODOCUMENTO,t1.Q4NOFILE Q4NOFILE,t1.Q4DATAFILE Q4DATAFILE,t1.Q4SIZEFILE Q4SIZEFILE,t1.Q4TEDESFILE Q4TEDESFILE,t1.Q4FECHA Q4FECHA,t1.Q4ORIGEN Q4ORIGEN, t1.Q4CONTENTTYPEFILE Q4CONTENTTYPEFILE,t2.COCODIGO CONSULTACOCODIGO,t2.COFECHA CONSULTACOFECHA,t2.COCOSX CONSULTACOCOSX,t2.CONRAN CONSULTACONRAN,t2.COCOSE CONSULTACOCOSE,t2.COTEXTO CONSULTACOTEXTO,t2.CONRREG CONSULTACONRREG,t2.CONOCO CONSULTACONOCO,t2.CONODIRCO CONSULTACONODIRCO,t2.CONRCPCO CONSULTACONRCPCO,t2.COCOLOCO CONSULTACOCOLOCO,t2.CONOLOCO CONSULTACONOLOCO,t2.CONOMUCO CONSULTACONOMUCO,t2.COCOPVCO CONSULTACOCOPVCO,t2.COCOPACO CONSULTACOCOPACO,t2.CONRTELCO CONSULTACONRTELCO,t2.CONRFAXCO CONSULTACONRFAXCO,t2.COCOEMCO CONSULTACOCOEMCO,t2.COFERES CONSULTACOFERES,t2.COINREENV CONSULTACOINREENV,t2.COTERESP CONSULTACOTERESP,t2.COCOTFPR CONSULTACOCOTFPR,t2.COINL37 CONSULTACOINL37,t2.CONRANRG CONSULTACONRANRG,t2.COCOPRO CONSULTACOCOPRO,t2.COHDCODIGO CONSULTACOHDCODIGO,t2.COHORA CONSULTACOHORA,t2.COFECHACONSUMIDOR CONSULTACOFECHACONSUMIDOR,t2.NORA_PAIS_ID CONSULTANORAPAISID,t2.NOMBRE_PAIS CONSULTANOMBREPAIS,t2.NORA_PROVINCIA_ID CONSULTANORAPROVINCIAID,t2.NOMBRE_PROVINCIA CONSULTANOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID CONSULTANORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO CONSULTANOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID CONSULTANORALOCALIDADID,t2.NOMBRE_LOCALIDAD CONSULTANOMBRELOCALIDAD,t2.NORA_CALLE_ID CONSULTANORACALLEID,t2.NOMBRE_CALLE CONSULTANOMBRECALLE,t2.NORA_CP_ID CONSULTANORACPID,t2.NOMBRE_CP CONSULTANOMBRECP,t2.NORA_PORTAL_ID CONSULTANORAPORTALID,t2.NOMBRE_PORTAL CONSULTANOMBREPORTAL,t2.COINL21 CONSULTACOINL21,t2.COSITUACION CONSULTACOSITUACION, t2.NOMBRE_PISO ConsultaNOMBREPISO, t2.DIRECCION_NOCAPV ConsultaDIRECCION_NOCAPV,t2.COCOTIR CONSULTACOCOTIR,t2.COCOPS CONSULTACOCOPS,t2.CORANCOD CONSULTACORANCOD,t2.COCOTFP CONSULTACOCOTFP,t2.COCOOR CONSULTACOCOOR,t2.COCOMO CONSULTACOCOMO "
						+ "FROM CONSULTA_FILE t1 ,CONSULTA t2 ");

		if (consultafile != null && consultafile.getQ4codocumento() != null) {
			where.append(" AND t1.Q4CODOCUMENTO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4codocumento() + "%");
			} else {
				params.add("%" + consultafile.getQ4codocumento() + "%");
			}
			where.append(" AND t1.Q4CODOCUMENTO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocodigo() != null) {
			where.append(" AND t2.COCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocodigo() + "%");
			} else {
				params.add("%" + consultafile.getConsulta().getCocodigo() + "%");
			}
			where.append(" AND t2.COCODIGO IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getMotivo() != null
				&& consultafile.getConsulta().getMotivo().getTircodigo() != null) {
			where.append(" AND UPPER(t2.COCOTIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getMotivo()
						.getTircodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getMotivo().getTircodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOTIR IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getProducto() != null
				&& consultafile.getConsulta().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t2.COCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.COCOPS IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getRangoEdad() != null
				&& consultafile.getConsulta().getRangoEdad().getRancod() != null) {
			where.append(" AND UPPER(t2.CORANCOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getRangoEdad()
						.getRancod().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getRangoEdad().getRancod()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CORANCOD IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getFormaPresentacion() != null
				&& consultafile.getConsulta().getFormaPresentacion()
						.getTfpcodigo() != null) {
			where.append(" AND UPPER(t2.COCOTFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getFormaPresentacion()
						.getTfpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getFormaPresentacion()
								.getTfpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.COCOTFP IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getOrganismo() != null
				&& consultafile.getConsulta().getOrganismo().getCodOrg() != null) {
			where.append(" AND UPPER(t2.COCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getOrganismo()
						.getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getOrganismo().getCodOrg()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOOR IS NOT NULL");
		}
		if (consultafile != null
				&& consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCensoMonitor() != null
				&& consultafile.getConsulta().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t2.COCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.COCOMO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofecha() != null) {
			where.append(" AND t2.COFECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCofecha() + "%");
			} else {
				params.add("%" + consultafile.getConsulta().getCofecha() + "%");
			}
			where.append(" AND t2.COFECHA IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocosx() != null) {
			where.append(" AND UPPER(t2.COCOSX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocosx().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocosx().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COCOSX IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConran() != null) {
			where.append(" AND UPPER(t2.CONRAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConran().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConran().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CONRAN IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocose() != null) {
			where.append(" AND UPPER(t2.COCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocose().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COCOSE IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCotexto() != null) {
			where.append(" AND UPPER(t2.COTEXTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCotexto()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCotexto().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COTEXTO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrreg() != null) {
			where.append(" AND t2.CONRREG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConrreg() + "%");
			} else {
				params.add("%" + consultafile.getConsulta().getConrreg() + "%");
			}
			where.append(" AND t2.CONRREG IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoco() != null) {
			where.append(" AND UPPER(t2.CONOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CONOCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConodirco() != null) {
			where.append(" AND UPPER(t2.CONODIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConodirco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConodirco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONODIRCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrcpco() != null) {
			where.append(" AND UPPER(t2.CONRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConrcpco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConrcpco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONRCPCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoloco() != null) {
			where.append(" AND UPPER(t2.COCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocoloco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocoloco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOLOCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConoloco() != null) {
			where.append(" AND UPPER(t2.CONOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConoloco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConoloco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONOLOCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConomuco() != null) {
			where.append(" AND UPPER(t2.CONOMUCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConomuco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConomuco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONOMUCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopvco() != null) {
			where.append(" AND UPPER(t2.COCOPVCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocopvco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocopvco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOPVCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopaco() != null) {
			where.append(" AND UPPER(t2.COCOPACO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocopaco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocopaco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOPACO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrtelco() != null) {
			where.append(" AND UPPER(t2.CONRTELCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConrtelco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConrtelco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONRTELCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConrfaxco() != null) {
			where.append(" AND UPPER(t2.CONRFAXCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConrfaxco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getConrfaxco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CONRFAXCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocoemco() != null) {
			where.append(" AND UPPER(t2.COCOEMCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocoemco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocoemco()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOEMCO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoferes() != null) {
			where.append(" AND t2.COFERES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCoferes() + "%");
			} else {
				params.add("%" + consultafile.getConsulta().getCoferes() + "%");
			}
			where.append(" AND t2.COFERES IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinreenv() != null) {
			where.append(" AND UPPER(t2.COINREENV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCoinreenv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCoinreenv()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COINREENV IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoteresp() != null) {
			where.append(" AND UPPER(t2.COTERESP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCoteresp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCoteresp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COTERESP IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocotfpr() != null) {
			where.append(" AND UPPER(t2.COCOTFPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocotfpr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocotfpr()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COCOTFPR IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl37() != null) {
			where.append(" AND UPPER(t2.COINL37) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCoinl37()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCoinl37().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COINL37 IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getConranrg() != null) {
			where.append(" AND t2.CONRANRG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getConranrg() + "%");
			} else {
				params.add("%" + consultafile.getConsulta().getConranrg() + "%");
			}
			where.append(" AND t2.CONRANRG IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCocopro() != null) {
			where.append(" AND UPPER(t2.COCOPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCocopro()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCocopro().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COCOPRO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohdcodigo() != null) {
			where.append(" AND UPPER(t2.COHDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCohdcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCohdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COHDCODIGO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCohora() != null) {
			where.append(" AND UPPER(t2.COHORA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCohora().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCohora().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COHORA IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCofechaconsumidor() != null) {
			where.append(" AND t2.COFECHACONSUMIDOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCofechaconsumidor()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCofechaconsumidor()
						+ "%");
			}
			where.append(" AND t2.COFECHACONSUMIDOR IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPaisId() != null) {
			where.append(" AND UPPER(t2.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PAIS_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePais() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombrePais()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombrePais()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PAIS IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreProvincia() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t2.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t2.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCalleId() != null) {
			where.append(" AND UPPER(t2.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CALLE_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCalle() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CALLE IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraCpId() != null) {
			where.append(" AND UPPER(t2.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CP_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombreCp() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CP IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNoraPortalId() != null) {
			where.append(" AND UPPER(t2.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PORTAL_ID IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePortal() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PORTAL IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCoinl21() != null) {
			where.append(" AND UPPER(t2.COINL21) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCoinl21()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCoinl21().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.COINL21 IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getCosituacion() != null) {
			where.append(" AND UPPER(t2.COSITUACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getCosituacion()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getCosituacion()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.COSITUACION IS NOT NULL");
		}
		if (consultafile != null && consultafile.getConsulta() != null
				&& consultafile.getConsulta().getNombrePiso() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getConsulta().getNombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ consultafile.getConsulta().getNombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PISO IS NOT NULL");
		}
		if (consultafile != null && consultafile.getQ4nofile() != null) {
			where.append(" AND UPPER(t1.Q4NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4nofile().toUpperCase() + "%");
			} else {
				params.add("%" + consultafile.getQ4nofile().toUpperCase() + "%");
			}
			where.append(" AND t1.Q4NOFILE IS NOT NULL");
		}
		if (consultafile != null && consultafile.getQ4sizefile() != null) {
			where.append(" AND t1.Q4SIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4sizefile() + "%");
			} else {
				params.add("%" + consultafile.getQ4sizefile() + "%");
			}
			where.append(" AND t1.Q4SIZEFILE IS NOT NULL");
		}
		if (consultafile != null && consultafile.getQ4tedesfile() != null) {
			where.append(" AND UPPER(t1.Q4TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4tedesfile().toUpperCase() + "%");
			} else {
				params.add("%" + consultafile.getQ4tedesfile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q4TEDESFILE IS NOT NULL");
		}
		if (consultafile != null && consultafile.getQ4fecha() != null) {
			where.append(" AND t1.Q4FECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4fecha() + "%");
			} else {
				params.add("%" + consultafile.getQ4fecha() + "%");
			}
			where.append(" AND t1.Q4FECHA IS NOT NULL");
		}
		if (consultafile != null && consultafile.getQ4origen() != null) {
			where.append(" AND UPPER(t1.Q4ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(consultafile.getQ4origen().toUpperCase() + "%");
			} else {
				params.add("%" + consultafile.getQ4origen().toUpperCase() + "%");
			}
			where.append(" AND t1.Q4ORIGEN IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ConsultaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21Q4T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
