package com.ejie.y41a.dao;

import java.util.Date;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.DocumentoConsultaDetalle;

/**
 * * ConsultaDao generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

public interface ConsultaDao {

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta add(Consulta consulta);

	/**
	 * Inserts a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta addConsulta(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta update(Consulta consulta);

	/**
	 * Updates a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Pagination
	 * @return Consulta
	 */
	Consulta updateRespuesta(Consulta consulta);

	/**
	 * Finds a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	Consulta find(Consulta consulta);

	/**
	 * Deletes a single row in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return
	 */
	void remove(Consulta consulta);

	/**
	 * Finds a List of rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Consulta> findAll(Consulta consulta, Pagination pagination);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return List
	 */
	Long findAllCount(Consulta consulta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Consulta> findAllLike(Consulta consulta, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	List<Consulta> findAllLikeConsulta(Consulta consulta,
			Pagination pagination, Boolean startsWith, Date fechaDesde,
			Date fechaHasta);

	/**
	 * Counts rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param startsWith
	 *            Boolean
	 * @param fechaDesde
	 *            Date
	 * @param fechaHasta
	 *            Date
	 * @return List
	 */
	Long findAllLikeConsultaCount(Consulta consulta, Boolean startsWith,
			Date fechaDesde, Date fechaHasta);

	/**
	 * Finds rows in the Consulta table using like.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<DocumentoConsultaDetalle> findAllDocumentosConsulta(Consulta consulta,
			Pagination pagination);

	/**
	 * Counts rows in the Consulta table.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Long
	 */
	Long findAllDocumentosConsultaCount(Consulta consulta);

}
