package com.ejie.y41a.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;
import javax.sql.rowset.serial.SerialBlob;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.ComunicacionFile;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.TipoComunicacion;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * ComunicacionFileDaoImpl generated by UDA, 22-feb-2012 17:30:27.
 * 
 *  
 */

@Repository
@Transactional
public class ComunicacionFileDaoImpl implements ComunicacionFileDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private DataSource dataSource;

	// private static final Logger logger = LoggerFactory
	// .getLogger(ComunicacionFileDaoImpl.class);

	private RowMapper<ComunicacionFile> rwMap = new RowMapper<ComunicacionFile>() {
		public ComunicacionFile mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ComunicacionFile(resultSet.getLong("M3COFILE"),
					resultSet.getString("M3NOFILE"),
					resultSet.getBlob("M3DATAFILE"),
					resultSet.getInt("M3SIZEFILE"),
					resultSet.getString("M3TEDESFILE"),
					resultSet.getString("M3CONTENTTYPEFILE"), new Comunicacion(
							resultSet.getLong("ComunicacionM4COCOMU"),
							new Organismo(resultSet
									.getString("ComunicacionM4COCOOR"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							resultSet.getDate("ComunicacionM4FEENV"),
							resultSet.getDate("ComunicacionM4FECAD"),
							resultSet.getString("ComunicacionM4NOREMI"),
							resultSet.getString("ComunicacionM4TESUBJECT"),
							resultSet.getString("ComunicacionM4TECOMU"),
							resultSet.getLong("ComunicacionM4NUDEST"),
							resultSet.getLong("ComunicacionM4NUFILADJ"),
							resultSet.getInt("ComunicacionM4INCOMACT"),
							resultSet.getInt("ComunicacionM4INCOMBL"),
							new TipoComunicacion(resultSet
									.getInt("ComunicacionM4COTIPO"), null,
									null, null, null, null, null, null)));
		}
	};

	/**
	 * Función especial para manejar campo LONG RAW - Spring no lo soporta
	 * 
	 */
	private List<ComunicacionFile> getMapBlob(String query) {

		ComunicacionFile comfile = null;
		List<ComunicacionFile> aCommList = new ArrayList<ComunicacionFile>();

		// StringBuffer
		Connection cn = null;
		Statement stmt = null;
		ResultSet resultSet = null;
		oracle.jdbc.OracleStatement ostmt = null;
		try {
			cn = dataSource.getConnection();
			stmt = cn.createStatement();
			// cast the statement stmt to an OracleStatement
			ostmt = (oracle.jdbc.OracleStatement) stmt;

			// redefine the LONG column at index position 1 to VARBINARY
			ostmt.defineColumnType(3, Types.VARBINARY);

			// Do a query to get the images named 'LESLIE'
			// ResultSet rset = ostmt
			// .executeQuery("select GIFDATA from streamexample where NAME='LESLIE'");
			resultSet = ostmt.executeQuery(query);

			while (resultSet.next()) {
				// The data is not streamed here
				// resultSet.next();

				byte[] file = resultSet.getBytes("M3DATAFILE");

				comfile = new ComunicacionFile(resultSet.getLong("M3COFILE"),
						resultSet.getString("M3NOFILE"), new SerialBlob(file),
						resultSet.getInt("M3SIZEFILE"),
						resultSet.getString("M3TEDESFILE"),
						resultSet.getString("M3CONTENTTYPEFILE"),
						new Comunicacion(resultSet
								.getLong("ComunicacionM4COCOMU"),
								new Organismo(resultSet
										.getString("ComunicacionM4COCOOR"),
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null, null, null,
										null, null, null, null), resultSet
										.getDate("ComunicacionM4FEENV"),
								resultSet.getDate("ComunicacionM4FECAD"),
								resultSet.getString("ComunicacionM4NOREMI"),
								resultSet.getString("ComunicacionM4TESUBJECT"),
								resultSet.getString("ComunicacionM4TECOMU"),
								resultSet.getLong("ComunicacionM4NUDEST"),
								resultSet.getLong("ComunicacionM4NUFILADJ"),
								resultSet.getInt("ComunicacionM4INCOMACT"),
								resultSet.getInt("ComunicacionM4INCOMBL"),
								new TipoComunicacion(resultSet
										.getInt("ComunicacionM4COTIPO"), null,
										null, null, null, null, null, null)));

				aCommList.add(comfile);
			}

		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {

			try {
				resultSet.close();
				stmt.close();
				ostmt.close();
				cn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}

		}

		return aCommList;
	}

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
		this.dataSource = dataSource;
	}

	/**
	 * Inserts a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return ComunicacionFile
	 */
	public ComunicacionFile add(ComunicacionFile comunicacionfile) {

		String query = "INSERT INTO COMUNICACION_FILE( M3COFILE,M3COCOMU,M3NOFILE,M3DATAFILE,M3SIZEFILE,M3TEDESFILE,M3CONTENTTYPEFILE)"
				+ "VALUES (?,?,?,?,?,?,?)";

		Object getComunicacionM4cocomuAux = null;
		if (comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			getComunicacionM4cocomuAux = comunicacionfile.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate.update(query, comunicacionfile.getM3cofile(),
				getComunicacionM4cocomuAux, comunicacionfile.getM3nofile(),
				Y41aJdbcUtils.ConvertBlobToByte(comunicacionfile
						.getM3datafile()), comunicacionfile.getM3sizefile(),
				comunicacionfile.getM3tedesfile(), comunicacionfile
						.getM3contenttypefile());
		return comunicacionfile;
	}

	/**
	 * Updates a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return ComunicacionFile
	 */
	public ComunicacionFile update(ComunicacionFile comunicacionfile) {
		String query = "UPDATE COMUNICACION_FILE SET M3COCOMU=?,M3NOFILE=?,M3DATAFILE=?,M3SIZEFILE=?,M3TEDESFILE=?,M3CONTENTTYPEFILE=? WHERE M3COFILE=?";
		Object getComunicacionM4cocomuAux = null;
		if (comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			getComunicacionM4cocomuAux = comunicacionfile.getComunicacion()
					.getM4cocomu();
		}
		this.jdbcTemplate
				.update(query, getComunicacionM4cocomuAux, comunicacionfile
						.getM3nofile(), Y41aJdbcUtils
						.ConvertBlobToByte(comunicacionfile.getM3datafile()),
						comunicacionfile.getM3sizefile(), comunicacionfile
								.getM3tedesfile(), comunicacionfile
								.getM3contenttypefile(), comunicacionfile
								.getM3cofile());
		return comunicacionfile;
	}

	/**
	 * (Change to obtain LONG RAW Field) Finds a single row in the
	 * ComunicacionFile table. Change
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return ComunicacionFile
	 */
	@Transactional(readOnly = true)
	public ComunicacionFile find(ComunicacionFile comunicacionfile) {
		StringBuffer query = new StringBuffer(Y41aConstantes.BUFFER_200);
		query.append("SELECT t1.M3COFILE M3COFILE, t1.M3NOFILE M3NOFILE, t1.M3DATAFILE M3DATAFILE, t1.M3SIZEFILE M3SIZEFILE, ");
		query.append("t1.M3TEDESFILE M3TEDESFILE, t1.M3CONTENTTYPEFILE M3CONTENTTYPEFILE, t2.M4COCOMU COMUNICACIONM4COCOMU, ");
		query.append("t2.M4COCOOR COMUNICACIONM4COCOOR, t2.M4FEENV COMUNICACIONM4FEENV, t2.M4FECAD COMUNICACIONM4FECAD, ");
		query.append("t2.M4NOREMI COMUNICACIONM4NOREMI, t2.M4TESUBJECT COMUNICACIONM4TESUBJECT, t2.M4TECOMU COMUNICACIONM4TECOMU, ");
		query.append("t2.M4NUDEST COMUNICACIONM4NUDEST, t2.M4NUFILADJ COMUNICACIONM4NUFILADJ, t2.M4INCOMACT COMUNICACIONM4INCOMACT, ");
		query.append("t2.M4INCOMBL COMUNICACIONM4INCOMBL, t2.M4COTIPO COMUNICACIONM4COTIPO ");

		query.append("FROM COMUNICACION_FILE t1 , COMUNICACION t2  ");
		query.append("WHERE t1.M3COCOMU= t2.M4COCOMU(+) ");
		query.append(" AND ");
		query.append("t1.M3COFILE = ");
		query.append(comunicacionfile.getM3cofile());

		List<ComunicacionFile> aList = (List<ComunicacionFile>) getMapBlob(query
				.toString());
		ComunicacionFile aFile = null;

		if (aList != null) {
			Iterator<ComunicacionFile> it = aList.iterator();
			if (it.hasNext()) {
				aFile = (ComunicacionFile) it.next();
			}
		}
		return aFile;
	}

	/**
	 * Finds a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return ComunicacionFile
	 */
	@Transactional(readOnly = true)
	public ComunicacionFile find_(ComunicacionFile comunicacionfile) {
		String query = "SELECT t1.M3COFILE M3COFILE, t1.M3NOFILE M3NOFILE, t1.M3DATAFILE M3DATAFILE, t1.M3SIZEFILE M3SIZEFILE, t1.M3TEDESFILE M3TEDESFILE, t1.M3CONTENTTYPEFILE M3CONTENTTYPEFILE, t2.M4COCOMU COMUNICACIONM4COCOMU, t2.M4COCOOR COMUNICACIONM4COCOOR, t2.M4FEENV COMUNICACIONM4FEENV, t2.M4FECAD COMUNICACIONM4FECAD, t2.M4NOREMI COMUNICACIONM4NOREMI, t2.M4TESUBJECT COMUNICACIONM4TESUBJECT, t2.M4TECOMU COMUNICACIONM4TECOMU, t2.M4NUDEST COMUNICACIONM4NUDEST, t2.M4NUFILADJ COMUNICACIONM4NUFILADJ, t2.M4INCOMACT COMUNICACIONM4INCOMACT, t2.M4INCOMBL COMUNICACIONM4INCOMBL, t2.M4COTIPO COMUNICACIONM4COTIPO "
				+ "FROM COMUNICACION_FILE t1 , COMUNICACION t2  "
				+ "WHERE t1.M3COFILE = ?   AND t1.M3COCOMU= t2.M4COCOMU(+)  ";
		return (ComunicacionFile) this.jdbcTemplate.queryForObject(query,
				rwMap, comunicacionfile.getM3cofile());
	}

	/**
	 * Removes a single row in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            Pagination
	 * @return
	 */
	public void remove(ComunicacionFile comunicacionfile) {
		String query = "DELETE  FROM COMUNICACION_FILE WHERE M3COFILE=?";
		this.jdbcTemplate.update(query, comunicacionfile.getM3cofile());
	}

	/**
	 * (Change to obtain LONG RAW Field) Finds a List of rows in the
	 * ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            ComunicacionFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionFile> findAll(ComunicacionFile comunicacionfile,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		where.append(" WHERE t1.M3COCOMU= t2.M4COCOMU(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M3COFILE M3COFILE,t1.M3NOFILE M3NOFILE,t1.M3DATAFILE M3DATAFILE,t1.M3SIZEFILE M3SIZEFILE,t1.M3TEDESFILE M3TEDESFILE, t1.M3CONTENTTYPEFILE M3CONTENTTYPEFILE,t2.M4COCOMU COMUNICACIONM4COCOMU,t2.M4COCOOR COMUNICACIONM4COCOOR,t2.M4FEENV COMUNICACIONM4FEENV,t2.M4FECAD COMUNICACIONM4FECAD,t2.M4NOREMI COMUNICACIONM4NOREMI,t2.M4TESUBJECT COMUNICACIONM4TESUBJECT,t2.M4TECOMU COMUNICACIONM4TECOMU,t2.M4NUDEST COMUNICACIONM4NUDEST,t2.M4NUFILADJ COMUNICACIONM4NUFILADJ,t2.M4INCOMACT COMUNICACIONM4INCOMACT,t2.M4INCOMBL COMUNICACIONM4INCOMBL,t2.M4COTIPO COMUNICACIONM4COTIPO "
						+ "FROM COMUNICACION_FILE t1 ,COMUNICACION t2 ");

		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t2.M4COCOMU = ");
			where.append(comunicacionfile.getComunicacion().getM4cocomu());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<ComunicacionFile>) getMapBlob(query.toString());

	}

	/**
	 * Finds a List of rows in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            ComunicacionFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionFile> findAll_(ComunicacionFile comunicacionfile,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M3COCOMU= t2.M4COCOMU(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M3COFILE M3COFILE,t1.M3NOFILE M3NOFILE,t1.M3DATAFILE M3DATAFILE,t1.M3SIZEFILE M3SIZEFILE,t1.M3TEDESFILE M3TEDESFILE, t1.M3CONTENTTYPEFILE M3CONTENTTYPEFILE,t2.M4COCOMU COMUNICACIONM4COCOMU,t2.M4COCOOR COMUNICACIONM4COCOOR,t2.M4FEENV COMUNICACIONM4FEENV,t2.M4FECAD COMUNICACIONM4FECAD,t2.M4NOREMI COMUNICACIONM4NOREMI,t2.M4TESUBJECT COMUNICACIONM4TESUBJECT,t2.M4TECOMU COMUNICACIONM4TECOMU,t2.M4NUDEST COMUNICACIONM4NUDEST,t2.M4NUFILADJ COMUNICACIONM4NUFILADJ,t2.M4INCOMACT COMUNICACIONM4INCOMACT,t2.M4INCOMBL COMUNICACIONM4INCOMBL,t2.M4COTIPO COMUNICACIONM4COTIPO "
						+ "FROM COMUNICACION_FILE t1 ,COMUNICACION t2 ");

		if (comunicacionfile != null && comunicacionfile.getM3cofile() != null) {
			where.append(" AND t1.M3COFILE = ?");
			params.add(comunicacionfile.getM3cofile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t2.M4COCOMU = ?");
			params.add(comunicacionfile.getComunicacion().getM4cocomu());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion()
						.getM6codigo() != null) {
			where.append(" AND t2.M4COTIPO = ?");
			params.add(comunicacionfile.getComunicacion().getTipoComunicacion()
					.getM6codigo());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getOrganismo() != null
				&& comunicacionfile.getComunicacion().getOrganismo()
						.getCodOrg() != null) {
			where.append(" AND t2.M4COCOOR = ?");
			params.add(comunicacionfile.getComunicacion().getOrganismo()
					.getCodOrg());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4feenv() != null) {
			where.append(" AND t2.M4FEENV = ?");
			params.add(comunicacionfile.getComunicacion().getM4feenv());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4fecad() != null) {
			where.append(" AND t2.M4FECAD = ?");
			params.add(comunicacionfile.getComunicacion().getM4fecad());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4noremi() != null) {
			where.append(" AND t2.M4NOREMI = ?");
			params.add(comunicacionfile.getComunicacion().getM4noremi());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tesubject() != null) {
			where.append(" AND t2.M4TESUBJECT = ?");
			params.add(comunicacionfile.getComunicacion().getM4tesubject());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tecomu() != null) {
			where.append(" AND t2.M4TECOMU = ?");
			params.add(comunicacionfile.getComunicacion().getM4tecomu());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nudest() != null) {
			where.append(" AND t2.M4NUDEST = ?");
			params.add(comunicacionfile.getComunicacion().getM4nudest());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nufiladj() != null) {
			where.append(" AND t2.M4NUFILADJ = ?");
			params.add(comunicacionfile.getComunicacion().getM4nufiladj());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incomact() != null) {
			where.append(" AND t2.M4INCOMACT = ?");
			params.add(comunicacionfile.getComunicacion().getM4incomact());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incombl() != null) {
			where.append(" AND t2.M4INCOMBL = ?");
			params.add(comunicacionfile.getComunicacion().getM4incombl());
		}
		if (comunicacionfile != null && comunicacionfile.getM3nofile() != null) {
			where.append(" AND t1.M3NOFILE = ?");
			params.add(comunicacionfile.getM3nofile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3datafile() != null) {
			where.append(" AND t1.M3DATAFILE = ?");
			params.add(comunicacionfile.getM3datafile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3sizefile() != null) {
			where.append(" AND t1.M3SIZEFILE = ?");
			params.add(comunicacionfile.getM3sizefile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3tedesfile() != null) {
			where.append(" AND t1.M3TEDESFILE = ?");
			params.add(comunicacionfile.getM3tedesfile());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}

		return (List<ComunicacionFile>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ComunicacionFile table.
	 * 
	 * @param comunicacionfile
	 *            ComunicacionFile
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ComunicacionFile comunicacionfile) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.M3COCOMU= t2.M4COCOMU(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  COMUNICACION_FILE t1   ,  COMUNICACION t2  ");
		if (comunicacionfile != null && comunicacionfile.getM3cofile() != null) {
			where.append(" AND t1.M3COFILE = ?");
			params.add(comunicacionfile.getM3cofile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t2.M4COCOMU = ?");
			params.add(comunicacionfile.getComunicacion().getM4cocomu());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion()
						.getM6codigo() != null) {
			where.append(" AND t2.M4COTIPO = ?");
			params.add(comunicacionfile.getComunicacion().getTipoComunicacion()
					.getM6codigo());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getOrganismo() != null
				&& comunicacionfile.getComunicacion().getOrganismo()
						.getCodOrg() != null) {
			where.append(" AND t2.M4COCOOR = ?");
			params.add(comunicacionfile.getComunicacion().getOrganismo()
					.getCodOrg());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4feenv() != null) {
			where.append(" AND t2.M4FEENV = ?");
			params.add(comunicacionfile.getComunicacion().getM4feenv());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4fecad() != null) {
			where.append(" AND t2.M4FECAD = ?");
			params.add(comunicacionfile.getComunicacion().getM4fecad());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4noremi() != null) {
			where.append(" AND t2.M4NOREMI = ?");
			params.add(comunicacionfile.getComunicacion().getM4noremi());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tesubject() != null) {
			where.append(" AND t2.M4TESUBJECT = ?");
			params.add(comunicacionfile.getComunicacion().getM4tesubject());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tecomu() != null) {
			where.append(" AND t2.M4TECOMU = ?");
			params.add(comunicacionfile.getComunicacion().getM4tecomu());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nudest() != null) {
			where.append(" AND t2.M4NUDEST = ?");
			params.add(comunicacionfile.getComunicacion().getM4nudest());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nufiladj() != null) {
			where.append(" AND t2.M4NUFILADJ = ?");
			params.add(comunicacionfile.getComunicacion().getM4nufiladj());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incomact() != null) {
			where.append(" AND t2.M4INCOMACT = ?");
			params.add(comunicacionfile.getComunicacion().getM4incomact());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incombl() != null) {
			where.append(" AND t2.M4INCOMBL = ?");
			params.add(comunicacionfile.getComunicacion().getM4incombl());
		}
		if (comunicacionfile != null && comunicacionfile.getM3nofile() != null) {
			where.append(" AND t1.M3NOFILE = ?");
			params.add(comunicacionfile.getM3nofile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3datafile() != null) {
			where.append(" AND t1.M3DATAFILE = ?");
			params.add(comunicacionfile.getM3datafile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3sizefile() != null) {
			where.append(" AND t1.M3SIZEFILE = ?");
			params.add(comunicacionfile.getM3sizefile());
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3tedesfile() != null) {
			where.append(" AND t1.M3TEDESFILE = ?");
			params.add(comunicacionfile.getM3tedesfile());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ComunicacionFile table using like.
	 * 
	 * @param comunicacionfile
	 *            ComunicacionFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ComunicacionFile> findAllLike(
			ComunicacionFile comunicacionfile, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.M3COCOMU= t2.M4COCOMU(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.M3COFILE M3COFILE,t1.M3NOFILE M3NOFILE,t1.M3DATAFILE M3DATAFILE,t1.M3SIZEFILE M3SIZEFILE,t1.M3TEDESFILE M3TEDESFILE, t1.M3CONTENTTYPEFILE M3CONTENTTYPEFILE,t2.M4COCOMU COMUNICACIONM4COCOMU,t2.M4COCOOR COMUNICACIONM4COCOOR,t2.M4FEENV COMUNICACIONM4FEENV,t2.M4FECAD COMUNICACIONM4FECAD,t2.M4NOREMI COMUNICACIONM4NOREMI,t2.M4TESUBJECT COMUNICACIONM4TESUBJECT,t2.M4TECOMU COMUNICACIONM4TECOMU,t2.M4NUDEST COMUNICACIONM4NUDEST,t2.M4NUFILADJ COMUNICACIONM4NUFILADJ,t2.M4INCOMACT COMUNICACIONM4INCOMACT,t2.M4INCOMBL COMUNICACIONM4INCOMBL,t2.M4COTIPO COMUNICACIONM4COTIPO "
						+ "FROM COMUNICACION_FILE t1 ,COMUNICACION t2 ");

		if (comunicacionfile != null && comunicacionfile.getM3cofile() != null) {
			where.append(" AND t1.M3COFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getM3cofile() + "%");
			} else {
				params.add("%" + comunicacionfile.getM3cofile() + "%");
			}
			where.append(" AND t1.M3COFILE IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4cocomu() != null) {
			where.append(" AND t2.M4COCOMU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4cocomu()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4cocomu()
						+ "%");
			}
			where.append(" AND t2.M4COCOMU IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion() != null
				&& comunicacionfile.getComunicacion().getTipoComunicacion()
						.getM6codigo() != null) {
			where.append(" AND t2.M4COTIPO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion()
						.getTipoComunicacion().getM6codigo()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion()
								.getTipoComunicacion().getM6codigo() + "%");
			}
			where.append(" AND t2.M4COTIPO IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getOrganismo() != null
				&& comunicacionfile.getComunicacion().getOrganismo()
						.getCodOrg() != null) {
			where.append(" AND UPPER(t2.M4COCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getOrganismo()
						.getCodOrg().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getOrganismo()
								.getCodOrg().toUpperCase() + "%");
			}
			where.append(" AND t2.M4COCOOR IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4feenv() != null) {
			where.append(" AND t2.M4FEENV like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4feenv()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4feenv() + "%");
			}
			where.append(" AND t2.M4FEENV IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4fecad() != null) {
			where.append(" AND t2.M4FECAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4fecad()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4fecad() + "%");
			}
			where.append(" AND t2.M4FECAD IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4noremi() != null) {
			where.append(" AND UPPER(t2.M4NOREMI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4noremi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4noremi()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M4NOREMI IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tesubject() != null) {
			where.append(" AND UPPER(t2.M4TESUBJECT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4tesubject()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4tesubject()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M4TESUBJECT IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4tecomu() != null) {
			where.append(" AND UPPER(t2.M4TECOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4tecomu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4tecomu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.M4TECOMU IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nudest() != null) {
			where.append(" AND t2.M4NUDEST like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4nudest()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4nudest()
						+ "%");
			}
			where.append(" AND t2.M4NUDEST IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4nufiladj() != null) {
			where.append(" AND t2.M4NUFILADJ like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4nufiladj()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4nufiladj()
						+ "%");
			}
			where.append(" AND t2.M4NUFILADJ IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incomact() != null) {
			where.append(" AND t2.M4INCOMACT like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4incomact()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4incomact()
						+ "%");
			}
			where.append(" AND t2.M4INCOMACT IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getComunicacion() != null
				&& comunicacionfile.getComunicacion().getM4incombl() != null) {
			where.append(" AND t2.M4INCOMBL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getComunicacion().getM4incombl()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getComunicacion().getM4incombl()
						+ "%");
			}
			where.append(" AND t2.M4INCOMBL IS NOT NULL");
		}
		if (comunicacionfile != null && comunicacionfile.getM3nofile() != null) {
			where.append(" AND UPPER(t1.M3NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getM3nofile().toUpperCase() + "%");
			} else {
				params.add("%" + comunicacionfile.getM3nofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.M3NOFILE IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3datafile() != null) {
			where.append(" AND t1.M3DATAFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getM3datafile() + "%");
			} else {
				params.add("%" + comunicacionfile.getM3datafile() + "%");
			}
			where.append(" AND t1.M3DATAFILE IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3sizefile() != null) {
			where.append(" AND t1.M3SIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getM3sizefile() + "%");
			} else {
				params.add("%" + comunicacionfile.getM3sizefile() + "%");
			}
			where.append(" AND t1.M3SIZEFILE IS NOT NULL");
		}
		if (comunicacionfile != null
				&& comunicacionfile.getM3tedesfile() != null) {
			where.append(" AND UPPER(t1.M3TEDESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(comunicacionfile.getM3tedesfile().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ comunicacionfile.getM3tedesfile().toUpperCase() + "%");
			}
			where.append(" AND t1.M3TEDESFILE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ComunicacionFile>) this.jdbcTemplate.query(
				query.toString(), rwMap, params.toArray());
	}

	/**
	 * Get a New PK.
	 * 
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long getNewPK() {

		List<Object> params = new ArrayList<Object>();

		StringBuffer query = new StringBuffer(
				"SELECT SEQ_L21M3T00.NEXTVAL FROM  DUAL ");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
