package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Pais;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Comaut;

/**
 *  * ComautDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class ComautDaoImpl implements ComautDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Comaut> rwMap = new RowMapper<Comaut>() {
		public Comaut mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Comaut(
               resultSet.getString("CACODIGO"), resultSet.getString("CANOMBRE"), new Pais(resultSet.getString("PaisPACODIGO"), resultSet.getString("PaisPACOAL2"), resultSet.getString("PaisPACOAL3"), resultSet.getString("PaisPANOMBRE"))
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Comaut table.
     *
     * @param comaut Pagination
     * @return Comaut
     */
	public Comaut add(Comaut comaut) {

    	String query = "INSERT INTO COMAUT( CACODIGO,CACOPA,CANOMBRE)"
        + "VALUES (?,?,?)";

				   Object getPaisPacodigoAux=null;
		     if (comaut.getPais()!= null  && comaut.getPais().getPacodigo()!=null ){
			     getPaisPacodigoAux=comaut.getPais().getPacodigo();
		   	  }
		this.jdbcTemplate.update(query, comaut.getCacodigo(), getPaisPacodigoAux, comaut.getCanombre());
		return comaut;
	}

    /**
     * Updates a single row in the Comaut table.
     *
     * @param comaut Pagination
     * @return Comaut
     */
    public Comaut update(Comaut comaut) {
		String query = "UPDATE COMAUT SET CACOPA=?,CANOMBRE=? WHERE CACODIGO=?";
				Object getPaisPacodigoAux=null;
				if (comaut.getPais()!= null   && comaut.getPais().getPacodigo()!=null ){
					getPaisPacodigoAux=comaut.getPais().getPacodigo();
				}
		this.jdbcTemplate.update(query, getPaisPacodigoAux, comaut.getCanombre(), comaut.getCacodigo());
		return comaut;
	}

    /**
     * Finds a single row in the Comaut table.
     *
     * @param comaut Pagination
     * @return Comaut
     */
    @Transactional (readOnly = true)
    public Comaut find(Comaut comaut) {
		String query = "SELECT t1.CACODIGO CACODIGO, t1.CANOMBRE CANOMBRE, t2.PACODIGO PAISPACODIGO, t2.PACOAL2 PAISPACOAL2, t2.PACOAL3 PAISPACOAL3, t2.PANOMBRE PAISPANOMBRE " 
         + "FROM COMAUT t1 , PAIS t2  " 
         + "WHERE t1.CACODIGO = ?   AND t1.CACOPA= t2.PACODIGO(+)  ";
		return (Comaut) this.jdbcTemplate.queryForObject(query, 
			rwMap , comaut.getCacodigo());	 
    }

    /**
     * Removes a single row in the Comaut table.
     *
     * @param comaut Pagination
     * @return
     */
    public void remove(Comaut comaut) {
		String query = "DELETE  FROM COMAUT WHERE CACODIGO=?";
		this.jdbcTemplate.update(query, comaut.getCacodigo());
    	}
    
   /**
    * Finds a List of rows in the Comaut table.
    * 
    * @param comaut Comaut
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Comaut> findAll(Comaut comaut, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CACOPA= t2.PACODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CACODIGO CACODIGO,t1.CANOMBRE CANOMBRE,t2.PACODIGO PAISPACODIGO,t2.PACOAL2 PAISPACOAL2,t2.PACOAL3 PAISPACOAL3,t2.PANOMBRE PAISPANOMBRE " 
			+ "FROM COMAUT t1 ,PAIS t2 ");
		
		if (comaut  != null  && comaut.getCacodigo() != null ) {
			where.append(" AND t1.CACODIGO = ?");
			params.add(comaut.getCacodigo());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacodigo() != null ) {
			where.append(" AND t2.PACODIGO = ?");
			params.add(comaut.getPais().getPacodigo());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal2() != null ) {
			where.append(" AND t2.PACOAL2 = ?");
			params.add(comaut.getPais().getPacoal2());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal3() != null ) {
			where.append(" AND t2.PACOAL3 = ?");
			params.add(comaut.getPais().getPacoal3());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPanombre() != null ) {
			where.append(" AND t2.PANOMBRE = ?");
			params.add(comaut.getPais().getPanombre());
		}
		if (comaut  != null  && comaut.getCanombre() != null ) {
			where.append(" AND t1.CANOMBRE = ?");
			params.add(comaut.getCanombre());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Comaut>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Comaut table.
     * 
     * @param comaut Comaut
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Comaut comaut) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.CACOPA= t2.PACODIGO(+) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  COMAUT t1   ,  PAIS t2  ");
		if (comaut  != null  && comaut.getCacodigo() != null ) {
			where.append(" AND t1.CACODIGO = ?");
			params.add(comaut.getCacodigo());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacodigo() != null ) {
			where.append(" AND t2.PACODIGO = ?");
			params.add(comaut.getPais().getPacodigo());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal2() != null ) {
			where.append(" AND t2.PACOAL2 = ?");
			params.add(comaut.getPais().getPacoal2());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal3() != null ) {
			where.append(" AND t2.PACOAL3 = ?");
			params.add(comaut.getPais().getPacoal3());
		}
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPanombre() != null ) {
			where.append(" AND t2.PANOMBRE = ?");
			params.add(comaut.getPais().getPanombre());
		}
		if (comaut  != null  && comaut.getCanombre() != null ) {
			where.append(" AND t1.CANOMBRE = ?");
			params.add(comaut.getCanombre());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Comaut table using like.
     * 
     * @param comaut Comaut
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Comaut> findAllLike(Comaut comaut, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CACOPA= t2.PACODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CACODIGO CACODIGO,t1.CANOMBRE CANOMBRE,t2.PACODIGO PAISPACODIGO,t2.PACOAL2 PAISPACOAL2,t2.PACOAL3 PAISPACOAL3,t2.PANOMBRE PAISPANOMBRE " 
        	+ "FROM COMAUT t1 ,PAIS t2 ");
      	
		if (comaut  != null  && comaut.getCacodigo() != null ) {
			where.append(" AND UPPER(t1.CACODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getCacodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+comaut.getCacodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.CACODIGO IS NOT NULL");
        }
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacodigo() != null ) {
			where.append(" AND t2.PACODIGO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getPais().getPacodigo()  +"%");
			}else{
				params.add("%"+comaut.getPais().getPacodigo() +"%");
			}	
			where.append(" AND t2.PACODIGO IS NOT NULL");
        }
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal2() != null ) {
			where.append(" AND UPPER(t2.PACOAL2) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getPais().getPacoal2().toUpperCase()  +"%");
			}else{
				params.add("%"+comaut.getPais().getPacoal2().toUpperCase() +"%");
			}	
			where.append(" AND t2.PACOAL2 IS NOT NULL");
        }
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPacoal3() != null ) {
			where.append(" AND UPPER(t2.PACOAL3) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getPais().getPacoal3().toUpperCase()  +"%");
			}else{
				params.add("%"+comaut.getPais().getPacoal3().toUpperCase() +"%");
			}	
			where.append(" AND t2.PACOAL3 IS NOT NULL");
        }
		if (comaut!=null && comaut.getPais() != null  && comaut.getPais().getPanombre() != null ) {
			where.append(" AND UPPER(t2.PANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getPais().getPanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+comaut.getPais().getPanombre().toUpperCase() +"%");
			}	
			where.append(" AND t2.PANOMBRE IS NOT NULL");
        }
		if (comaut  != null  && comaut.getCanombre() != null ) {
			where.append(" AND UPPER(t1.CANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(comaut.getCanombre().toUpperCase()  +"%");
			}else{
				params.add("%"+comaut.getCanombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.CANOMBRE IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Comaut>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

