package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Organismo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.CensoMonitor;

/**
 * * CensoMonitorDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 * 
 *  
 */

@Repository
@Transactional
public class CensoMonitorDaoImpl implements CensoMonitorDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<CensoMonitor> rwMap = new RowMapper<CensoMonitor>() {
		public CensoMonitor mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CensoMonitor(resultSet.getString("MOCODIGO"),
					resultSet.getString("MONOMBRE"),
					resultSet.getString("MOCOEM"),
					resultSet.getString("MOUSU"),
					resultSet.getString("MOCLAVE"),
					resultSet.getDate("MOFECBAJA"),
					resultSet.getString("MOADMIN"),
					resultSet.getString("MOPRIMERA"), new Organismo(
							resultSet.getString("OrganismoCODORG"),
							resultSet.getString("OrganismoENTIDADID"),
							resultSet.getString("OrganismoNOMBREES"),
							resultSet.getString("OrganismoNOMBREEU"),
							resultSet.getString("OrganismoACTIVA"),
							resultSet.getString("OrganismoISKONTSUMOGEST"),
							resultSet.getString("OrganismoISKONTSUMONET"),
							resultSet.getString("OrganismoISOFERTAFORM"),
							resultSet.getString("OrganismoISCONSULTASWEB"),
							resultSet.getString("OrganismoISNACIONAL"),
							resultSet.getString("OrganismoOBSERVACIONES"),
							resultSet.getString("OrganismoTELEFONO"),
							resultSet.getString("OrganismoFAX"),
							resultSet.getString("OrganismoEMAIL"),
							resultSet.getString("OrganismoURL"),
							resultSet.getString("OrganismoUSUARIO"),
							resultSet.getString("OrganismoPASSWORD"),
							resultSet.getString("OrganismoNORAPAISID"),
							resultSet.getString("OrganismoNOMBREPAIS"),
							resultSet.getString("OrganismoNORAPROVINCIAID"),
							resultSet.getString("OrganismoNOMBREPROVINCIA"),
							resultSet.getString("OrganismoNORAMUNICIPIOID"),
							resultSet.getString("OrganismoNOMBREMUNICIPIO"),
							resultSet.getString("OrganismoNORALOCALIDADID"),
							resultSet.getString("OrganismoNOMBRELOCALIDAD"),
							resultSet.getString("OrganismoNORACALLEID"),
							resultSet.getString("OrganismoNOMBRECALLE"),
							resultSet.getString("OrganismoNORACPID"),
							resultSet.getString("OrganismoNOMBRECP"),
							resultSet.getString("OrganismoNORAPORTALID"),
							resultSet.getString("OrganismoNOMBREPORTAL"),
							resultSet.getString("OrganismoUSUULTMOD"),
							resultSet.getDate("OrganismoFECULTMOD")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	public CensoMonitor add(CensoMonitor censomonitor) {

		String query = "INSERT INTO CENSO_MONITOR( MOCODIGO,MOCOOR,MONOMBRE,MOCOEM,MOUSU,MOCLAVE,MOFECBAJA,MOADMIN,MOPRIMERA) "
				+ "VALUES ((SELECT MOCODIGO FROM MONITOR_POSIBLE WHERE MOCODIGO NOT IN (SELECT MOCODIGO FROM CENSO_MONITOR) AND ROWNUM=1),?,?,?,?,?,?,?,?)";

		Object getOrganismoCodOrgAux = null;
		if (censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = censomonitor.getOrganismo().getCodOrg();
		}
		this.jdbcTemplate.update(query, getOrganismoCodOrgAux,
				censomonitor.getMonombre(), censomonitor.getMocoem(),
				censomonitor.getMousu(), censomonitor.getMoclave(),
				censomonitor.getMofecbaja(), censomonitor.getMoadmin(),
				censomonitor.getMoprimera());
		return censomonitor;
	}

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	public CensoMonitor update(CensoMonitor censomonitor) {
		String query = "UPDATE CENSO_MONITOR SET MOCOOR=?,MONOMBRE=?,MOCOEM=?,MOUSU=?,MOCLAVE=?,MOFECBAJA=?,MOADMIN=?,MOPRIMERA=? WHERE MOCODIGO=?";
		Object getOrganismoCodOrgAux = null;
		if (censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			getOrganismoCodOrgAux = censomonitor.getOrganismo().getCodOrg();
		}
		this.jdbcTemplate.update(query, getOrganismoCodOrgAux,
				censomonitor.getMonombre(), censomonitor.getMocoem(),
				censomonitor.getMousu(), censomonitor.getMoclave(),
				censomonitor.getMofecbaja(), censomonitor.getMoadmin(),
				censomonitor.getMoprimera(), censomonitor.getMocodigo());
		return censomonitor;
	}

	/**
	 * Updates a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	public CensoMonitor updatePassword(CensoMonitor censomonitor) {
		String query = "UPDATE CENSO_MONITOR SET MOCLAVE=?,MOPRIMERA=? WHERE MOCODIGO=?";

		this.jdbcTemplate.update(query, censomonitor.getMoclave(),
				censomonitor.getMoprimera(), censomonitor.getMocodigo());
		return censomonitor;
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	@Transactional(readOnly = true)
	public CensoMonitor find(CensoMonitor censomonitor) {
		String query = "SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, t1.MOCOEM MOCOEM, t1.MOUSU MOUSU, t1.MOCLAVE MOCLAVE, t1.MOFECBAJA MOFECBAJA, t1.MOADMIN MOADMIN, t1.MOPRIMERA MOPRIMERA, t2.COD_ORG ORGANISMOCODORG, t2.ENTIDAD_ID ORGANISMOENTIDADID, t2.NOMBRE_ES ORGANISMONOMBREES, t2.NOMBRE_EU ORGANISMONOMBREEU, t2.ACTIVA ORGANISMOACTIVA, t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t2.ISKONTSUMONET ORGANISMOISKONTSUMONET, t2.ISOFERTAFORM ORGANISMOISOFERTAFORM, t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t2.ISNACIONAL ORGANISMOISNACIONAL, t2.OBSERVACIONES ORGANISMOOBSERVACIONES, t2.TELEFONO ORGANISMOTELEFONO, t2.FAX ORGANISMOFAX, t2.EMAIL ORGANISMOEMAIL, t2.URL ORGANISMOURL, t2.USUARIO ORGANISMOUSUARIO, t2.PASSWORD ORGANISMOPASSWORD, t2.NORA_PAIS_ID ORGANISMONORAPAISID, t2.NOMBRE_PAIS ORGANISMONOMBREPAIS, t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t2.NORA_CALLE_ID ORGANISMONORACALLEID, t2.NOMBRE_CALLE ORGANISMONOMBRECALLE, t2.NORA_CP_ID ORGANISMONORACPID, t2.NOMBRE_CP ORGANISMONOMBRECP, t2.NORA_PORTAL_ID ORGANISMONORAPORTALID, t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t2.USUULTMOD ORGANISMOUSUULTMOD, t2.FECULTMOD ORGANISMOFECULTMOD "
				+ "FROM CENSO_MONITOR t1 , ORGANISMO t2  "
				+ "WHERE t1.MOCODIGO = ?   AND t1.MOCOOR= t2.COD_ORG(+)  ";
		return (CensoMonitor) this.jdbcTemplate.queryForObject(query, rwMap,
				censomonitor.getMocodigo());
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	@Transactional(readOnly = true)
	public CensoMonitor findCensoMonitorUser(CensoMonitor censomonitor) {
		String query = "SELECT t1.MOCODIGO MOCODIGO, t1.MONOMBRE MONOMBRE, t1.MOCOEM MOCOEM, t1.MOUSU MOUSU, t1.MOCLAVE MOCLAVE, t1.MOFECBAJA MOFECBAJA, t1.MOADMIN MOADMIN, t1.MOPRIMERA MOPRIMERA, t2.COD_ORG ORGANISMOCODORG, t2.ENTIDAD_ID ORGANISMOENTIDADID, t2.NOMBRE_ES ORGANISMONOMBREES, t2.NOMBRE_EU ORGANISMONOMBREEU, t2.ACTIVA ORGANISMOACTIVA, t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST, t2.ISKONTSUMONET ORGANISMOISKONTSUMONET, t2.ISOFERTAFORM ORGANISMOISOFERTAFORM, t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB, t2.ISNACIONAL ORGANISMOISNACIONAL, t2.OBSERVACIONES ORGANISMOOBSERVACIONES, t2.TELEFONO ORGANISMOTELEFONO, t2.FAX ORGANISMOFAX, t2.EMAIL ORGANISMOEMAIL, t2.URL ORGANISMOURL, t2.USUARIO ORGANISMOUSUARIO, t2.PASSWORD ORGANISMOPASSWORD, t2.NORA_PAIS_ID ORGANISMONORAPAISID, t2.NOMBRE_PAIS ORGANISMONOMBREPAIS, t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID, t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA, t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID, t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO, t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID, t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD, t2.NORA_CALLE_ID ORGANISMONORACALLEID, t2.NOMBRE_CALLE ORGANISMONOMBRECALLE, t2.NORA_CP_ID ORGANISMONORACPID, t2.NOMBRE_CP ORGANISMONOMBRECP, t2.NORA_PORTAL_ID ORGANISMONORAPORTALID, t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL, t2.USUULTMOD ORGANISMOUSUULTMOD, t2.FECULTMOD ORGANISMOFECULTMOD "
				+ "FROM CENSO_MONITOR t1 , ORGANISMO t2  "
				+ "WHERE t1.MOUSU = ?   AND t1.MOCOOR= t2.COD_ORG(+)  ";
		return (CensoMonitor) this.jdbcTemplate.queryForObject(query, rwMap,
				censomonitor.getMousu());
	}

	/**
	 * Removes a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return
	 */
	public void remove(CensoMonitor censomonitor) {
		String query = "DELETE  FROM CENSO_MONITOR WHERE MOCODIGO=?";
		this.jdbcTemplate.update(query, censomonitor.getMocodigo());
	}

	/**
	 * Finds a List of rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CensoMonitor> findAll(CensoMonitor censomonitor,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.MOCOOR= t2.COD_ORG(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.MOCODIGO MOCODIGO,t1.MONOMBRE MONOMBRE,t1.MOCOEM MOCOEM,t1.MOUSU MOUSU,t1.MOCLAVE MOCLAVE,t1.MOFECBAJA MOFECBAJA,t1.MOADMIN MOADMIN,t1.MOPRIMERA MOPRIMERA,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM CENSO_MONITOR t1 ,ORGANISMO t2 ");

		if (censomonitor != null && censomonitor.getMocodigo() != null) {
			where.append(" AND t1.MOCODIGO = ?");
			params.add(censomonitor.getMocodigo());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(censomonitor.getOrganismo().getCodOrg());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(censomonitor.getOrganismo().getEntidadId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(censomonitor.getOrganismo().getNombreEs());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(censomonitor.getOrganismo().getNombreEu());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(censomonitor.getOrganismo().getActiva());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(censomonitor.getOrganismo().getIskontsumogest());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(censomonitor.getOrganismo().getIskontsumonet());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(censomonitor.getOrganismo().getIsofertaform());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(censomonitor.getOrganismo().getIsconsultasweb());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(censomonitor.getOrganismo().getIsnacional());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(censomonitor.getOrganismo().getObservaciones());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(censomonitor.getOrganismo().getTelefono());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(censomonitor.getOrganismo().getFax());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(censomonitor.getOrganismo().getEmail());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(censomonitor.getOrganismo().getUrl());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(censomonitor.getOrganismo().getUsuario());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(censomonitor.getOrganismo().getPassword());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraPaisId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(censomonitor.getOrganismo().getNombrePais());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraProvinciaId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(censomonitor.getOrganismo().getNombreProvincia());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraMunicipioId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(censomonitor.getOrganismo().getNombreMunicipio());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraLocalidadId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(censomonitor.getOrganismo().getNombreLocalidad());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraCalleId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(censomonitor.getOrganismo().getNombreCalle());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraCpId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(censomonitor.getOrganismo().getNombreCp());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraPortalId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(censomonitor.getOrganismo().getNombrePortal());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(censomonitor.getOrganismo().getUsuultmod());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(censomonitor.getOrganismo().getFecultmod());
		}
		if (censomonitor != null && censomonitor.getMonombre() != null) {
			where.append(" AND t1.MONOMBRE = ?");
			params.add(censomonitor.getMonombre());
		}
		if (censomonitor != null && censomonitor.getMocoem() != null) {
			where.append(" AND t1.MOCOEM = ?");
			params.add(censomonitor.getMocoem());
		}
		if (censomonitor != null && censomonitor.getMousu() != null) {
			where.append(" AND t1.MOUSU = ?");
			params.add(censomonitor.getMousu());
		}
		if (censomonitor != null && censomonitor.getMoclave() != null) {
			where.append(" AND t1.MOCLAVE = ?");
			params.add(censomonitor.getMoclave());
		}
		if (censomonitor != null && censomonitor.getMofecbaja() != null) {
			where.append(" AND t1.MOFECBAJA = ?");
			params.add(censomonitor.getMofecbaja());
		}
		if (censomonitor != null && censomonitor.getMoadmin() != null) {
			where.append(" AND t1.MOADMIN = ?");
			params.add(censomonitor.getMoadmin());
		}
		if (censomonitor != null && censomonitor.getMoprimera() != null) {
			where.append(" AND t1.MOPRIMERA = ?");
			params.add(censomonitor.getMoprimera());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CensoMonitor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CensoMonitor censomonitor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.MOCOOR= t2.COD_ORG(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CENSO_MONITOR t1   ,  ORGANISMO t2  ");
		if (censomonitor != null && censomonitor.getMocodigo() != null) {
			where.append(" AND t1.MOCODIGO = ?");
			params.add(censomonitor.getMocodigo());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(censomonitor.getOrganismo().getCodOrg());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEntidadId() != null) {
			where.append(" AND t2.ENTIDAD_ID = ?");
			params.add(censomonitor.getOrganismo().getEntidadId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEs() != null) {
			where.append(" AND t2.NOMBRE_ES = ?");
			params.add(censomonitor.getOrganismo().getNombreEs());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEu() != null) {
			where.append(" AND t2.NOMBRE_EU = ?");
			params.add(censomonitor.getOrganismo().getNombreEu());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getActiva() != null) {
			where.append(" AND t2.ACTIVA = ?");
			params.add(censomonitor.getOrganismo().getActiva());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND t2.ISKONTSUMOGEST = ?");
			params.add(censomonitor.getOrganismo().getIskontsumogest());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND t2.ISKONTSUMONET = ?");
			params.add(censomonitor.getOrganismo().getIskontsumonet());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsofertaform() != null) {
			where.append(" AND t2.ISOFERTAFORM = ?");
			params.add(censomonitor.getOrganismo().getIsofertaform());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND t2.ISCONSULTASWEB = ?");
			params.add(censomonitor.getOrganismo().getIsconsultasweb());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsnacional() != null) {
			where.append(" AND t2.ISNACIONAL = ?");
			params.add(censomonitor.getOrganismo().getIsnacional());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getObservaciones() != null) {
			where.append(" AND t2.OBSERVACIONES = ?");
			params.add(censomonitor.getOrganismo().getObservaciones());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getTelefono() != null) {
			where.append(" AND t2.TELEFONO = ?");
			params.add(censomonitor.getOrganismo().getTelefono());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFax() != null) {
			where.append(" AND t2.FAX = ?");
			params.add(censomonitor.getOrganismo().getFax());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEmail() != null) {
			where.append(" AND t2.EMAIL = ?");
			params.add(censomonitor.getOrganismo().getEmail());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUrl() != null) {
			where.append(" AND t2.URL = ?");
			params.add(censomonitor.getOrganismo().getUrl());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuario() != null) {
			where.append(" AND t2.USUARIO = ?");
			params.add(censomonitor.getOrganismo().getUsuario());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getPassword() != null) {
			where.append(" AND t2.PASSWORD = ?");
			params.add(censomonitor.getOrganismo().getPassword());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND t2.NORA_PAIS_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraPaisId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePais() != null) {
			where.append(" AND t2.NOMBRE_PAIS = ?");
			params.add(censomonitor.getOrganismo().getNombrePais());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND t2.NORA_PROVINCIA_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraProvinciaId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND t2.NOMBRE_PROVINCIA = ?");
			params.add(censomonitor.getOrganismo().getNombreProvincia());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND t2.NORA_MUNICIPIO_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraMunicipioId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND t2.NOMBRE_MUNICIPIO = ?");
			params.add(censomonitor.getOrganismo().getNombreMunicipio());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND t2.NORA_LOCALIDAD_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraLocalidadId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND t2.NOMBRE_LOCALIDAD = ?");
			params.add(censomonitor.getOrganismo().getNombreLocalidad());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND t2.NORA_CALLE_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraCalleId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCalle() != null) {
			where.append(" AND t2.NOMBRE_CALLE = ?");
			params.add(censomonitor.getOrganismo().getNombreCalle());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCpId() != null) {
			where.append(" AND t2.NORA_CP_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraCpId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCp() != null) {
			where.append(" AND t2.NOMBRE_CP = ?");
			params.add(censomonitor.getOrganismo().getNombreCp());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND t2.NORA_PORTAL_ID = ?");
			params.add(censomonitor.getOrganismo().getNoraPortalId());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePortal() != null) {
			where.append(" AND t2.NOMBRE_PORTAL = ?");
			params.add(censomonitor.getOrganismo().getNombrePortal());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuultmod() != null) {
			where.append(" AND t2.USUULTMOD = ?");
			params.add(censomonitor.getOrganismo().getUsuultmod());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD = ?");
			params.add(censomonitor.getOrganismo().getFecultmod());
		}
		if (censomonitor != null && censomonitor.getMonombre() != null) {
			where.append(" AND t1.MONOMBRE = ?");
			params.add(censomonitor.getMonombre());
		}
		if (censomonitor != null && censomonitor.getMocoem() != null) {
			where.append(" AND t1.MOCOEM = ?");
			params.add(censomonitor.getMocoem());
		}
		if (censomonitor != null && censomonitor.getMousu() != null) {
			where.append(" AND t1.MOUSU = ?");
			params.add(censomonitor.getMousu());
		}
		if (censomonitor != null && censomonitor.getMoclave() != null) {
			where.append(" AND t1.MOCLAVE = ?");
			params.add(censomonitor.getMoclave());
		}
		if (censomonitor != null && censomonitor.getMofecbaja() != null) {
			where.append(" AND t1.MOFECBAJA = ?");
			params.add(censomonitor.getMofecbaja());
		}
		if (censomonitor != null && censomonitor.getMoadmin() != null) {
			where.append(" AND t1.MOADMIN = ?");
			params.add(censomonitor.getMoadmin());
		}
		if (censomonitor != null && censomonitor.getMoprimera() != null) {
			where.append(" AND t1.MOPRIMERA = ?");
			params.add(censomonitor.getMoprimera());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CensoMonitor table using like.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CensoMonitor> findAllLike(CensoMonitor censomonitor,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.MOCOOR= t2.COD_ORG(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.MOCODIGO MOCODIGO,t1.MONOMBRE MONOMBRE,t1.MOCOEM MOCOEM,t1.MOUSU MOUSU,t1.MOCLAVE MOCLAVE,t1.MOFECBAJA MOFECBAJA,t1.MOADMIN MOADMIN,t1.MOPRIMERA MOPRIMERA,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM CENSO_MONITOR t1 ,ORGANISMO t2 ");

		if (censomonitor != null && censomonitor.getMocodigo() != null) {
			where.append(" AND UPPER(t1.MOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCODIGO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getCodOrg() + "%");
			} else {
				params.add("%" + censomonitor.getOrganismo().getCodOrg() + "%");
			}
			where.append(" AND t2.COD_ORG IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEntidadId() != null) {
			where.append(" AND UPPER(t2.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEntidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEntidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ENTIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getActiva() != null) {
			where.append(" AND UPPER(t2.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getActiva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getActiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACTIVA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumogest()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumogest()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMOGEST IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumonet()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumonet()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMONET IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsofertaform() != null) {
			where.append(" AND UPPER(t2.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsofertaform()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsofertaform()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISOFERTAFORM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND UPPER(t2.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsconsultasweb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsconsultasweb()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISCONSULTASWEB IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsnacional() != null) {
			where.append(" AND UPPER(t2.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsnacional()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsnacional()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISNACIONAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getObservaciones() != null) {
			where.append(" AND UPPER(t2.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.OBSERVACIONES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getTelefono() != null) {
			where.append(" AND UPPER(t2.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getTelefono()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getTelefono()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TELEFONO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFax() != null) {
			where.append(" AND UPPER(t2.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.FAX IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEmail() != null) {
			where.append(" AND UPPER(t2.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EMAIL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUrl() != null) {
			where.append(" AND UPPER(t2.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.URL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuario() != null) {
			where.append(" AND UPPER(t2.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuario()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuario()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUARIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getPassword() != null) {
			where.append(" AND UPPER(t2.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getPassword()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getPassword()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PASSWORD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND UPPER(t2.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PAIS_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePais() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePais()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePais()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PAIS IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t2.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t2.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND UPPER(t2.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CALLE_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCalle() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CALLE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCpId() != null) {
			where.append(" AND UPPER(t2.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CP_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCp() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CP IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND UPPER(t2.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PORTAL_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePortal() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PORTAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuultmod() != null) {
			where.append(" AND UPPER(t2.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuultmod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuultmod()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFecultmod() + "%");
			} else {
				params.add("%" + censomonitor.getOrganismo().getFecultmod()
						+ "%");
			}
			where.append(" AND t2.FECULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMonombre() != null) {
			where.append(" AND UPPER(t1.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t1.MONOMBRE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMocoem() != null) {
			where.append(" AND UPPER(t1.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCOEM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMousu() != null) {
			where.append(" AND UPPER(t1.MOUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMousu().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMousu().toUpperCase() + "%");
			}
			where.append(" AND t1.MOUSU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoclave() != null) {
			where.append(" AND UPPER(t1.MOCLAVE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoclave().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoclave().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCLAVE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMofecbaja() != null) {
			where.append(" AND t1.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMofecbaja() + "%");
			} else {
				params.add("%" + censomonitor.getMofecbaja() + "%");
			}
			where.append(" AND t1.MOFECBAJA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoadmin() != null) {
			where.append(" AND UPPER(t1.MOADMIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoadmin().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoadmin().toUpperCase() + "%");
			}
			where.append(" AND t1.MOADMIN IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoprimera() != null) {
			where.append(" AND UPPER(t1.MOPRIMERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoprimera().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoprimera().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MOPRIMERA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CensoMonitor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CensoMonitor> findAllLikeFilter(CensoMonitor censomonitor,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.MOCOOR= t2.COD_ORG(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.MOCODIGO MOCODIGO,t1.MONOMBRE MONOMBRE,t1.MOCOEM MOCOEM,t1.MOUSU MOUSU,t1.MOCLAVE MOCLAVE,t1.MOFECBAJA MOFECBAJA,t1.MOADMIN MOADMIN,t1.MOPRIMERA MOPRIMERA,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM CENSO_MONITOR t1 ,ORGANISMO t2 ");

		if (censomonitor != null && censomonitor.getMocodigo() != null) {
			where.append(" AND UPPER(t1.MOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCODIGO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(censomonitor.getOrganismo().getCodOrg());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEntidadId() != null) {
			where.append(" AND UPPER(t2.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEntidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEntidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ENTIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getActiva() != null) {
			where.append(" AND UPPER(t2.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getActiva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getActiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACTIVA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumogest()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumogest()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMOGEST IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumonet()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumonet()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMONET IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsofertaform() != null) {
			where.append(" AND UPPER(t2.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsofertaform()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsofertaform()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISOFERTAFORM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND UPPER(t2.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsconsultasweb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsconsultasweb()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISCONSULTASWEB IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsnacional() != null) {
			where.append(" AND UPPER(t2.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsnacional()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsnacional()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISNACIONAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getObservaciones() != null) {
			where.append(" AND UPPER(t2.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.OBSERVACIONES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getTelefono() != null) {
			where.append(" AND UPPER(t2.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getTelefono()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getTelefono()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TELEFONO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFax() != null) {
			where.append(" AND UPPER(t2.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.FAX IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEmail() != null) {
			where.append(" AND UPPER(t2.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EMAIL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUrl() != null) {
			where.append(" AND UPPER(t2.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.URL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuario() != null) {
			where.append(" AND UPPER(t2.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuario()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuario()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUARIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getPassword() != null) {
			where.append(" AND UPPER(t2.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getPassword()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getPassword()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PASSWORD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND UPPER(t2.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PAIS_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePais() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePais()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePais()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PAIS IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t2.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t2.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND UPPER(t2.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CALLE_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCalle() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CALLE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCpId() != null) {
			where.append(" AND UPPER(t2.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CP_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCp() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CP IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND UPPER(t2.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PORTAL_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePortal() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PORTAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuultmod() != null) {
			where.append(" AND UPPER(t2.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuultmod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuultmod()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFecultmod() + "%");
			} else {
				params.add("%" + censomonitor.getOrganismo().getFecultmod()
						+ "%");
			}
			where.append(" AND t2.FECULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMonombre() != null) {
			where.append(" AND UPPER(t1.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t1.MONOMBRE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMocoem() != null) {
			where.append(" AND UPPER(t1.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCOEM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMousu() != null) {
			where.append(" AND UPPER(t1.MOUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMousu().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMousu().toUpperCase() + "%");
			}
			where.append(" AND t1.MOUSU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoclave() != null) {
			where.append(" AND UPPER(t1.MOCLAVE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoclave().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoclave().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCLAVE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMofecbaja() != null) {
			where.append(" AND t1.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMofecbaja() + "%");
			} else {
				params.add("%" + censomonitor.getMofecbaja() + "%");
			}
			where.append(" AND t1.MOFECBAJA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoadmin() != null) {
			where.append(" AND UPPER(t1.MOADMIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoadmin().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoadmin().toUpperCase() + "%");
			}
			where.append(" AND t1.MOADMIN IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoprimera() != null) {
			where.append(" AND UPPER(t1.MOPRIMERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoprimera().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoprimera().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MOPRIMERA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CensoMonitor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCountFilter(CensoMonitor censomonitor,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.MOCOOR= t2.COD_ORG(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CENSO_MONITOR t1   ,  ORGANISMO t2  ");
		if (censomonitor != null && censomonitor.getMocodigo() != null) {
			where.append(" AND UPPER(t1.MOCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocodigo().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCODIGO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(censomonitor.getOrganismo().getCodOrg());
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEntidadId() != null) {
			where.append(" AND UPPER(t2.ENTIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEntidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEntidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ENTIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEs() != null) {
			where.append(" AND UPPER(t2.NOMBRE_ES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEs()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEs()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_ES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreEu() != null) {
			where.append(" AND UPPER(t2.NOMBRE_EU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreEu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreEu()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_EU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getActiva() != null) {
			where.append(" AND UPPER(t2.ACTIVA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getActiva()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getActiva().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACTIVA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumogest() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMOGEST) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumogest()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumogest()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMOGEST IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIskontsumonet() != null) {
			where.append(" AND UPPER(t2.ISKONTSUMONET) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIskontsumonet()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIskontsumonet()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISKONTSUMONET IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsofertaform() != null) {
			where.append(" AND UPPER(t2.ISOFERTAFORM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsofertaform()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsofertaform()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISOFERTAFORM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsconsultasweb() != null) {
			where.append(" AND UPPER(t2.ISCONSULTASWEB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsconsultasweb()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsconsultasweb()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISCONSULTASWEB IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getIsnacional() != null) {
			where.append(" AND UPPER(t2.ISNACIONAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getIsnacional()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getIsnacional()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ISNACIONAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getObservaciones() != null) {
			where.append(" AND UPPER(t2.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getObservaciones()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getObservaciones()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.OBSERVACIONES IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getTelefono() != null) {
			where.append(" AND UPPER(t2.TELEFONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getTelefono()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getTelefono()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TELEFONO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFax() != null) {
			where.append(" AND UPPER(t2.FAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getFax().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.FAX IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getEmail() != null) {
			where.append(" AND UPPER(t2.EMAIL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getEmail().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.EMAIL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUrl() != null) {
			where.append(" AND UPPER(t2.URL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUrl().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.URL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuario() != null) {
			where.append(" AND UPPER(t2.USUARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuario()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuario()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUARIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getPassword() != null) {
			where.append(" AND UPPER(t2.PASSWORD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getPassword()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getPassword()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.PASSWORD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPaisId() != null) {
			where.append(" AND UPPER(t2.NORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PAIS_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePais() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PAIS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePais()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePais()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PAIS IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.NORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PROVINCIA_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreProvincia() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PROVINCIA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.NORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreMunicipio() != null) {
			where.append(" AND UPPER(t2.NOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.NORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreLocalidad() != null) {
			where.append(" AND UPPER(t2.NOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCalleId() != null) {
			where.append(" AND UPPER(t2.NORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CALLE_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCalle() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CALLE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraCpId() != null) {
			where.append(" AND UPPER(t2.NORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_CP_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombreCp() != null) {
			where.append(" AND UPPER(t2.NOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_CP IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNoraPortalId() != null) {
			where.append(" AND UPPER(t2.NORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NORA_PORTAL_ID IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getNombrePortal() != null) {
			where.append(" AND UPPER(t2.NOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getNombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getNombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.NOMBRE_PORTAL IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getUsuultmod() != null) {
			where.append(" AND UPPER(t2.USUULTMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getUsuultmod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ censomonitor.getOrganismo().getUsuultmod()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.USUULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getFecultmod() != null) {
			where.append(" AND t2.FECULTMOD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getOrganismo().getFecultmod() + "%");
			} else {
				params.add("%" + censomonitor.getOrganismo().getFecultmod()
						+ "%");
			}
			where.append(" AND t2.FECULTMOD IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMonombre() != null) {
			where.append(" AND UPPER(t1.MONOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMonombre().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMonombre().toUpperCase() + "%");
			}
			where.append(" AND t1.MONOMBRE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMocoem() != null) {
			where.append(" AND UPPER(t1.MOCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMocoem().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMocoem().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCOEM IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMousu() != null) {
			where.append(" AND UPPER(t1.MOUSU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMousu().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMousu().toUpperCase() + "%");
			}
			where.append(" AND t1.MOUSU IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoclave() != null) {
			where.append(" AND UPPER(t1.MOCLAVE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoclave().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoclave().toUpperCase() + "%");
			}
			where.append(" AND t1.MOCLAVE IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMofecbaja() != null) {
			where.append(" AND t1.MOFECBAJA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMofecbaja() + "%");
			} else {
				params.add("%" + censomonitor.getMofecbaja() + "%");
			}
			where.append(" AND t1.MOFECBAJA IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoadmin() != null) {
			where.append(" AND UPPER(t1.MOADMIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoadmin().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoadmin().toUpperCase() + "%");
			}
			where.append(" AND t1.MOADMIN IS NOT NULL");
		}
		if (censomonitor != null && censomonitor.getMoprimera() != null) {
			where.append(" AND UPPER(t1.MOPRIMERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(censomonitor.getMoprimera().toUpperCase() + "%");
			} else {
				params.add("%" + censomonitor.getMoprimera().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MOPRIMERA IS NOT NULL");
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CensoMonitor table using like in the filter of
	 * CensoMonitor.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CensoMonitor> findAllCensoMonitorAlta(CensoMonitor censomonitor) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.MOCOOR= t2.COD_ORG(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.MOCODIGO MOCODIGO,t1.MONOMBRE MONOMBRE,t1.MOCOEM MOCOEM,t1.MOUSU MOUSU,t1.MOCLAVE MOCLAVE,t1.MOFECBAJA MOFECBAJA,t1.MOADMIN MOADMIN,t1.MOPRIMERA MOPRIMERA,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
						+ "FROM CENSO_MONITOR t1 ,ORGANISMO t2 ");

		if (censomonitor != null && censomonitor.getOrganismo() != null
				&& censomonitor.getOrganismo().getCodOrg() != null) {
			where.append(" AND t2.COD_ORG = ?");
			params.add(censomonitor.getOrganismo().getCodOrg());
		}

		where.append(" AND t1.MOFECBAJA IS NULL");

		query.append(where);

		return (List<CensoMonitor>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCensoMonitorAltaCount(CensoMonitor censomonitor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CENSO_MONITOR t1  ");

		where.append(" AND t1.MOFECBAJA IS NULL ");

		where.append(" AND t1.MOUSU = ? ");

		params.add(censomonitor.getMousu());

		if (censomonitor.getMocodigo() != null
				&& !censomonitor.getMocodigo().equals("")) {
			where.append(" AND t1.MOCODIGO  <> ? ");
			params.add(censomonitor.getMocodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            CensoMonitor
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findUsuarioCensoMonitorCount(CensoMonitor censomonitor) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CENSO_MONITOR t1  ");

		where.append(" AND t1.MOUSU = ? ");

		params.add(censomonitor.getMousu());

		if (censomonitor.getMocodigo() != null
				&& !censomonitor.getMocodigo().equals("")) {
			where.append(" AND t1.MOCODIGO  <> ? ");
			params.add(censomonitor.getMocodigo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the CensoMonitor table.
	 * 
	 * @param censomonitor
	 *            Pagination
	 * @return CensoMonitor
	 */
	@Transactional(readOnly = true)
	public CensoMonitor findCoordinadorSolicitudes(CensoMonitor censomonitor) {
		try {
			String query = "SELECT t1.MOCODIGO MOCODIGO,t1.MONOMBRE MONOMBRE,t1.MOCOEM MOCOEM,t1.MOUSU MOUSU,t1.MOCLAVE MOCLAVE,t1.MOFECBAJA MOFECBAJA,t1.MOADMIN MOADMIN,t1.MOPRIMERA MOPRIMERA,t2.COD_ORG ORGANISMOCODORG,t2.ENTIDAD_ID ORGANISMOENTIDADID,t2.NOMBRE_ES ORGANISMONOMBREES,t2.NOMBRE_EU ORGANISMONOMBREEU,t2.ACTIVA ORGANISMOACTIVA,t2.ISKONTSUMOGEST ORGANISMOISKONTSUMOGEST,t2.ISKONTSUMONET ORGANISMOISKONTSUMONET,t2.ISOFERTAFORM ORGANISMOISOFERTAFORM,t2.ISCONSULTASWEB ORGANISMOISCONSULTASWEB,t2.ISNACIONAL ORGANISMOISNACIONAL,t2.OBSERVACIONES ORGANISMOOBSERVACIONES,t2.TELEFONO ORGANISMOTELEFONO,t2.FAX ORGANISMOFAX,t2.EMAIL ORGANISMOEMAIL,t2.URL ORGANISMOURL,t2.USUARIO ORGANISMOUSUARIO,t2.PASSWORD ORGANISMOPASSWORD,t2.NORA_PAIS_ID ORGANISMONORAPAISID,t2.NOMBRE_PAIS ORGANISMONOMBREPAIS,t2.NORA_PROVINCIA_ID ORGANISMONORAPROVINCIAID,t2.NOMBRE_PROVINCIA ORGANISMONOMBREPROVINCIA,t2.NORA_MUNICIPIO_ID ORGANISMONORAMUNICIPIOID,t2.NOMBRE_MUNICIPIO ORGANISMONOMBREMUNICIPIO,t2.NORA_LOCALIDAD_ID ORGANISMONORALOCALIDADID,t2.NOMBRE_LOCALIDAD ORGANISMONOMBRELOCALIDAD,t2.NORA_CALLE_ID ORGANISMONORACALLEID,t2.NOMBRE_CALLE ORGANISMONOMBRECALLE,t2.NORA_CP_ID ORGANISMONORACPID,t2.NOMBRE_CP ORGANISMONOMBRECP,t2.NORA_PORTAL_ID ORGANISMONORAPORTALID,t2.NOMBRE_PORTAL ORGANISMONOMBREPORTAL,t2.USUULTMOD ORGANISMOUSUULTMOD,t2.FECULTMOD ORGANISMOFECULTMOD "
					+ "FROM CENSO_MONITOR t1 , ORGANISMO t2  "
					+ "WHERE t1.ID_PERFILSOLICITUDES = ?  AND t1.MOCOOR=? AND t1.MOCOOR= t2.COD_ORG(+) AND t1.MOFECBAJA IS NULL AND ROWNUM=1 ";
			return (CensoMonitor) this.jdbcTemplate.queryForObject(query,
					rwMap, Y41aConstantes.PERFIL_COORDINADOR, censomonitor
							.getOrganismo().getCodOrg());
		} catch (EmptyResultDataAccessException e) {
			return new CensoMonitor();
		}
	}
}
