package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.Comaut;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipAlerta;
import com.ejie.y41a.model.TipOrigenProd;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.CaracterAlerta;

/**
 * * CaracterAlertaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class CaracterAlertaDaoImpl implements CaracterAlertaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<CaracterAlerta> rwMap = new RowMapper<CaracterAlerta>() {
		public CaracterAlerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CaracterAlerta(resultSet.getString("CRCODIGO"),
					resultSet.getString("CRCOOR"),
					resultSet.getDate("CRFERERE"),
					resultSet.getString("CRTEINFO"),
					resultSet.getInt("CRCNACTU"),
					resultSet.getString("CRINPRSE"), new Alerta(
							resultSet.getString("AlertaALCODIGO"),
							resultSet.getString("AlertaALCOOR"),
							resultSet.getLong("AlertaALNRAN"),
							resultSet.getString("AlertaALNROR"),
							resultSet.getDate("AlertaALFEEN"),
							resultSet.getDate("AlertaALFEPLRR"),
							resultSet.getString("AlertaALNOPRSE"),
							resultSet.getString("AlertaALNRLOPS"),
							resultSet.getString("AlertaALNOMAPS"),
							resultSet.getString("AlertaALNOMOPS"),
							resultSet.getDate("AlertaALFEDUMI"),
							resultSet.getString("AlertaALTEIN"),
							resultSet.getDate("AlertaALFERRIN"),
							resultSet.getString("AlertaALINRE"),
							resultSet.getDate("AlertaALFECOOR"),
							resultSet.getString("AlertaALCOTMO"), new Comaut(
									resultSet.getString("AlertaALCOCA"), null,
									null, null), new Producto(
									resultSet.getString("AlertaALCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipOrigenProd(resultSet
									.getString("AlertaALCOTOP"), null, null),
							new Pais(resultSet.getString("AlertaALCOPA"), null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("AlertaALCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null)), new TipAlerta(
							resultSet.getString("TipAlertaTCACODIGO"),
							resultSet.getString("TipAlertaTCANOMBRE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            Pagination
	 * @return CaracterAlerta
	 */
	public CaracterAlerta add(CaracterAlerta caracteralerta) {

		String query = "INSERT INTO CARACTER_ALERTA( CRCODIGO,CRCOAL,CRTIPO,CRCOOR,CRFERERE,CRTEINFO,CRCNACTU,CRINPRSE)"
				+ "VALUES (?,?,?,?,?,?,?,?)";

		Object getAlertaAlcodigoAux = null;
		if (caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = caracteralerta.getAlerta().getAlcodigo();
		}
		Object getTipAlertaTcacodigoAux = null;
		if (caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcacodigo() != null) {
			getTipAlertaTcacodigoAux = caracteralerta.getTipAlerta()
					.getTcacodigo();
		}
		this.jdbcTemplate.update(query, caracteralerta.getCrcodigo(),
				getAlertaAlcodigoAux, getTipAlertaTcacodigoAux,
				caracteralerta.getCrcoor(), caracteralerta.getCrferere(),
				caracteralerta.getCrteinfo(), caracteralerta.getCrcnactu(),
				caracteralerta.getCrinprse());
		return caracteralerta;
	}

	/**
	 * Updates a single row in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            Pagination
	 * @return CaracterAlerta
	 */
	public CaracterAlerta update(CaracterAlerta caracteralerta) {
		String query = "UPDATE CARACTER_ALERTA SET CRCOAL=?,CRTIPO=?,CRCOOR=?,CRFERERE=?,CRTEINFO=?,CRCNACTU=?,CRINPRSE=? WHERE CRCODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = caracteralerta.getAlerta().getAlcodigo();
		}
		Object getTipAlertaTcacodigoAux = null;
		if (caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcacodigo() != null) {
			getTipAlertaTcacodigoAux = caracteralerta.getTipAlerta()
					.getTcacodigo();
		}
		this.jdbcTemplate.update(query, getAlertaAlcodigoAux,
				getTipAlertaTcacodigoAux, caracteralerta.getCrcoor(),
				caracteralerta.getCrferere(), caracteralerta.getCrteinfo(),
				caracteralerta.getCrcnactu(), caracteralerta.getCrinprse(),
				caracteralerta.getCrcodigo());
		return caracteralerta;
	}

	/**
	 * Finds a single row in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            Pagination
	 * @return CaracterAlerta
	 */
	@Transactional(readOnly = true)
	public CaracterAlerta find(CaracterAlerta caracteralerta) {
		String query = "SELECT t1.CRCODIGO CRCODIGO, t1.CRCOOR CRCOOR, t1.CRFERERE CRFERERE, t1.CRTEINFO CRTEINFO, t1.CRCNACTU CRCNACTU, t1.CRINPRSE CRINPRSE, t2.ALCODIGO ALERTAALCODIGO, t2.ALCOOR ALERTAALCOOR, t2.ALNRAN ALERTAALNRAN, t2.ALNROR ALERTAALNROR, t2.ALFEEN ALERTAALFEEN, t2.ALFEPLRR ALERTAALFEPLRR, t2.ALNOPRSE ALERTAALNOPRSE, t2.ALNRLOPS ALERTAALNRLOPS, t2.ALNOMAPS ALERTAALNOMAPS, t2.ALNOMOPS ALERTAALNOMOPS, t2.ALFEDUMI ALERTAALFEDUMI, t2.ALTEIN ALERTAALTEIN, t2.ALFERRIN ALERTAALFERRIN, t2.ALINRE ALERTAALINRE, t2.ALFECOOR ALERTAALFECOOR, t2.ALCOTMO ALERTAALCOTMO, t3.TCACODIGO TIPALERTATCACODIGO, t3.TCANOMBRE TIPALERTATCANOMBRE, t2.ALCOCA ALERTAALCOCA, t2.ALCOPS ALERTAALCOPS, t2.ALCOTOP ALERTAALCOTOP, t2.ALCOPA ALERTAALCOPA, t2.ALCOES ALERTAALCOES "
				+ "FROM CARACTER_ALERTA t1 , ALERTA t2 , TIP_ALERTA t3  "
				+ "WHERE t1.CRCODIGO = ?   AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+)  ";
		return (CaracterAlerta) this.jdbcTemplate.queryForObject(query, rwMap,
				caracteralerta.getCrcodigo());
	}

	/**
	 * Removes a single row in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            Pagination
	 * @return
	 */
	public void remove(CaracterAlerta caracteralerta) {
		String query = "DELETE  FROM CARACTER_ALERTA WHERE CRCODIGO=?";
		this.jdbcTemplate.update(query, caracteralerta.getCrcodigo());
	}

	/**
	 * Finds a List of rows in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            CaracterAlerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CaracterAlerta> findAll(CaracterAlerta caracteralerta,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALTEIN ALERTAALTEIN,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t3.TCACODIGO TIPALERTATCACODIGO,t3.TCANOMBRE TIPALERTATCANOMBRE,t2.ALCOCA ALERTAALCOCA,t2.ALCOPS ALERTAALCOPS,t2.ALCOTOP ALERTAALCOTOP,t2.ALCOPA ALERTAALCOPA,t2.ALCOES ALERTAALCOES "
						+ "FROM CARACTER_ALERTA t1 ,ALERTA t2 ,TIP_ALERTA t3 ");

		if (caracteralerta != null && caracteralerta.getCrcodigo() != null) {
			where.append(" AND t1.CRCODIGO = ?");
			params.add(caracteralerta.getCrcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(caracteralerta.getAlerta().getAlcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getComaut() != null
				&& caracteralerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(caracteralerta.getAlerta().getComaut().getCacodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getProducto() != null
				&& caracteralerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(caracteralerta.getAlerta().getProducto().getPscodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getTipOrigenProd() != null
				&& caracteralerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(caracteralerta.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getPais() != null
				&& caracteralerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(caracteralerta.getAlerta().getPais().getPacodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getEstablecimiento() != null
				&& caracteralerta.getAlerta().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(caracteralerta.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(caracteralerta.getAlerta().getAlcoor());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(caracteralerta.getAlerta().getAlnran());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(caracteralerta.getAlerta().getAlnror());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(caracteralerta.getAlerta().getAlfeen());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(caracteralerta.getAlerta().getAlfeplrr());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(caracteralerta.getAlerta().getAlnoprse());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(caracteralerta.getAlerta().getAlnrlops());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(caracteralerta.getAlerta().getAlnomaps());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(caracteralerta.getAlerta().getAlnomops());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(caracteralerta.getAlerta().getAlfedumi());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(caracteralerta.getAlerta().getAltein());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(caracteralerta.getAlerta().getAlferrin());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(caracteralerta.getAlerta().getAlinre());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(caracteralerta.getAlerta().getAlfecoor());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(caracteralerta.getAlerta().getAlcotmo());
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcacodigo() != null) {
			where.append(" AND t3.TCACODIGO = ?");
			params.add(caracteralerta.getTipAlerta().getTcacodigo());
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcanombre() != null) {
			where.append(" AND t3.TCANOMBRE = ?");
			params.add(caracteralerta.getTipAlerta().getTcanombre());
		}
		if (caracteralerta != null && caracteralerta.getCrcoor() != null) {
			where.append(" AND t1.CRCOOR = ?");
			params.add(caracteralerta.getCrcoor());
		}
		if (caracteralerta != null && caracteralerta.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(caracteralerta.getCrferere());
		}
		if (caracteralerta != null && caracteralerta.getCrteinfo() != null) {
			where.append(" AND t1.CRTEINFO = ?");
			params.add(caracteralerta.getCrteinfo());
		}
		if (caracteralerta != null && caracteralerta.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(caracteralerta.getCrcnactu());
		}
		if (caracteralerta != null && caracteralerta.getCrinprse() != null) {
			where.append(" AND t1.CRINPRSE = ?");
			params.add(caracteralerta.getCrinprse());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CaracterAlerta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CaracterAlerta table.
	 * 
	 * @param caracteralerta
	 *            CaracterAlerta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CaracterAlerta caracteralerta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.CRCOAL= t2.ALCODIGO(+) and t1.CRTIPO= t3.TCACODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CARACTER_ALERTA t1   ,  ALERTA t2   ,  TIP_ALERTA t3  ");
		if (caracteralerta != null && caracteralerta.getCrcodigo() != null) {
			where.append(" AND t1.CRCODIGO = ?");
			params.add(caracteralerta.getCrcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(caracteralerta.getAlerta().getAlcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getComaut() != null
				&& caracteralerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(caracteralerta.getAlerta().getComaut().getCacodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getProducto() != null
				&& caracteralerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(caracteralerta.getAlerta().getProducto().getPscodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getTipOrigenProd() != null
				&& caracteralerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(caracteralerta.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getPais() != null
				&& caracteralerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(caracteralerta.getAlerta().getPais().getPacodigo());
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getEstablecimiento() != null
				&& caracteralerta.getAlerta().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(caracteralerta.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(caracteralerta.getAlerta().getAlcoor());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(caracteralerta.getAlerta().getAlnran());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(caracteralerta.getAlerta().getAlnror());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(caracteralerta.getAlerta().getAlfeen());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(caracteralerta.getAlerta().getAlfeplrr());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(caracteralerta.getAlerta().getAlnoprse());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(caracteralerta.getAlerta().getAlnrlops());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(caracteralerta.getAlerta().getAlnomaps());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(caracteralerta.getAlerta().getAlnomops());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(caracteralerta.getAlerta().getAlfedumi());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(caracteralerta.getAlerta().getAltein());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(caracteralerta.getAlerta().getAlferrin());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(caracteralerta.getAlerta().getAlinre());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(caracteralerta.getAlerta().getAlfecoor());
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(caracteralerta.getAlerta().getAlcotmo());
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcacodigo() != null) {
			where.append(" AND t3.TCACODIGO = ?");
			params.add(caracteralerta.getTipAlerta().getTcacodigo());
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcanombre() != null) {
			where.append(" AND t3.TCANOMBRE = ?");
			params.add(caracteralerta.getTipAlerta().getTcanombre());
		}
		if (caracteralerta != null && caracteralerta.getCrcoor() != null) {
			where.append(" AND t1.CRCOOR = ?");
			params.add(caracteralerta.getCrcoor());
		}
		if (caracteralerta != null && caracteralerta.getCrferere() != null) {
			where.append(" AND t1.CRFERERE = ?");
			params.add(caracteralerta.getCrferere());
		}
		if (caracteralerta != null && caracteralerta.getCrteinfo() != null) {
			where.append(" AND t1.CRTEINFO = ?");
			params.add(caracteralerta.getCrteinfo());
		}
		if (caracteralerta != null && caracteralerta.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU = ?");
			params.add(caracteralerta.getCrcnactu());
		}
		if (caracteralerta != null && caracteralerta.getCrinprse() != null) {
			where.append(" AND t1.CRINPRSE = ?");
			params.add(caracteralerta.getCrinprse());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CaracterAlerta table using like.
	 * 
	 * @param caracteralerta
	 *            CaracterAlerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CaracterAlerta> findAllLike(CaracterAlerta caracteralerta,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CRCOAL= t2.ALCODIGO(+) AND t1.CRTIPO= t3.TCACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.CRCODIGO CRCODIGO,t1.CRCOOR CRCOOR,t1.CRFERERE CRFERERE,t1.CRTEINFO CRTEINFO,t1.CRCNACTU CRCNACTU,t1.CRINPRSE CRINPRSE,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALTEIN ALERTAALTEIN,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t3.TCACODIGO TIPALERTATCACODIGO,t3.TCANOMBRE TIPALERTATCANOMBRE,t2.ALCOCA ALERTAALCOCA,t2.ALCOPS ALERTAALCOPS,t2.ALCOTOP ALERTAALCOTOP,t2.ALCOPA ALERTAALCOPA,t2.ALCOES ALERTAALCOES "
						+ "FROM CARACTER_ALERTA t1 ,ALERTA t2 ,TIP_ALERTA t3 ");

		if (caracteralerta != null && caracteralerta.getCrcodigo() != null) {
			where.append(" AND UPPER(t1.CRCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + caracteralerta.getCrcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRCODIGO IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlcodigo() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlcodigo() + "%");
			}
			where.append(" AND t2.ALCODIGO IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getComaut() != null
				&& caracteralerta.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND UPPER(t2.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getComaut().getCacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getComaut().getCacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOCA IS NOT NULL");
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getProducto() != null
				&& caracteralerta.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t2.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPS IS NOT NULL");
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getTipOrigenProd() != null
				&& caracteralerta.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND UPPER(t2.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getTipOrigenProd()
						.getTopcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getTipOrigenProd()
								.getTopcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOTOP IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getPais() != null
				&& caracteralerta.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND UPPER(t2.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getPais().getPacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getPais().getPacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPA IS NOT NULL");
		}
		if (caracteralerta != null
				&& caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getEstablecimiento() != null
				&& caracteralerta.getAlerta().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t2.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOES IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t2.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOOR IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnran() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlnran() + "%");
			}
			where.append(" AND t2.ALNRAN IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t2.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnror().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNROR IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlfeen() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlfeen() + "%");
			}
			where.append(" AND t2.ALFEEN IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlfeplrr() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlfeplrr() + "%");
			}
			where.append(" AND t2.ALFEPLRR IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t2.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnoprse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlnoprse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOPRSE IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t2.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNRLOPS IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t2.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOMAPS IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t2.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALNOMOPS IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlfedumi() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlfedumi() + "%");
			}
			where.append(" AND t2.ALFEDUMI IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t2.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAltein().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAltein().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALTEIN IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlferrin() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlferrin() + "%");
			}
			where.append(" AND t2.ALFERRIN IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t2.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALINRE IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlfecoor() + "%");
			} else {
				params.add("%" + caracteralerta.getAlerta().getAlfecoor() + "%");
			}
			where.append(" AND t2.ALFECOOR IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getAlerta() != null
				&& caracteralerta.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t2.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getAlerta().getAlcotmo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTMO IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcacodigo() != null) {
			where.append(" AND t3.TCACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getTipAlerta().getTcacodigo() + "%");
			} else {
				params.add("%" + caracteralerta.getTipAlerta().getTcacodigo()
						+ "%");
			}
			where.append(" AND t3.TCACODIGO IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getTipAlerta() != null
				&& caracteralerta.getTipAlerta().getTcanombre() != null) {
			where.append(" AND UPPER(t3.TCANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getTipAlerta().getTcanombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ caracteralerta.getTipAlerta().getTcanombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TCANOMBRE IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getCrcoor() != null) {
			where.append(" AND UPPER(t1.CRCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrcoor().toUpperCase() + "%");
			} else {
				params.add("%" + caracteralerta.getCrcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.CRCOOR IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getCrferere() != null) {
			where.append(" AND t1.CRFERERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrferere() + "%");
			} else {
				params.add("%" + caracteralerta.getCrferere() + "%");
			}
			where.append(" AND t1.CRFERERE IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getCrteinfo() != null) {
			where.append(" AND UPPER(t1.CRTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrteinfo().toUpperCase() + "%");
			} else {
				params.add("%" + caracteralerta.getCrteinfo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRTEINFO IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getCrcnactu() != null) {
			where.append(" AND t1.CRCNACTU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrcnactu() + "%");
			} else {
				params.add("%" + caracteralerta.getCrcnactu() + "%");
			}
			where.append(" AND t1.CRCNACTU IS NOT NULL");
		}
		if (caracteralerta != null && caracteralerta.getCrinprse() != null) {
			where.append(" AND UPPER(t1.CRINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(caracteralerta.getCrinprse().toUpperCase() + "%");
			} else {
				params.add("%" + caracteralerta.getCrinprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.CRINPRSE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CaracterAlerta>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
