package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.model.Producto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.CampanhaProd;

/**
 *  * CampanhaProdDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class CampanhaProdDaoImpl implements CampanhaProdDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<CampanhaProd> rwMap = new RowMapper<CampanhaProd>() {
		public CampanhaProd mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new CampanhaProd(
               resultSet.getString("CPCODIGO"), resultSet.getString("CPNOPS"), new Producto(resultSet.getString("ProductoPSCODIGO"), resultSet.getString("ProductoPSNOMBRE"), resultSet.getString("ProductoPSNOCO"), resultSet.getString("ProductoPSDESCRI"), resultSet.getString("ProductoPSCOSE"), resultSet.getString("ProductoPSNOMBREE"), resultSet.getString("ProductoPSNOMBREI"), resultSet.getString("ProductoPSNOMBREF"), resultSet.getString("ProductoPSNOMBREA"), resultSet.getString("ProductoPSNOCOE"), resultSet.getString("ProductoPSNOCOI"), resultSet.getString("ProductoPSNOCOF"), resultSet.getString("ProductoPSNOCOA"), resultSet.getString("ProductoPSDESCRIE"), resultSet.getString("ProductoPSDESCRII"), resultSet.getString("ProductoPSDESCRIF"), resultSet.getString("ProductoPSDESCRIA"), resultSet.getString("ProductoPSSEL1"), resultSet.getString("ProductoPSCOINC"), new ProdAgrupado(resultSet.getString("ProductoPSCOE8"), null, null, null)), new Campanha(resultSet.getString("CampanhaCMCODIGO"), resultSet.getString("CampanhaCMNOMBRE"), resultSet.getString("CampanhaCMCOPS"), resultSet.getString("CampanhaCMNOAR"), resultSet.getString("CampanhaCMNOPS"), resultSet.getString("CampanhaCMCOTMO"))
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the CampanhaProd table.
     *
     * @param campanhaprod Pagination
     * @return CampanhaProd
     */
	public CampanhaProd add(CampanhaProd campanhaprod) {

    	String query = "INSERT INTO CAMPANHA_PROD( CPCODIGO,CPCOPS,CPCOCM,CPNOPS)"
        + "VALUES (?,?,?,?)";

				   Object getProductoPscodigoAux=null;
		     if (campanhaprod.getProducto()!= null  && campanhaprod.getProducto().getPscodigo()!=null ){
			     getProductoPscodigoAux=campanhaprod.getProducto().getPscodigo();
		   	  }
				   Object getCampanhaCmcodigoAux=null;
		     if (campanhaprod.getCampanha()!= null  && campanhaprod.getCampanha().getCmcodigo()!=null ){
			     getCampanhaCmcodigoAux=campanhaprod.getCampanha().getCmcodigo();
		   	  }
		this.jdbcTemplate.update(query, campanhaprod.getCpcodigo(), getProductoPscodigoAux, getCampanhaCmcodigoAux, campanhaprod.getCpnops());
		return campanhaprod;
	}

    /**
     * Updates a single row in the CampanhaProd table.
     *
     * @param campanhaprod Pagination
     * @return CampanhaProd
     */
    public CampanhaProd update(CampanhaProd campanhaprod) {
		String query = "UPDATE CAMPANHA_PROD SET CPCOPS=?,CPCOCM=?,CPNOPS=? WHERE CPCODIGO=?";
				Object getProductoPscodigoAux=null;
				if (campanhaprod.getProducto()!= null   && campanhaprod.getProducto().getPscodigo()!=null ){
					getProductoPscodigoAux=campanhaprod.getProducto().getPscodigo();
				}
				Object getCampanhaCmcodigoAux=null;
				if (campanhaprod.getCampanha()!= null   && campanhaprod.getCampanha().getCmcodigo()!=null ){
					getCampanhaCmcodigoAux=campanhaprod.getCampanha().getCmcodigo();
				}
		this.jdbcTemplate.update(query, getProductoPscodigoAux, getCampanhaCmcodigoAux, campanhaprod.getCpnops(), campanhaprod.getCpcodigo());
		return campanhaprod;
	}

    /**
     * Finds a single row in the CampanhaProd table.
     *
     * @param campanhaprod Pagination
     * @return CampanhaProd
     */
    @Transactional (readOnly = true)
    public CampanhaProd find(CampanhaProd campanhaprod) {
		String query = "SELECT t1.CPCODIGO CPCODIGO, t1.CPNOPS CPNOPS, t2.PSCODIGO PRODUCTOPSCODIGO, t2.PSNOMBRE PRODUCTOPSNOMBRE, t2.PSNOCO PRODUCTOPSNOCO, t2.PSDESCRI PRODUCTOPSDESCRI, t2.PSCOSE PRODUCTOPSCOSE, t2.PSNOMBREE PRODUCTOPSNOMBREE, t2.PSNOMBREI PRODUCTOPSNOMBREI, t2.PSNOMBREF PRODUCTOPSNOMBREF, t2.PSNOMBREA PRODUCTOPSNOMBREA, t2.PSNOCOE PRODUCTOPSNOCOE, t2.PSNOCOI PRODUCTOPSNOCOI, t2.PSNOCOF PRODUCTOPSNOCOF, t2.PSNOCOA PRODUCTOPSNOCOA, t2.PSDESCRIE PRODUCTOPSDESCRIE, t2.PSDESCRII PRODUCTOPSDESCRII, t2.PSDESCRIF PRODUCTOPSDESCRIF, t2.PSDESCRIA PRODUCTOPSDESCRIA, t2.PSSEL1 PRODUCTOPSSEL1, t2.PSCOINC PRODUCTOPSCOINC, t3.CMCODIGO CAMPANHACMCODIGO, t3.CMNOMBRE CAMPANHACMNOMBRE, t3.CMCOPS CAMPANHACMCOPS, t3.CMNOAR CAMPANHACMNOAR, t3.CMNOPS CAMPANHACMNOPS, t3.CMCOTMO CAMPANHACMCOTMO, t2.PSCOE8 PRODUCTOPSCOE8 " 
         + "FROM CAMPANHA_PROD t1 , PRODUCTO t2 , CAMPANHA t3  " 
         + "WHERE t1.CPCODIGO = ?   AND t1.CPCOPS= t2.PSCODIGO(+) AND t1.CPCOCM= t3.CMCODIGO(+)  ";
		return (CampanhaProd) this.jdbcTemplate.queryForObject(query, 
			rwMap , campanhaprod.getCpcodigo());	 
    }

    /**
     * Removes a single row in the CampanhaProd table.
     *
     * @param campanhaprod Pagination
     * @return
     */
    public void remove(CampanhaProd campanhaprod) {
		String query = "DELETE  FROM CAMPANHA_PROD WHERE CPCODIGO=?";
		this.jdbcTemplate.update(query, campanhaprod.getCpcodigo());
    	}
    
   /**
    * Finds a List of rows in the CampanhaProd table.
    * 
    * @param campanhaprod CampanhaProd
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<CampanhaProd> findAll(CampanhaProd campanhaprod, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CPCOPS= t2.PSCODIGO(+) AND t1.CPCOCM= t3.CMCODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CPCODIGO CPCODIGO,t1.CPNOPS CPNOPS,t2.PSCODIGO PRODUCTOPSCODIGO,t2.PSNOMBRE PRODUCTOPSNOMBRE,t2.PSNOCO PRODUCTOPSNOCO,t2.PSDESCRI PRODUCTOPSDESCRI,t2.PSCOSE PRODUCTOPSCOSE,t2.PSNOMBREE PRODUCTOPSNOMBREE,t2.PSNOMBREI PRODUCTOPSNOMBREI,t2.PSNOMBREF PRODUCTOPSNOMBREF,t2.PSNOMBREA PRODUCTOPSNOMBREA,t2.PSNOCOE PRODUCTOPSNOCOE,t2.PSNOCOI PRODUCTOPSNOCOI,t2.PSNOCOF PRODUCTOPSNOCOF,t2.PSNOCOA PRODUCTOPSNOCOA,t2.PSDESCRIE PRODUCTOPSDESCRIE,t2.PSDESCRII PRODUCTOPSDESCRII,t2.PSDESCRIF PRODUCTOPSDESCRIF,t2.PSDESCRIA PRODUCTOPSDESCRIA,t2.PSSEL1 PRODUCTOPSSEL1,t2.PSCOINC PRODUCTOPSCOINC,t3.CMCODIGO CAMPANHACMCODIGO,t3.CMNOMBRE CAMPANHACMNOMBRE,t3.CMCOPS CAMPANHACMCOPS,t3.CMNOAR CAMPANHACMNOAR,t3.CMNOPS CAMPANHACMNOPS,t3.CMCOTMO CAMPANHACMCOTMO,t2.PSCOE8 PRODUCTOPSCOE8 " 
			+ "FROM CAMPANHA_PROD t1 ,PRODUCTO t2 ,CAMPANHA t3 ");
		
		if (campanhaprod  != null  && campanhaprod.getCpcodigo() != null ) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(campanhaprod.getCpcodigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscodigo() != null ) {
			where.append(" AND t2.PSCODIGO = ?");
			params.add(campanhaprod.getProducto().getPscodigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null && campanhaprod.getProducto().getProdAgrupado() != null && campanhaprod.getProducto().getProdAgrupado().getE8codigo() != null ) {
			where.append(" AND t2.PSCOE8 = ?");
			params.add(campanhaprod.getProducto().getProdAgrupado().getE8codigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombre() != null ) {
			where.append(" AND t2.PSNOMBRE = ?");
			params.add(campanhaprod.getProducto().getPsnombre());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnoco() != null ) {
			where.append(" AND t2.PSNOCO = ?");
			params.add(campanhaprod.getProducto().getPsnoco());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescri() != null ) {
			where.append(" AND t2.PSDESCRI = ?");
			params.add(campanhaprod.getProducto().getPsdescri());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscose() != null ) {
			where.append(" AND t2.PSCOSE = ?");
			params.add(campanhaprod.getProducto().getPscose());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombree() != null ) {
			where.append(" AND t2.PSNOMBREE = ?");
			params.add(campanhaprod.getProducto().getPsnombree());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrei() != null ) {
			where.append(" AND t2.PSNOMBREI = ?");
			params.add(campanhaprod.getProducto().getPsnombrei());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombref() != null ) {
			where.append(" AND t2.PSNOMBREF = ?");
			params.add(campanhaprod.getProducto().getPsnombref());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrea() != null ) {
			where.append(" AND t2.PSNOMBREA = ?");
			params.add(campanhaprod.getProducto().getPsnombrea());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoe() != null ) {
			where.append(" AND t2.PSNOCOE = ?");
			params.add(campanhaprod.getProducto().getPsnocoe());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoi() != null ) {
			where.append(" AND t2.PSNOCOI = ?");
			params.add(campanhaprod.getProducto().getPsnocoi());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocof() != null ) {
			where.append(" AND t2.PSNOCOF = ?");
			params.add(campanhaprod.getProducto().getPsnocof());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoa() != null ) {
			where.append(" AND t2.PSNOCOA = ?");
			params.add(campanhaprod.getProducto().getPsnocoa());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrie() != null ) {
			where.append(" AND t2.PSDESCRIE = ?");
			params.add(campanhaprod.getProducto().getPsdescrie());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrii() != null ) {
			where.append(" AND t2.PSDESCRII = ?");
			params.add(campanhaprod.getProducto().getPsdescrii());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrif() != null ) {
			where.append(" AND t2.PSDESCRIF = ?");
			params.add(campanhaprod.getProducto().getPsdescrif());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescria() != null ) {
			where.append(" AND t2.PSDESCRIA = ?");
			params.add(campanhaprod.getProducto().getPsdescria());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPssel1() != null ) {
			where.append(" AND t2.PSSEL1 = ?");
			params.add(campanhaprod.getProducto().getPssel1());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscoinc() != null ) {
			where.append(" AND t2.PSCOINC = ?");
			params.add(campanhaprod.getProducto().getPscoinc());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t3.CMCODIGO = ?");
			params.add(campanhaprod.getCampanha().getCmcodigo());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnombre() != null ) {
			where.append(" AND t3.CMNOMBRE = ?");
			params.add(campanhaprod.getCampanha().getCmnombre());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcops() != null ) {
			where.append(" AND t3.CMCOPS = ?");
			params.add(campanhaprod.getCampanha().getCmcops());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnoar() != null ) {
			where.append(" AND t3.CMNOAR = ?");
			params.add(campanhaprod.getCampanha().getCmnoar());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnops() != null ) {
			where.append(" AND t3.CMNOPS = ?");
			params.add(campanhaprod.getCampanha().getCmnops());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcotmo() != null ) {
			where.append(" AND t3.CMCOTMO = ?");
			params.add(campanhaprod.getCampanha().getCmcotmo());
		}
		if (campanhaprod  != null  && campanhaprod.getCpnops() != null ) {
			where.append(" AND t1.CPNOPS = ?");
			params.add(campanhaprod.getCpnops());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<CampanhaProd>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the CampanhaProd table.
     * 
     * @param campanhaprod CampanhaProd
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(CampanhaProd campanhaprod) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.CPCOPS= t2.PSCODIGO(+) and t1.CPCOCM= t3.CMCODIGO(+) ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  CAMPANHA_PROD t1   ,  PRODUCTO t2   ,  CAMPANHA t3  ");
		if (campanhaprod  != null  && campanhaprod.getCpcodigo() != null ) {
			where.append(" AND t1.CPCODIGO = ?");
			params.add(campanhaprod.getCpcodigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscodigo() != null ) {
			where.append(" AND t2.PSCODIGO = ?");
			params.add(campanhaprod.getProducto().getPscodigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null && campanhaprod.getProducto().getProdAgrupado() != null && campanhaprod.getProducto().getProdAgrupado().getE8codigo() != null ) {
			where.append(" AND t2.PSCOE8 = ?");
			params.add(campanhaprod.getProducto().getProdAgrupado().getE8codigo());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombre() != null ) {
			where.append(" AND t2.PSNOMBRE = ?");
			params.add(campanhaprod.getProducto().getPsnombre());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnoco() != null ) {
			where.append(" AND t2.PSNOCO = ?");
			params.add(campanhaprod.getProducto().getPsnoco());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescri() != null ) {
			where.append(" AND t2.PSDESCRI = ?");
			params.add(campanhaprod.getProducto().getPsdescri());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscose() != null ) {
			where.append(" AND t2.PSCOSE = ?");
			params.add(campanhaprod.getProducto().getPscose());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombree() != null ) {
			where.append(" AND t2.PSNOMBREE = ?");
			params.add(campanhaprod.getProducto().getPsnombree());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrei() != null ) {
			where.append(" AND t2.PSNOMBREI = ?");
			params.add(campanhaprod.getProducto().getPsnombrei());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombref() != null ) {
			where.append(" AND t2.PSNOMBREF = ?");
			params.add(campanhaprod.getProducto().getPsnombref());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrea() != null ) {
			where.append(" AND t2.PSNOMBREA = ?");
			params.add(campanhaprod.getProducto().getPsnombrea());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoe() != null ) {
			where.append(" AND t2.PSNOCOE = ?");
			params.add(campanhaprod.getProducto().getPsnocoe());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoi() != null ) {
			where.append(" AND t2.PSNOCOI = ?");
			params.add(campanhaprod.getProducto().getPsnocoi());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocof() != null ) {
			where.append(" AND t2.PSNOCOF = ?");
			params.add(campanhaprod.getProducto().getPsnocof());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoa() != null ) {
			where.append(" AND t2.PSNOCOA = ?");
			params.add(campanhaprod.getProducto().getPsnocoa());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrie() != null ) {
			where.append(" AND t2.PSDESCRIE = ?");
			params.add(campanhaprod.getProducto().getPsdescrie());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrii() != null ) {
			where.append(" AND t2.PSDESCRII = ?");
			params.add(campanhaprod.getProducto().getPsdescrii());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrif() != null ) {
			where.append(" AND t2.PSDESCRIF = ?");
			params.add(campanhaprod.getProducto().getPsdescrif());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescria() != null ) {
			where.append(" AND t2.PSDESCRIA = ?");
			params.add(campanhaprod.getProducto().getPsdescria());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPssel1() != null ) {
			where.append(" AND t2.PSSEL1 = ?");
			params.add(campanhaprod.getProducto().getPssel1());
		}
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscoinc() != null ) {
			where.append(" AND t2.PSCOINC = ?");
			params.add(campanhaprod.getProducto().getPscoinc());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t3.CMCODIGO = ?");
			params.add(campanhaprod.getCampanha().getCmcodigo());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnombre() != null ) {
			where.append(" AND t3.CMNOMBRE = ?");
			params.add(campanhaprod.getCampanha().getCmnombre());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcops() != null ) {
			where.append(" AND t3.CMCOPS = ?");
			params.add(campanhaprod.getCampanha().getCmcops());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnoar() != null ) {
			where.append(" AND t3.CMNOAR = ?");
			params.add(campanhaprod.getCampanha().getCmnoar());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnops() != null ) {
			where.append(" AND t3.CMNOPS = ?");
			params.add(campanhaprod.getCampanha().getCmnops());
		}
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcotmo() != null ) {
			where.append(" AND t3.CMCOTMO = ?");
			params.add(campanhaprod.getCampanha().getCmcotmo());
		}
		if (campanhaprod  != null  && campanhaprod.getCpnops() != null ) {
			where.append(" AND t1.CPNOPS = ?");
			params.add(campanhaprod.getCpnops());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the CampanhaProd table using like.
     * 
     * @param campanhaprod CampanhaProd
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<CampanhaProd> findAllLike(CampanhaProd campanhaprod, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.CPCOPS= t2.PSCODIGO(+) AND t1.CPCOCM= t3.CMCODIGO(+) 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CPCODIGO CPCODIGO,t1.CPNOPS CPNOPS,t2.PSCODIGO PRODUCTOPSCODIGO,t2.PSNOMBRE PRODUCTOPSNOMBRE,t2.PSNOCO PRODUCTOPSNOCO,t2.PSDESCRI PRODUCTOPSDESCRI,t2.PSCOSE PRODUCTOPSCOSE,t2.PSNOMBREE PRODUCTOPSNOMBREE,t2.PSNOMBREI PRODUCTOPSNOMBREI,t2.PSNOMBREF PRODUCTOPSNOMBREF,t2.PSNOMBREA PRODUCTOPSNOMBREA,t2.PSNOCOE PRODUCTOPSNOCOE,t2.PSNOCOI PRODUCTOPSNOCOI,t2.PSNOCOF PRODUCTOPSNOCOF,t2.PSNOCOA PRODUCTOPSNOCOA,t2.PSDESCRIE PRODUCTOPSDESCRIE,t2.PSDESCRII PRODUCTOPSDESCRII,t2.PSDESCRIF PRODUCTOPSDESCRIF,t2.PSDESCRIA PRODUCTOPSDESCRIA,t2.PSSEL1 PRODUCTOPSSEL1,t2.PSCOINC PRODUCTOPSCOINC,t3.CMCODIGO CAMPANHACMCODIGO,t3.CMNOMBRE CAMPANHACMNOMBRE,t3.CMCOPS CAMPANHACMCOPS,t3.CMNOAR CAMPANHACMNOAR,t3.CMNOPS CAMPANHACMNOPS,t3.CMCOTMO CAMPANHACMCOTMO,t2.PSCOE8 PRODUCTOPSCOE8 " 
        	+ "FROM CAMPANHA_PROD t1 ,PRODUCTO t2 ,CAMPANHA t3 ");
      	
		if (campanhaprod  != null  && campanhaprod.getCpcodigo() != null ) {
			where.append(" AND UPPER(t1.CPCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCpcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCpcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.CPCODIGO IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscodigo() != null ) {
			where.append(" AND t2.PSCODIGO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPscodigo()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPscodigo() +"%");
			}	
			where.append(" AND t2.PSCODIGO IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null && campanhaprod.getProducto().getProdAgrupado() != null && campanhaprod.getProducto().getProdAgrupado().getE8codigo() != null ) {
			where.append(" AND UPPER(t2.PSCOE8) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getProdAgrupado().getE8codigo().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getProdAgrupado().getE8codigo().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSCOE8 IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombre() != null ) {
			where.append(" AND UPPER(t2.PSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnombre().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOMBRE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnoco() != null ) {
			where.append(" AND UPPER(t2.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnoco().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnoco().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOCO IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescri() != null ) {
			where.append(" AND UPPER(t2.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsdescri().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsdescri().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSDESCRI IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscose() != null ) {
			where.append(" AND UPPER(t2.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPscose().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPscose().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSCOSE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombree() != null ) {
			where.append(" AND UPPER(t2.PSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnombree().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnombree().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOMBREE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrei() != null ) {
			where.append(" AND UPPER(t2.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnombrei().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnombrei().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOMBREI IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombref() != null ) {
			where.append(" AND UPPER(t2.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnombref().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnombref().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOMBREF IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnombrea() != null ) {
			where.append(" AND UPPER(t2.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnombrea().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnombrea().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOMBREA IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoe() != null ) {
			where.append(" AND UPPER(t2.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnocoe().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnocoe().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOCOE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoi() != null ) {
			where.append(" AND UPPER(t2.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnocoi().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnocoi().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOCOI IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocof() != null ) {
			where.append(" AND UPPER(t2.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnocof().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnocof().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOCOF IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsnocoa() != null ) {
			where.append(" AND UPPER(t2.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsnocoa().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsnocoa().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSNOCOA IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrie() != null ) {
			where.append(" AND UPPER(t2.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsdescrie().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsdescrie().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSDESCRIE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrii() != null ) {
			where.append(" AND UPPER(t2.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsdescrii().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsdescrii().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSDESCRII IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescrif() != null ) {
			where.append(" AND UPPER(t2.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsdescrif().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsdescrif().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSDESCRIF IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPsdescria() != null ) {
			where.append(" AND UPPER(t2.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPsdescria().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPsdescria().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSDESCRIA IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPssel1() != null ) {
			where.append(" AND UPPER(t2.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPssel1().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPssel1().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSSEL1 IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getProducto() != null  && campanhaprod.getProducto().getPscoinc() != null ) {
			where.append(" AND UPPER(t2.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getProducto().getPscoinc().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getProducto().getPscoinc().toUpperCase() +"%");
			}	
			where.append(" AND t2.PSCOINC IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcodigo() != null ) {
			where.append(" AND t3.CMCODIGO like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmcodigo()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmcodigo() +"%");
			}	
			where.append(" AND t3.CMCODIGO IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnombre() != null ) {
			where.append(" AND UPPER(t3.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmnombre().toUpperCase() +"%");
			}	
			where.append(" AND t3.CMNOMBRE IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcops() != null ) {
			where.append(" AND UPPER(t3.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmcops().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmcops().toUpperCase() +"%");
			}	
			where.append(" AND t3.CMCOPS IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnoar() != null ) {
			where.append(" AND UPPER(t3.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmnoar().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmnoar().toUpperCase() +"%");
			}	
			where.append(" AND t3.CMNOAR IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmnops() != null ) {
			where.append(" AND UPPER(t3.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmnops().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmnops().toUpperCase() +"%");
			}	
			where.append(" AND t3.CMNOPS IS NOT NULL");
        }
		if (campanhaprod!=null && campanhaprod.getCampanha() != null  && campanhaprod.getCampanha().getCmcotmo() != null ) {
			where.append(" AND UPPER(t3.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCampanha().getCmcotmo().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCampanha().getCmcotmo().toUpperCase() +"%");
			}	
			where.append(" AND t3.CMCOTMO IS NOT NULL");
        }
		if (campanhaprod  != null  && campanhaprod.getCpnops() != null ) {
			where.append(" AND UPPER(t1.CPNOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanhaprod.getCpnops().toUpperCase()  +"%");
			}else{
				params.add("%"+campanhaprod.getCpnops().toUpperCase() +"%");
			}	
			where.append(" AND t1.CPNOPS IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<CampanhaProd>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

