package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Campanha;

/**
 *  * CampanhaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 *  
 */
 
@Repository
@Transactional
public class CampanhaDaoImpl implements CampanhaDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Campanha> rwMap = new RowMapper<Campanha>() {
		public Campanha mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Campanha(
               resultSet.getString("CMCODIGO"), resultSet.getString("CMNOMBRE"), resultSet.getString("CMCOPS"), resultSet.getString("CMNOAR"), resultSet.getString("CMNOPS"), resultSet.getString("CMCOTMO")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Campanha table.
     *
     * @param campanha Pagination
     * @return Campanha
     */
	public Campanha add(Campanha campanha) {

    	String query = "INSERT INTO CAMPANHA( CMCODIGO,CMNOMBRE,CMCOPS,CMNOAR,CMNOPS,CMCOTMO)"
        + "VALUES (?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, campanha.getCmcodigo(), campanha.getCmnombre(), campanha.getCmcops(), campanha.getCmnoar(), campanha.getCmnops(), campanha.getCmcotmo());
		return campanha;
	}

    /**
     * Updates a single row in the Campanha table.
     *
     * @param campanha Pagination
     * @return Campanha
     */
    public Campanha update(Campanha campanha) {
		String query = "UPDATE CAMPANHA SET CMNOMBRE=?,CMCOPS=?,CMNOAR=?,CMNOPS=?,CMCOTMO=? WHERE CMCODIGO=?";
		this.jdbcTemplate.update(query, campanha.getCmnombre(), campanha.getCmcops(), campanha.getCmnoar(), campanha.getCmnops(), campanha.getCmcotmo(), campanha.getCmcodigo());
		return campanha;
	}

    /**
     * Finds a single row in the Campanha table.
     *
     * @param campanha Pagination
     * @return Campanha
     */
    @Transactional (readOnly = true)
    public Campanha find(Campanha campanha) {
		String query = "SELECT t1.CMCODIGO CMCODIGO, t1.CMNOMBRE CMNOMBRE, t1.CMCOPS CMCOPS, t1.CMNOAR CMNOAR, t1.CMNOPS CMNOPS, t1.CMCOTMO CMCOTMO " 
         + "FROM CAMPANHA t1  " 
         + "WHERE t1.CMCODIGO = ?    ";
		return (Campanha) this.jdbcTemplate.queryForObject(query, 
			rwMap , campanha.getCmcodigo());	 
    }

    /**
     * Removes a single row in the Campanha table.
     *
     * @param campanha Pagination
     * @return
     */
    public void remove(Campanha campanha) {
		String query = "DELETE  FROM CAMPANHA WHERE CMCODIGO=?";
		this.jdbcTemplate.update(query, campanha.getCmcodigo());
    	}
    
   /**
    * Finds a List of rows in the Campanha table.
    * 
    * @param campanha Campanha
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Campanha> findAll(Campanha campanha, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CMCODIGO CMCODIGO,t1.CMNOMBRE CMNOMBRE,t1.CMCOPS CMCOPS,t1.CMNOAR CMNOAR,t1.CMNOPS CMNOPS,t1.CMCOTMO CMCOTMO " 
			+ "FROM CAMPANHA t1 ");
		
		if (campanha  != null  && campanha.getCmcodigo() != null ) {
			where.append(" AND t1.CMCODIGO = ?");
			params.add(campanha.getCmcodigo());
		}
		if (campanha  != null  && campanha.getCmnombre() != null ) {
			where.append(" AND t1.CMNOMBRE = ?");
			params.add(campanha.getCmnombre());
		}
		if (campanha  != null  && campanha.getCmcops() != null ) {
			where.append(" AND t1.CMCOPS = ?");
			params.add(campanha.getCmcops());
		}
		if (campanha  != null  && campanha.getCmnoar() != null ) {
			where.append(" AND t1.CMNOAR = ?");
			params.add(campanha.getCmnoar());
		}
		if (campanha  != null  && campanha.getCmnops() != null ) {
			where.append(" AND t1.CMNOPS = ?");
			params.add(campanha.getCmnops());
		}
		if (campanha  != null  && campanha.getCmcotmo() != null ) {
			where.append(" AND t1.CMCOTMO = ?");
			params.add(campanha.getCmcotmo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Campanha>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Campanha table.
     * 
     * @param campanha Campanha
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Campanha campanha) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  CAMPANHA t1  ");
		if (campanha  != null  && campanha.getCmcodigo() != null ) {
			where.append(" AND t1.CMCODIGO = ?");
			params.add(campanha.getCmcodigo());
		}
		if (campanha  != null  && campanha.getCmnombre() != null ) {
			where.append(" AND t1.CMNOMBRE = ?");
			params.add(campanha.getCmnombre());
		}
		if (campanha  != null  && campanha.getCmcops() != null ) {
			where.append(" AND t1.CMCOPS = ?");
			params.add(campanha.getCmcops());
		}
		if (campanha  != null  && campanha.getCmnoar() != null ) {
			where.append(" AND t1.CMNOAR = ?");
			params.add(campanha.getCmnoar());
		}
		if (campanha  != null  && campanha.getCmnops() != null ) {
			where.append(" AND t1.CMNOPS = ?");
			params.add(campanha.getCmnops());
		}
		if (campanha  != null  && campanha.getCmcotmo() != null ) {
			where.append(" AND t1.CMCOTMO = ?");
			params.add(campanha.getCmcotmo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Campanha table using like.
     * 
     * @param campanha Campanha
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Campanha> findAllLike(Campanha campanha, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.CMCODIGO CMCODIGO,t1.CMNOMBRE CMNOMBRE,t1.CMCOPS CMCOPS,t1.CMNOAR CMNOAR,t1.CMNOPS CMNOPS,t1.CMCOTMO CMCOTMO " 
        	+ "FROM CAMPANHA t1 ");
      	
		if (campanha  != null  && campanha.getCmcodigo() != null ) {
			where.append(" AND UPPER(t1.CMCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMCODIGO IS NOT NULL");
        }
		if (campanha  != null  && campanha.getCmnombre() != null ) {
			where.append(" AND UPPER(t1.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMNOMBRE IS NOT NULL");
        }
		if (campanha  != null  && campanha.getCmcops() != null ) {
			where.append(" AND UPPER(t1.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmcops().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmcops().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMCOPS IS NOT NULL");
        }
		if (campanha  != null  && campanha.getCmnoar() != null ) {
			where.append(" AND UPPER(t1.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmnoar().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmnoar().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMNOAR IS NOT NULL");
        }
		if (campanha  != null  && campanha.getCmnops() != null ) {
			where.append(" AND UPPER(t1.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmnops().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmnops().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMNOPS IS NOT NULL");
        }
		if (campanha  != null  && campanha.getCmcotmo() != null ) {
			where.append(" AND UPPER(t1.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(campanha.getCmcotmo().toUpperCase()  +"%");
			}else{
				params.add("%"+campanha.getCmcotmo().toUpperCase() +"%");
			}	
			where.append(" AND t1.CMCOTMO IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Campanha>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

