package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41a.model.Campanha;

/**
 *  * CampanhaDao generated by UDA, 22-mar-2012 16:48:05.
 *  
 */

public interface CampanhaDao {
    
    /**
     * Inserts a single row in the Campanha table.
     *
     * @param campanha Campanha
     * @return Campanha
     */
    Campanha add(Campanha campanha);

    /**
     * Updates a single row in the Campanha table.
     *
     * @param campanha Campanha
     * @return Campanha
     */
    Campanha update(Campanha campanha);

    /**
     * Finds a single row in the Campanha table.
     *
     * @param campanha Campanha
     * @return Campanha
     */
    Campanha find(Campanha campanha);

    /**
     * Deletes a single row in the Campanha table.
     *
     * @param campanha Campanha
     * @return 
     */
    void remove(Campanha campanha);

    /**
     * Finds a List of rows in the Campanha table.
     *
     * @param campanha Campanha
     * @param pagination Pagination
     * @return List
     */
    List<Campanha> findAll(Campanha campanha, Pagination pagination);

    /**
     * Counts rows in the Campanha table.
     *
     * @param campanha Campanha
     * @return List
     */
    Long findAllCount(Campanha campanha);
	
	/**
     * Finds rows in the Campanha table using like.
     *
     * @param campanha Campanha
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List
     */
	List<Campanha> findAllLike(Campanha campanha, Pagination pagination, Boolean startsWith);
}

