package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.Campanha;

/**
 * * CampahnaRecibDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class CampahnaRecibDaoImpl implements CampahnaRecibDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<CampahnaRecib> rwMap = new RowMapper<CampahnaRecib>() {
		public CampahnaRecib mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new CampahnaRecib(resultSet.getString("S4CODIGO"),
					resultSet.getString("S4CODORGANISMO"),
					resultSet.getDate("S4FECCOMUNICACION"),
					resultSet.getDate("S4FECFINALIZACION"),
					resultSet.getInt("S4CANTIDADACTUACIONES"), new Campanha(
							resultSet.getString("CampanhaCMCODIGO"),
							resultSet.getString("CampanhaCMNOMBRE"),
							resultSet.getString("CampanhaCMCOPS"),
							resultSet.getString("CampanhaCMNOAR"),
							resultSet.getString("CampanhaCMNOPS"),
							resultSet.getString("CampanhaCMCOTMO")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            Pagination
	 * @return CampahnaRecib
	 */
	public CampahnaRecib add(CampahnaRecib campahnarecib) {

		String query = "INSERT INTO CAMPAHNA_RECIB( S4CODIGO,S4CODCAMPANHA,S4CODORGANISMO,S4FECCOMUNICACION,S4FECFINALIZACION,S4CANTIDADACTUACIONES)"
				+ "VALUES (?,?,?,?,?,?)";

		Object getCampanhaCmcodigoAux = null;
		if (campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campahnarecib.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, campahnarecib.getS4codigo(),
				getCampanhaCmcodigoAux, campahnarecib.getS4codorganismo(),
				campahnarecib.getS4feccomunicacion(),
				campahnarecib.getS4fecfinalizacion(),
				campahnarecib.getS4cantidadactuaciones());
		return campahnarecib;
	}

	/**
	 * Updates a single row in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            Pagination
	 * @return CampahnaRecib
	 */
	public CampahnaRecib update(CampahnaRecib campahnarecib) {
		String query = "UPDATE CAMPAHNA_RECIB SET S4CODCAMPANHA=?,S4CODORGANISMO=?,S4FECCOMUNICACION=?,S4FECFINALIZACION=?,S4CANTIDADACTUACIONES=? WHERE S4CODIGO=?";
		Object getCampanhaCmcodigoAux = null;
		if (campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcodigo() != null) {
			getCampanhaCmcodigoAux = campahnarecib.getCampanha().getCmcodigo();
		}
		this.jdbcTemplate.update(query, getCampanhaCmcodigoAux,
				campahnarecib.getS4codorganismo(),
				campahnarecib.getS4feccomunicacion(),
				campahnarecib.getS4fecfinalizacion(),
				campahnarecib.getS4cantidadactuaciones(),
				campahnarecib.getS4codigo());
		return campahnarecib;
	}

	/**
	 * Updates a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	public CampahnaRecibBusqueda updateFinalizada(
			CampahnaRecibBusqueda campahnaRecibBusqueda) {
		String query = "UPDATE CAMPAHNA_RECIB SET S4FECFINALIZACION=SYSDATE WHERE S4CODIGO=?";

		this.jdbcTemplate.update(query,
				campahnaRecibBusqueda.getCodigoRecibida());
		return campahnaRecibBusqueda;
	}

	/**
	 * Finds a single row in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            Pagination
	 * @return CampahnaRecib
	 */
	@Transactional(readOnly = true)
	public CampahnaRecib find(CampahnaRecib campahnarecib) {
		String query = "SELECT t1.S4CODIGO S4CODIGO, t1.S4CODORGANISMO S4CODORGANISMO, t1.S4FECCOMUNICACION S4FECCOMUNICACION, t1.S4FECFINALIZACION S4FECFINALIZACION, t1.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES, t2.CMCODIGO CAMPANHACMCODIGO, t2.CMNOMBRE CAMPANHACMNOMBRE, t2.CMCOPS CAMPANHACMCOPS, t2.CMNOAR CAMPANHACMNOAR, t2.CMNOPS CAMPANHACMNOPS, t2.CMCOTMO CAMPANHACMCOTMO "
				+ "FROM CAMPAHNA_RECIB t1 , CAMPANHA t2  "
				+ "WHERE t1.S4CODIGO = ?   AND t1.S4CODCAMPANHA= t2.CMCODIGO(+)  ";
		return (CampahnaRecib) this.jdbcTemplate.queryForObject(query, rwMap,
				campahnarecib.getS4codigo());
	}

	/**
	 * Finds a single row in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	@Transactional(readOnly = true)
	public CampahnaRecibBusqueda findCampahnaRecib(
			CampahnaRecibBusqueda campahnaRecibBusqueda) {
		String query = "SELECT TIPO, CODIGO, DESCRIPCION, NUMINSPECCIONES, FECRECEPCION, FECFINALIZACION, ORGANISMO, CODRECIBIDA, CODDETALLE  "
				+ "FROM Y41A02V00  "
				+ "WHERE 1=1 AND ORGANISMO = ? AND TIPO = ? AND CODRECIBIDA = ? ";
		return (CampahnaRecibBusqueda) this.jdbcTemplate.queryForObject(
				query,
				new RowMapper<CampahnaRecibBusqueda>() {
					public CampahnaRecibBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new CampahnaRecibBusqueda(resultSet
								.getString("TIPO"), resultSet
								.getString("CODIGO"), resultSet
								.getString("DESCRIPCION"), resultSet
								.getInt("NUMINSPECCIONES"), resultSet
								.getDate("FECRECEPCION"), resultSet
								.getDate("FECFINALIZACION"), resultSet
								.getString("ORGANISMO"), resultSet
								.getString("CODRECIBIDA"), resultSet
								.getString("CODDETALLE"));
					}
				}, campahnaRecibBusqueda.getCodOrganismo(),
				campahnaRecibBusqueda.getTipo(), campahnaRecibBusqueda
						.getCodigoRecibida());

	}

	/**
	 * Removes a single row in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            Pagination
	 * @return
	 */
	public void remove(CampahnaRecib campahnarecib) {
		String query = "DELETE  FROM CAMPAHNA_RECIB WHERE S4CODIGO=?";
		this.jdbcTemplate.update(query, campahnarecib.getS4codigo());
	}

	/**
	 * Finds a List of rows in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            CampahnaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampahnaRecib> findAll(CampahnaRecib campahnarecib,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S4CODCAMPANHA= t2.CMCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S4CODIGO S4CODIGO,t1.S4CODORGANISMO S4CODORGANISMO,t1.S4FECCOMUNICACION S4FECCOMUNICACION,t1.S4FECFINALIZACION S4FECFINALIZACION,t1.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO "
						+ "FROM CAMPAHNA_RECIB t1 ,CAMPANHA t2 ");

		if (campahnarecib != null && campahnarecib.getS4codigo() != null) {
			where.append(" AND t1.S4CODIGO = ?");
			params.add(campahnarecib.getS4codigo());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campahnarecib.getCampanha().getCmcodigo());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campahnarecib.getCampanha().getCmnombre());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campahnarecib.getCampanha().getCmcops());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campahnarecib.getCampanha().getCmnoar());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campahnarecib.getCampanha().getCmnops());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campahnarecib.getCampanha().getCmcotmo());
		}
		if (campahnarecib != null && campahnarecib.getS4codorganismo() != null) {
			where.append(" AND t1.S4CODORGANISMO = ?");
			params.add(campahnarecib.getS4codorganismo());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4feccomunicacion() != null) {
			where.append(" AND t1.S4FECCOMUNICACION = ?");
			params.add(campahnarecib.getS4feccomunicacion());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4fecfinalizacion() != null) {
			where.append(" AND t1.S4FECFINALIZACION = ?");
			params.add(campahnarecib.getS4fecfinalizacion());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4cantidadactuaciones() != null) {
			where.append(" AND t1.S4CANTIDADACTUACIONES = ?");
			params.add(campahnarecib.getS4cantidadactuaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CampahnaRecib>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the CampahnaRecib table.
	 * 
	 * @param campahnarecib
	 *            CampahnaRecib
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(CampahnaRecib campahnarecib) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.S4CODCAMPANHA= t2.CMCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  CAMPAHNA_RECIB t1   ,  CAMPANHA t2  ");
		if (campahnarecib != null && campahnarecib.getS4codigo() != null) {
			where.append(" AND t1.S4CODIGO = ?");
			params.add(campahnarecib.getS4codigo());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO = ?");
			params.add(campahnarecib.getCampanha().getCmcodigo());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnombre() != null) {
			where.append(" AND t2.CMNOMBRE = ?");
			params.add(campahnarecib.getCampanha().getCmnombre());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcops() != null) {
			where.append(" AND t2.CMCOPS = ?");
			params.add(campahnarecib.getCampanha().getCmcops());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnoar() != null) {
			where.append(" AND t2.CMNOAR = ?");
			params.add(campahnarecib.getCampanha().getCmnoar());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnops() != null) {
			where.append(" AND t2.CMNOPS = ?");
			params.add(campahnarecib.getCampanha().getCmnops());
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcotmo() != null) {
			where.append(" AND t2.CMCOTMO = ?");
			params.add(campahnarecib.getCampanha().getCmcotmo());
		}
		if (campahnarecib != null && campahnarecib.getS4codorganismo() != null) {
			where.append(" AND t1.S4CODORGANISMO = ?");
			params.add(campahnarecib.getS4codorganismo());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4feccomunicacion() != null) {
			where.append(" AND t1.S4FECCOMUNICACION = ?");
			params.add(campahnarecib.getS4feccomunicacion());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4fecfinalizacion() != null) {
			where.append(" AND t1.S4FECFINALIZACION = ?");
			params.add(campahnarecib.getS4fecfinalizacion());
		}
		if (campahnarecib != null
				&& campahnarecib.getS4cantidadactuaciones() != null) {
			where.append(" AND t1.S4CANTIDADACTUACIONES = ?");
			params.add(campahnarecib.getS4cantidadactuaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the CampahnaRecib table using like.
	 * 
	 * @param campahnarecib
	 *            CampahnaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampahnaRecib> findAllLike(CampahnaRecib campahnarecib,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S4CODCAMPANHA= t2.CMCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S4CODIGO S4CODIGO,t1.S4CODORGANISMO S4CODORGANISMO,t1.S4FECCOMUNICACION S4FECCOMUNICACION,t1.S4FECFINALIZACION S4FECFINALIZACION,t1.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES,t2.CMCODIGO CAMPANHACMCODIGO,t2.CMNOMBRE CAMPANHACMNOMBRE,t2.CMCOPS CAMPANHACMCOPS,t2.CMNOAR CAMPANHACMNOAR,t2.CMNOPS CAMPANHACMNOPS,t2.CMCOTMO CAMPANHACMCOTMO "
						+ "FROM CAMPAHNA_RECIB t1 ,CAMPANHA t2 ");

		if (campahnarecib != null && campahnarecib.getS4codigo() != null) {
			where.append(" AND UPPER(t1.S4CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getS4codigo().toUpperCase() + "%");
			} else {
				params.add("%" + campahnarecib.getS4codigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.S4CODIGO IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.CMCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmcodigo() + "%");
			} else {
				params.add("%" + campahnarecib.getCampanha().getCmcodigo()
						+ "%");
			}
			where.append(" AND t2.CMCODIGO IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnombre() != null) {
			where.append(" AND UPPER(t2.CMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getCampanha().getCmnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CMNOMBRE IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcops() != null) {
			where.append(" AND UPPER(t2.CMCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmcops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getCampanha().getCmcops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CMCOPS IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnoar() != null) {
			where.append(" AND UPPER(t2.CMNOAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmnoar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getCampanha().getCmnoar().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CMNOAR IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmnops() != null) {
			where.append(" AND UPPER(t2.CMNOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmnops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getCampanha().getCmnops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CMNOPS IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getCampanha() != null
				&& campahnarecib.getCampanha().getCmcotmo() != null) {
			where.append(" AND UPPER(t2.CMCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getCampanha().getCmcotmo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getCampanha().getCmcotmo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CMCOTMO IS NOT NULL");
		}
		if (campahnarecib != null && campahnarecib.getS4codorganismo() != null) {
			where.append(" AND UPPER(t1.S4CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getS4codorganismo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ campahnarecib.getS4codorganismo().toUpperCase() + "%");
			}
			where.append(" AND t1.S4CODORGANISMO IS NOT NULL");
		}
		if (campahnarecib != null
				&& campahnarecib.getS4feccomunicacion() != null) {
			where.append(" AND t1.S4FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getS4feccomunicacion() + "%");
			} else {
				params.add("%" + campahnarecib.getS4feccomunicacion() + "%");
			}
			where.append(" AND t1.S4FECCOMUNICACION IS NOT NULL");
		}
		if (campahnarecib != null
				&& campahnarecib.getS4fecfinalizacion() != null) {
			where.append(" AND t1.S4FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getS4fecfinalizacion() + "%");
			} else {
				params.add("%" + campahnarecib.getS4fecfinalizacion() + "%");
			}
			where.append(" AND t1.S4FECFINALIZACION IS NOT NULL");
		}
		if (campahnarecib != null
				&& campahnarecib.getS4cantidadactuaciones() != null) {
			where.append(" AND t1.S4CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnarecib.getS4cantidadactuaciones() + "%");
			} else {
				params.add("%" + campahnarecib.getS4cantidadactuaciones() + "%");
			}
			where.append(" AND t1.S4CANTIDADACTUACIONES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CampahnaRecib>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds rows in the CampahnaRecib table using like.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampahnaRecibBusqueda> findAllLikeCampahna(
			CampahnaRecibBusqueda campahnaRecibBusqueda, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer(
				"SELECT TIPO, CODIGO, DESCRIPCION, NUMINSPECCIONES, FECRECEPCION, FECFINALIZACION, ORGANISMO, CODRECIBIDA, CODDETALLE "
						+ " FROM Y41A02V00 ");

		where.append(" AND ORGANISMO = ?");
		params.add(campahnaRecibBusqueda.getCodOrganismo());

		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getTipo() != null) {
			where.append(" AND TIPO = ?");
			params.add(campahnaRecibBusqueda.getTipo());
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getDescripcion() != null) {
			where.append(" AND TRANSLATE(UPPER(DESCRIPCION),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnaRecibBusqueda.getDescripcion().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ campahnaRecibBusqueda.getDescripcion().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND DESCRIPCION IS NOT NULL");
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getFecrecepcionDesde() != null) {
			where.append(" AND FECRECEPCION >= ?");
			params.add(campahnaRecibBusqueda.getFecrecepcionDesde());
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getFecrecepcionHasta() != null) {
			where.append(" AND FECRECEPCION <= ?");
			params.add(campahnaRecibBusqueda.getFecrecepcionHasta());
		}

		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getMostrarFinalizadas() == null) {
			where.append(" AND FECFINALIZACION IS NULL ");
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc() + " NULLS LAST ");
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CampahnaRecibBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<CampahnaRecibBusqueda>() {
					public CampahnaRecibBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new CampahnaRecibBusqueda(resultSet
								.getString("TIPO"), resultSet
								.getString("CODIGO"), resultSet
								.getString("DESCRIPCION"), resultSet
								.getInt("NUMINSPECCIONES"), resultSet
								.getDate("FECRECEPCION"), resultSet
								.getDate("FECFINALIZACION"), resultSet
								.getString("ORGANISMO"), resultSet
								.getString("CODRECIBIDA"), resultSet
								.getString("CODDETALLE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the CampahnaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCampahnaCount(
			CampahnaRecibBusqueda campahnaRecibBusqueda, Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM Y41A02V00 ");

		where.append(" AND ORGANISMO = ?");
		params.add(campahnaRecibBusqueda.getCodOrganismo());

		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getTipo() != null) {
			where.append(" AND TIPO = ?");
			params.add(campahnaRecibBusqueda.getTipo());
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getDescripcion() != null) {
			where.append(" AND TRANSLATE(UPPER(DESCRIPCION),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(campahnaRecibBusqueda.getDescripcion().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ campahnaRecibBusqueda.getDescripcion().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND DESCRIPCION IS NOT NULL");
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getFecrecepcionDesde() != null) {
			where.append(" AND FECRECEPCION >= ?");
			params.add(campahnaRecibBusqueda.getFecrecepcionDesde());
		}
		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getFecrecepcionHasta() != null) {
			where.append(" AND FECRECEPCION <= ?");
			params.add(campahnaRecibBusqueda.getFecrecepcionHasta());
		}

		if (campahnaRecibBusqueda != null
				&& campahnaRecibBusqueda.getMostrarFinalizadas() == null) {
			where.append(" AND FECFINALIZACION IS NULL ");
		}

		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
