package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.BandejaSolicitudesKonbide;

/**
 * BandejaSolicitudesDao generated by UDA, 02-oct-2013 9:38:26.
 * 
 *  
 */

@Repository
@Transactional
public class BandejaSolicitudesDaoImpl implements BandejaSolicitudesDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<BandejaSolicitudesKonbide> rwMap = new RowMapper<BandejaSolicitudesKonbide>() {
		public BandejaSolicitudesKonbide mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new BandejaSolicitudesKonbide(
					resultSet.getString("EHCODIGO"),
					resultSet.getString("HDCODIGO"),
					resultSet.getString("DECOOR"),
					resultSet.getBigDecimal("DENRAN"),
					resultSet.getBigDecimal("DENROR"),
					resultSet.getBigDecimal("HDNROR"),
					resultSet.getString("DECOTFP"),
					resultSet.getString("HDCOMO"),
					resultSet.getString("HDCOSC"),
					resultSet.getString("HCCOOR"),
					resultSet.getString("FCODIGOACTUAL"),
					resultSet.getString("TRCODIGOACTUAL"),
					resultSet.getString("Q5ORIGEN"),
					resultSet.getString("Q5NOFILE"),
					resultSet.getDate("FECHATRAMITE"),
					resultSet.getString("IDDESTINATARIO"),
					resultSet.getString("ESTADOTRAMITE"),
					resultSet.getDate("FECHALIMITE"),
					resultSet.getString("INDAVISO"),
					resultSet.getString("TIPOAVISO"), null);
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            Pagination
	 * @return BandejaSolicitudesKonbide
	 */
	public BandejaSolicitudesKonbide add(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		String query = "INSERT INTO BANDEJA_SOLICITUDES (EHCODIGO, HDCODIGO, DECOOR, DENRAN, DENROR, HDNROR, DECOTFP, HDCOMO, HDCOSC, HCCOOR, FCODIGOACTUAL, TRCODIGOACTUAL, Q5ORIGEN, Q5NOFILE, FECHATRAMITE, IDDESTINATARIO, ESTADOTRAMITE, FECHALIMITE, INDAVISO, TIPOAVISO) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query,
				BandejaSolicitudesKonbide.getEhcodigo(),
				BandejaSolicitudesKonbide.getHdcodigo(),
				BandejaSolicitudesKonbide.getDecoor(),
				BandejaSolicitudesKonbide.getDenran(),
				BandejaSolicitudesKonbide.getDenror(),
				BandejaSolicitudesKonbide.getHdnror(),
				BandejaSolicitudesKonbide.getDecotfp(),
				BandejaSolicitudesKonbide.getHdcomo(),
				BandejaSolicitudesKonbide.getHdcosc(),
				BandejaSolicitudesKonbide.getHccoor(),
				BandejaSolicitudesKonbide.getFcodigoactual(),
				BandejaSolicitudesKonbide.getTrcodigoactual(),
				BandejaSolicitudesKonbide.getQ5origen(),
				BandejaSolicitudesKonbide.getQ5nofile(),
				BandejaSolicitudesKonbide.getFechatramite(),
				BandejaSolicitudesKonbide.getIddestinatario(),
				BandejaSolicitudesKonbide.getEstadotramite(),
				BandejaSolicitudesKonbide.getFechalimite(),
				BandejaSolicitudesKonbide.getIndaviso(),
				BandejaSolicitudesKonbide.getTipoaviso());
		return BandejaSolicitudesKonbide;
	}

	/**
	 * Updates a single row in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            Pagination
	 * @return BandejaSolicitudesKonbide
	 */
	public BandejaSolicitudesKonbide update(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		String query = "UPDATE BANDEJA_SOLICITUDES SET HDCODIGO=?, DECOOR=?, DENRAN=?, DENROR=?, HDNROR=?, DECOTFP=?, HDCOMO=?, HDCOSC=?, HCCOOR=?, FCODIGOACTUAL=?, TRCODIGOACTUAL=?, Q5ORIGEN=?, Q5NOFILE=?, FECHATRAMITE=?, IDDESTINATARIO=?, ESTADOTRAMITE=?, FECHALIMITE=?, INDAVISO=?, TIPOAVISO=? WHERE EHCODIGO=?";
		this.jdbcTemplate.update(query,
				BandejaSolicitudesKonbide.getHdcodigo(),
				BandejaSolicitudesKonbide.getDecoor(),
				BandejaSolicitudesKonbide.getDenran(),
				BandejaSolicitudesKonbide.getDenror(),
				BandejaSolicitudesKonbide.getHdnror(),
				BandejaSolicitudesKonbide.getDecotfp(),
				BandejaSolicitudesKonbide.getHdcomo(),
				BandejaSolicitudesKonbide.getHdcosc(),
				BandejaSolicitudesKonbide.getHccoor(),
				BandejaSolicitudesKonbide.getFcodigoactual(),
				BandejaSolicitudesKonbide.getTrcodigoactual(),
				BandejaSolicitudesKonbide.getQ5origen(),
				BandejaSolicitudesKonbide.getQ5nofile(),
				BandejaSolicitudesKonbide.getFechatramite(),
				BandejaSolicitudesKonbide.getIddestinatario(),
				BandejaSolicitudesKonbide.getEstadotramite(),
				BandejaSolicitudesKonbide.getFechalimite(),
				BandejaSolicitudesKonbide.getIndaviso(),
				BandejaSolicitudesKonbide.getTipoaviso(),
				BandejaSolicitudesKonbide.getEhcodigo());
		return BandejaSolicitudesKonbide;
	}

	/**
	 * Finds a single row in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            Pagination
	 * @return BandejaSolicitudesKonbide
	 */
	@Transactional(readOnly = true)
	public BandejaSolicitudesKonbide find(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		String query = "SELECT t1.EHCODIGO EHCODIGO, t1.HDCODIGO HDCODIGO, t1.DECOOR DECOOR, t1.DENRAN DENRAN, t1.DENROR DENROR, t1.HDNROR HDNROR, t1.DECOTFP DECOTFP, t1.HDCOMO HDCOMO, t1.HDCOSC HDCOSC, t1.HCCOOR HCCOOR, t1.FCODIGOACTUAL FCODIGOACTUAL, t1.TRCODIGOACTUAL TRCODIGOACTUAL, t1.Q5ORIGEN Q5ORIGEN, t1.Q5NOFILE Q5NOFILE, t1.FECHATRAMITE FECHATRAMITE, t1.IDDESTINATARIO IDDESTINATARIO, t1.ESTADOTRAMITE ESTADOTRAMITE, t1.FECHALIMITE FECHALIMITE, t1.INDAVISO INDAVISO, t1.TIPOAVISO TIPOAVISO FROM BANDEJA_SOLICITUDES t1  WHERE t1.EHCODIGO = ?  ";

		List<BandejaSolicitudesKonbide> BandejaSolicitudesKonbideList = this.jdbcTemplate
				.query(query, this.rwMap,
						BandejaSolicitudesKonbide.getEhcodigo());
		return (BandejaSolicitudesKonbide) DataAccessUtils
				.uniqueResult(BandejaSolicitudesKonbideList);
	}

	/**
	 * Removes a single row in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            Pagination
	 * @return
	 */
	public void remove(BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		String query = "DELETE FROM BANDEJA_SOLICITUDES WHERE EHCODIGO=?";
		this.jdbcTemplate
				.update(query, BandejaSolicitudesKonbide.getEhcodigo());
	}

	/**
	 * Removes a single row in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            Pagination
	 * @return
	 */
	public void removeAllTramitesExpediente(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		String query = "DELETE FROM BANDEJA_SOLICITUDES WHERE HDCODIGO=?";
		this.jdbcTemplate
				.update(query, BandejaSolicitudesKonbide.getHdcodigo());
	}

	/**
	 * Finds a List of rows in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesKonbide> findAll(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Pagination pagination) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.HDCODIGO HDCODIGO,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.HDNROR HDNROR,t1.DECOTFP DECOTFP,t1.HDCOMO HDCOMO,t1.HDCOSC HDCOSC,t1.HCCOOR HCCOOR,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.Q5ORIGEN Q5ORIGEN,t1.Q5NOFILE Q5NOFILE,t1.FECHATRAMITE FECHATRAMITE,t1.IDDESTINATARIO IDDESTINATARIO,t1.ESTADOTRAMITE ESTADOTRAMITE,t1.FECHALIMITE FECHALIMITE,t1.INDAVISO INDAVISO,t1.TIPOAVISO TIPOAVISO ");
		query.append("FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(BandejaSolicitudesKonbide);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<BandejaSolicitudesKonbide>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaSolicitudesKonbide table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(BandejaSolicitudesKonbide);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the BandejaSolicitudesKonbide table using like.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesKonbide> findAllLike(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Pagination pagination, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.EHCODIGO EHCODIGO,t1.HDCODIGO HDCODIGO,t1.DECOOR DECOOR,t1.DENRAN DENRAN,t1.DENROR DENROR,t1.HDNROR HDNROR,t1.DECOTFP DECOTFP,t1.HDCOMO HDCOMO,t1.HDCOSC HDCOSC,t1.HCCOOR HCCOOR,t1.FCODIGOACTUAL FCODIGOACTUAL,t1.TRCODIGOACTUAL TRCODIGOACTUAL,t1.Q5ORIGEN Q5ORIGEN,t1.Q5NOFILE Q5NOFILE,t1.FECHATRAMITE FECHATRAMITE,t1.IDDESTINATARIO IDDESTINATARIO,t1.ESTADOTRAMITE ESTADOTRAMITE,t1.FECHALIMITE FECHALIMITE,t1.INDAVISO INDAVISO,t1.TIPOAVISO TIPOAVISO ");
		query.append("FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				BandejaSolicitudesKonbide, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return (List<BandejaSolicitudesKonbide>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Counts rows in the BandejaSolicitudesKonbide table using like.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM BANDEJA_SOLICITUDES t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				BandejaSolicitudesKonbide, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaSolicitudesKonbide entity
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {

		StringBuilder where = new StringBuilder(
				BandejaSolicitudesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getEhcodigo() != null) {
			where.append(" AND t1.EHCODIGO = ?");
			params.add(BandejaSolicitudesKonbide.getEhcodigo());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcodigo() != null) {
			where.append(" AND t1.HDCODIGO = ?");
			params.add(BandejaSolicitudesKonbide.getHdcodigo());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDecoor() != null) {
			where.append(" AND t1.DECOOR = ?");
			params.add(BandejaSolicitudesKonbide.getDecoor());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(BandejaSolicitudesKonbide.getDenran());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(BandejaSolicitudesKonbide.getDenror());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(BandejaSolicitudesKonbide.getHdnror());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDecotfp() != null) {
			where.append(" AND t1.DECOTFP = ?");
			params.add(BandejaSolicitudesKonbide.getDecotfp());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcomo() != null) {
			where.append(" AND t1.HDCOMO = ?");
			params.add(BandejaSolicitudesKonbide.getHdcomo());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcosc() != null) {
			where.append(" AND t1.HDCOSC = ?");
			params.add(BandejaSolicitudesKonbide.getHdcosc());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHccoor() != null) {
			where.append(" AND t1.HCCOOR = ?");
			params.add(BandejaSolicitudesKonbide.getHccoor());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFcodigoactual() != null) {
			where.append(" AND t1.FCODIGOACTUAL = ?");
			params.add(BandejaSolicitudesKonbide.getFcodigoactual());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getTrcodigoactual() != null) {
			where.append(" AND t1.TRCODIGOACTUAL = ?");
			params.add(BandejaSolicitudesKonbide.getTrcodigoactual());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getQ5origen() != null) {
			where.append(" AND t1.Q5ORIGEN = ?");
			params.add(BandejaSolicitudesKonbide.getQ5origen());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getQ5nofile() != null) {
			where.append(" AND t1.Q5NOFILE = ?");
			params.add(BandejaSolicitudesKonbide.getQ5nofile());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(BandejaSolicitudesKonbide.getFechatramite());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getIddestinatario() != null) {
			where.append(" AND t1.IDDESTINATARIO = ?");
			params.add(BandejaSolicitudesKonbide.getIddestinatario());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getEstadotramite() != null) {
			where.append(" AND t1.ESTADOTRAMITE = ?");
			params.add(BandejaSolicitudesKonbide.getEstadotramite());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(BandejaSolicitudesKonbide.getFechalimite());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getIndaviso() != null) {
			where.append(" AND t1.INDAVISO = ?");
			params.add(BandejaSolicitudesKonbide.getIndaviso());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getTipoaviso() != null) {
			where.append(" AND t1.TIPOAVISO = ?");
			params.add(BandejaSolicitudesKonbide.getTipoaviso());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the BandejaSolicitudesKonbide entity
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereLikeMap(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				BandejaSolicitudesDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getEhcodigo() != null) {
			where.append(" AND UPPER(t1.EHCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getEhcodigo()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getEhcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.EHCODIGO IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcodigo() != null) {
			where.append(" AND UPPER(t1.HDCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getHdcodigo()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getHdcodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HDCODIGO IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDecoor() != null) {
			where.append(" AND UPPER(t1.DECOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getDecoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getDecoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DECOOR IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDenran() != null) {
			where.append(" AND t1.DENRAN = ?");
			params.add(BandejaSolicitudesKonbide.getDenran());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDenror() != null) {
			where.append(" AND t1.DENROR = ?");
			params.add(BandejaSolicitudesKonbide.getDenror());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdnror() != null) {
			where.append(" AND t1.HDNROR = ?");
			params.add(BandejaSolicitudesKonbide.getHdnror());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getDecotfp() != null) {
			where.append(" AND UPPER(t1.DECOTFP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getDecotfp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getDecotfp().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DECOTFP IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcomo() != null) {
			where.append(" AND UPPER(t1.HDCOMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getHdcomo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getHdcomo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HDCOMO IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHdcosc() != null) {
			where.append(" AND UPPER(t1.HDCOSC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getHdcosc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getHdcosc().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HDCOSC IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getHccoor() != null) {
			where.append(" AND UPPER(t1.HCCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getHccoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getHccoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.HCCOOR IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFcodigoactual() != null) {
			where.append(" AND UPPER(t1.FCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getFcodigoactual()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getFcodigoactual()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.FCODIGOACTUAL IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getTrcodigoactual() != null) {
			where.append(" AND UPPER(t1.TRCODIGOACTUAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getTrcodigoactual()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getTrcodigoactual()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TRCODIGOACTUAL IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getQ5origen() != null) {
			where.append(" AND UPPER(t1.Q5ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getQ5origen()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getQ5origen().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5ORIGEN IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getQ5nofile() != null) {
			where.append(" AND UPPER(t1.Q5NOFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getQ5nofile()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getQ5nofile().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.Q5NOFILE IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFechatramite() != null) {
			where.append(" AND t1.FECHATRAMITE = ?");
			params.add(BandejaSolicitudesKonbide.getFechatramite());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getIddestinatario() != null) {
			where.append(" AND UPPER(t1.IDDESTINATARIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getIddestinatario()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getIddestinatario()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.IDDESTINATARIO IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getEstadotramite() != null) {
			where.append(" AND UPPER(t1.ESTADOTRAMITE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getEstadotramite()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getEstadotramite()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.ESTADOTRAMITE IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getFechalimite() != null) {
			where.append(" AND t1.FECHALIMITE = ?");
			params.add(BandejaSolicitudesKonbide.getFechalimite());
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getIndaviso() != null) {
			where.append(" AND UPPER(t1.INDAVISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getIndaviso()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getIndaviso().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.INDAVISO IS NOT NULL");
		}
		if (BandejaSolicitudesKonbide != null
				&& BandejaSolicitudesKonbide.getTipoaviso() != null) {
			where.append(" AND UPPER(t1.TIPOAVISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(BandejaSolicitudesKonbide.getTipoaviso()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ BandejaSolicitudesKonbide.getTipoaviso()
								.toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOAVISO IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesKonbide> findAllTramitesPendientesSolicitudes(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t2.HDCODIGO HDCODIGO, t3.DECOOR DECOOR, t3.DENRAN DENRAN, t3.DENROR DENROR, t2.HDNROR HDNROR, t3.DECOTFP DECOTFP, t2.HDCOMO HDCOMO, t2.HDCOSC HDCOSC, t4.HCCOOR HCCOOR, t2.FCODIGOACTUAL FCODIGOACTUAL, t1.EHCOTEE TRCODIGOACTUAL, t1.EHFECHAINICIO FECHATRAMITE,	t1.EHIDDESTINATARIO IDDESTINATARIO,	t1.EHESTADOTRAMITE ESTADOTRAMITE ");
		query.append("FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(BandejaSolicitudesKonbide.getHdcodigo());

		where.append(" AND t1.EHFECHAINICIO IS NOT NULL AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		return (List<BandejaSolicitudesKonbide>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<BandejaSolicitudesKonbide>() {
					public BandejaSolicitudesKonbide mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						return new BandejaSolicitudesKonbide(resultSet
								.getString("EHCODIGO"), resultSet
								.getString("HDCODIGO"), resultSet
								.getString("DECOOR"), resultSet
								.getBigDecimal("DENRAN"), resultSet
								.getBigDecimal("DENROR"), resultSet
								.getBigDecimal("HDNROR"), resultSet
								.getString("DECOTFP"), resultSet
								.getString("HDCOMO"), resultSet
								.getString("HDCOSC"), resultSet
								.getString("HCCOOR"), resultSet
								.getString("FCODIGOACTUAL"), resultSet
								.getString("TRCODIGOACTUAL"), null, null,
								resultSet.getDate("FECHATRAMITE"), resultSet
										.getString("IDDESTINATARIO"), resultSet
										.getString("ESTADOTRAMITE"), null,
								null, null, resultSet.getString("EHCOTEE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesPendientesSolicitudesCount(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(BandejaSolicitudesKonbide.getHdcodigo());

		where.append(" AND t1.EHFECHAFIN IS NULL ");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the tramites hecho table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<BandejaSolicitudesKonbide> findAllTramitesFinalizadosSolicitudes(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide,
			Pagination pagination) {

		StringBuilder query = new StringBuilder(
				"SELECT t1.EHCODIGO EHCODIGO, t1.EHCOTEE EHCOTEE, t2.HDCODIGO HDCODIGO, t3.DECOOR DECOOR, t3.DENRAN DENRAN, t3.DENROR DENROR, t2.HDNROR HDNROR, t3.DECOTFP DECOTFP, t2.HDCOMO HDCOMO, t2.HDCOSC HDCOSC, t4.HCCOOR HCCOOR, t2.FCODIGOACTUAL FCODIGOACTUAL, t2.TRCODIGOACTUAL TRCODIGOACTUAL,	t1.EHFECHAFIN FECHATRAMITE,	t1.EHIDDESTINATARIO IDDESTINATARIO,	t1.EHESTADOTRAMITE ESTADOTRAMITE ");
		query.append("FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(BandejaSolicitudesKonbide.getHdcodigo());

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);

		query.append(" ORDER BY EHFECHA DESC, EHHORA DESC ");

		return (List<BandejaSolicitudesKonbide>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<BandejaSolicitudesKonbide>() {
					public BandejaSolicitudesKonbide mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						return new BandejaSolicitudesKonbide(resultSet
								.getString("EHCODIGO"), resultSet
								.getString("HDCODIGO"), resultSet
								.getString("DECOOR"), resultSet
								.getBigDecimal("DENRAN"), resultSet
								.getBigDecimal("DENROR"), resultSet
								.getBigDecimal("HDNROR"), resultSet
								.getString("DECOTFP"), resultSet
								.getString("HDCOMO"), resultSet
								.getString("HDCOSC"), resultSet
								.getString("HCCOOR"), resultSet
								.getString("FCODIGOACTUAL"), resultSet
								.getString("TRCODIGOACTUAL"), null, null,
								resultSet.getDate("FECHATRAMITE"), resultSet
										.getString("IDDESTINATARIO"), resultSet
										.getString("ESTADOTRAMITE"), null,
								null, null, resultSet.getString("EHCOTEE"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the tramites hecho table.
	 * 
	 * @param BandejaSolicitudesKonbide
	 *            BandejaSolicitudesKonbide
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllTramitesFinalizadosSolicitudesCount(
			BandejaSolicitudesKonbide BandejaSolicitudesKonbide) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM TRAMITE_HECHO t1, HECHO_DENUNCIADO t2, DENUNCIA t3,DECISION_HECHO t4 WHERE  (1=1) AND t1.EHCOHD = t2.HDCODIGO AND t2.HDCODE = t3.DECODIGO AND t2.HDCODIGO = t4.HCCOHD  ");

		StringBuilder where = new StringBuilder();

		List<Object> params = new ArrayList<Object>();
		where.append(" AND t2.HDCODIGO= ? ");
		params.add(BandejaSolicitudesKonbide.getHdcodigo());

		where.append(" AND t1.EHFECHAFIN IS NOT NULL ");

		query.append(where);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}
}
