package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.AnalisisDetalle;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.OriProdAlerta;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipCaracMuestra;
import com.ejie.y41a.model.TipDepoMuestra;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipmotActuacion;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Analisis;

/**
 * * AnalisisDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class AnalisisDaoImpl implements AnalisisDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Analisis> rwMap = new RowMapper<Analisis>() {
		public Analisis mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Analisis(
					resultSet.getString("ANCODIGO"),
					resultSet.getString("ANCOHD"),
					resultSet.getInt("ANNRMU"),
					resultSet.getBigDecimal("ANNRAN"),
					resultSet.getString("ANCOOR"),
					resultSet.getString("ANTEESTM"),
					resultSet.getBigDecimal("ANCAPTPM"),
					resultSet.getString("ANCOLA"),
					resultSet.getString("ANTEDEAS"),
					resultSet.getDate("ANFEREEL"),
					resultSet.getString("ANNRBOAN"),
					resultSet.getDate("ANFEBOAN"),
					resultSet.getString("ANTEINBA"),
					resultSet.getDate("ANFECRAR"),
					resultSet.getString("ANINEXAC"),
					resultSet.getString("ANINEXAD"),
					resultSet.getDate("ANFECOAC"),
					resultSet.getString("ANINREAC"),
					resultSet.getString("ANINLACI"),
					resultSet.getDate("ANFECEAC"),
					resultSet.getDate("ANFEENAC"),
					resultSet.getDate("ANFEBOAC"),
					resultSet.getString("ANINRSAC"),
					resultSet.getDate("ANFERBAC"),
					resultSet.getDate("ANFEERAC"),
					resultSet.getDate("ANFESOAD"),
					resultSet.getDate("ANFEBOAD"),
					resultSet.getString("ANINREAD"),
					resultSet.getDate("ANFECORA"),
					new TipCaracMuestra(resultSet
							.getString("TipCaracMuestraTCTCODIGO"), resultSet
							.getString("TipCaracMuestraTCTNOMBRE")),
					new TipDepoMuestra(resultSet
							.getString("TipDepoMuestraTDMCODIGO"), resultSet
							.getString("TipDepoMuestraTDMNOMBRE")),
					new Actuacion(
							resultSet.getString("ActuacionATCODIGO"),
							resultSet.getBigDecimal("ActuacionATNROR"),
							resultSet.getString("ActuacionATCOAV"),
							resultSet.getString("ActuacionATCOSE"),
							resultSet.getString("ActuacionATNOPRSE"),
							resultSet.getString("ActuacionATNOMAPS"),
							resultSet.getString("ActuacionATNOMOPS"),
							resultSet.getString("ActuacionATNRLOPS"),
							resultSet.getDate("ActuacionATFEDUMI"),
							resultSet.getString("ActuacionATINPRSE"),
							resultSet.getBigDecimal("ActuacionATCAUNEP"),
							resultSet.getString("ActuacionATTEINFO"),
							resultSet.getString("ActuacionATCOAT"),
							new TipProtocolo(resultSet
									.getString("ActuacionATCOTP"), null, null,
									null, null, null),
							new Acta(resultSet.getString("ActuacionATCOAC"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null),
							new CampahnaRecib(resultSet
									.getString("ActuacionATCOCM"), null, null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("ActuacionATCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null),
							new Producto(
									resultSet.getString("ActuacionATCOPS"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new DenunciaRecib(resultSet
									.getString("ActuacionATCOHD"), null, null,
									null, null, null, null),
							new AlertaRecib(resultSet
									.getString("ActuacionATCOAL"), null, null,
									null, null, null, null, null),
							new TipActuacion(resultSet
									.getString("ActuacionATCOTTA"), null, null),
							new TipmotActuacion(resultSet
									.getString("ActuacionATCOTMA"), null, null)),
					new OriProdAlerta(resultSet
							.getString("OriProdAlertaTOMCODIGO"), resultSet
							.getString("OriProdAlertaTOMNOMBRE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Pagination
	 * @return Analisis
	 */
	public Analisis add(Analisis analisis) {

		String query = "INSERT INTO ANALISIS( ANCODIGO,ANCOTCT,ANCOTDM,ANCOAT,ANCOTOM,ANCOHD,ANNRMU,ANNRAN,ANCOOR,ANTEESTM,ANCAPTPM,ANCOLA,ANTEDEAS,ANFEREEL,ANNRBOAN,ANFEBOAN,ANTEINBA,ANFECRAR,ANINEXAC,ANINEXAD,ANFECOAC,ANINREAC,ANINLACI,ANFECEAC,ANFEENAC,ANFEBOAC,ANINRSAC,ANFERBAC,ANFEERAC,ANFESOAD,ANFEBOAD,ANINREAD,ANFECORA)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTipCaracMuestraTctcodigoAux = null;
		if (analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctcodigo() != null) {
			getTipCaracMuestraTctcodigoAux = analisis.getTipCaracMuestra()
					.getTctcodigo();
		}
		Object getTipDepoMuestraTdmcodigoAux = null;
		if (analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmcodigo() != null) {
			getTipDepoMuestraTdmcodigoAux = analisis.getTipDepoMuestra()
					.getTdmcodigo();
		}
		Object getActuacionAtcodigoAux = null;
		if (analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = analisis.getActuacion().getAtcodigo();
		}
		Object getOriProdAlertaTomcodigoAux = null;
		if (analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomcodigo() != null) {
			getOriProdAlertaTomcodigoAux = analisis.getOriProdAlerta()
					.getTomcodigo();
		}
		this.jdbcTemplate.update(query, analisis.getAncodigo(),
				getTipCaracMuestraTctcodigoAux, getTipDepoMuestraTdmcodigoAux,
				getActuacionAtcodigoAux, getOriProdAlertaTomcodigoAux,
				analisis.getAncohd(), analisis.getAnnrmu(),
				analisis.getAnnran(), analisis.getAncoor(),
				analisis.getAnteestm(), analisis.getAncaptpm(),
				analisis.getAncola(), analisis.getAntedeas(),
				analisis.getAnfereel(), analisis.getAnnrboan(),
				analisis.getAnfeboan(), analisis.getAnteinba(),
				analisis.getAnfecrar(), analisis.getAninexac(),
				analisis.getAninexad(), analisis.getAnfecoac(),
				analisis.getAninreac(), analisis.getAninlaci(),
				analisis.getAnfeceac(), analisis.getAnfeenac(),
				analisis.getAnfeboac(), analisis.getAninrsac(),
				analisis.getAnferbac(), analisis.getAnfeerac(),
				analisis.getAnfesoad(), analisis.getAnfeboad(),
				analisis.getAninread(), analisis.getAnfecora());
		return analisis;
	}

	/**
	 * Inserts a single row in the Analisis table.
	 * 
	 * @param analisisDetalle
	 *            AnalisisDetalle
	 * @return AnalisisDetalle
	 */
	public AnalisisDetalle addMuestra(AnalisisDetalle analisisDetalle) {

		String query = "INSERT INTO ANALISIS( ANCODIGO,ANCOTCT,ANCOTDM,ANCOAT,ANCOTOM,ANNRMU,ANNRAN,ANCOOR,ANTEESTM,ANCAPTPM)"
				+ "VALUES (?,?,?,?,?,(SELECT NVL(MAX(ABS(ANNRMU)),0)+1 FROM ANALISIS WHERE ANCOOR = ? AND ANNRAN = ?),?,?,?,?)";

		this.jdbcTemplate.update(query, analisisDetalle.getAncodigo(),
				analisisDetalle.getTctcodigo(), analisisDetalle.getTdmcodigo(),
				analisisDetalle.getAtcodigo(), analisisDetalle.getTomcodigo(),
				analisisDetalle.getAncoor(), analisisDetalle.getAnnran(),
				analisisDetalle.getAnnran(), analisisDetalle.getAncoor(),
				analisisDetalle.getAnteestm(), analisisDetalle.getAncaptpm());

		return analisisDetalle;
	}

	/**
	 * Updates a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Pagination
	 * @return Analisis
	 */
	public Analisis update(Analisis analisis) {
		String query = "UPDATE ANALISIS SET ANCOTCT=?,ANCOTDM=?,ANCOAT=?,ANCOTOM=?,ANCOHD=?,ANNRMU=?,ANNRAN=?,ANCOOR=?,ANTEESTM=?,ANCAPTPM=?,ANCOLA=?,ANTEDEAS=?,ANFEREEL=?,ANNRBOAN=?,ANFEBOAN=?,ANTEINBA=?,ANFECRAR=?,ANINEXAC=?,ANINEXAD=?,ANFECOAC=?,ANINREAC=?,ANINLACI=?,ANFECEAC=?,ANFEENAC=?,ANFEBOAC=?,ANINRSAC=?,ANFERBAC=?,ANFEERAC=?,ANFESOAD=?,ANFEBOAD=?,ANINREAD=?,ANFECORA=? WHERE ANCODIGO=?";
		Object getTipCaracMuestraTctcodigoAux = null;
		if (analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctcodigo() != null) {
			getTipCaracMuestraTctcodigoAux = analisis.getTipCaracMuestra()
					.getTctcodigo();
		}
		Object getTipDepoMuestraTdmcodigoAux = null;
		if (analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmcodigo() != null) {
			getTipDepoMuestraTdmcodigoAux = analisis.getTipDepoMuestra()
					.getTdmcodigo();
		}
		Object getActuacionAtcodigoAux = null;
		if (analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = analisis.getActuacion().getAtcodigo();
		}
		Object getOriProdAlertaTomcodigoAux = null;
		if (analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomcodigo() != null) {
			getOriProdAlertaTomcodigoAux = analisis.getOriProdAlerta()
					.getTomcodigo();
		}
		this.jdbcTemplate.update(query, getTipCaracMuestraTctcodigoAux,
				getTipDepoMuestraTdmcodigoAux, getActuacionAtcodigoAux,
				getOriProdAlertaTomcodigoAux, analisis.getAncohd(),
				analisis.getAnnrmu(), analisis.getAnnran(),
				analisis.getAncoor(), analisis.getAnteestm(),
				analisis.getAncaptpm(), analisis.getAncola(),
				analisis.getAntedeas(), analisis.getAnfereel(),
				analisis.getAnnrboan(), analisis.getAnfeboan(),
				analisis.getAnteinba(), analisis.getAnfecrar(),
				analisis.getAninexac(), analisis.getAninexad(),
				analisis.getAnfecoac(), analisis.getAninreac(),
				analisis.getAninlaci(), analisis.getAnfeceac(),
				analisis.getAnfeenac(), analisis.getAnfeboac(),
				analisis.getAninrsac(), analisis.getAnferbac(),
				analisis.getAnfeerac(), analisis.getAnfesoad(),
				analisis.getAnfeboad(), analisis.getAninread(),
				analisis.getAnfecora(), analisis.getAncodigo());
		return analisis;
	}

	/**
	 * Updates a single row in the Analisis table.
	 * 
	 * @param analisisDetalle
	 *            AnalisisDetalle
	 * @return AnalisisDetalle
	 */
	public AnalisisDetalle updateMuestra(AnalisisDetalle analisisDetalle) {

		String query = "UPDATE ANALISIS SET ANCOTCT=?,ANCOTDM=?,ANCOTOM=?,ANTEESTM=?,ANCAPTPM=? WHERE ANCODIGO=?";
		this.jdbcTemplate.update(query, analisisDetalle.getTctcodigo(),
				analisisDetalle.getTdmcodigo(), analisisDetalle.getTomcodigo(),
				analisisDetalle.getAnteestm(), analisisDetalle.getAncaptpm(),
				analisisDetalle.getAncodigo());
		return analisisDetalle;
	}

	/**
	 * Finds a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Pagination
	 * @return Analisis
	 */
	@Transactional(readOnly = true)
	public Analisis find(Analisis analisis) {
		String query = "SELECT t1.ANCODIGO ANCODIGO, t1.ANCOHD ANCOHD, t1.ANNRMU ANNRMU, t1.ANNRAN ANNRAN, t1.ANCOOR ANCOOR, t1.ANTEESTM ANTEESTM, t1.ANCAPTPM ANCAPTPM, t1.ANCOLA ANCOLA, t1.ANTEDEAS ANTEDEAS, t1.ANFEREEL ANFEREEL, t1.ANNRBOAN ANNRBOAN, t1.ANFEBOAN ANFEBOAN, t1.ANTEINBA ANTEINBA, t1.ANFECRAR ANFECRAR, t1.ANINEXAC ANINEXAC, t1.ANINEXAD ANINEXAD, t1.ANFECOAC ANFECOAC, t1.ANINREAC ANINREAC, t1.ANINLACI ANINLACI, t1.ANFECEAC ANFECEAC, t1.ANFEENAC ANFEENAC, t1.ANFEBOAC ANFEBOAC, t1.ANINRSAC ANINRSAC, t1.ANFERBAC ANFERBAC, t1.ANFEERAC ANFEERAC, t1.ANFESOAD ANFESOAD, t1.ANFEBOAD ANFEBOAD, t1.ANINREAD ANINREAD, t1.ANFECORA ANFECORA, t2.TCTCODIGO TIPCARACMUESTRATCTCODIGO, t2.TCTNOMBRE TIPCARACMUESTRATCTNOMBRE, t3.TDMCODIGO TIPDEPOMUESTRATDMCODIGO, t3.TDMNOMBRE TIPDEPOMUESTRATDMNOMBRE, t4.ATCODIGO ACTUACIONATCODIGO, t4.ATNROR ACTUACIONATNROR, t4.ATCOAV ACTUACIONATCOAV, t4.ATCOSE ACTUACIONATCOSE, t4.ATNOPRSE ACTUACIONATNOPRSE, t4.ATNOMAPS ACTUACIONATNOMAPS, t4.ATNOMOPS ACTUACIONATNOMOPS, t4.ATNRLOPS ACTUACIONATNRLOPS, t4.ATFEDUMI ACTUACIONATFEDUMI, t4.ATINPRSE ACTUACIONATINPRSE, t4.ATCAUNEP ACTUACIONATCAUNEP, t4.ATTEINFO ACTUACIONATTEINFO, t4.ATCOAT ACTUACIONATCOAT, t5.TOMCODIGO ORIPRODALERTATOMCODIGO, t5.TOMNOMBRE ORIPRODALERTATOMNOMBRE, t4.ATCOTP ACTUACIONATCOTP, t4.ATCOAC ACTUACIONATCOAC, t4.ATCOCM ACTUACIONATCOCM, t4.ATCOES ACTUACIONATCOES, t4.ATCOPS ACTUACIONATCOPS, t4.ATCOHD ACTUACIONATCOHD, t4.ATCOAL ACTUACIONATCOAL, t4.ATCOTTA ACTUACIONATCOTTA, t4.ATCOTMA ACTUACIONATCOTMA "
				+ "FROM ANALISIS t1 , TIP_CARAC_MUESTRA t2 , TIP_DEPO_MUESTRA t3 , ACTUACION t4 , ORI_PROD_ALERTA t5  "
				+ "WHERE t4.ATCODIGO = ?   AND t1.ANCOTCT= t2.TCTCODIGO(+) AND t1.ANCOTDM= t3.TDMCODIGO(+) AND t1.ANCOAT= t4.ATCODIGO(+) AND t1.ANCOTOM= t5.TOMCODIGO(+)  ";
		return (Analisis) this.jdbcTemplate.queryForObject(query, rwMap,
				analisis.getActuacion().getAtcodigo());
	}

	/**
	 * Removes a single row in the Analisis table.
	 * 
	 * @param analisis
	 *            Pagination
	 * @return
	 */
	public void remove(Analisis analisis) {
		String query = "DELETE  FROM ANALISIS WHERE ANCODIGO=?";
		this.jdbcTemplate.update(query, analisis.getAncodigo());
	}

	/**
	 * Finds a List of rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Analisis> findAll(Analisis analisis, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ANCOTCT= t2.TCTCODIGO(+) AND t1.ANCOTDM= t3.TDMCODIGO(+) AND t1.ANCOAT= t4.ATCODIGO(+) AND t1.ANCOTOM= t5.TOMCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ANCODIGO ANCODIGO,t1.ANCOHD ANCOHD,t1.ANNRMU ANNRMU,t1.ANNRAN ANNRAN,t1.ANCOOR ANCOOR,t1.ANTEESTM ANTEESTM,t1.ANCAPTPM ANCAPTPM,t1.ANCOLA ANCOLA,t1.ANTEDEAS ANTEDEAS,t1.ANFEREEL ANFEREEL,t1.ANNRBOAN ANNRBOAN,t1.ANFEBOAN ANFEBOAN,t1.ANTEINBA ANTEINBA,t1.ANFECRAR ANFECRAR,t1.ANINEXAC ANINEXAC,t1.ANINEXAD ANINEXAD,t1.ANFECOAC ANFECOAC,t1.ANINREAC ANINREAC,t1.ANINLACI ANINLACI,t1.ANFECEAC ANFECEAC,t1.ANFEENAC ANFEENAC,t1.ANFEBOAC ANFEBOAC,t1.ANINRSAC ANINRSAC,t1.ANFERBAC ANFERBAC,t1.ANFEERAC ANFEERAC,t1.ANFESOAD ANFESOAD,t1.ANFEBOAD ANFEBOAD,t1.ANINREAD ANINREAD,t1.ANFECORA ANFECORA,t2.TCTCODIGO TIPCARACMUESTRATCTCODIGO,t2.TCTNOMBRE TIPCARACMUESTRATCTNOMBRE,t3.TDMCODIGO TIPDEPOMUESTRATDMCODIGO,t3.TDMNOMBRE TIPDEPOMUESTRATDMNOMBRE,t4.ATCODIGO ACTUACIONATCODIGO,t4.ATNROR ACTUACIONATNROR,t4.ATCOAV ACTUACIONATCOAV,t4.ATCOSE ACTUACIONATCOSE,t4.ATNOPRSE ACTUACIONATNOPRSE,t4.ATNOMAPS ACTUACIONATNOMAPS,t4.ATNOMOPS ACTUACIONATNOMOPS,t4.ATNRLOPS ACTUACIONATNRLOPS,t4.ATFEDUMI ACTUACIONATFEDUMI,t4.ATINPRSE ACTUACIONATINPRSE,t4.ATCAUNEP ACTUACIONATCAUNEP,t4.ATTEINFO ACTUACIONATTEINFO,t4.ATCOAT ACTUACIONATCOAT,t5.TOMCODIGO ORIPRODALERTATOMCODIGO,t5.TOMNOMBRE ORIPRODALERTATOMNOMBRE,t4.ATCOTP ACTUACIONATCOTP,t4.ATCOAC ACTUACIONATCOAC,t4.ATCOCM ACTUACIONATCOCM,t4.ATCOES ACTUACIONATCOES,t4.ATCOPS ACTUACIONATCOPS,t4.ATCOHD ACTUACIONATCOHD,t4.ATCOAL ACTUACIONATCOAL,t4.ATCOTTA ACTUACIONATCOTTA,t4.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM ANALISIS t1 ,TIP_CARAC_MUESTRA t2 ,TIP_DEPO_MUESTRA t3 ,ACTUACION t4 ,ORI_PROD_ALERTA t5 ");

		if (analisis != null && analisis.getAncodigo() != null) {
			where.append(" AND t1.ANCODIGO = ?");
			params.add(analisis.getAncodigo());
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctcodigo() != null) {
			where.append(" AND t2.TCTCODIGO = ?");
			params.add(analisis.getTipCaracMuestra().getTctcodigo());
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctnombre() != null) {
			where.append(" AND t2.TCTNOMBRE = ?");
			params.add(analisis.getTipCaracMuestra().getTctnombre());
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmcodigo() != null) {
			where.append(" AND t3.TDMCODIGO = ?");
			params.add(analisis.getTipDepoMuestra().getTdmcodigo());
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmnombre() != null) {
			where.append(" AND t3.TDMNOMBRE = ?");
			params.add(analisis.getTipDepoMuestra().getTdmnombre());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO = ?");
			params.add(analisis.getActuacion().getAtcodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipProtocolo() != null
				&& analisis.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t4.ATCOTP = ?");
			params.add(analisis.getActuacion().getTipProtocolo().getTpcodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getActa() != null
				&& analisis.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t4.ATCOAC = ?");
			params.add(analisis.getActuacion().getActa().getAccodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getCampahnaRecib() != null
				&& analisis.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t4.ATCOCM = ?");
			params.add(analisis.getActuacion().getCampahnaRecib().getS4codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getEstablecimiento() != null
				&& analisis.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t4.ATCOES = ?");
			params.add(analisis.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getProducto() != null
				&& analisis.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t4.ATCOPS = ?");
			params.add(analisis.getActuacion().getProducto().getPscodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getDenunciaRecib() != null
				&& analisis.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t4.ATCOHD = ?");
			params.add(analisis.getActuacion().getDenunciaRecib().getS6codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getAlertaRecib() != null
				&& analisis.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t4.ATCOAL = ?");
			params.add(analisis.getActuacion().getAlertaRecib().getS5codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipActuacion() != null
				&& analisis.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t4.ATCOTTA = ?");
			params.add(analisis.getActuacion().getTipActuacion().getTtacodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t4.ATCOTMA = ?");
			params.add(analisis.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnror() != null) {
			where.append(" AND t4.ATNROR = ?");
			params.add(analisis.getActuacion().getAtnror());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoav() != null) {
			where.append(" AND t4.ATCOAV = ?");
			params.add(analisis.getActuacion().getAtcoav());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcose() != null) {
			where.append(" AND t4.ATCOSE = ?");
			params.add(analisis.getActuacion().getAtcose());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnoprse() != null) {
			where.append(" AND t4.ATNOPRSE = ?");
			params.add(analisis.getActuacion().getAtnoprse());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomaps() != null) {
			where.append(" AND t4.ATNOMAPS = ?");
			params.add(analisis.getActuacion().getAtnomaps());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomops() != null) {
			where.append(" AND t4.ATNOMOPS = ?");
			params.add(analisis.getActuacion().getAtnomops());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnrlops() != null) {
			where.append(" AND t4.ATNRLOPS = ?");
			params.add(analisis.getActuacion().getAtnrlops());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtfedumi() != null) {
			where.append(" AND t4.ATFEDUMI = ?");
			params.add(analisis.getActuacion().getAtfedumi());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtinprse() != null) {
			where.append(" AND t4.ATINPRSE = ?");
			params.add(analisis.getActuacion().getAtinprse());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcaunep() != null) {
			where.append(" AND t4.ATCAUNEP = ?");
			params.add(analisis.getActuacion().getAtcaunep());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtteinfo() != null) {
			where.append(" AND t4.ATTEINFO = ?");
			params.add(analisis.getActuacion().getAtteinfo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoat() != null) {
			where.append(" AND t4.ATCOAT = ?");
			params.add(analisis.getActuacion().getAtcoat());
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomcodigo() != null) {
			where.append(" AND t5.TOMCODIGO = ?");
			params.add(analisis.getOriProdAlerta().getTomcodigo());
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomnombre() != null) {
			where.append(" AND t5.TOMNOMBRE = ?");
			params.add(analisis.getOriProdAlerta().getTomnombre());
		}
		if (analisis != null && analisis.getAncohd() != null) {
			where.append(" AND t1.ANCOHD = ?");
			params.add(analisis.getAncohd());
		}
		if (analisis != null && analisis.getAnnrmu() != null) {
			where.append(" AND t1.ANNRMU = ?");
			params.add(analisis.getAnnrmu());
		}
		if (analisis != null && analisis.getAnnran() != null) {
			where.append(" AND t1.ANNRAN = ?");
			params.add(analisis.getAnnran());
		}
		if (analisis != null && analisis.getAncoor() != null) {
			where.append(" AND t1.ANCOOR = ?");
			params.add(analisis.getAncoor());
		}
		if (analisis != null && analisis.getAnteestm() != null) {
			where.append(" AND t1.ANTEESTM = ?");
			params.add(analisis.getAnteestm());
		}
		if (analisis != null && analisis.getAncaptpm() != null) {
			where.append(" AND t1.ANCAPTPM = ?");
			params.add(analisis.getAncaptpm());
		}
		if (analisis != null && analisis.getAncola() != null) {
			where.append(" AND t1.ANCOLA = ?");
			params.add(analisis.getAncola());
		}
		if (analisis != null && analisis.getAntedeas() != null) {
			where.append(" AND t1.ANTEDEAS = ?");
			params.add(analisis.getAntedeas());
		}
		if (analisis != null && analisis.getAnfereel() != null) {
			where.append(" AND t1.ANFEREEL = ?");
			params.add(analisis.getAnfereel());
		}
		if (analisis != null && analisis.getAnnrboan() != null) {
			where.append(" AND t1.ANNRBOAN = ?");
			params.add(analisis.getAnnrboan());
		}
		if (analisis != null && analisis.getAnfeboan() != null) {
			where.append(" AND t1.ANFEBOAN = ?");
			params.add(analisis.getAnfeboan());
		}
		if (analisis != null && analisis.getAnteinba() != null) {
			where.append(" AND t1.ANTEINBA = ?");
			params.add(analisis.getAnteinba());
		}
		if (analisis != null && analisis.getAnfecrar() != null) {
			where.append(" AND t1.ANFECRAR = ?");
			params.add(analisis.getAnfecrar());
		}
		if (analisis != null && analisis.getAninexac() != null) {
			where.append(" AND t1.ANINEXAC = ?");
			params.add(analisis.getAninexac());
		}
		if (analisis != null && analisis.getAninexad() != null) {
			where.append(" AND t1.ANINEXAD = ?");
			params.add(analisis.getAninexad());
		}
		if (analisis != null && analisis.getAnfecoac() != null) {
			where.append(" AND t1.ANFECOAC = ?");
			params.add(analisis.getAnfecoac());
		}
		if (analisis != null && analisis.getAninreac() != null) {
			where.append(" AND t1.ANINREAC = ?");
			params.add(analisis.getAninreac());
		}
		if (analisis != null && analisis.getAninlaci() != null) {
			where.append(" AND t1.ANINLACI = ?");
			params.add(analisis.getAninlaci());
		}
		if (analisis != null && analisis.getAnfeceac() != null) {
			where.append(" AND t1.ANFECEAC = ?");
			params.add(analisis.getAnfeceac());
		}
		if (analisis != null && analisis.getAnfeenac() != null) {
			where.append(" AND t1.ANFEENAC = ?");
			params.add(analisis.getAnfeenac());
		}
		if (analisis != null && analisis.getAnfeboac() != null) {
			where.append(" AND t1.ANFEBOAC = ?");
			params.add(analisis.getAnfeboac());
		}
		if (analisis != null && analisis.getAninrsac() != null) {
			where.append(" AND t1.ANINRSAC = ?");
			params.add(analisis.getAninrsac());
		}
		if (analisis != null && analisis.getAnferbac() != null) {
			where.append(" AND t1.ANFERBAC = ?");
			params.add(analisis.getAnferbac());
		}
		if (analisis != null && analisis.getAnfeerac() != null) {
			where.append(" AND t1.ANFEERAC = ?");
			params.add(analisis.getAnfeerac());
		}
		if (analisis != null && analisis.getAnfesoad() != null) {
			where.append(" AND t1.ANFESOAD = ?");
			params.add(analisis.getAnfesoad());
		}
		if (analisis != null && analisis.getAnfeboad() != null) {
			where.append(" AND t1.ANFEBOAD = ?");
			params.add(analisis.getAnfeboad());
		}
		if (analisis != null && analisis.getAninread() != null) {
			where.append(" AND t1.ANINREAD = ?");
			params.add(analisis.getAninread());
		}
		if (analisis != null && analisis.getAnfecora() != null) {
			where.append(" AND t1.ANFECORA = ?");
			params.add(analisis.getAnfecora());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Analisis>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Analisis table.
	 * 
	 * @param analisis
	 *            Analisis
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Analisis analisis) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ANCOTCT= t2.TCTCODIGO(+) and t1.ANCOTDM= t3.TDMCODIGO(+) and t1.ANCOAT= t4.ATCODIGO(+) and t1.ANCOTOM= t5.TOMCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ANALISIS t1   ,  TIP_CARAC_MUESTRA t2   ,  TIP_DEPO_MUESTRA t3   ,  ACTUACION t4   ,  ORI_PROD_ALERTA t5  ");
		if (analisis != null && analisis.getAncodigo() != null) {
			where.append(" AND t1.ANCODIGO = ?");
			params.add(analisis.getAncodigo());
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctcodigo() != null) {
			where.append(" AND t2.TCTCODIGO = ?");
			params.add(analisis.getTipCaracMuestra().getTctcodigo());
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctnombre() != null) {
			where.append(" AND t2.TCTNOMBRE = ?");
			params.add(analisis.getTipCaracMuestra().getTctnombre());
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmcodigo() != null) {
			where.append(" AND t3.TDMCODIGO = ?");
			params.add(analisis.getTipDepoMuestra().getTdmcodigo());
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmnombre() != null) {
			where.append(" AND t3.TDMNOMBRE = ?");
			params.add(analisis.getTipDepoMuestra().getTdmnombre());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO = ?");
			params.add(analisis.getActuacion().getAtcodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipProtocolo() != null
				&& analisis.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t4.ATCOTP = ?");
			params.add(analisis.getActuacion().getTipProtocolo().getTpcodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getActa() != null
				&& analisis.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t4.ATCOAC = ?");
			params.add(analisis.getActuacion().getActa().getAccodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getCampahnaRecib() != null
				&& analisis.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t4.ATCOCM = ?");
			params.add(analisis.getActuacion().getCampahnaRecib().getS4codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getEstablecimiento() != null
				&& analisis.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t4.ATCOES = ?");
			params.add(analisis.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getProducto() != null
				&& analisis.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t4.ATCOPS = ?");
			params.add(analisis.getActuacion().getProducto().getPscodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getDenunciaRecib() != null
				&& analisis.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t4.ATCOHD = ?");
			params.add(analisis.getActuacion().getDenunciaRecib().getS6codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getAlertaRecib() != null
				&& analisis.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t4.ATCOAL = ?");
			params.add(analisis.getActuacion().getAlertaRecib().getS5codigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipActuacion() != null
				&& analisis.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t4.ATCOTTA = ?");
			params.add(analisis.getActuacion().getTipActuacion().getTtacodigo());
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t4.ATCOTMA = ?");
			params.add(analisis.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnror() != null) {
			where.append(" AND t4.ATNROR = ?");
			params.add(analisis.getActuacion().getAtnror());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoav() != null) {
			where.append(" AND t4.ATCOAV = ?");
			params.add(analisis.getActuacion().getAtcoav());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcose() != null) {
			where.append(" AND t4.ATCOSE = ?");
			params.add(analisis.getActuacion().getAtcose());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnoprse() != null) {
			where.append(" AND t4.ATNOPRSE = ?");
			params.add(analisis.getActuacion().getAtnoprse());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomaps() != null) {
			where.append(" AND t4.ATNOMAPS = ?");
			params.add(analisis.getActuacion().getAtnomaps());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomops() != null) {
			where.append(" AND t4.ATNOMOPS = ?");
			params.add(analisis.getActuacion().getAtnomops());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnrlops() != null) {
			where.append(" AND t4.ATNRLOPS = ?");
			params.add(analisis.getActuacion().getAtnrlops());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtfedumi() != null) {
			where.append(" AND t4.ATFEDUMI = ?");
			params.add(analisis.getActuacion().getAtfedumi());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtinprse() != null) {
			where.append(" AND t4.ATINPRSE = ?");
			params.add(analisis.getActuacion().getAtinprse());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcaunep() != null) {
			where.append(" AND t4.ATCAUNEP = ?");
			params.add(analisis.getActuacion().getAtcaunep());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtteinfo() != null) {
			where.append(" AND t4.ATTEINFO = ?");
			params.add(analisis.getActuacion().getAtteinfo());
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoat() != null) {
			where.append(" AND t4.ATCOAT = ?");
			params.add(analisis.getActuacion().getAtcoat());
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomcodigo() != null) {
			where.append(" AND t5.TOMCODIGO = ?");
			params.add(analisis.getOriProdAlerta().getTomcodigo());
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomnombre() != null) {
			where.append(" AND t5.TOMNOMBRE = ?");
			params.add(analisis.getOriProdAlerta().getTomnombre());
		}
		if (analisis != null && analisis.getAncohd() != null) {
			where.append(" AND t1.ANCOHD = ?");
			params.add(analisis.getAncohd());
		}
		if (analisis != null && analisis.getAnnrmu() != null) {
			where.append(" AND t1.ANNRMU = ?");
			params.add(analisis.getAnnrmu());
		}
		if (analisis != null && analisis.getAnnran() != null) {
			where.append(" AND t1.ANNRAN = ?");
			params.add(analisis.getAnnran());
		}
		if (analisis != null && analisis.getAncoor() != null) {
			where.append(" AND t1.ANCOOR = ?");
			params.add(analisis.getAncoor());
		}
		if (analisis != null && analisis.getAnteestm() != null) {
			where.append(" AND t1.ANTEESTM = ?");
			params.add(analisis.getAnteestm());
		}
		if (analisis != null && analisis.getAncaptpm() != null) {
			where.append(" AND t1.ANCAPTPM = ?");
			params.add(analisis.getAncaptpm());
		}
		if (analisis != null && analisis.getAncola() != null) {
			where.append(" AND t1.ANCOLA = ?");
			params.add(analisis.getAncola());
		}
		if (analisis != null && analisis.getAntedeas() != null) {
			where.append(" AND t1.ANTEDEAS = ?");
			params.add(analisis.getAntedeas());
		}
		if (analisis != null && analisis.getAnfereel() != null) {
			where.append(" AND t1.ANFEREEL = ?");
			params.add(analisis.getAnfereel());
		}
		if (analisis != null && analisis.getAnnrboan() != null) {
			where.append(" AND t1.ANNRBOAN = ?");
			params.add(analisis.getAnnrboan());
		}
		if (analisis != null && analisis.getAnfeboan() != null) {
			where.append(" AND t1.ANFEBOAN = ?");
			params.add(analisis.getAnfeboan());
		}
		if (analisis != null && analisis.getAnteinba() != null) {
			where.append(" AND t1.ANTEINBA = ?");
			params.add(analisis.getAnteinba());
		}
		if (analisis != null && analisis.getAnfecrar() != null) {
			where.append(" AND t1.ANFECRAR = ?");
			params.add(analisis.getAnfecrar());
		}
		if (analisis != null && analisis.getAninexac() != null) {
			where.append(" AND t1.ANINEXAC = ?");
			params.add(analisis.getAninexac());
		}
		if (analisis != null && analisis.getAninexad() != null) {
			where.append(" AND t1.ANINEXAD = ?");
			params.add(analisis.getAninexad());
		}
		if (analisis != null && analisis.getAnfecoac() != null) {
			where.append(" AND t1.ANFECOAC = ?");
			params.add(analisis.getAnfecoac());
		}
		if (analisis != null && analisis.getAninreac() != null) {
			where.append(" AND t1.ANINREAC = ?");
			params.add(analisis.getAninreac());
		}
		if (analisis != null && analisis.getAninlaci() != null) {
			where.append(" AND t1.ANINLACI = ?");
			params.add(analisis.getAninlaci());
		}
		if (analisis != null && analisis.getAnfeceac() != null) {
			where.append(" AND t1.ANFECEAC = ?");
			params.add(analisis.getAnfeceac());
		}
		if (analisis != null && analisis.getAnfeenac() != null) {
			where.append(" AND t1.ANFEENAC = ?");
			params.add(analisis.getAnfeenac());
		}
		if (analisis != null && analisis.getAnfeboac() != null) {
			where.append(" AND t1.ANFEBOAC = ?");
			params.add(analisis.getAnfeboac());
		}
		if (analisis != null && analisis.getAninrsac() != null) {
			where.append(" AND t1.ANINRSAC = ?");
			params.add(analisis.getAninrsac());
		}
		if (analisis != null && analisis.getAnferbac() != null) {
			where.append(" AND t1.ANFERBAC = ?");
			params.add(analisis.getAnferbac());
		}
		if (analisis != null && analisis.getAnfeerac() != null) {
			where.append(" AND t1.ANFEERAC = ?");
			params.add(analisis.getAnfeerac());
		}
		if (analisis != null && analisis.getAnfesoad() != null) {
			where.append(" AND t1.ANFESOAD = ?");
			params.add(analisis.getAnfesoad());
		}
		if (analisis != null && analisis.getAnfeboad() != null) {
			where.append(" AND t1.ANFEBOAD = ?");
			params.add(analisis.getAnfeboad());
		}
		if (analisis != null && analisis.getAninread() != null) {
			where.append(" AND t1.ANINREAD = ?");
			params.add(analisis.getAninread());
		}
		if (analisis != null && analisis.getAnfecora() != null) {
			where.append(" AND t1.ANFECORA = ?");
			params.add(analisis.getAnfecora());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Analisis table using like.
	 * 
	 * @param analisis
	 *            Analisis
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Analisis> findAllLike(Analisis analisis, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ANCOTCT= t2.TCTCODIGO(+) AND t1.ANCOTDM= t3.TDMCODIGO(+) AND t1.ANCOAT= t4.ATCODIGO(+) AND t1.ANCOTOM= t5.TOMCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ANCODIGO ANCODIGO,t1.ANCOHD ANCOHD,t1.ANNRMU ANNRMU,t1.ANNRAN ANNRAN,t1.ANCOOR ANCOOR,t1.ANTEESTM ANTEESTM,t1.ANCAPTPM ANCAPTPM,t1.ANCOLA ANCOLA,t1.ANTEDEAS ANTEDEAS,t1.ANFEREEL ANFEREEL,t1.ANNRBOAN ANNRBOAN,t1.ANFEBOAN ANFEBOAN,t1.ANTEINBA ANTEINBA,t1.ANFECRAR ANFECRAR,t1.ANINEXAC ANINEXAC,t1.ANINEXAD ANINEXAD,t1.ANFECOAC ANFECOAC,t1.ANINREAC ANINREAC,t1.ANINLACI ANINLACI,t1.ANFECEAC ANFECEAC,t1.ANFEENAC ANFEENAC,t1.ANFEBOAC ANFEBOAC,t1.ANINRSAC ANINRSAC,t1.ANFERBAC ANFERBAC,t1.ANFEERAC ANFEERAC,t1.ANFESOAD ANFESOAD,t1.ANFEBOAD ANFEBOAD,t1.ANINREAD ANINREAD,t1.ANFECORA ANFECORA,t2.TCTCODIGO TIPCARACMUESTRATCTCODIGO,t2.TCTNOMBRE TIPCARACMUESTRATCTNOMBRE,t3.TDMCODIGO TIPDEPOMUESTRATDMCODIGO,t3.TDMNOMBRE TIPDEPOMUESTRATDMNOMBRE,t4.ATCODIGO ACTUACIONATCODIGO,t4.ATNROR ACTUACIONATNROR,t4.ATCOAV ACTUACIONATCOAV,t4.ATCOSE ACTUACIONATCOSE,t4.ATNOPRSE ACTUACIONATNOPRSE,t4.ATNOMAPS ACTUACIONATNOMAPS,t4.ATNOMOPS ACTUACIONATNOMOPS,t4.ATNRLOPS ACTUACIONATNRLOPS,t4.ATFEDUMI ACTUACIONATFEDUMI,t4.ATINPRSE ACTUACIONATINPRSE,t4.ATCAUNEP ACTUACIONATCAUNEP,t4.ATTEINFO ACTUACIONATTEINFO,t4.ATCOAT ACTUACIONATCOAT,t5.TOMCODIGO ORIPRODALERTATOMCODIGO,t5.TOMNOMBRE ORIPRODALERTATOMNOMBRE,t4.ATCOTP ACTUACIONATCOTP,t4.ATCOAC ACTUACIONATCOAC,t4.ATCOCM ACTUACIONATCOCM,t4.ATCOES ACTUACIONATCOES,t4.ATCOPS ACTUACIONATCOPS,t4.ATCOHD ACTUACIONATCOHD,t4.ATCOAL ACTUACIONATCOAL,t4.ATCOTTA ACTUACIONATCOTTA,t4.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM ANALISIS t1 ,TIP_CARAC_MUESTRA t2 ,TIP_DEPO_MUESTRA t3 ,ACTUACION t4 ,ORI_PROD_ALERTA t5 ");

		if (analisis != null && analisis.getAncodigo() != null) {
			where.append(" AND UPPER(t1.ANCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAncodigo().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAncodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCODIGO IS NOT NULL");
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctcodigo() != null) {
			where.append(" AND t2.TCTCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getTipCaracMuestra().getTctcodigo() + "%");
			} else {
				params.add("%" + analisis.getTipCaracMuestra().getTctcodigo()
						+ "%");
			}
			where.append(" AND t2.TCTCODIGO IS NOT NULL");
		}
		if (analisis != null && analisis.getTipCaracMuestra() != null
				&& analisis.getTipCaracMuestra().getTctnombre() != null) {
			where.append(" AND UPPER(t2.TCTNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getTipCaracMuestra().getTctnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getTipCaracMuestra().getTctnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TCTNOMBRE IS NOT NULL");
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmcodigo() != null) {
			where.append(" AND t3.TDMCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getTipDepoMuestra().getTdmcodigo() + "%");
			} else {
				params.add("%" + analisis.getTipDepoMuestra().getTdmcodigo()
						+ "%");
			}
			where.append(" AND t3.TDMCODIGO IS NOT NULL");
		}
		if (analisis != null && analisis.getTipDepoMuestra() != null
				&& analisis.getTipDepoMuestra().getTdmnombre() != null) {
			where.append(" AND UPPER(t3.TDMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getTipDepoMuestra().getTdmnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getTipDepoMuestra().getTdmnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TDMNOMBRE IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcodigo() != null) {
			where.append(" AND t4.ATCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtcodigo() + "%");
			} else {
				params.add("%" + analisis.getActuacion().getAtcodigo() + "%");
			}
			where.append(" AND t4.ATCODIGO IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipProtocolo() != null
				&& analisis.getActuacion().getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND UPPER(t4.ATCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getTipProtocolo()
						.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getTipProtocolo()
								.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOTP IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getActa() != null
				&& analisis.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND UPPER(t4.ATCOAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getActa().getAccodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getActa().getAccodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOAC IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getCampahnaRecib() != null
				&& analisis.getActuacion().getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND UPPER(t4.ATCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getCampahnaRecib()
						.getS4codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getCampahnaRecib()
								.getS4codigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOCM IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getEstablecimiento() != null
				&& analisis.getActuacion().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t4.ATCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOES IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getProducto() != null
				&& analisis.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t4.ATCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getProducto().getPscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getProducto().getPscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOPS IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getDenunciaRecib() != null
				&& analisis.getActuacion().getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND UPPER(t4.ATCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getDenunciaRecib()
						.getS6codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getDenunciaRecib()
								.getS6codigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOHD IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getAlertaRecib() != null
				&& analisis.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND UPPER(t4.ATCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAlertaRecib()
						.getS5codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAlertaRecib()
								.getS5codigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOAL IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipActuacion() != null
				&& analisis.getActuacion().getTipActuacion().getTtacodigo() != null) {
			where.append(" AND UPPER(t4.ATCOTTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getTipActuacion()
						.getTtacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getTipActuacion()
								.getTtacodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOTTA IS NOT NULL");
		}
		if (analisis != null
				&& analisis.getActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion() != null
				&& analisis.getActuacion().getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND UPPER(t4.ATCOTMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getTipmotActuacion()
						.getTmacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getTipmotActuacion()
								.getTmacodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.ATCOTMA IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnror() != null) {
			where.append(" AND t4.ATNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtnror() + "%");
			} else {
				params.add("%" + analisis.getActuacion().getAtnror() + "%");
			}
			where.append(" AND t4.ATNROR IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoav() != null) {
			where.append(" AND UPPER(t4.ATCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtcoav().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtcoav().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATCOAV IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcose() != null) {
			where.append(" AND UPPER(t4.ATCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtcose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtcose().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATCOSE IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnoprse() != null) {
			where.append(" AND UPPER(t4.ATNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtnoprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATNOPRSE IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomaps() != null) {
			where.append(" AND UPPER(t4.ATNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATNOMAPS IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnomops() != null) {
			where.append(" AND UPPER(t4.ATNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATNOMOPS IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtnrlops() != null) {
			where.append(" AND UPPER(t4.ATNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATNRLOPS IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtfedumi() != null) {
			where.append(" AND t4.ATFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtfedumi() + "%");
			} else {
				params.add("%" + analisis.getActuacion().getAtfedumi() + "%");
			}
			where.append(" AND t4.ATFEDUMI IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtinprse() != null) {
			where.append(" AND UPPER(t4.ATINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtinprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtinprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATINPRSE IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcaunep() != null) {
			where.append(" AND t4.ATCAUNEP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtcaunep() + "%");
			} else {
				params.add("%" + analisis.getActuacion().getAtcaunep() + "%");
			}
			where.append(" AND t4.ATCAUNEP IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtteinfo() != null) {
			where.append(" AND UPPER(t4.ATTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtteinfo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtteinfo().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATTEINFO IS NOT NULL");
		}
		if (analisis != null && analisis.getActuacion() != null
				&& analisis.getActuacion().getAtcoat() != null) {
			where.append(" AND UPPER(t4.ATCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getActuacion().getAtcoat().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getActuacion().getAtcoat().toUpperCase()
						+ "%");
			}
			where.append(" AND t4.ATCOAT IS NOT NULL");
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomcodigo() != null) {
			where.append(" AND t5.TOMCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getOriProdAlerta().getTomcodigo() + "%");
			} else {
				params.add("%" + analisis.getOriProdAlerta().getTomcodigo()
						+ "%");
			}
			where.append(" AND t5.TOMCODIGO IS NOT NULL");
		}
		if (analisis != null && analisis.getOriProdAlerta() != null
				&& analisis.getOriProdAlerta().getTomnombre() != null) {
			where.append(" AND UPPER(t5.TOMNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getOriProdAlerta().getTomnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ analisis.getOriProdAlerta().getTomnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.TOMNOMBRE IS NOT NULL");
		}
		if (analisis != null && analisis.getAncohd() != null) {
			where.append(" AND UPPER(t1.ANCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAncohd().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAncohd().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCOHD IS NOT NULL");
		}
		if (analisis != null && analisis.getAnnrmu() != null) {
			where.append(" AND t1.ANNRMU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnnrmu() + "%");
			} else {
				params.add("%" + analisis.getAnnrmu() + "%");
			}
			where.append(" AND t1.ANNRMU IS NOT NULL");
		}
		if (analisis != null && analisis.getAnnran() != null) {
			where.append(" AND t1.ANNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnnran() + "%");
			} else {
				params.add("%" + analisis.getAnnran() + "%");
			}
			where.append(" AND t1.ANNRAN IS NOT NULL");
		}
		if (analisis != null && analisis.getAncoor() != null) {
			where.append(" AND UPPER(t1.ANCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAncoor().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAncoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCOOR IS NOT NULL");
		}
		if (analisis != null && analisis.getAnteestm() != null) {
			where.append(" AND UPPER(t1.ANTEESTM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnteestm().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAnteestm().toUpperCase() + "%");
			}
			where.append(" AND t1.ANTEESTM IS NOT NULL");
		}
		if (analisis != null && analisis.getAncaptpm() != null) {
			where.append(" AND t1.ANCAPTPM like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAncaptpm() + "%");
			} else {
				params.add("%" + analisis.getAncaptpm() + "%");
			}
			where.append(" AND t1.ANCAPTPM IS NOT NULL");
		}
		if (analisis != null && analisis.getAncola() != null) {
			where.append(" AND UPPER(t1.ANCOLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAncola().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAncola().toUpperCase() + "%");
			}
			where.append(" AND t1.ANCOLA IS NOT NULL");
		}
		if (analisis != null && analisis.getAntedeas() != null) {
			where.append(" AND UPPER(t1.ANTEDEAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAntedeas().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAntedeas().toUpperCase() + "%");
			}
			where.append(" AND t1.ANTEDEAS IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfereel() != null) {
			where.append(" AND t1.ANFEREEL like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfereel() + "%");
			} else {
				params.add("%" + analisis.getAnfereel() + "%");
			}
			where.append(" AND t1.ANFEREEL IS NOT NULL");
		}
		if (analisis != null && analisis.getAnnrboan() != null) {
			where.append(" AND UPPER(t1.ANNRBOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnnrboan().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAnnrboan().toUpperCase() + "%");
			}
			where.append(" AND t1.ANNRBOAN IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeboan() != null) {
			where.append(" AND t1.ANFEBOAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeboan() + "%");
			} else {
				params.add("%" + analisis.getAnfeboan() + "%");
			}
			where.append(" AND t1.ANFEBOAN IS NOT NULL");
		}
		if (analisis != null && analisis.getAnteinba() != null) {
			where.append(" AND UPPER(t1.ANTEINBA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnteinba().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAnteinba().toUpperCase() + "%");
			}
			where.append(" AND t1.ANTEINBA IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfecrar() != null) {
			where.append(" AND t1.ANFECRAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfecrar() + "%");
			} else {
				params.add("%" + analisis.getAnfecrar() + "%");
			}
			where.append(" AND t1.ANFECRAR IS NOT NULL");
		}
		if (analisis != null && analisis.getAninexac() != null) {
			where.append(" AND UPPER(t1.ANINEXAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninexac().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninexac().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINEXAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAninexad() != null) {
			where.append(" AND UPPER(t1.ANINEXAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninexad().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninexad().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINEXAD IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfecoac() != null) {
			where.append(" AND t1.ANFECOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfecoac() + "%");
			} else {
				params.add("%" + analisis.getAnfecoac() + "%");
			}
			where.append(" AND t1.ANFECOAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAninreac() != null) {
			where.append(" AND UPPER(t1.ANINREAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninreac().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninreac().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINREAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAninlaci() != null) {
			where.append(" AND UPPER(t1.ANINLACI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninlaci().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninlaci().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINLACI IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeceac() != null) {
			where.append(" AND t1.ANFECEAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeceac() + "%");
			} else {
				params.add("%" + analisis.getAnfeceac() + "%");
			}
			where.append(" AND t1.ANFECEAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeenac() != null) {
			where.append(" AND t1.ANFEENAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeenac() + "%");
			} else {
				params.add("%" + analisis.getAnfeenac() + "%");
			}
			where.append(" AND t1.ANFEENAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeboac() != null) {
			where.append(" AND t1.ANFEBOAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeboac() + "%");
			} else {
				params.add("%" + analisis.getAnfeboac() + "%");
			}
			where.append(" AND t1.ANFEBOAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAninrsac() != null) {
			where.append(" AND UPPER(t1.ANINRSAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninrsac().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninrsac().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINRSAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAnferbac() != null) {
			where.append(" AND t1.ANFERBAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnferbac() + "%");
			} else {
				params.add("%" + analisis.getAnferbac() + "%");
			}
			where.append(" AND t1.ANFERBAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeerac() != null) {
			where.append(" AND t1.ANFEERAC like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeerac() + "%");
			} else {
				params.add("%" + analisis.getAnfeerac() + "%");
			}
			where.append(" AND t1.ANFEERAC IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfesoad() != null) {
			where.append(" AND t1.ANFESOAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfesoad() + "%");
			} else {
				params.add("%" + analisis.getAnfesoad() + "%");
			}
			where.append(" AND t1.ANFESOAD IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfeboad() != null) {
			where.append(" AND t1.ANFEBOAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfeboad() + "%");
			} else {
				params.add("%" + analisis.getAnfeboad() + "%");
			}
			where.append(" AND t1.ANFEBOAD IS NOT NULL");
		}
		if (analisis != null && analisis.getAninread() != null) {
			where.append(" AND UPPER(t1.ANINREAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAninread().toUpperCase() + "%");
			} else {
				params.add("%" + analisis.getAninread().toUpperCase() + "%");
			}
			where.append(" AND t1.ANINREAD IS NOT NULL");
		}
		if (analisis != null && analisis.getAnfecora() != null) {
			where.append(" AND t1.ANFECORA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(analisis.getAnfecora() + "%");
			} else {
				params.add("%" + analisis.getAnfecora() + "%");
			}
			where.append(" AND t1.ANFECORA IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Analisis>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
