package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.CampahnaRecibBusqueda;
import com.ejie.y41a.model.CaracterAlerta;
import com.ejie.y41a.model.Comaut;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipAlerta;
import com.ejie.y41a.model.TipOrigenProd;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.AlertaRecib;

/**
 * * AlertaRecibDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class AlertaRecibDaoImpl implements AlertaRecibDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<AlertaRecib> rwMap = new RowMapper<AlertaRecib>() {
		public AlertaRecib mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new AlertaRecib(resultSet.getString("S5CODIGO"),
					resultSet.getString("S5CODORGANISMO"),
					resultSet.getDate("S5FECCOMUNICACION"),
					resultSet.getDate("S5FECFINALIZACION"),
					resultSet.getInt("S5CANTIDADACTUACIONES"), new Alerta(
							resultSet.getString("AlertaALCODIGO"),
							resultSet.getString("AlertaALCOOR"),
							resultSet.getLong("AlertaALNRAN"),
							resultSet.getString("AlertaALNROR"),
							resultSet.getDate("AlertaALFEEN"),
							resultSet.getDate("AlertaALFEPLRR"),
							resultSet.getString("AlertaALNOPRSE"),
							resultSet.getString("AlertaALNRLOPS"),
							resultSet.getString("AlertaALNOMAPS"),
							resultSet.getString("AlertaALNOMOPS"),
							resultSet.getDate("AlertaALFEDUMI"),
							resultSet.getString("AlertaALTEIN"),
							resultSet.getDate("AlertaALFERRIN"),
							resultSet.getString("AlertaALINRE"),
							resultSet.getDate("AlertaALFECOOR"),
							resultSet.getString("AlertaALCOTMO"), new Comaut(
									resultSet.getString("AlertaALCOCA"), null,
									null, null), new Producto(
									resultSet.getString("AlertaALCOPS"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null),
							new TipOrigenProd(resultSet
									.getString("AlertaALCOTOP"), null, null),
							new Pais(resultSet.getString("AlertaALCOPA"), null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("AlertaALCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null)), new CaracterAlerta(
							resultSet.getString("CaracterAlertaCRCODIGO"),
							resultSet.getString("CaracterAlertaCRCOOR"),
							resultSet.getDate("CaracterAlertaCRFERERE"),
							resultSet.getString("CaracterAlertaCRTEINFO"),
							resultSet.getInt("CaracterAlertaCRCNACTU"),
							resultSet.getString("CaracterAlertaCRINPRSE"),
							new Alerta(resultSet
									.getString("CaracterAlertaCRCOAL"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null),
							new TipAlerta(resultSet
									.getString("CaracterAlertaCRTIPO"), null,
									null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            Pagination
	 * @return AlertaRecib
	 */
	public AlertaRecib add(AlertaRecib alertarecib) {

		String query = "INSERT INTO ALERTA_RECIB( S5CODIGO,S5CODALERTA,S5CARACTERALERTA,S5CODORGANISMO,S5FECCOMUNICACION,S5FECFINALIZACION,S5CANTIDADACTUACIONES)"
				+ "VALUES (?,?,?,?,?,?,?)";

		Object getAlertaAlcodigoAux = null;
		if (alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alertarecib.getAlerta().getAlcodigo();
		}
		Object getCaracterAlertaCrcodigoAux = null;
		if (alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcodigo() != null) {
			getCaracterAlertaCrcodigoAux = alertarecib.getCaracterAlerta()
					.getCrcodigo();
		}
		this.jdbcTemplate.update(query, alertarecib.getS5codigo(),
				getAlertaAlcodigoAux, getCaracterAlertaCrcodigoAux,
				alertarecib.getS5codorganismo(),
				alertarecib.getS5feccomunicacion(),
				alertarecib.getS5fecfinalizacion(),
				alertarecib.getS5cantidadactuaciones());
		return alertarecib;
	}

	/**
	 * Updates a single row in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            Pagination
	 * @return AlertaRecib
	 */
	public AlertaRecib update(AlertaRecib alertarecib) {
		String query = "UPDATE ALERTA_RECIB SET S5CODALERTA=?,S5CARACTERALERTA=?,S5CODORGANISMO=?,S5FECCOMUNICACION=?,S5FECFINALIZACION=?,S5CANTIDADACTUACIONES=? WHERE S5CODIGO=?";
		Object getAlertaAlcodigoAux = null;
		if (alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcodigo() != null) {
			getAlertaAlcodigoAux = alertarecib.getAlerta().getAlcodigo();
		}
		Object getCaracterAlertaCrcodigoAux = null;
		if (alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcodigo() != null) {
			getCaracterAlertaCrcodigoAux = alertarecib.getCaracterAlerta()
					.getCrcodigo();
		}
		this.jdbcTemplate.update(query, getAlertaAlcodigoAux,
				getCaracterAlertaCrcodigoAux, alertarecib.getS5codorganismo(),
				alertarecib.getS5feccomunicacion(),
				alertarecib.getS5fecfinalizacion(),
				alertarecib.getS5cantidadactuaciones(),
				alertarecib.getS5codigo());
		return alertarecib;
	}

	/**
	 * Updates a single row in the AlertaRecib table.
	 * 
	 * @param campahnaRecibBusqueda
	 *            CampahnaRecibBusqueda
	 * @return CampahnaRecibBusqueda
	 */
	public CampahnaRecibBusqueda updateFinalizada(
			CampahnaRecibBusqueda campahnaRecibBusqueda) {
		String query = "UPDATE ALERTA_RECIB SET S5FECFINALIZACION=SYSDATE WHERE S5CODIGO=?";

		this.jdbcTemplate.update(query,
				campahnaRecibBusqueda.getCodigoRecibida());
		return campahnaRecibBusqueda;
	}

	/**
	 * Finds a single row in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            Pagination
	 * @return AlertaRecib
	 */
	@Transactional(readOnly = true)
	public AlertaRecib find(AlertaRecib alertarecib) {
		String query = "SELECT t1.S5CODIGO S5CODIGO, t1.S5CODORGANISMO S5CODORGANISMO, t1.S5FECCOMUNICACION S5FECCOMUNICACION, t1.S5FECFINALIZACION S5FECFINALIZACION, t1.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES, t2.ALCODIGO ALERTAALCODIGO, t2.ALCOOR ALERTAALCOOR, t2.ALNRAN ALERTAALNRAN, t2.ALNROR ALERTAALNROR, t2.ALFEEN ALERTAALFEEN, t2.ALFEPLRR ALERTAALFEPLRR, t2.ALNOPRSE ALERTAALNOPRSE, t2.ALNRLOPS ALERTAALNRLOPS, t2.ALNOMAPS ALERTAALNOMAPS, t2.ALNOMOPS ALERTAALNOMOPS, t2.ALFEDUMI ALERTAALFEDUMI, t2.ALTEIN ALERTAALTEIN, t2.ALFERRIN ALERTAALFERRIN, t2.ALINRE ALERTAALINRE, t2.ALFECOOR ALERTAALFECOOR, t2.ALCOTMO ALERTAALCOTMO, t3.CRCODIGO CARACTERALERTACRCODIGO, t3.CRCOOR CARACTERALERTACRCOOR, t3.CRFERERE CARACTERALERTACRFERERE, t3.CRTEINFO CARACTERALERTACRTEINFO, t3.CRCNACTU CARACTERALERTACRCNACTU, t3.CRINPRSE CARACTERALERTACRINPRSE, t2.ALCOCA ALERTAALCOCA, t2.ALCOPS ALERTAALCOPS, t2.ALCOTOP ALERTAALCOTOP, t2.ALCOPA ALERTAALCOPA, t2.ALCOES ALERTAALCOES, t3.CRCOAL CARACTERALERTACRCOAL, t3.CRTIPO CARACTERALERTACRTIPO "
				+ "FROM ALERTA_RECIB t1 , ALERTA t2 , CARACTER_ALERTA t3  "
				+ "WHERE t1.S5CODIGO = ?   AND t1.S5CODALERTA= t2.ALCODIGO(+) AND t1.S5CARACTERALERTA= t3.CRCODIGO(+)  ";
		return (AlertaRecib) this.jdbcTemplate.queryForObject(query, rwMap,
				alertarecib.getS5codigo());
	}

	/**
	 * Removes a single row in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            Pagination
	 * @return
	 */
	public void remove(AlertaRecib alertarecib) {
		String query = "DELETE  FROM ALERTA_RECIB WHERE S5CODIGO=?";
		this.jdbcTemplate.update(query, alertarecib.getS5codigo());
	}

	/**
	 * Finds a List of rows in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            AlertaRecib
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaRecib> findAll(AlertaRecib alertarecib,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S5CODALERTA= t2.ALCODIGO(+) AND t1.S5CARACTERALERTA= t3.CRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S5CODIGO S5CODIGO,t1.S5CODORGANISMO S5CODORGANISMO,t1.S5FECCOMUNICACION S5FECCOMUNICACION,t1.S5FECFINALIZACION S5FECFINALIZACION,t1.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALTEIN ALERTAALTEIN,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t3.CRCODIGO CARACTERALERTACRCODIGO,t3.CRCOOR CARACTERALERTACRCOOR,t3.CRFERERE CARACTERALERTACRFERERE,t3.CRTEINFO CARACTERALERTACRTEINFO,t3.CRCNACTU CARACTERALERTACRCNACTU,t3.CRINPRSE CARACTERALERTACRINPRSE,t2.ALCOCA ALERTAALCOCA,t2.ALCOPS ALERTAALCOPS,t2.ALCOTOP ALERTAALCOTOP,t2.ALCOPA ALERTAALCOPA,t2.ALCOES ALERTAALCOES,t3.CRCOAL CARACTERALERTACRCOAL,t3.CRTIPO CARACTERALERTACRTIPO "
						+ "FROM ALERTA_RECIB t1 ,ALERTA t2 ,CARACTER_ALERTA t3 ");

		if (alertarecib != null && alertarecib.getS5codigo() != null) {
			where.append(" AND t1.S5CODIGO = ?");
			params.add(alertarecib.getS5codigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alertarecib.getAlerta().getAlcodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getComaut() != null
				&& alertarecib.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(alertarecib.getAlerta().getComaut().getCacodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getProducto() != null
				&& alertarecib.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(alertarecib.getAlerta().getProducto().getPscodigo());
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getTipOrigenProd() != null
				&& alertarecib.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(alertarecib.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getPais() != null
				&& alertarecib.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(alertarecib.getAlerta().getPais().getPacodigo());
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getEstablecimiento() != null
				&& alertarecib.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(alertarecib.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(alertarecib.getAlerta().getAlcoor());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(alertarecib.getAlerta().getAlnran());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(alertarecib.getAlerta().getAlnror());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alertarecib.getAlerta().getAlfeen());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alertarecib.getAlerta().getAlfeplrr());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(alertarecib.getAlerta().getAlnoprse());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(alertarecib.getAlerta().getAlnrlops());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(alertarecib.getAlerta().getAlnomaps());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(alertarecib.getAlerta().getAlnomops());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alertarecib.getAlerta().getAlfedumi());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(alertarecib.getAlerta().getAltein());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alertarecib.getAlerta().getAlferrin());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(alertarecib.getAlerta().getAlinre());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alertarecib.getAlerta().getAlfecoor());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(alertarecib.getAlerta().getAlcotmo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND t3.CRCODIGO = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcodigo());
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND t3.CRCOAL = ?");
			params.add(alertarecib.getCaracterAlerta().getAlerta()
					.getAlcodigo());
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta()
						.getTcacodigo() != null) {
			where.append(" AND t3.CRTIPO = ?");
			params.add(alertarecib.getCaracterAlerta().getTipAlerta()
					.getTcacodigo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcoor() != null) {
			where.append(" AND t3.CRCOOR = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcoor());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrferere() != null) {
			where.append(" AND t3.CRFERERE = ?");
			params.add(alertarecib.getCaracterAlerta().getCrferere());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrteinfo() != null) {
			where.append(" AND t3.CRTEINFO = ?");
			params.add(alertarecib.getCaracterAlerta().getCrteinfo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcnactu() != null) {
			where.append(" AND t3.CRCNACTU = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcnactu());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrinprse() != null) {
			where.append(" AND t3.CRINPRSE = ?");
			params.add(alertarecib.getCaracterAlerta().getCrinprse());
		}
		if (alertarecib != null && alertarecib.getS5codorganismo() != null) {
			where.append(" AND t1.S5CODORGANISMO = ?");
			params.add(alertarecib.getS5codorganismo());
		}
		if (alertarecib != null && alertarecib.getS5feccomunicacion() != null) {
			where.append(" AND t1.S5FECCOMUNICACION = ?");
			params.add(alertarecib.getS5feccomunicacion());
		}
		if (alertarecib != null && alertarecib.getS5fecfinalizacion() != null) {
			where.append(" AND t1.S5FECFINALIZACION = ?");
			params.add(alertarecib.getS5fecfinalizacion());
		}
		if (alertarecib != null
				&& alertarecib.getS5cantidadactuaciones() != null) {
			where.append(" AND t1.S5CANTIDADACTUACIONES = ?");
			params.add(alertarecib.getS5cantidadactuaciones());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<AlertaRecib>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the AlertaRecib table.
	 * 
	 * @param alertarecib
	 *            AlertaRecib
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(AlertaRecib alertarecib) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.S5CODALERTA= t2.ALCODIGO(+) and t1.S5CARACTERALERTA= t3.CRCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ALERTA_RECIB t1   ,  ALERTA t2   ,  CARACTER_ALERTA t3  ");
		if (alertarecib != null && alertarecib.getS5codigo() != null) {
			where.append(" AND t1.S5CODIGO = ?");
			params.add(alertarecib.getS5codigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO = ?");
			params.add(alertarecib.getAlerta().getAlcodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getComaut() != null
				&& alertarecib.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND t2.ALCOCA = ?");
			params.add(alertarecib.getAlerta().getComaut().getCacodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getProducto() != null
				&& alertarecib.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ALCOPS = ?");
			params.add(alertarecib.getAlerta().getProducto().getPscodigo());
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getTipOrigenProd() != null
				&& alertarecib.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t2.ALCOTOP = ?");
			params.add(alertarecib.getAlerta().getTipOrigenProd()
					.getTopcodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getPais() != null
				&& alertarecib.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND t2.ALCOPA = ?");
			params.add(alertarecib.getAlerta().getPais().getPacodigo());
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getEstablecimiento() != null
				&& alertarecib.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ALCOES = ?");
			params.add(alertarecib.getAlerta().getEstablecimiento()
					.getEscodigo());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcoor() != null) {
			where.append(" AND t2.ALCOOR = ?");
			params.add(alertarecib.getAlerta().getAlcoor());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN = ?");
			params.add(alertarecib.getAlerta().getAlnran());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnror() != null) {
			where.append(" AND t2.ALNROR = ?");
			params.add(alertarecib.getAlerta().getAlnror());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN = ?");
			params.add(alertarecib.getAlerta().getAlfeen());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR = ?");
			params.add(alertarecib.getAlerta().getAlfeplrr());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnoprse() != null) {
			where.append(" AND t2.ALNOPRSE = ?");
			params.add(alertarecib.getAlerta().getAlnoprse());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnrlops() != null) {
			where.append(" AND t2.ALNRLOPS = ?");
			params.add(alertarecib.getAlerta().getAlnrlops());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomaps() != null) {
			where.append(" AND t2.ALNOMAPS = ?");
			params.add(alertarecib.getAlerta().getAlnomaps());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomops() != null) {
			where.append(" AND t2.ALNOMOPS = ?");
			params.add(alertarecib.getAlerta().getAlnomops());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI = ?");
			params.add(alertarecib.getAlerta().getAlfedumi());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAltein() != null) {
			where.append(" AND t2.ALTEIN = ?");
			params.add(alertarecib.getAlerta().getAltein());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN = ?");
			params.add(alertarecib.getAlerta().getAlferrin());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlinre() != null) {
			where.append(" AND t2.ALINRE = ?");
			params.add(alertarecib.getAlerta().getAlinre());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR = ?");
			params.add(alertarecib.getAlerta().getAlfecoor());
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcotmo() != null) {
			where.append(" AND t2.ALCOTMO = ?");
			params.add(alertarecib.getAlerta().getAlcotmo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND t3.CRCODIGO = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcodigo());
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND t3.CRCOAL = ?");
			params.add(alertarecib.getCaracterAlerta().getAlerta()
					.getAlcodigo());
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta()
						.getTcacodigo() != null) {
			where.append(" AND t3.CRTIPO = ?");
			params.add(alertarecib.getCaracterAlerta().getTipAlerta()
					.getTcacodigo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcoor() != null) {
			where.append(" AND t3.CRCOOR = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcoor());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrferere() != null) {
			where.append(" AND t3.CRFERERE = ?");
			params.add(alertarecib.getCaracterAlerta().getCrferere());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrteinfo() != null) {
			where.append(" AND t3.CRTEINFO = ?");
			params.add(alertarecib.getCaracterAlerta().getCrteinfo());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcnactu() != null) {
			where.append(" AND t3.CRCNACTU = ?");
			params.add(alertarecib.getCaracterAlerta().getCrcnactu());
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrinprse() != null) {
			where.append(" AND t3.CRINPRSE = ?");
			params.add(alertarecib.getCaracterAlerta().getCrinprse());
		}
		if (alertarecib != null && alertarecib.getS5codorganismo() != null) {
			where.append(" AND t1.S5CODORGANISMO = ?");
			params.add(alertarecib.getS5codorganismo());
		}
		if (alertarecib != null && alertarecib.getS5feccomunicacion() != null) {
			where.append(" AND t1.S5FECCOMUNICACION = ?");
			params.add(alertarecib.getS5feccomunicacion());
		}
		if (alertarecib != null && alertarecib.getS5fecfinalizacion() != null) {
			where.append(" AND t1.S5FECFINALIZACION = ?");
			params.add(alertarecib.getS5fecfinalizacion());
		}
		if (alertarecib != null
				&& alertarecib.getS5cantidadactuaciones() != null) {
			where.append(" AND t1.S5CANTIDADACTUACIONES = ?");
			params.add(alertarecib.getS5cantidadactuaciones());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the AlertaRecib table using like.
	 * 
	 * @param alertarecib
	 *            AlertaRecib
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaRecib> findAllLike(AlertaRecib alertarecib,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S5CODALERTA= t2.ALCODIGO(+) AND t1.S5CARACTERALERTA= t3.CRCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S5CODIGO S5CODIGO,t1.S5CODORGANISMO S5CODORGANISMO,t1.S5FECCOMUNICACION S5FECCOMUNICACION,t1.S5FECFINALIZACION S5FECFINALIZACION,t1.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES,t2.ALCODIGO ALERTAALCODIGO,t2.ALCOOR ALERTAALCOOR,t2.ALNRAN ALERTAALNRAN,t2.ALNROR ALERTAALNROR,t2.ALFEEN ALERTAALFEEN,t2.ALFEPLRR ALERTAALFEPLRR,t2.ALNOPRSE ALERTAALNOPRSE,t2.ALNRLOPS ALERTAALNRLOPS,t2.ALNOMAPS ALERTAALNOMAPS,t2.ALNOMOPS ALERTAALNOMOPS,t2.ALFEDUMI ALERTAALFEDUMI,t2.ALTEIN ALERTAALTEIN,t2.ALFERRIN ALERTAALFERRIN,t2.ALINRE ALERTAALINRE,t2.ALFECOOR ALERTAALFECOOR,t2.ALCOTMO ALERTAALCOTMO,t3.CRCODIGO CARACTERALERTACRCODIGO,t3.CRCOOR CARACTERALERTACRCOOR,t3.CRFERERE CARACTERALERTACRFERERE,t3.CRTEINFO CARACTERALERTACRTEINFO,t3.CRCNACTU CARACTERALERTACRCNACTU,t3.CRINPRSE CARACTERALERTACRINPRSE,t2.ALCOCA ALERTAALCOCA,t2.ALCOPS ALERTAALCOPS,t2.ALCOTOP ALERTAALCOTOP,t2.ALCOPA ALERTAALCOPA,t2.ALCOES ALERTAALCOES,t3.CRCOAL CARACTERALERTACRCOAL,t3.CRTIPO CARACTERALERTACRTIPO "
						+ "FROM ALERTA_RECIB t1 ,ALERTA t2 ,CARACTER_ALERTA t3 ");

		if (alertarecib != null && alertarecib.getS5codigo() != null) {
			where.append(" AND UPPER(t1.S5CODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getS5codigo().toUpperCase() + "%");
			} else {
				params.add("%" + alertarecib.getS5codigo().toUpperCase() + "%");
			}
			where.append(" AND t1.S5CODIGO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcodigo() != null) {
			where.append(" AND t2.ALCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlcodigo() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlcodigo() + "%");
			}
			where.append(" AND t2.ALCODIGO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getComaut() != null
				&& alertarecib.getAlerta().getComaut().getCacodigo() != null) {
			where.append(" AND UPPER(t2.ALCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getComaut().getCacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getComaut().getCacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOCA IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getProducto() != null
				&& alertarecib.getAlerta().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t2.ALCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getProducto().getPscodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getProducto().getPscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPS IS NOT NULL");
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getTipOrigenProd() != null
				&& alertarecib.getAlerta().getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND UPPER(t2.ALCOTOP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getTipOrigenProd()
						.getTopcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getTipOrigenProd()
								.getTopcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOTOP IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getPais() != null
				&& alertarecib.getAlerta().getPais().getPacodigo() != null) {
			where.append(" AND UPPER(t2.ALCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getPais().getPacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getPais().getPacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOPA IS NOT NULL");
		}
		if (alertarecib != null
				&& alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getEstablecimiento() != null
				&& alertarecib.getAlerta().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t2.ALCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ALCOES IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcoor() != null) {
			where.append(" AND UPPER(t2.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlcoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOOR IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnran() != null) {
			where.append(" AND t2.ALNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnran() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlnran() + "%");
			}
			where.append(" AND t2.ALNRAN IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnror() != null) {
			where.append(" AND UPPER(t2.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnror().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNROR IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeen() != null) {
			where.append(" AND t2.ALFEEN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlfeen() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlfeen() + "%");
			}
			where.append(" AND t2.ALFEEN IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfeplrr() != null) {
			where.append(" AND t2.ALFEPLRR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlfeplrr() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlfeplrr() + "%");
			}
			where.append(" AND t2.ALFEPLRR IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnoprse() != null) {
			where.append(" AND UPPER(t2.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlnoprse().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOPRSE IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnrlops() != null) {
			where.append(" AND UPPER(t2.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlnrlops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNRLOPS IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomaps() != null) {
			where.append(" AND UPPER(t2.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlnomaps().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMAPS IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlnomops() != null) {
			where.append(" AND UPPER(t2.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlnomops().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALNOMOPS IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfedumi() != null) {
			where.append(" AND t2.ALFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlfedumi() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlfedumi() + "%");
			}
			where.append(" AND t2.ALFEDUMI IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAltein() != null) {
			where.append(" AND UPPER(t2.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAltein().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAltein().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALTEIN IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlferrin() != null) {
			where.append(" AND t2.ALFERRIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlferrin() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlferrin() + "%");
			}
			where.append(" AND t2.ALFERRIN IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlinre() != null) {
			where.append(" AND UPPER(t2.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlinre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALINRE IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlfecoor() != null) {
			where.append(" AND t2.ALFECOOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlfecoor() + "%");
			} else {
				params.add("%" + alertarecib.getAlerta().getAlfecoor() + "%");
			}
			where.append(" AND t2.ALFECOOR IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getAlerta() != null
				&& alertarecib.getAlerta().getAlcotmo() != null) {
			where.append(" AND UPPER(t2.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getAlerta().getAlcotmo().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ALCOTMO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND t3.CRCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrcodigo() + "%");
			} else {
				params.add("%" + alertarecib.getCaracterAlerta().getCrcodigo()
						+ "%");
			}
			where.append(" AND t3.CRCODIGO IS NOT NULL");
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta() != null
				&& alertarecib.getCaracterAlerta().getAlerta().getAlcodigo() != null) {
			where.append(" AND UPPER(t3.CRCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getAlerta()
						.getAlcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getCaracterAlerta().getAlerta()
								.getAlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.CRCOAL IS NOT NULL");
		}
		if (alertarecib != null
				&& alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta() != null
				&& alertarecib.getCaracterAlerta().getTipAlerta()
						.getTcacodigo() != null) {
			where.append(" AND UPPER(t3.CRTIPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getTipAlerta()
						.getTcacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getCaracterAlerta().getTipAlerta()
								.getTcacodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.CRTIPO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcoor() != null) {
			where.append(" AND UPPER(t3.CRCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrcoor()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getCaracterAlerta().getCrcoor()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CRCOOR IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrferere() != null) {
			where.append(" AND t3.CRFERERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrferere() + "%");
			} else {
				params.add("%" + alertarecib.getCaracterAlerta().getCrferere()
						+ "%");
			}
			where.append(" AND t3.CRFERERE IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrteinfo() != null) {
			where.append(" AND UPPER(t3.CRTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrteinfo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getCaracterAlerta().getCrteinfo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CRTEINFO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrcnactu() != null) {
			where.append(" AND t3.CRCNACTU like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrcnactu() + "%");
			} else {
				params.add("%" + alertarecib.getCaracterAlerta().getCrcnactu()
						+ "%");
			}
			where.append(" AND t3.CRCNACTU IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getCaracterAlerta() != null
				&& alertarecib.getCaracterAlerta().getCrinprse() != null) {
			where.append(" AND UPPER(t3.CRINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getCaracterAlerta().getCrinprse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alertarecib.getCaracterAlerta().getCrinprse()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.CRINPRSE IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getS5codorganismo() != null) {
			where.append(" AND UPPER(t1.S5CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getS5codorganismo().toUpperCase() + "%");
			} else {
				params.add("%" + alertarecib.getS5codorganismo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.S5CODORGANISMO IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getS5feccomunicacion() != null) {
			where.append(" AND t1.S5FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getS5feccomunicacion() + "%");
			} else {
				params.add("%" + alertarecib.getS5feccomunicacion() + "%");
			}
			where.append(" AND t1.S5FECCOMUNICACION IS NOT NULL");
		}
		if (alertarecib != null && alertarecib.getS5fecfinalizacion() != null) {
			where.append(" AND t1.S5FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getS5fecfinalizacion() + "%");
			} else {
				params.add("%" + alertarecib.getS5fecfinalizacion() + "%");
			}
			where.append(" AND t1.S5FECFINALIZACION IS NOT NULL");
		}
		if (alertarecib != null
				&& alertarecib.getS5cantidadactuaciones() != null) {
			where.append(" AND t1.S5CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alertarecib.getS5cantidadactuaciones() + "%");
			} else {
				params.add("%" + alertarecib.getS5cantidadactuaciones() + "%");
			}
			where.append(" AND t1.S5CANTIDADACTUACIONES IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<AlertaRecib>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
