package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Comaut;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipOrigenProd;

/**
 * * AlertaDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class AlertaDaoImpl implements AlertaDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Alerta> rwMap = new RowMapper<Alerta>() {
		public Alerta mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Alerta(resultSet.getString("ALCODIGO"),
					resultSet.getString("ALCOOR"), resultSet.getLong("ALNRAN"),
					resultSet.getString("ALNROR"), resultSet.getDate("ALFEEN"),
					resultSet.getDate("ALFEPLRR"),
					resultSet.getString("ALNOPRSE"),
					resultSet.getString("ALNRLOPS"),
					resultSet.getString("ALNOMAPS"),
					resultSet.getString("ALNOMOPS"),
					resultSet.getDate("ALFEDUMI"),
					resultSet.getString("ALTEIN"),
					resultSet.getDate("ALFERRIN"),
					resultSet.getString("ALINRE"),
					resultSet.getDate("ALFECOOR"),
					resultSet.getString("ALCOTMO"), new Comaut(
							resultSet.getString("ComautCACODIGO"),
							resultSet.getString("ComautCANOMBRE"), new Pais(
									resultSet.getString("ComautCACOPA"), null,
									null, null, null, null)), new Producto(
							resultSet.getString("ProductoPSCODIGO"),
							resultSet.getString("ProductoPSNOMBRE"),
							resultSet.getString("ProductoPSNOCO"),
							resultSet.getString("ProductoPSDESCRI"),
							resultSet.getString("ProductoPSCOSE"),
							resultSet.getString("ProductoPSNOMBREE"),
							resultSet.getString("ProductoPSNOMBREI"),
							resultSet.getString("ProductoPSNOMBREF"),
							resultSet.getString("ProductoPSNOMBREA"),
							resultSet.getString("ProductoPSNOCOE"),
							resultSet.getString("ProductoPSNOCOI"),
							resultSet.getString("ProductoPSNOCOF"),
							resultSet.getString("ProductoPSNOCOA"),
							resultSet.getString("ProductoPSDESCRIE"),
							resultSet.getString("ProductoPSDESCRII"),
							resultSet.getString("ProductoPSDESCRIF"),
							resultSet.getString("ProductoPSDESCRIA"),
							resultSet.getString("ProductoPSSEL1"),
							resultSet.getString("ProductoPSCOINC"),
							new ProdAgrupado(resultSet
									.getString("ProductoPSCOE8"), null, null,
									null)), new TipOrigenProd(
							resultSet.getString("TipOrigenProdTOPCODIGO"),
							resultSet.getString("TipOrigenProdTOPNOMBRE")),
					new Pais(resultSet.getString("PaisPACODIGO"), resultSet
							.getString("PaisPACOAL2"), resultSet
							.getString("PaisPACOAL3"), resultSet
							.getString("PaisPANOMBRE")), new Establecimiento(
							resultSet.getString("ESTABLEESCODIGO"),
							resultSet.getString("ESTABLEESNOMBRE"),
							resultSet.getString("ESTABLEESNIF"),
							resultSet.getString("ESTABLEESNOAN"),
							resultSet.getString("ESTABLEESNOCO"),
							resultSet.getString("ESTABLEESNODIR"),
							resultSet.getString("ESTABLEESCOLO"),
							resultSet.getString("ESTABLEESNRCOPO"),
							resultSet.getString("ESTABLEESNRTEL"),
							resultSet.getString("ESTABLEESNRFAX"),
							resultSet.getString("ESTABLEESCOPA"),
							resultSet.getString("ESTABLEESINCAPR"),
							resultSet.getString("ESTABLEESINDEMP"),
							resultSet.getString("ESTABLEESTECO"),
							resultSet.getString("ESTABLEESINADAR"),
							resultSet.getDate("ESTABLEESFEADAR"),
							resultSet.getString("ESTABLEESCOEM"),
							resultSet.getString("ESTABLEESINEMPR"),
							resultSet.getString("ESTABLEESNRTEL2"),
							resultSet.getDate("ESTABLEESFEBA"),
							resultSet.getString("ESTABLEESNOAP1"),
							resultSet.getString("ESTABLEESNOAP2"),
							resultSet.getString("ESTABLEESNOLO"),
							resultSet.getString("ESTABLEESCOMAPV"),
							resultSet.getString("ESTABLEESCOCA"),
							resultSet.getString("ESTABLEESNOPECO"),
							resultSet.getString("ESTABLEESCOIDCO"),
							resultSet.getString("ESTABLEESINRECO"),
							resultSet.getString("ESTABLEESFEMOD"),
							resultSet.getString("ESTABLEESINESCO"),
							resultSet.getString("ESTABLEESNOMU"),
							resultSet.getString("ESTABLEESNOREP"),
							resultSet.getString("ESTABLEESNIFREP"),
							resultSet.getString("ESTABLEDTTEEMR"),
							resultSet.getString("ESTABLEESCAREP"),
							resultSet.getString("ESTABLEESTEURL"),
							resultSet.getString("ESTABLEESCOOE"),
							resultSet.getString("ESTABLEESNODECO"),
							resultSet.getString("ESTABLEESINTIAR"),
							resultSet.getDate("ESTABLEESFEPLAD"),
							resultSet.getString("ESTABLEESINDEME"),
							resultSet.getString("ESTABLEESNORAPAISID"),
							resultSet.getString("ESTABLEESNORAPAISNOMBRE"),
							resultSet.getString("ESTABLEESNORAPROVINCIAID"),
							resultSet.getString("ESTABLEESNOMBREPROVINCIA"),
							resultSet.getString("ESTABLEESNORAMUNICIPIOID"),
							resultSet.getString("ESTABLEESNOMBREMUNICIPIO"),
							resultSet.getString("ESTABLEESNORALOCALIDADID"),
							resultSet.getString("ESTABLEESNOMBRELOCALIDAD"),
							resultSet.getString("ESTABLEESNORACALLEID"),
							resultSet.getString("ESTABLEESNOMBRECALLE"),
							resultSet.getString("ESTABLEESNORACPID"),
							resultSet.getString("ESTABLEESNOMBRECP"),
							resultSet.getString("ESTABLEESNORAPORTALID"),
							resultSet.getString("ESTABLEESNOMBREPORTAL"),
							resultSet.getString("ESTABLEESNOMBREPISO"),
							resultSet.getString("EstableESDIRECCION_NOCAPV"),
							resultSet.getString("EstableESEXTRANJERO"), null,
							new CensoMonitor(resultSet
									.getString("ESTABLEESCOZS"), null, null,
									null, null, null, null, null, null, null,
									null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta add(Alerta alerta) {

		String query = "INSERT INTO ALERTA( ALCODIGO,ALCOCA,ALCOPS,ALCOTOP,ALCOPA,ALCOES,ALCOOR,ALNRAN,ALNROR,ALFEEN,ALFEPLRR,ALNOPRSE,ALNRLOPS,ALNOMAPS,ALNOMOPS,ALFEDUMI,ALTEIN,ALFERRIN,ALINRE,ALFECOOR,ALCOTMO)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getComautCacodigoAux = null;
		if (alerta.getComaut() != null
				&& alerta.getComaut().getCacodigo() != null) {
			getComautCacodigoAux = alerta.getComaut().getCacodigo();
		}
		Object getProductoPscodigoAux = null;
		if (alerta.getProducto() != null
				&& alerta.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = alerta.getProducto().getPscodigo();
		}
		Object getTipOrigenProdTopcodigoAux = null;
		if (alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopcodigo() != null) {
			getTipOrigenProdTopcodigoAux = alerta.getTipOrigenProd()
					.getTopcodigo();
		}
		Object getPaisPacodigoAux = null;
		if (alerta.getPais() != null && alerta.getPais().getPacodigo() != null) {
			getPaisPacodigoAux = alerta.getPais().getPacodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = alerta.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, alerta.getAlcodigo(),
				getComautCacodigoAux, getProductoPscodigoAux,
				getTipOrigenProdTopcodigoAux, getPaisPacodigoAux,
				getEstablecimientoEscodigoAux, alerta.getAlcoor(),
				alerta.getAlnran(), alerta.getAlnror(), alerta.getAlfeen(),
				alerta.getAlfeplrr(), alerta.getAlnoprse(),
				alerta.getAlnrlops(), alerta.getAlnomaps(),
				alerta.getAlnomops(), alerta.getAlfedumi(), alerta.getAltein(),
				alerta.getAlferrin(), alerta.getAlinre(), alerta.getAlfecoor(),
				alerta.getAlcotmo());
		return alerta;
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	public Alerta update(Alerta alerta) {
		String query = "UPDATE ALERTA SET ALCOCA=?,ALCOPS=?,ALCOTOP=?,ALCOPA=?,ALCOES=?,ALCOOR=?,ALNRAN=?,ALNROR=?,ALFEEN=?,ALFEPLRR=?,ALNOPRSE=?,ALNRLOPS=?,ALNOMAPS=?,ALNOMOPS=?,ALFEDUMI=?,ALTEIN=?,ALFERRIN=?,ALINRE=?,ALFECOOR=?,ALCOTMO=? WHERE ALCODIGO=?";
		Object getComautCacodigoAux = null;
		if (alerta.getComaut() != null
				&& alerta.getComaut().getCacodigo() != null) {
			getComautCacodigoAux = alerta.getComaut().getCacodigo();
		}
		Object getProductoPscodigoAux = null;
		if (alerta.getProducto() != null
				&& alerta.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = alerta.getProducto().getPscodigo();
		}
		Object getTipOrigenProdTopcodigoAux = null;
		if (alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopcodigo() != null) {
			getTipOrigenProdTopcodigoAux = alerta.getTipOrigenProd()
					.getTopcodigo();
		}
		Object getPaisPacodigoAux = null;
		if (alerta.getPais() != null && alerta.getPais().getPacodigo() != null) {
			getPaisPacodigoAux = alerta.getPais().getPacodigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = alerta.getEstablecimiento()
					.getEscodigo();
		}
		this.jdbcTemplate.update(query, getComautCacodigoAux,
				getProductoPscodigoAux, getTipOrigenProdTopcodigoAux,
				getPaisPacodigoAux, getEstablecimientoEscodigoAux,
				alerta.getAlcoor(), alerta.getAlnran(), alerta.getAlnror(),
				alerta.getAlfeen(), alerta.getAlfeplrr(), alerta.getAlnoprse(),
				alerta.getAlnrlops(), alerta.getAlnomaps(),
				alerta.getAlnomops(), alerta.getAlfedumi(), alerta.getAltein(),
				alerta.getAlferrin(), alerta.getAlinre(), alerta.getAlfecoor(),
				alerta.getAlcotmo(), alerta.getAlcodigo());
		return alerta;
	}

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alertaDetalle
	 *            AlertaDetalle
	 * @return Alerta
	 */
	public AlertaDetalle updateEstablecimiento(AlertaDetalle alertaDetalle) {
		String query = "UPDATE ALERTA SET ALCOES=? WHERE ALCODIGO=?";

		this.jdbcTemplate.update(query, alertaDetalle.getEscodigo(),
				alertaDetalle.getAlcodigo());
		return alertaDetalle;
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return Alerta
	 */
	@Transactional(readOnly = true)
	public Alerta find(Alerta alerta) {
		String query = "SELECT t1.ALCODIGO ALCODIGO, t1.ALCOOR ALCOOR, t1.ALNRAN ALNRAN, t1.ALNROR ALNROR, t1.ALFEEN ALFEEN, t1.ALFEPLRR ALFEPLRR, t1.ALNOPRSE ALNOPRSE, t1.ALNRLOPS ALNRLOPS, t1.ALNOMAPS ALNOMAPS, t1.ALNOMOPS ALNOMOPS, t1.ALFEDUMI ALFEDUMI, t1.ALTEIN ALTEIN, t1.ALFERRIN ALFERRIN, t1.ALINRE ALINRE, t1.ALFECOOR ALFECOOR, t1.ALCOTMO ALCOTMO, t2.CACODIGO COMAUTCACODIGO, t2.CANOMBRE COMAUTCANOMBRE, t3.PSCODIGO PRODUCTOPSCODIGO, t3.PSNOMBRE PRODUCTOPSNOMBRE, t3.PSNOCO PRODUCTOPSNOCO, t3.PSDESCRI PRODUCTOPSDESCRI, t3.PSCOSE PRODUCTOPSCOSE, t3.PSNOMBREE PRODUCTOPSNOMBREE, t3.PSNOMBREI PRODUCTOPSNOMBREI, t3.PSNOMBREF PRODUCTOPSNOMBREF, t3.PSNOMBREA PRODUCTOPSNOMBREA, t3.PSNOCOE PRODUCTOPSNOCOE, t3.PSNOCOI PRODUCTOPSNOCOI, t3.PSNOCOF PRODUCTOPSNOCOF, t3.PSNOCOA PRODUCTOPSNOCOA, t3.PSDESCRIE PRODUCTOPSDESCRIE, t3.PSDESCRII PRODUCTOPSDESCRII, t3.PSDESCRIF PRODUCTOPSDESCRIF, t3.PSDESCRIA PRODUCTOPSDESCRIA, t3.PSSEL1 PRODUCTOPSSEL1, t3.PSCOINC PRODUCTOPSCOINC, t4.TOPCODIGO TIPORIGENPRODTOPCODIGO, t4.TOPNOMBRE TIPORIGENPRODTOPNOMBRE, t5.PACODIGO PAISPACODIGO, t5.PACOAL2 PAISPACOAL2, t5.PACOAL3 PAISPACOAL3, t5.PANOMBRE PAISPANOMBRE, t6.ESCODIGO ESTABLEESCODIGO, t6.ESNOMBRE ESTABLEESNOMBRE, t6.ESNIF ESTABLEESNIF, t6.ESNOAN ESTABLEESNOAN, t6.ESNOCO ESTABLEESNOCO, t6.ESNODIR ESTABLEESNODIR, t6.ESCOLO ESTABLEESCOLO, t6.ESNRCOPO ESTABLEESNRCOPO, t6.ESNRTEL ESTABLEESNRTEL, t6.ESNRFAX ESTABLEESNRFAX, t6.ESCOPA ESTABLEESCOPA, t6.ESINCAPR ESTABLEESINCAPR, t6.ESINDEMP ESTABLEESINDEMP, t6.ESTECO ESTABLEESTECO, t6.ESINADAR ESTABLEESINADAR, t6.ESFEADAR ESTABLEESFEADAR, t6.ESCOEM ESTABLEESCOEM, t6.ESINEMPR ESTABLEESINEMPR, t6.ESNRTEL2 ESTABLEESNRTEL2, t6.ESFEBA ESTABLEESFEBA, t6.ESNOAP1 ESTABLEESNOAP1, t6.ESNOAP2 ESTABLEESNOAP2, t6.ESNOLO ESTABLEESNOLO, t6.ESCOMAPV ESTABLEESCOMAPV, t6.ESCOCA ESTABLEESCOCA, t6.ESNOPECO ESTABLEESNOPECO, t6.ESCOIDCO ESTABLEESCOIDCO, t6.ESINRECO ESTABLEESINRECO, t6.ESFEMOD ESTABLEESFEMOD, t6.ESINESCO ESTABLEESINESCO, t6.ESNOMU ESTABLEESNOMU, t6.ESNOREP ESTABLEESNOREP, t6.ESNIFREP ESTABLEESNIFREP, t6.DTTEEMR ESTABLEDTTEEMR, t6.ESCAREP ESTABLEESCAREP, t6.ESTEURL ESTABLEESTEURL, t6.ESCOOE ESTABLEESCOOE, t6.ESNODECO ESTABLEESNODECO, t6.ESINTIAR ESTABLEESINTIAR, t6.ESFEPLAD ESTABLEESFEPLAD, t6.ESINDEME ESTABLEESINDEME, t6.ESNORA_PAIS_ID ESTABLEESNORAPAISID, t6.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE, t6.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID, t6.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA, t6.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID, t6.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO, t6.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID, t6.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD, t6.ESNORA_CALLE_ID ESTABLEESNORACALLEID, t6.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE, t6.ESNORA_CP_ID ESTABLEESNORACPID, t6.ESNOMBRE_CP ESTABLEESNOMBRECP, t6.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID, t6.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL, t6.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t6.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t6.ESEXTRANJERO EstableESEXTRANJERO,t2.CACOPA COMAUTCACOPA, t3.PSCOE8 PRODUCTOPSCOE8, t6.ESCOZS ESTABLEESCOZS "
				+ "FROM ALERTA t1 , COMAUT t2 , PRODUCTO t3 , ORI_PROD_MUESTRA t4 , PAIS t5 , ESTABLECIMIENTO t6  "
				+ "WHERE t1.ALCODIGO = ?   AND t1.ALCOCA= t2.CACODIGO(+) AND t1.ALCOPS= t3.PSCODIGO(+) AND t1.ALCOTOP= t4.TOPCODIGO(+) AND t1.ALCOPA= t5.PACODIGO(+) AND t1.ALCOES= t6.ESCODIGO(+)  ";
		return (Alerta) this.jdbcTemplate.queryForObject(query, rwMap,
				alerta.getAlcodigo());
	}

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return AlertaDetalle
	 */
	@Transactional(readOnly = true)
	public AlertaDetalle findAlerta(Alerta alerta) {
		String query = "SELECT t1.ALCODIGO ALCODIGO, t1.ALCOOR ALCOOR, t1.ALNRAN ALNRAN, t1.ALNROR ALNROR, t1.ALFEEN ALFEEN, t1.ALFEPLRR ALFEPLRR, t1.ALTEIN ALTEIN, t5.CRTIPO CRTIPO, t3.PSCODIGO PRODUCTOPSCODIGO, t3.PSNOMBRE PRODUCTOPSNOMBRE, t3.PSNOMBREE PRODUCTOPSNOMBREE, t3.PSNOCO PRODUCTOPSNOCO, t3.PSNOCOE PRODUCTOPSNOCOE, t3.PSDESCRI PRODUCTOPSDESCRI,    t3.PSDESCRIE PRODUCTOPSDESCRIE, t1.ALNOPRSE ALNOPRSE, t1.ALNRLOPS ALNRLOPS, t1.ALNOMAPS ALNOMAPS, t1.ALNOMOPS ALNOMOPS, t1.ALFEDUMI ALFEDUMI, t4.ESCODIGO ESTABLEESCODIGO, t4.ESNOMBRE ESTABLEESNOMBRE, t4.ESNIF ESTABLEESNIF, t4.ESNOCO ESTABLEESNOCO, t4.ESNORA_PAIS_ID ESTABLEESNORAPAISID, t4.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE, t4.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID, t4.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA, t4.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID, t4.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO, t4.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID, t4.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD, t4.ESNORA_CALLE_ID ESTABLEESNORACALLEID, t4.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE, t4.ESNORA_CP_ID ESTABLEESNORACPID, t4.ESNOMBRE_CP ESTABLEESNOMBRECP, t4.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID, t4.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL, t4.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t4.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV "
				+ "FROM ALERTA t1 ,  ALERTA_RECIB t2, PRODUCTO t3, ESTABLECIMIENTO t4, CARACTER_ALERTA t5 "
				+ "WHERE t1.ALCODIGO = ?  AND t2.S5CODORGANISMO = ? AND t1.ALCODIGO = t2.S5CODALERTA(+) AND t1.ALCOPS= t3.PSCODIGO(+) AND t1.ALCOES= t4.ESCODIGO(+) AND t2.S5CARACTERALERTA = t5.CRCODIGO(+) ";
		return (AlertaDetalle) this.jdbcTemplate.queryForObject(query,
				new RowMapper<AlertaDetalle>() {
					public AlertaDetalle mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new AlertaDetalle(
								resultSet.getString("ALCODIGO"),
								resultSet.getString("ALCOOR"),
								resultSet.getLong("ALNRAN"),
								resultSet.getString("ALNROR"),
								resultSet.getDate("ALFEEN"),
								resultSet.getDate("ALFEPLRR"),
								resultSet.getString("ALTEIN"),
								resultSet.getString("CRTIPO"),
								resultSet.getString("ProductoPSCODIGO"),
								resultSet.getString("ProductoPSNOMBRE"),
								resultSet.getString("ProductoPSNOMBREE"),
								resultSet.getString("ProductoPSNOCO"),
								resultSet.getString("ProductoPSNOCOE"),
								resultSet.getString("ProductoPSDESCRI"),
								resultSet.getString("ProductoPSDESCRIE"),
								resultSet.getString("ALNOPRSE"),
								resultSet.getString("ALNOMAPS"),
								resultSet.getString("ALNOMOPS"),
								resultSet.getString("ALNRLOPS"),
								resultSet.getDate("ALFEDUMI"),
								resultSet.getString("ESTABLEESCODIGO"),
								resultSet.getString("ESTABLEESNOMBRE"),
								resultSet.getString("ESTABLEESNIF"),
								resultSet.getString("ESTABLEESNOCO"),
								resultSet.getString("ESTABLEESNORAPAISID"),
								resultSet.getString("ESTABLEESNORAPAISNOMBRE"),
								resultSet.getString("ESTABLEESNORAPROVINCIAID"),
								resultSet.getString("ESTABLEESNOMBREPROVINCIA"),
								resultSet.getString("ESTABLEESNORAMUNICIPIOID"),
								resultSet.getString("ESTABLEESNOMBREMUNICIPIO"),
								resultSet.getString("ESTABLEESNORALOCALIDADID"),
								resultSet.getString("ESTABLEESNOMBRELOCALIDAD"),
								resultSet.getString("ESTABLEESNORACALLEID"),
								resultSet.getString("ESTABLEESNOMBRECALLE"),
								resultSet.getString("ESTABLEESNORACPID"),
								resultSet.getString("ESTABLEESNOMBRECP"),
								resultSet.getString("ESTABLEESNORAPORTALID"),
								resultSet.getString("ESTABLEESNOMBREPORTAL"),
								resultSet.getString("ESTABLEESNOMBREPISO"),
								resultSet
										.getString("ESTABLEESDIRECCION_NOCAPV"));
					}
				}, alerta.getAlcodigo(), alerta.getAlcoor());
	}

	/**
	 * Removes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return
	 */
	public void remove(Alerta alerta) {
		String query = "DELETE  FROM ALERTA WHERE ALCODIGO=?";
		this.jdbcTemplate.update(query, alerta.getAlcodigo());
	}

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<AlertaDetalle> findAllAlertaEstablecimiento(Alerta alerta,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT t1.ALCODIGO ALCODIGO "
				+ "FROM ALERTA t1 ");

		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t1.ALCOES = ?");
			params.add(alerta.getEstablecimiento().getEscodigo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<AlertaDetalle>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<AlertaDetalle>() {
					public AlertaDetalle mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new AlertaDetalle(resultSet
								.getString("ALCODIGO"), null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null, null,
								null, null, null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Alerta> findAll(Alerta alerta, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ALCOCA= t2.CACODIGO(+) AND t1.ALCOPS= t3.PSCODIGO(+) AND t1.ALCOTOP= t4.TOPCODIGO(+) AND t1.ALCOPA= t5.PACODIGO(+) AND t1.ALCOES= t6.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALTEIN ALTEIN,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t2.CACODIGO COMAUTCACODIGO,t2.CANOMBRE COMAUTCANOMBRE,t3.PSCODIGO PRODUCTOPSCODIGO,t3.PSNOMBRE PRODUCTOPSNOMBRE,t3.PSNOCO PRODUCTOPSNOCO,t3.PSDESCRI PRODUCTOPSDESCRI,t3.PSCOSE PRODUCTOPSCOSE,t3.PSNOMBREE PRODUCTOPSNOMBREE,t3.PSNOMBREI PRODUCTOPSNOMBREI,t3.PSNOMBREF PRODUCTOPSNOMBREF,t3.PSNOMBREA PRODUCTOPSNOMBREA,t3.PSNOCOE PRODUCTOPSNOCOE,t3.PSNOCOI PRODUCTOPSNOCOI,t3.PSNOCOF PRODUCTOPSNOCOF,t3.PSNOCOA PRODUCTOPSNOCOA,t3.PSDESCRIE PRODUCTOPSDESCRIE,t3.PSDESCRII PRODUCTOPSDESCRII,t3.PSDESCRIF PRODUCTOPSDESCRIF,t3.PSDESCRIA PRODUCTOPSDESCRIA,t3.PSSEL1 PRODUCTOPSSEL1,t3.PSCOINC PRODUCTOPSCOINC,t4.TOPCODIGO TIPORIGENPRODTOPCODIGO,t4.TOPNOMBRE TIPORIGENPRODTOPNOMBRE,t5.PACODIGO PAISPACODIGO,t5.PACOAL2 PAISPACOAL2,t5.PACOAL3 PAISPACOAL3,t5.PANOMBRE PAISPANOMBRE,t6.ESCODIGO ESTABLEESCODIGO,t6.ESNOMBRE ESTABLEESNOMBRE,t6.ESNIF ESTABLEESNIF,t6.ESNOAN ESTABLEESNOAN,t6.ESNOCO ESTABLEESNOCO,t6.ESNODIR ESTABLEESNODIR,t6.ESCOLO ESTABLEESCOLO,t6.ESNRCOPO ESTABLEESNRCOPO,t6.ESNRTEL ESTABLEESNRTEL,t6.ESNRFAX ESTABLEESNRFAX,t6.ESCOPA ESTABLEESCOPA,t6.ESINCAPR ESTABLEESINCAPR,t6.ESINDEMP ESTABLEESINDEMP,t6.ESTECO ESTABLEESTECO,t6.ESINADAR ESTABLEESINADAR,t6.ESFEADAR ESTABLEESFEADAR,t6.ESCOEM ESTABLEESCOEM,t6.ESINEMPR ESTABLEESINEMPR,t6.ESNRTEL2 ESTABLEESNRTEL2,t6.ESFEBA ESTABLEESFEBA,t6.ESNOAP1 ESTABLEESNOAP1,t6.ESNOAP2 ESTABLEESNOAP2,t6.ESNOLO ESTABLEESNOLO,t6.ESCOMAPV ESTABLEESCOMAPV,t6.ESCOCA ESTABLEESCOCA,t6.ESNOPECO ESTABLEESNOPECO,t6.ESCOIDCO ESTABLEESCOIDCO,t6.ESINRECO ESTABLEESINRECO,t6.ESFEMOD ESTABLEESFEMOD,t6.ESINESCO ESTABLEESINESCO,t6.ESNOMU ESTABLEESNOMU,t6.ESNOREP ESTABLEESNOREP,t6.ESNIFREP ESTABLEESNIFREP,t6.DTTEEMR ESTABLEDTTEEMR,t6.ESCAREP ESTABLEESCAREP,t6.ESTEURL ESTABLEESTEURL,t6.ESCOOE ESTABLEESCOOE,t6.ESNODECO ESTABLEESNODECO,t6.ESINTIAR ESTABLEESINTIAR,t6.ESFEPLAD ESTABLEESFEPLAD,t6.ESINDEME ESTABLEESINDEME,t6.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t6.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t6.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t6.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t6.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t6.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t6.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t6.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t6.ESNORA_CALLE_ID ESTABLEESNORACALLEID,t6.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE,t6.ESNORA_CP_ID ESTABLEESNORACPID,t6.ESNOMBRE_CP ESTABLEESNOMBRECP,t6.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID,t6.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL,t6.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t6.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t2.CACOPA COMAUTCACOPA,t3.PSCOE8 PRODUCTOPSCOE8,t6.ESCOZS ESTABLEESCOZS "
						+ "FROM ALERTA t1 ,COMAUT t2 ,PRODUCTO t3 ,ORI_PROD_MUESTRA t4 ,PAIS t5 ,ESTABLECIMIENTO t6 ");

		if (alerta != null && alerta.getAlcodigo() != null) {
			where.append(" AND t1.ALCODIGO = ?");
			params.add(alerta.getAlcodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCacodigo() != null) {
			where.append(" AND t2.CACODIGO = ?");
			params.add(alerta.getComaut().getCacodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getPais() != null
				&& alerta.getComaut().getPais().getPacodigo() != null) {
			where.append(" AND t2.CACOPA = ?");
			params.add(alerta.getComaut().getPais().getPacodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCanombre() != null) {
			where.append(" AND t2.CANOMBRE = ?");
			params.add(alerta.getComaut().getCanombre());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(alerta.getProducto().getPscodigo());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getProdAgrupado() != null
				&& alerta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(alerta.getProducto().getProdAgrupado().getE8codigo());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombre() != null) {
			where.append(" AND t3.PSNOMBRE = ?");
			params.add(alerta.getProducto().getPsnombre());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(alerta.getProducto().getPsnoco());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(alerta.getProducto().getPsdescri());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(alerta.getProducto().getPscose());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombree() != null) {
			where.append(" AND t3.PSNOMBREE = ?");
			params.add(alerta.getProducto().getPsnombree());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(alerta.getProducto().getPsnombrei());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(alerta.getProducto().getPsnombref());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(alerta.getProducto().getPsnombrea());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(alerta.getProducto().getPsnocoe());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(alerta.getProducto().getPsnocoi());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(alerta.getProducto().getPsnocof());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(alerta.getProducto().getPsnocoa());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(alerta.getProducto().getPsdescrie());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(alerta.getProducto().getPsdescrii());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(alerta.getProducto().getPsdescrif());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(alerta.getProducto().getPsdescria());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(alerta.getProducto().getPssel1());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(alerta.getProducto().getPscoinc());
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t4.TOPCODIGO = ?");
			params.add(alerta.getTipOrigenProd().getTopcodigo());
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopnombre() != null) {
			where.append(" AND t4.TOPNOMBRE = ?");
			params.add(alerta.getTipOrigenProd().getTopnombre());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacodigo() != null) {
			where.append(" AND t5.PACODIGO = ?");
			params.add(alerta.getPais().getPacodigo());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal2() != null) {
			where.append(" AND t5.PACOAL2 = ?");
			params.add(alerta.getPais().getPacoal2());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal3() != null) {
			where.append(" AND t5.PACOAL3 = ?");
			params.add(alerta.getPais().getPacoal3());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPanombre() != null) {
			where.append(" AND t5.PANOMBRE = ?");
			params.add(alerta.getPais().getPanombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t6.ESCODIGO = ?");
			params.add(alerta.getEstablecimiento().getEscodigo());
		}
		if (alerta != null
				&& alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getCensoMonitor() != null
				&& alerta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t6.ESCOZS = ?");
			params.add(alerta.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t6.ESNOMBRE = ?");
			params.add(alerta.getEstablecimiento().getEsnombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t6.ESNIF = ?");
			params.add(alerta.getEstablecimiento().getEsnif());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t6.ESNOAN = ?");
			params.add(alerta.getEstablecimiento().getEsnoan());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t6.ESNOCO = ?");
			params.add(alerta.getEstablecimiento().getEsnoco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t6.ESNODIR = ?");
			params.add(alerta.getEstablecimiento().getEsnodir());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t6.ESCOLO = ?");
			params.add(alerta.getEstablecimiento().getEscolo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t6.ESNRCOPO = ?");
			params.add(alerta.getEstablecimiento().getEsnrcopo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t6.ESNRTEL = ?");
			params.add(alerta.getEstablecimiento().getEsnrtel());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t6.ESNRFAX = ?");
			params.add(alerta.getEstablecimiento().getEsnrfax());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t6.ESCOPA = ?");
			params.add(alerta.getEstablecimiento().getEscopa());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t6.ESINCAPR = ?");
			params.add(alerta.getEstablecimiento().getEsincapr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t6.ESINDEMP = ?");
			params.add(alerta.getEstablecimiento().getEsindemp());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t6.ESTECO = ?");
			params.add(alerta.getEstablecimiento().getEsteco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t6.ESINADAR = ?");
			params.add(alerta.getEstablecimiento().getEsinadar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t6.ESFEADAR = ?");
			params.add(alerta.getEstablecimiento().getEsfeadar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t6.ESCOEM = ?");
			params.add(alerta.getEstablecimiento().getEscoem());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t6.ESINEMPR = ?");
			params.add(alerta.getEstablecimiento().getEsinempr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t6.ESNRTEL2 = ?");
			params.add(alerta.getEstablecimiento().getEsnrtel2());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t6.ESFEBA = ?");
			params.add(alerta.getEstablecimiento().getEsfeba());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t6.ESNOAP1 = ?");
			params.add(alerta.getEstablecimiento().getEsnoap1());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t6.ESNOAP2 = ?");
			params.add(alerta.getEstablecimiento().getEsnoap2());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t6.ESNOLO = ?");
			params.add(alerta.getEstablecimiento().getEsnolo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t6.ESCOMAPV = ?");
			params.add(alerta.getEstablecimiento().getEscomapv());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t6.ESCOCA = ?");
			params.add(alerta.getEstablecimiento().getEscoca());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t6.ESNOPECO = ?");
			params.add(alerta.getEstablecimiento().getEsnopeco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t6.ESCOIDCO = ?");
			params.add(alerta.getEstablecimiento().getEscoidco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t6.ESINRECO = ?");
			params.add(alerta.getEstablecimiento().getEsinreco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t6.ESFEMOD = ?");
			params.add(alerta.getEstablecimiento().getEsfemod());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t6.ESINESCO = ?");
			params.add(alerta.getEstablecimiento().getEsinesco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t6.ESNOMU = ?");
			params.add(alerta.getEstablecimiento().getEsnomu());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t6.ESNOREP = ?");
			params.add(alerta.getEstablecimiento().getEsnorep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t6.ESNIFREP = ?");
			params.add(alerta.getEstablecimiento().getEsnifrep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t6.DTTEEMR = ?");
			params.add(alerta.getEstablecimiento().getDtteemr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t6.ESCAREP = ?");
			params.add(alerta.getEstablecimiento().getEscarep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t6.ESTEURL = ?");
			params.add(alerta.getEstablecimiento().getEsteurl());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t6.ESCOOE = ?");
			params.add(alerta.getEstablecimiento().getEscooe());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t6.ESNODECO = ?");
			params.add(alerta.getEstablecimiento().getEsnodeco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t6.ESINTIAR = ?");
			params.add(alerta.getEstablecimiento().getEsintiar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t6.ESFEPLAD = ?");
			params.add(alerta.getEstablecimiento().getEsfeplad());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t6.ESINDEME = ?");
			params.add(alerta.getEstablecimiento().getEsindeme());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t6.ESNORA_PAIS_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPaisId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t6.ESNORA_PAIS_NOMBRE = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t6.ESNORA_PROVINCIA_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t6.ESNOMBRE_PROVINCIA = ?");
			params.add(alerta.getEstablecimiento().getEsnombreProvincia());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t6.ESNORA_MUNICIPIO_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t6.ESNOMBRE_MUNICIPIO = ?");
			params.add(alerta.getEstablecimiento().getEsnombreMunicipio());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t6.ESNORA_LOCALIDAD_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t6.ESNOMBRE_LOCALIDAD = ?");
			params.add(alerta.getEstablecimiento().getEsnombreLocalidad());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t6.ESNORA_CALLE_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraCalleId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t6.ESNOMBRE_CALLE = ?");
			params.add(alerta.getEstablecimiento().getEsnombreCalle());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t6.ESNORA_CP_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraCpId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t6.ESNOMBRE_CP = ?");
			params.add(alerta.getEstablecimiento().getEsnombreCp());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t6.ESNORA_PORTAL_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPortalId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t6.ESNOMBRE_PORTAL = ?");
			params.add(alerta.getEstablecimiento().getEsnombrePortal());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t6.ESNOMBRE_PISO = ?");
			params.add(alerta.getEstablecimiento().getEsnombrePiso());
		}
		if (alerta != null && alerta.getAlcoor() != null) {
			where.append(" AND t1.ALCOOR = ?");
			params.add(alerta.getAlcoor());
		}
		if (alerta != null && alerta.getAlnran() != null) {
			where.append(" AND t1.ALNRAN = ?");
			params.add(alerta.getAlnran());
		}
		if (alerta != null && alerta.getAlnror() != null) {
			where.append(" AND t1.ALNROR = ?");
			params.add(alerta.getAlnror());
		}
		if (alerta != null && alerta.getAlfeen() != null) {
			where.append(" AND t1.ALFEEN = ?");
			params.add(alerta.getAlfeen());
		}
		if (alerta != null && alerta.getAlfeplrr() != null) {
			where.append(" AND t1.ALFEPLRR = ?");
			params.add(alerta.getAlfeplrr());
		}
		if (alerta != null && alerta.getAlnoprse() != null) {
			where.append(" AND t1.ALNOPRSE = ?");
			params.add(alerta.getAlnoprse());
		}
		if (alerta != null && alerta.getAlnrlops() != null) {
			where.append(" AND t1.ALNRLOPS = ?");
			params.add(alerta.getAlnrlops());
		}
		if (alerta != null && alerta.getAlnomaps() != null) {
			where.append(" AND t1.ALNOMAPS = ?");
			params.add(alerta.getAlnomaps());
		}
		if (alerta != null && alerta.getAlnomops() != null) {
			where.append(" AND t1.ALNOMOPS = ?");
			params.add(alerta.getAlnomops());
		}
		if (alerta != null && alerta.getAlfedumi() != null) {
			where.append(" AND t1.ALFEDUMI = ?");
			params.add(alerta.getAlfedumi());
		}
		if (alerta != null && alerta.getAltein() != null) {
			where.append(" AND t1.ALTEIN = ?");
			params.add(alerta.getAltein());
		}
		if (alerta != null && alerta.getAlferrin() != null) {
			where.append(" AND t1.ALFERRIN = ?");
			params.add(alerta.getAlferrin());
		}
		if (alerta != null && alerta.getAlinre() != null) {
			where.append(" AND t1.ALINRE = ?");
			params.add(alerta.getAlinre());
		}
		if (alerta != null && alerta.getAlfecoor() != null) {
			where.append(" AND t1.ALFECOOR = ?");
			params.add(alerta.getAlfecoor());
		}
		if (alerta != null && alerta.getAlcotmo() != null) {
			where.append(" AND t1.ALCOTMO = ?");
			params.add(alerta.getAlcotmo());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Alerta>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Alerta alerta) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ALCOCA= t2.CACODIGO(+) and t1.ALCOPS= t3.PSCODIGO(+) and t1.ALCOTOP= t4.TOPCODIGO(+) and t1.ALCOPA= t5.PACODIGO(+) and t1.ALCOES= t6.ESCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ALERTA t1   ,  COMAUT t2   ,  PRODUCTO t3   ,  ORI_PROD_MUESTRA t4   ,  PAIS t5   ,  ESTABLECIMIENTO t6  ");
		if (alerta != null && alerta.getAlcodigo() != null) {
			where.append(" AND t1.ALCODIGO = ?");
			params.add(alerta.getAlcodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCacodigo() != null) {
			where.append(" AND t2.CACODIGO = ?");
			params.add(alerta.getComaut().getCacodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getPais() != null
				&& alerta.getComaut().getPais().getPacodigo() != null) {
			where.append(" AND t2.CACOPA = ?");
			params.add(alerta.getComaut().getPais().getPacodigo());
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCanombre() != null) {
			where.append(" AND t2.CANOMBRE = ?");
			params.add(alerta.getComaut().getCanombre());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO = ?");
			params.add(alerta.getProducto().getPscodigo());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getProdAgrupado() != null
				&& alerta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t3.PSCOE8 = ?");
			params.add(alerta.getProducto().getProdAgrupado().getE8codigo());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombre() != null) {
			where.append(" AND t3.PSNOMBRE = ?");
			params.add(alerta.getProducto().getPsnombre());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnoco() != null) {
			where.append(" AND t3.PSNOCO = ?");
			params.add(alerta.getProducto().getPsnoco());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescri() != null) {
			where.append(" AND t3.PSDESCRI = ?");
			params.add(alerta.getProducto().getPsdescri());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscose() != null) {
			where.append(" AND t3.PSCOSE = ?");
			params.add(alerta.getProducto().getPscose());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombree() != null) {
			where.append(" AND t3.PSNOMBREE = ?");
			params.add(alerta.getProducto().getPsnombree());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrei() != null) {
			where.append(" AND t3.PSNOMBREI = ?");
			params.add(alerta.getProducto().getPsnombrei());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombref() != null) {
			where.append(" AND t3.PSNOMBREF = ?");
			params.add(alerta.getProducto().getPsnombref());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrea() != null) {
			where.append(" AND t3.PSNOMBREA = ?");
			params.add(alerta.getProducto().getPsnombrea());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoe() != null) {
			where.append(" AND t3.PSNOCOE = ?");
			params.add(alerta.getProducto().getPsnocoe());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoi() != null) {
			where.append(" AND t3.PSNOCOI = ?");
			params.add(alerta.getProducto().getPsnocoi());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocof() != null) {
			where.append(" AND t3.PSNOCOF = ?");
			params.add(alerta.getProducto().getPsnocof());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoa() != null) {
			where.append(" AND t3.PSNOCOA = ?");
			params.add(alerta.getProducto().getPsnocoa());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrie() != null) {
			where.append(" AND t3.PSDESCRIE = ?");
			params.add(alerta.getProducto().getPsdescrie());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrii() != null) {
			where.append(" AND t3.PSDESCRII = ?");
			params.add(alerta.getProducto().getPsdescrii());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrif() != null) {
			where.append(" AND t3.PSDESCRIF = ?");
			params.add(alerta.getProducto().getPsdescrif());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescria() != null) {
			where.append(" AND t3.PSDESCRIA = ?");
			params.add(alerta.getProducto().getPsdescria());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPssel1() != null) {
			where.append(" AND t3.PSSEL1 = ?");
			params.add(alerta.getProducto().getPssel1());
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscoinc() != null) {
			where.append(" AND t3.PSCOINC = ?");
			params.add(alerta.getProducto().getPscoinc());
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t4.TOPCODIGO = ?");
			params.add(alerta.getTipOrigenProd().getTopcodigo());
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopnombre() != null) {
			where.append(" AND t4.TOPNOMBRE = ?");
			params.add(alerta.getTipOrigenProd().getTopnombre());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacodigo() != null) {
			where.append(" AND t5.PACODIGO = ?");
			params.add(alerta.getPais().getPacodigo());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal2() != null) {
			where.append(" AND t5.PACOAL2 = ?");
			params.add(alerta.getPais().getPacoal2());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal3() != null) {
			where.append(" AND t5.PACOAL3 = ?");
			params.add(alerta.getPais().getPacoal3());
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPanombre() != null) {
			where.append(" AND t5.PANOMBRE = ?");
			params.add(alerta.getPais().getPanombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t6.ESCODIGO = ?");
			params.add(alerta.getEstablecimiento().getEscodigo());
		}
		if (alerta != null
				&& alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getCensoMonitor() != null
				&& alerta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND t6.ESCOZS = ?");
			params.add(alerta.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t6.ESNOMBRE = ?");
			params.add(alerta.getEstablecimiento().getEsnombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t6.ESNIF = ?");
			params.add(alerta.getEstablecimiento().getEsnif());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t6.ESNOAN = ?");
			params.add(alerta.getEstablecimiento().getEsnoan());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t6.ESNOCO = ?");
			params.add(alerta.getEstablecimiento().getEsnoco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t6.ESNODIR = ?");
			params.add(alerta.getEstablecimiento().getEsnodir());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t6.ESCOLO = ?");
			params.add(alerta.getEstablecimiento().getEscolo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t6.ESNRCOPO = ?");
			params.add(alerta.getEstablecimiento().getEsnrcopo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t6.ESNRTEL = ?");
			params.add(alerta.getEstablecimiento().getEsnrtel());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t6.ESNRFAX = ?");
			params.add(alerta.getEstablecimiento().getEsnrfax());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t6.ESCOPA = ?");
			params.add(alerta.getEstablecimiento().getEscopa());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t6.ESINCAPR = ?");
			params.add(alerta.getEstablecimiento().getEsincapr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t6.ESINDEMP = ?");
			params.add(alerta.getEstablecimiento().getEsindemp());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t6.ESTECO = ?");
			params.add(alerta.getEstablecimiento().getEsteco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t6.ESINADAR = ?");
			params.add(alerta.getEstablecimiento().getEsinadar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t6.ESFEADAR = ?");
			params.add(alerta.getEstablecimiento().getEsfeadar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t6.ESCOEM = ?");
			params.add(alerta.getEstablecimiento().getEscoem());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t6.ESINEMPR = ?");
			params.add(alerta.getEstablecimiento().getEsinempr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t6.ESNRTEL2 = ?");
			params.add(alerta.getEstablecimiento().getEsnrtel2());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t6.ESFEBA = ?");
			params.add(alerta.getEstablecimiento().getEsfeba());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t6.ESNOAP1 = ?");
			params.add(alerta.getEstablecimiento().getEsnoap1());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t6.ESNOAP2 = ?");
			params.add(alerta.getEstablecimiento().getEsnoap2());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t6.ESNOLO = ?");
			params.add(alerta.getEstablecimiento().getEsnolo());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t6.ESCOMAPV = ?");
			params.add(alerta.getEstablecimiento().getEscomapv());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t6.ESCOCA = ?");
			params.add(alerta.getEstablecimiento().getEscoca());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t6.ESNOPECO = ?");
			params.add(alerta.getEstablecimiento().getEsnopeco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t6.ESCOIDCO = ?");
			params.add(alerta.getEstablecimiento().getEscoidco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t6.ESINRECO = ?");
			params.add(alerta.getEstablecimiento().getEsinreco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t6.ESFEMOD = ?");
			params.add(alerta.getEstablecimiento().getEsfemod());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t6.ESINESCO = ?");
			params.add(alerta.getEstablecimiento().getEsinesco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t6.ESNOMU = ?");
			params.add(alerta.getEstablecimiento().getEsnomu());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t6.ESNOREP = ?");
			params.add(alerta.getEstablecimiento().getEsnorep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t6.ESNIFREP = ?");
			params.add(alerta.getEstablecimiento().getEsnifrep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t6.DTTEEMR = ?");
			params.add(alerta.getEstablecimiento().getDtteemr());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t6.ESCAREP = ?");
			params.add(alerta.getEstablecimiento().getEscarep());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t6.ESTEURL = ?");
			params.add(alerta.getEstablecimiento().getEsteurl());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t6.ESCOOE = ?");
			params.add(alerta.getEstablecimiento().getEscooe());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t6.ESNODECO = ?");
			params.add(alerta.getEstablecimiento().getEsnodeco());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t6.ESINTIAR = ?");
			params.add(alerta.getEstablecimiento().getEsintiar());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t6.ESFEPLAD = ?");
			params.add(alerta.getEstablecimiento().getEsfeplad());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t6.ESINDEME = ?");
			params.add(alerta.getEstablecimiento().getEsindeme());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t6.ESNORA_PAIS_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPaisId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t6.ESNORA_PAIS_NOMBRE = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t6.ESNORA_PROVINCIA_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t6.ESNOMBRE_PROVINCIA = ?");
			params.add(alerta.getEstablecimiento().getEsnombreProvincia());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t6.ESNORA_MUNICIPIO_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t6.ESNOMBRE_MUNICIPIO = ?");
			params.add(alerta.getEstablecimiento().getEsnombreMunicipio());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t6.ESNORA_LOCALIDAD_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t6.ESNOMBRE_LOCALIDAD = ?");
			params.add(alerta.getEstablecimiento().getEsnombreLocalidad());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t6.ESNORA_CALLE_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraCalleId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t6.ESNOMBRE_CALLE = ?");
			params.add(alerta.getEstablecimiento().getEsnombreCalle());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t6.ESNORA_CP_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraCpId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t6.ESNOMBRE_CP = ?");
			params.add(alerta.getEstablecimiento().getEsnombreCp());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t6.ESNORA_PORTAL_ID = ?");
			params.add(alerta.getEstablecimiento().getEsnoraPortalId());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t6.ESNOMBRE_PORTAL = ?");
			params.add(alerta.getEstablecimiento().getEsnombrePortal());
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t6.ESNOMBRE_PISO = ?");
			params.add(alerta.getEstablecimiento().getEsnombrePiso());
		}
		if (alerta != null && alerta.getAlcoor() != null) {
			where.append(" AND t1.ALCOOR = ?");
			params.add(alerta.getAlcoor());
		}
		if (alerta != null && alerta.getAlnran() != null) {
			where.append(" AND t1.ALNRAN = ?");
			params.add(alerta.getAlnran());
		}
		if (alerta != null && alerta.getAlnror() != null) {
			where.append(" AND t1.ALNROR = ?");
			params.add(alerta.getAlnror());
		}
		if (alerta != null && alerta.getAlfeen() != null) {
			where.append(" AND t1.ALFEEN = ?");
			params.add(alerta.getAlfeen());
		}
		if (alerta != null && alerta.getAlfeplrr() != null) {
			where.append(" AND t1.ALFEPLRR = ?");
			params.add(alerta.getAlfeplrr());
		}
		if (alerta != null && alerta.getAlnoprse() != null) {
			where.append(" AND t1.ALNOPRSE = ?");
			params.add(alerta.getAlnoprse());
		}
		if (alerta != null && alerta.getAlnrlops() != null) {
			where.append(" AND t1.ALNRLOPS = ?");
			params.add(alerta.getAlnrlops());
		}
		if (alerta != null && alerta.getAlnomaps() != null) {
			where.append(" AND t1.ALNOMAPS = ?");
			params.add(alerta.getAlnomaps());
		}
		if (alerta != null && alerta.getAlnomops() != null) {
			where.append(" AND t1.ALNOMOPS = ?");
			params.add(alerta.getAlnomops());
		}
		if (alerta != null && alerta.getAlfedumi() != null) {
			where.append(" AND t1.ALFEDUMI = ?");
			params.add(alerta.getAlfedumi());
		}
		if (alerta != null && alerta.getAltein() != null) {
			where.append(" AND t1.ALTEIN = ?");
			params.add(alerta.getAltein());
		}
		if (alerta != null && alerta.getAlferrin() != null) {
			where.append(" AND t1.ALFERRIN = ?");
			params.add(alerta.getAlferrin());
		}
		if (alerta != null && alerta.getAlinre() != null) {
			where.append(" AND t1.ALINRE = ?");
			params.add(alerta.getAlinre());
		}
		if (alerta != null && alerta.getAlfecoor() != null) {
			where.append(" AND t1.ALFECOOR = ?");
			params.add(alerta.getAlfecoor());
		}
		if (alerta != null && alerta.getAlcotmo() != null) {
			where.append(" AND t1.ALCOTMO = ?");
			params.add(alerta.getAlcotmo());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ALCOCA= t2.CACODIGO(+) AND t1.ALCOPS= t3.PSCODIGO(+) AND t1.ALCOTOP= t4.TOPCODIGO(+) AND t1.ALCOPA= t5.PACODIGO(+) AND t1.ALCOES= t6.ESCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ALCODIGO ALCODIGO,t1.ALCOOR ALCOOR,t1.ALNRAN ALNRAN,t1.ALNROR ALNROR,t1.ALFEEN ALFEEN,t1.ALFEPLRR ALFEPLRR,t1.ALNOPRSE ALNOPRSE,t1.ALNRLOPS ALNRLOPS,t1.ALNOMAPS ALNOMAPS,t1.ALNOMOPS ALNOMOPS,t1.ALFEDUMI ALFEDUMI,t1.ALTEIN ALTEIN,t1.ALFERRIN ALFERRIN,t1.ALINRE ALINRE,t1.ALFECOOR ALFECOOR,t1.ALCOTMO ALCOTMO,t2.CACODIGO COMAUTCACODIGO,t2.CANOMBRE COMAUTCANOMBRE,t3.PSCODIGO PRODUCTOPSCODIGO,t3.PSNOMBRE PRODUCTOPSNOMBRE,t3.PSNOCO PRODUCTOPSNOCO,t3.PSDESCRI PRODUCTOPSDESCRI,t3.PSCOSE PRODUCTOPSCOSE,t3.PSNOMBREE PRODUCTOPSNOMBREE,t3.PSNOMBREI PRODUCTOPSNOMBREI,t3.PSNOMBREF PRODUCTOPSNOMBREF,t3.PSNOMBREA PRODUCTOPSNOMBREA,t3.PSNOCOE PRODUCTOPSNOCOE,t3.PSNOCOI PRODUCTOPSNOCOI,t3.PSNOCOF PRODUCTOPSNOCOF,t3.PSNOCOA PRODUCTOPSNOCOA,t3.PSDESCRIE PRODUCTOPSDESCRIE,t3.PSDESCRII PRODUCTOPSDESCRII,t3.PSDESCRIF PRODUCTOPSDESCRIF,t3.PSDESCRIA PRODUCTOPSDESCRIA,t3.PSSEL1 PRODUCTOPSSEL1,t3.PSCOINC PRODUCTOPSCOINC,t4.TOPCODIGO TIPORIGENPRODTOPCODIGO,t4.TOPNOMBRE TIPORIGENPRODTOPNOMBRE,t5.PACODIGO PAISPACODIGO,t5.PACOAL2 PAISPACOAL2,t5.PACOAL3 PAISPACOAL3,t5.PANOMBRE PAISPANOMBRE,t6.ESCODIGO ESTABLEESCODIGO,t6.ESNOMBRE ESTABLEESNOMBRE,t6.ESNIF ESTABLEESNIF,t6.ESNOAN ESTABLEESNOAN,t6.ESNOCO ESTABLEESNOCO,t6.ESNODIR ESTABLEESNODIR,t6.ESCOLO ESTABLEESCOLO,t6.ESNRCOPO ESTABLEESNRCOPO,t6.ESNRTEL ESTABLEESNRTEL,t6.ESNRFAX ESTABLEESNRFAX,t6.ESCOPA ESTABLEESCOPA,t6.ESINCAPR ESTABLEESINCAPR,t6.ESINDEMP ESTABLEESINDEMP,t6.ESTECO ESTABLEESTECO,t6.ESINADAR ESTABLEESINADAR,t6.ESFEADAR ESTABLEESFEADAR,t6.ESCOEM ESTABLEESCOEM,t6.ESINEMPR ESTABLEESINEMPR,t6.ESNRTEL2 ESTABLEESNRTEL2,t6.ESFEBA ESTABLEESFEBA,t6.ESNOAP1 ESTABLEESNOAP1,t6.ESNOAP2 ESTABLEESNOAP2,t6.ESNOLO ESTABLEESNOLO,t6.ESCOMAPV ESTABLEESCOMAPV,t6.ESCOCA ESTABLEESCOCA,t6.ESNOPECO ESTABLEESNOPECO,t6.ESCOIDCO ESTABLEESCOIDCO,t6.ESINRECO ESTABLEESINRECO,t6.ESFEMOD ESTABLEESFEMOD,t6.ESINESCO ESTABLEESINESCO,t6.ESNOMU ESTABLEESNOMU,t6.ESNOREP ESTABLEESNOREP,t6.ESNIFREP ESTABLEESNIFREP,t6.DTTEEMR ESTABLEDTTEEMR,t6.ESCAREP ESTABLEESCAREP,t6.ESTEURL ESTABLEESTEURL,t6.ESCOOE ESTABLEESCOOE,t6.ESNODECO ESTABLEESNODECO,t6.ESINTIAR ESTABLEESINTIAR,t6.ESFEPLAD ESTABLEESFEPLAD,t6.ESINDEME ESTABLEESINDEME,t6.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t6.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t6.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t6.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t6.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t6.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t6.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t6.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t6.ESNORA_CALLE_ID ESTABLEESNORACALLEID,t6.ESNOMBRE_CALLE ESTABLEESNOMBRECALLE,t6.ESNORA_CP_ID ESTABLEESNORACPID,t6.ESNOMBRE_CP ESTABLEESNOMBRECP,t6.ESNORA_PORTAL_ID ESTABLEESNORAPORTALID,t6.ESNOMBRE_PORTAL ESTABLEESNOMBREPORTAL,t6.ESNOMBRE_PISO ESTABLEESNOMBREPISO, t6.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t2.CACOPA COMAUTCACOPA,t3.PSCOE8 PRODUCTOPSCOE8,t6.ESCOZS ESTABLEESCOZS "
						+ "FROM ALERTA t1 ,COMAUT t2 ,PRODUCTO t3 ,ORI_PROD_MUESTRA t4 ,PAIS t5 ,ESTABLECIMIENTO t6 ");

		if (alerta != null && alerta.getAlcodigo() != null) {
			where.append(" AND UPPER(t1.ALCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCacodigo() != null) {
			where.append(" AND t2.CACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getComaut().getCacodigo() + "%");
			} else {
				params.add("%" + alerta.getComaut().getCacodigo() + "%");
			}
			where.append(" AND t2.CACODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getPais() != null
				&& alerta.getComaut().getPais().getPacodigo() != null) {
			where.append(" AND UPPER(t2.CACOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getComaut().getPais().getPacodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getComaut().getPais().getPacodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.CACOPA IS NOT NULL");
		}
		if (alerta != null && alerta.getComaut() != null
				&& alerta.getComaut().getCanombre() != null) {
			where.append(" AND UPPER(t2.CANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getComaut().getCanombre().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getComaut().getCanombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.CANOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscodigo() != null) {
			where.append(" AND t3.PSCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPscodigo() + "%");
			} else {
				params.add("%" + alerta.getProducto().getPscodigo() + "%");
			}
			where.append(" AND t3.PSCODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getProdAgrupado() != null
				&& alerta.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND UPPER(t3.PSCOE8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getProdAgrupado().getE8codigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getProdAgrupado().getE8codigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.PSCOE8 IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombre() != null) {
			where.append(" AND UPPER(t3.PSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnoco() != null) {
			where.append(" AND UPPER(t3.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnoco().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getProducto().getPsnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOCO IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescri() != null) {
			where.append(" AND UPPER(t3.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsdescri().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsdescri().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSDESCRI IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscose() != null) {
			where.append(" AND UPPER(t3.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPscose().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getProducto().getPscose().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSCOSE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombree() != null) {
			where.append(" AND UPPER(t3.PSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnombree().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOMBREE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrei() != null) {
			where.append(" AND UPPER(t3.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnombrei().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOMBREI IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombref() != null) {
			where.append(" AND UPPER(t3.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnombref().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOMBREF IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnombrea() != null) {
			where.append(" AND UPPER(t3.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnombrea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSNOMBREA IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoe() != null) {
			where.append(" AND UPPER(t3.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnocoe().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnocoe().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoi() != null) {
			where.append(" AND UPPER(t3.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnocoi().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnocoi().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOI IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocof() != null) {
			where.append(" AND UPPER(t3.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnocof().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnocof().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOF IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsnocoa() != null) {
			where.append(" AND UPPER(t3.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsnocoa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsnocoa().toUpperCase() + "%");
			}
			where.append(" AND t3.PSNOCOA IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrie() != null) {
			where.append(" AND UPPER(t3.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsdescrie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsdescrie().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSDESCRIE IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrii() != null) {
			where.append(" AND UPPER(t3.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsdescrii().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsdescrii().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSDESCRII IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescrif() != null) {
			where.append(" AND UPPER(t3.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsdescrif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsdescrif().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSDESCRIF IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPsdescria() != null) {
			where.append(" AND UPPER(t3.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPsdescria().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPsdescria().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSDESCRIA IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPssel1() != null) {
			where.append(" AND UPPER(t3.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPssel1().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getProducto().getPssel1().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.PSSEL1 IS NOT NULL");
		}
		if (alerta != null && alerta.getProducto() != null
				&& alerta.getProducto().getPscoinc() != null) {
			where.append(" AND UPPER(t3.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getProducto().getPscoinc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getProducto().getPscoinc().toUpperCase() + "%");
			}
			where.append(" AND t3.PSCOINC IS NOT NULL");
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopcodigo() != null) {
			where.append(" AND t4.TOPCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getTipOrigenProd().getTopcodigo() + "%");
			} else {
				params.add("%" + alerta.getTipOrigenProd().getTopcodigo() + "%");
			}
			where.append(" AND t4.TOPCODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getTipOrigenProd() != null
				&& alerta.getTipOrigenProd().getTopnombre() != null) {
			where.append(" AND UPPER(t4.TOPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getTipOrigenProd().getTopnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getTipOrigenProd().getTopnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.TOPNOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacodigo() != null) {
			where.append(" AND t5.PACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getPais().getPacodigo() + "%");
			} else {
				params.add("%" + alerta.getPais().getPacodigo() + "%");
			}
			where.append(" AND t5.PACODIGO IS NOT NULL");
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal2() != null) {
			where.append(" AND UPPER(t5.PACOAL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getPais().getPacoal2().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getPais().getPacoal2().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.PACOAL2 IS NOT NULL");
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPacoal3() != null) {
			where.append(" AND UPPER(t5.PACOAL3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getPais().getPacoal3().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getPais().getPacoal3().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.PACOAL3 IS NOT NULL");
		}
		if (alerta != null && alerta.getPais() != null
				&& alerta.getPais().getPanombre() != null) {
			where.append(" AND UPPER(t5.PANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getPais().getPanombre().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getPais().getPanombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t5.PANOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t6.ESCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscodigo() + "%");
			} else {
				params.add("%" + alerta.getEstablecimiento().getEscodigo()
						+ "%");
			}
			where.append(" AND t6.ESCODIGO IS NOT NULL");
		}
		if (alerta != null
				&& alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getCensoMonitor() != null
				&& alerta.getEstablecimiento().getCensoMonitor().getMocodigo() != null) {
			where.append(" AND UPPER(t6.ESCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t6.ESCOZS IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t6.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnif().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESNIF IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND UPPER(t6.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoan()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoan().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESNOAN IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND UPPER(t6.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESNOCO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t6.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnodir()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnodir()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNODIR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscolo() != null) {
			where.append(" AND UPPER(t6.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscolo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESCOLO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND UPPER(t6.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnrcopo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnrcopo()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNRCOPO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND UPPER(t6.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnrtel()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnrtel()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNRTEL IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND UPPER(t6.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnrfax()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnrfax()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNRFAX IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscopa() != null) {
			where.append(" AND UPPER(t6.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscopa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscopa().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESCOPA IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND UPPER(t6.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsincapr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsincapr()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINCAPR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND UPPER(t6.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsindemp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsindemp()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINDEMP IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteco() != null) {
			where.append(" AND UPPER(t6.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsteco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsteco().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESTECO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND UPPER(t6.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsinadar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsinadar()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINADAR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t6.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsfeadar() + "%");
			} else {
				params.add("%" + alerta.getEstablecimiento().getEsfeadar()
						+ "%");
			}
			where.append(" AND t6.ESFEADAR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoem() != null) {
			where.append(" AND UPPER(t6.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscoem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscoem().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESCOEM IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND UPPER(t6.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsinempr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsinempr()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINEMPR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND UPPER(t6.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnrtel2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnrtel2()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNRTEL2 IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t6.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsfeba() + "%");
			} else {
				params.add("%" + alerta.getEstablecimiento().getEsfeba() + "%");
			}
			where.append(" AND t6.ESFEBA IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND UPPER(t6.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoap1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoap1()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOAP1 IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND UPPER(t6.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoap2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoap2()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOAP2 IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND UPPER(t6.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnolo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnolo().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESNOLO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND UPPER(t6.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscomapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscomapv()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESCOMAPV IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoca() != null) {
			where.append(" AND UPPER(t6.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscoca()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscoca().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESCOCA IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND UPPER(t6.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnopeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnopeco()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOPECO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND UPPER(t6.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscoidco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscoidco()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESCOIDCO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND UPPER(t6.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsinreco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsinreco()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINRECO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND UPPER(t6.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsfemod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsfemod()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESFEMOD IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND UPPER(t6.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsinesco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsinesco()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINESCO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND UPPER(t6.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnomu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnomu().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESNOMU IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND UPPER(t6.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnorep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnorep()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOREP IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND UPPER(t6.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnifrep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnifrep()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNIFREP IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND UPPER(t6.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getDtteemr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getDtteemr()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.DTTEEMR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscarep() != null) {
			where.append(" AND UPPER(t6.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscarep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscarep()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESCAREP IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND UPPER(t6.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsteurl()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsteurl()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESTEURL IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEscooe() != null) {
			where.append(" AND UPPER(t6.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEscooe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEscooe().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.ESCOOE IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND UPPER(t6.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnodeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnodeco()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNODECO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND UPPER(t6.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsintiar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsintiar()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINTIAR IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t6.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsfeplad() + "%");
			} else {
				params.add("%" + alerta.getEstablecimiento().getEsfeplad()
						+ "%");
			}
			where.append(" AND t6.ESFEPLAD IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND UPPER(t6.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsindeme()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsindeme()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESINDEME IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t6.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t6.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t6.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t6.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t6.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t6.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND UPPER(t6.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_CP_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_CP IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t6.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (alerta != null && alerta.getEstablecimiento() != null
				&& alerta.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND UPPER(t6.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getEstablecimiento().getEsnombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ alerta.getEstablecimiento().getEsnombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t6.ESNOMBRE_PISO IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcoor() != null) {
			where.append(" AND UPPER(t1.ALCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcoor().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcoor().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOOR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnran() != null) {
			where.append(" AND t1.ALNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnran() + "%");
			} else {
				params.add("%" + alerta.getAlnran() + "%");
			}
			where.append(" AND t1.ALNRAN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnror() != null) {
			where.append(" AND UPPER(t1.ALNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnror().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnror().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNROR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfeen() != null) {
			where.append(" AND t1.ALFEEN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlfeen() + "%");
			} else {
				params.add("%" + alerta.getAlfeen() + "%");
			}
			where.append(" AND t1.ALFEEN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfeplrr() != null) {
			where.append(" AND t1.ALFEPLRR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlfeplrr() + "%");
			} else {
				params.add("%" + alerta.getAlfeplrr() + "%");
			}
			where.append(" AND t1.ALFEPLRR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnoprse() != null) {
			where.append(" AND UPPER(t1.ALNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnoprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOPRSE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnrlops() != null) {
			where.append(" AND UPPER(t1.ALNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnrlops().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNRLOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnomaps() != null) {
			where.append(" AND UPPER(t1.ALNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnomaps().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOMAPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlnomops() != null) {
			where.append(" AND UPPER(t1.ALNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlnomops().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlnomops().toUpperCase() + "%");
			}
			where.append(" AND t1.ALNOMOPS IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfedumi() != null) {
			where.append(" AND t1.ALFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlfedumi() + "%");
			} else {
				params.add("%" + alerta.getAlfedumi() + "%");
			}
			where.append(" AND t1.ALFEDUMI IS NOT NULL");
		}
		if (alerta != null && alerta.getAltein() != null) {
			where.append(" AND UPPER(t1.ALTEIN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAltein().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAltein().toUpperCase() + "%");
			}
			where.append(" AND t1.ALTEIN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlferrin() != null) {
			where.append(" AND t1.ALFERRIN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlferrin() + "%");
			} else {
				params.add("%" + alerta.getAlferrin() + "%");
			}
			where.append(" AND t1.ALFERRIN IS NOT NULL");
		}
		if (alerta != null && alerta.getAlinre() != null) {
			where.append(" AND UPPER(t1.ALINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlinre().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlinre().toUpperCase() + "%");
			}
			where.append(" AND t1.ALINRE IS NOT NULL");
		}
		if (alerta != null && alerta.getAlfecoor() != null) {
			where.append(" AND t1.ALFECOOR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlfecoor() + "%");
			} else {
				params.add("%" + alerta.getAlfecoor() + "%");
			}
			where.append(" AND t1.ALFECOOR IS NOT NULL");
		}
		if (alerta != null && alerta.getAlcotmo() != null) {
			where.append(" AND UPPER(t1.ALCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(alerta.getAlcotmo().toUpperCase() + "%");
			} else {
				params.add("%" + alerta.getAlcotmo().toUpperCase() + "%");
			}
			where.append(" AND t1.ALCOTMO IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Alerta>) this.jdbcTemplate.query(query.toString(), rwMap,
				params.toArray());
	}
}
