package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaDetalle;

/**
 * * AlertaDao generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

public interface AlertaDao {

	/**
	 * Inserts a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta add(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta update(Alerta alerta);

	/**
	 * Updates a single row in the Alerta table.
	 * 
	 * @param alertaDetalle
	 *            AlertaDetalle
	 * @return Alerta
	 */
	AlertaDetalle updateEstablecimiento(AlertaDetalle alertaDetalle);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return Alerta
	 */
	Alerta find(Alerta alerta);

	/**
	 * Finds a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Pagination
	 * @return AlertaDetalle
	 */
	AlertaDetalle findAlerta(Alerta alerta);

	/**
	 * Deletes a single row in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return
	 */
	void remove(Alerta alerta);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<AlertaDetalle> findAllAlertaEstablecimiento(Alerta alerta,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Alerta> findAll(Alerta alerta, Pagination pagination);

	/**
	 * Counts rows in the Alerta table.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return List
	 */
	Long findAllCount(Alerta alerta);

	/**
	 * Finds rows in the Alerta table using like.
	 * 
	 * @param alerta
	 *            Alerta
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Alerta> findAllLike(Alerta alerta, Pagination pagination,
			Boolean startsWith);
}
