package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ActuacionBusqueda;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaActuacionBusqueda;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.model.CaracterAlerta;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Inspector;
import com.ejie.y41a.model.PlantillaCartaInspeccionDetalle;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipmotActuacion;
import com.ejie.y41a.model.Tipodoc;

/**
 * * ActuacionDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class ActuacionDaoImpl implements ActuacionDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Actuacion> rwMap = new RowMapper<Actuacion>() {
		public Actuacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Actuacion(
					resultSet.getString("ATCODIGO"),
					resultSet.getBigDecimal("ATNROR"),
					resultSet.getString("ATCOAV"),
					resultSet.getString("ATCOSE"),
					resultSet.getString("ATNOPRSE"),
					resultSet.getString("ATNOMAPS"),
					resultSet.getString("ATNOMOPS"),
					resultSet.getString("ATNRLOPS"),
					resultSet.getDate("ATFEDUMI"),
					resultSet.getString("ATINPRSE"),
					resultSet.getBigDecimal("ATCAUNEP"),
					null,
					resultSet.getString("ATCOAT"),
					new TipProtocolo(resultSet
							.getString("TipProtocoloTPCODIGO"), resultSet
							.getString("TipProtocoloTPNOMBRE"), resultSet
							.getString("TipProtocoloTPCOTMO"), new Campanha(
							resultSet.getString("TipProtocoloTPCOCM"), null,
							null, null, null, null, null, null, null)),
					new Acta(resultSet.getString("ActaACCODIGO"), resultSet
							.getString("ActaACCOOR"), resultSet
							.getString("ActaACNROR"), resultSet
							.getBigDecimal("ActaACNRAN"), resultSet
							.getDate("ActaACFELE"), resultSet
							.getDate("ActaACFERE"), resultSet
							.getString("ActaACCOAV"), resultSet
							.getString("ActaACCOSE"), resultSet
							.getDate("ActaACFEEX"), resultSet
							.getString("ActaACINRE"), resultSet
							.getString("ActaACNOCO"), resultSet
							.getString("ActaACAPE1CO"), resultSet
							.getString("ActaACAPE2CO"), resultSet
							.getString("ActaACDNICO"), resultSet
							.getString("ActaACCOCO"), resultSet
							.getString("ActaACDIRCO"), resultSet
							.getString("ActaACCOLOCO"), resultSet
							.getString("ActaACNRCPCO"), resultSet
							.getString("ActaACNRTFCO"), resultSet
							.getString("ActaACNORAPAISID"), resultSet
							.getString("ActaACNORAPAISNOMBRE"), resultSet
							.getString("ActaACNORAPROVINCIAID"), resultSet
							.getString("ActaACNOMBREPROVINCIA"), resultSet
							.getString("ActaACNORAMUNICIPIOID"), resultSet
							.getString("ActaACNOMBREMUNICIPIO"), resultSet
							.getString("ActaACNORALOCALIDADID"), resultSet
							.getString("ActaACNOMBRELOCALIDAD"), resultSet
							.getString("ActaACNORACALLEID"), resultSet
							.getString("ActaACNOMBRECALLE"), resultSet
							.getString("ActaACNORACPID"), resultSet
							.getString("ActaACNOMBRECP"), resultSet
							.getString("ActaACNORAPORTALID"), resultSet
							.getString("ActaACNOMBREPORTAL"), resultSet
							.getString("ActaACNOMBREPISO"), resultSet
							.getString("ActaACDIRECCIONNOCAPV"), new Inspector(
							resultSet.getString("ActaACCOINDO"), null, null,
							null, null),
							new Inspector(resultSet.getString("ActaACCOINUN"),
									null, null, null, null), new Tipodoc(
									resultSet.getString("ActaACCOTD"), null,
									null), new Establecimiento(resultSet
									.getString("ActaACCOES"), null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null)),
					new CampahnaRecib(resultSet.getString("S4CODIGO"),
							resultSet.getString("S4CODORGANISMO"), resultSet
									.getDate("S4FECCOMUNICACION"), resultSet
									.getDate("S4FECFINALIZACION"), resultSet
									.getInt("S4CANTIDADACTUACIONES"),
							new Campanha(resultSet.getString("S4CODCAMPANHA"),
									null, null, null, null, null, null, null,
									null)),
					new Establecimiento(
							resultSet.getString("EstablecimientoESCODIGO"),
							resultSet.getString("EstablecimientoESNOMBRE"),
							resultSet.getString("EstablecimientoESNIF"),
							resultSet.getString("EstablecimientoESNOAN"),
							resultSet.getString("EstablecimientoESNOCO"),
							resultSet.getString("EstablecimientoESNODIR"),
							resultSet.getString("EstablecimientoESCOLO"),
							resultSet.getString("EstablecimientoESNRCOPO"),
							resultSet.getString("EstablecimientoESNRTEL"),
							resultSet.getString("EstablecimientoESNRFAX"),
							resultSet.getString("EstablecimientoESCOPA"),
							resultSet.getString("EstablecimientoESINCAPR"),
							resultSet.getString("EstablecimientoESINDEMP"),
							resultSet.getString("EstablecimientoESTECO"),
							resultSet.getString("EstablecimientoESINADAR"),
							resultSet.getDate("EstablecimientoESFEADAR"),
							resultSet.getString("EstablecimientoESCOEM"),
							resultSet.getString("EstablecimientoESINEMPR"),
							resultSet.getString("EstablecimientoESNRTEL2"),
							resultSet.getDate("EstablecimientoESFEBA"),
							resultSet.getString("EstablecimientoESNOAP1"),
							resultSet.getString("EstablecimientoESNOAP2"),
							resultSet.getString("EstablecimientoESNOLO"),
							resultSet.getString("EstablecimientoESCOMAPV"),
							resultSet.getString("EstablecimientoESCOCA"),
							resultSet.getString("EstablecimientoESNOPECO"),
							resultSet.getString("EstablecimientoESCOIDCO"),
							resultSet.getString("EstablecimientoESINRECO"),
							resultSet.getString("EstablecimientoESFEMOD"),
							resultSet.getString("EstablecimientoESINESCO"),
							resultSet.getString("EstablecimientoESNOMU"),
							resultSet.getString("EstablecimientoESNOREP"),
							resultSet.getString("EstablecimientoESNIFREP"),
							resultSet.getString("EstablecimientoDTTEEMR"),
							resultSet.getString("EstablecimientoESCAREP"),
							resultSet.getString("EstablecimientoESTEURL"),
							resultSet.getString("EstablecimientoESCOOE"),
							resultSet.getString("EstablecimientoESNODECO"),
							resultSet.getString("EstablecimientoESINTIAR"),
							resultSet.getDate("EstablecimientoESFEPLAD"),
							resultSet.getString("EstablecimientoESINDEME"),
							resultSet.getString("ESTABLEESNORAPAISID"),
							resultSet.getString("ESTABLEESNORAPAISNOMBRE"),
							resultSet.getString("ESTABLEESNORAPROVINCIAID"),
							resultSet.getString("ESTABLEESNOMBREPROVINCIA"),
							resultSet.getString("ESTABLEESNORAMUNICIPIOID"),
							resultSet.getString("ESTABLEESNOMBREMUNICIPIO"),
							resultSet.getString("ESTABLEESNORALOCALIDADID"),
							resultSet.getString("ESTABLEESNOMBRELOCALIDAD"),
							resultSet.getString("EstablecimientoESNORACALLEID"),
							resultSet.getString("EstablecimientoESNOMBRECALLE"),
							resultSet.getString("EstablecimientoESNORACPID"),
							resultSet.getString("EstablecimientoESNOMBRECP"),
							resultSet
									.getString("EstablecimientoESNORAPORTALID"),
							resultSet
									.getString("EstablecimientoESNOMBREPORTAL"),
							resultSet.getString("EstablecimientoESNOMBREPISO"),
							resultSet.getString("EstableESDIRECCION_NOCAPV"),
							resultSet.getString("EstableESEXTRANJERO"), null,
							new CensoMonitor(resultSet
									.getString("EstablecimientoESCOZS"), null,
									null, null, null, null, null, null, null,
									null, null, null)), new Producto(
							resultSet.getString("ProductoPSCODIGO"),
							resultSet.getString("ProductoPSNOMBRE"),
							resultSet.getString("ProductoPSNOCO"),
							resultSet.getString("ProductoPSDESCRI"),
							resultSet.getString("ProductoPSCOSE"),
							resultSet.getString("ProductoPSNOMBREE"),
							resultSet.getString("ProductoPSNOMBREI"),
							resultSet.getString("ProductoPSNOMBREF"),
							resultSet.getString("ProductoPSNOMBREA"),
							resultSet.getString("ProductoPSNOCOE"),
							resultSet.getString("ProductoPSNOCOI"),
							resultSet.getString("ProductoPSNOCOF"),
							resultSet.getString("ProductoPSNOCOA"),
							resultSet.getString("ProductoPSDESCRIE"),
							resultSet.getString("ProductoPSDESCRII"),
							resultSet.getString("ProductoPSDESCRIF"),
							resultSet.getString("ProductoPSDESCRIA"),
							resultSet.getString("ProductoPSSEL1"),
							resultSet.getString("ProductoPSCOINC"),
							new ProdAgrupado(resultSet
									.getString("ProductoPSCOE8"), null, null,
									null)), new DenunciaRecib(
							resultSet.getString("S6CODIGO"),
							resultSet.getString("S6CODORGANISMO"),
							resultSet.getDate("S6FECCOMUNICACION"),
							resultSet.getDate("S6FECFINALIZACION"),
							resultSet.getInt("S6CANTIDADACTUACIONES"),
							new HechoDenunciado(resultSet
									.getString("S6CODHECDEN"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null)), new AlertaRecib(
							resultSet.getString("S5CODIGO"),
							resultSet.getString("S5CODORGANISMO"),
							resultSet.getDate("S5FECCOMUNICACION"),
							resultSet.getDate("S5FECFINALIZACION"),
							resultSet.getInt("S5CANTIDADACTUACIONES"),
							new Alerta(resultSet.getString("S5CODALERTA"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null), new CaracterAlerta(
									resultSet.getString("S5CARACTERALERTA"),
									null, null, null, null, null, null, null,
									null)), new TipActuacion(
							resultSet.getString("TipActuacionTTACODIGO"),
							resultSet.getString("TipActuacionTTANOMBRE")),
					new TipmotActuacion(resultSet
							.getString("TipmotActuacionTMACODIGO"), resultSet
							.getString("TipmotActuacionTMANOMBRE")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion add(Actuacion actuacion) {

		String query = "INSERT INTO ACTUACION( ATCODIGO,ATCOTP,ATCOAC,ATCOCM,ATCOES,ATCOPS,ATCOHD,ATCOAL,ATCOTTA,ATCOTMA,ATNROR,ATCOAV,ATCOSE,ATNOPRSE,ATNOMAPS,ATNOMOPS,ATNRLOPS,ATFEDUMI,ATINPRSE,ATCAUNEP,ATTEINFO,ATCOAT)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		Object getTipProtocoloTpcodigoAux = null;
		if (actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = actuacion.getTipProtocolo()
					.getTpcodigo();
		}
		Object getActaAccodigoAux = null;
		if (actuacion.getActa() != null
				&& actuacion.getActa().getAccodigo() != null) {
			getActaAccodigoAux = actuacion.getActa().getAccodigo();
		}
		Object getCampahnaRecibS4codigoAux = null;
		if (actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			getCampahnaRecibS4codigoAux = actuacion.getCampahnaRecib()
					.getS4codigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = actuacion.getEstablecimiento()
					.getEscodigo();
		}
		Object getProductoPscodigoAux = null;
		if (actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = actuacion.getProducto().getPscodigo();
		}
		Object getDenunciaRecibS6codigoAux = null;
		if (actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			getDenunciaRecibS6codigoAux = actuacion.getDenunciaRecib()
					.getS6codigo();
		}
		Object getAlertaRecibS5codigoAux = null;
		if (actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			getAlertaRecibS5codigoAux = actuacion.getAlertaRecib()
					.getS5codigo();
		}
		Object getTipActuacionTtacodigoAux = null;
		if (actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			getTipActuacionTtacodigoAux = actuacion.getTipActuacion()
					.getTtacodigo();
		}
		Object getTipmotActuacionTmacodigoAux = null;
		if (actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			getTipmotActuacionTmacodigoAux = actuacion.getTipmotActuacion()
					.getTmacodigo();
		}
		this.jdbcTemplate.update(query, actuacion.getAtcodigo(),
				getTipProtocoloTpcodigoAux, getActaAccodigoAux,
				getCampahnaRecibS4codigoAux, getEstablecimientoEscodigoAux,
				getProductoPscodigoAux, getDenunciaRecibS6codigoAux,
				getAlertaRecibS5codigoAux, getTipActuacionTtacodigoAux,
				getTipmotActuacionTmacodigoAux, actuacion.getAtnror(),
				actuacion.getAtcoav(), actuacion.getAtcose(),
				actuacion.getAtnoprse(), actuacion.getAtnomaps(),
				actuacion.getAtnomops(), actuacion.getAtnrlops(),
				actuacion.getAtfedumi(), actuacion.getAtinprse(),
				actuacion.getAtcaunep(), actuacion.getAtteinfo(),
				actuacion.getAtcoat());
		return actuacion;
	}

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion addActuacion(Actuacion actuacion) {

		String query = "INSERT INTO ACTUACION( ATCODIGO,ATCOTP,ATCOAC,ATCOCM,ATCOES,ATCOPS,ATCOHD,ATCOAL,ATCOTTA,ATCOTMA,ATNROR,ATCOAV,ATCOSE,ATNOPRSE,ATNOMAPS,ATNOMOPS,ATNRLOPS,ATFEDUMI,ATINPRSE,ATCAUNEP,ATTEINFO,ATCOAT)"
				+ "VALUES (?,?,?,?,?,?,?,?,?,?,(SELECT NVL(MAX(ABS(ATNROR)),0)+1 FROM ACTUACION WHERE ATCOAC =?),?,?,?,?,?,?,?,?,?,?,?)";

		Object getTipProtocoloTpcodigoAux = null;
		if (actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = actuacion.getTipProtocolo()
					.getTpcodigo();
		}
		Object getActaAccodigoAux = null;
		if (actuacion.getActa() != null
				&& actuacion.getActa().getAccodigo() != null) {
			getActaAccodigoAux = actuacion.getActa().getAccodigo();
		}
		Object getCampahnaRecibS4codigoAux = null;
		if (actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			getCampahnaRecibS4codigoAux = actuacion.getCampahnaRecib()
					.getS4codigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = actuacion.getEstablecimiento()
					.getEscodigo();
		}
		Object getProductoPscodigoAux = null;
		if (actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = actuacion.getProducto().getPscodigo();
		}
		Object getDenunciaRecibS6codigoAux = null;
		if (actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			getDenunciaRecibS6codigoAux = actuacion.getDenunciaRecib()
					.getS6codigo();
		}
		Object getAlertaRecibS5codigoAux = null;
		if (actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			getAlertaRecibS5codigoAux = actuacion.getAlertaRecib()
					.getS5codigo();
		}
		Object getTipActuacionTtacodigoAux = null;
		if (actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			getTipActuacionTtacodigoAux = actuacion.getTipActuacion()
					.getTtacodigo();
		}
		Object getTipmotActuacionTmacodigoAux = null;
		if (actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			getTipmotActuacionTmacodigoAux = actuacion.getTipmotActuacion()
					.getTmacodigo();
		}
		this.jdbcTemplate.update(query, actuacion.getAtcodigo(),
				getTipProtocoloTpcodigoAux, getActaAccodigoAux,
				getCampahnaRecibS4codigoAux, getEstablecimientoEscodigoAux,
				getProductoPscodigoAux, getDenunciaRecibS6codigoAux,
				getAlertaRecibS5codigoAux, getTipActuacionTtacodigoAux,
				getTipmotActuacionTmacodigoAux, getActaAccodigoAux,
				actuacion.getAtcoav(), actuacion.getAtcose(),
				actuacion.getAtnoprse(), actuacion.getAtnomaps(),
				actuacion.getAtnomops(), actuacion.getAtnrlops(),
				actuacion.getAtfedumi(), actuacion.getAtinprse(),
				actuacion.getAtcaunep(), actuacion.getAtteinfo(),
				actuacion.getAtcoat());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion update(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOTP=?,ATCOCM=?,ATCOES=?,ATCOPS=?,ATCOHD=?,ATCOAL=?,ATCOTTA=?,ATCOTMA=?,ATCOAV=?,ATCOSE=?,ATNOPRSE=?,ATNOMAPS=?,ATNOMOPS=?,ATNRLOPS=?,ATFEDUMI=?,ATINPRSE=?,ATCAUNEP=?,ATTEINFO=?,ATCOAT=? WHERE ATCODIGO=?";
		Object getTipProtocoloTpcodigoAux = null;
		if (actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = actuacion.getTipProtocolo()
					.getTpcodigo();
		}
		Object getCampahnaRecibS4codigoAux = null;
		if (actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			getCampahnaRecibS4codigoAux = actuacion.getCampahnaRecib()
					.getS4codigo();
		}
		Object getEstablecimientoEscodigoAux = null;
		if (actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = actuacion.getEstablecimiento()
					.getEscodigo();
		}
		Object getProductoPscodigoAux = null;
		if (actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			getProductoPscodigoAux = actuacion.getProducto().getPscodigo();
		}
		Object getDenunciaRecibS6codigoAux = null;
		if (actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			getDenunciaRecibS6codigoAux = actuacion.getDenunciaRecib()
					.getS6codigo();
		}
		Object getAlertaRecibS5codigoAux = null;
		if (actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			getAlertaRecibS5codigoAux = actuacion.getAlertaRecib()
					.getS5codigo();
		}
		Object getTipActuacionTtacodigoAux = null;
		if (actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			getTipActuacionTtacodigoAux = actuacion.getTipActuacion()
					.getTtacodigo();
		}
		Object getTipmotActuacionTmacodigoAux = null;
		if (actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			getTipmotActuacionTmacodigoAux = actuacion.getTipmotActuacion()
					.getTmacodigo();
		}
		this.jdbcTemplate.update(query, getTipProtocoloTpcodigoAux,
				getCampahnaRecibS4codigoAux, getEstablecimientoEscodigoAux,
				getProductoPscodigoAux, getDenunciaRecibS6codigoAux,
				getAlertaRecibS5codigoAux, getTipActuacionTtacodigoAux,
				getTipmotActuacionTmacodigoAux, actuacion.getAtcoav(),
				actuacion.getAtcose(), actuacion.getAtnoprse(),
				actuacion.getAtnomaps(), actuacion.getAtnomops(),
				actuacion.getAtnrlops(), actuacion.getAtfedumi(),
				actuacion.getAtinprse(), actuacion.getAtcaunep(),
				actuacion.getAtteinfo(), actuacion.getAtcoat(),
				actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateEstablecimiento(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOES=? WHERE ATCODIGO=?";

		Object getEstablecimientoEscodigoAux = null;
		if (actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			getEstablecimientoEscodigoAux = actuacion.getEstablecimiento()
					.getEscodigo();
		}

		this.jdbcTemplate.update(query, getEstablecimientoEscodigoAux,
				actuacion.getAtcodigo());

		return actuacion;
	}

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	public Actuacion updateTipoProtocoloActuacion(Actuacion actuacion) {
		String query = "UPDATE ACTUACION SET ATCOTP=? WHERE ATCODIGO=?";
		Object getTipProtocoloTpcodigoAux = null;
		if (actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			getTipProtocoloTpcodigoAux = actuacion.getTipProtocolo()
					.getTpcodigo();
		}

		this.jdbcTemplate.update(query, getTipProtocoloTpcodigoAux,
				actuacion.getAtcodigo());
		return actuacion;
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	@Transactional(readOnly = true)
	public Actuacion find(Actuacion actuacion) {
		String query = "SELECT t1.ATCODIGO ATCODIGO, t1.ATNROR ATNROR, t1.ATCOAV ATCOAV, t1.ATCOSE ATCOSE, t1.ATNOPRSE ATNOPRSE, t1.ATNOMAPS ATNOMAPS, t1.ATNOMOPS ATNOMOPS, t1.ATNRLOPS ATNRLOPS, t1.ATFEDUMI ATFEDUMI, t1.ATINPRSE ATINPRSE, t1.ATCAUNEP ATCAUNEP, t1.ATTEINFO ATTEINFO, t1.ATCOAT ATCOAT, t2.TPCODIGO TIPPROTOCOLOTPCODIGO, t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE, t2.TPCOTMO TIPPROTOCOLOTPCOTMO, t3.ACCODIGO ACTAACCODIGO, t3.ACCOOR ACTAACCOOR, t3.ACNROR ACTAACNROR, t3.ACNRAN ACTAACNRAN, t3.ACFELE ACTAACFELE, t3.ACFERE ACTAACFERE, t3.ACCOAV ACTAACCOAV, t3.ACCOSE ACTAACCOSE, t3.ACFEEX ACTAACFEEX, t3.ACINRE ACTAACINRE, t3.ACNOCO ACTAACNOCO, t3.ACAPE1CO ACTAACAPE1CO,t3.ACAPE2CO ACTAACAPE2CO, t3.ACDNICO ACTAACDNICO, t3.ACCOCO ACTAACCOCO, t3.ACDIRCO ACTAACDIRCO, t3.ACCOLOCO ACTAACCOLOCO, t3.ACNRCPCO ACTAACNRCPCO, t3.ACNRTFCO ACTAACNRTFCO, t3.ACNORA_PAIS_ID ACTAACNORAPAISID, t3.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE, t3.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID, t3.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA, t3.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID, t3.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO, t3.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID, t3.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD, t3.ACNORA_CALLE_ID ACTAACNORACALLEID, t3.ACNOMBRE_CALLE ACTAACNOMBRECALLE, t3.ACNORA_CP_ID ACTAACNORACPID, t3.ACNOMBRE_CP ACTAACNOMBRECP, t3.ACNORA_PORTAL_ID ACTAACNORAPORTALID, t3.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL, t3.ACNOMBRE_PISO ACTAACNOMBREPISO, t3.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV, t4.S4CODIGO S4CODIGO, t4.S4CODORGANISMO S4CODORGANISMO, t4.S4FECCOMUNICACION S4FECCOMUNICACION, t4.S4FECFINALIZACION S4FECFINALIZACION, t4.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES, t5.ESCODIGO ESTABLECIMIENTOESCODIGO, t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE, t5.ESNIF ESTABLECIMIENTOESNIF, t5.ESNOAN ESTABLECIMIENTOESNOAN, t5.ESNOCO ESTABLECIMIENTOESNOCO, t5.ESNODIR ESTABLECIMIENTOESNODIR, t5.ESCOLO ESTABLECIMIENTOESCOLO, t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO, t5.ESNRTEL ESTABLECIMIENTOESNRTEL, t5.ESNRFAX ESTABLECIMIENTOESNRFAX, t5.ESCOPA ESTABLECIMIENTOESCOPA, t5.ESINCAPR ESTABLECIMIENTOESINCAPR, t5.ESINDEMP ESTABLECIMIENTOESINDEMP, t5.ESTECO ESTABLECIMIENTOESTECO, t5.ESINADAR ESTABLECIMIENTOESINADAR, t5.ESFEADAR ESTABLECIMIENTOESFEADAR, t5.ESCOEM ESTABLECIMIENTOESCOEM, t5.ESINEMPR ESTABLECIMIENTOESINEMPR, t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2, t5.ESFEBA ESTABLECIMIENTOESFEBA, t5.ESNOAP1 ESTABLECIMIENTOESNOAP1, t5.ESNOAP2 ESTABLECIMIENTOESNOAP2, t5.ESNOLO ESTABLECIMIENTOESNOLO, t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV, t5.ESCOCA ESTABLECIMIENTOESCOCA, t5.ESNOPECO ESTABLECIMIENTOESNOPECO, t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO, t5.ESINRECO ESTABLECIMIENTOESINRECO, t5.ESFEMOD ESTABLECIMIENTOESFEMOD, t5.ESINESCO ESTABLECIMIENTOESINESCO, t5.ESNOMU ESTABLECIMIENTOESNOMU, t5.ESNOREP ESTABLECIMIENTOESNOREP, t5.ESNIFREP ESTABLECIMIENTOESNIFREP, t5.DTTEEMR ESTABLECIMIENTODTTEEMR, t5.ESCAREP ESTABLECIMIENTOESCAREP, t5.ESTEURL ESTABLECIMIENTOESTEURL, t5.ESCOOE ESTABLECIMIENTOESCOOE, t5.ESNODECO ESTABLECIMIENTOESNODECO, t5.ESINTIAR ESTABLECIMIENTOESINTIAR, t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD, t5.ESINDEME ESTABLECIMIENTOESINDEME, t5.ESNORA_PAIS_ID ESTABLEESNORAPAISID, t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE, t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID, t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA, t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID, t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO, t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID, t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD, t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID, t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE, t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID, t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP, t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID, t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL, t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO, t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t5.ESEXTRANJERO EstableESEXTRANJERO, t6.PSCODIGO PRODUCTOPSCODIGO, t6.PSNOMBRE PRODUCTOPSNOMBRE, t6.PSNOCO PRODUCTOPSNOCO, t6.PSDESCRI PRODUCTOPSDESCRI, t6.PSCOSE PRODUCTOPSCOSE, t6.PSNOMBREE PRODUCTOPSNOMBREE, t6.PSNOMBREI PRODUCTOPSNOMBREI, t6.PSNOMBREF PRODUCTOPSNOMBREF, t6.PSNOMBREA PRODUCTOPSNOMBREA, t6.PSNOCOE PRODUCTOPSNOCOE, t6.PSNOCOI PRODUCTOPSNOCOI, t6.PSNOCOF PRODUCTOPSNOCOF, t6.PSNOCOA PRODUCTOPSNOCOA, t6.PSDESCRIE PRODUCTOPSDESCRIE, t6.PSDESCRII PRODUCTOPSDESCRII, t6.PSDESCRIF PRODUCTOPSDESCRIF, t6.PSDESCRIA PRODUCTOPSDESCRIA, t6.PSSEL1 PRODUCTOPSSEL1, t6.PSCOINC PRODUCTOPSCOINC, t7.S6CODIGO S6CODIGO, t7.S6CODORGANISMO S6CODORGANISMO, t7.S6FECCOMUNICACION S6FECCOMUNICACION, t7.S6FECFINALIZACION S6FECFINALIZACION, t7.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES, t8.S5CODIGO S5CODIGO, t8.S5CODORGANISMO S5CODORGANISMO, t8.S5FECCOMUNICACION S5FECCOMUNICACION, t8.S5FECFINALIZACION S5FECFINALIZACION, t8.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES, t9.TTACODIGO TIPACTUACIONTTACODIGO, t9.TTANOMBRE TIPACTUACIONTTANOMBRE, t10.TMACODIGO TIPMOTACTUACIONTMACODIGO, t10.TMANOMBRE TIPMOTACTUACIONTMANOMBRE, t2.TPCOCM TIPPROTOCOLOTPCOCM, t3.ACCOINDO ACTAACCOINDO, t3.ACCOINUN ACTAACCOINUN, t3.ACCOTD ACTAACCOTD, t3.ACCOES ACTAACCOES, t4.S4CODCAMPANHA S4CODCAMPANHA, t5.ESCOZS ESTABLECIMIENTOESCOZS, t6.PSCOE8 PRODUCTOPSCOE8, t7.S6CODHECDEN S6CODHECDEN, t8.S5CODALERTA S5CODALERTA, t8.S5CARACTERALERTA S5CARACTERALERTA "
				+ "FROM ACTUACION t1 , TIP_PROTOCOLO t2 , ACTA t3 , CAMPAHNA_RECIB t4 , ESTABLECIMIENTO t5 , PRODUCTO t6 , DENUNCIA_RECIB t7 , ALERTA_RECIB t8 , TIP_ACTUACION t9 , TIPMOT_ACTUACION t10  "
				+ "WHERE t1.ATCODIGO = ?   AND t1.ATCOTP= t2.TPCODIGO(+) AND t1.ATCOAC= t3.ACCODIGO(+) AND t1.ATCOCM= t4.S4CODIGO(+) AND t1.ATCOES= t5.ESCODIGO(+) AND t1.ATCOPS= t6.PSCODIGO(+) AND t1.ATCOHD= t7.S6CODIGO(+) AND t1.ATCOAL= t8.S5CODIGO(+) AND t1.ATCOTTA= t9.TTACODIGO(+) AND t1.ATCOTMA= t10.TMACODIGO(+)  ";
		return (Actuacion) this.jdbcTemplate.queryForObject(query, rwMap,
				actuacion.getAtcodigo());
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	@Transactional(readOnly = true)
	public ActaActuacionAlta findActuacion(Actuacion actuacion) {
		String query = "SELECT t2.ACCODIGO ACCODIGO, t2.ACCOOR ACCOOR, t2.ACNROR ACNROR, t2.ACNRAN ACNRAN, t2.ACFELE ACFELE, t2.ACFERE ACFERE, t2.ACCOINUN ACCOINUN, t2.ACCOINDO ACCOINDO, t4.TDCODIGO TDCODIGO, t4.TDNOMBRE TDNOMBRE, t2.ACNOCO ACNOCO, t2.ACAPE1CO ACAPE1CO, t2.ACAPE2CO ACAPE2CO,t2.ACDNICO ACDNICO, t2.ACCOCO ACCOCO, t2.ACDIRCO ACDIRCO, t2.ACCOLOCO ACCOLOCO, t2.ACNRCPCO ACNRCPCO, t2.ACNRTFCO ACNRTFCO, t2.ACNORA_PAIS_ID ACNORAPAISID,t2.ACNORA_PAIS_NOMBRE ACNORAPAISNOMBRE,t2.ACNORA_PROVINCIA_ID ACNORAPROVINCIAID,t2.ACNOMBRE_PROVINCIA ACNOMBREPROVINCIA,t2.ACNORA_MUNICIPIO_ID ACNORAMUNICIPIOID,t2.ACNOMBRE_MUNICIPIO ACNOMBREMUNICIPIO,t2.ACNORA_LOCALIDAD_ID ACNORALOCALIDADID,t2.ACNOMBRE_LOCALIDAD ACNOMBRELOCALIDAD,t2.ACNORA_CALLE_ID ACNORACALLEID,t2.ACNOMBRE_CALLE ACNOMBRECALLE,t2.ACNORA_CP_ID ACNORACPID,t2.ACNOMBRE_CP ACNOMBRECP,t2.ACNORA_PORTAL_ID ACNORAPORTALID,t2.ACNOMBRE_PORTAL ACNOMBREPORTAL,t2.ACNOMBRE_PISO ACNOMBREPISO, t2.ACDIRECCION_NOCAPV ACDIRECCIONNOCAPV, t5actuacion.ESCODIGO ESCODIGOACTUACION, t5actuacion.ESNOMBRE ESNOMBREACTUACION, t5actuacion.ESNIF ESNIFACTUACION, t5actuacion.ESNOCO ESNOCOACTUACION, t5actuacion.ESNODIR ESNODIRACTUACION, t5actuacion.ESCOLO ESCOLOACTUACION, t5actuacion.ESNRCOPO ESNRCOPOACTUACION, t5actuacion.ESNRTEL ESNRTELACTUACION, t5actuacion.ESNRFAX ESNRFAXACTUACION, t5actuacion.ESCOPA ESCOPAACTUACION, t5actuacion.ESINADAR ESINADARACTUACION, t5actuacion.ESFEADAR ESFEADARACTUACION, t5actuacion.ESCOEM ESCOEMACTUACION, t5actuacion.ESNRTEL2 ESNRTEL2ACTUACION, t5actuacion.ESFEBA ESFEBAACTUACION, t5actuacion.ESNOLO ESNOLOACTUACION, t5actuacion.ESCOMAPV ESCOMAPVACTUACION, t5actuacion.ESCOCA ESCOCAACTUACION, t5actuacion.ESNOMU ESNOMUACTUACION, t5actuacion.ESTEURL ESTEURLACTUACION, t5actuacion.ESNORA_PAIS_ID ESNORAPAISIDACTUACION, t5actuacion.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBREACTUACION, t5actuacion.ESNORA_PROVINCIA_ID ESNORAPROVINCIAIDACTUACION, t5actuacion.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIAACTUACION, t5actuacion.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOIDACTUACION, t5actuacion.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIOACTUACION, t5actuacion.ESNORA_LOCALIDAD_ID ESNORALOCALIDADIDACTUACION, t5actuacion.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDADACTUACION, t5actuacion.ESNORA_CALLE_ID ESNORACALLEIDACTUACION, t5actuacion.ESNOMBRE_CALLE ESNOMBRECALLEACTUACION, t5actuacion.ESNORA_CP_ID ESNORACPIDACTUACION, t5actuacion.ESNOMBRE_CP ESNOMBRECPACTUACION, t5actuacion.ESNORA_PORTAL_ID ESNORAPORTALIDACTUACION, t5actuacion.ESNOMBRE_PORTAL ESNOMBREPORTALACTUACION, t5actuacion.ESNOMBRE_PISO ESNOMBREPISOACTUACION, t5actuacion.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPVACTUACION, t6actuacion.EACODIGO EACODIGOACTUACION, t7actuacion.AVCODIGO AVCODIGOACTUACION, t7actuacion.AVNOMBRE AVNOMBREACTUACION, t7actuacion.AVNOMBREE AVNOMBREEACTUACION, t8actuacion.SECODIGO SECODIGOACTUACION, t8actuacion.SENOMBRE SENOMBREACTUACION, t8actuacion.SENOMBREE SENOMBREEACTUACION, t6actuacion.EAINPRSE EAINPRSEACTUACION, t5visita.ESCODIGO ESCODIGOVISITA, t5visita.ESNOMBRE ESNOMBREVISITA, t5visita.ESNIF ESNIFVISITA, t5visita.ESNOCO ESNOCOVISITA, t5visita.ESNODIR ESNODIRVISITA, t5visita.ESCOLO ESCOLOVISITA, t5visita.ESNRCOPO ESNRCOPOVISITA, t5visita.ESNRTEL ESNRTELVISITA, t5visita.ESNRFAX ESNRFAXVISITA, t5visita.ESCOPA ESCOPAVISITA, t5visita.ESINADAR ESINADARVISITA, t5visita.ESFEADAR ESFEADARVISITA, t5visita.ESCOEM ESCOEMVISITA, t5visita.ESNRTEL2 ESNRTEL2VISITA, t5visita.ESFEBA ESFEBAVISITA, t5visita.ESNOLO ESNOLOVISITA, t5visita.ESCOMAPV ESCOMAPVVISITA, t5visita.ESCOCA ESCOCAVISITA, t5visita.ESNOMU ESNOMUVISITA, t5visita.ESTEURL ESTEURLVISITA, t5visita.ESNORA_PAIS_ID ESNORAPAISIDVISITA, t5visita.ESNORA_PAIS_NOMBRE ESNORAPAISNOMBREVISITA, t5visita.ESNORA_PROVINCIA_ID ESNORAPROVINCIAIDVISITA, t5visita.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIAVISITA, t5visita.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOIDVISITA, t5visita.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIOVISITA, t5visita.ESNORA_LOCALIDAD_ID ESNORALOCALIDADIDVISITA, t5visita.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDADVISITA, t5visita.ESNORA_CALLE_ID ESNORACALLEIDVISITA, t5visita.ESNOMBRE_CALLE ESNOMBRECALLEVISITA, t5visita.ESNORA_CP_ID ESNORACPIDVISITA, t5visita.ESNOMBRE_CP ESNOMBRECPVISITA, t5visita.ESNORA_PORTAL_ID ESNORAPORTALIDVISITA, t5visita.ESNOMBRE_PORTAL ESNOMBREPORTALVISITA, t5visita.ESNOMBRE_PISO ESNOMBREPISOVISITA, t5visita.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPVVISITA, t6visita.EACODIGO EACODIGOVISITA, t7visita.AVCODIGO AVCODIGOVISITA, t7visita.AVNOMBRE AVNOMBREVISITA, t7visita.AVNOMBREE AVNOMBREEVISITA, t8visita.SECODIGO SECODIGOVISITA, t8visita.SENOMBRE SENOMBREVISITA, t8visita.SENOMBREE SENOMBREEVISITA, t6visita.EAINPRSE EAINPRSEVISITA, t3.ATCODIGO ATCODIGO, t3.ATNROR ATNROR, t9.TTACODIGO TTACODIGO,t9.TTANOMBRE TTANOMBRE, t10.TMACODIGO TMACODIGO,t10.TMANOMBRE TMANOMBRE, t11.PSCODIGO PSCODIGO,t11.PSNOMBRE PSNOMBRE, t11.PSNOMBREE PSNOMBREE, t3.ATNOPRSE ATNOPRSE,t3.ATNOMAPS ATNOMAPS,t3.ATNOMOPS ATNOMOPS,t3.ATNRLOPS ATNRLOPS,t3.ATFEDUMI ATFEDUMI, t3.ATINPRSE ATINPRSE,t3.ATCAUNEP ATCAUNEP,t3.ATCOCM ATCOCM, t3.ATCOHD ATCOHD, t3.ATCOAL ATCOAL, t3.ATCOTP ATCOTP, t3.ATTEINFO ATTEINFO "
				+ "FROM ACTA t2, ACTUACION t3,TIPODOC t4, ESTABLECIMIENTO t5actuacion, ESTABLECIMIENTO t5visita, ESTABLECIM_SECTOR t6visita, ESTABLECIM_SECTOR t6actuacion, ACTIVIDAD t7visita , ACTIVIDAD t7actuacion , SECTOR t8visita, SECTOR t8actuacion, TIP_ACTUACION t9 ,TIPMOT_ACTUACION t10, PRODUCTO t11 "
				+ "WHERE t3.ATCODIGO = ? AND t3.ATCOAC = t2.ACCODIGO AND t2.ACCOTD= t4.TDCODIGO AND t3.ATCOES= t5actuacion.ESCODIGO AND t2.ACCOES= t5visita.ESCODIGO AND t5visita.ESCODIGO= t6visita.EACOES (+) AND t5actuacion.ESCODIGO= t6actuacion.EACOES (+)	AND t5actuacion.ESCODIGO=t6actuacion.EACOES (+)	AND t6actuacion.EACOAV= t7actuacion.AVCODIGO (+) AND t6actuacion.EACOSE= t8actuacion.SECODIGO (+) AND ? = t6actuacion.EAINPRSE (+) AND t5visita.ESCODIGO=t6visita.EACOES (+) AND t6visita.EACOAV= t7visita.AVCODIGO (+)	AND t6visita.EACOSE= t8visita.SECODIGO (+) AND ? = t6visita.EAINPRSE (+) AND t3.ATCOTTA= t9.TTACODIGO(+) AND t3.ATCOTMA= t10.TMACODIGO(+) AND t3.ATCOPS= t11.PSCODIGO(+)";

		return (ActaActuacionAlta) this.jdbcTemplate.queryForObject(
				query,
				new RowMapper<ActaActuacionAlta>() {
					public ActaActuacionAlta mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new ActaActuacionAlta(
								null,
								null,
								null,
								resultSet.getString("ACCODIGO"),
								resultSet.getString("ACCOOR"),
								resultSet.getString("ACNROR"),
								resultSet.getBigDecimal("ACNRAN"),
								resultSet.getDate("ACFELE"),
								resultSet.getDate("ACFERE"),
								resultSet.getString("ACCOINUN"),
								resultSet.getString("ACCOINDO"),
								resultSet.getString("TDCODIGO"),
								resultSet.getString("TDNOMBRE"),
								resultSet.getString("ACNOCO"),
								resultSet.getString("ACAPE1CO"),
								resultSet.getString("ACAPE2CO"),
								resultSet.getString("ACDNICO"),
								resultSet.getString("ACCOCO"),
								resultSet.getString("ACDIRCO"),
								resultSet.getString("ACCOLOCO"),
								resultSet.getString("ACNRCPCO"),
								resultSet.getString("ACNRTFCO"),
								resultSet.getString("ACNORAPAISID"),
								resultSet.getString("ACNORAPAISNOMBRE"),
								resultSet.getString("ACNORAPROVINCIAID"),
								resultSet.getString("ACNOMBREPROVINCIA"),
								resultSet.getString("ACNORAMUNICIPIOID"),
								resultSet.getString("ACNOMBREMUNICIPIO"),
								resultSet.getString("ACNORALOCALIDADID"),
								resultSet.getString("ACNOMBRELOCALIDAD"),
								resultSet.getString("ACNORACALLEID"),
								resultSet.getString("ACNOMBRECALLE"),
								resultSet.getString("ACNORACPID"),
								resultSet.getString("ACNOMBRECP"),
								resultSet.getString("ACNORAPORTALID"),
								resultSet.getString("ACNOMBREPORTAL"),
								resultSet.getString("ACNOMBREPISO"),
								resultSet.getString("ACDIRECCIONNOCAPV"),
								null,
								resultSet.getString("ESCODIGOVISITA"),
								resultSet.getString("ESNOMBREVISITA"),
								resultSet.getString("ESNIFVISITA"),
								resultSet.getString("ESNOCOVISITA"),
								resultSet.getString("ESNODIRVISITA"),
								resultSet.getString("ESCOLOVISITA"),
								resultSet.getString("ESNRCOPOVISITA"),
								resultSet.getString("ESNRTELVISITA"),
								resultSet.getString("ESNRFAXVISITA"),
								resultSet.getString("ESCOPAVISITA"),
								resultSet.getString("ESINADARVISITA"),
								resultSet.getDate("ESFEADARVISITA"),
								resultSet.getString("ESCOEMVISITA"),
								resultSet.getString("ESNRTEL2VISITA"),
								resultSet.getDate("ESFEBAVISITA"),
								resultSet.getString("ESNOLOVISITA"),
								resultSet.getString("ESCOMAPVVISITA"),
								resultSet.getString("ESCOCAVISITA"),
								resultSet.getString("ESNOMUVISITA"),
								resultSet.getString("ESTEURLVISITA"),
								resultSet.getString("ESNORAPAISIDVISITA"),
								resultSet.getString("ESNORAPAISNOMBREVISITA"),
								resultSet.getString("ESNORAPROVINCIAIDVISITA"),
								resultSet.getString("ESNOMBREPROVINCIAVISITA"),
								resultSet.getString("ESNORAMUNICIPIOIDVISITA"),
								resultSet.getString("ESNOMBREMUNICIPIOVISITA"),
								resultSet.getString("ESNORALOCALIDADIDVISITA"),
								resultSet.getString("ESNOMBRELOCALIDADVISITA"),
								resultSet.getString("ESNORACALLEIDVISITA"),
								resultSet.getString("ESNOMBRECALLEVISITA"),
								resultSet.getString("ESNORACPIDVISITA"),
								resultSet.getString("ESNOMBRECPVISITA"),
								resultSet.getString("ESNORAPORTALIDVISITA"),
								resultSet.getString("ESNOMBREPORTALVISITA"),
								resultSet.getString("ESNOMBREPISOVISITA"),
								resultSet.getString("ESDIRECCION_NOCAPVVISITA"),
								resultSet.getString("EACODIGOVISITA"),
								resultSet.getString("AVCODIGOVISITA"),
								resultSet.getString("AVNOMBREVISITA"),
								resultSet.getString("AVNOMBREEVISITA"),
								resultSet.getString("SECODIGOVISITA"),
								resultSet.getString("SENOMBREVISITA"),
								resultSet.getString("SENOMBREEVISITA"),
								resultSet.getString("EAINPRSEVISITA"),
								null,
								resultSet.getString("ATCODIGO"),
								resultSet.getBigDecimal("ATNROR"),
								resultSet.getString("ATCOTP"),
								resultSet.getString("ATTEINFO"),
								resultSet.getString("TTACODIGO"),
								resultSet.getString("TTANOMBRE"),
								resultSet.getString("TMACODIGO"),
								resultSet.getString("TMANOMBRE"),
								resultSet.getString("ESCODIGOACTUACION"),
								resultSet.getString("ESNOMBREACTUACION"),
								resultSet.getString("ESNIFACTUACION"),
								resultSet.getString("ESNOCOACTUACION"),
								resultSet.getString("ESNODIRACTUACION"),
								resultSet.getString("ESCOLOACTUACION"),
								resultSet.getString("ESNRCOPOACTUACION"),
								resultSet.getString("ESNRTELACTUACION"),
								resultSet.getString("ESNRFAXACTUACION"),
								resultSet.getString("ESCOPAACTUACION"),
								resultSet.getString("ESINADARACTUACION"),
								resultSet.getDate("ESFEADARACTUACION"),
								resultSet.getString("ESCOEMACTUACION"),
								resultSet.getString("ESNRTEL2ACTUACION"),
								resultSet.getDate("ESFEBAACTUACION"),
								resultSet.getString("ESNOLOACTUACION"),
								resultSet.getString("ESCOMAPVACTUACION"),
								resultSet.getString("ESCOCAACTUACION"),
								resultSet.getString("ESNOMUACTUACION"),
								resultSet.getString("ESTEURLACTUACION"),
								resultSet.getString("ESNORAPAISIDACTUACION"),
								resultSet
										.getString("ESNORAPAISNOMBREACTUACION"),
								resultSet
										.getString("ESNORAPROVINCIAIDACTUACION"),
								resultSet
										.getString("ESNOMBREPROVINCIAACTUACION"),
								resultSet
										.getString("ESNORAMUNICIPIOIDACTUACION"),
								resultSet
										.getString("ESNOMBREMUNICIPIOACTUACION"),
								resultSet
										.getString("ESNORALOCALIDADIDACTUACION"),
								resultSet
										.getString("ESNOMBRELOCALIDADACTUACION"),
								resultSet.getString("ESNORACALLEIDACTUACION"),
								resultSet.getString("ESNOMBRECALLEACTUACION"),
								resultSet.getString("ESNORACPIDACTUACION"),
								resultSet.getString("ESNOMBRECPACTUACION"),
								resultSet.getString("ESNORAPORTALIDACTUACION"),
								resultSet.getString("ESNOMBREPORTALACTUACION"),
								resultSet.getString("ESNOMBREPISOACTUACION"),
								resultSet
										.getString("ESDIRECCION_NOCAPVACTUACION"),
								resultSet.getString("EACODIGOACTUACION"),
								resultSet.getString("AVCODIGOACTUACION"),
								resultSet.getString("AVNOMBREACTUACION"),
								resultSet.getString("AVNOMBREEACTUACION"),
								resultSet.getString("SECODIGOACTUACION"),
								resultSet.getString("SENOMBREACTUACION"),
								resultSet.getString("SENOMBREEACTUACION"),
								resultSet.getString("EAINPRSEACTUACION"), null,
								resultSet.getString("PSCODIGO"), resultSet
										.getString("PSNOMBRE"), resultSet
										.getString("PSNOMBREE"), resultSet
										.getString("ATNOPRSE"), resultSet
										.getString("ATNOMAPS"), resultSet
										.getString("ATNOMOPS"), resultSet
										.getString("ATNRLOPS"), resultSet
										.getDate("ATFEDUMI"), resultSet
										.getString("ATCOCM"), resultSet
										.getString("ATCOAL"), resultSet
										.getString("ATCOHD"), resultSet
										.getString("ATINPRSE"), resultSet
										.getBigDecimal("ATCAUNEP"));
					}
				}, actuacion.getAtcodigo(),
				Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO,
				Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
	}

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param plantillaCartaInspeccionDetalle
	 *            PlantillaCartaInspeccionDetalle
	 * @return PlantillaCartaInspeccionDetalle
	 */
	@Transactional(readOnly = true)
	public PlantillaCartaInspeccionDetalle findPlantillaCartaInspeccion(
			PlantillaCartaInspeccionDetalle plantillaCartaInspeccionDetalle) {
		String query = "SELECT t1.ACCODIGO ACCODIGO, t1.ACCOOR ACCOOR, t1.ACNROR ACNROR, t1.ACNRAN ACNRAN, t1.ACFELE ACFELE, t2.ATCODIGO ATCODIGO, t2.ATNROR ATNROR, t3actuacion.ESCODIGO ESCODIGOACTUACION, t3actuacion.ESNOMBRE ESNOMBREACTUACION, t3actuacion.ESNIF ESNIFACTUACION, t3actuacion.ESNOCO ESNOCOACTUACION, t3actuacion.ESNORA_PROVINCIA_ID ESNORAPROVINCIAIDACTUACION, t3actuacion.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIAACTUACION, t3actuacion.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOIDACTUACION, t3actuacion.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIOACTUACION, t3actuacion.ESNORA_LOCALIDAD_ID ESNORALOCALIDADIDACTUACION, t3actuacion.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDADACTUACION, t3actuacion.ESNORA_CALLE_ID ESNORACALLEIDACTUACION, t3actuacion.ESNOMBRE_CALLE ESNOMBRECALLEACTUACION, t3actuacion.ESNORA_CP_ID ESNORACPIDACTUACION, t3actuacion.ESNOMBRE_CP ESNOMBRECPACTUACION, t3actuacion.ESNORA_PORTAL_ID ESNORAPORTALIDACTUACION, t3actuacion.ESNOMBRE_PORTAL ESNOMBREPORTALACTUACION, t3actuacion.ESNOMBRE_PISO ESNOMBREPISOACTUACION, t3actuacion.ESNOLO ESNOLOACTUACION, t3actuacion.ESNODIR ESNODIRACTUACION, t3actuacion.ESNRCOPO ESNRCOPOACTUACION, t3actuacion.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPVACTUACION, t3visita.ESCODIGO ESCODIGOVISITA, t3visita.ESNOMBRE ESNOMBREVISITA, t3visita.ESNIF ESNIFVISITA, t3visita.ESNOCO ESNOCOVISITA, t3visita.ESNORA_PROVINCIA_ID ESNORAPROVINCIAIDVISITA, t3visita.ESNOMBRE_PROVINCIA ESNOMBREPROVINCIAVISITA, t3visita.ESNORA_MUNICIPIO_ID ESNORAMUNICIPIOIDVISITA, t3visita.ESNOMBRE_MUNICIPIO ESNOMBREMUNICIPIOVISITA, t3visita.ESNORA_LOCALIDAD_ID ESNORALOCALIDADIDVISITA, t3visita.ESNOMBRE_LOCALIDAD ESNOMBRELOCALIDADVISITA, t3visita.ESNORA_CALLE_ID ESNORACALLEIDVISITA, t3visita.ESNOMBRE_CALLE ESNOMBRECALLEVISITA, t3visita.ESNORA_CP_ID ESNORACPIDVISITA, t3visita.ESNOMBRE_CP ESNOMBRECPVISITA, t3visita.ESNORA_PORTAL_ID ESNORAPORTALIDVISITA, t3visita.ESNOMBRE_PORTAL ESNOMBREPORTALVISITA, t3visita.ESNOMBRE_PISO ESNOMBREPISOVISITA, t3actuacion.ESNOLO ESNOLOVISITA, t3actuacion.ESNODIR ESNODIRVISITA, t3actuacion.ESNRCOPO ESNRCOPOVISITA, t3visita.ESDIRECCION_NOCAPV ESDIRECCION_NOCAPVVISITA, t4.TMACODIGO TMACODIGO,t4.TMANOMBRE TMANOMBRE, t5.PSCODIGO PSCODIGO,t5.PSNOMBRE PSNOMBRE, t5.PSNOMBREE PSNOMBREE, t2.ATNOPRSE ATNOPRSE,t2.ATNOMAPS ATNOMAPS,t2.ATNOMOPS ATNOMOPS,t2.ATNRLOPS ATNRLOPS, t6.COD_ORG CODORG, t6.NOMBRE_ES NOMBREES, t6.NOMBRE_EU NOMBREEU,  t6.NORA_PROVINCIA_ID NORAPROVINCIAID, t6.NOMBRE_PROVINCIA NOMBREPROVINCIA, t6.NORA_MUNICIPIO_ID NORAMUNICIPIOID, t6.NOMBRE_MUNICIPIO NOMBREMUNICIPIO, t6.NORA_LOCALIDAD_ID NORALOCALIDADID, t6.NOMBRE_LOCALIDAD NOMBRELOCALIDAD, t6.NORA_CALLE_ID NORACALLEID, t6.NOMBRE_CALLE NOMBRECALLE, t6.NORA_CP_ID NORACPID, t6.NOMBRE_CP NOMBRECP, t6.NORA_PORTAL_ID NORAPORTALID, t6.NOMBRE_PORTAL NOMBREPORTAL "
				+ "FROM ACTA t1, ACTUACION t2, ESTABLECIMIENTO t3actuacion, ESTABLECIMIENTO t3visita,TIPMOT_ACTUACION t4, PRODUCTO t5, ORGANISMO t6 "
				+ "WHERE t1.ACCODIGO = t2.ATCOAC AND t2.ATCOES= t3actuacion.ESCODIGO AND t1.ACCOES= t3visita.ESCODIGO AND t2.ATCOTMA= t4.TMACODIGO(+) AND t2.ATCOPS= t5.PSCODIGO(+) AND t1.ACCOOR = t6.COD_ORG(+) AND t2.ATCODIGO = ? ";

		return (PlantillaCartaInspeccionDetalle) this.jdbcTemplate
				.queryForObject(query,
						new RowMapper<PlantillaCartaInspeccionDetalle>() {
							public PlantillaCartaInspeccionDetalle mapRow(
									ResultSet resultSet, int rowNum)
									throws SQLException {
								return new PlantillaCartaInspeccionDetalle(
										null,
										resultSet.getString("ACCODIGO"),
										resultSet.getString("ACCOOR"),
										resultSet.getString("ACNROR"),
										resultSet.getBigDecimal("ACNRAN"),
										resultSet.getDate("ACFELE"),
										null,
										null,
										resultSet.getString("ATCODIGO"),
										resultSet.getBigDecimal("ATNROR"),
										null,
										resultSet.getString("ESCODIGOVISITA"),
										resultSet.getString("ESNOMBREVISITA"),
										resultSet.getString("ESNIFVISITA"),
										resultSet.getString("ESNOCOVISITA"),
										resultSet
												.getString("ESNORAPROVINCIAIDVISITA"),
										resultSet
												.getString("ESNOMBREPROVINCIAVISITA"),
										resultSet
												.getString("ESNORAMUNICIPIOIDVISITA"),
										resultSet
												.getString("ESNOMBREMUNICIPIOVISITA"),
										resultSet
												.getString("ESNORALOCALIDADIDVISITA"),
										resultSet
												.getString("ESNOMBRELOCALIDADVISITA"),
										resultSet
												.getString("ESNORACALLEIDVISITA"),
										resultSet
												.getString("ESNOMBRECALLEVISITA"),
										resultSet.getString("ESNORACPIDVISITA"),
										resultSet.getString("ESNOMBRECPVISITA"),
										resultSet
												.getString("ESNORAPORTALIDVISITA"),
										resultSet
												.getString("ESNOMBREPORTALVISITA"),
										resultSet
												.getString("ESNOMBREPISOVISITA"),
										resultSet.getString("ESNOLOVISITA"),
										resultSet.getString("ESNODIRVISITA"),
										resultSet.getString("ESNRCOPOVISITA"),
										resultSet
												.getString("ESDIRECCION_NOCAPVVISITA"),
										null,
										null,
										resultSet
												.getString("ESCODIGOACTUACION"),
										resultSet
												.getString("ESNOMBREACTUACION"),
										resultSet.getString("ESNIFACTUACION"),
										resultSet.getString("ESNOCOACTUACION"),
										resultSet
												.getString("ESNORAPROVINCIAIDACTUACION"),
										resultSet
												.getString("ESNOMBREPROVINCIAACTUACION"),
										resultSet
												.getString("ESNORAMUNICIPIOIDACTUACION"),
										resultSet
												.getString("ESNOMBREMUNICIPIOACTUACION"),
										resultSet
												.getString("ESNORALOCALIDADIDACTUACION"),
										resultSet
												.getString("ESNOMBRELOCALIDADACTUACION"),
										resultSet
												.getString("ESNORACALLEIDACTUACION"),
										resultSet
												.getString("ESNOMBRECALLEACTUACION"),
										resultSet
												.getString("ESNORACPIDACTUACION"),
										resultSet
												.getString("ESNOMBRECPACTUACION"),
										resultSet
												.getString("ESNORAPORTALIDACTUACION"),
										resultSet
												.getString("ESNOMBREPORTALACTUACION"),
										resultSet
												.getString("ESNOMBREPISOACTUACION"),
										resultSet.getString("ESNOLOACTUACION"),
										resultSet.getString("ESNODIRACTUACION"),
										resultSet
												.getString("ESNRCOPOACTUACION"),
										resultSet
												.getString("ESDIRECCION_NOCAPVACTUACION"),
										null, null, resultSet
												.getString("PSCODIGO"),
										resultSet.getString("PSNOMBRE"),
										resultSet.getString("PSNOMBREE"),
										resultSet.getString("ATNOPRSE"),
										resultSet.getString("ATNOMAPS"),
										resultSet.getString("ATNOMOPS"),
										resultSet.getString("ATNRLOPS"),
										resultSet.getString("TMACODIGO"),
										resultSet.getString("TMANOMBRE"),
										resultSet.getString("CODORG"),
										resultSet.getString("NOMBREES"),
										resultSet.getString("NOMBREEU"),
										resultSet.getString("NORAPROVINCIAID"),
										resultSet.getString("NOMBREPROVINCIA"),
										resultSet.getString("NORAMUNICIPIOID"),
										resultSet.getString("NOMBREMUNICIPIO"),
										resultSet.getString("NORALOCALIDADID"),
										resultSet.getString("NOMBRELOCALIDAD"),
										resultSet.getString("NORACALLEID"),
										resultSet.getString("NOMBRECALLE"),
										resultSet.getString("NORACPID"),
										resultSet.getString("NOMBRECP"),
										resultSet.getString("NORAPORTALID"),
										resultSet.getString("NOMBREPORTAL"),
										null, null, null, null);
							}
						}, plantillaCartaInspeccionDetalle.getAtcodigo());
	}

	/**
	 * Removes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return
	 */
	public void remove(Actuacion actuacion) {
		String query = "DELETE  FROM ACTUACION WHERE ATCODIGO=?";
		this.jdbcTemplate.update(query, actuacion.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAllActuacionEstablecimiento(Actuacion actuacion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ATCOES= t2.ESCODIGO(+)");

		StringBuffer query = new StringBuffer("SELECT  t1.ATCODIGO ATCODIGO "
				+ "FROM ACTUACION t1 ,ESTABLECIMIENTO t2 ");

		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ESCODIGO = ?");
			params.add(actuacion.getEstablecimiento().getEscodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				new RowMapper<Actuacion>() {
					public Actuacion mapRow(ResultSet resultSet, int rowNum)
							throws SQLException {
						return new Actuacion(resultSet.getString("ATCODIGO"),
								null, null, null, null, null, null, null, null,
								null, null, null, null, null, null, null,
								new Establecimiento(), null, null, null, null,
								null);
					}
				}, params.toArray());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAll(Actuacion actuacion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ATCOTP= t2.TPCODIGO(+) AND t1.ATCOAC= t3.ACCODIGO(+) AND t1.ATCOCM= t4.S4CODIGO(+) AND t1.ATCOES= t5.ESCODIGO(+) AND t1.ATCOPS= t6.PSCODIGO(+) AND t1.ATCOHD= t7.S6CODIGO(+) AND t1.ATCOAL= t8.S5CODIGO(+) AND t1.ATCOTTA= t9.TTACODIGO(+) AND t1.ATCOTMA= t10.TMACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ATCODIGO ATCODIGO,t1.ATNROR ATNROR,t1.ATCOAV ATCOAV,t1.ATCOSE ATCOSE,t1.ATNOPRSE ATNOPRSE,t1.ATNOMAPS ATNOMAPS,t1.ATNOMOPS ATNOMOPS,t1.ATNRLOPS ATNRLOPS,t1.ATFEDUMI ATFEDUMI,t1.ATINPRSE ATINPRSE,t1.ATCAUNEP ATCAUNEP,t1.ATCOAT ATCOAT,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.ACCODIGO ACTAACCODIGO,t3.ACCOOR ACTAACCOOR,t3.ACNROR ACTAACNROR,t3.ACNRAN ACTAACNRAN,t3.ACFELE ACTAACFELE,t3.ACFERE ACTAACFERE,t3.ACCOAV ACTAACCOAV,t3.ACCOSE ACTAACCOSE,t3.ACFEEX ACTAACFEEX,t3.ACINRE ACTAACINRE,t3.ACNOCO ACTAACNOCO,t3.ACAPE1CO ACTAACAPE1CO,t3.ACAPE2CO ACTAACAPE2CO,t3.ACDNICO ACTAACDNICO,t3.ACCOCO ACTAACCOCO,t3.ACDIRCO ACTAACDIRCO,t3.ACCOLOCO ACTAACCOLOCO,t3.ACNRCPCO ACTAACNRCPCO,t3.ACNRTFCO ACTAACNRTFCO,t3.ACNORA_PAIS_ID ACTAACNORAPAISID,t3.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t3.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t3.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t3.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t3.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t3.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t3.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t3.ACNORA_CALLE_ID ACTAACNORACALLEID,t3.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t3.ACNORA_CP_ID ACTAACNORACPID,t3.ACNOMBRE_CP ACTAACNOMBRECP,t3.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t3.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t3.ACNOMBRE_PISO ACTAACNOMBREPISO, t3.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV,t4.S4CODIGO S4CODIGO,t4.S4CODORGANISMO S4CODORGANISMO,t4.S4FECCOMUNICACION S4FECCOMUNICACION,t4.S4FECFINALIZACION S4FECFINALIZACION,t4.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES,t5.ESCODIGO ESTABLECIMIENTOESCODIGO,t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE,t5.ESNIF ESTABLECIMIENTOESNIF,t5.ESNOAN ESTABLECIMIENTOESNOAN,t5.ESNOCO ESTABLECIMIENTOESNOCO,t5.ESNODIR ESTABLECIMIENTOESNODIR,t5.ESCOLO ESTABLECIMIENTOESCOLO,t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t5.ESNRTEL ESTABLECIMIENTOESNRTEL,t5.ESNRFAX ESTABLECIMIENTOESNRFAX,t5.ESCOPA ESTABLECIMIENTOESCOPA,t5.ESINCAPR ESTABLECIMIENTOESINCAPR,t5.ESINDEMP ESTABLECIMIENTOESINDEMP,t5.ESTECO ESTABLECIMIENTOESTECO,t5.ESINADAR ESTABLECIMIENTOESINADAR,t5.ESFEADAR ESTABLECIMIENTOESFEADAR,t5.ESCOEM ESTABLECIMIENTOESCOEM,t5.ESINEMPR ESTABLECIMIENTOESINEMPR,t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t5.ESFEBA ESTABLECIMIENTOESFEBA,t5.ESNOAP1 ESTABLECIMIENTOESNOAP1,t5.ESNOAP2 ESTABLECIMIENTOESNOAP2,t5.ESNOLO ESTABLECIMIENTOESNOLO,t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t5.ESCOCA ESTABLECIMIENTOESCOCA,t5.ESNOPECO ESTABLECIMIENTOESNOPECO,t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t5.ESINRECO ESTABLECIMIENTOESINRECO,t5.ESFEMOD ESTABLECIMIENTOESFEMOD,t5.ESINESCO ESTABLECIMIENTOESINESCO,t5.ESNOMU ESTABLECIMIENTOESNOMU,t5.ESNOREP ESTABLECIMIENTOESNOREP,t5.ESNIFREP ESTABLECIMIENTOESNIFREP,t5.DTTEEMR ESTABLECIMIENTODTTEEMR,t5.ESCAREP ESTABLECIMIENTOESCAREP,t5.ESTEURL ESTABLECIMIENTOESTEURL,t5.ESCOOE ESTABLECIMIENTOESCOOE,t5.ESNODECO ESTABLECIMIENTOESNODECO,t5.ESINTIAR ESTABLECIMIENTOESINTIAR,t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t5.ESINDEME ESTABLECIMIENTOESINDEME,t5.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID,t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE,t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID,t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP,t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID,t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL,t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO,t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV,t5.ESEXTRANJERO EstableESEXTRANJERO,t6.PSCODIGO PRODUCTOPSCODIGO,t6.PSNOMBRE PRODUCTOPSNOMBRE,t6.PSNOCO PRODUCTOPSNOCO,t6.PSDESCRI PRODUCTOPSDESCRI,t6.PSCOSE PRODUCTOPSCOSE,t6.PSNOMBREE PRODUCTOPSNOMBREE,t6.PSNOMBREI PRODUCTOPSNOMBREI,t6.PSNOMBREF PRODUCTOPSNOMBREF,t6.PSNOMBREA PRODUCTOPSNOMBREA,t6.PSNOCOE PRODUCTOPSNOCOE,t6.PSNOCOI PRODUCTOPSNOCOI,t6.PSNOCOF PRODUCTOPSNOCOF,t6.PSNOCOA PRODUCTOPSNOCOA,t6.PSDESCRIE PRODUCTOPSDESCRIE,t6.PSDESCRII PRODUCTOPSDESCRII,t6.PSDESCRIF PRODUCTOPSDESCRIF,t6.PSDESCRIA PRODUCTOPSDESCRIA,t6.PSSEL1 PRODUCTOPSSEL1,t6.PSCOINC PRODUCTOPSCOINC,t7.S6CODIGO S6CODIGO,t7.S6CODORGANISMO S6CODORGANISMO,t7.S6FECCOMUNICACION S6FECCOMUNICACION,t7.S6FECFINALIZACION S6FECFINALIZACION,t7.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES,t8.S5CODIGO S5CODIGO,t8.S5CODORGANISMO S5CODORGANISMO,t8.S5FECCOMUNICACION S5FECCOMUNICACION,t8.S5FECFINALIZACION S5FECFINALIZACION,t8.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES,t9.TTACODIGO TIPACTUACIONTTACODIGO,t9.TTANOMBRE TIPACTUACIONTTANOMBRE,t10.TMACODIGO TIPMOTACTUACIONTMACODIGO,t10.TMANOMBRE TIPMOTACTUACIONTMANOMBRE,t2.TPCOCM TIPPROTOCOLOTPCOCM,t3.ACCOINDO ACTAACCOINDO,t3.ACCOINUN ACTAACCOINUN,t3.ACCOTD ACTAACCOTD,t3.ACCOES ACTAACCOES,t4.S4CODCAMPANHA S4CODCAMPANHA,t5.ESCOZS ESTABLECIMIENTOESCOZS,t6.PSCOE8 PRODUCTOPSCOE8,t7.S6CODHECDEN S6CODHECDEN,t8.S5CODALERTA S5CODALERTA,t8.S5CARACTERALERTA S5CARACTERALERTA "
						+ "FROM ACTUACION t1 ,TIP_PROTOCOLO t2 ,ACTA t3 ,CAMPAHNA_RECIB t4 ,ESTABLECIMIENTO t5 ,PRODUCTO t6 ,DENUNCIA_RECIB t7 ,ALERTA_RECIB t8 ,TIP_ACTUACION t9 ,TIPMOT_ACTUACION t10 ");

		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND t1.ATCODIGO = ?");
			params.add(actuacion.getAtcodigo());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(actuacion.getTipProtocolo().getTpcodigo());
		}
		if (actuacion != null
				&& actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getCampanha() != null
				&& actuacion.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(actuacion.getTipProtocolo().getCampanha().getCmcodigo());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(actuacion.getTipProtocolo().getTpnombre());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(actuacion.getTipProtocolo().getTpcotmo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccodigo() != null) {
			where.append(" AND t3.ACCODIGO = ?");
			params.add(actuacion.getActa().getAccodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoindo() != null
				&& actuacion.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t3.ACCOINDO = ?");
			params.add(actuacion.getActa().getInspectorByAccoindo()
					.getIncodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoinun() != null
				&& actuacion.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t3.ACCOINUN = ?");
			params.add(actuacion.getActa().getInspectorByAccoinun()
					.getIncodigo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getTipodoc() != null
				&& actuacion.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND t3.ACCOTD = ?");
			params.add(actuacion.getActa().getTipodoc().getTdcodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getEstablecimiento() != null
				&& actuacion.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ACCOES = ?");
			params.add(actuacion.getActa().getEstablecimiento().getEscodigo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoor() != null) {
			where.append(" AND t3.ACCOOR = ?");
			params.add(actuacion.getActa().getAccoor());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnror() != null) {
			where.append(" AND t3.ACNROR = ?");
			params.add(actuacion.getActa().getAcnror());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnran() != null) {
			where.append(" AND t3.ACNRAN = ?");
			params.add(actuacion.getActa().getAcnran());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfele() != null) {
			where.append(" AND t3.ACFELE = ?");
			params.add(actuacion.getActa().getAcfele());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfere() != null) {
			where.append(" AND t3.ACFERE = ?");
			params.add(actuacion.getActa().getAcfere());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoav() != null) {
			where.append(" AND t3.ACCOAV = ?");
			params.add(actuacion.getActa().getAccoav());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccose() != null) {
			where.append(" AND t3.ACCOSE = ?");
			params.add(actuacion.getActa().getAccose());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfeex() != null) {
			where.append(" AND t3.ACFEEX = ?");
			params.add(actuacion.getActa().getAcfeex());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcinre() != null) {
			where.append(" AND t3.ACINRE = ?");
			params.add(actuacion.getActa().getAcinre());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoco() != null) {
			where.append(" AND t3.ACNOCO = ?");
			params.add(actuacion.getActa().getAcnoco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape1co() != null) {
			where.append(" AND t3.ACAPE1CO = ?");
			params.add(actuacion.getActa().getAcape1co());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape2co() != null) {
			where.append(" AND t3.ACAPE2CO = ?");
			params.add(actuacion.getActa().getAcape2co());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdnico() != null) {
			where.append(" AND t3.ACDNICO = ?");
			params.add(actuacion.getActa().getAcdnico());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoco() != null) {
			where.append(" AND t3.ACCOCO = ?");
			params.add(actuacion.getActa().getAccoco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdirco() != null) {
			where.append(" AND t3.ACDIRCO = ?");
			params.add(actuacion.getActa().getAcdirco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoloco() != null) {
			where.append(" AND t3.ACCOLOCO = ?");
			params.add(actuacion.getActa().getAccoloco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrcpco() != null) {
			where.append(" AND t3.ACNRCPCO = ?");
			params.add(actuacion.getActa().getAcnrcpco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrtfco() != null) {
			where.append(" AND t3.ACNRTFCO = ?");
			params.add(actuacion.getActa().getAcnrtfco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisId() != null) {
			where.append(" AND t3.ACNORA_PAIS_ID = ?");
			params.add(actuacion.getActa().getAcnoraPaisId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND t3.ACNORA_PAIS_NOMBRE = ?");
			params.add(actuacion.getActa().getAcnoraPaisNombre());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND t3.ACNORA_PROVINCIA_ID = ?");
			params.add(actuacion.getActa().getAcnoraProvinciaId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreProvincia() != null) {
			where.append(" AND t3.ACNOMBRE_PROVINCIA = ?");
			params.add(actuacion.getActa().getAcnombreProvincia());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND t3.ACNORA_MUNICIPIO_ID = ?");
			params.add(actuacion.getActa().getAcnoraMunicipioId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND t3.ACNOMBRE_MUNICIPIO = ?");
			params.add(actuacion.getActa().getAcnombreMunicipio());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND t3.ACNORA_LOCALIDAD_ID = ?");
			params.add(actuacion.getActa().getAcnoraLocalidadId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND t3.ACNOMBRE_LOCALIDAD = ?");
			params.add(actuacion.getActa().getAcnombreLocalidad());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCalleId() != null) {
			where.append(" AND t3.ACNORA_CALLE_ID = ?");
			params.add(actuacion.getActa().getAcnoraCalleId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCalle() != null) {
			where.append(" AND t3.ACNOMBRE_CALLE = ?");
			params.add(actuacion.getActa().getAcnombreCalle());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCpId() != null) {
			where.append(" AND t3.ACNORA_CP_ID = ?");
			params.add(actuacion.getActa().getAcnoraCpId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCp() != null) {
			where.append(" AND t3.ACNOMBRE_CP = ?");
			params.add(actuacion.getActa().getAcnombreCp());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPortalId() != null) {
			where.append(" AND t3.ACNORA_PORTAL_ID = ?");
			params.add(actuacion.getActa().getAcnoraPortalId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePortal() != null) {
			where.append(" AND t3.ACNOMBRE_PORTAL = ?");
			params.add(actuacion.getActa().getAcnombrePortal());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePiso() != null) {
			where.append(" AND t3.ACNOMBRE_PISO = ?");
			params.add(actuacion.getActa().getAcnombrePiso());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t4.S4CODIGO = ?");
			params.add(actuacion.getCampahnaRecib().getS4codigo());
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getCampanha() != null
				&& actuacion.getCampahnaRecib().getCampanha().getCmcodigo() != null) {
			where.append(" AND t4.S4CODCAMPANHA = ?");
			params.add(actuacion.getCampahnaRecib().getCampanha().getCmcodigo());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codorganismo() != null) {
			where.append(" AND t4.S4CODORGANISMO = ?");
			params.add(actuacion.getCampahnaRecib().getS4codorganismo());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4feccomunicacion() != null) {
			where.append(" AND t4.S4FECCOMUNICACION = ?");
			params.add(actuacion.getCampahnaRecib().getS4feccomunicacion());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4fecfinalizacion() != null) {
			where.append(" AND t4.S4FECFINALIZACION = ?");
			params.add(actuacion.getCampahnaRecib().getS4fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4cantidadactuaciones() != null) {
			where.append(" AND t4.S4CANTIDADACTUACIONES = ?");
			params.add(actuacion.getCampahnaRecib().getS4cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(actuacion.getEstablecimiento().getEscodigo());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getCensoMonitor() != null
				&& actuacion.getEstablecimiento().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t5.ESCOZS = ?");
			params.add(actuacion.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t5.ESNOMBRE = ?");
			params.add(actuacion.getEstablecimiento().getEsnombre());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(actuacion.getEstablecimiento().getEsnif());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t5.ESNOAN = ?");
			params.add(actuacion.getEstablecimiento().getEsnoan());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t5.ESNOCO = ?");
			params.add(actuacion.getEstablecimiento().getEsnoco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t5.ESNODIR = ?");
			params.add(actuacion.getEstablecimiento().getEsnodir());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t5.ESCOLO = ?");
			params.add(actuacion.getEstablecimiento().getEscolo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t5.ESNRCOPO = ?");
			params.add(actuacion.getEstablecimiento().getEsnrcopo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t5.ESNRTEL = ?");
			params.add(actuacion.getEstablecimiento().getEsnrtel());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t5.ESNRFAX = ?");
			params.add(actuacion.getEstablecimiento().getEsnrfax());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t5.ESCOPA = ?");
			params.add(actuacion.getEstablecimiento().getEscopa());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t5.ESINCAPR = ?");
			params.add(actuacion.getEstablecimiento().getEsincapr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t5.ESINDEMP = ?");
			params.add(actuacion.getEstablecimiento().getEsindemp());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t5.ESTECO = ?");
			params.add(actuacion.getEstablecimiento().getEsteco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t5.ESINADAR = ?");
			params.add(actuacion.getEstablecimiento().getEsinadar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR = ?");
			params.add(actuacion.getEstablecimiento().getEsfeadar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t5.ESCOEM = ?");
			params.add(actuacion.getEstablecimiento().getEscoem());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t5.ESINEMPR = ?");
			params.add(actuacion.getEstablecimiento().getEsinempr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t5.ESNRTEL2 = ?");
			params.add(actuacion.getEstablecimiento().getEsnrtel2());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA = ?");
			params.add(actuacion.getEstablecimiento().getEsfeba());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t5.ESNOAP1 = ?");
			params.add(actuacion.getEstablecimiento().getEsnoap1());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t5.ESNOAP2 = ?");
			params.add(actuacion.getEstablecimiento().getEsnoap2());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t5.ESNOLO = ?");
			params.add(actuacion.getEstablecimiento().getEsnolo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t5.ESCOMAPV = ?");
			params.add(actuacion.getEstablecimiento().getEscomapv());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t5.ESCOCA = ?");
			params.add(actuacion.getEstablecimiento().getEscoca());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t5.ESNOPECO = ?");
			params.add(actuacion.getEstablecimiento().getEsnopeco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t5.ESCOIDCO = ?");
			params.add(actuacion.getEstablecimiento().getEscoidco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t5.ESINRECO = ?");
			params.add(actuacion.getEstablecimiento().getEsinreco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t5.ESFEMOD = ?");
			params.add(actuacion.getEstablecimiento().getEsfemod());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t5.ESINESCO = ?");
			params.add(actuacion.getEstablecimiento().getEsinesco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t5.ESNOMU = ?");
			params.add(actuacion.getEstablecimiento().getEsnomu());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t5.ESNOREP = ?");
			params.add(actuacion.getEstablecimiento().getEsnorep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t5.ESNIFREP = ?");
			params.add(actuacion.getEstablecimiento().getEsnifrep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t5.DTTEEMR = ?");
			params.add(actuacion.getEstablecimiento().getDtteemr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t5.ESCAREP = ?");
			params.add(actuacion.getEstablecimiento().getEscarep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t5.ESTEURL = ?");
			params.add(actuacion.getEstablecimiento().getEsteurl());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t5.ESCOOE = ?");
			params.add(actuacion.getEstablecimiento().getEscooe());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t5.ESNODECO = ?");
			params.add(actuacion.getEstablecimiento().getEsnodeco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t5.ESINTIAR = ?");
			params.add(actuacion.getEstablecimiento().getEsintiar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD = ?");
			params.add(actuacion.getEstablecimiento().getEsfeplad());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t5.ESINDEME = ?");
			params.add(actuacion.getEstablecimiento().getEsindeme());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.ESNORA_PAIS_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPaisId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t5.ESNORA_PAIS_NOMBRE = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t5.ESNOMBRE_PROVINCIA = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreProvincia());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t5.ESNOMBRE_MUNICIPIO = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreMunicipio());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t5.ESNOMBRE_LOCALIDAD = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreLocalidad());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t5.ESNORA_CALLE_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraCalleId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t5.ESNOMBRE_CALLE = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreCalle());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t5.ESNORA_CP_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraCpId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t5.ESNOMBRE_CP = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreCp());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t5.ESNORA_PORTAL_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPortalId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t5.ESNOMBRE_PORTAL = ?");
			params.add(actuacion.getEstablecimiento().getEsnombrePortal());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t5.ESNOMBRE_PISO = ?");
			params.add(actuacion.getEstablecimiento().getEsnombrePiso());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO = ?");
			params.add(actuacion.getProducto().getPscodigo());
		}
		if (actuacion != null
				&& actuacion.getProducto() != null
				&& actuacion.getProducto().getProdAgrupado() != null
				&& actuacion.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t6.PSCOE8 = ?");
			params.add(actuacion.getProducto().getProdAgrupado().getE8codigo());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombre() != null) {
			where.append(" AND t6.PSNOMBRE = ?");
			params.add(actuacion.getProducto().getPsnombre());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnoco() != null) {
			where.append(" AND t6.PSNOCO = ?");
			params.add(actuacion.getProducto().getPsnoco());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescri() != null) {
			where.append(" AND t6.PSDESCRI = ?");
			params.add(actuacion.getProducto().getPsdescri());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscose() != null) {
			where.append(" AND t6.PSCOSE = ?");
			params.add(actuacion.getProducto().getPscose());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombree() != null) {
			where.append(" AND t6.PSNOMBREE = ?");
			params.add(actuacion.getProducto().getPsnombree());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrei() != null) {
			where.append(" AND t6.PSNOMBREI = ?");
			params.add(actuacion.getProducto().getPsnombrei());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombref() != null) {
			where.append(" AND t6.PSNOMBREF = ?");
			params.add(actuacion.getProducto().getPsnombref());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrea() != null) {
			where.append(" AND t6.PSNOMBREA = ?");
			params.add(actuacion.getProducto().getPsnombrea());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoe() != null) {
			where.append(" AND t6.PSNOCOE = ?");
			params.add(actuacion.getProducto().getPsnocoe());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoi() != null) {
			where.append(" AND t6.PSNOCOI = ?");
			params.add(actuacion.getProducto().getPsnocoi());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocof() != null) {
			where.append(" AND t6.PSNOCOF = ?");
			params.add(actuacion.getProducto().getPsnocof());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoa() != null) {
			where.append(" AND t6.PSNOCOA = ?");
			params.add(actuacion.getProducto().getPsnocoa());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrie() != null) {
			where.append(" AND t6.PSDESCRIE = ?");
			params.add(actuacion.getProducto().getPsdescrie());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrii() != null) {
			where.append(" AND t6.PSDESCRII = ?");
			params.add(actuacion.getProducto().getPsdescrii());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrif() != null) {
			where.append(" AND t6.PSDESCRIF = ?");
			params.add(actuacion.getProducto().getPsdescrif());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescria() != null) {
			where.append(" AND t6.PSDESCRIA = ?");
			params.add(actuacion.getProducto().getPsdescria());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPssel1() != null) {
			where.append(" AND t6.PSSEL1 = ?");
			params.add(actuacion.getProducto().getPssel1());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscoinc() != null) {
			where.append(" AND t6.PSCOINC = ?");
			params.add(actuacion.getProducto().getPscoinc());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t7.S6CODIGO = ?");
			params.add(actuacion.getDenunciaRecib().getS6codigo());
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND t7.S6CODHECDEN = ?");
			params.add(actuacion.getDenunciaRecib().getHechoDenunciado()
					.getHdcodigo());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codorganismo() != null) {
			where.append(" AND t7.S6CODORGANISMO = ?");
			params.add(actuacion.getDenunciaRecib().getS6codorganismo());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6feccomunicacion() != null) {
			where.append(" AND t7.S6FECCOMUNICACION = ?");
			params.add(actuacion.getDenunciaRecib().getS6feccomunicacion());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6fecfinalizacion() != null) {
			where.append(" AND t7.S6FECFINALIZACION = ?");
			params.add(actuacion.getDenunciaRecib().getS6fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6cantidadactuaciones() != null) {
			where.append(" AND t7.S6CANTIDADACTUACIONES = ?");
			params.add(actuacion.getDenunciaRecib().getS6cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t8.S5CODIGO = ?");
			params.add(actuacion.getAlertaRecib().getS5codigo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getAlerta() != null
				&& actuacion.getAlertaRecib().getAlerta().getAlcodigo() != null) {
			where.append(" AND t8.S5CODALERTA = ?");
			params.add(actuacion.getAlertaRecib().getAlerta().getAlcodigo());
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND t8.S5CARACTERALERTA = ?");
			params.add(actuacion.getAlertaRecib().getCaracterAlerta()
					.getCrcodigo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codorganismo() != null) {
			where.append(" AND t8.S5CODORGANISMO = ?");
			params.add(actuacion.getAlertaRecib().getS5codorganismo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5feccomunicacion() != null) {
			where.append(" AND t8.S5FECCOMUNICACION = ?");
			params.add(actuacion.getAlertaRecib().getS5feccomunicacion());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5fecfinalizacion() != null) {
			where.append(" AND t8.S5FECFINALIZACION = ?");
			params.add(actuacion.getAlertaRecib().getS5fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5cantidadactuaciones() != null) {
			where.append(" AND t8.S5CANTIDADACTUACIONES = ?");
			params.add(actuacion.getAlertaRecib().getS5cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t9.TTACODIGO = ?");
			params.add(actuacion.getTipActuacion().getTtacodigo());
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtanombre() != null) {
			where.append(" AND t9.TTANOMBRE = ?");
			params.add(actuacion.getTipActuacion().getTtanombre());
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t10.TMACODIGO = ?");
			params.add(actuacion.getTipmotActuacion().getTmacodigo());
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmanombre() != null) {
			where.append(" AND t10.TMANOMBRE = ?");
			params.add(actuacion.getTipmotActuacion().getTmanombre());
		}
		if (actuacion != null && actuacion.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacion.getAtnror());
		}
		if (actuacion != null && actuacion.getAtcoav() != null) {
			where.append(" AND t1.ATCOAV = ?");
			params.add(actuacion.getAtcoav());
		}
		if (actuacion != null && actuacion.getAtcose() != null) {
			where.append(" AND t1.ATCOSE = ?");
			params.add(actuacion.getAtcose());
		}
		if (actuacion != null && actuacion.getAtnoprse() != null) {
			where.append(" AND t1.ATNOPRSE = ?");
			params.add(actuacion.getAtnoprse());
		}
		if (actuacion != null && actuacion.getAtnomaps() != null) {
			where.append(" AND t1.ATNOMAPS = ?");
			params.add(actuacion.getAtnomaps());
		}
		if (actuacion != null && actuacion.getAtnomops() != null) {
			where.append(" AND t1.ATNOMOPS = ?");
			params.add(actuacion.getAtnomops());
		}
		if (actuacion != null && actuacion.getAtnrlops() != null) {
			where.append(" AND t1.ATNRLOPS = ?");
			params.add(actuacion.getAtnrlops());
		}
		if (actuacion != null && actuacion.getAtfedumi() != null) {
			where.append(" AND t1.ATFEDUMI = ?");
			params.add(actuacion.getAtfedumi());
		}
		if (actuacion != null && actuacion.getAtinprse() != null) {
			where.append(" AND t1.ATINPRSE = ?");
			params.add(actuacion.getAtinprse());
		}
		if (actuacion != null && actuacion.getAtcaunep() != null) {
			where.append(" AND t1.ATCAUNEP = ?");
			params.add(actuacion.getAtcaunep());
		}
		if (actuacion != null && actuacion.getAtcoat() != null) {
			where.append(" AND t1.ATCOAT = ?");
			params.add(actuacion.getAtcoat());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Actuacion actuacion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.ATCOTP= t2.TPCODIGO(+) and t1.ATCOAC= t3.ACCODIGO(+) and t1.ATCOCM= t4.S4CODIGO(+) and t1.ATCOES= t5.ESCODIGO(+) and t1.ATCOPS= t6.PSCODIGO(+) and t1.ATCOHD= t7.S6CODIGO(+) and t1.ATCOAL= t8.S5CODIGO(+) and t1.ATCOTTA= t9.TTACODIGO(+) and t1.ATCOTMA= t10.TMACODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ACTUACION t1   ,  TIP_PROTOCOLO t2   ,  ACTA t3   ,  CAMPAHNA_RECIB t4   ,  ESTABLECIMIENTO t5   ,  PRODUCTO t6   ,  DENUNCIA_RECIB t7   ,  ALERTA_RECIB t8   ,  TIP_ACTUACION t9   ,  TIPMOT_ACTUACION t10  ");
		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND t1.ATCODIGO = ?");
			params.add(actuacion.getAtcodigo());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO = ?");
			params.add(actuacion.getTipProtocolo().getTpcodigo());
		}
		if (actuacion != null
				&& actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getCampanha() != null
				&& actuacion.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND t2.TPCOCM = ?");
			params.add(actuacion.getTipProtocolo().getCampanha().getCmcodigo());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND t2.TPNOMBRE = ?");
			params.add(actuacion.getTipProtocolo().getTpnombre());
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND t2.TPCOTMO = ?");
			params.add(actuacion.getTipProtocolo().getTpcotmo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccodigo() != null) {
			where.append(" AND t3.ACCODIGO = ?");
			params.add(actuacion.getActa().getAccodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoindo() != null
				&& actuacion.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t3.ACCOINDO = ?");
			params.add(actuacion.getActa().getInspectorByAccoindo()
					.getIncodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoinun() != null
				&& actuacion.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t3.ACCOINUN = ?");
			params.add(actuacion.getActa().getInspectorByAccoinun()
					.getIncodigo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getTipodoc() != null
				&& actuacion.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND t3.ACCOTD = ?");
			params.add(actuacion.getActa().getTipodoc().getTdcodigo());
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getEstablecimiento() != null
				&& actuacion.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t3.ACCOES = ?");
			params.add(actuacion.getActa().getEstablecimiento().getEscodigo());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoor() != null) {
			where.append(" AND t3.ACCOOR = ?");
			params.add(actuacion.getActa().getAccoor());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnror() != null) {
			where.append(" AND t3.ACNROR = ?");
			params.add(actuacion.getActa().getAcnror());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnran() != null) {
			where.append(" AND t3.ACNRAN = ?");
			params.add(actuacion.getActa().getAcnran());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfele() != null) {
			where.append(" AND t3.ACFELE = ?");
			params.add(actuacion.getActa().getAcfele());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfere() != null) {
			where.append(" AND t3.ACFERE = ?");
			params.add(actuacion.getActa().getAcfere());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoav() != null) {
			where.append(" AND t3.ACCOAV = ?");
			params.add(actuacion.getActa().getAccoav());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccose() != null) {
			where.append(" AND t3.ACCOSE = ?");
			params.add(actuacion.getActa().getAccose());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfeex() != null) {
			where.append(" AND t3.ACFEEX = ?");
			params.add(actuacion.getActa().getAcfeex());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcinre() != null) {
			where.append(" AND t3.ACINRE = ?");
			params.add(actuacion.getActa().getAcinre());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoco() != null) {
			where.append(" AND t3.ACNOCO = ?");
			params.add(actuacion.getActa().getAcnoco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape1co() != null) {
			where.append(" AND t3.ACAPE1CO = ?");
			params.add(actuacion.getActa().getAcape1co());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape2co() != null) {
			where.append(" AND t3.ACAPE2CO = ?");
			params.add(actuacion.getActa().getAcape2co());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdnico() != null) {
			where.append(" AND t3.ACDNICO = ?");
			params.add(actuacion.getActa().getAcdnico());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoco() != null) {
			where.append(" AND t3.ACCOCO = ?");
			params.add(actuacion.getActa().getAccoco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdirco() != null) {
			where.append(" AND t3.ACDIRCO = ?");
			params.add(actuacion.getActa().getAcdirco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoloco() != null) {
			where.append(" AND t3.ACCOLOCO = ?");
			params.add(actuacion.getActa().getAccoloco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrcpco() != null) {
			where.append(" AND t3.ACNRCPCO = ?");
			params.add(actuacion.getActa().getAcnrcpco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrtfco() != null) {
			where.append(" AND t3.ACNRTFCO = ?");
			params.add(actuacion.getActa().getAcnrtfco());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisId() != null) {
			where.append(" AND t3.ACNORA_PAIS_ID = ?");
			params.add(actuacion.getActa().getAcnoraPaisId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND t3.ACNORA_PAIS_NOMBRE = ?");
			params.add(actuacion.getActa().getAcnoraPaisNombre());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND t3.ACNORA_PROVINCIA_ID = ?");
			params.add(actuacion.getActa().getAcnoraProvinciaId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreProvincia() != null) {
			where.append(" AND t3.ACNOMBRE_PROVINCIA = ?");
			params.add(actuacion.getActa().getAcnombreProvincia());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND t3.ACNORA_MUNICIPIO_ID = ?");
			params.add(actuacion.getActa().getAcnoraMunicipioId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND t3.ACNOMBRE_MUNICIPIO = ?");
			params.add(actuacion.getActa().getAcnombreMunicipio());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND t3.ACNORA_LOCALIDAD_ID = ?");
			params.add(actuacion.getActa().getAcnoraLocalidadId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND t3.ACNOMBRE_LOCALIDAD = ?");
			params.add(actuacion.getActa().getAcnombreLocalidad());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCalleId() != null) {
			where.append(" AND t3.ACNORA_CALLE_ID = ?");
			params.add(actuacion.getActa().getAcnoraCalleId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCalle() != null) {
			where.append(" AND t3.ACNOMBRE_CALLE = ?");
			params.add(actuacion.getActa().getAcnombreCalle());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCpId() != null) {
			where.append(" AND t3.ACNORA_CP_ID = ?");
			params.add(actuacion.getActa().getAcnoraCpId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCp() != null) {
			where.append(" AND t3.ACNOMBRE_CP = ?");
			params.add(actuacion.getActa().getAcnombreCp());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPortalId() != null) {
			where.append(" AND t3.ACNORA_PORTAL_ID = ?");
			params.add(actuacion.getActa().getAcnoraPortalId());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePortal() != null) {
			where.append(" AND t3.ACNOMBRE_PORTAL = ?");
			params.add(actuacion.getActa().getAcnombrePortal());
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePiso() != null) {
			where.append(" AND t3.ACNOMBRE_PISO = ?");
			params.add(actuacion.getActa().getAcnombrePiso());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t4.S4CODIGO = ?");
			params.add(actuacion.getCampahnaRecib().getS4codigo());
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getCampanha() != null
				&& actuacion.getCampahnaRecib().getCampanha().getCmcodigo() != null) {
			where.append(" AND t4.S4CODCAMPANHA = ?");
			params.add(actuacion.getCampahnaRecib().getCampanha().getCmcodigo());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codorganismo() != null) {
			where.append(" AND t4.S4CODORGANISMO = ?");
			params.add(actuacion.getCampahnaRecib().getS4codorganismo());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4feccomunicacion() != null) {
			where.append(" AND t4.S4FECCOMUNICACION = ?");
			params.add(actuacion.getCampahnaRecib().getS4feccomunicacion());
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4fecfinalizacion() != null) {
			where.append(" AND t4.S4FECFINALIZACION = ?");
			params.add(actuacion.getCampahnaRecib().getS4fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4cantidadactuaciones() != null) {
			where.append(" AND t4.S4CANTIDADACTUACIONES = ?");
			params.add(actuacion.getCampahnaRecib().getS4cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO = ?");
			params.add(actuacion.getEstablecimiento().getEscodigo());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getCensoMonitor() != null
				&& actuacion.getEstablecimiento().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND t5.ESCOZS = ?");
			params.add(actuacion.getEstablecimiento().getCensoMonitor()
					.getMocodigo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND t5.ESNOMBRE = ?");
			params.add(actuacion.getEstablecimiento().getEsnombre());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnif() != null) {
			where.append(" AND t5.ESNIF = ?");
			params.add(actuacion.getEstablecimiento().getEsnif());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND t5.ESNOAN = ?");
			params.add(actuacion.getEstablecimiento().getEsnoan());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND t5.ESNOCO = ?");
			params.add(actuacion.getEstablecimiento().getEsnoco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND t5.ESNODIR = ?");
			params.add(actuacion.getEstablecimiento().getEsnodir());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscolo() != null) {
			where.append(" AND t5.ESCOLO = ?");
			params.add(actuacion.getEstablecimiento().getEscolo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND t5.ESNRCOPO = ?");
			params.add(actuacion.getEstablecimiento().getEsnrcopo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND t5.ESNRTEL = ?");
			params.add(actuacion.getEstablecimiento().getEsnrtel());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND t5.ESNRFAX = ?");
			params.add(actuacion.getEstablecimiento().getEsnrfax());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscopa() != null) {
			where.append(" AND t5.ESCOPA = ?");
			params.add(actuacion.getEstablecimiento().getEscopa());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND t5.ESINCAPR = ?");
			params.add(actuacion.getEstablecimiento().getEsincapr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND t5.ESINDEMP = ?");
			params.add(actuacion.getEstablecimiento().getEsindemp());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteco() != null) {
			where.append(" AND t5.ESTECO = ?");
			params.add(actuacion.getEstablecimiento().getEsteco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND t5.ESINADAR = ?");
			params.add(actuacion.getEstablecimiento().getEsinadar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR = ?");
			params.add(actuacion.getEstablecimiento().getEsfeadar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoem() != null) {
			where.append(" AND t5.ESCOEM = ?");
			params.add(actuacion.getEstablecimiento().getEscoem());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND t5.ESINEMPR = ?");
			params.add(actuacion.getEstablecimiento().getEsinempr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND t5.ESNRTEL2 = ?");
			params.add(actuacion.getEstablecimiento().getEsnrtel2());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA = ?");
			params.add(actuacion.getEstablecimiento().getEsfeba());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND t5.ESNOAP1 = ?");
			params.add(actuacion.getEstablecimiento().getEsnoap1());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND t5.ESNOAP2 = ?");
			params.add(actuacion.getEstablecimiento().getEsnoap2());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND t5.ESNOLO = ?");
			params.add(actuacion.getEstablecimiento().getEsnolo());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND t5.ESCOMAPV = ?");
			params.add(actuacion.getEstablecimiento().getEscomapv());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoca() != null) {
			where.append(" AND t5.ESCOCA = ?");
			params.add(actuacion.getEstablecimiento().getEscoca());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND t5.ESNOPECO = ?");
			params.add(actuacion.getEstablecimiento().getEsnopeco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND t5.ESCOIDCO = ?");
			params.add(actuacion.getEstablecimiento().getEscoidco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND t5.ESINRECO = ?");
			params.add(actuacion.getEstablecimiento().getEsinreco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND t5.ESFEMOD = ?");
			params.add(actuacion.getEstablecimiento().getEsfemod());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND t5.ESINESCO = ?");
			params.add(actuacion.getEstablecimiento().getEsinesco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND t5.ESNOMU = ?");
			params.add(actuacion.getEstablecimiento().getEsnomu());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND t5.ESNOREP = ?");
			params.add(actuacion.getEstablecimiento().getEsnorep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND t5.ESNIFREP = ?");
			params.add(actuacion.getEstablecimiento().getEsnifrep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND t5.DTTEEMR = ?");
			params.add(actuacion.getEstablecimiento().getDtteemr());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscarep() != null) {
			where.append(" AND t5.ESCAREP = ?");
			params.add(actuacion.getEstablecimiento().getEscarep());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND t5.ESTEURL = ?");
			params.add(actuacion.getEstablecimiento().getEsteurl());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscooe() != null) {
			where.append(" AND t5.ESCOOE = ?");
			params.add(actuacion.getEstablecimiento().getEscooe());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND t5.ESNODECO = ?");
			params.add(actuacion.getEstablecimiento().getEsnodeco());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND t5.ESINTIAR = ?");
			params.add(actuacion.getEstablecimiento().getEsintiar());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD = ?");
			params.add(actuacion.getEstablecimiento().getEsfeplad());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND t5.ESINDEME = ?");
			params.add(actuacion.getEstablecimiento().getEsindeme());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND t5.ESNORA_PAIS_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPaisId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND t5.ESNORA_PAIS_NOMBRE = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPaisNombre());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND t5.ESNORA_PROVINCIA_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraProvinciaId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND t5.ESNOMBRE_PROVINCIA = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreProvincia());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND t5.ESNORA_MUNICIPIO_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraMunicipioId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND t5.ESNOMBRE_MUNICIPIO = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreMunicipio());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND t5.ESNORA_LOCALIDAD_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraLocalidadId());
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND t5.ESNOMBRE_LOCALIDAD = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreLocalidad());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND t5.ESNORA_CALLE_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraCalleId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND t5.ESNOMBRE_CALLE = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreCalle());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND t5.ESNORA_CP_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraCpId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND t5.ESNOMBRE_CP = ?");
			params.add(actuacion.getEstablecimiento().getEsnombreCp());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND t5.ESNORA_PORTAL_ID = ?");
			params.add(actuacion.getEstablecimiento().getEsnoraPortalId());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND t5.ESNOMBRE_PORTAL = ?");
			params.add(actuacion.getEstablecimiento().getEsnombrePortal());
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND t5.ESNOMBRE_PISO = ?");
			params.add(actuacion.getEstablecimiento().getEsnombrePiso());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO = ?");
			params.add(actuacion.getProducto().getPscodigo());
		}
		if (actuacion != null
				&& actuacion.getProducto() != null
				&& actuacion.getProducto().getProdAgrupado() != null
				&& actuacion.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND t6.PSCOE8 = ?");
			params.add(actuacion.getProducto().getProdAgrupado().getE8codigo());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombre() != null) {
			where.append(" AND t6.PSNOMBRE = ?");
			params.add(actuacion.getProducto().getPsnombre());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnoco() != null) {
			where.append(" AND t6.PSNOCO = ?");
			params.add(actuacion.getProducto().getPsnoco());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescri() != null) {
			where.append(" AND t6.PSDESCRI = ?");
			params.add(actuacion.getProducto().getPsdescri());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscose() != null) {
			where.append(" AND t6.PSCOSE = ?");
			params.add(actuacion.getProducto().getPscose());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombree() != null) {
			where.append(" AND t6.PSNOMBREE = ?");
			params.add(actuacion.getProducto().getPsnombree());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrei() != null) {
			where.append(" AND t6.PSNOMBREI = ?");
			params.add(actuacion.getProducto().getPsnombrei());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombref() != null) {
			where.append(" AND t6.PSNOMBREF = ?");
			params.add(actuacion.getProducto().getPsnombref());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrea() != null) {
			where.append(" AND t6.PSNOMBREA = ?");
			params.add(actuacion.getProducto().getPsnombrea());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoe() != null) {
			where.append(" AND t6.PSNOCOE = ?");
			params.add(actuacion.getProducto().getPsnocoe());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoi() != null) {
			where.append(" AND t6.PSNOCOI = ?");
			params.add(actuacion.getProducto().getPsnocoi());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocof() != null) {
			where.append(" AND t6.PSNOCOF = ?");
			params.add(actuacion.getProducto().getPsnocof());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoa() != null) {
			where.append(" AND t6.PSNOCOA = ?");
			params.add(actuacion.getProducto().getPsnocoa());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrie() != null) {
			where.append(" AND t6.PSDESCRIE = ?");
			params.add(actuacion.getProducto().getPsdescrie());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrii() != null) {
			where.append(" AND t6.PSDESCRII = ?");
			params.add(actuacion.getProducto().getPsdescrii());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrif() != null) {
			where.append(" AND t6.PSDESCRIF = ?");
			params.add(actuacion.getProducto().getPsdescrif());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescria() != null) {
			where.append(" AND t6.PSDESCRIA = ?");
			params.add(actuacion.getProducto().getPsdescria());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPssel1() != null) {
			where.append(" AND t6.PSSEL1 = ?");
			params.add(actuacion.getProducto().getPssel1());
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscoinc() != null) {
			where.append(" AND t6.PSCOINC = ?");
			params.add(actuacion.getProducto().getPscoinc());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t7.S6CODIGO = ?");
			params.add(actuacion.getDenunciaRecib().getS6codigo());
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND t7.S6CODHECDEN = ?");
			params.add(actuacion.getDenunciaRecib().getHechoDenunciado()
					.getHdcodigo());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codorganismo() != null) {
			where.append(" AND t7.S6CODORGANISMO = ?");
			params.add(actuacion.getDenunciaRecib().getS6codorganismo());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6feccomunicacion() != null) {
			where.append(" AND t7.S6FECCOMUNICACION = ?");
			params.add(actuacion.getDenunciaRecib().getS6feccomunicacion());
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6fecfinalizacion() != null) {
			where.append(" AND t7.S6FECFINALIZACION = ?");
			params.add(actuacion.getDenunciaRecib().getS6fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6cantidadactuaciones() != null) {
			where.append(" AND t7.S6CANTIDADACTUACIONES = ?");
			params.add(actuacion.getDenunciaRecib().getS6cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t8.S5CODIGO = ?");
			params.add(actuacion.getAlertaRecib().getS5codigo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getAlerta() != null
				&& actuacion.getAlertaRecib().getAlerta().getAlcodigo() != null) {
			where.append(" AND t8.S5CODALERTA = ?");
			params.add(actuacion.getAlertaRecib().getAlerta().getAlcodigo());
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND t8.S5CARACTERALERTA = ?");
			params.add(actuacion.getAlertaRecib().getCaracterAlerta()
					.getCrcodigo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codorganismo() != null) {
			where.append(" AND t8.S5CODORGANISMO = ?");
			params.add(actuacion.getAlertaRecib().getS5codorganismo());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5feccomunicacion() != null) {
			where.append(" AND t8.S5FECCOMUNICACION = ?");
			params.add(actuacion.getAlertaRecib().getS5feccomunicacion());
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5fecfinalizacion() != null) {
			where.append(" AND t8.S5FECFINALIZACION = ?");
			params.add(actuacion.getAlertaRecib().getS5fecfinalizacion());
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5cantidadactuaciones() != null) {
			where.append(" AND t8.S5CANTIDADACTUACIONES = ?");
			params.add(actuacion.getAlertaRecib().getS5cantidadactuaciones());
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t9.TTACODIGO = ?");
			params.add(actuacion.getTipActuacion().getTtacodigo());
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtanombre() != null) {
			where.append(" AND t9.TTANOMBRE = ?");
			params.add(actuacion.getTipActuacion().getTtanombre());
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t10.TMACODIGO = ?");
			params.add(actuacion.getTipmotActuacion().getTmacodigo());
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmanombre() != null) {
			where.append(" AND t10.TMANOMBRE = ?");
			params.add(actuacion.getTipmotActuacion().getTmanombre());
		}
		if (actuacion != null && actuacion.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacion.getAtnror());
		}
		if (actuacion != null && actuacion.getAtcoav() != null) {
			where.append(" AND t1.ATCOAV = ?");
			params.add(actuacion.getAtcoav());
		}
		if (actuacion != null && actuacion.getAtcose() != null) {
			where.append(" AND t1.ATCOSE = ?");
			params.add(actuacion.getAtcose());
		}
		if (actuacion != null && actuacion.getAtnoprse() != null) {
			where.append(" AND t1.ATNOPRSE = ?");
			params.add(actuacion.getAtnoprse());
		}
		if (actuacion != null && actuacion.getAtnomaps() != null) {
			where.append(" AND t1.ATNOMAPS = ?");
			params.add(actuacion.getAtnomaps());
		}
		if (actuacion != null && actuacion.getAtnomops() != null) {
			where.append(" AND t1.ATNOMOPS = ?");
			params.add(actuacion.getAtnomops());
		}
		if (actuacion != null && actuacion.getAtnrlops() != null) {
			where.append(" AND t1.ATNRLOPS = ?");
			params.add(actuacion.getAtnrlops());
		}
		if (actuacion != null && actuacion.getAtfedumi() != null) {
			where.append(" AND t1.ATFEDUMI = ?");
			params.add(actuacion.getAtfedumi());
		}
		if (actuacion != null && actuacion.getAtinprse() != null) {
			where.append(" AND t1.ATINPRSE = ?");
			params.add(actuacion.getAtinprse());
		}
		if (actuacion != null && actuacion.getAtcaunep() != null) {
			where.append(" AND t1.ATCAUNEP = ?");
			params.add(actuacion.getAtcaunep());
		}
		if (actuacion != null && actuacion.getAtcoat() != null) {
			where.append(" AND t1.ATCOAT = ?");
			params.add(actuacion.getAtcoat());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<Actuacion> findAllLike(Actuacion actuacion,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.ATCOTP= t2.TPCODIGO(+) AND t1.ATCOAC= t3.ACCODIGO(+) AND t1.ATCOCM= t4.S4CODIGO(+) AND t1.ATCOES= t5.ESCODIGO(+) AND t1.ATCOPS= t6.PSCODIGO(+) AND t1.ATCOHD= t7.S6CODIGO(+) AND t1.ATCOAL= t8.S5CODIGO(+) AND t1.ATCOTTA= t9.TTACODIGO(+) AND t1.ATCOTMA= t10.TMACODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ATCODIGO ATCODIGO,t1.ATNROR ATNROR,t1.ATCOAV ATCOAV,t1.ATCOSE ATCOSE,t1.ATNOPRSE ATNOPRSE,t1.ATNOMAPS ATNOMAPS,t1.ATNOMOPS ATNOMOPS,t1.ATNRLOPS ATNRLOPS,t1.ATFEDUMI ATFEDUMI,t1.ATINPRSE ATINPRSE,t1.ATCAUNEP ATCAUNEP,t1.ATCOAT ATCOAT,t2.TPCODIGO TIPPROTOCOLOTPCODIGO,t2.TPNOMBRE TIPPROTOCOLOTPNOMBRE,t2.TPCOTMO TIPPROTOCOLOTPCOTMO,t3.ACCODIGO ACTAACCODIGO,t3.ACCOOR ACTAACCOOR,t3.ACNROR ACTAACNROR,t3.ACNRAN ACTAACNRAN,t3.ACFELE ACTAACFELE,t3.ACFERE ACTAACFERE,t3.ACCOAV ACTAACCOAV,t3.ACCOSE ACTAACCOSE,t3.ACFEEX ACTAACFEEX,t3.ACINRE ACTAACINRE,t3.ACNOCO ACTAACNOCO,t3.ACAPE1CO ACTAACAPE1CO,t3.ACAPE2CO ACTAACAPE2CO,t3.ACDNICO ACTAACDNICO,t3.ACCOCO ACTAACCOCO,t3.ACDIRCO ACTAACDIRCO,t3.ACCOLOCO ACTAACCOLOCO,t3.ACNRCPCO ACTAACNRCPCO,t3.ACNRTFCO ACTAACNRTFCO,t3.ACNORA_PAIS_ID ACTAACNORAPAISID,t3.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t3.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t3.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t3.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t3.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t3.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t3.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t3.ACNORA_CALLE_ID ACTAACNORACALLEID,t3.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t3.ACNORA_CP_ID ACTAACNORACPID,t3.ACNOMBRE_CP ACTAACNOMBRECP,t3.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t3.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t3.ACNOMBRE_PISO ACTAACNOMBREPISO, t3.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV,t4.S4CODIGO S4CODIGO,t4.S4CODORGANISMO S4CODORGANISMO,t4.S4FECCOMUNICACION S4FECCOMUNICACION,t4.S4FECFINALIZACION S4FECFINALIZACION,t4.S4CANTIDADACTUACIONES S4CANTIDADACTUACIONES,t5.ESCODIGO ESTABLECIMIENTOESCODIGO,t5.ESNOMBRE ESTABLECIMIENTOESNOMBRE,t5.ESNIF ESTABLECIMIENTOESNIF,t5.ESNOAN ESTABLECIMIENTOESNOAN,t5.ESNOCO ESTABLECIMIENTOESNOCO,t5.ESNODIR ESTABLECIMIENTOESNODIR,t5.ESCOLO ESTABLECIMIENTOESCOLO,t5.ESNRCOPO ESTABLECIMIENTOESNRCOPO,t5.ESNRTEL ESTABLECIMIENTOESNRTEL,t5.ESNRFAX ESTABLECIMIENTOESNRFAX,t5.ESCOPA ESTABLECIMIENTOESCOPA,t5.ESINCAPR ESTABLECIMIENTOESINCAPR,t5.ESINDEMP ESTABLECIMIENTOESINDEMP,t5.ESTECO ESTABLECIMIENTOESTECO,t5.ESINADAR ESTABLECIMIENTOESINADAR,t5.ESFEADAR ESTABLECIMIENTOESFEADAR,t5.ESCOEM ESTABLECIMIENTOESCOEM,t5.ESINEMPR ESTABLECIMIENTOESINEMPR,t5.ESNRTEL2 ESTABLECIMIENTOESNRTEL2,t5.ESFEBA ESTABLECIMIENTOESFEBA,t5.ESNOAP1 ESTABLECIMIENTOESNOAP1,t5.ESNOAP2 ESTABLECIMIENTOESNOAP2,t5.ESNOLO ESTABLECIMIENTOESNOLO,t5.ESCOMAPV ESTABLECIMIENTOESCOMAPV,t5.ESCOCA ESTABLECIMIENTOESCOCA,t5.ESNOPECO ESTABLECIMIENTOESNOPECO,t5.ESCOIDCO ESTABLECIMIENTOESCOIDCO,t5.ESINRECO ESTABLECIMIENTOESINRECO,t5.ESFEMOD ESTABLECIMIENTOESFEMOD,t5.ESINESCO ESTABLECIMIENTOESINESCO,t5.ESNOMU ESTABLECIMIENTOESNOMU,t5.ESNOREP ESTABLECIMIENTOESNOREP,t5.ESNIFREP ESTABLECIMIENTOESNIFREP,t5.DTTEEMR ESTABLECIMIENTODTTEEMR,t5.ESCAREP ESTABLECIMIENTOESCAREP,t5.ESTEURL ESTABLECIMIENTOESTEURL,t5.ESCOOE ESTABLECIMIENTOESCOOE,t5.ESNODECO ESTABLECIMIENTOESNODECO,t5.ESINTIAR ESTABLECIMIENTOESINTIAR,t5.ESFEPLAD ESTABLECIMIENTOESFEPLAD,t5.ESINDEME ESTABLECIMIENTOESINDEME,t5.ESNORA_PAIS_ID ESTABLEESNORAPAISID,t5.ESNORA_PAIS_NOMBRE ESTABLEESNORAPAISNOMBRE,t5.ESNORA_PROVINCIA_ID ESTABLEESNORAPROVINCIAID,t5.ESNOMBRE_PROVINCIA ESTABLEESNOMBREPROVINCIA,t5.ESNORA_MUNICIPIO_ID ESTABLEESNORAMUNICIPIOID,t5.ESNOMBRE_MUNICIPIO ESTABLEESNOMBREMUNICIPIO,t5.ESNORA_LOCALIDAD_ID ESTABLEESNORALOCALIDADID,t5.ESNOMBRE_LOCALIDAD ESTABLEESNOMBRELOCALIDAD,t5.ESNORA_CALLE_ID ESTABLECIMIENTOESNORACALLEID,t5.ESNOMBRE_CALLE ESTABLECIMIENTOESNOMBRECALLE,t5.ESNORA_CP_ID ESTABLECIMIENTOESNORACPID,t5.ESNOMBRE_CP ESTABLECIMIENTOESNOMBRECP,t5.ESNORA_PORTAL_ID ESTABLECIMIENTOESNORAPORTALID,t5.ESNOMBRE_PORTAL ESTABLECIMIENTOESNOMBREPORTAL,t5.ESNOMBRE_PISO ESTABLECIMIENTOESNOMBREPISO,t5.ESDIRECCION_NOCAPV ESTABLEESDIRECCION_NOCAPV, t5.ESEXTRANJERO EstableESEXTRANJERO, t6.PSCODIGO PRODUCTOPSCODIGO,t6.PSNOMBRE PRODUCTOPSNOMBRE,t6.PSNOCO PRODUCTOPSNOCO,t6.PSDESCRI PRODUCTOPSDESCRI,t6.PSCOSE PRODUCTOPSCOSE,t6.PSNOMBREE PRODUCTOPSNOMBREE,t6.PSNOMBREI PRODUCTOPSNOMBREI,t6.PSNOMBREF PRODUCTOPSNOMBREF,t6.PSNOMBREA PRODUCTOPSNOMBREA,t6.PSNOCOE PRODUCTOPSNOCOE,t6.PSNOCOI PRODUCTOPSNOCOI,t6.PSNOCOF PRODUCTOPSNOCOF,t6.PSNOCOA PRODUCTOPSNOCOA,t6.PSDESCRIE PRODUCTOPSDESCRIE,t6.PSDESCRII PRODUCTOPSDESCRII,t6.PSDESCRIF PRODUCTOPSDESCRIF,t6.PSDESCRIA PRODUCTOPSDESCRIA,t6.PSSEL1 PRODUCTOPSSEL1,t6.PSCOINC PRODUCTOPSCOINC,t7.S6CODIGO S6CODIGO,t7.S6CODORGANISMO S6CODORGANISMO,t7.S6FECCOMUNICACION S6FECCOMUNICACION,t7.S6FECFINALIZACION S6FECFINALIZACION,t7.S6CANTIDADACTUACIONES S6CANTIDADACTUACIONES,t8.S5CODIGO S5CODIGO,t8.S5CODORGANISMO S5CODORGANISMO,t8.S5FECCOMUNICACION S5FECCOMUNICACION,t8.S5FECFINALIZACION S5FECFINALIZACION,t8.S5CANTIDADACTUACIONES S5CANTIDADACTUACIONES,t9.TTACODIGO TIPACTUACIONTTACODIGO,t9.TTANOMBRE TIPACTUACIONTTANOMBRE,t10.TMACODIGO TIPMOTACTUACIONTMACODIGO,t10.TMANOMBRE TIPMOTACTUACIONTMANOMBRE,t2.TPCOCM TIPPROTOCOLOTPCOCM,t3.ACCOINDO ACTAACCOINDO,t3.ACCOINUN ACTAACCOINUN,t3.ACCOTD ACTAACCOTD,t3.ACCOES ACTAACCOES,t4.S4CODCAMPANHA S4CODCAMPANHA,t5.ESCOZS ESTABLECIMIENTOESCOZS,t6.PSCOE8 PRODUCTOPSCOE8,t7.S6CODHECDEN S6CODHECDEN,t8.S5CODALERTA S5CODALERTA,t8.S5CARACTERALERTA S5CARACTERALERTA "
						+ "FROM ACTUACION t1 ,TIP_PROTOCOLO t2 ,ACTA t3 ,CAMPAHNA_RECIB t4 ,ESTABLECIMIENTO t5 ,PRODUCTO t6 ,DENUNCIA_RECIB t7 ,ALERTA_RECIB t8 ,TIP_ACTUACION t9 ,TIPMOT_ACTUACION t10 ");

		if (actuacion != null && actuacion.getAtcodigo() != null) {
			where.append(" AND UPPER(t1.ATCODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcodigo().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcodigo() != null) {
			where.append(" AND t2.TPCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipProtocolo().getTpcodigo() + "%");
			} else {
				params.add("%" + actuacion.getTipProtocolo().getTpcodigo()
						+ "%");
			}
			where.append(" AND t2.TPCODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getCampanha() != null
				&& actuacion.getTipProtocolo().getCampanha().getCmcodigo() != null) {
			where.append(" AND UPPER(t2.TPCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipProtocolo().getCampanha()
						.getCmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getTipProtocolo().getCampanha()
								.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOCM IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpnombre() != null) {
			where.append(" AND UPPER(t2.TPNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipProtocolo().getTpnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getTipProtocolo().getTpnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TPNOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipProtocolo() != null
				&& actuacion.getTipProtocolo().getTpcotmo() != null) {
			where.append(" AND UPPER(t2.TPCOTMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipProtocolo().getTpcotmo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getTipProtocolo().getTpcotmo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.TPCOTMO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccodigo() != null) {
			where.append(" AND t3.ACCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccodigo() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccodigo() + "%");
			}
			where.append(" AND t3.ACCODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoindo() != null
				&& actuacion.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND UPPER(t3.ACCOINDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getInspectorByAccoindo()
						.getIncodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getInspectorByAccoindo()
								.getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ACCOINDO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getInspectorByAccoinun() != null
				&& actuacion.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND UPPER(t3.ACCOINUN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getInspectorByAccoinun()
						.getIncodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getInspectorByAccoinun()
								.getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ACCOINUN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getTipodoc() != null
				&& actuacion.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND UPPER(t3.ACCOTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getTipodoc().getTdcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getTipodoc().getTdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACCOTD IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getActa() != null
				&& actuacion.getActa().getEstablecimiento() != null
				&& actuacion.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t3.ACCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t3.ACCOES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoor() != null) {
			where.append(" AND UPPER(t3.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACCOOR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnror() != null) {
			where.append(" AND UPPER(t3.ACNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnror().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNROR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnran() != null) {
			where.append(" AND t3.ACNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnran() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnran() + "%");
			}
			where.append(" AND t3.ACNRAN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfele() != null) {
			where.append(" AND t3.ACFELE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcfele() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcfele() + "%");
			}
			where.append(" AND t3.ACFELE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfere() != null) {
			where.append(" AND t3.ACFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcfere() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcfere() + "%");
			}
			where.append(" AND t3.ACFERE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoav() != null) {
			where.append(" AND UPPER(t3.ACCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoav().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoav().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACCOAV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccose() != null) {
			where.append(" AND UPPER(t3.ACCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccose().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccose().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACCOSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcfeex() != null) {
			where.append(" AND t3.ACFEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcfeex() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcfeex() + "%");
			}
			where.append(" AND t3.ACFEEX IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcinre() != null) {
			where.append(" AND UPPER(t3.ACINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcinre().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACINRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoco() != null) {
			where.append(" AND UPPER(t3.ACNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape1co() != null) {
			where.append(" AND UPPER(t3.ACAPE1CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcape1co().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcape1co().toUpperCase() + "%");
			}
			where.append(" AND t3.ACAPE1CO IS NOT NULL");
		}

		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcape2co() != null) {
			where.append(" AND UPPER(t3.ACAPE2CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcape2co().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcape2co().toUpperCase() + "%");
			}
			where.append(" AND t3.ACAPE2CO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdnico() != null) {
			where.append(" AND UPPER(t3.ACDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcdnico().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcdnico().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACDNICO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoco() != null) {
			where.append(" AND UPPER(t3.ACCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAccoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACCOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcdirco() != null) {
			where.append(" AND UPPER(t3.ACDIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcdirco().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getActa().getAcdirco().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACDIRCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAccoloco() != null) {
			where.append(" AND UPPER(t3.ACCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAccoloco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAccoloco().toUpperCase() + "%");
			}
			where.append(" AND t3.ACCOLOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrcpco() != null) {
			where.append(" AND UPPER(t3.ACNRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnrcpco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnrcpco().toUpperCase() + "%");
			}
			where.append(" AND t3.ACNRCPCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnrtfco() != null) {
			where.append(" AND UPPER(t3.ACNRTFCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnrtfco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnrtfco().toUpperCase() + "%");
			}
			where.append(" AND t3.ACNRTFCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisId() != null) {
			where.append(" AND UPPER(t3.ACNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPaisId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraPaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t3.ACNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND UPPER(t3.ACNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND UPPER(t3.ACNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND UPPER(t3.ACNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCalleId() != null) {
			where.append(" AND UPPER(t3.ACNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraCalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCalle() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreCalle().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraCpId() != null) {
			where.append(" AND UPPER(t3.ACNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraCpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNORA_CP_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombreCp() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombreCp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNOMBRE_CP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnoraPortalId() != null) {
			where.append(" AND UPPER(t3.ACNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePortal() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getActa() != null
				&& actuacion.getActa().getAcnombrePiso() != null) {
			where.append(" AND UPPER(t3.ACNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getActa().getAcnombrePiso().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getActa().getAcnombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t3.ACNOMBRE_PISO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codigo() != null) {
			where.append(" AND t4.S4CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib().getS4codigo() + "%");
			} else {
				params.add("%" + actuacion.getCampahnaRecib().getS4codigo()
						+ "%");
			}
			where.append(" AND t4.S4CODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getCampanha() != null
				&& actuacion.getCampahnaRecib().getCampanha().getCmcodigo() != null) {
			where.append(" AND UPPER(t4.S4CODCAMPANHA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib().getCampanha()
						.getCmcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getCampahnaRecib().getCampanha()
								.getCmcodigo().toUpperCase() + "%");
			}
			where.append(" AND t4.S4CODCAMPANHA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4codorganismo() != null) {
			where.append(" AND UPPER(t4.S4CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib().getS4codorganismo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getCampahnaRecib().getS4codorganismo()
								.toUpperCase() + "%");
			}
			where.append(" AND t4.S4CODORGANISMO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4feccomunicacion() != null) {
			where.append(" AND t4.S4FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib().getS4feccomunicacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getCampahnaRecib().getS4feccomunicacion()
						+ "%");
			}
			where.append(" AND t4.S4FECCOMUNICACION IS NOT NULL");
		}
		if (actuacion != null && actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4fecfinalizacion() != null) {
			where.append(" AND t4.S4FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib().getS4fecfinalizacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getCampahnaRecib().getS4fecfinalizacion()
						+ "%");
			}
			where.append(" AND t4.S4FECFINALIZACION IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getCampahnaRecib() != null
				&& actuacion.getCampahnaRecib().getS4cantidadactuaciones() != null) {
			where.append(" AND t4.S4CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getCampahnaRecib()
						.getS4cantidadactuaciones() + "%");
			} else {
				params.add("%"
						+ actuacion.getCampahnaRecib()
								.getS4cantidadactuaciones() + "%");
			}
			where.append(" AND t4.S4CANTIDADACTUACIONES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t5.ESCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscodigo() + "%");
			} else {
				params.add("%" + actuacion.getEstablecimiento().getEscodigo()
						+ "%");
			}
			where.append(" AND t5.ESCODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getCensoMonitor() != null
				&& actuacion.getEstablecimiento().getCensoMonitor()
						.getMocodigo() != null) {
			where.append(" AND UPPER(t5.ESCOZS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getCensoMonitor()
						.getMocodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getCensoMonitor()
								.getMocodigo().toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOZS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombre() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnif() != null) {
			where.append(" AND UPPER(t5.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnif()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnif()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNIF IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoan() != null) {
			where.append(" AND UPPER(t5.ESNOAN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoan()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoan()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOAN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoco() != null) {
			where.append(" AND UPPER(t5.ESNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodir() != null) {
			where.append(" AND UPPER(t5.ESNODIR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnodir()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnodir()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNODIR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscolo() != null) {
			where.append(" AND UPPER(t5.ESCOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscolo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscolo()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOLO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrcopo() != null) {
			where.append(" AND UPPER(t5.ESNRCOPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnrcopo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnrcopo()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNRCOPO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel() != null) {
			where.append(" AND UPPER(t5.ESNRTEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnrtel()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnrtel()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNRTEL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrfax() != null) {
			where.append(" AND UPPER(t5.ESNRFAX) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnrfax()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnrfax()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNRFAX IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscopa() != null) {
			where.append(" AND UPPER(t5.ESCOPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscopa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscopa()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOPA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsincapr() != null) {
			where.append(" AND UPPER(t5.ESINCAPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsincapr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsincapr()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINCAPR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindemp() != null) {
			where.append(" AND UPPER(t5.ESINDEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsindemp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsindemp()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINDEMP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteco() != null) {
			where.append(" AND UPPER(t5.ESTECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsteco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsteco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESTECO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinadar() != null) {
			where.append(" AND UPPER(t5.ESINADAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsinadar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsinadar()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINADAR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeadar() != null) {
			where.append(" AND t5.ESFEADAR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsfeadar() + "%");
			} else {
				params.add("%" + actuacion.getEstablecimiento().getEsfeadar()
						+ "%");
			}
			where.append(" AND t5.ESFEADAR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoem() != null) {
			where.append(" AND UPPER(t5.ESCOEM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscoem()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscoem()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOEM IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinempr() != null) {
			where.append(" AND UPPER(t5.ESINEMPR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsinempr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsinempr()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINEMPR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnrtel2() != null) {
			where.append(" AND UPPER(t5.ESNRTEL2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnrtel2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnrtel2()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNRTEL2 IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeba() != null) {
			where.append(" AND t5.ESFEBA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsfeba() + "%");
			} else {
				params.add("%" + actuacion.getEstablecimiento().getEsfeba()
						+ "%");
			}
			where.append(" AND t5.ESFEBA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap1() != null) {
			where.append(" AND UPPER(t5.ESNOAP1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoap1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoap1()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOAP1 IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoap2() != null) {
			where.append(" AND UPPER(t5.ESNOAP2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoap2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoap2()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOAP2 IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnolo() != null) {
			where.append(" AND UPPER(t5.ESNOLO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnolo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnolo()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOLO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscomapv() != null) {
			where.append(" AND UPPER(t5.ESCOMAPV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscomapv()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscomapv()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOMAPV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoca() != null) {
			where.append(" AND UPPER(t5.ESCOCA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscoca()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscoca()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOCA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnopeco() != null) {
			where.append(" AND UPPER(t5.ESNOPECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnopeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnopeco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOPECO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscoidco() != null) {
			where.append(" AND UPPER(t5.ESCOIDCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscoidco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscoidco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOIDCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinreco() != null) {
			where.append(" AND UPPER(t5.ESINRECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsinreco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsinreco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINRECO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfemod() != null) {
			where.append(" AND UPPER(t5.ESFEMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsfemod()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsfemod()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESFEMOD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsinesco() != null) {
			where.append(" AND UPPER(t5.ESINESCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsinesco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsinesco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINESCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnomu() != null) {
			where.append(" AND UPPER(t5.ESNOMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnomu()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnomu()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMU IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnorep() != null) {
			where.append(" AND UPPER(t5.ESNOREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnorep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnorep()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOREP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnifrep() != null) {
			where.append(" AND UPPER(t5.ESNIFREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnifrep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnifrep()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNIFREP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getDtteemr() != null) {
			where.append(" AND UPPER(t5.DTTEEMR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getDtteemr()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getDtteemr()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.DTTEEMR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscarep() != null) {
			where.append(" AND UPPER(t5.ESCAREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscarep()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscarep()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCAREP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsteurl() != null) {
			where.append(" AND UPPER(t5.ESTEURL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsteurl()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsteurl()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESTEURL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEscooe() != null) {
			where.append(" AND UPPER(t5.ESCOOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEscooe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEscooe()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESCOOE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnodeco() != null) {
			where.append(" AND UPPER(t5.ESNODECO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnodeco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnodeco()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNODECO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsintiar() != null) {
			where.append(" AND UPPER(t5.ESINTIAR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsintiar()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsintiar()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINTIAR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsfeplad() != null) {
			where.append(" AND t5.ESFEPLAD like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsfeplad() + "%");
			} else {
				params.add("%" + actuacion.getEstablecimiento().getEsfeplad()
						+ "%");
			}
			where.append(" AND t5.ESFEPLAD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsindeme() != null) {
			where.append(" AND UPPER(t5.ESINDEME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsindeme()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsindeme()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESINDEME IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoraPaisId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraPaisId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PAIS_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPaisNombre() != null) {
			where.append(" AND UPPER(t5.ESNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraProvinciaId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnoraProvinciaId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreProvincia() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnombreProvincia().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraMunicipioId() != null) {
			where.append(" AND UPPER(t5.ESNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnoraMunicipioId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreMunicipio() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnombreMunicipio().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraLocalidadId() != null) {
			where.append(" AND UPPER(t5.ESNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnoraLocalidadId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreLocalidad() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento()
						.getEsnombreLocalidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCalleId() != null) {
			where.append(" AND UPPER(t5.ESNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoraCalleId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraCalleId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_CALLE_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCalle() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnombreCalle()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombreCalle()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_CALLE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraCpId() != null) {
			where.append(" AND UPPER(t5.ESNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoraCpId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraCpId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_CP_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombreCp() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnombreCp()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombreCp()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_CP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnoraPortalId() != null) {
			where.append(" AND UPPER(t5.ESNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnoraPortalId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnoraPortalId()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNORA_PORTAL_ID IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePortal() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnombrePortal()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombrePortal()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PORTAL IS NOT NULL");
		}
		if (actuacion != null && actuacion.getEstablecimiento() != null
				&& actuacion.getEstablecimiento().getEsnombrePiso() != null) {
			where.append(" AND UPPER(t5.ESNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getEstablecimiento().getEsnombrePiso()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getEstablecimiento().getEsnombrePiso()
								.toUpperCase() + "%");
			}
			where.append(" AND t5.ESNOMBRE_PISO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscodigo() != null) {
			where.append(" AND t6.PSCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPscodigo() + "%");
			} else {
				params.add("%" + actuacion.getProducto().getPscodigo() + "%");
			}
			where.append(" AND t6.PSCODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getProducto() != null
				&& actuacion.getProducto().getProdAgrupado() != null
				&& actuacion.getProducto().getProdAgrupado().getE8codigo() != null) {
			where.append(" AND UPPER(t6.PSCOE8) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getProdAgrupado()
						.getE8codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getProdAgrupado()
								.getE8codigo().toUpperCase() + "%");
			}
			where.append(" AND t6.PSCOE8 IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombre() != null) {
			where.append(" AND UPPER(t6.PSNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnombre().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnombre().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnoco() != null) {
			where.append(" AND UPPER(t6.PSNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnoco().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOCO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescri() != null) {
			where.append(" AND UPPER(t6.PSDESCRI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsdescri().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsdescri().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSDESCRI IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscose() != null) {
			where.append(" AND UPPER(t6.PSCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPscose().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPscose().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSCOSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombree() != null) {
			where.append(" AND UPPER(t6.PSNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnombree().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnombree().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOMBREE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrei() != null) {
			where.append(" AND UPPER(t6.PSNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnombrei().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnombrei().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOMBREI IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombref() != null) {
			where.append(" AND UPPER(t6.PSNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnombref().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnombref().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOMBREF IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnombrea() != null) {
			where.append(" AND UPPER(t6.PSNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnombrea().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnombrea().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOMBREA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoe() != null) {
			where.append(" AND UPPER(t6.PSNOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnocoe().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnocoe().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOCOE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoi() != null) {
			where.append(" AND UPPER(t6.PSNOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnocoi().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnocoi().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOCOI IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocof() != null) {
			where.append(" AND UPPER(t6.PSNOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnocof().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnocof().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOCOF IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsnocoa() != null) {
			where.append(" AND UPPER(t6.PSNOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsnocoa().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsnocoa().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSNOCOA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrie() != null) {
			where.append(" AND UPPER(t6.PSDESCRIE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsdescrie().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsdescrie().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSDESCRIE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrii() != null) {
			where.append(" AND UPPER(t6.PSDESCRII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsdescrii().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsdescrii().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSDESCRII IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescrif() != null) {
			where.append(" AND UPPER(t6.PSDESCRIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsdescrif().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsdescrif().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSDESCRIF IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPsdescria() != null) {
			where.append(" AND UPPER(t6.PSDESCRIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPsdescria().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPsdescria().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSDESCRIA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPssel1() != null) {
			where.append(" AND UPPER(t6.PSSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPssel1().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPssel1().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSSEL1 IS NOT NULL");
		}
		if (actuacion != null && actuacion.getProducto() != null
				&& actuacion.getProducto().getPscoinc() != null) {
			where.append(" AND UPPER(t6.PSCOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getProducto().getPscoinc().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getProducto().getPscoinc().toUpperCase()
						+ "%");
			}
			where.append(" AND t6.PSCOINC IS NOT NULL");
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codigo() != null) {
			where.append(" AND t7.S6CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib().getS6codigo() + "%");
			} else {
				params.add("%" + actuacion.getDenunciaRecib().getS6codigo()
						+ "%");
			}
			where.append(" AND t7.S6CODIGO IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado() != null
				&& actuacion.getDenunciaRecib().getHechoDenunciado()
						.getHdcodigo() != null) {
			where.append(" AND UPPER(t7.S6CODHECDEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib().getHechoDenunciado()
						.getHdcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getDenunciaRecib().getHechoDenunciado()
								.getHdcodigo().toUpperCase() + "%");
			}
			where.append(" AND t7.S6CODHECDEN IS NOT NULL");
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6codorganismo() != null) {
			where.append(" AND UPPER(t7.S6CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib().getS6codorganismo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getDenunciaRecib().getS6codorganismo()
								.toUpperCase() + "%");
			}
			where.append(" AND t7.S6CODORGANISMO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6feccomunicacion() != null) {
			where.append(" AND t7.S6FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib().getS6feccomunicacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getDenunciaRecib().getS6feccomunicacion()
						+ "%");
			}
			where.append(" AND t7.S6FECCOMUNICACION IS NOT NULL");
		}
		if (actuacion != null && actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6fecfinalizacion() != null) {
			where.append(" AND t7.S6FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib().getS6fecfinalizacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getDenunciaRecib().getS6fecfinalizacion()
						+ "%");
			}
			where.append(" AND t7.S6FECFINALIZACION IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getDenunciaRecib() != null
				&& actuacion.getDenunciaRecib().getS6cantidadactuaciones() != null) {
			where.append(" AND t7.S6CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getDenunciaRecib()
						.getS6cantidadactuaciones() + "%");
			} else {
				params.add("%"
						+ actuacion.getDenunciaRecib()
								.getS6cantidadactuaciones() + "%");
			}
			where.append(" AND t7.S6CANTIDADACTUACIONES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t8.S5CODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getS5codigo() + "%");
			} else {
				params.add("%" + actuacion.getAlertaRecib().getS5codigo() + "%");
			}
			where.append(" AND t8.S5CODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getAlerta() != null
				&& actuacion.getAlertaRecib().getAlerta().getAlcodigo() != null) {
			where.append(" AND UPPER(t8.S5CODALERTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getAlerta().getAlcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getAlerta().getAlcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t8.S5CODALERTA IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta() != null
				&& actuacion.getAlertaRecib().getCaracterAlerta().getCrcodigo() != null) {
			where.append(" AND UPPER(t8.S5CARACTERALERTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getCaracterAlerta()
						.getCrcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getCaracterAlerta()
								.getCrcodigo().toUpperCase() + "%");
			}
			where.append(" AND t8.S5CARACTERALERTA IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5codorganismo() != null) {
			where.append(" AND UPPER(t8.S5CODORGANISMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getS5codorganismo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getS5codorganismo()
								.toUpperCase() + "%");
			}
			where.append(" AND t8.S5CODORGANISMO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5feccomunicacion() != null) {
			where.append(" AND t8.S5FECCOMUNICACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getS5feccomunicacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getS5feccomunicacion()
						+ "%");
			}
			where.append(" AND t8.S5FECCOMUNICACION IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5fecfinalizacion() != null) {
			where.append(" AND t8.S5FECFINALIZACION like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib().getS5fecfinalizacion()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getS5fecfinalizacion()
						+ "%");
			}
			where.append(" AND t8.S5FECFINALIZACION IS NOT NULL");
		}
		if (actuacion != null
				&& actuacion.getAlertaRecib() != null
				&& actuacion.getAlertaRecib().getS5cantidadactuaciones() != null) {
			where.append(" AND t8.S5CANTIDADACTUACIONES like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAlertaRecib()
						.getS5cantidadactuaciones() + "%");
			} else {
				params.add("%"
						+ actuacion.getAlertaRecib().getS5cantidadactuaciones()
						+ "%");
			}
			where.append(" AND t8.S5CANTIDADACTUACIONES IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtacodigo() != null) {
			where.append(" AND t9.TTACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipActuacion().getTtacodigo() + "%");
			} else {
				params.add("%" + actuacion.getTipActuacion().getTtacodigo()
						+ "%");
			}
			where.append(" AND t9.TTACODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipActuacion() != null
				&& actuacion.getTipActuacion().getTtanombre() != null) {
			where.append(" AND UPPER(t9.TTANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipActuacion().getTtanombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getTipActuacion().getTtanombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t9.TTANOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmacodigo() != null) {
			where.append(" AND t10.TMACODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipmotActuacion().getTmacodigo() + "%");
			} else {
				params.add("%" + actuacion.getTipmotActuacion().getTmacodigo()
						+ "%");
			}
			where.append(" AND t10.TMACODIGO IS NOT NULL");
		}
		if (actuacion != null && actuacion.getTipmotActuacion() != null
				&& actuacion.getTipmotActuacion().getTmanombre() != null) {
			where.append(" AND UPPER(t10.TMANOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getTipmotActuacion().getTmanombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacion.getTipmotActuacion().getTmanombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t10.TMANOMBRE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnror() != null) {
			where.append(" AND t1.ATNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnror() + "%");
			} else {
				params.add("%" + actuacion.getAtnror() + "%");
			}
			where.append(" AND t1.ATNROR IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoav() != null) {
			where.append(" AND UPPER(t1.ATCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoav().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoav().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOAV IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcose() != null) {
			where.append(" AND UPPER(t1.ATCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcose().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcose().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnoprse() != null) {
			where.append(" AND UPPER(t1.ATNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnoprse().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnoprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOPRSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnomaps() != null) {
			where.append(" AND UPPER(t1.ATNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnomaps().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnomaps().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOMAPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnomops() != null) {
			where.append(" AND UPPER(t1.ATNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnomops().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnomops().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNOMOPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtnrlops() != null) {
			where.append(" AND UPPER(t1.ATNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtnrlops().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtnrlops().toUpperCase() + "%");
			}
			where.append(" AND t1.ATNRLOPS IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtfedumi() != null) {
			where.append(" AND t1.ATFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtfedumi() + "%");
			} else {
				params.add("%" + actuacion.getAtfedumi() + "%");
			}
			where.append(" AND t1.ATFEDUMI IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtinprse() != null) {
			where.append(" AND UPPER(t1.ATINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtinprse().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtinprse().toUpperCase() + "%");
			}
			where.append(" AND t1.ATINPRSE IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcaunep() != null) {
			where.append(" AND t1.ATCAUNEP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcaunep() + "%");
			} else {
				params.add("%" + actuacion.getAtcaunep() + "%");
			}
			where.append(" AND t1.ATCAUNEP IS NOT NULL");
		}
		if (actuacion != null && actuacion.getAtcoat() != null) {
			where.append(" AND UPPER(t1.ATCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacion.getAtcoat().toUpperCase() + "%");
			} else {
				params.add("%" + actuacion.getAtcoat().toUpperCase() + "%");
			}
			where.append(" AND t1.ATCOAT IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<Actuacion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<CampahnaActuacionBusqueda> findAllCampahnaActuacion(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ATCOAC = t2.ACCODIGO AND t1.ATCOES= t3.ESCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.ATCODIGO ATCODIGO, t2.ACCODIGO ACCODIGO, t2.ACCOOR ACCOOR, t2.ACNROR ACNROR, t2.ACNRAN ACNRAN, t1.ATNROR ATNROR, t2.ACFELE ACFELE, t3.ESCODIGO ESCODIGO, t3.ESNOMBRE ESNOMBRE, t3.ESNIF ESNIF, t3.ESNOCO ESNOCO, t1.ATCOCM ATCOCM, t1.ATCOHD ATCOHD, t1.ATCOAL ATCOAL "
						+ "FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3 ");

		// Campaña
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(campahnaActuacionBusqueda.getAtcocm());
		}

		// Denuncia
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcohd() != null) {
			where.append(" AND t1.ATCOHD = ?");
			params.add(campahnaActuacionBusqueda.getAtcohd());
		}

		// Alerta
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcoal() != null) {
			where.append(" AND t1.ATCOAL = ?");
			params.add(campahnaActuacionBusqueda.getAtcoal());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<CampahnaActuacionBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<CampahnaActuacionBusqueda>() {
					public CampahnaActuacionBusqueda mapRow(
							ResultSet resultSet, int rowNum)
							throws SQLException {
						return new CampahnaActuacionBusqueda(resultSet
								.getString("ATCODIGO"), resultSet
								.getBigDecimal("ATNROR"), resultSet
								.getString("ACCODIGO"), resultSet
								.getString("ACCOOR"), resultSet
								.getString("ACNROR"), resultSet
								.getBigDecimal("ACNRAN"), resultSet
								.getDate("ACFELE"), resultSet
								.getString("ESCODIGO"), resultSet
								.getString("ESNOMBRE"), resultSet
								.getString("ESNIF"), resultSet
								.getString("ESNOCO"), null, null, null, null,
								resultSet.getString("ATCOCM"), resultSet
										.getString("ATCOAL"), resultSet
										.getString("ATCOHD"));
					}
				}, params.toArray());
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCampahnaActuacionCount(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ATCOAC = t2.ACCODIGO AND t1.ATCOES= t3.ESCODIGO ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3  ");
		// Campaña
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcocm() != null) {
			where.append(" AND t1.ATCOCM = ?");
			params.add(campahnaActuacionBusqueda.getAtcocm());
		}

		// Denuncia
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcohd() != null) {
			where.append(" AND t1.ATCOHD = ?");
			params.add(campahnaActuacionBusqueda.getAtcohd());
		}

		// Alerta
		if (campahnaActuacionBusqueda != null
				&& campahnaActuacionBusqueda.getAtcoal() != null) {
			where.append(" AND t1.ATCOAL = ?");
			params.add(campahnaActuacionBusqueda.getAtcoal());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActuacionBusqueda> findAllLikeActuacion(
			ActuacionBusqueda actuacionBusqueda, Pagination pagination,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(300);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ATCOAC = t2.ACCODIGO AND t1.ATCOES = t3actuacion.ESCODIGO AND t2.ACCOES = t3visita.ESCODIGO AND t3visita.ESCODIGO = t4visita.EACOES(+) AND t3actuacion.ESCODIGO = t4actuacion.EACOES(+) ");

		StringBuffer query = new StringBuffer(300);
		query.append(" SELECT  t1.ATCODIGO AS ATCODIGO");
		query.append(" ,t2.ACCODIGO AS ACCODIGO ");
		query.append(" ,t2.ACCOOR AS ACCOOR ");
		query.append(" ,t2.ACNROR AS ACNROR ");
		query.append(" ,t2.ACNRAN AS ACNRAN ");
		query.append(" ,t1.ATNROR AS ATNROR ");
		query.append(" ,t2.ACFELE AS ACFELE ");
		query.append(" ,t3visita.ESCODIGO AS ESCODIGOVISITA ");
		query.append(" ,t3visita.ESNOMBRE AS ESNOMBREVISITA ");
		query.append(" ,t3visita.ESNIF AS ESNIFVISITA ");
		query.append(" ,t3visita.ESNOCO AS ESNOCOVISITA ");
		query.append(" ,t3actuacion.ESCODIGO AS ESCODIGOACTUACION ");
		query.append(" ,t3actuacion.ESNOMBRE AS ESNOMBREACTUACION ");
		query.append(" ,t3actuacion.ESNIF AS ESNIFACTUACION ");
		query.append(" ,t3actuacion.ESNOCO AS ESNOCOACTUACION ");
		query.append(" ,t1.ATCOCM AS ATCOCM ");
		query.append(" ,t1.ATCOHD AS ATCOHD ");
		query.append(" ,t1.ATCOAL AS ATCOAL ");

		query.append(" FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3actuacion, ESTABLECIMIENTO t3visita, ");
		query.append(" ESTABLECIM_SECTOR t4visita, ESTABLECIM_SECTOR t4actuacion ");

		// Codigo de organismo
		if (actuacionBusqueda != null && actuacionBusqueda.getAccoor() != null) {
			where.append(" AND t2.ACCOOR = ?");
			params.add(actuacionBusqueda.getAccoor());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAcnror() != null) {
			where.append(" AND t2.ACNROR = ?");
			params.add(actuacionBusqueda.getAcnror());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actuacionBusqueda.getAcnran());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacionBusqueda.getAtnror());
		}

		// Fecha visita
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getAcfeleDesde() != null) {
			where.append(" AND t2.ACFELE >= ?");
			params.add(actuacionBusqueda.getAcfeleDesde());
		}
		// Fecha visita
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getAcfeleHasta() != null) {
			where.append(" AND t2.ACFELE <=  ?");
			params.add(actuacionBusqueda.getAcfeleHasta());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getInspector() != null) {
			where.append(" AND (t2.ACCOINUN = ? OR t2.ACCOINDO = ?) ");
			params.add(actuacionBusqueda.getInspector());
			params.add(actuacionBusqueda.getInspector());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnombreVisita() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3visita.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreVisita().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreVisita().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3visita.ESNOMBRE IS NOT NULL) OR ");

			where.append(" (TRANSLATE(UPPER(t3visita.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreVisita().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreVisita().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3visita.ESNOCO IS NOT NULL)) ");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnifVisita() != null) {
			where.append(" AND UPPER(t3visita.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnifVisita().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnifVisita().toUpperCase()
						+ "%");
			}
			where.append(" AND t3visita.ESNIF IS NOT NULL");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getSecodigoVisita() != null) {
			where.append(" AND t4visita.EACOSE = ?");
			params.add(actuacionBusqueda.getSecodigoVisita());
			where.append(" AND t4visita.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}

		// Tipo actuacion
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getTtacodigo() != null) {
			where.append(" AND t1.ATCOTTA = ?");
			params.add(actuacionBusqueda.getTtacodigo());
		}

		// Tipo motivo
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getTmacodigo() != null) {
			where.append(" AND t1.ATCOTMA = ?");
			params.add(actuacionBusqueda.getTmacodigo());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnombreActuacion() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3actuacion.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreActuacion()
						.toUpperCase().replaceAll("Á", "A")
						.replaceAll("É", "E").replaceAll("Í", "I")
						.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreActuacion()
								.toUpperCase().replaceAll("Á", "A")
								.replaceAll("É", "E").replaceAll("Í", "I")
								.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			}
			where.append(" AND t3actuacion.ESNOMBRE IS NOT NULL) OR ");

			where.append(" (TRANSLATE(UPPER(t3actuacion.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreActuacion()
						.toUpperCase().replaceAll("Á", "A")
						.replaceAll("É", "E").replaceAll("Í", "I")
						.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreActuacion()
								.toUpperCase().replaceAll("Á", "A")
								.replaceAll("É", "E").replaceAll("Í", "I")
								.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			}
			where.append(" AND t3actuacion.ESNOCO IS NOT NULL)) ");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnifActuacion() != null) {
			where.append(" AND UPPER(t3actuacion.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnifActuacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnifActuacion().toUpperCase()
						+ "%");
			}
			where.append(" AND t3actuacion.ESNIF IS NOT NULL");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getSecodigoActuacion() != null) {
			where.append(" AND t4actuacion.EACOSE = ?");
			params.add(actuacionBusqueda.getSecodigoActuacion());
			where.append(" AND t4actuacion.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getPscodigoActuacion() != null) {
			where.append(" AND t1.ATCOPS = ?");
			params.add(actuacionBusqueda.getPscodigoActuacion());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		try {
			return (List<ActuacionBusqueda>) this.jdbcTemplate.query(
					query.toString(), new RowMapper<ActuacionBusqueda>() {
						public ActuacionBusqueda mapRow(ResultSet resultSet,
								int rowNum) throws SQLException {
							return

							new ActuacionBusqueda(resultSet
									.getString("ATCODIGO"), resultSet
									.getBigDecimal("ATNROR"), resultSet
									.getString("ACCODIGO"), resultSet
									.getString("ACCOOR"), resultSet
									.getString("ACNROR"), resultSet
									.getBigDecimal("ACNRAN"), resultSet
									.getDate("ACFELE"), null, null, null,
									resultSet.getString("ESCODIGOVISITA"),
									resultSet.getString("ESNOMBREVISITA"),
									resultSet.getString("ESNIFVISITA"),
									resultSet.getString("ESNOCOVISITA"), null,
									null, null, null, null, null, null,
									resultSet.getString("ESCODIGOACTUACION"),
									resultSet.getString("ESNOMBREACTUACION"),
									resultSet.getString("ESNIFACTUACION"),
									resultSet.getString("ESNOCOACTUACION"),
									null, null, null, null, null, null,
									resultSet.getString("ATCOCM"), resultSet
											.getString("ATCOAL"), resultSet
											.getString("ATCOHD"), null);
						}
					}, params.toArray());

		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeActuacionCount(ActuacionBusqueda actuacionBusqueda,
			Boolean startsWith) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE t1.ATCOAC = t2.ACCODIGO AND t1.ATCOES= t3actuacion.ESCODIGO AND t2.ACCOES= t3visita.ESCODIGO AND t3visita.ESCODIGO= t4visita.EACOES(+) AND t3actuacion.ESCODIGO = t4actuacion.EACOES(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM ACTUACION t1, ACTA t2, ESTABLECIMIENTO t3actuacion, ESTABLECIMIENTO t3visita, ESTABLECIM_SECTOR t4visita, ESTABLECIM_SECTOR t4actuacion ");

		// Codigo de organismo
		if (actuacionBusqueda != null && actuacionBusqueda.getAccoor() != null) {
			where.append(" AND t2.ACCOOR = ?");
			params.add(actuacionBusqueda.getAccoor());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAcnror() != null) {
			where.append(" AND t2.ACNROR = ?");
			params.add(actuacionBusqueda.getAcnror());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actuacionBusqueda.getAcnran());
		}

		if (actuacionBusqueda != null && actuacionBusqueda.getAtnror() != null) {
			where.append(" AND t1.ATNROR = ?");
			params.add(actuacionBusqueda.getAtnror());
		}

		// Fecha visita
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getAcfeleDesde() != null) {
			where.append(" AND t2.ACFELE >= ?");
			params.add(actuacionBusqueda.getAcfeleDesde());
		}
		// Fecha visita
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getAcfeleHasta() != null) {
			where.append(" AND t2.ACFELE <=  ?");
			params.add(actuacionBusqueda.getAcfeleHasta());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getInspector() != null) {
			where.append(" AND (t2.ACCOINUN = ? OR t2.ACCOINDO = ?) ");
			params.add(actuacionBusqueda.getInspector());
			params.add(actuacionBusqueda.getInspector());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnombreVisita() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3visita.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreVisita().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreVisita().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3visita.ESNOMBRE IS NOT NULL) OR ");

			where.append(" (TRANSLATE(UPPER(t3visita.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreVisita().toUpperCase()
						.replaceAll("Á", "A").replaceAll("É", "E")
						.replaceAll("Í", "I").replaceAll("Ó", "O")
						.replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreVisita().toUpperCase()
								.replaceAll("Á", "A").replaceAll("É", "E")
								.replaceAll("Í", "I").replaceAll("Ó", "O")
								.replaceAll("Ú", "U") + "%");
			}
			where.append(" AND t3visita.ESNOCO IS NOT NULL)) ");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnifVisita() != null) {
			where.append(" AND UPPER(t3visita.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnifVisita().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnifVisita().toUpperCase()
						+ "%");
			}
			where.append(" AND t3visita.ESNIF IS NOT NULL");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getSecodigoVisita() != null) {
			where.append(" AND t4visita.EACOSE = ?");
			params.add(actuacionBusqueda.getSecodigoVisita());
			where.append(" AND t4visita.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}

		// Tipo actuacion
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getTtacodigo() != null) {
			where.append(" AND t1.ATCOTTA = ?");
			params.add(actuacionBusqueda.getTtacodigo());
		}

		// Tipo motivo
		if (actuacionBusqueda != null
				&& actuacionBusqueda.getTmacodigo() != null) {
			where.append(" AND t1.ATCOTMA = ?");
			params.add(actuacionBusqueda.getTmacodigo());
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnombreActuacion() != null) {
			where.append(" AND ((TRANSLATE(UPPER(t3actuacion.ESNOMBRE),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreActuacion()
						.toUpperCase().replaceAll("Á", "A")
						.replaceAll("É", "E").replaceAll("Í", "I")
						.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreActuacion()
								.toUpperCase().replaceAll("Á", "A")
								.replaceAll("É", "E").replaceAll("Í", "I")
								.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			}
			where.append(" AND t3actuacion.ESNOMBRE IS NOT NULL) OR ");

			where.append(" (TRANSLATE(UPPER(t3actuacion.ESNOCO),'ÁÉÍÓÚ','AEIOU') like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnombreActuacion()
						.toUpperCase().replaceAll("Á", "A")
						.replaceAll("É", "E").replaceAll("Í", "I")
						.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnombreActuacion()
								.toUpperCase().replaceAll("Á", "A")
								.replaceAll("É", "E").replaceAll("Í", "I")
								.replaceAll("Ó", "O").replaceAll("Ú", "U")
						+ "%");
			}
			where.append(" AND t3actuacion.ESNOCO IS NOT NULL)) ");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getEsnifActuacion() != null) {
			where.append(" AND UPPER(t3actuacion.ESNIF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actuacionBusqueda.getEsnifActuacion().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actuacionBusqueda.getEsnifActuacion().toUpperCase()
						+ "%");
			}
			where.append(" AND t3actuacion.ESNIF IS NOT NULL");
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getSecodigoActuacion() != null) {
			where.append(" AND t4actuacion.EACOSE = ?");
			params.add(actuacionBusqueda.getSecodigoActuacion());
			where.append(" AND t4actuacion.EAINPRSE = ?");
			params.add(Y41aConstantes.SECTOR_ESTABLECIMIENTO_PRIMARIO);
		}

		if (actuacionBusqueda != null
				&& actuacionBusqueda.getPscodigoActuacion() != null) {
			where.append(" AND t1.ATCOPS = ?");
			params.add(actuacionBusqueda.getPscodigoActuacion());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
