package com.ejie.y41a.dao;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.ActaActuacionAlta;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ActuacionBusqueda;
import com.ejie.y41a.model.CampahnaActuacionBusqueda;
import com.ejie.y41a.model.PlantillaCartaInspeccionDetalle;

/**
 * * ActuacionDao generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

public interface ActuacionDao {

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion add(Actuacion actuacion);

	/**
	 * Inserts a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion addActuacion(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion update(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion updateEstablecimiento(Actuacion actuacion);

	/**
	 * Updates a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Pagination
	 * @return Actuacion
	 */
	Actuacion updateTipoProtocoloActuacion(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	Actuacion find(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return ActuacionDetalle
	 */
	ActaActuacionAlta findActuacion(Actuacion actuacion);

	/**
	 * Finds a single row in the Actuacion table.
	 * 
	 * @param plantillaCartaInspeccionDetalle
	 *            PlantillaCartaInspeccionDetalle
	 * @return PlantillaCartaInspeccionDetalle
	 */
	PlantillaCartaInspeccionDetalle findPlantillaCartaInspeccion(
			PlantillaCartaInspeccionDetalle plantillaCartaInspeccionDetalle);

	/**
	 * Deletes a single row in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return
	 */
	void remove(Actuacion actuacion);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAllActuacionEstablecimiento(Actuacion actuacion,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Actuacion> findAll(Actuacion actuacion, Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return List
	 */
	Long findAllCount(Actuacion actuacion);

	/**
	 * Finds rows in the Actuacion table using like.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Actuacion> findAllLike(Actuacion actuacion, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<CampahnaActuacionBusqueda> findAllCampahnaActuacion(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda,
			Pagination pagination);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param campahnaActuacionBusqueda
	 *            CampahnaActuacionBusqueda
	 * @return Long
	 */
	Long findAllCampahnaActuacionCount(
			CampahnaActuacionBusqueda campahnaActuacionBusqueda);

	/**
	 * Finds a List of rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<ActuacionBusqueda> findAllLikeActuacion(
			ActuacionBusqueda actuacionBusqueda, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Actuacion table.
	 * 
	 * @param actuacionBusqueda
	 *            ActuacionBusqueda
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeActuacionCount(ActuacionBusqueda actuacionBusqueda,
			Boolean startsWith);
}
