package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.Actividad;

/**
 *  * ActividadDaoImpl generated by UDA, 01-feb-2012 17:10:36.
 *  
 */
 
@Repository
@Transactional
public class ActividadDaoImpl implements ActividadDao {
    private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<Actividad> rwMap = new RowMapper<Actividad>() {
		public Actividad mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Actividad(
               resultSet.getString("AVCODIGO"), resultSet.getString("AVNOMBRE"), resultSet.getString("AVNOCO"), resultSet.getString("AVTEDE"), resultSet.getString("AVCOSE"), resultSet.getString("AVNOMBREE"), resultSet.getString("AVNOMBREI"), resultSet.getString("AVNOMBREF"), resultSet.getString("AVNOCOE"), resultSet.getString("AVNOCOI"), resultSet.getString("AVNOCOF"), resultSet.getString("AVTEDEE"), resultSet.getString("AVTEDEI"), resultSet.getString("AVTEDEF"), resultSet.getString("AVNOMBREA"), resultSet.getString("AVNOCOA"), resultSet.getString("AVTEDEA")
           ); } } ;

	/**
     * Method use to set the datasource.
     *
     * @param dataSource DataSource
     * @return
     */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    /**
     * Inserts a single row in the Actividad table.
     *
     * @param actividad Pagination
     * @return Actividad
     */
	public Actividad add(Actividad actividad) {

    	String query = "INSERT INTO ACTIVIDAD( AVCODIGO,AVNOMBRE,AVNOCO,AVTEDE,AVCOSE,AVNOMBREE,AVNOMBREI,AVNOMBREF,AVNOCOE,AVNOCOI,AVNOCOF,AVTEDEE,AVTEDEI,AVTEDEF,AVNOMBREA,AVNOCOA,AVTEDEA)"
        + "VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query, actividad.getAvcodigo(), actividad.getAvnombre(), actividad.getAvnoco(), actividad.getAvtede(), actividad.getAvcose(), actividad.getAvnombree(), actividad.getAvnombrei(), actividad.getAvnombref(), actividad.getAvnocoe(), actividad.getAvnocoi(), actividad.getAvnocof(), actividad.getAvtedee(), actividad.getAvtedei(), actividad.getAvtedef(), actividad.getAvnombrea(), actividad.getAvnocoa(), actividad.getAvtedea());
		return actividad;
	}

    /**
     * Updates a single row in the Actividad table.
     *
     * @param actividad Pagination
     * @return Actividad
     */
    public Actividad update(Actividad actividad) {
		String query = "UPDATE ACTIVIDAD SET AVNOMBRE=?,AVNOCO=?,AVTEDE=?,AVCOSE=?,AVNOMBREE=?,AVNOMBREI=?,AVNOMBREF=?,AVNOCOE=?,AVNOCOI=?,AVNOCOF=?,AVTEDEE=?,AVTEDEI=?,AVTEDEF=?,AVNOMBREA=?,AVNOCOA=?,AVTEDEA=? WHERE AVCODIGO=?";
		this.jdbcTemplate.update(query, actividad.getAvnombre(), actividad.getAvnoco(), actividad.getAvtede(), actividad.getAvcose(), actividad.getAvnombree(), actividad.getAvnombrei(), actividad.getAvnombref(), actividad.getAvnocoe(), actividad.getAvnocoi(), actividad.getAvnocof(), actividad.getAvtedee(), actividad.getAvtedei(), actividad.getAvtedef(), actividad.getAvnombrea(), actividad.getAvnocoa(), actividad.getAvtedea(), actividad.getAvcodigo());
		return actividad;
	}

    /**
     * Finds a single row in the Actividad table.
     *
     * @param actividad Pagination
     * @return Actividad
     */
    @Transactional (readOnly = true)
    public Actividad find(Actividad actividad) {
		String query = "SELECT t1.AVCODIGO AVCODIGO, t1.AVNOMBRE AVNOMBRE, t1.AVNOCO AVNOCO, t1.AVTEDE AVTEDE, t1.AVCOSE AVCOSE, t1.AVNOMBREE AVNOMBREE, t1.AVNOMBREI AVNOMBREI, t1.AVNOMBREF AVNOMBREF, t1.AVNOCOE AVNOCOE, t1.AVNOCOI AVNOCOI, t1.AVNOCOF AVNOCOF, t1.AVTEDEE AVTEDEE, t1.AVTEDEI AVTEDEI, t1.AVTEDEF AVTEDEF, t1.AVNOMBREA AVNOMBREA, t1.AVNOCOA AVNOCOA, t1.AVTEDEA AVTEDEA " 
         + "FROM ACTIVIDAD t1  " 
         + "WHERE t1.AVCODIGO = ?    ";
		return (Actividad) this.jdbcTemplate.queryForObject(query, 
			rwMap , actividad.getAvcodigo());	 
    }

    /**
     * Removes a single row in the Actividad table.
     *
     * @param actividad Pagination
     * @return
     */
    public void remove(Actividad actividad) {
		String query = "DELETE  FROM ACTIVIDAD WHERE AVCODIGO=?";
		this.jdbcTemplate.update(query, actividad.getAvcodigo());
    	}
    
   /**
    * Finds a List of rows in the Actividad table.
    * 
    * @param actividad Actividad
    * @param pagination Pagination
    * @return List 
    */
	@Transactional (readOnly = true)
    public List<Actividad> findAll(Actividad actividad, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.AVCODIGO AVCODIGO,t1.AVNOMBRE AVNOMBRE,t1.AVNOCO AVNOCO,t1.AVTEDE AVTEDE,t1.AVCOSE AVCOSE,t1.AVNOMBREE AVNOMBREE,t1.AVNOMBREI AVNOMBREI,t1.AVNOMBREF AVNOMBREF,t1.AVNOCOE AVNOCOE,t1.AVNOCOI AVNOCOI,t1.AVNOCOF AVNOCOF,t1.AVTEDEE AVTEDEE,t1.AVTEDEI AVTEDEI,t1.AVTEDEF AVTEDEF,t1.AVNOMBREA AVNOMBREA,t1.AVNOCOA AVNOCOA,t1.AVTEDEA AVTEDEA " 
			+ "FROM ACTIVIDAD t1 ");
		
		if (actividad  != null  && actividad.getAvcodigo() != null ) {
			where.append(" AND t1.AVCODIGO = ?");
			params.add(actividad.getAvcodigo());
		}
		if (actividad  != null  && actividad.getAvnombre() != null ) {
			where.append(" AND t1.AVNOMBRE = ?");
			params.add(actividad.getAvnombre());
		}
		if (actividad  != null  && actividad.getAvnoco() != null ) {
			where.append(" AND t1.AVNOCO = ?");
			params.add(actividad.getAvnoco());
		}
		if (actividad  != null  && actividad.getAvtede() != null ) {
			where.append(" AND t1.AVTEDE = ?");
			params.add(actividad.getAvtede());
		}
		if (actividad  != null  && actividad.getAvcose() != null ) {
			where.append(" AND t1.AVCOSE = ?");
			params.add(actividad.getAvcose());
		}
		if (actividad  != null  && actividad.getAvnombree() != null ) {
			where.append(" AND t1.AVNOMBREE = ?");
			params.add(actividad.getAvnombree());
		}
		if (actividad  != null  && actividad.getAvnombrei() != null ) {
			where.append(" AND t1.AVNOMBREI = ?");
			params.add(actividad.getAvnombrei());
		}
		if (actividad  != null  && actividad.getAvnombref() != null ) {
			where.append(" AND t1.AVNOMBREF = ?");
			params.add(actividad.getAvnombref());
		}
		if (actividad  != null  && actividad.getAvnocoe() != null ) {
			where.append(" AND t1.AVNOCOE = ?");
			params.add(actividad.getAvnocoe());
		}
		if (actividad  != null  && actividad.getAvnocoi() != null ) {
			where.append(" AND t1.AVNOCOI = ?");
			params.add(actividad.getAvnocoi());
		}
		if (actividad  != null  && actividad.getAvnocof() != null ) {
			where.append(" AND t1.AVNOCOF = ?");
			params.add(actividad.getAvnocof());
		}
		if (actividad  != null  && actividad.getAvtedee() != null ) {
			where.append(" AND t1.AVTEDEE = ?");
			params.add(actividad.getAvtedee());
		}
		if (actividad  != null  && actividad.getAvtedei() != null ) {
			where.append(" AND t1.AVTEDEI = ?");
			params.add(actividad.getAvtedei());
		}
		if (actividad  != null  && actividad.getAvtedef() != null ) {
			where.append(" AND t1.AVTEDEF = ?");
			params.add(actividad.getAvtedef());
		}
		if (actividad  != null  && actividad.getAvnombrea() != null ) {
			where.append(" AND t1.AVNOMBREA = ?");
			params.add(actividad.getAvnombrea());
		}
		if (actividad  != null  && actividad.getAvnocoa() != null ) {
			where.append(" AND t1.AVNOCOA = ?");
			params.add(actividad.getAvnocoa());
		}
		if (actividad  != null  && actividad.getAvtedea() != null ) {
			where.append(" AND t1.AVTEDEA = ?");
			params.add(actividad.getAvtedea());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Actividad>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
	
    /**
     * Counts rows in the Actividad table.
     * 
     * @param actividad Actividad
     * @return Long
     */
    @Transactional (readOnly = true)
    public Long findAllCount(Actividad actividad) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  ");

		StringBuffer query = new StringBuffer("SELECT COUNT(1) FROM  ACTIVIDAD t1  ");
		if (actividad  != null  && actividad.getAvcodigo() != null ) {
			where.append(" AND t1.AVCODIGO = ?");
			params.add(actividad.getAvcodigo());
		}
		if (actividad  != null  && actividad.getAvnombre() != null ) {
			where.append(" AND t1.AVNOMBRE = ?");
			params.add(actividad.getAvnombre());
		}
		if (actividad  != null  && actividad.getAvnoco() != null ) {
			where.append(" AND t1.AVNOCO = ?");
			params.add(actividad.getAvnoco());
		}
		if (actividad  != null  && actividad.getAvtede() != null ) {
			where.append(" AND t1.AVTEDE = ?");
			params.add(actividad.getAvtede());
		}
		if (actividad  != null  && actividad.getAvcose() != null ) {
			where.append(" AND t1.AVCOSE = ?");
			params.add(actividad.getAvcose());
		}
		if (actividad  != null  && actividad.getAvnombree() != null ) {
			where.append(" AND t1.AVNOMBREE = ?");
			params.add(actividad.getAvnombree());
		}
		if (actividad  != null  && actividad.getAvnombrei() != null ) {
			where.append(" AND t1.AVNOMBREI = ?");
			params.add(actividad.getAvnombrei());
		}
		if (actividad  != null  && actividad.getAvnombref() != null ) {
			where.append(" AND t1.AVNOMBREF = ?");
			params.add(actividad.getAvnombref());
		}
		if (actividad  != null  && actividad.getAvnocoe() != null ) {
			where.append(" AND t1.AVNOCOE = ?");
			params.add(actividad.getAvnocoe());
		}
		if (actividad  != null  && actividad.getAvnocoi() != null ) {
			where.append(" AND t1.AVNOCOI = ?");
			params.add(actividad.getAvnocoi());
		}
		if (actividad  != null  && actividad.getAvnocof() != null ) {
			where.append(" AND t1.AVNOCOF = ?");
			params.add(actividad.getAvnocof());
		}
		if (actividad  != null  && actividad.getAvtedee() != null ) {
			where.append(" AND t1.AVTEDEE = ?");
			params.add(actividad.getAvtedee());
		}
		if (actividad  != null  && actividad.getAvtedei() != null ) {
			where.append(" AND t1.AVTEDEI = ?");
			params.add(actividad.getAvtedei());
		}
		if (actividad  != null  && actividad.getAvtedef() != null ) {
			where.append(" AND t1.AVTEDEF = ?");
			params.add(actividad.getAvtedef());
		}
		if (actividad  != null  && actividad.getAvnombrea() != null ) {
			where.append(" AND t1.AVNOMBREA = ?");
			params.add(actividad.getAvnombrea());
		}
		if (actividad  != null  && actividad.getAvnocoa() != null ) {
			where.append(" AND t1.AVNOCOA = ?");
			params.add(actividad.getAvnocoa());
		}
		if (actividad  != null  && actividad.getAvtedea() != null ) {
			where.append(" AND t1.AVTEDEA = ?");
			params.add(actividad.getAvtedea());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}
	
	/**
	 * Finds rows in the Actividad table using like.
     * 
     * @param actividad Actividad
     * @param pagination Pagination
     * @param startsWith Boolean
     * @return List 
     */
	@Transactional (readOnly = true)
    public List<Actividad> findAllLike(Actividad actividad, Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 	");
		
		StringBuffer query = new StringBuffer("SELECT  t1.AVCODIGO AVCODIGO,t1.AVNOMBRE AVNOMBRE,t1.AVNOCO AVNOCO,t1.AVTEDE AVTEDE,t1.AVCOSE AVCOSE,t1.AVNOMBREE AVNOMBREE,t1.AVNOMBREI AVNOMBREI,t1.AVNOMBREF AVNOMBREF,t1.AVNOCOE AVNOCOE,t1.AVNOCOI AVNOCOI,t1.AVNOCOF AVNOCOF,t1.AVTEDEE AVTEDEE,t1.AVTEDEI AVTEDEI,t1.AVTEDEF AVTEDEF,t1.AVNOMBREA AVNOMBREA,t1.AVNOCOA AVNOCOA,t1.AVTEDEA AVTEDEA " 
        	+ "FROM ACTIVIDAD t1 ");
      	
		if (actividad  != null  && actividad.getAvcodigo() != null ) {
			where.append(" AND UPPER(t1.AVCODIGO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvcodigo().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvcodigo().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVCODIGO IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnombre() != null ) {
			where.append(" AND UPPER(t1.AVNOMBRE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnombre().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnombre().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOMBRE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnoco() != null ) {
			where.append(" AND UPPER(t1.AVNOCO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnoco().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnoco().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOCO IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvtede() != null ) {
			where.append(" AND UPPER(t1.AVTEDE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvtede().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvtede().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVTEDE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvcose() != null ) {
			where.append(" AND UPPER(t1.AVCOSE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvcose().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvcose().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVCOSE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnombree() != null ) {
			where.append(" AND UPPER(t1.AVNOMBREE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnombree().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnombree().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOMBREE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnombrei() != null ) {
			where.append(" AND UPPER(t1.AVNOMBREI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnombrei().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnombrei().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOMBREI IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnombref() != null ) {
			where.append(" AND UPPER(t1.AVNOMBREF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnombref().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnombref().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOMBREF IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnocoe() != null ) {
			where.append(" AND UPPER(t1.AVNOCOE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnocoe().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnocoe().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOCOE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnocoi() != null ) {
			where.append(" AND UPPER(t1.AVNOCOI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnocoi().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnocoi().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOCOI IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnocof() != null ) {
			where.append(" AND UPPER(t1.AVNOCOF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnocof().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnocof().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOCOF IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvtedee() != null ) {
			where.append(" AND UPPER(t1.AVTEDEE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvtedee().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvtedee().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVTEDEE IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvtedei() != null ) {
			where.append(" AND UPPER(t1.AVTEDEI) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvtedei().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvtedei().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVTEDEI IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvtedef() != null ) {
			where.append(" AND UPPER(t1.AVTEDEF) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvtedef().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvtedef().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVTEDEF IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnombrea() != null ) {
			where.append(" AND UPPER(t1.AVNOMBREA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnombrea().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnombrea().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOMBREA IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvnocoa() != null ) {
			where.append(" AND UPPER(t1.AVNOCOA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvnocoa().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvnocoa().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVNOCOA IS NOT NULL");
        }
		if (actividad  != null  && actividad.getAvtedea() != null ) {
			where.append(" AND UPPER(t1.AVTEDEA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(actividad.getAvtedea().toUpperCase()  +"%");
			}else{
				params.add("%"+actividad.getAvtedea().toUpperCase() +"%");
			}	
			where.append(" AND t1.AVTEDEA IS NOT NULL");
        }
        query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " " + pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(pagination,query.toString()));
		}
		return (List<Actividad>) this.jdbcTemplate.query(query.toString(),rwMap, params.toArray());
	}
}

