package com.ejie.y41a.dao;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaInfraccionBusqueda;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.AlertaRecib;
import com.ejie.y41a.model.CampahnaRecib;
import com.ejie.y41a.model.DenunciaRecib;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.ProtocoloDetalle;
import com.ejie.y41a.model.TipActuacion;
import com.ejie.y41a.model.TipProtocolo;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.model.TipmotActuacion;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41a.model.ActaInfraccion;

/**
 * * ActaInfraccionDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class ActaInfraccionDaoImpl implements ActaInfraccionDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<ActaInfraccion> rwMap = new RowMapper<ActaInfraccion>() {
		public ActaInfraccion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ActaInfraccion(
					resultSet.getString("AICODIGO"),
					resultSet.getString("AIINEXII"),
					new Actuacion(
							resultSet.getString("ActuacionATCODIGO"),
							resultSet.getBigDecimal("ActuacionATNROR"),
							resultSet.getString("ActuacionATCOAV"),
							resultSet.getString("ActuacionATCOSE"),
							resultSet.getString("ActuacionATNOPRSE"),
							resultSet.getString("ActuacionATNOMAPS"),
							resultSet.getString("ActuacionATNOMOPS"),
							resultSet.getString("ActuacionATNRLOPS"),
							resultSet.getDate("ActuacionATFEDUMI"),
							resultSet.getString("ActuacionATINPRSE"),
							resultSet.getBigDecimal("ActuacionATCAUNEP"),
							resultSet.getString("ActuacionATTEINFO"),
							resultSet.getString("ActuacionATCOAT"),
							new TipProtocolo(resultSet
									.getString("ActuacionATCOTP"), null, null,
									null, null, null),
							new Acta(resultSet.getString("ActuacionATCOAC"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null),
							new CampahnaRecib(resultSet
									.getString("ActuacionATCOCM"), null, null,
									null, null, null, null),
							new Establecimiento(resultSet
									.getString("ActuacionATCOES"), null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null),
							new Producto(
									resultSet.getString("ActuacionATCOPS"),
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null),
							new DenunciaRecib(resultSet
									.getString("ActuacionATCOHD"), null, null,
									null, null, null, null),
							new AlertaRecib(resultSet
									.getString("ActuacionATCOAL"), null, null,
									null, null, null, null, null),
							new TipActuacion(resultSet
									.getString("ActuacionATCOTTA"), null, null),
							new TipmotActuacion(resultSet
									.getString("ActuacionATCOTMA"), null, null)),
					new TipReqNormativo(resultSet
							.getString("TipReqNormativoTTICODIGO"), resultSet
							.getString("TipReqNormativoTTINOMBRE"), resultSet
							.getString("TipReqNormativoTTINOCO"), resultSet
							.getString("TipReqNormativoTTITEDE"), resultSet
							.getString("TipReqNormativoTTICOSE"), resultSet
							.getString("TipReqNormativoTTINOCO2"), resultSet
							.getString("TipReqNormativoTTIINSEL1"), resultSet
							.getString("TipReqNormativoTTICOL4"), resultSet
							.getString("TipReqNormativoTTINOMBREE"), resultSet
							.getString("TipReqNormativoTTINOMBREI"), resultSet
							.getString("TipReqNormativoTTINOMBREF"), resultSet
							.getString("TipReqNormativoTTINOCOE"), resultSet
							.getString("TipReqNormativoTTINOCOI"), resultSet
							.getString("TipReqNormativoTTINOCOF"), resultSet
							.getString("TipReqNormativoTTITEDEE"), resultSet
							.getString("TipReqNormativoTTITEDEI"), resultSet
							.getString("TipReqNormativoTTITEDEF"), resultSet
							.getString("TipReqNormativoTTICODGRUPO"), resultSet
							.getString("TipReqNormativoTTINOMBREA"), resultSet
							.getString("TipReqNormativoTTINOCOA"), resultSet
							.getString("TipReqNormativoTTITEDEA"), resultSet
							.getString("TipReqNormativoTTICOE7"), resultSet
							.getString("TipReqNormativoTTICOINC")));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion add(ActaInfraccion actainfraccion) {

		String query = "INSERT INTO ACTA_INFRACCION( AICODIGO,AICOAT,AICOTTI,AIINEXII)"
				+ "VALUES (?,?,?,?)";

		Object getActuacionAtcodigoAux = null;
		if (actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = actainfraccion.getActuacion()
					.getAtcodigo();
		}
		Object getTipReqNormativoTticodigoAux = null;
		if (actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = actainfraccion
					.getTipReqNormativo().getTticodigo();
		}
		this.jdbcTemplate.update(query, actainfraccion.getAicodigo(),
				getActuacionAtcodigoAux, getTipReqNormativoTticodigoAux,
				actainfraccion.getAiinexii());
		return actainfraccion;
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion update(ActaInfraccion actainfraccion) {
		String query = "UPDATE ACTA_INFRACCION SET AICOAT=?,AICOTTI=?,AIINEXII=? WHERE AICODIGO=?";
		Object getActuacionAtcodigoAux = null;
		if (actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			getActuacionAtcodigoAux = actainfraccion.getActuacion()
					.getAtcodigo();
		}
		Object getTipReqNormativoTticodigoAux = null;
		if (actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			getTipReqNormativoTticodigoAux = actainfraccion
					.getTipReqNormativo().getTticodigo();
		}
		this.jdbcTemplate.update(query, getActuacionAtcodigoAux,
				getTipReqNormativoTticodigoAux, actainfraccion.getAiinexii(),
				actainfraccion.getAicodigo());
		return actainfraccion;
	}

	/**
	 * Updates a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	public ActaInfraccion updateConstatacion(ActaInfraccion actainfraccion) {
		String query = "UPDATE ACTA_INFRACCION SET AIINEXII=? WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, actainfraccion.getAiinexii(),
				actainfraccion.getAicodigo());
		return actainfraccion;
	}

	/**
	 * Finds a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return ActaInfraccion
	 */
	@Transactional(readOnly = true)
	public ActaInfraccion find(ActaInfraccion actainfraccion) {
		String query = "SELECT t1.AICODIGO AICODIGO, t1.AIINEXII AIINEXII, t2.ATCODIGO ACTUACIONATCODIGO, t2.ATNROR ACTUACIONATNROR, t2.ATCOAV ACTUACIONATCOAV, t2.ATCOSE ACTUACIONATCOSE, t2.ATNOPRSE ACTUACIONATNOPRSE, t2.ATNOMAPS ACTUACIONATNOMAPS, t2.ATNOMOPS ACTUACIONATNOMOPS, t2.ATNRLOPS ACTUACIONATNRLOPS, t2.ATFEDUMI ACTUACIONATFEDUMI, t2.ATINPRSE ACTUACIONATINPRSE, t2.ATCAUNEP ACTUACIONATCAUNEP, t2.ATTEINFO ACTUACIONATTEINFO, t2.ATCOAT ACTUACIONATCOAT, t3.TTICODIGO TIPREQNORMATIVOTTICODIGO, t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE, t3.TTINOCO TIPREQNORMATIVOTTINOCO, t3.TTITEDE TIPREQNORMATIVOTTITEDE, t3.TTICOSE TIPREQNORMATIVOTTICOSE, t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2, t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1, t3.TTICOL4 TIPREQNORMATIVOTTICOL4, t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE, t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI, t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF, t3.TTINOCOE TIPREQNORMATIVOTTINOCOE, t3.TTINOCOI TIPREQNORMATIVOTTINOCOI, t3.TTINOCOF TIPREQNORMATIVOTTINOCOF, t3.TTITEDEE TIPREQNORMATIVOTTITEDEE, t3.TTITEDEI TIPREQNORMATIVOTTITEDEI, t3.TTITEDEF TIPREQNORMATIVOTTITEDEF, t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO, t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA, t3.TTINOCOA TIPREQNORMATIVOTTINOCOA, t3.TTITEDEA TIPREQNORMATIVOTTITEDEA, t3.TTICOE7 TIPREQNORMATIVOTTICOE7, t3.TTICOINC TIPREQNORMATIVOTTICOINC, t2.ATCOTP ACTUACIONATCOTP, t2.ATCOAC ACTUACIONATCOAC, t2.ATCOCM ACTUACIONATCOCM, t2.ATCOES ACTUACIONATCOES, t2.ATCOPS ACTUACIONATCOPS, t2.ATCOHD ACTUACIONATCOHD, t2.ATCOAL ACTUACIONATCOAL, t2.ATCOTTA ACTUACIONATCOTTA, t2.ATCOTMA ACTUACIONATCOTMA "
				+ "FROM ACTA_INFRACCION t1 , ACTUACION t2 , TIP_REQ_NORMATIVO t3  "
				+ "WHERE t1.AICODIGO = ?   AND t1.AICOAT= t2.ATCODIGO(+) AND t1.AICOTTI= t3.TTICODIGO(+)  ";
		return (ActaInfraccion) this.jdbcTemplate.queryForObject(query, rwMap,
				actainfraccion.getAicodigo());
	}

	/**
	 * Removes a single row in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            Pagination
	 * @return
	 */
	public void remove(ActaInfraccion actainfraccion) {
		String query = "DELETE  FROM ACTA_INFRACCION WHERE AICODIGO=?";
		this.jdbcTemplate.update(query, actainfraccion.getAicodigo());
	}

	/**
	 * Removes a single row in the ActaInfraccion table.
	 * 
	 * @param protocoloDetalle
	 *            ProtocoloDetalle
	 * @return
	 */
	public void removeInfraccionActa(ProtocoloDetalle protocoloDetalle) {
		String query = "DELETE  FROM ACTA_INFRACCION WHERE AICOAT=?";
		this.jdbcTemplate.update(query, protocoloDetalle.getAtcodigo());
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaInfraccion> findAll(ActaInfraccion actainfraccion,
			Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.AICOAT= t2.ATCODIGO(+) AND t1.AICOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.AICODIGO AICODIGO,t1.AIINEXII AIINEXII,t2.ATCODIGO ACTUACIONATCODIGO,t2.ATNROR ACTUACIONATNROR,t2.ATCOAV ACTUACIONATCOAV,t2.ATCOSE ACTUACIONATCOSE,t2.ATNOPRSE ACTUACIONATNOPRSE,t2.ATNOMAPS ACTUACIONATNOMAPS,t2.ATNOMOPS ACTUACIONATNOMOPS,t2.ATNRLOPS ACTUACIONATNRLOPS,t2.ATFEDUMI ACTUACIONATFEDUMI,t2.ATINPRSE ACTUACIONATINPRSE,t2.ATCAUNEP ACTUACIONATCAUNEP,t2.ATTEINFO ACTUACIONATTEINFO,t2.ATCOAT ACTUACIONATCOAT,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.ATCOTP ACTUACIONATCOTP,t2.ATCOAC ACTUACIONATCOAC,t2.ATCOCM ACTUACIONATCOCM,t2.ATCOES ACTUACIONATCOES,t2.ATCOPS ACTUACIONATCOPS,t2.ATCOHD ACTUACIONATCOHD,t2.ATCOAL ACTUACIONATCOAL,t2.ATCOTTA ACTUACIONATCOTTA,t2.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM ACTA_INFRACCION t1 ,ACTUACION t2 ,TIP_REQ_NORMATIVO t3 ");

		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND t1.AICODIGO = ?");
			params.add(actainfraccion.getAicodigo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO = ?");
			params.add(actainfraccion.getActuacion().getAtcodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipProtocolo() != null
				&& actainfraccion.getActuacion().getTipProtocolo()
						.getTpcodigo() != null) {
			where.append(" AND t2.ATCOTP = ?");
			params.add(actainfraccion.getActuacion().getTipProtocolo()
					.getTpcodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getActa() != null
				&& actainfraccion.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t2.ATCOAC = ?");
			params.add(actainfraccion.getActuacion().getActa().getAccodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getCampahnaRecib() != null
				&& actainfraccion.getActuacion().getCampahnaRecib()
						.getS4codigo() != null) {
			where.append(" AND t2.ATCOCM = ?");
			params.add(actainfraccion.getActuacion().getCampahnaRecib()
					.getS4codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getEstablecimiento() != null
				&& actainfraccion.getActuacion().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.ATCOES = ?");
			params.add(actainfraccion.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getProducto() != null
				&& actainfraccion.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ATCOPS = ?");
			params.add(actainfraccion.getActuacion().getProducto()
					.getPscodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getDenunciaRecib() != null
				&& actainfraccion.getActuacion().getDenunciaRecib()
						.getS6codigo() != null) {
			where.append(" AND t2.ATCOHD = ?");
			params.add(actainfraccion.getActuacion().getDenunciaRecib()
					.getS6codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAlertaRecib() != null
				&& actainfraccion.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t2.ATCOAL = ?");
			params.add(actainfraccion.getActuacion().getAlertaRecib()
					.getS5codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion()
						.getTtacodigo() != null) {
			where.append(" AND t2.ATCOTTA = ?");
			params.add(actainfraccion.getActuacion().getTipActuacion()
					.getTtacodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion()
						.getTmacodigo() != null) {
			where.append(" AND t2.ATCOTMA = ?");
			params.add(actainfraccion.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnror() != null) {
			where.append(" AND t2.ATNROR = ?");
			params.add(actainfraccion.getActuacion().getAtnror());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoav() != null) {
			where.append(" AND t2.ATCOAV = ?");
			params.add(actainfraccion.getActuacion().getAtcoav());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcose() != null) {
			where.append(" AND t2.ATCOSE = ?");
			params.add(actainfraccion.getActuacion().getAtcose());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnoprse() != null) {
			where.append(" AND t2.ATNOPRSE = ?");
			params.add(actainfraccion.getActuacion().getAtnoprse());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomaps() != null) {
			where.append(" AND t2.ATNOMAPS = ?");
			params.add(actainfraccion.getActuacion().getAtnomaps());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomops() != null) {
			where.append(" AND t2.ATNOMOPS = ?");
			params.add(actainfraccion.getActuacion().getAtnomops());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnrlops() != null) {
			where.append(" AND t2.ATNRLOPS = ?");
			params.add(actainfraccion.getActuacion().getAtnrlops());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtfedumi() != null) {
			where.append(" AND t2.ATFEDUMI = ?");
			params.add(actainfraccion.getActuacion().getAtfedumi());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtinprse() != null) {
			where.append(" AND t2.ATINPRSE = ?");
			params.add(actainfraccion.getActuacion().getAtinprse());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcaunep() != null) {
			where.append(" AND t2.ATCAUNEP = ?");
			params.add(actainfraccion.getActuacion().getAtcaunep());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtteinfo() != null) {
			where.append(" AND t2.ATTEINFO = ?");
			params.add(actainfraccion.getActuacion().getAtteinfo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoat() != null) {
			where.append(" AND t2.ATCOAT = ?");
			params.add(actainfraccion.getActuacion().getAtcoat());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t3.TTINOMBRE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombre());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t3.TTINOCO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinoco());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t3.TTITEDE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitede());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t3.TTICOSE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticose());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t3.TTINOCO2 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinoco2());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t3.TTIINSEL1 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtiinsel1());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t3.TTICOL4 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticol4());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t3.TTINOMBREE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombree());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t3.TTINOMBREI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombrei());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t3.TTINOMBREF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombref());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t3.TTINOCOE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoe());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t3.TTINOCOI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoi());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t3.TTINOCOF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocof());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t3.TTITEDEE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedee());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t3.TTITEDEI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedei());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t3.TTITEDEF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedef());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t3.TTICODGRUPO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticodgrupo());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t3.TTINOMBREA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombrea());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t3.TTINOCOA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoa());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t3.TTITEDEA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedea());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t3.TTICOE7 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticoe7());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t3.TTICOINC = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticoinc());
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND t1.AIINEXII = ?");
			params.add(actainfraccion.getAiinexii());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ActaInfraccion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ActaInfraccion actainfraccion) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.AICOAT= t2.ATCODIGO(+) and t1.AICOTTI= t3.TTICODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ACTA_INFRACCION t1   ,  ACTUACION t2   ,  TIP_REQ_NORMATIVO t3  ");
		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND t1.AICODIGO = ?");
			params.add(actainfraccion.getAicodigo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO = ?");
			params.add(actainfraccion.getActuacion().getAtcodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipProtocolo() != null
				&& actainfraccion.getActuacion().getTipProtocolo()
						.getTpcodigo() != null) {
			where.append(" AND t2.ATCOTP = ?");
			params.add(actainfraccion.getActuacion().getTipProtocolo()
					.getTpcodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getActa() != null
				&& actainfraccion.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND t2.ATCOAC = ?");
			params.add(actainfraccion.getActuacion().getActa().getAccodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getCampahnaRecib() != null
				&& actainfraccion.getActuacion().getCampahnaRecib()
						.getS4codigo() != null) {
			where.append(" AND t2.ATCOCM = ?");
			params.add(actainfraccion.getActuacion().getCampahnaRecib()
					.getS4codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getEstablecimiento() != null
				&& actainfraccion.getActuacion().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND t2.ATCOES = ?");
			params.add(actainfraccion.getActuacion().getEstablecimiento()
					.getEscodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getProducto() != null
				&& actainfraccion.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND t2.ATCOPS = ?");
			params.add(actainfraccion.getActuacion().getProducto()
					.getPscodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getDenunciaRecib() != null
				&& actainfraccion.getActuacion().getDenunciaRecib()
						.getS6codigo() != null) {
			where.append(" AND t2.ATCOHD = ?");
			params.add(actainfraccion.getActuacion().getDenunciaRecib()
					.getS6codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAlertaRecib() != null
				&& actainfraccion.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND t2.ATCOAL = ?");
			params.add(actainfraccion.getActuacion().getAlertaRecib()
					.getS5codigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion()
						.getTtacodigo() != null) {
			where.append(" AND t2.ATCOTTA = ?");
			params.add(actainfraccion.getActuacion().getTipActuacion()
					.getTtacodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion()
						.getTmacodigo() != null) {
			where.append(" AND t2.ATCOTMA = ?");
			params.add(actainfraccion.getActuacion().getTipmotActuacion()
					.getTmacodigo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnror() != null) {
			where.append(" AND t2.ATNROR = ?");
			params.add(actainfraccion.getActuacion().getAtnror());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoav() != null) {
			where.append(" AND t2.ATCOAV = ?");
			params.add(actainfraccion.getActuacion().getAtcoav());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcose() != null) {
			where.append(" AND t2.ATCOSE = ?");
			params.add(actainfraccion.getActuacion().getAtcose());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnoprse() != null) {
			where.append(" AND t2.ATNOPRSE = ?");
			params.add(actainfraccion.getActuacion().getAtnoprse());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomaps() != null) {
			where.append(" AND t2.ATNOMAPS = ?");
			params.add(actainfraccion.getActuacion().getAtnomaps());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomops() != null) {
			where.append(" AND t2.ATNOMOPS = ?");
			params.add(actainfraccion.getActuacion().getAtnomops());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnrlops() != null) {
			where.append(" AND t2.ATNRLOPS = ?");
			params.add(actainfraccion.getActuacion().getAtnrlops());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtfedumi() != null) {
			where.append(" AND t2.ATFEDUMI = ?");
			params.add(actainfraccion.getActuacion().getAtfedumi());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtinprse() != null) {
			where.append(" AND t2.ATINPRSE = ?");
			params.add(actainfraccion.getActuacion().getAtinprse());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcaunep() != null) {
			where.append(" AND t2.ATCAUNEP = ?");
			params.add(actainfraccion.getActuacion().getAtcaunep());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtteinfo() != null) {
			where.append(" AND t2.ATTEINFO = ?");
			params.add(actainfraccion.getActuacion().getAtteinfo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoat() != null) {
			where.append(" AND t2.ATCOAT = ?");
			params.add(actainfraccion.getActuacion().getAtcoat());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticodigo());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND t3.TTINOMBRE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombre());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND t3.TTINOCO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinoco());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND t3.TTITEDE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitede());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticose() != null) {
			where.append(" AND t3.TTICOSE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticose());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND t3.TTINOCO2 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinoco2());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND t3.TTIINSEL1 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtiinsel1());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND t3.TTICOL4 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticol4());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND t3.TTINOMBREE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombree());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND t3.TTINOMBREI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombrei());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND t3.TTINOMBREF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombref());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND t3.TTINOCOE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoe());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND t3.TTINOCOI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoi());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND t3.TTINOCOF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocof());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND t3.TTITEDEE = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedee());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND t3.TTITEDEI = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedei());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND t3.TTITEDEF = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedef());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND t3.TTICODGRUPO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticodgrupo());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND t3.TTINOMBREA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinombrea());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND t3.TTINOCOA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtinocoa());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND t3.TTITEDEA = ?");
			params.add(actainfraccion.getTipReqNormativo().getTtitedea());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND t3.TTICOE7 = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticoe7());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND t3.TTICOINC = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticoinc());
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND t1.AIINEXII = ?");
			params.add(actainfraccion.getAiinexii());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a List of rows in the ActaInfraccion table.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaInfraccionBusqueda> findAllConstatacion(
			ActaInfraccion actainfraccion, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.AICOAT= t2.ATCODIGO(+) AND t1.AICOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.AICODIGO AICODIGO,t2.ATCODIGO ATCODIGO,t2.ATCOAC ATCOAC, t3.TTICODIGO TTICODIGO, t3.TTINOMBRE TTINOMBRE, t3.TTINOMBREE TTINOMBREE, t1.AIINEXII AIINEXII "
						+ "FROM ACTA_INFRACCION t1 ,ACTUACION t2 ,TIP_REQ_NORMATIVO t3 ");

		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND t1.AICODIGO = ?");
			params.add(actainfraccion.getAicodigo());
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO = ?");
			params.add(actainfraccion.getActuacion().getAtcodigo());
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND t1.AIINEXII = ?");
			params.add(actainfraccion.getAiinexii());
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO = ?");
			params.add(actainfraccion.getTipReqNormativo().getTticodigo());
		}

		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ActaInfraccionBusqueda>) this.jdbcTemplate.query(
				query.toString(), new RowMapper<ActaInfraccionBusqueda>() {
					public ActaInfraccionBusqueda mapRow(ResultSet resultSet,
							int rowNum) throws SQLException {
						return new ActaInfraccionBusqueda(resultSet
								.getString("AICODIGO"), resultSet
								.getString("ATCODIGO"), resultSet
								.getString("ATCOAC"), resultSet
								.getString("TTICODIGO"), resultSet
								.getString("TTINOMBRE"), resultSet
								.getString("TTINOMBREE"), resultSet
								.getString("AIINEXII"));
					}
				}, params.toArray());
	}

	/**
	 * Finds rows in the ActaInfraccion table using like.
	 * 
	 * @param actainfraccion
	 *            ActaInfraccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaInfraccion> findAllLike(ActaInfraccion actainfraccion,
			Pagination pagination, Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.AICOAT= t2.ATCODIGO(+) AND t1.AICOTTI= t3.TTICODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.AICODIGO AICODIGO,t1.AIINEXII AIINEXII,t2.ATCODIGO ACTUACIONATCODIGO,t2.ATNROR ACTUACIONATNROR,t2.ATCOAV ACTUACIONATCOAV,t2.ATCOSE ACTUACIONATCOSE,t2.ATNOPRSE ACTUACIONATNOPRSE,t2.ATNOMAPS ACTUACIONATNOMAPS,t2.ATNOMOPS ACTUACIONATNOMOPS,t2.ATNRLOPS ACTUACIONATNRLOPS,t2.ATFEDUMI ACTUACIONATFEDUMI,t2.ATINPRSE ACTUACIONATINPRSE,t2.ATCAUNEP ACTUACIONATCAUNEP,t2.ATTEINFO ACTUACIONATTEINFO,t2.ATCOAT ACTUACIONATCOAT,t3.TTICODIGO TIPREQNORMATIVOTTICODIGO,t3.TTINOMBRE TIPREQNORMATIVOTTINOMBRE,t3.TTINOCO TIPREQNORMATIVOTTINOCO,t3.TTITEDE TIPREQNORMATIVOTTITEDE,t3.TTICOSE TIPREQNORMATIVOTTICOSE,t3.TTINOCO2 TIPREQNORMATIVOTTINOCO2,t3.TTIINSEL1 TIPREQNORMATIVOTTIINSEL1,t3.TTICOL4 TIPREQNORMATIVOTTICOL4,t3.TTINOMBREE TIPREQNORMATIVOTTINOMBREE,t3.TTINOMBREI TIPREQNORMATIVOTTINOMBREI,t3.TTINOMBREF TIPREQNORMATIVOTTINOMBREF,t3.TTINOCOE TIPREQNORMATIVOTTINOCOE,t3.TTINOCOI TIPREQNORMATIVOTTINOCOI,t3.TTINOCOF TIPREQNORMATIVOTTINOCOF,t3.TTITEDEE TIPREQNORMATIVOTTITEDEE,t3.TTITEDEI TIPREQNORMATIVOTTITEDEI,t3.TTITEDEF TIPREQNORMATIVOTTITEDEF,t3.TTICODGRUPO TIPREQNORMATIVOTTICODGRUPO,t3.TTINOMBREA TIPREQNORMATIVOTTINOMBREA,t3.TTINOCOA TIPREQNORMATIVOTTINOCOA,t3.TTITEDEA TIPREQNORMATIVOTTITEDEA,t3.TTICOE7 TIPREQNORMATIVOTTICOE7,t3.TTICOINC TIPREQNORMATIVOTTICOINC,t2.ATCOTP ACTUACIONATCOTP,t2.ATCOAC ACTUACIONATCOAC,t2.ATCOCM ACTUACIONATCOCM,t2.ATCOES ACTUACIONATCOES,t2.ATCOPS ACTUACIONATCOPS,t2.ATCOHD ACTUACIONATCOHD,t2.ATCOAL ACTUACIONATCOAL,t2.ATCOTTA ACTUACIONATCOTTA,t2.ATCOTMA ACTUACIONATCOTMA "
						+ "FROM ACTA_INFRACCION t1 ,ACTUACION t2 ,TIP_REQ_NORMATIVO t3 ");

		if (actainfraccion != null && actainfraccion.getAicodigo() != null) {
			where.append(" AND UPPER(t1.AICODIGO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAicodigo().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAicodigo().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AICODIGO IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcodigo() != null) {
			where.append(" AND t2.ATCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtcodigo() + "%");
			} else {
				params.add("%" + actainfraccion.getActuacion().getAtcodigo()
						+ "%");
			}
			where.append(" AND t2.ATCODIGO IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipProtocolo() != null
				&& actainfraccion.getActuacion().getTipProtocolo()
						.getTpcodigo() != null) {
			where.append(" AND UPPER(t2.ATCOTP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getTipProtocolo()
						.getTpcodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getTipProtocolo()
								.getTpcodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOTP IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getActa() != null
				&& actainfraccion.getActuacion().getActa().getAccodigo() != null) {
			where.append(" AND UPPER(t2.ATCOAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getActa()
						.getAccodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getActa().getAccodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOAC IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getCampahnaRecib() != null
				&& actainfraccion.getActuacion().getCampahnaRecib()
						.getS4codigo() != null) {
			where.append(" AND UPPER(t2.ATCOCM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getCampahnaRecib()
						.getS4codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getCampahnaRecib()
								.getS4codigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOCM IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getEstablecimiento() != null
				&& actainfraccion.getActuacion().getEstablecimiento()
						.getEscodigo() != null) {
			where.append(" AND UPPER(t2.ATCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getEstablecimiento()
								.getEscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOES IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getProducto() != null
				&& actainfraccion.getActuacion().getProducto().getPscodigo() != null) {
			where.append(" AND UPPER(t2.ATCOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getProducto()
						.getPscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getProducto()
								.getPscodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOPS IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getDenunciaRecib() != null
				&& actainfraccion.getActuacion().getDenunciaRecib()
						.getS6codigo() != null) {
			where.append(" AND UPPER(t2.ATCOHD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getDenunciaRecib()
						.getS6codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getDenunciaRecib()
								.getS6codigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOHD IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAlertaRecib() != null
				&& actainfraccion.getActuacion().getAlertaRecib().getS5codigo() != null) {
			where.append(" AND UPPER(t2.ATCOAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAlertaRecib()
						.getS5codigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAlertaRecib()
								.getS5codigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOAL IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion() != null
				&& actainfraccion.getActuacion().getTipActuacion()
						.getTtacodigo() != null) {
			where.append(" AND UPPER(t2.ATCOTTA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getTipActuacion()
						.getTtacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getTipActuacion()
								.getTtacodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOTTA IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion() != null
				&& actainfraccion.getActuacion().getTipmotActuacion()
						.getTmacodigo() != null) {
			where.append(" AND UPPER(t2.ATCOTMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getTipmotActuacion()
						.getTmacodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getTipmotActuacion()
								.getTmacodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOTMA IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnror() != null) {
			where.append(" AND t2.ATNROR like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtnror() + "%");
			} else {
				params.add("%" + actainfraccion.getActuacion().getAtnror()
						+ "%");
			}
			where.append(" AND t2.ATNROR IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoav() != null) {
			where.append(" AND UPPER(t2.ATCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtcoav()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtcoav()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOAV IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcose() != null) {
			where.append(" AND UPPER(t2.ATCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtcose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtcose()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOSE IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnoprse() != null) {
			where.append(" AND UPPER(t2.ATNOPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtnoprse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtnoprse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATNOPRSE IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomaps() != null) {
			where.append(" AND UPPER(t2.ATNOMAPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtnomaps()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtnomaps()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATNOMAPS IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnomops() != null) {
			where.append(" AND UPPER(t2.ATNOMOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtnomops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtnomops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATNOMOPS IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtnrlops() != null) {
			where.append(" AND UPPER(t2.ATNRLOPS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtnrlops()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtnrlops()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATNRLOPS IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtfedumi() != null) {
			where.append(" AND t2.ATFEDUMI like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtfedumi() + "%");
			} else {
				params.add("%" + actainfraccion.getActuacion().getAtfedumi()
						+ "%");
			}
			where.append(" AND t2.ATFEDUMI IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtinprse() != null) {
			where.append(" AND UPPER(t2.ATINPRSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtinprse()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtinprse()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATINPRSE IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcaunep() != null) {
			where.append(" AND t2.ATCAUNEP like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtcaunep() + "%");
			} else {
				params.add("%" + actainfraccion.getActuacion().getAtcaunep()
						+ "%");
			}
			where.append(" AND t2.ATCAUNEP IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtteinfo() != null) {
			where.append(" AND UPPER(t2.ATTEINFO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtteinfo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtteinfo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATTEINFO IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getActuacion() != null
				&& actainfraccion.getActuacion().getAtcoat() != null) {
			where.append(" AND UPPER(t2.ATCOAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getActuacion().getAtcoat()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getActuacion().getAtcoat()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ATCOAT IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodigo() != null) {
			where.append(" AND t3.TTICODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticodigo()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticodigo()
						+ "%");
			}
			where.append(" AND t3.TTICODIGO IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombre() != null) {
			where.append(" AND UPPER(t3.TTINOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBRE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco() != null) {
			where.append(" AND UPPER(t3.TTINOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinoco()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinoco()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCO IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitede() != null) {
			where.append(" AND UPPER(t3.TTITEDE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtitede()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtitede()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticose() != null) {
			where.append(" AND UPPER(t3.TTICOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticose()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticose()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOSE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinoco2() != null) {
			where.append(" AND UPPER(t3.TTINOCO2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinoco2()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinoco2()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCO2 IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtiinsel1() != null) {
			where.append(" AND UPPER(t3.TTIINSEL1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtiinsel1()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtiinsel1()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTIINSEL1 IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticol4() != null) {
			where.append(" AND UPPER(t3.TTICOL4) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticol4()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticol4()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOL4 IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombree() != null) {
			where.append(" AND UPPER(t3.TTINOMBREE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinombree()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinombree()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrei() != null) {
			where.append(" AND UPPER(t3.TTINOMBREI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinombrei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinombrei()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREI IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombref() != null) {
			where.append(" AND UPPER(t3.TTINOMBREF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinombref()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinombref()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREF IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoe() != null) {
			where.append(" AND UPPER(t3.TTINOCOE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinocoe()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinocoe()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoi() != null) {
			where.append(" AND UPPER(t3.TTINOCOI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinocoi()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinocoi()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOI IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocof() != null) {
			where.append(" AND UPPER(t3.TTINOCOF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinocof()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinocof()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOF IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedee() != null) {
			where.append(" AND UPPER(t3.TTITEDEE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtitedee()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtitedee()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEE IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedei() != null) {
			where.append(" AND UPPER(t3.TTITEDEI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtitedei()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtitedei()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEI IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedef() != null) {
			where.append(" AND UPPER(t3.TTITEDEF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtitedef()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtitedef()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEF IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticodgrupo() != null) {
			where.append(" AND UPPER(t3.TTICODGRUPO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticodgrupo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticodgrupo()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICODGRUPO IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinombrea() != null) {
			where.append(" AND UPPER(t3.TTINOMBREA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinombrea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinombrea()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOMBREA IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtinocoa() != null) {
			where.append(" AND UPPER(t3.TTINOCOA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtinocoa()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtinocoa()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTINOCOA IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTtitedea() != null) {
			where.append(" AND UPPER(t3.TTITEDEA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTtitedea()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTtitedea()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTITEDEA IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoe7() != null) {
			where.append(" AND UPPER(t3.TTICOE7) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticoe7()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticoe7()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOE7 IS NOT NULL");
		}
		if (actainfraccion != null
				&& actainfraccion.getTipReqNormativo() != null
				&& actainfraccion.getTipReqNormativo().getTticoinc() != null) {
			where.append(" AND UPPER(t3.TTICOINC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getTipReqNormativo().getTticoinc()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actainfraccion.getTipReqNormativo().getTticoinc()
								.toUpperCase() + "%");
			}
			where.append(" AND t3.TTICOINC IS NOT NULL");
		}
		if (actainfraccion != null && actainfraccion.getAiinexii() != null) {
			where.append(" AND UPPER(t1.AIINEXII) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actainfraccion.getAiinexii().toUpperCase() + "%");
			} else {
				params.add("%" + actainfraccion.getAiinexii().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AIINEXII IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ActaInfraccion>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
