package com.ejie.y41a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.PaginationManager;
import com.ejie.y41a.model.Acta;
import com.ejie.y41a.model.ActaFile;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Inspector;
import com.ejie.y41a.model.Tipodoc;
import com.ejie.y41a.utils.jdbc.Y41aJdbcUtils;

/**
 * * ActaFileDaoImpl generated by UDA, 22-mar-2012 16:48:05.
 * 
 *  
 */

@Repository
@Transactional
public class ActaFileDaoImpl implements ActaFileDao {
	private SimpleJdbcTemplate jdbcTemplate;
	private RowMapper<ActaFile> rwMap = new RowMapper<ActaFile>() {
		public ActaFile mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new ActaFile(resultSet.getString("S3CODOCUMENTO"),
					resultSet.getString("S3NOMFILE"),
					resultSet.getBlob("S3DATAFILE"),
					resultSet.getInt("S3SIZEFILE"),
					resultSet.getString("S3DESFILE"),
					resultSet.getDate("S3FECHA"),
					resultSet.getString("S3ORIGEN"),
					resultSet.getString("S3CONTENTTYPE"), new Acta(
							resultSet.getString("ActaACCODIGO"),
							resultSet.getString("ActaACCOOR"),
							resultSet.getString("ActaACNROR"),
							resultSet.getBigDecimal("ActaACNRAN"),
							resultSet.getDate("ActaACFELE"),
							resultSet.getDate("ActaACFERE"),
							resultSet.getString("ActaACCOAV"),
							resultSet.getString("ActaACCOSE"),
							resultSet.getDate("ActaACFEEX"),
							resultSet.getString("ActaACINRE"),
							resultSet.getString("ActaACNOCO"),
							resultSet.getString("ActaACAPE1CO"),
							resultSet.getString("ActaACAPE2CO"),
							resultSet.getString("ActaACDNICO"),
							resultSet.getString("ActaACCOCO"),
							resultSet.getString("ActaACDIRCO"),
							resultSet.getString("ActaACCOLOCO"),
							resultSet.getString("ActaACNRCPCO"),
							resultSet.getString("ActaACNRTFCO"),
							resultSet.getString("ActaACNORAPAISID"),
							resultSet.getString("ActaACNORAPAISNOMBRE"),
							resultSet.getString("ActaACNORAPROVINCIAID"),
							resultSet.getString("ActaACNOMBREPROVINCIA"),
							resultSet.getString("ActaACNORAMUNICIPIOID"),
							resultSet.getString("ActaACNOMBREMUNICIPIO"),
							resultSet.getString("ActaACNORALOCALIDADID"),
							resultSet.getString("ActaACNOMBRELOCALIDAD"),
							resultSet.getString("ActaACNORACALLEID"),
							resultSet.getString("ActaACNOMBRECALLE"),
							resultSet.getString("ActaACNORACPID"),
							resultSet.getString("ActaACNOMBRECP"),
							resultSet.getString("ActaACNORAPORTALID"),
							resultSet.getString("ActaACNOMBREPORTAL"),
							resultSet.getString("ActaACNOMBREPISO"),
							resultSet.getString("ActaACDIRECCIONNOCAPV"),
							new Inspector(resultSet.getString("ActaACCOINDO"),
									null, null, null, null), new Inspector(
									resultSet.getString("ActaACCOINUN"), null,
									null, null, null), new Tipodoc(
									resultSet.getString("ActaACCOTD"), null,
									null), new Establecimiento(
									resultSet.getString("ActaACCOES"), null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null, null, null, null, null, null,
									null, null)));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
	}

	/**
	 * Inserts a single row in the ActaFile table.
	 * 
	 * @param actafile
	 *            Pagination
	 * @return ActaFile
	 */
	public ActaFile add(ActaFile actafile) {

		String query = "INSERT INTO ACTA_FILE( S3CODOCUMENTO,S3CODACTA,S3NOMFILE,S3DATAFILE,S3SIZEFILE,S3DESFILE,S3FECHA,S3ORIGEN,S3CONTENTTYPE)"
				+ "VALUES (?,?,?,?,?,?,?,?,?)";

		Object getActaAccodigoAux = null;
		if (actafile.getActa() != null
				&& actafile.getActa().getAccodigo() != null) {
			getActaAccodigoAux = actafile.getActa().getAccodigo();
		}
		this.jdbcTemplate.update(query, actafile.getS3codocumento(),
				getActaAccodigoAux, actafile.getS3nomfile(),
				Y41aJdbcUtils.ConvertBlobToByte(actafile.getS3datafile()),
				actafile.getS3sizefile(), actafile.getS3desfile(),
				actafile.getS3fecha(), actafile.getS3origen(),
				actafile.getS3contenttype());
		return actafile;
	}

	/**
	 * Updates a single row in the ActaFile table.
	 * 
	 * @param actafile
	 *            Pagination
	 * @return ActaFile
	 */
	public ActaFile update(ActaFile actafile) {
		String query = "UPDATE ACTA_FILE SET S3CODACTA=?,S3NOMFILE=?,S3DATAFILE=?,S3SIZEFILE=?,S3DESFILE=?,S3FECHA=?,S3ORIGEN=?,S3CONTENTTYPE=? WHERE S3CODOCUMENTO=?";
		Object getActaAccodigoAux = null;
		if (actafile.getActa() != null
				&& actafile.getActa().getAccodigo() != null) {
			getActaAccodigoAux = actafile.getActa().getAccodigo();
		}
		this.jdbcTemplate.update(query, getActaAccodigoAux,
				actafile.getS3nomfile(), actafile.getS3datafile(),
				actafile.getS3sizefile(), actafile.getS3desfile(),
				actafile.getS3fecha(), actafile.getS3origen(),
				actafile.getS3contenttype(), actafile.getS3codocumento());
		return actafile;
	}

	/**
	 * Finds a single row in the ActaFile table.
	 * 
	 * @param actafile
	 *            Pagination
	 * @return ActaFile
	 */
	@Transactional(readOnly = true)
	public ActaFile find(ActaFile actafile) {
		String query = "SELECT t1.S3CODOCUMENTO S3CODOCUMENTO, t1.S3NOMFILE S3NOMFILE, t1.S3DATAFILE S3DATAFILE, t1.S3SIZEFILE S3SIZEFILE, t1.S3DESFILE S3DESFILE, t1.S3FECHA S3FECHA, t1.S3ORIGEN S3ORIGEN, t1.S3CONTENTTYPE S3CONTENTTYPE, t2.ACCODIGO ACTAACCODIGO, t2.ACCOOR ACTAACCOOR, t2.ACNROR ACTAACNROR, t2.ACNRAN ACTAACNRAN, t2.ACFELE ACTAACFELE, t2.ACFERE ACTAACFERE, t2.ACCOAV ACTAACCOAV, t2.ACCOSE ACTAACCOSE, t2.ACFEEX ACTAACFEEX, t2.ACINRE ACTAACINRE, t2.ACNOCO ACTAACNOCO, t2.ACAPE1CO ACTAACAPE1CO,t2.ACAPE2CO ACTAACAPE2CO, t2.ACDNICO ACTAACDNICO, t2.ACCOCO ACTAACCOCO, t2.ACDIRCO ACTAACDIRCO, t2.ACCOLOCO ACTAACCOLOCO, t2.ACNRCPCO ACTAACNRCPCO, t2.ACNRTFCO ACTAACNRTFCO, t2.ACNORA_PAIS_ID ACTAACNORAPAISID, t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE, t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID, t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA, t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID, t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO, t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID, t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD, t2.ACNORA_CALLE_ID ACTAACNORACALLEID, t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE, t2.ACNORA_CP_ID ACTAACNORACPID, t2.ACNOMBRE_CP ACTAACNOMBRECP, t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID, t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL, t2.ACNOMBRE_PISO ACTAACNOMBREPISO, t2.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV, t2.ACCOINDO ACTAACCOINDO, t2.ACCOINUN ACTAACCOINUN, t2.ACCOTD ACTAACCOTD, t2.ACCOES ACTAACCOES "
				+ "FROM ACTA_FILE t1 , ACTA t2  "
				+ "WHERE t1.S3CODOCUMENTO = ?   AND t1.S3CODACTA= t2.ACCODIGO(+)  ";
		return (ActaFile) this.jdbcTemplate.queryForObject(query, rwMap,
				actafile.getS3codocumento());
	}

	/**
	 * Removes a single row in the ActaFile table.
	 * 
	 * @param actafile
	 *            Pagination
	 * @return
	 */
	public void remove(ActaFile actafile) {
		String query = "DELETE  FROM ACTA_FILE WHERE S3CODOCUMENTO=?";
		this.jdbcTemplate.update(query, actafile.getS3codocumento());
	}

	/**
	 * Finds a List of rows in the ActaFile table.
	 * 
	 * @param actafile
	 *            ActaFile
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaFile> findAll(ActaFile actafile, Pagination pagination) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S3CODACTA= t2.ACCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S3CODOCUMENTO S3CODOCUMENTO,t1.S3NOMFILE S3NOMFILE, t1.S3DATAFILE S3DATAFILE,t1.S3SIZEFILE S3SIZEFILE,t1.S3DESFILE S3DESFILE,t1.S3FECHA S3FECHA,t1.S3ORIGEN S3ORIGEN,t1.S3CONTENTTYPE S3CONTENTTYPE,t2.ACCODIGO ACTAACCODIGO,t2.ACCOOR ACTAACCOOR,t2.ACNROR ACTAACNROR,t2.ACNRAN ACTAACNRAN,t2.ACFELE ACTAACFELE,t2.ACFERE ACTAACFERE,t2.ACCOAV ACTAACCOAV,t2.ACCOSE ACTAACCOSE,t2.ACFEEX ACTAACFEEX,t2.ACINRE ACTAACINRE,t2.ACNOCO ACTAACNOCO,t2.ACAPE1CO ACTAACAPE1CO,t2.ACAPE2CO ACTAACAPE2CO,t2.ACDNICO ACTAACDNICO,t2.ACCOCO ACTAACCOCO,t2.ACDIRCO ACTAACDIRCO,t2.ACCOLOCO ACTAACCOLOCO,t2.ACNRCPCO ACTAACNRCPCO,t2.ACNRTFCO ACTAACNRTFCO,t2.ACNORA_PAIS_ID ACTAACNORAPAISID,t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t2.ACNORA_CALLE_ID ACTAACNORACALLEID,t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t2.ACNORA_CP_ID ACTAACNORACPID,t2.ACNOMBRE_CP ACTAACNOMBRECP,t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t2.ACNOMBRE_PISO ACTAACNOMBREPISO, t2.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV,t2.ACCOINDO ACTAACCOINDO,t2.ACCOINUN ACTAACCOINUN,t2.ACCOTD ACTAACCOTD,t2.ACCOES ACTAACCOES "
						+ "FROM ACTA_FILE t1 ,ACTA t2 ");

		if (actafile != null && actafile.getS3codocumento() != null) {
			where.append(" AND t1.S3CODOCUMENTO = ?");
			params.add(actafile.getS3codocumento());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccodigo() != null) {
			where.append(" AND t2.ACCODIGO = ?");
			params.add(actafile.getActa().getAccodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoindo() != null
				&& actafile.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t2.ACCOINDO = ?");
			params.add(actafile.getActa().getInspectorByAccoindo()
					.getIncodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoinun() != null
				&& actafile.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t2.ACCOINUN = ?");
			params.add(actafile.getActa().getInspectorByAccoinun()
					.getIncodigo());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getTipodoc() != null
				&& actafile.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND t2.ACCOTD = ?");
			params.add(actafile.getActa().getTipodoc().getTdcodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getEstablecimiento() != null
				&& actafile.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ACCOES = ?");
			params.add(actafile.getActa().getEstablecimiento().getEscodigo());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoor() != null) {
			where.append(" AND t2.ACCOOR = ?");
			params.add(actafile.getActa().getAccoor());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnror() != null) {
			where.append(" AND t2.ACNROR = ?");
			params.add(actafile.getActa().getAcnror());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actafile.getActa().getAcnran());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfele() != null) {
			where.append(" AND t2.ACFELE = ?");
			params.add(actafile.getActa().getAcfele());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfere() != null) {
			where.append(" AND t2.ACFERE = ?");
			params.add(actafile.getActa().getAcfere());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoav() != null) {
			where.append(" AND t2.ACCOAV = ?");
			params.add(actafile.getActa().getAccoav());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccose() != null) {
			where.append(" AND t2.ACCOSE = ?");
			params.add(actafile.getActa().getAccose());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfeex() != null) {
			where.append(" AND t2.ACFEEX = ?");
			params.add(actafile.getActa().getAcfeex());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcinre() != null) {
			where.append(" AND t2.ACINRE = ?");
			params.add(actafile.getActa().getAcinre());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoco() != null) {
			where.append(" AND t2.ACNOCO = ?");
			params.add(actafile.getActa().getAcnoco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape1co() != null) {
			where.append(" AND t2.ACAPE1CO = ?");
			params.add(actafile.getActa().getAcape1co());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape2co() != null) {
			where.append(" AND t2.ACAPE2CO = ?");
			params.add(actafile.getActa().getAcape2co());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdnico() != null) {
			where.append(" AND t2.ACDNICO = ?");
			params.add(actafile.getActa().getAcdnico());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoco() != null) {
			where.append(" AND t2.ACCOCO = ?");
			params.add(actafile.getActa().getAccoco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdirco() != null) {
			where.append(" AND t2.ACDIRCO = ?");
			params.add(actafile.getActa().getAcdirco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoloco() != null) {
			where.append(" AND t2.ACCOLOCO = ?");
			params.add(actafile.getActa().getAccoloco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrcpco() != null) {
			where.append(" AND t2.ACNRCPCO = ?");
			params.add(actafile.getActa().getAcnrcpco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrtfco() != null) {
			where.append(" AND t2.ACNRTFCO = ?");
			params.add(actafile.getActa().getAcnrtfco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisId() != null) {
			where.append(" AND t2.ACNORA_PAIS_ID = ?");
			params.add(actafile.getActa().getAcnoraPaisId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND t2.ACNORA_PAIS_NOMBRE = ?");
			params.add(actafile.getActa().getAcnoraPaisNombre());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND t2.ACNORA_PROVINCIA_ID = ?");
			params.add(actafile.getActa().getAcnoraProvinciaId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreProvincia() != null) {
			where.append(" AND t2.ACNOMBRE_PROVINCIA = ?");
			params.add(actafile.getActa().getAcnombreProvincia());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND t2.ACNORA_MUNICIPIO_ID = ?");
			params.add(actafile.getActa().getAcnoraMunicipioId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND t2.ACNOMBRE_MUNICIPIO = ?");
			params.add(actafile.getActa().getAcnombreMunicipio());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND t2.ACNORA_LOCALIDAD_ID = ?");
			params.add(actafile.getActa().getAcnoraLocalidadId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND t2.ACNOMBRE_LOCALIDAD = ?");
			params.add(actafile.getActa().getAcnombreLocalidad());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCalleId() != null) {
			where.append(" AND t2.ACNORA_CALLE_ID = ?");
			params.add(actafile.getActa().getAcnoraCalleId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCalle() != null) {
			where.append(" AND t2.ACNOMBRE_CALLE = ?");
			params.add(actafile.getActa().getAcnombreCalle());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCpId() != null) {
			where.append(" AND t2.ACNORA_CP_ID = ?");
			params.add(actafile.getActa().getAcnoraCpId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCp() != null) {
			where.append(" AND t2.ACNOMBRE_CP = ?");
			params.add(actafile.getActa().getAcnombreCp());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPortalId() != null) {
			where.append(" AND t2.ACNORA_PORTAL_ID = ?");
			params.add(actafile.getActa().getAcnoraPortalId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePortal() != null) {
			where.append(" AND t2.ACNOMBRE_PORTAL = ?");
			params.add(actafile.getActa().getAcnombrePortal());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePiso() != null) {
			where.append(" AND t2.ACNOMBRE_PISO = ?");
			params.add(actafile.getActa().getAcnombrePiso());
		}
		if (actafile != null && actafile.getS3nomfile() != null) {
			where.append(" AND t1.S3NOMFILE = ?");
			params.add(actafile.getS3nomfile());
		}
		if (actafile != null && actafile.getS3sizefile() != null) {
			where.append(" AND t1.S3SIZEFILE = ?");
			params.add(actafile.getS3sizefile());
		}
		if (actafile != null && actafile.getS3desfile() != null) {
			where.append(" AND t1.S3DESFILE = ?");
			params.add(actafile.getS3desfile());
		}
		if (actafile != null && actafile.getS3fecha() != null) {
			where.append(" AND t1.S3FECHA = ?");
			params.add(actafile.getS3fecha());
		}
		if (actafile != null && actafile.getS3origen() != null) {
			where.append(" AND t1.S3ORIGEN = ?");
			params.add(actafile.getS3origen());
		}
		if (actafile != null && actafile.getS3contenttype() != null) {
			where.append(" AND t1.S3CONTENTTYPE = ?");
			params.add(actafile.getS3contenttype());
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ActaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}

	/**
	 * Counts rows in the ActaFile table.
	 * 
	 * @param actafile
	 *            ActaFile
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(ActaFile actafile) {

		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1  and t1.S3CODACTA= t2.ACCODIGO(+) ");

		StringBuffer query = new StringBuffer(
				"SELECT COUNT(1) FROM  ACTA_FILE t1   ,  ACTA t2  ");
		if (actafile != null && actafile.getS3codocumento() != null) {
			where.append(" AND t1.S3CODOCUMENTO = ?");
			params.add(actafile.getS3codocumento());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccodigo() != null) {
			where.append(" AND t2.ACCODIGO = ?");
			params.add(actafile.getActa().getAccodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoindo() != null
				&& actafile.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND t2.ACCOINDO = ?");
			params.add(actafile.getActa().getInspectorByAccoindo()
					.getIncodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoinun() != null
				&& actafile.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND t2.ACCOINUN = ?");
			params.add(actafile.getActa().getInspectorByAccoinun()
					.getIncodigo());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getTipodoc() != null
				&& actafile.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND t2.ACCOTD = ?");
			params.add(actafile.getActa().getTipodoc().getTdcodigo());
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getEstablecimiento() != null
				&& actafile.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND t2.ACCOES = ?");
			params.add(actafile.getActa().getEstablecimiento().getEscodigo());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoor() != null) {
			where.append(" AND t2.ACCOOR = ?");
			params.add(actafile.getActa().getAccoor());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnror() != null) {
			where.append(" AND t2.ACNROR = ?");
			params.add(actafile.getActa().getAcnror());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnran() != null) {
			where.append(" AND t2.ACNRAN = ?");
			params.add(actafile.getActa().getAcnran());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfele() != null) {
			where.append(" AND t2.ACFELE = ?");
			params.add(actafile.getActa().getAcfele());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfere() != null) {
			where.append(" AND t2.ACFERE = ?");
			params.add(actafile.getActa().getAcfere());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoav() != null) {
			where.append(" AND t2.ACCOAV = ?");
			params.add(actafile.getActa().getAccoav());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccose() != null) {
			where.append(" AND t2.ACCOSE = ?");
			params.add(actafile.getActa().getAccose());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfeex() != null) {
			where.append(" AND t2.ACFEEX = ?");
			params.add(actafile.getActa().getAcfeex());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcinre() != null) {
			where.append(" AND t2.ACINRE = ?");
			params.add(actafile.getActa().getAcinre());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoco() != null) {
			where.append(" AND t2.ACNOCO = ?");
			params.add(actafile.getActa().getAcnoco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape1co() != null) {
			where.append(" AND t2.ACAPE1CO = ?");
			params.add(actafile.getActa().getAcape1co());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape2co() != null) {
			where.append(" AND t2.ACAPE2CO = ?");
			params.add(actafile.getActa().getAcape2co());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdnico() != null) {
			where.append(" AND t2.ACDNICO = ?");
			params.add(actafile.getActa().getAcdnico());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoco() != null) {
			where.append(" AND t2.ACCOCO = ?");
			params.add(actafile.getActa().getAccoco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdirco() != null) {
			where.append(" AND t2.ACDIRCO = ?");
			params.add(actafile.getActa().getAcdirco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoloco() != null) {
			where.append(" AND t2.ACCOLOCO = ?");
			params.add(actafile.getActa().getAccoloco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrcpco() != null) {
			where.append(" AND t2.ACNRCPCO = ?");
			params.add(actafile.getActa().getAcnrcpco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrtfco() != null) {
			where.append(" AND t2.ACNRTFCO = ?");
			params.add(actafile.getActa().getAcnrtfco());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisId() != null) {
			where.append(" AND t2.ACNORA_PAIS_ID = ?");
			params.add(actafile.getActa().getAcnoraPaisId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND t2.ACNORA_PAIS_NOMBRE = ?");
			params.add(actafile.getActa().getAcnoraPaisNombre());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND t2.ACNORA_PROVINCIA_ID = ?");
			params.add(actafile.getActa().getAcnoraProvinciaId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreProvincia() != null) {
			where.append(" AND t2.ACNOMBRE_PROVINCIA = ?");
			params.add(actafile.getActa().getAcnombreProvincia());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND t2.ACNORA_MUNICIPIO_ID = ?");
			params.add(actafile.getActa().getAcnoraMunicipioId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND t2.ACNOMBRE_MUNICIPIO = ?");
			params.add(actafile.getActa().getAcnombreMunicipio());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND t2.ACNORA_LOCALIDAD_ID = ?");
			params.add(actafile.getActa().getAcnoraLocalidadId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND t2.ACNOMBRE_LOCALIDAD = ?");
			params.add(actafile.getActa().getAcnombreLocalidad());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCalleId() != null) {
			where.append(" AND t2.ACNORA_CALLE_ID = ?");
			params.add(actafile.getActa().getAcnoraCalleId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCalle() != null) {
			where.append(" AND t2.ACNOMBRE_CALLE = ?");
			params.add(actafile.getActa().getAcnombreCalle());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCpId() != null) {
			where.append(" AND t2.ACNORA_CP_ID = ?");
			params.add(actafile.getActa().getAcnoraCpId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCp() != null) {
			where.append(" AND t2.ACNOMBRE_CP = ?");
			params.add(actafile.getActa().getAcnombreCp());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPortalId() != null) {
			where.append(" AND t2.ACNORA_PORTAL_ID = ?");
			params.add(actafile.getActa().getAcnoraPortalId());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePortal() != null) {
			where.append(" AND t2.ACNOMBRE_PORTAL = ?");
			params.add(actafile.getActa().getAcnombrePortal());
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePiso() != null) {
			where.append(" AND t2.ACNOMBRE_PISO = ?");
			params.add(actafile.getActa().getAcnombrePiso());
		}
		if (actafile != null && actafile.getS3nomfile() != null) {
			where.append(" AND t1.S3NOMFILE = ?");
			params.add(actafile.getS3nomfile());
		}
		if (actafile != null && actafile.getS3sizefile() != null) {
			where.append(" AND t1.S3SIZEFILE = ?");
			params.add(actafile.getS3sizefile());
		}
		if (actafile != null && actafile.getS3desfile() != null) {
			where.append(" AND t1.S3DESFILE = ?");
			params.add(actafile.getS3desfile());
		}
		if (actafile != null && actafile.getS3fecha() != null) {
			where.append(" AND t1.S3FECHA = ?");
			params.add(actafile.getS3fecha());
		}
		if (actafile != null && actafile.getS3origen() != null) {
			where.append(" AND t1.S3ORIGEN = ?");
			params.add(actafile.getS3origen());
		}
		if (actafile != null && actafile.getS3contenttype() != null) {
			where.append(" AND t1.S3CONTENTTYPE = ?");
			params.add(actafile.getS3contenttype());
		}
		query.append(where);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds rows in the ActaFile table using like.
	 * 
	 * @param actafile
	 *            ActaFile
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	@Transactional(readOnly = true)
	public List<ActaFile> findAllLike(ActaFile actafile, Pagination pagination,
			Boolean startsWith) {
		StringBuffer where = new StringBuffer(3000);
		List<Object> params = new ArrayList<Object>();
		where.append(" WHERE 1=1 AND t1.S3CODACTA= t2.ACCODIGO(+) 	");

		StringBuffer query = new StringBuffer(
				"SELECT  t1.S3CODOCUMENTO S3CODOCUMENTO,t1.S3NOMFILE S3NOMFILE,t1.S3DATAFILE S3DATAFILE,t1.S3SIZEFILE S3SIZEFILE,t1.S3DESFILE S3DESFILE,t1.S3FECHA S3FECHA,t1.S3ORIGEN S3ORIGEN,t1.S3CONTENTTYPE S3CONTENTTYPE,t2.ACCODIGO ACTAACCODIGO,t2.ACCOOR ACTAACCOOR,t2.ACNROR ACTAACNROR,t2.ACNRAN ACTAACNRAN,t2.ACFELE ACTAACFELE,t2.ACFERE ACTAACFERE,t2.ACCOAV ACTAACCOAV,t2.ACCOSE ACTAACCOSE,t2.ACFEEX ACTAACFEEX,t2.ACINRE ACTAACINRE,t2.ACNOCO ACTAACNOCO,t2.ACAPE1CO ACTAACAPE1CO,t2.ACAPE2CO ACTAACAPE2CO,t2.ACDNICO ACTAACDNICO,t2.ACCOCO ACTAACCOCO,t2.ACDIRCO ACTAACDIRCO,t2.ACCOLOCO ACTAACCOLOCO,t2.ACNRCPCO ACTAACNRCPCO,t2.ACNRTFCO ACTAACNRTFCO,t2.ACNORA_PAIS_ID ACTAACNORAPAISID,t2.ACNORA_PAIS_NOMBRE ACTAACNORAPAISNOMBRE,t2.ACNORA_PROVINCIA_ID ACTAACNORAPROVINCIAID,t2.ACNOMBRE_PROVINCIA ACTAACNOMBREPROVINCIA,t2.ACNORA_MUNICIPIO_ID ACTAACNORAMUNICIPIOID,t2.ACNOMBRE_MUNICIPIO ACTAACNOMBREMUNICIPIO,t2.ACNORA_LOCALIDAD_ID ACTAACNORALOCALIDADID,t2.ACNOMBRE_LOCALIDAD ACTAACNOMBRELOCALIDAD,t2.ACNORA_CALLE_ID ACTAACNORACALLEID,t2.ACNOMBRE_CALLE ACTAACNOMBRECALLE,t2.ACNORA_CP_ID ACTAACNORACPID,t2.ACNOMBRE_CP ACTAACNOMBRECP,t2.ACNORA_PORTAL_ID ACTAACNORAPORTALID,t2.ACNOMBRE_PORTAL ACTAACNOMBREPORTAL,t2.ACNOMBRE_PISO ACTAACNOMBREPISO, t2.ACDIRECCION_NOCAPV ActaACDIRECCIONNOCAPV,t2.ACCOINDO ACTAACCOINDO,t2.ACCOINUN ACTAACCOINUN,t2.ACCOTD ACTAACCOTD,t2.ACCOES ACTAACCOES "
						+ "FROM ACTA_FILE t1 ,ACTA t2 ");

		if (actafile != null && actafile.getS3codocumento() != null) {
			where.append(" AND UPPER(t1.S3CODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3codocumento().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getS3codocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.S3CODOCUMENTO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccodigo() != null) {
			where.append(" AND t2.ACCODIGO like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccodigo() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccodigo() + "%");
			}
			where.append(" AND t2.ACCODIGO IS NOT NULL");
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoindo() != null
				&& actafile.getActa().getInspectorByAccoindo().getIncodigo() != null) {
			where.append(" AND UPPER(t2.ACCOINDO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getInspectorByAccoindo()
						.getIncodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getInspectorByAccoindo()
								.getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOINDO IS NOT NULL");
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getInspectorByAccoinun() != null
				&& actafile.getActa().getInspectorByAccoinun().getIncodigo() != null) {
			where.append(" AND UPPER(t2.ACCOINUN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getInspectorByAccoinun()
						.getIncodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getInspectorByAccoinun()
								.getIncodigo().toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOINUN IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getTipodoc() != null
				&& actafile.getActa().getTipodoc().getTdcodigo() != null) {
			where.append(" AND UPPER(t2.ACCOTD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getTipodoc().getTdcodigo()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getTipodoc().getTdcodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOTD IS NOT NULL");
		}
		if (actafile != null
				&& actafile.getActa() != null
				&& actafile.getActa().getEstablecimiento() != null
				&& actafile.getActa().getEstablecimiento().getEscodigo() != null) {
			where.append(" AND UPPER(t2.ACCOES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getEstablecimiento()
						.getEscodigo().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getEstablecimiento().getEscodigo()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACCOES IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoor() != null) {
			where.append(" AND UPPER(t2.ACCOOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccoor().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccoor().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACCOOR IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnror() != null) {
			where.append(" AND UPPER(t2.ACNROR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnror().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcnror().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNROR IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnran() != null) {
			where.append(" AND t2.ACNRAN like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnran() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcnran() + "%");
			}
			where.append(" AND t2.ACNRAN IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfele() != null) {
			where.append(" AND t2.ACFELE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcfele() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcfele() + "%");
			}
			where.append(" AND t2.ACFELE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfere() != null) {
			where.append(" AND t2.ACFERE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcfere() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcfere() + "%");
			}
			where.append(" AND t2.ACFERE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoav() != null) {
			where.append(" AND UPPER(t2.ACCOAV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccoav().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccoav().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACCOAV IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccose() != null) {
			where.append(" AND UPPER(t2.ACCOSE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccose().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccose().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACCOSE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcfeex() != null) {
			where.append(" AND t2.ACFEEX like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcfeex() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcfeex() + "%");
			}
			where.append(" AND t2.ACFEEX IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcinre() != null) {
			where.append(" AND UPPER(t2.ACINRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcinre().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcinre().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACINRE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoco() != null) {
			where.append(" AND UPPER(t2.ACNOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcnoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNOCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape1co() != null) {
			where.append(" AND UPPER(t2.ACAPE1CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcape1co().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcape1co().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACAPE1CO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcape2co() != null) {
			where.append(" AND UPPER(t2.ACAPE2CO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcape2co().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcape2co().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACAPE2CO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdnico() != null) {
			where.append(" AND UPPER(t2.ACDNICO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcdnico().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcdnico().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACDNICO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoco() != null) {
			where.append(" AND UPPER(t2.ACCOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccoco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccoco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACCOCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcdirco() != null) {
			where.append(" AND UPPER(t2.ACDIRCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcdirco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcdirco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACDIRCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAccoloco() != null) {
			where.append(" AND UPPER(t2.ACCOLOCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAccoloco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAccoloco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACCOLOCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrcpco() != null) {
			where.append(" AND UPPER(t2.ACNRCPCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnrcpco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcnrcpco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNRCPCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnrtfco() != null) {
			where.append(" AND UPPER(t2.ACNRTFCO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnrtfco().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getActa().getAcnrtfco().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNRTFCO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PAIS_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraPaisId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraPaisId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNORA_PAIS_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPaisNombre() != null) {
			where.append(" AND UPPER(t2.ACNORA_PAIS_NOMBRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraPaisNombre()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraPaisNombre()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PAIS_NOMBRE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraProvinciaId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PROVINCIA_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraProvinciaId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraProvinciaId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_PROVINCIA_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreProvincia() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PROVINCIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombreProvincia()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombreProvincia()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_PROVINCIA IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraMunicipioId() != null) {
			where.append(" AND UPPER(t2.ACNORA_MUNICIPIO_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraMunicipioId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraMunicipioId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_MUNICIPIO_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreMunicipio() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_MUNICIPIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombreMunicipio()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombreMunicipio()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_MUNICIPIO IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraLocalidadId() != null) {
			where.append(" AND UPPER(t2.ACNORA_LOCALIDAD_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraLocalidadId()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraLocalidadId()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNORA_LOCALIDAD_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreLocalidad() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_LOCALIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombreLocalidad()
						.toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombreLocalidad()
								.toUpperCase() + "%");
			}
			where.append(" AND t2.ACNOMBRE_LOCALIDAD IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCalleId() != null) {
			where.append(" AND UPPER(t2.ACNORA_CALLE_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraCalleId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraCalleId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNORA_CALLE_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCalle() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_CALLE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombreCalle().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombreCalle().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNOMBRE_CALLE IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraCpId() != null) {
			where.append(" AND UPPER(t2.ACNORA_CP_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraCpId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraCpId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNORA_CP_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombreCp() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombreCp().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombreCp().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNOMBRE_CP IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnoraPortalId() != null) {
			where.append(" AND UPPER(t2.ACNORA_PORTAL_ID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnoraPortalId().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnoraPortalId().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNORA_PORTAL_ID IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePortal() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PORTAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombrePortal().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombrePortal().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNOMBRE_PORTAL IS NOT NULL");
		}
		if (actafile != null && actafile.getActa() != null
				&& actafile.getActa().getAcnombrePiso() != null) {
			where.append(" AND UPPER(t2.ACNOMBRE_PISO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getActa().getAcnombrePiso().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ actafile.getActa().getAcnombrePiso().toUpperCase()
						+ "%");
			}
			where.append(" AND t2.ACNOMBRE_PISO IS NOT NULL");
		}
		if (actafile != null && actafile.getS3nomfile() != null) {
			where.append(" AND UPPER(t1.S3NOMFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3nomfile().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getS3nomfile().toUpperCase() + "%");
			}
			where.append(" AND t1.S3NOMFILE IS NOT NULL");
		}
		if (actafile != null && actafile.getS3sizefile() != null) {
			where.append(" AND t1.S3SIZEFILE like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3sizefile() + "%");
			} else {
				params.add("%" + actafile.getS3sizefile() + "%");
			}
			where.append(" AND t1.S3SIZEFILE IS NOT NULL");
		}
		if (actafile != null && actafile.getS3desfile() != null) {
			where.append(" AND UPPER(t1.S3DESFILE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3desfile().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getS3desfile().toUpperCase() + "%");
			}
			where.append(" AND t1.S3DESFILE IS NOT NULL");
		}
		if (actafile != null && actafile.getS3fecha() != null) {
			where.append(" AND t1.S3FECHA like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3fecha() + "%");
			} else {
				params.add("%" + actafile.getS3fecha() + "%");
			}
			where.append(" AND t1.S3FECHA IS NOT NULL");
		}
		if (actafile != null && actafile.getS3origen() != null) {
			where.append(" AND UPPER(t1.S3ORIGEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3origen().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getS3origen().toUpperCase() + "%");
			}
			where.append(" AND t1.S3ORIGEN IS NOT NULL");
		}
		if (actafile != null && actafile.getS3contenttype() != null) {
			where.append(" AND UPPER(t1.S3CONTENTTYPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(actafile.getS3contenttype().toUpperCase() + "%");
			} else {
				params.add("%" + actafile.getS3contenttype().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.S3CONTENTTYPE IS NOT NULL");
		}
		query.append(where);

		StringBuffer order = new StringBuffer(3000);
		if (pagination != null) {
			if (pagination.getSort() != null) {
				order.append(" ORDER BY " + pagination.getSort() + " "
						+ pagination.getAscDsc());
				query.append(order);
			}
			query = new StringBuffer(PaginationManager.getQueryLimits(
					pagination, query.toString()));
		}
		return (List<ActaFile>) this.jdbcTemplate.query(query.toString(),
				rwMap, params.toArray());
	}
}
